# GO-FUSE

[![Build Status](https://travis-ci.org/hanwen/go-fuse.svg?branch=master)](https://travis-ci.org/hanwen/go-fuse)
[![GoDoc](https://godoc.org/github.com/hanwen/go-fuse?status.svg)](https://godoc.org/github.com/hanwen/go-fuse)

native bindings for the FUSE kernel module.

## Highlights

* High speed: as fast as libfuse using the gc compiler for single
threaded loads.

* Supports in-process mounting of different FileSystems onto
subdirectories of the FUSE mount.

* Supports 3 interfaces for writing filesystems:
  - `PathFileSystem`: define filesystems in terms path names.
  - `NodeFileSystem`: define filesystems in terms of inodes.
  - `RawFileSystem`: define filesystems in terms of FUSE's raw
  wire protocol.

* Both NodeFileSystem and PathFileSystem support manipulation of true
  hardlinks.

* Includes two fleshed out examples, zipfs and unionfs.


## Examples

* `example/hello/main.go` contains a 60-line "hello world" filesystem

* `zipfs/zipfs.go` contains a small and simple read-only filesystem for
  zip and tar files. The corresponding command is in example/zipfs/
  For example,

  ```shell
  mkdir /tmp/mountpoint
  example/zipfs/zipfs /tmp/mountpoint file.zip &
  ls /tmp/mountpoint
  fusermount -u /tmp/mountpoint
  ````

* `zipfs/multizipfs.go` shows how to use in-process mounts to
  combine multiple Go-FUSE filesystems into a larger filesystem.

* `fuse/loopback.go` mounts another piece of the filesystem.
  Functionally, it is similar to a symlink.  A binary to run is in
  example/loopback/ . For example

  ```shell
  mkdir /tmp/mountpoint
  example/loopback/loopback -debug /tmp/mountpoint /some/other/directory &
  ls /tmp/mountpoint
  fusermount -u /tmp/mountpoint
  ```

* `unionfs/unionfs.go`: implements a union mount using 1 R/W branch, and
  multiple R/O branches.

  ```shell
  mkdir -p  /tmp/mountpoint /tmp/writable
  example/unionfs/unionfs /tmp/mountpoint /tmp/writable /usr &
  ls /tmp/mountpoint
  ls -l /tmp/mountpoint/bin/vi
  rm /tmp/mountpoint/bin/vi
  ls -l /tmp/mountpoint/bin/vi
  cat /tmp/writable/DELETION/*
  ```

* `union/autounionfs.go`: creates UnionFs mounts automatically based on
  existence of READONLY symlinks.


Tested on:

- x86 32bits (Fedora 14).
- x86 64bits (Ubuntu Lucid).


## Benchmarks

We use threaded stats over a read-only filesystem for benchmarking.
Automated code is under benchmark/ directory. A simple C version of
the same FS gives a FUSE baseline

Data points (Go-FUSE version May 2012), 1000 files, high level
interface, all kernel caching turned off, median stat time:

platform                    libfuse     Go-FUSE      difference (%)

Lenovo T60/Fedora16 (1cpu)  349us       355us        2% slower
Lenovo T400/Lucid   (1cpu)  138us       140us        5% slower
Dell T3500/Lucid    (1cpu)   72us        76us        5% slower

On T60, for each file we have
- Client side latency is 360us
- 106us of this is server side latency (4.5x lookup 23us, 1x getattr 4us)
- 16.5us is due to latency measurements.
- 3us is due to garbage collection.

## macOS Support

go-fuse works somewhat on OSX. Known limitations:

* All of the limitations of OSXFUSE, including lack of support for
  NOTIFY.

* OSX issues STATFS calls continuously (leading to performance
  concerns).

* OSX has trouble with concurrent reads from the FUSE device, leading
  to performance concerns.

* Tests are expected to pass; report any failure as a bug!

## Credits

* Inspired by Taru Karttunen's package, https://bitbucket.org/taruti/go-extra.

* Originally based on Ivan Krasin's https://github.com/krasin/go-fuse-zip

## Bugs

Yes, probably.  Report them through
https://github.com/hanwen/go-fuse/issues

## Disclaimer

This is not an official Google product.

## Known Problems

Grep source code for TODO.  Major topics:

* Missing support for network FS file locking: `FUSE_GETLK`, `FUSE_SETLK`,
  `FUSE_SETLKW`

* Missing support for `FUSE_INTERRUPT`, `CUSE`, `BMAP`, `IOCTL`

* In the path API, renames are racy; See also:

    http://sourceforge.net/mailarchive/message.php?msg_id=27550667

  Don't use the path API if you care about correctness.

## License

Like Go, this library is distributed under the new BSD license.  See
accompanying LICENSE file.
