; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --function-signature --check-attributes --check-globals
; RUN: opt -passes=attributor -S %s | FileCheck %s

@var1 = internal global [1 x i32] undef
@var2 = internal global i32 0

;.
; CHECK: @[[VAR1:[a-zA-Z0-9_$"\\.-]+]] = internal global [1 x i32] undef
; CHECK: @[[VAR2:[a-zA-Z0-9_$"\\.-]+]] = internal global i32 0
;.
define ptr addrspace(1) @foo(ptr addrspace(4) %arg) {
; CHECK: Function Attrs: mustprogress nofree norecurse nosync nounwind willreturn memory(none)
; CHECK-LABEL: define {{[^@]+}}@foo
; CHECK-SAME: (ptr addrspace(4) nofree readnone [[ARG:%.*]]) #[[ATTR0:[0-9]+]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = addrspacecast ptr addrspace(4) [[ARG]] to ptr addrspace(1)
; CHECK-NEXT:    ret ptr addrspace(1) [[TMP0]]
;
entry:
  %0 = addrspacecast ptr addrspace(4) %arg to ptr addrspace(1)
  ret ptr addrspace(1) %0
}

define ptr @func1() {
; CHECK: Function Attrs: mustprogress nofree norecurse nosync nounwind willreturn memory(none)
; CHECK-LABEL: define {{[^@]+}}@func1
; CHECK-SAME: () #[[ATTR0]] {
; CHECK-NEXT:    ret ptr @var1
;
  %ptr = call ptr @func1a(ptr @var1)
  ret ptr %ptr
}

define internal ptr @func1a(ptr %arg) {
  ret ptr %arg
}

define internal void @func2a(ptr %0) {
; CHECK: Function Attrs: mustprogress nofree norecurse nosync nounwind willreturn memory(write)
; CHECK-LABEL: define {{[^@]+}}@func2a
; CHECK-SAME: (ptr nocapture nofree nonnull writeonly align 4 dereferenceable(4) [[TMP0:%.*]]) #[[ATTR1:[0-9]+]] {
; CHECK-NEXT:    ret void
;
  store i32 0, ptr %0
  ret void
}

define i32 @func2() {
; CHECK: Function Attrs: mustprogress nofree norecurse nosync nounwind willreturn memory(write)
; CHECK-LABEL: define {{[^@]+}}@func2
; CHECK-SAME: () #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = tail call i32 (ptr, ...) @func2a(ptr nocapture nofree nonnull writeonly align 4 dereferenceable(4) undef) #[[ATTR3:[0-9]+]]
; CHECK-NEXT:    ret i32 0
;
  %1 = tail call i32 (ptr, ...) @func2a(ptr @var2)
  %2 = load i32, ptr @var2
  ret i32 %2
}

define i32 @func3(i1 %false) {
; CHECK: Function Attrs: mustprogress nofree norecurse nosync nounwind willreturn memory(write)
; CHECK-LABEL: define {{[^@]+}}@func3
; CHECK-SAME: (i1 [[FALSE:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = tail call i32 (ptr, ...) @func2a(ptr nocapture nofree nonnull writeonly align 4 dereferenceable(4) undef) #[[ATTR3]]
; CHECK-NEXT:    br i1 [[FALSE]], label [[USE_BB:%.*]], label [[RET_BB:%.*]]
; CHECK:       use_bb:
; CHECK-NEXT:    ret i32 [[TMP1]]
; CHECK:       ret_bb:
; CHECK-NEXT:    ret i32 0
;
  %1 = tail call i32 (ptr, ...) @func2a(ptr @var2)
  br i1 %false, label %use_bb, label %ret_bb
use_bb:
  ret i32 %1
ret_bb:
  %2 = load i32, ptr @var2
  ret i32 %2
}

define void @func4() {
; CHECK-LABEL: define {{[^@]+}}@func4() {
; CHECK-NEXT:    call void @func5()
; CHECK-NEXT:    ret void
;
  call void @func5(i32 0)
  ret void
}

define internal void @func5(i32 %0) {
; CHECK: Function Attrs: memory(readwrite, argmem: none)
; CHECK-LABEL: define {{[^@]+}}@func5
; CHECK-SAME: () #[[ATTR2:[0-9]+]] {
; CHECK-NEXT:    br label [[BLOCK:%.*]]
; CHECK:       block:
; CHECK-NEXT:    call void @func6(ptr blockaddress(@func5, [[BLOCK]]))
; CHECK-NEXT:    ret void
;
  %tmp = alloca ptr
  br label %block

block:
  store ptr blockaddress(@func5, %block), ptr %tmp
  %addr = load ptr, ptr %tmp
  call void @func6(ptr %addr)
  ret void
}

define i16 @foo3() {
; CHECK: Function Attrs: mustprogress nofree norecurse nosync nounwind willreturn memory(none)
; CHECK-LABEL: define {{[^@]+}}@foo3
; CHECK-SAME: () #[[ATTR0]] {
; CHECK-NEXT:    [[CALL:%.*]] = call i16 @bar3() #[[ATTR4:[0-9]+]]
; CHECK-NEXT:    ret i16 [[CALL]]
;
  %call = call i16 @bar3()
  ret i16 %call
}
define internal i16 @bar3(ptr %p1, i16 %p2) {
; CHECK: Function Attrs: mustprogress nofree norecurse nosync nounwind willreturn memory(none)
; CHECK-LABEL: define {{[^@]+}}@bar3
; CHECK-SAME: (ptr nocapture nofree readnone [[P1:%.*]], i16 returned [[P2:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    ret i16 [[P2]]
;
  ret i16 %p2
}

; CHECK-LABEL: declare {{[^@]+}}@func6
; CHECK-SAME: (ptr)
declare void @func6(ptr)
;.
; CHECK: attributes #[[ATTR0]] = { mustprogress nofree norecurse nosync nounwind willreturn memory(none) }
; CHECK: attributes #[[ATTR1]] = { mustprogress nofree norecurse nosync nounwind willreturn memory(write) }
; CHECK: attributes #[[ATTR2]] = { memory(readwrite, argmem: none) }
; CHECK: attributes #[[ATTR3]] = { nofree nosync nounwind willreturn memory(write) }
; CHECK: attributes #[[ATTR4]] = { nofree nosync nounwind willreturn memory(none) }
;.
