// RUN: llvm-mc -triple x86_64-unknown-unknown --show-encoding %s | FileCheck %s

// CHECK: vpaddb %zmm23, %zmm24, %zmm19
// CHECK:  encoding: [0x62,0xa1,0x3d,0x40,0xfc,0xdf]
          vpaddb %zmm23, %zmm24, %zmm19

// CHECK: vpaddb %zmm23, %zmm24, %zmm19 {%k3}
// CHECK:  encoding: [0x62,0xa1,0x3d,0x43,0xfc,0xdf]
          vpaddb %zmm23, %zmm24, %zmm19 {%k3}

// CHECK: vpaddb %zmm23, %zmm24, %zmm19 {%k3} {z}
// CHECK:  encoding: [0x62,0xa1,0x3d,0xc3,0xfc,0xdf]
          vpaddb %zmm23, %zmm24, %zmm19 {%k3} {z}

// CHECK: vpaddb (%rcx), %zmm24, %zmm19
// CHECK:  encoding: [0x62,0xe1,0x3d,0x40,0xfc,0x19]
          vpaddb (%rcx), %zmm24, %zmm19

// CHECK: vpaddb 291(%rax,%r14,8), %zmm24, %zmm19
// CHECK:  encoding: [0x62,0xa1,0x3d,0x40,0xfc,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vpaddb 291(%rax,%r14,8), %zmm24, %zmm19

// CHECK: vpaddb 8128(%rdx), %zmm24, %zmm19
// CHECK:  encoding: [0x62,0xe1,0x3d,0x40,0xfc,0x5a,0x7f]
          vpaddb 8128(%rdx), %zmm24, %zmm19

// CHECK: vpaddb 8192(%rdx), %zmm24, %zmm19
// CHECK:  encoding: [0x62,0xe1,0x3d,0x40,0xfc,0x9a,0x00,0x20,0x00,0x00]
          vpaddb 8192(%rdx), %zmm24, %zmm19

// CHECK: vpaddb -8192(%rdx), %zmm24, %zmm19
// CHECK:  encoding: [0x62,0xe1,0x3d,0x40,0xfc,0x5a,0x80]
          vpaddb -8192(%rdx), %zmm24, %zmm19

// CHECK: vpaddb -8256(%rdx), %zmm24, %zmm19
// CHECK:  encoding: [0x62,0xe1,0x3d,0x40,0xfc,0x9a,0xc0,0xdf,0xff,0xff]
          vpaddb -8256(%rdx), %zmm24, %zmm19

// CHECK: vpaddw %zmm19, %zmm24, %zmm17
// CHECK:  encoding: [0x62,0xa1,0x3d,0x40,0xfd,0xcb]
          vpaddw %zmm19, %zmm24, %zmm17

// CHECK: vpaddw %zmm19, %zmm24, %zmm17 {%k3}
// CHECK:  encoding: [0x62,0xa1,0x3d,0x43,0xfd,0xcb]
          vpaddw %zmm19, %zmm24, %zmm17 {%k3}

// CHECK: vpaddw %zmm19, %zmm24, %zmm17 {%k3} {z}
// CHECK:  encoding: [0x62,0xa1,0x3d,0xc3,0xfd,0xcb]
          vpaddw %zmm19, %zmm24, %zmm17 {%k3} {z}

// CHECK: vpaddw (%rcx), %zmm24, %zmm17
// CHECK:  encoding: [0x62,0xe1,0x3d,0x40,0xfd,0x09]
          vpaddw (%rcx), %zmm24, %zmm17

// CHECK: vpaddw 291(%rax,%r14,8), %zmm24, %zmm17
// CHECK:  encoding: [0x62,0xa1,0x3d,0x40,0xfd,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vpaddw 291(%rax,%r14,8), %zmm24, %zmm17

// CHECK: vpaddw 8128(%rdx), %zmm24, %zmm17
// CHECK:  encoding: [0x62,0xe1,0x3d,0x40,0xfd,0x4a,0x7f]
          vpaddw 8128(%rdx), %zmm24, %zmm17

// CHECK: vpaddw 8192(%rdx), %zmm24, %zmm17
// CHECK:  encoding: [0x62,0xe1,0x3d,0x40,0xfd,0x8a,0x00,0x20,0x00,0x00]
          vpaddw 8192(%rdx), %zmm24, %zmm17

// CHECK: vpaddw -8192(%rdx), %zmm24, %zmm17
// CHECK:  encoding: [0x62,0xe1,0x3d,0x40,0xfd,0x4a,0x80]
          vpaddw -8192(%rdx), %zmm24, %zmm17

// CHECK: vpaddw -8256(%rdx), %zmm24, %zmm17
// CHECK:  encoding: [0x62,0xe1,0x3d,0x40,0xfd,0x8a,0xc0,0xdf,0xff,0xff]
          vpaddw -8256(%rdx), %zmm24, %zmm17

// CHECK: vpbroadcastb %eax, %zmm19
// CHECK:  encoding: [0x62,0xe2,0x7d,0x48,0x7a,0xd8]
          vpbroadcastb %eax, %zmm19

// CHECK: vpbroadcastb %eax, %zmm19 {%k7}
// CHECK:  encoding: [0x62,0xe2,0x7d,0x4f,0x7a,0xd8]
          vpbroadcastb %eax, %zmm19 {%k7}

// CHECK: vpbroadcastb %eax, %zmm19 {%k7} {z}
// CHECK:  encoding: [0x62,0xe2,0x7d,0xcf,0x7a,0xd8]
          vpbroadcastb %eax, %zmm19 {%k7} {z}

// CHECK: vpbroadcastw %eax, %zmm24
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x7b,0xc0]
          vpbroadcastw %eax, %zmm24

// CHECK: vpbroadcastw %eax, %zmm24 {%k1}
// CHECK:  encoding: [0x62,0x62,0x7d,0x49,0x7b,0xc0]
          vpbroadcastw %eax, %zmm24 {%k1}

// CHECK: vpbroadcastw %eax, %zmm24 {%k1} {z}
// CHECK:  encoding: [0x62,0x62,0x7d,0xc9,0x7b,0xc0]
          vpbroadcastw %eax, %zmm24 {%k1} {z}
// CHECK: vpcmpeqb %zmm26, %zmm26, %k4
// CHECK:  encoding: [0x62,0x91,0x2d,0x40,0x74,0xe2]
          vpcmpeqb %zmm26, %zmm26, %k4

// CHECK: vpcmpeqb %zmm26, %zmm26, %k4 {%k6}
// CHECK:  encoding: [0x62,0x91,0x2d,0x46,0x74,0xe2]
          vpcmpeqb %zmm26, %zmm26, %k4 {%k6}

// CHECK: vpcmpeqb (%rcx), %zmm26, %k4
// CHECK:  encoding: [0x62,0xf1,0x2d,0x40,0x74,0x21]
          vpcmpeqb (%rcx), %zmm26, %k4

// CHECK: vpcmpeqb 291(%rax,%r14,8), %zmm26, %k4
// CHECK:  encoding: [0x62,0xb1,0x2d,0x40,0x74,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vpcmpeqb 291(%rax,%r14,8), %zmm26, %k4

// CHECK: vpcmpeqb 8128(%rdx), %zmm26, %k4
// CHECK:  encoding: [0x62,0xf1,0x2d,0x40,0x74,0x62,0x7f]
          vpcmpeqb 8128(%rdx), %zmm26, %k4

// CHECK: vpcmpeqb 8192(%rdx), %zmm26, %k4
// CHECK:  encoding: [0x62,0xf1,0x2d,0x40,0x74,0xa2,0x00,0x20,0x00,0x00]
          vpcmpeqb 8192(%rdx), %zmm26, %k4

// CHECK: vpcmpeqb -8192(%rdx), %zmm26, %k4
// CHECK:  encoding: [0x62,0xf1,0x2d,0x40,0x74,0x62,0x80]
          vpcmpeqb -8192(%rdx), %zmm26, %k4

// CHECK: vpcmpeqb -8256(%rdx), %zmm26, %k4
// CHECK:  encoding: [0x62,0xf1,0x2d,0x40,0x74,0xa2,0xc0,0xdf,0xff,0xff]
          vpcmpeqb -8256(%rdx), %zmm26, %k4

// CHECK: vpcmpeqw %zmm19, %zmm23, %k5
// CHECK:  encoding: [0x62,0xb1,0x45,0x40,0x75,0xeb]
          vpcmpeqw %zmm19, %zmm23, %k5

// CHECK: vpcmpeqw %zmm19, %zmm23, %k5 {%k7}
// CHECK:  encoding: [0x62,0xb1,0x45,0x47,0x75,0xeb]
          vpcmpeqw %zmm19, %zmm23, %k5 {%k7}

// CHECK: vpcmpeqw (%rcx), %zmm23, %k5
// CHECK:  encoding: [0x62,0xf1,0x45,0x40,0x75,0x29]
          vpcmpeqw (%rcx), %zmm23, %k5

// CHECK: vpcmpeqw 291(%rax,%r14,8), %zmm23, %k5
// CHECK:  encoding: [0x62,0xb1,0x45,0x40,0x75,0xac,0xf0,0x23,0x01,0x00,0x00]
          vpcmpeqw 291(%rax,%r14,8), %zmm23, %k5

// CHECK: vpcmpeqw 8128(%rdx), %zmm23, %k5
// CHECK:  encoding: [0x62,0xf1,0x45,0x40,0x75,0x6a,0x7f]
          vpcmpeqw 8128(%rdx), %zmm23, %k5

// CHECK: vpcmpeqw 8192(%rdx), %zmm23, %k5
// CHECK:  encoding: [0x62,0xf1,0x45,0x40,0x75,0xaa,0x00,0x20,0x00,0x00]
          vpcmpeqw 8192(%rdx), %zmm23, %k5

// CHECK: vpcmpeqw -8192(%rdx), %zmm23, %k5
// CHECK:  encoding: [0x62,0xf1,0x45,0x40,0x75,0x6a,0x80]
          vpcmpeqw -8192(%rdx), %zmm23, %k5

// CHECK: vpcmpeqw -8256(%rdx), %zmm23, %k5
// CHECK:  encoding: [0x62,0xf1,0x45,0x40,0x75,0xaa,0xc0,0xdf,0xff,0xff]
          vpcmpeqw -8256(%rdx), %zmm23, %k5

// CHECK: vpcmpgtb %zmm20, %zmm30, %k4
// CHECK:  encoding: [0x62,0xb1,0x0d,0x40,0x64,0xe4]
          vpcmpgtb %zmm20, %zmm30, %k4

// CHECK: vpcmpgtb %zmm20, %zmm30, %k4 {%k1}
// CHECK:  encoding: [0x62,0xb1,0x0d,0x41,0x64,0xe4]
          vpcmpgtb %zmm20, %zmm30, %k4 {%k1}

// CHECK: vpcmpgtb (%rcx), %zmm30, %k4
// CHECK:  encoding: [0x62,0xf1,0x0d,0x40,0x64,0x21]
          vpcmpgtb (%rcx), %zmm30, %k4

// CHECK: vpcmpgtb 291(%rax,%r14,8), %zmm30, %k4
// CHECK:  encoding: [0x62,0xb1,0x0d,0x40,0x64,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vpcmpgtb 291(%rax,%r14,8), %zmm30, %k4

// CHECK: vpcmpgtb 8128(%rdx), %zmm30, %k4
// CHECK:  encoding: [0x62,0xf1,0x0d,0x40,0x64,0x62,0x7f]
          vpcmpgtb 8128(%rdx), %zmm30, %k4

// CHECK: vpcmpgtb 8192(%rdx), %zmm30, %k4
// CHECK:  encoding: [0x62,0xf1,0x0d,0x40,0x64,0xa2,0x00,0x20,0x00,0x00]
          vpcmpgtb 8192(%rdx), %zmm30, %k4

// CHECK: vpcmpgtb -8192(%rdx), %zmm30, %k4
// CHECK:  encoding: [0x62,0xf1,0x0d,0x40,0x64,0x62,0x80]
          vpcmpgtb -8192(%rdx), %zmm30, %k4

// CHECK: vpcmpgtb -8256(%rdx), %zmm30, %k4
// CHECK:  encoding: [0x62,0xf1,0x0d,0x40,0x64,0xa2,0xc0,0xdf,0xff,0xff]
          vpcmpgtb -8256(%rdx), %zmm30, %k4

// CHECK: vpcmpgtw %zmm21, %zmm23, %k5
// CHECK:  encoding: [0x62,0xb1,0x45,0x40,0x65,0xed]
          vpcmpgtw %zmm21, %zmm23, %k5

// CHECK: vpcmpgtw %zmm21, %zmm23, %k5 {%k7}
// CHECK:  encoding: [0x62,0xb1,0x45,0x47,0x65,0xed]
          vpcmpgtw %zmm21, %zmm23, %k5 {%k7}

// CHECK: vpcmpgtw (%rcx), %zmm23, %k5
// CHECK:  encoding: [0x62,0xf1,0x45,0x40,0x65,0x29]
          vpcmpgtw (%rcx), %zmm23, %k5

// CHECK: vpcmpgtw 291(%rax,%r14,8), %zmm23, %k5
// CHECK:  encoding: [0x62,0xb1,0x45,0x40,0x65,0xac,0xf0,0x23,0x01,0x00,0x00]
          vpcmpgtw 291(%rax,%r14,8), %zmm23, %k5

// CHECK: vpcmpgtw 8128(%rdx), %zmm23, %k5
// CHECK:  encoding: [0x62,0xf1,0x45,0x40,0x65,0x6a,0x7f]
          vpcmpgtw 8128(%rdx), %zmm23, %k5

// CHECK: vpcmpgtw 8192(%rdx), %zmm23, %k5
// CHECK:  encoding: [0x62,0xf1,0x45,0x40,0x65,0xaa,0x00,0x20,0x00,0x00]
          vpcmpgtw 8192(%rdx), %zmm23, %k5

// CHECK: vpcmpgtw -8192(%rdx), %zmm23, %k5
// CHECK:  encoding: [0x62,0xf1,0x45,0x40,0x65,0x6a,0x80]
          vpcmpgtw -8192(%rdx), %zmm23, %k5

// CHECK: vpcmpgtw -8256(%rdx), %zmm23, %k5
// CHECK:  encoding: [0x62,0xf1,0x45,0x40,0x65,0xaa,0xc0,0xdf,0xff,0xff]
          vpcmpgtw -8256(%rdx), %zmm23, %k5

// CHECK: vpmaxsb %zmm26, %zmm29, %zmm23
// CHECK:  encoding: [0x62,0x82,0x15,0x40,0x3c,0xfa]
          vpmaxsb %zmm26, %zmm29, %zmm23

// CHECK: vpmaxsb %zmm26, %zmm29, %zmm23 {%k4}
// CHECK:  encoding: [0x62,0x82,0x15,0x44,0x3c,0xfa]
          vpmaxsb %zmm26, %zmm29, %zmm23 {%k4}

// CHECK: vpmaxsb %zmm26, %zmm29, %zmm23 {%k4} {z}
// CHECK:  encoding: [0x62,0x82,0x15,0xc4,0x3c,0xfa]
          vpmaxsb %zmm26, %zmm29, %zmm23 {%k4} {z}

// CHECK: vpmaxsb (%rcx), %zmm29, %zmm23
// CHECK:  encoding: [0x62,0xe2,0x15,0x40,0x3c,0x39]
          vpmaxsb (%rcx), %zmm29, %zmm23

// CHECK: vpmaxsb 291(%rax,%r14,8), %zmm29, %zmm23
// CHECK:  encoding: [0x62,0xa2,0x15,0x40,0x3c,0xbc,0xf0,0x23,0x01,0x00,0x00]
          vpmaxsb 291(%rax,%r14,8), %zmm29, %zmm23

// CHECK: vpmaxsb 8128(%rdx), %zmm29, %zmm23
// CHECK:  encoding: [0x62,0xe2,0x15,0x40,0x3c,0x7a,0x7f]
          vpmaxsb 8128(%rdx), %zmm29, %zmm23

// CHECK: vpmaxsb 8192(%rdx), %zmm29, %zmm23
// CHECK:  encoding: [0x62,0xe2,0x15,0x40,0x3c,0xba,0x00,0x20,0x00,0x00]
          vpmaxsb 8192(%rdx), %zmm29, %zmm23

// CHECK: vpmaxsb -8192(%rdx), %zmm29, %zmm23
// CHECK:  encoding: [0x62,0xe2,0x15,0x40,0x3c,0x7a,0x80]
          vpmaxsb -8192(%rdx), %zmm29, %zmm23

// CHECK: vpmaxsb -8256(%rdx), %zmm29, %zmm23
// CHECK:  encoding: [0x62,0xe2,0x15,0x40,0x3c,0xba,0xc0,0xdf,0xff,0xff]
          vpmaxsb -8256(%rdx), %zmm29, %zmm23

// CHECK: vpmaxsw %zmm25, %zmm28, %zmm25
// CHECK:  encoding: [0x62,0x01,0x1d,0x40,0xee,0xc9]
          vpmaxsw %zmm25, %zmm28, %zmm25

// CHECK: vpmaxsw %zmm25, %zmm28, %zmm25 {%k3}
// CHECK:  encoding: [0x62,0x01,0x1d,0x43,0xee,0xc9]
          vpmaxsw %zmm25, %zmm28, %zmm25 {%k3}

// CHECK: vpmaxsw %zmm25, %zmm28, %zmm25 {%k3} {z}
// CHECK:  encoding: [0x62,0x01,0x1d,0xc3,0xee,0xc9]
          vpmaxsw %zmm25, %zmm28, %zmm25 {%k3} {z}

// CHECK: vpmaxsw (%rcx), %zmm28, %zmm25
// CHECK:  encoding: [0x62,0x61,0x1d,0x40,0xee,0x09]
          vpmaxsw (%rcx), %zmm28, %zmm25

// CHECK: vpmaxsw 291(%rax,%r14,8), %zmm28, %zmm25
// CHECK:  encoding: [0x62,0x21,0x1d,0x40,0xee,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vpmaxsw 291(%rax,%r14,8), %zmm28, %zmm25

// CHECK: vpmaxsw 8128(%rdx), %zmm28, %zmm25
// CHECK:  encoding: [0x62,0x61,0x1d,0x40,0xee,0x4a,0x7f]
          vpmaxsw 8128(%rdx), %zmm28, %zmm25

// CHECK: vpmaxsw 8192(%rdx), %zmm28, %zmm25
// CHECK:  encoding: [0x62,0x61,0x1d,0x40,0xee,0x8a,0x00,0x20,0x00,0x00]
          vpmaxsw 8192(%rdx), %zmm28, %zmm25

// CHECK: vpmaxsw -8192(%rdx), %zmm28, %zmm25
// CHECK:  encoding: [0x62,0x61,0x1d,0x40,0xee,0x4a,0x80]
          vpmaxsw -8192(%rdx), %zmm28, %zmm25

// CHECK: vpmaxsw -8256(%rdx), %zmm28, %zmm25
// CHECK:  encoding: [0x62,0x61,0x1d,0x40,0xee,0x8a,0xc0,0xdf,0xff,0xff]
          vpmaxsw -8256(%rdx), %zmm28, %zmm25

// CHECK: vpmaxub %zmm25, %zmm18, %zmm29
// CHECK:  encoding: [0x62,0x01,0x6d,0x40,0xde,0xe9]
          vpmaxub %zmm25, %zmm18, %zmm29

// CHECK: vpmaxub %zmm25, %zmm18, %zmm29 {%k7}
// CHECK:  encoding: [0x62,0x01,0x6d,0x47,0xde,0xe9]
          vpmaxub %zmm25, %zmm18, %zmm29 {%k7}

// CHECK: vpmaxub %zmm25, %zmm18, %zmm29 {%k7} {z}
// CHECK:  encoding: [0x62,0x01,0x6d,0xc7,0xde,0xe9]
          vpmaxub %zmm25, %zmm18, %zmm29 {%k7} {z}

// CHECK: vpmaxub (%rcx), %zmm18, %zmm29
// CHECK:  encoding: [0x62,0x61,0x6d,0x40,0xde,0x29]
          vpmaxub (%rcx), %zmm18, %zmm29

// CHECK: vpmaxub 291(%rax,%r14,8), %zmm18, %zmm29
// CHECK:  encoding: [0x62,0x21,0x6d,0x40,0xde,0xac,0xf0,0x23,0x01,0x00,0x00]
          vpmaxub 291(%rax,%r14,8), %zmm18, %zmm29

// CHECK: vpmaxub 8128(%rdx), %zmm18, %zmm29
// CHECK:  encoding: [0x62,0x61,0x6d,0x40,0xde,0x6a,0x7f]
          vpmaxub 8128(%rdx), %zmm18, %zmm29

// CHECK: vpmaxub 8192(%rdx), %zmm18, %zmm29
// CHECK:  encoding: [0x62,0x61,0x6d,0x40,0xde,0xaa,0x00,0x20,0x00,0x00]
          vpmaxub 8192(%rdx), %zmm18, %zmm29

// CHECK: vpmaxub -8192(%rdx), %zmm18, %zmm29
// CHECK:  encoding: [0x62,0x61,0x6d,0x40,0xde,0x6a,0x80]
          vpmaxub -8192(%rdx), %zmm18, %zmm29

// CHECK: vpmaxub -8256(%rdx), %zmm18, %zmm29
// CHECK:  encoding: [0x62,0x61,0x6d,0x40,0xde,0xaa,0xc0,0xdf,0xff,0xff]
          vpmaxub -8256(%rdx), %zmm18, %zmm29

// CHECK: vpmaxuw %zmm23, %zmm27, %zmm21
// CHECK:  encoding: [0x62,0xa2,0x25,0x40,0x3e,0xef]
          vpmaxuw %zmm23, %zmm27, %zmm21

// CHECK: vpmaxuw %zmm23, %zmm27, %zmm21 {%k3}
// CHECK:  encoding: [0x62,0xa2,0x25,0x43,0x3e,0xef]
          vpmaxuw %zmm23, %zmm27, %zmm21 {%k3}

// CHECK: vpmaxuw %zmm23, %zmm27, %zmm21 {%k3} {z}
// CHECK:  encoding: [0x62,0xa2,0x25,0xc3,0x3e,0xef]
          vpmaxuw %zmm23, %zmm27, %zmm21 {%k3} {z}

// CHECK: vpmaxuw (%rcx), %zmm27, %zmm21
// CHECK:  encoding: [0x62,0xe2,0x25,0x40,0x3e,0x29]
          vpmaxuw (%rcx), %zmm27, %zmm21

// CHECK: vpmaxuw 291(%rax,%r14,8), %zmm27, %zmm21
// CHECK:  encoding: [0x62,0xa2,0x25,0x40,0x3e,0xac,0xf0,0x23,0x01,0x00,0x00]
          vpmaxuw 291(%rax,%r14,8), %zmm27, %zmm21

// CHECK: vpmaxuw 8128(%rdx), %zmm27, %zmm21
// CHECK:  encoding: [0x62,0xe2,0x25,0x40,0x3e,0x6a,0x7f]
          vpmaxuw 8128(%rdx), %zmm27, %zmm21

// CHECK: vpmaxuw 8192(%rdx), %zmm27, %zmm21
// CHECK:  encoding: [0x62,0xe2,0x25,0x40,0x3e,0xaa,0x00,0x20,0x00,0x00]
          vpmaxuw 8192(%rdx), %zmm27, %zmm21

// CHECK: vpmaxuw -8192(%rdx), %zmm27, %zmm21
// CHECK:  encoding: [0x62,0xe2,0x25,0x40,0x3e,0x6a,0x80]
          vpmaxuw -8192(%rdx), %zmm27, %zmm21

// CHECK: vpmaxuw -8256(%rdx), %zmm27, %zmm21
// CHECK:  encoding: [0x62,0xe2,0x25,0x40,0x3e,0xaa,0xc0,0xdf,0xff,0xff]
          vpmaxuw -8256(%rdx), %zmm27, %zmm21

// CHECK: vpminsb %zmm25, %zmm22, %zmm28
// CHECK:  encoding: [0x62,0x02,0x4d,0x40,0x38,0xe1]
          vpminsb %zmm25, %zmm22, %zmm28

// CHECK: vpminsb %zmm25, %zmm22, %zmm28 {%k6}
// CHECK:  encoding: [0x62,0x02,0x4d,0x46,0x38,0xe1]
          vpminsb %zmm25, %zmm22, %zmm28 {%k6}

// CHECK: vpminsb %zmm25, %zmm22, %zmm28 {%k6} {z}
// CHECK:  encoding: [0x62,0x02,0x4d,0xc6,0x38,0xe1]
          vpminsb %zmm25, %zmm22, %zmm28 {%k6} {z}

// CHECK: vpminsb (%rcx), %zmm22, %zmm28
// CHECK:  encoding: [0x62,0x62,0x4d,0x40,0x38,0x21]
          vpminsb (%rcx), %zmm22, %zmm28

// CHECK: vpminsb 291(%rax,%r14,8), %zmm22, %zmm28
// CHECK:  encoding: [0x62,0x22,0x4d,0x40,0x38,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vpminsb 291(%rax,%r14,8), %zmm22, %zmm28

// CHECK: vpminsb 8128(%rdx), %zmm22, %zmm28
// CHECK:  encoding: [0x62,0x62,0x4d,0x40,0x38,0x62,0x7f]
          vpminsb 8128(%rdx), %zmm22, %zmm28

// CHECK: vpminsb 8192(%rdx), %zmm22, %zmm28
// CHECK:  encoding: [0x62,0x62,0x4d,0x40,0x38,0xa2,0x00,0x20,0x00,0x00]
          vpminsb 8192(%rdx), %zmm22, %zmm28

// CHECK: vpminsb -8192(%rdx), %zmm22, %zmm28
// CHECK:  encoding: [0x62,0x62,0x4d,0x40,0x38,0x62,0x80]
          vpminsb -8192(%rdx), %zmm22, %zmm28

// CHECK: vpminsb -8256(%rdx), %zmm22, %zmm28
// CHECK:  encoding: [0x62,0x62,0x4d,0x40,0x38,0xa2,0xc0,0xdf,0xff,0xff]
          vpminsb -8256(%rdx), %zmm22, %zmm28

// CHECK: vpminsw %zmm25, %zmm22, %zmm27
// CHECK:  encoding: [0x62,0x01,0x4d,0x40,0xea,0xd9]
          vpminsw %zmm25, %zmm22, %zmm27

// CHECK: vpminsw %zmm25, %zmm22, %zmm27 {%k6}
// CHECK:  encoding: [0x62,0x01,0x4d,0x46,0xea,0xd9]
          vpminsw %zmm25, %zmm22, %zmm27 {%k6}

// CHECK: vpminsw %zmm25, %zmm22, %zmm27 {%k6} {z}
// CHECK:  encoding: [0x62,0x01,0x4d,0xc6,0xea,0xd9]
          vpminsw %zmm25, %zmm22, %zmm27 {%k6} {z}

// CHECK: vpminsw (%rcx), %zmm22, %zmm27
// CHECK:  encoding: [0x62,0x61,0x4d,0x40,0xea,0x19]
          vpminsw (%rcx), %zmm22, %zmm27

// CHECK: vpminsw 291(%rax,%r14,8), %zmm22, %zmm27
// CHECK:  encoding: [0x62,0x21,0x4d,0x40,0xea,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vpminsw 291(%rax,%r14,8), %zmm22, %zmm27

// CHECK: vpminsw 8128(%rdx), %zmm22, %zmm27
// CHECK:  encoding: [0x62,0x61,0x4d,0x40,0xea,0x5a,0x7f]
          vpminsw 8128(%rdx), %zmm22, %zmm27

// CHECK: vpminsw 8192(%rdx), %zmm22, %zmm27
// CHECK:  encoding: [0x62,0x61,0x4d,0x40,0xea,0x9a,0x00,0x20,0x00,0x00]
          vpminsw 8192(%rdx), %zmm22, %zmm27

// CHECK: vpminsw -8192(%rdx), %zmm22, %zmm27
// CHECK:  encoding: [0x62,0x61,0x4d,0x40,0xea,0x5a,0x80]
          vpminsw -8192(%rdx), %zmm22, %zmm27

// CHECK: vpminsw -8256(%rdx), %zmm22, %zmm27
// CHECK:  encoding: [0x62,0x61,0x4d,0x40,0xea,0x9a,0xc0,0xdf,0xff,0xff]
          vpminsw -8256(%rdx), %zmm22, %zmm27

// CHECK: vpminub %zmm26, %zmm25, %zmm25
// CHECK:  encoding: [0x62,0x01,0x35,0x40,0xda,0xca]
          vpminub %zmm26, %zmm25, %zmm25

// CHECK: vpminub %zmm26, %zmm25, %zmm25 {%k6}
// CHECK:  encoding: [0x62,0x01,0x35,0x46,0xda,0xca]
          vpminub %zmm26, %zmm25, %zmm25 {%k6}

// CHECK: vpminub %zmm26, %zmm25, %zmm25 {%k6} {z}
// CHECK:  encoding: [0x62,0x01,0x35,0xc6,0xda,0xca]
          vpminub %zmm26, %zmm25, %zmm25 {%k6} {z}

// CHECK: vpminub (%rcx), %zmm25, %zmm25
// CHECK:  encoding: [0x62,0x61,0x35,0x40,0xda,0x09]
          vpminub (%rcx), %zmm25, %zmm25

// CHECK: vpminub 291(%rax,%r14,8), %zmm25, %zmm25
// CHECK:  encoding: [0x62,0x21,0x35,0x40,0xda,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vpminub 291(%rax,%r14,8), %zmm25, %zmm25

// CHECK: vpminub 8128(%rdx), %zmm25, %zmm25
// CHECK:  encoding: [0x62,0x61,0x35,0x40,0xda,0x4a,0x7f]
          vpminub 8128(%rdx), %zmm25, %zmm25

// CHECK: vpminub 8192(%rdx), %zmm25, %zmm25
// CHECK:  encoding: [0x62,0x61,0x35,0x40,0xda,0x8a,0x00,0x20,0x00,0x00]
          vpminub 8192(%rdx), %zmm25, %zmm25

// CHECK: vpminub -8192(%rdx), %zmm25, %zmm25
// CHECK:  encoding: [0x62,0x61,0x35,0x40,0xda,0x4a,0x80]
          vpminub -8192(%rdx), %zmm25, %zmm25

// CHECK: vpminub -8256(%rdx), %zmm25, %zmm25
// CHECK:  encoding: [0x62,0x61,0x35,0x40,0xda,0x8a,0xc0,0xdf,0xff,0xff]
          vpminub -8256(%rdx), %zmm25, %zmm25

// CHECK: vpminuw %zmm20, %zmm29, %zmm19
// CHECK:  encoding: [0x62,0xa2,0x15,0x40,0x3a,0xdc]
          vpminuw %zmm20, %zmm29, %zmm19

// CHECK: vpminuw %zmm20, %zmm29, %zmm19 {%k7}
// CHECK:  encoding: [0x62,0xa2,0x15,0x47,0x3a,0xdc]
          vpminuw %zmm20, %zmm29, %zmm19 {%k7}

// CHECK: vpminuw %zmm20, %zmm29, %zmm19 {%k7} {z}
// CHECK:  encoding: [0x62,0xa2,0x15,0xc7,0x3a,0xdc]
          vpminuw %zmm20, %zmm29, %zmm19 {%k7} {z}

// CHECK: vpminuw (%rcx), %zmm29, %zmm19
// CHECK:  encoding: [0x62,0xe2,0x15,0x40,0x3a,0x19]
          vpminuw (%rcx), %zmm29, %zmm19

// CHECK: vpminuw 291(%rax,%r14,8), %zmm29, %zmm19
// CHECK:  encoding: [0x62,0xa2,0x15,0x40,0x3a,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vpminuw 291(%rax,%r14,8), %zmm29, %zmm19

// CHECK: vpminuw 8128(%rdx), %zmm29, %zmm19
// CHECK:  encoding: [0x62,0xe2,0x15,0x40,0x3a,0x5a,0x7f]
          vpminuw 8128(%rdx), %zmm29, %zmm19

// CHECK: vpminuw 8192(%rdx), %zmm29, %zmm19
// CHECK:  encoding: [0x62,0xe2,0x15,0x40,0x3a,0x9a,0x00,0x20,0x00,0x00]
          vpminuw 8192(%rdx), %zmm29, %zmm19

// CHECK: vpminuw -8192(%rdx), %zmm29, %zmm19
// CHECK:  encoding: [0x62,0xe2,0x15,0x40,0x3a,0x5a,0x80]
          vpminuw -8192(%rdx), %zmm29, %zmm19

// CHECK: vpminuw -8256(%rdx), %zmm29, %zmm19
// CHECK:  encoding: [0x62,0xe2,0x15,0x40,0x3a,0x9a,0xc0,0xdf,0xff,0xff]
          vpminuw -8256(%rdx), %zmm29, %zmm19

// CHECK: vpmovsxbw %ymm18, %zmm22
// CHECK:  encoding: [0x62,0xa2,0x7d,0x48,0x20,0xf2]
          vpmovsxbw %ymm18, %zmm22

// CHECK: vpmovsxbw %ymm18, %zmm22 {%k5}
// CHECK:  encoding: [0x62,0xa2,0x7d,0x4d,0x20,0xf2]
          vpmovsxbw %ymm18, %zmm22 {%k5}

// CHECK: vpmovsxbw %ymm18, %zmm22 {%k5} {z}
// CHECK:  encoding: [0x62,0xa2,0x7d,0xcd,0x20,0xf2]
          vpmovsxbw %ymm18, %zmm22 {%k5} {z}

// CHECK: vpmovsxbw (%rcx), %zmm22
// CHECK:  encoding: [0x62,0xe2,0x7d,0x48,0x20,0x31]
          vpmovsxbw (%rcx), %zmm22

// CHECK: vpmovsxbw 291(%rax,%r14,8), %zmm22
// CHECK:  encoding: [0x62,0xa2,0x7d,0x48,0x20,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vpmovsxbw 291(%rax,%r14,8), %zmm22

// CHECK: vpmovsxbw 4064(%rdx), %zmm22
// CHECK:  encoding: [0x62,0xe2,0x7d,0x48,0x20,0x72,0x7f]
          vpmovsxbw 4064(%rdx), %zmm22

// CHECK: vpmovsxbw 4096(%rdx), %zmm22
// CHECK:  encoding: [0x62,0xe2,0x7d,0x48,0x20,0xb2,0x00,0x10,0x00,0x00]
          vpmovsxbw 4096(%rdx), %zmm22

// CHECK: vpmovsxbw -4096(%rdx), %zmm22
// CHECK:  encoding: [0x62,0xe2,0x7d,0x48,0x20,0x72,0x80]
          vpmovsxbw -4096(%rdx), %zmm22

// CHECK: vpmovsxbw -4128(%rdx), %zmm22
// CHECK:  encoding: [0x62,0xe2,0x7d,0x48,0x20,0xb2,0xe0,0xef,0xff,0xff]
          vpmovsxbw -4128(%rdx), %zmm22

// CHECK: vpmovzxbw %ymm26, %zmm24
// CHECK:  encoding: [0x62,0x02,0x7d,0x48,0x30,0xc2]
          vpmovzxbw %ymm26, %zmm24

// CHECK: vpmovzxbw %ymm26, %zmm24 {%k4}
// CHECK:  encoding: [0x62,0x02,0x7d,0x4c,0x30,0xc2]
          vpmovzxbw %ymm26, %zmm24 {%k4}

// CHECK: vpmovzxbw %ymm26, %zmm24 {%k4} {z}
// CHECK:  encoding: [0x62,0x02,0x7d,0xcc,0x30,0xc2]
          vpmovzxbw %ymm26, %zmm24 {%k4} {z}

// CHECK: vpmovzxbw (%rcx), %zmm24
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x30,0x01]
          vpmovzxbw (%rcx), %zmm24

// CHECK: vpmovzxbw 291(%rax,%r14,8), %zmm24
// CHECK:  encoding: [0x62,0x22,0x7d,0x48,0x30,0x84,0xf0,0x23,0x01,0x00,0x00]
          vpmovzxbw 291(%rax,%r14,8), %zmm24

// CHECK: vpmovzxbw 4064(%rdx), %zmm24
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x30,0x42,0x7f]
          vpmovzxbw 4064(%rdx), %zmm24

// CHECK: vpmovzxbw 4096(%rdx), %zmm24
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x30,0x82,0x00,0x10,0x00,0x00]
          vpmovzxbw 4096(%rdx), %zmm24

// CHECK: vpmovzxbw -4096(%rdx), %zmm24
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x30,0x42,0x80]
          vpmovzxbw -4096(%rdx), %zmm24

// CHECK: vpmovzxbw -4128(%rdx), %zmm24
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x30,0x82,0xe0,0xef,0xff,0xff]
          vpmovzxbw -4128(%rdx), %zmm24

// CHECK: vpmullw %zmm19, %zmm28, %zmm19
// CHECK:  encoding: [0x62,0xa1,0x1d,0x40,0xd5,0xdb]
          vpmullw %zmm19, %zmm28, %zmm19

// CHECK: vpmullw %zmm19, %zmm28, %zmm19 {%k5}
// CHECK:  encoding: [0x62,0xa1,0x1d,0x45,0xd5,0xdb]
          vpmullw %zmm19, %zmm28, %zmm19 {%k5}

// CHECK: vpmullw %zmm19, %zmm28, %zmm19 {%k5} {z}
// CHECK:  encoding: [0x62,0xa1,0x1d,0xc5,0xd5,0xdb]
          vpmullw %zmm19, %zmm28, %zmm19 {%k5} {z}

// CHECK: vpmullw (%rcx), %zmm28, %zmm19
// CHECK:  encoding: [0x62,0xe1,0x1d,0x40,0xd5,0x19]
          vpmullw (%rcx), %zmm28, %zmm19

// CHECK: vpmullw 291(%rax,%r14,8), %zmm28, %zmm19
// CHECK:  encoding: [0x62,0xa1,0x1d,0x40,0xd5,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vpmullw 291(%rax,%r14,8), %zmm28, %zmm19

// CHECK: vpmullw 8128(%rdx), %zmm28, %zmm19
// CHECK:  encoding: [0x62,0xe1,0x1d,0x40,0xd5,0x5a,0x7f]
          vpmullw 8128(%rdx), %zmm28, %zmm19

// CHECK: vpmullw 8192(%rdx), %zmm28, %zmm19
// CHECK:  encoding: [0x62,0xe1,0x1d,0x40,0xd5,0x9a,0x00,0x20,0x00,0x00]
          vpmullw 8192(%rdx), %zmm28, %zmm19

// CHECK: vpmullw -8192(%rdx), %zmm28, %zmm19
// CHECK:  encoding: [0x62,0xe1,0x1d,0x40,0xd5,0x5a,0x80]
          vpmullw -8192(%rdx), %zmm28, %zmm19

// CHECK: vpmullw -8256(%rdx), %zmm28, %zmm19
// CHECK:  encoding: [0x62,0xe1,0x1d,0x40,0xd5,0x9a,0xc0,0xdf,0xff,0xff]
          vpmullw -8256(%rdx), %zmm28, %zmm19

// CHECK: vpsubb %zmm26, %zmm18, %zmm25
// CHECK:  encoding: [0x62,0x01,0x6d,0x40,0xf8,0xca]
          vpsubb %zmm26, %zmm18, %zmm25

// CHECK: vpsubb %zmm26, %zmm18, %zmm25 {%k4}
// CHECK:  encoding: [0x62,0x01,0x6d,0x44,0xf8,0xca]
          vpsubb %zmm26, %zmm18, %zmm25 {%k4}

// CHECK: vpsubb %zmm26, %zmm18, %zmm25 {%k4} {z}
// CHECK:  encoding: [0x62,0x01,0x6d,0xc4,0xf8,0xca]
          vpsubb %zmm26, %zmm18, %zmm25 {%k4} {z}

// CHECK: vpsubb (%rcx), %zmm18, %zmm25
// CHECK:  encoding: [0x62,0x61,0x6d,0x40,0xf8,0x09]
          vpsubb (%rcx), %zmm18, %zmm25

// CHECK: vpsubb 291(%rax,%r14,8), %zmm18, %zmm25
// CHECK:  encoding: [0x62,0x21,0x6d,0x40,0xf8,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vpsubb 291(%rax,%r14,8), %zmm18, %zmm25

// CHECK: vpsubb 8128(%rdx), %zmm18, %zmm25
// CHECK:  encoding: [0x62,0x61,0x6d,0x40,0xf8,0x4a,0x7f]
          vpsubb 8128(%rdx), %zmm18, %zmm25

// CHECK: vpsubb 8192(%rdx), %zmm18, %zmm25
// CHECK:  encoding: [0x62,0x61,0x6d,0x40,0xf8,0x8a,0x00,0x20,0x00,0x00]
          vpsubb 8192(%rdx), %zmm18, %zmm25

// CHECK: vpsubb -8192(%rdx), %zmm18, %zmm25
// CHECK:  encoding: [0x62,0x61,0x6d,0x40,0xf8,0x4a,0x80]
          vpsubb -8192(%rdx), %zmm18, %zmm25

// CHECK: vpsubb -8256(%rdx), %zmm18, %zmm25
// CHECK:  encoding: [0x62,0x61,0x6d,0x40,0xf8,0x8a,0xc0,0xdf,0xff,0xff]
          vpsubb -8256(%rdx), %zmm18, %zmm25

// CHECK: vpsubw %zmm24, %zmm24, %zmm17
// CHECK:  encoding: [0x62,0x81,0x3d,0x40,0xf9,0xc8]
          vpsubw %zmm24, %zmm24, %zmm17

// CHECK: vpsubw %zmm24, %zmm24, %zmm17 {%k4}
// CHECK:  encoding: [0x62,0x81,0x3d,0x44,0xf9,0xc8]
          vpsubw %zmm24, %zmm24, %zmm17 {%k4}

// CHECK: vpsubw %zmm24, %zmm24, %zmm17 {%k4} {z}
// CHECK:  encoding: [0x62,0x81,0x3d,0xc4,0xf9,0xc8]
          vpsubw %zmm24, %zmm24, %zmm17 {%k4} {z}

// CHECK: vpsubw (%rcx), %zmm24, %zmm17
// CHECK:  encoding: [0x62,0xe1,0x3d,0x40,0xf9,0x09]
          vpsubw (%rcx), %zmm24, %zmm17

// CHECK: vpsubw 291(%rax,%r14,8), %zmm24, %zmm17
// CHECK:  encoding: [0x62,0xa1,0x3d,0x40,0xf9,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vpsubw 291(%rax,%r14,8), %zmm24, %zmm17

// CHECK: vpsubw 8128(%rdx), %zmm24, %zmm17
// CHECK:  encoding: [0x62,0xe1,0x3d,0x40,0xf9,0x4a,0x7f]
          vpsubw 8128(%rdx), %zmm24, %zmm17

// CHECK: vpsubw 8192(%rdx), %zmm24, %zmm17
// CHECK:  encoding: [0x62,0xe1,0x3d,0x40,0xf9,0x8a,0x00,0x20,0x00,0x00]
          vpsubw 8192(%rdx), %zmm24, %zmm17

// CHECK: vpsubw -8192(%rdx), %zmm24, %zmm17
// CHECK:  encoding: [0x62,0xe1,0x3d,0x40,0xf9,0x4a,0x80]
          vpsubw -8192(%rdx), %zmm24, %zmm17

// CHECK: vpsubw -8256(%rdx), %zmm24, %zmm17
// CHECK:  encoding: [0x62,0xe1,0x3d,0x40,0xf9,0x8a,0xc0,0xdf,0xff,0xff]
          vpsubw -8256(%rdx), %zmm24, %zmm17

// CHECK: vmovdqu8 %zmm19, %zmm29
// CHECK:  encoding: [0x62,0x21,0x7f,0x48,0x6f,0xeb]
          vmovdqu8 %zmm19, %zmm29

// CHECK: vmovdqu8 %zmm19, %zmm29 {%k7}
// CHECK:  encoding: [0x62,0x21,0x7f,0x4f,0x6f,0xeb]
          vmovdqu8 %zmm19, %zmm29 {%k7}

// CHECK: vmovdqu8 %zmm19, %zmm29 {%k7} {z}
// CHECK:  encoding: [0x62,0x21,0x7f,0xcf,0x6f,0xeb]
          vmovdqu8 %zmm19, %zmm29 {%k7} {z}

// CHECK: vmovdqu8 (%rcx), %zmm29
// CHECK:  encoding: [0x62,0x61,0x7f,0x48,0x6f,0x29]
          vmovdqu8 (%rcx), %zmm29

// CHECK: vmovdqu8 291(%rax,%r14,8), %zmm29
// CHECK:  encoding: [0x62,0x21,0x7f,0x48,0x6f,0xac,0xf0,0x23,0x01,0x00,0x00]
          vmovdqu8 291(%rax,%r14,8), %zmm29

// CHECK: vmovdqu8 8128(%rdx), %zmm29
// CHECK:  encoding: [0x62,0x61,0x7f,0x48,0x6f,0x6a,0x7f]
          vmovdqu8 8128(%rdx), %zmm29

// CHECK: vmovdqu8 8192(%rdx), %zmm29
// CHECK:  encoding: [0x62,0x61,0x7f,0x48,0x6f,0xaa,0x00,0x20,0x00,0x00]
          vmovdqu8 8192(%rdx), %zmm29

// CHECK: vmovdqu8 -8192(%rdx), %zmm29
// CHECK:  encoding: [0x62,0x61,0x7f,0x48,0x6f,0x6a,0x80]
          vmovdqu8 -8192(%rdx), %zmm29

// CHECK: vmovdqu8 -8256(%rdx), %zmm29
// CHECK:  encoding: [0x62,0x61,0x7f,0x48,0x6f,0xaa,0xc0,0xdf,0xff,0xff]
          vmovdqu8 -8256(%rdx), %zmm29

// CHECK: vmovdqu16 %zmm18, %zmm17
// CHECK:  encoding: [0x62,0xa1,0xff,0x48,0x6f,0xca]
          vmovdqu16 %zmm18, %zmm17

// CHECK: vmovdqu16 %zmm18, %zmm17 {%k3}
// CHECK:  encoding: [0x62,0xa1,0xff,0x4b,0x6f,0xca]
          vmovdqu16 %zmm18, %zmm17 {%k3}

// CHECK: vmovdqu16 %zmm18, %zmm17 {%k3} {z}
// CHECK:  encoding: [0x62,0xa1,0xff,0xcb,0x6f,0xca]
          vmovdqu16 %zmm18, %zmm17 {%k3} {z}

// CHECK: vmovdqu16 (%rcx), %zmm17
// CHECK:  encoding: [0x62,0xe1,0xff,0x48,0x6f,0x09]
          vmovdqu16 (%rcx), %zmm17

// CHECK: vmovdqu16 291(%rax,%r14,8), %zmm17
// CHECK:  encoding: [0x62,0xa1,0xff,0x48,0x6f,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vmovdqu16 291(%rax,%r14,8), %zmm17

// CHECK: vmovdqu16 8128(%rdx), %zmm17
// CHECK:  encoding: [0x62,0xe1,0xff,0x48,0x6f,0x4a,0x7f]
          vmovdqu16 8128(%rdx), %zmm17

// CHECK: vmovdqu16 8192(%rdx), %zmm17
// CHECK:  encoding: [0x62,0xe1,0xff,0x48,0x6f,0x8a,0x00,0x20,0x00,0x00]
          vmovdqu16 8192(%rdx), %zmm17

// CHECK: vmovdqu16 -8192(%rdx), %zmm17
// CHECK:  encoding: [0x62,0xe1,0xff,0x48,0x6f,0x4a,0x80]
          vmovdqu16 -8192(%rdx), %zmm17

// CHECK: vmovdqu16 -8256(%rdx), %zmm17
// CHECK:  encoding: [0x62,0xe1,0xff,0x48,0x6f,0x8a,0xc0,0xdf,0xff,0xff]
          vmovdqu16 -8256(%rdx), %zmm17

// CHECK: kandq  %k7, %k5, %k5
// CHECK:  encoding: [0xc4,0xe1,0xd4,0x41,0xef]
          kandq  %k7, %k5, %k5

// CHECK: kandd  %k4, %k5, %k5
// CHECK:  encoding: [0xc4,0xe1,0xd5,0x41,0xec]
          kandd  %k4, %k5, %k5

// CHECK: kandnq %k4, %k5, %k2
// CHECK:  encoding: [0xc4,0xe1,0xd4,0x42,0xd4]
          kandnq %k4, %k5, %k2

// CHECK: kandnd %k6, %k6, %k3
// CHECK:  encoding: [0xc4,0xe1,0xcd,0x42,0xde]
          kandnd %k6, %k6, %k3

// CHECK: korq   %k4, %k5, %k4
// CHECK:  encoding: [0xc4,0xe1,0xd4,0x45,0xe4]
          korq   %k4, %k5, %k4

// CHECK: kord   %k6, %k6, %k5
// CHECK:  encoding: [0xc4,0xe1,0xcd,0x45,0xee]
          kord   %k6, %k6, %k5

// CHECK: kxnorq %k6, %k5, %k2
// CHECK:  encoding: [0xc4,0xe1,0xd4,0x46,0xd6]
          kxnorq %k6, %k5, %k2

// CHECK: kxnord %k5, %k3, %k5
// CHECK:  encoding: [0xc4,0xe1,0xe5,0x46,0xed]
          kxnord %k5, %k3, %k5

// CHECK: kxorq  %k4, %k3, %k2
// CHECK:  encoding: [0xc4,0xe1,0xe4,0x47,0xd4]
          kxorq  %k4, %k3, %k2

// CHECK: kxord  %k6, %k5, %k2
// CHECK:  encoding: [0xc4,0xe1,0xd5,0x47,0xd6]
          kxord  %k6, %k5, %k2

// CHECK: knotq  %k6, %k3
// CHECK:  encoding: [0xc4,0xe1,0xf8,0x44,0xde]
          knotq  %k6, %k3

// CHECK: knotd  %k4, %k3
// CHECK:  encoding: [0xc4,0xe1,0xf9,0x44,0xdc]
          knotd  %k4, %k3

// CHECK: kmovq  %k5, %k2
// CHECK:  encoding: [0xc4,0xe1,0xf8,0x90,0xd5]
          kmovq  %k5, %k2

// CHECK: kmovq  (%rcx), %k2
// CHECK:  encoding: [0xc4,0xe1,0xf8,0x90,0x11]
          kmovq  (%rcx), %k2

// CHECK: kmovq  291(%rax,%r14,8), %k2
// CHECK:  encoding: [0xc4,0xa1,0xf8,0x90,0x94,0xf0,0x23,0x01,0x00,0x00]
          kmovq  291(%rax,%r14,8), %k2

// CHECK: kmovd  %k4, %k5
// CHECK:  encoding: [0xc4,0xe1,0xf9,0x90,0xec]
          kmovd  %k4, %k5

// CHECK: kmovd  (%rcx), %k5
// CHECK:  encoding: [0xc4,0xe1,0xf9,0x90,0x29]
          kmovd  (%rcx), %k5

// CHECK: kmovd  291(%rax,%r14,8), %k5
// CHECK:  encoding: [0xc4,0xa1,0xf9,0x90,0xac,0xf0,0x23,0x01,0x00,0x00]
          kmovd  291(%rax,%r14,8), %k5

// CHECK: kmovq  %k3, (%rcx)
// CHECK:  encoding: [0xc4,0xe1,0xf8,0x91,0x19]
          kmovq  %k3, (%rcx)

// CHECK: kmovq  %k3, 291(%rax,%r14,8)
// CHECK:  encoding: [0xc4,0xa1,0xf8,0x91,0x9c,0xf0,0x23,0x01,0x00,0x00]
          kmovq  %k3, 291(%rax,%r14,8)

// CHECK: kmovd  %k3, (%rcx)
// CHECK:  encoding: [0xc4,0xe1,0xf9,0x91,0x19]
          kmovd  %k3, (%rcx)

// CHECK: kmovd  %k3, 291(%rax,%r14,8)
// CHECK:  encoding: [0xc4,0xa1,0xf9,0x91,0x9c,0xf0,0x23,0x01,0x00,0x00]
          kmovd  %k3, 291(%rax,%r14,8)

// CHECK: kmovq  %rax, %k2
// CHECK:  encoding: [0xc4,0xe1,0xfb,0x92,0xd0]
          kmovq  %rax, %k2

// CHECK: kmovq  %r8, %k2
// CHECK:  encoding: [0xc4,0xc1,0xfb,0x92,0xd0]
          kmovq  %r8, %k2

// CHECK: kmovd  %eax, %k4
// CHECK:  encoding: [0xc5,0xfb,0x92,0xe0]
          kmovd  %eax, %k4

// CHECK: kmovd  %ebp, %k4
// CHECK:  encoding: [0xc5,0xfb,0x92,0xe5]
          kmovd  %ebp, %k4

// CHECK: kmovd  %r13d, %k4
// CHECK:  encoding: [0xc4,0xc1,0x7b,0x92,0xe5]
          kmovd  %r13d, %k4

// CHECK: kmovq  %k3, %rax
// CHECK:  encoding: [0xc4,0xe1,0xfb,0x93,0xc3]
          kmovq  %k3, %rax

// CHECK: kmovq  %k3, %r8
// CHECK:  encoding: [0xc4,0x61,0xfb,0x93,0xc3]
          kmovq  %k3, %r8

// CHECK: kmovd  %k5, %eax
// CHECK:  encoding: [0xc5,0xfb,0x93,0xc5]
          kmovd  %k5, %eax

// CHECK: kmovd  %k5, %ebp
// CHECK:  encoding: [0xc5,0xfb,0x93,0xed]
          kmovd  %k5, %ebp

// CHECK: kmovd  %k5, %r13d
// CHECK:  encoding: [0xc5,0x7b,0x93,0xed]
          kmovd  %k5, %r13d

// CHECK: vmovdqu8 %zmm18, (%rcx)
// CHECK:  encoding: [0x62,0xe1,0x7f,0x48,0x7f,0x11]
          vmovdqu8 %zmm18, (%rcx)

// CHECK: vmovdqu8 %zmm18, (%rcx) {%k3}
// CHECK:  encoding: [0x62,0xe1,0x7f,0x4b,0x7f,0x11]
          vmovdqu8 %zmm18, (%rcx) {%k3}

// CHECK: vmovdqu8 %zmm18, 291(%rax,%r14,8)
// CHECK:  encoding: [0x62,0xa1,0x7f,0x48,0x7f,0x94,0xf0,0x23,0x01,0x00,0x00]
          vmovdqu8 %zmm18, 291(%rax,%r14,8)

// CHECK: vmovdqu8 %zmm18, 8128(%rdx)
// CHECK:  encoding: [0x62,0xe1,0x7f,0x48,0x7f,0x52,0x7f]
          vmovdqu8 %zmm18, 8128(%rdx)

// CHECK: vmovdqu8 %zmm18, 8192(%rdx)
// CHECK:  encoding: [0x62,0xe1,0x7f,0x48,0x7f,0x92,0x00,0x20,0x00,0x00]
          vmovdqu8 %zmm18, 8192(%rdx)

// CHECK: vmovdqu8 %zmm18, -8192(%rdx)
// CHECK:  encoding: [0x62,0xe1,0x7f,0x48,0x7f,0x52,0x80]
          vmovdqu8 %zmm18, -8192(%rdx)

// CHECK: vmovdqu8 %zmm18, -8256(%rdx)
// CHECK:  encoding: [0x62,0xe1,0x7f,0x48,0x7f,0x92,0xc0,0xdf,0xff,0xff]
          vmovdqu8 %zmm18, -8256(%rdx)

// CHECK: vmovdqu16 %zmm28, (%rcx)
// CHECK:  encoding: [0x62,0x61,0xff,0x48,0x7f,0x21]
          vmovdqu16 %zmm28, (%rcx)

// CHECK: vmovdqu16 %zmm28, (%rcx) {%k6}
// CHECK:  encoding: [0x62,0x61,0xff,0x4e,0x7f,0x21]
          vmovdqu16 %zmm28, (%rcx) {%k6}

// CHECK: vmovdqu16 %zmm28, 291(%rax,%r14,8)
// CHECK:  encoding: [0x62,0x21,0xff,0x48,0x7f,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vmovdqu16 %zmm28, 291(%rax,%r14,8)

// CHECK: vmovdqu16 %zmm28, 8128(%rdx)
// CHECK:  encoding: [0x62,0x61,0xff,0x48,0x7f,0x62,0x7f]
          vmovdqu16 %zmm28, 8128(%rdx)

// CHECK: vmovdqu16 %zmm28, 8192(%rdx)
// CHECK:  encoding: [0x62,0x61,0xff,0x48,0x7f,0xa2,0x00,0x20,0x00,0x00]
          vmovdqu16 %zmm28, 8192(%rdx)

// CHECK: vmovdqu16 %zmm28, -8192(%rdx)
// CHECK:  encoding: [0x62,0x61,0xff,0x48,0x7f,0x62,0x80]
          vmovdqu16 %zmm28, -8192(%rdx)

// CHECK: vmovdqu16 %zmm28, -8256(%rdx)
// CHECK:  encoding: [0x62,0x61,0xff,0x48,0x7f,0xa2,0xc0,0xdf,0xff,0xff]
          vmovdqu16 %zmm28, -8256(%rdx)


// CHECK: vpcmpb $171, %zmm25, %zmm26, %k3
// CHECK:  encoding: [0x62,0x93,0x2d,0x40,0x3f,0xd9,0xab]
          vpcmpb $171, %zmm25, %zmm26, %k3

// CHECK: vpcmpb $171, %zmm25, %zmm26, %k3 {%k7}
// CHECK:  encoding: [0x62,0x93,0x2d,0x47,0x3f,0xd9,0xab]
          vpcmpb $171, %zmm25, %zmm26, %k3 {%k7}

// CHECK: vpcmpb $123, %zmm25, %zmm26, %k3
// CHECK:  encoding: [0x62,0x93,0x2d,0x40,0x3f,0xd9,0x7b]
          vpcmpb $123, %zmm25, %zmm26, %k3

// CHECK: vpcmpb $123, (%rcx), %zmm26, %k3
// CHECK:  encoding: [0x62,0xf3,0x2d,0x40,0x3f,0x19,0x7b]
          vpcmpb $123, (%rcx), %zmm26, %k3

// CHECK: vpcmpb $123, 291(%rax,%r14,8), %zmm26, %k3
// CHECK:  encoding: [0x62,0xb3,0x2d,0x40,0x3f,0x9c,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vpcmpb $123, 291(%rax,%r14,8), %zmm26, %k3

// CHECK: vpcmpb $123, 8128(%rdx), %zmm26, %k3
// CHECK:  encoding: [0x62,0xf3,0x2d,0x40,0x3f,0x5a,0x7f,0x7b]
          vpcmpb $123, 8128(%rdx), %zmm26, %k3

// CHECK: vpcmpb $123, 8192(%rdx), %zmm26, %k3
// CHECK:  encoding: [0x62,0xf3,0x2d,0x40,0x3f,0x9a,0x00,0x20,0x00,0x00,0x7b]
          vpcmpb $123, 8192(%rdx), %zmm26, %k3

// CHECK: vpcmpb $123, -8192(%rdx), %zmm26, %k3
// CHECK:  encoding: [0x62,0xf3,0x2d,0x40,0x3f,0x5a,0x80,0x7b]
          vpcmpb $123, -8192(%rdx), %zmm26, %k3

// CHECK: vpcmpb $123, -8256(%rdx), %zmm26, %k3
// CHECK:  encoding: [0x62,0xf3,0x2d,0x40,0x3f,0x9a,0xc0,0xdf,0xff,0xff,0x7b]
          vpcmpb $123, -8256(%rdx), %zmm26, %k3

// CHECK: vpcmpltb %zmm25, %zmm26, %k3
// CHECK:  encoding: [0x62,0x93,0x2d,0x40,0x3f,0xd9,0x01]
          vpcmpltb %zmm25, %zmm26, %k3

// CHECK: vpcmpltb %zmm25, %zmm26, %k3 {%k7}
// CHECK:  encoding: [0x62,0x93,0x2d,0x47,0x3f,0xd9,0x01]
          vpcmpltb %zmm25, %zmm26, %k3 {%k7}

// CHECK: vpcmpltb (%rcx), %zmm26, %k3
// CHECK:  encoding: [0x62,0xf3,0x2d,0x40,0x3f,0x19,0x01]
          vpcmpltb (%rcx), %zmm26, %k3

// CHECK: vpcmpltb 291(%rax,%r14,8), %zmm26, %k3
// CHECK:  encoding: [0x62,0xb3,0x2d,0x40,0x3f,0x9c,0xf0,0x23,0x01,0x00,0x00,0x01]
          vpcmpltb 291(%rax,%r14,8), %zmm26, %k3

// CHECK: vpcmpltb 8128(%rdx), %zmm26, %k3
// CHECK:  encoding: [0x62,0xf3,0x2d,0x40,0x3f,0x5a,0x7f,0x01]
          vpcmpltb 8128(%rdx), %zmm26, %k3

// CHECK: vpcmpltb 8192(%rdx), %zmm26, %k3
// CHECK:  encoding: [0x62,0xf3,0x2d,0x40,0x3f,0x9a,0x00,0x20,0x00,0x00,0x01]
          vpcmpltb 8192(%rdx), %zmm26, %k3

// CHECK: vpcmpltb -8192(%rdx), %zmm26, %k3
// CHECK:  encoding: [0x62,0xf3,0x2d,0x40,0x3f,0x5a,0x80,0x01]
          vpcmpltb -8192(%rdx), %zmm26, %k3

// CHECK: vpcmpltb -8256(%rdx), %zmm26, %k3
// CHECK:  encoding: [0x62,0xf3,0x2d,0x40,0x3f,0x9a,0xc0,0xdf,0xff,0xff,0x01]
          vpcmpltb -8256(%rdx), %zmm26, %k3

// CHECK: vpcmpleb %zmm25, %zmm26, %k3
// CHECK:  encoding: [0x62,0x93,0x2d,0x40,0x3f,0xd9,0x02]
          vpcmpleb %zmm25, %zmm26, %k3

// CHECK: vpcmpleb %zmm25, %zmm26, %k3 {%k7}
// CHECK:  encoding: [0x62,0x93,0x2d,0x47,0x3f,0xd9,0x02]
          vpcmpleb %zmm25, %zmm26, %k3 {%k7}

// CHECK: vpcmpleb (%rcx), %zmm26, %k3
// CHECK:  encoding: [0x62,0xf3,0x2d,0x40,0x3f,0x19,0x02]
          vpcmpleb (%rcx), %zmm26, %k3

// CHECK: vpcmpleb 291(%rax,%r14,8), %zmm26, %k3
// CHECK:  encoding: [0x62,0xb3,0x2d,0x40,0x3f,0x9c,0xf0,0x23,0x01,0x00,0x00,0x02]
          vpcmpleb 291(%rax,%r14,8), %zmm26, %k3

// CHECK: vpcmpleb 8128(%rdx), %zmm26, %k3
// CHECK:  encoding: [0x62,0xf3,0x2d,0x40,0x3f,0x5a,0x7f,0x02]
          vpcmpleb 8128(%rdx), %zmm26, %k3

// CHECK: vpcmpleb 8192(%rdx), %zmm26, %k3
// CHECK:  encoding: [0x62,0xf3,0x2d,0x40,0x3f,0x9a,0x00,0x20,0x00,0x00,0x02]
          vpcmpleb 8192(%rdx), %zmm26, %k3

// CHECK: vpcmpleb -8192(%rdx), %zmm26, %k3
// CHECK:  encoding: [0x62,0xf3,0x2d,0x40,0x3f,0x5a,0x80,0x02]
          vpcmpleb -8192(%rdx), %zmm26, %k3

// CHECK: vpcmpleb -8256(%rdx), %zmm26, %k3
// CHECK:  encoding: [0x62,0xf3,0x2d,0x40,0x3f,0x9a,0xc0,0xdf,0xff,0xff,0x02]
          vpcmpleb -8256(%rdx), %zmm26, %k3

// CHECK: vpcmpneqb %zmm25, %zmm26, %k3
// CHECK:  encoding: [0x62,0x93,0x2d,0x40,0x3f,0xd9,0x04]
          vpcmpneqb %zmm25, %zmm26, %k3

// CHECK: vpcmpneqb %zmm25, %zmm26, %k3 {%k7}
// CHECK:  encoding: [0x62,0x93,0x2d,0x47,0x3f,0xd9,0x04]
          vpcmpneqb %zmm25, %zmm26, %k3 {%k7}

// CHECK: vpcmpneqb (%rcx), %zmm26, %k3
// CHECK:  encoding: [0x62,0xf3,0x2d,0x40,0x3f,0x19,0x04]
          vpcmpneqb (%rcx), %zmm26, %k3

// CHECK: vpcmpneqb 291(%rax,%r14,8), %zmm26, %k3
// CHECK:  encoding: [0x62,0xb3,0x2d,0x40,0x3f,0x9c,0xf0,0x23,0x01,0x00,0x00,0x04]
          vpcmpneqb 291(%rax,%r14,8), %zmm26, %k3

// CHECK: vpcmpneqb 8128(%rdx), %zmm26, %k3
// CHECK:  encoding: [0x62,0xf3,0x2d,0x40,0x3f,0x5a,0x7f,0x04]
          vpcmpneqb 8128(%rdx), %zmm26, %k3

// CHECK: vpcmpneqb 8192(%rdx), %zmm26, %k3
// CHECK:  encoding: [0x62,0xf3,0x2d,0x40,0x3f,0x9a,0x00,0x20,0x00,0x00,0x04]
          vpcmpneqb 8192(%rdx), %zmm26, %k3

// CHECK: vpcmpneqb -8192(%rdx), %zmm26, %k3
// CHECK:  encoding: [0x62,0xf3,0x2d,0x40,0x3f,0x5a,0x80,0x04]
          vpcmpneqb -8192(%rdx), %zmm26, %k3

// CHECK: vpcmpneqb -8256(%rdx), %zmm26, %k3
// CHECK:  encoding: [0x62,0xf3,0x2d,0x40,0x3f,0x9a,0xc0,0xdf,0xff,0xff,0x04]
          vpcmpneqb -8256(%rdx), %zmm26, %k3

// CHECK: vpcmpnltb %zmm25, %zmm26, %k3
// CHECK:  encoding: [0x62,0x93,0x2d,0x40,0x3f,0xd9,0x05]
          vpcmpnltb %zmm25, %zmm26, %k3

// CHECK: vpcmpnltb %zmm25, %zmm26, %k3 {%k7}
// CHECK:  encoding: [0x62,0x93,0x2d,0x47,0x3f,0xd9,0x05]
          vpcmpnltb %zmm25, %zmm26, %k3 {%k7}

// CHECK: vpcmpnltb (%rcx), %zmm26, %k3
// CHECK:  encoding: [0x62,0xf3,0x2d,0x40,0x3f,0x19,0x05]
          vpcmpnltb (%rcx), %zmm26, %k3

// CHECK: vpcmpnltb 291(%rax,%r14,8), %zmm26, %k3
// CHECK:  encoding: [0x62,0xb3,0x2d,0x40,0x3f,0x9c,0xf0,0x23,0x01,0x00,0x00,0x05]
          vpcmpnltb 291(%rax,%r14,8), %zmm26, %k3

// CHECK: vpcmpnltb 8128(%rdx), %zmm26, %k3
// CHECK:  encoding: [0x62,0xf3,0x2d,0x40,0x3f,0x5a,0x7f,0x05]
          vpcmpnltb 8128(%rdx), %zmm26, %k3

// CHECK: vpcmpnltb 8192(%rdx), %zmm26, %k3
// CHECK:  encoding: [0x62,0xf3,0x2d,0x40,0x3f,0x9a,0x00,0x20,0x00,0x00,0x05]
          vpcmpnltb 8192(%rdx), %zmm26, %k3

// CHECK: vpcmpnltb -8192(%rdx), %zmm26, %k3
// CHECK:  encoding: [0x62,0xf3,0x2d,0x40,0x3f,0x5a,0x80,0x05]
          vpcmpnltb -8192(%rdx), %zmm26, %k3

// CHECK: vpcmpnltb -8256(%rdx), %zmm26, %k3
// CHECK:  encoding: [0x62,0xf3,0x2d,0x40,0x3f,0x9a,0xc0,0xdf,0xff,0xff,0x05]
          vpcmpnltb -8256(%rdx), %zmm26, %k3

// CHECK: vpcmpnleb %zmm25, %zmm26, %k3
// CHECK:  encoding: [0x62,0x93,0x2d,0x40,0x3f,0xd9,0x06]
          vpcmpnleb %zmm25, %zmm26, %k3

// CHECK: vpcmpnleb %zmm25, %zmm26, %k3 {%k7}
// CHECK:  encoding: [0x62,0x93,0x2d,0x47,0x3f,0xd9,0x06]
          vpcmpnleb %zmm25, %zmm26, %k3 {%k7}

// CHECK: vpcmpnleb (%rcx), %zmm26, %k3
// CHECK:  encoding: [0x62,0xf3,0x2d,0x40,0x3f,0x19,0x06]
          vpcmpnleb (%rcx), %zmm26, %k3

// CHECK: vpcmpnleb 291(%rax,%r14,8), %zmm26, %k3
// CHECK:  encoding: [0x62,0xb3,0x2d,0x40,0x3f,0x9c,0xf0,0x23,0x01,0x00,0x00,0x06]
          vpcmpnleb 291(%rax,%r14,8), %zmm26, %k3

// CHECK: vpcmpnleb 8128(%rdx), %zmm26, %k3
// CHECK:  encoding: [0x62,0xf3,0x2d,0x40,0x3f,0x5a,0x7f,0x06]
          vpcmpnleb 8128(%rdx), %zmm26, %k3

// CHECK: vpcmpnleb 8192(%rdx), %zmm26, %k3
// CHECK:  encoding: [0x62,0xf3,0x2d,0x40,0x3f,0x9a,0x00,0x20,0x00,0x00,0x06]
          vpcmpnleb 8192(%rdx), %zmm26, %k3

// CHECK: vpcmpnleb -8192(%rdx), %zmm26, %k3
// CHECK:  encoding: [0x62,0xf3,0x2d,0x40,0x3f,0x5a,0x80,0x06]
          vpcmpnleb -8192(%rdx), %zmm26, %k3

// CHECK: vpcmpnleb -8256(%rdx), %zmm26, %k3
// CHECK:  encoding: [0x62,0xf3,0x2d,0x40,0x3f,0x9a,0xc0,0xdf,0xff,0xff,0x06]
          vpcmpnleb -8256(%rdx), %zmm26, %k3

// CHECK: vpcmpw $171, %zmm25, %zmm29, %k3
// CHECK:  encoding: [0x62,0x93,0x95,0x40,0x3f,0xd9,0xab]
          vpcmpw $171, %zmm25, %zmm29, %k3

// CHECK: vpcmpw $171, %zmm25, %zmm29, %k3 {%k6}
// CHECK:  encoding: [0x62,0x93,0x95,0x46,0x3f,0xd9,0xab]
          vpcmpw $171, %zmm25, %zmm29, %k3 {%k6}

// CHECK: vpcmpw $123, %zmm25, %zmm29, %k3
// CHECK:  encoding: [0x62,0x93,0x95,0x40,0x3f,0xd9,0x7b]
          vpcmpw $123, %zmm25, %zmm29, %k3

// CHECK: vpcmpw $123, (%rcx), %zmm29, %k3
// CHECK:  encoding: [0x62,0xf3,0x95,0x40,0x3f,0x19,0x7b]
          vpcmpw $123, (%rcx), %zmm29, %k3

// CHECK: vpcmpw $123, 291(%rax,%r14,8), %zmm29, %k3
// CHECK:  encoding: [0x62,0xb3,0x95,0x40,0x3f,0x9c,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vpcmpw $123, 291(%rax,%r14,8), %zmm29, %k3

// CHECK: vpcmpw $123, 8128(%rdx), %zmm29, %k3
// CHECK:  encoding: [0x62,0xf3,0x95,0x40,0x3f,0x5a,0x7f,0x7b]
          vpcmpw $123, 8128(%rdx), %zmm29, %k3

// CHECK: vpcmpw $123, 8192(%rdx), %zmm29, %k3
// CHECK:  encoding: [0x62,0xf3,0x95,0x40,0x3f,0x9a,0x00,0x20,0x00,0x00,0x7b]
          vpcmpw $123, 8192(%rdx), %zmm29, %k3

// CHECK: vpcmpw $123, -8192(%rdx), %zmm29, %k3
// CHECK:  encoding: [0x62,0xf3,0x95,0x40,0x3f,0x5a,0x80,0x7b]
          vpcmpw $123, -8192(%rdx), %zmm29, %k3

// CHECK: vpcmpw $123, -8256(%rdx), %zmm29, %k3
// CHECK:  encoding: [0x62,0xf3,0x95,0x40,0x3f,0x9a,0xc0,0xdf,0xff,0xff,0x7b]
          vpcmpw $123, -8256(%rdx), %zmm29, %k3

// CHECK: vpcmpltw %zmm25, %zmm29, %k3
// CHECK:  encoding: [0x62,0x93,0x95,0x40,0x3f,0xd9,0x01]
          vpcmpltw %zmm25, %zmm29, %k3

// CHECK: vpcmpltw %zmm25, %zmm29, %k3 {%k6}
// CHECK:  encoding: [0x62,0x93,0x95,0x46,0x3f,0xd9,0x01]
          vpcmpltw %zmm25, %zmm29, %k3 {%k6}

// CHECK: vpcmpltw (%rcx), %zmm29, %k3
// CHECK:  encoding: [0x62,0xf3,0x95,0x40,0x3f,0x19,0x01]
          vpcmpltw (%rcx), %zmm29, %k3

// CHECK: vpcmpltw 291(%rax,%r14,8), %zmm29, %k3
// CHECK:  encoding: [0x62,0xb3,0x95,0x40,0x3f,0x9c,0xf0,0x23,0x01,0x00,0x00,0x01]
          vpcmpltw 291(%rax,%r14,8), %zmm29, %k3

// CHECK: vpcmpltw 8128(%rdx), %zmm29, %k3
// CHECK:  encoding: [0x62,0xf3,0x95,0x40,0x3f,0x5a,0x7f,0x01]
          vpcmpltw 8128(%rdx), %zmm29, %k3

// CHECK: vpcmpltw 8192(%rdx), %zmm29, %k3
// CHECK:  encoding: [0x62,0xf3,0x95,0x40,0x3f,0x9a,0x00,0x20,0x00,0x00,0x01]
          vpcmpltw 8192(%rdx), %zmm29, %k3

// CHECK: vpcmpltw -8192(%rdx), %zmm29, %k3
// CHECK:  encoding: [0x62,0xf3,0x95,0x40,0x3f,0x5a,0x80,0x01]
          vpcmpltw -8192(%rdx), %zmm29, %k3

// CHECK: vpcmpltw -8256(%rdx), %zmm29, %k3
// CHECK:  encoding: [0x62,0xf3,0x95,0x40,0x3f,0x9a,0xc0,0xdf,0xff,0xff,0x01]
          vpcmpltw -8256(%rdx), %zmm29, %k3

// CHECK: vpcmplew %zmm25, %zmm29, %k3
// CHECK:  encoding: [0x62,0x93,0x95,0x40,0x3f,0xd9,0x02]
          vpcmplew %zmm25, %zmm29, %k3

// CHECK: vpcmplew %zmm25, %zmm29, %k3 {%k6}
// CHECK:  encoding: [0x62,0x93,0x95,0x46,0x3f,0xd9,0x02]
          vpcmplew %zmm25, %zmm29, %k3 {%k6}

// CHECK: vpcmplew (%rcx), %zmm29, %k3
// CHECK:  encoding: [0x62,0xf3,0x95,0x40,0x3f,0x19,0x02]
          vpcmplew (%rcx), %zmm29, %k3

// CHECK: vpcmplew 291(%rax,%r14,8), %zmm29, %k3
// CHECK:  encoding: [0x62,0xb3,0x95,0x40,0x3f,0x9c,0xf0,0x23,0x01,0x00,0x00,0x02]
          vpcmplew 291(%rax,%r14,8), %zmm29, %k3

// CHECK: vpcmplew 8128(%rdx), %zmm29, %k3
// CHECK:  encoding: [0x62,0xf3,0x95,0x40,0x3f,0x5a,0x7f,0x02]
          vpcmplew 8128(%rdx), %zmm29, %k3

// CHECK: vpcmplew 8192(%rdx), %zmm29, %k3
// CHECK:  encoding: [0x62,0xf3,0x95,0x40,0x3f,0x9a,0x00,0x20,0x00,0x00,0x02]
          vpcmplew 8192(%rdx), %zmm29, %k3

// CHECK: vpcmplew -8192(%rdx), %zmm29, %k3
// CHECK:  encoding: [0x62,0xf3,0x95,0x40,0x3f,0x5a,0x80,0x02]
          vpcmplew -8192(%rdx), %zmm29, %k3

// CHECK: vpcmplew -8256(%rdx), %zmm29, %k3
// CHECK:  encoding: [0x62,0xf3,0x95,0x40,0x3f,0x9a,0xc0,0xdf,0xff,0xff,0x02]
          vpcmplew -8256(%rdx), %zmm29, %k3

// CHECK: vpcmpneqw %zmm25, %zmm29, %k3
// CHECK:  encoding: [0x62,0x93,0x95,0x40,0x3f,0xd9,0x04]
          vpcmpneqw %zmm25, %zmm29, %k3

// CHECK: vpcmpneqw %zmm25, %zmm29, %k3 {%k6}
// CHECK:  encoding: [0x62,0x93,0x95,0x46,0x3f,0xd9,0x04]
          vpcmpneqw %zmm25, %zmm29, %k3 {%k6}

// CHECK: vpcmpneqw (%rcx), %zmm29, %k3
// CHECK:  encoding: [0x62,0xf3,0x95,0x40,0x3f,0x19,0x04]
          vpcmpneqw (%rcx), %zmm29, %k3

// CHECK: vpcmpneqw 291(%rax,%r14,8), %zmm29, %k3
// CHECK:  encoding: [0x62,0xb3,0x95,0x40,0x3f,0x9c,0xf0,0x23,0x01,0x00,0x00,0x04]
          vpcmpneqw 291(%rax,%r14,8), %zmm29, %k3

// CHECK: vpcmpneqw 8128(%rdx), %zmm29, %k3
// CHECK:  encoding: [0x62,0xf3,0x95,0x40,0x3f,0x5a,0x7f,0x04]
          vpcmpneqw 8128(%rdx), %zmm29, %k3

// CHECK: vpcmpneqw 8192(%rdx), %zmm29, %k3
// CHECK:  encoding: [0x62,0xf3,0x95,0x40,0x3f,0x9a,0x00,0x20,0x00,0x00,0x04]
          vpcmpneqw 8192(%rdx), %zmm29, %k3

// CHECK: vpcmpneqw -8192(%rdx), %zmm29, %k3
// CHECK:  encoding: [0x62,0xf3,0x95,0x40,0x3f,0x5a,0x80,0x04]
          vpcmpneqw -8192(%rdx), %zmm29, %k3

// CHECK: vpcmpneqw -8256(%rdx), %zmm29, %k3
// CHECK:  encoding: [0x62,0xf3,0x95,0x40,0x3f,0x9a,0xc0,0xdf,0xff,0xff,0x04]
          vpcmpneqw -8256(%rdx), %zmm29, %k3

// CHECK: vpcmpnltw %zmm25, %zmm29, %k3
// CHECK:  encoding: [0x62,0x93,0x95,0x40,0x3f,0xd9,0x05]
          vpcmpnltw %zmm25, %zmm29, %k3

// CHECK: vpcmpnltw %zmm25, %zmm29, %k3 {%k6}
// CHECK:  encoding: [0x62,0x93,0x95,0x46,0x3f,0xd9,0x05]
          vpcmpnltw %zmm25, %zmm29, %k3 {%k6}

// CHECK: vpcmpnltw (%rcx), %zmm29, %k3
// CHECK:  encoding: [0x62,0xf3,0x95,0x40,0x3f,0x19,0x05]
          vpcmpnltw (%rcx), %zmm29, %k3

// CHECK: vpcmpnltw 291(%rax,%r14,8), %zmm29, %k3
// CHECK:  encoding: [0x62,0xb3,0x95,0x40,0x3f,0x9c,0xf0,0x23,0x01,0x00,0x00,0x05]
          vpcmpnltw 291(%rax,%r14,8), %zmm29, %k3

// CHECK: vpcmpnltw 8128(%rdx), %zmm29, %k3
// CHECK:  encoding: [0x62,0xf3,0x95,0x40,0x3f,0x5a,0x7f,0x05]
          vpcmpnltw 8128(%rdx), %zmm29, %k3

// CHECK: vpcmpnltw 8192(%rdx), %zmm29, %k3
// CHECK:  encoding: [0x62,0xf3,0x95,0x40,0x3f,0x9a,0x00,0x20,0x00,0x00,0x05]
          vpcmpnltw 8192(%rdx), %zmm29, %k3

// CHECK: vpcmpnltw -8192(%rdx), %zmm29, %k3
// CHECK:  encoding: [0x62,0xf3,0x95,0x40,0x3f,0x5a,0x80,0x05]
          vpcmpnltw -8192(%rdx), %zmm29, %k3

// CHECK: vpcmpnltw -8256(%rdx), %zmm29, %k3
// CHECK:  encoding: [0x62,0xf3,0x95,0x40,0x3f,0x9a,0xc0,0xdf,0xff,0xff,0x05]
          vpcmpnltw -8256(%rdx), %zmm29, %k3

// CHECK: vpcmpnlew %zmm25, %zmm29, %k3
// CHECK:  encoding: [0x62,0x93,0x95,0x40,0x3f,0xd9,0x06]
          vpcmpnlew %zmm25, %zmm29, %k3

// CHECK: vpcmpnlew %zmm25, %zmm29, %k3 {%k6}
// CHECK:  encoding: [0x62,0x93,0x95,0x46,0x3f,0xd9,0x06]
          vpcmpnlew %zmm25, %zmm29, %k3 {%k6}

// CHECK: vpcmpnlew (%rcx), %zmm29, %k3
// CHECK:  encoding: [0x62,0xf3,0x95,0x40,0x3f,0x19,0x06]
          vpcmpnlew (%rcx), %zmm29, %k3

// CHECK: vpcmpnlew 291(%rax,%r14,8), %zmm29, %k3
// CHECK:  encoding: [0x62,0xb3,0x95,0x40,0x3f,0x9c,0xf0,0x23,0x01,0x00,0x00,0x06]
          vpcmpnlew 291(%rax,%r14,8), %zmm29, %k3

// CHECK: vpcmpnlew 8128(%rdx), %zmm29, %k3
// CHECK:  encoding: [0x62,0xf3,0x95,0x40,0x3f,0x5a,0x7f,0x06]
          vpcmpnlew 8128(%rdx), %zmm29, %k3

// CHECK: vpcmpnlew 8192(%rdx), %zmm29, %k3
// CHECK:  encoding: [0x62,0xf3,0x95,0x40,0x3f,0x9a,0x00,0x20,0x00,0x00,0x06]
          vpcmpnlew 8192(%rdx), %zmm29, %k3

// CHECK: vpcmpnlew -8192(%rdx), %zmm29, %k3
// CHECK:  encoding: [0x62,0xf3,0x95,0x40,0x3f,0x5a,0x80,0x06]
          vpcmpnlew -8192(%rdx), %zmm29, %k3

// CHECK: vpcmpnlew -8256(%rdx), %zmm29, %k3
// CHECK:  encoding: [0x62,0xf3,0x95,0x40,0x3f,0x9a,0xc0,0xdf,0xff,0xff,0x06]
          vpcmpnlew -8256(%rdx), %zmm29, %k3

// CHECK: vpcmpub $171, %zmm22, %zmm29, %k4
// CHECK:  encoding: [0x62,0xb3,0x15,0x40,0x3e,0xe6,0xab]
          vpcmpub $171, %zmm22, %zmm29, %k4

// CHECK: vpcmpub $171, %zmm22, %zmm29, %k4 {%k7}
// CHECK:  encoding: [0x62,0xb3,0x15,0x47,0x3e,0xe6,0xab]
          vpcmpub $171, %zmm22, %zmm29, %k4 {%k7}

// CHECK: vpcmpub $123, %zmm22, %zmm29, %k4
// CHECK:  encoding: [0x62,0xb3,0x15,0x40,0x3e,0xe6,0x7b]
          vpcmpub $123, %zmm22, %zmm29, %k4

// CHECK: vpcmpub $123, (%rcx), %zmm29, %k4
// CHECK:  encoding: [0x62,0xf3,0x15,0x40,0x3e,0x21,0x7b]
          vpcmpub $123, (%rcx), %zmm29, %k4

// CHECK: vpcmpub $123, 291(%rax,%r14,8), %zmm29, %k4
// CHECK:  encoding: [0x62,0xb3,0x15,0x40,0x3e,0xa4,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vpcmpub $123, 291(%rax,%r14,8), %zmm29, %k4

// CHECK: vpcmpub $123, 8128(%rdx), %zmm29, %k4
// CHECK:  encoding: [0x62,0xf3,0x15,0x40,0x3e,0x62,0x7f,0x7b]
          vpcmpub $123, 8128(%rdx), %zmm29, %k4

// CHECK: vpcmpub $123, 8192(%rdx), %zmm29, %k4
// CHECK:  encoding: [0x62,0xf3,0x15,0x40,0x3e,0xa2,0x00,0x20,0x00,0x00,0x7b]
          vpcmpub $123, 8192(%rdx), %zmm29, %k4

// CHECK: vpcmpub $123, -8192(%rdx), %zmm29, %k4
// CHECK:  encoding: [0x62,0xf3,0x15,0x40,0x3e,0x62,0x80,0x7b]
          vpcmpub $123, -8192(%rdx), %zmm29, %k4

// CHECK: vpcmpub $123, -8256(%rdx), %zmm29, %k4
// CHECK:  encoding: [0x62,0xf3,0x15,0x40,0x3e,0xa2,0xc0,0xdf,0xff,0xff,0x7b]
          vpcmpub $123, -8256(%rdx), %zmm29, %k4

// CHECK: vpcmpequb %zmm22, %zmm29, %k4
// CHECK:  encoding: [0x62,0xb3,0x15,0x40,0x3e,0xe6,0x00]
          vpcmpequb %zmm22, %zmm29, %k4

// CHECK: vpcmpequb %zmm22, %zmm29, %k4 {%k7}
// CHECK:  encoding: [0x62,0xb3,0x15,0x47,0x3e,0xe6,0x00]
          vpcmpequb %zmm22, %zmm29, %k4 {%k7}

// CHECK: vpcmpequb %zmm22, %zmm29, %k4
// CHECK:  encoding: [0x62,0xb3,0x15,0x40,0x3e,0xe6,0x00]
          vpcmpequb %zmm22, %zmm29, %k4

// CHECK: vpcmpequb (%rcx), %zmm29, %k4
// CHECK:  encoding: [0x62,0xf3,0x15,0x40,0x3e,0x21,0x00]
          vpcmpequb (%rcx), %zmm29, %k4

// CHECK: vpcmpequb 291(%rax,%r14,8), %zmm29, %k4
// CHECK:  encoding: [0x62,0xb3,0x15,0x40,0x3e,0xa4,0xf0,0x23,0x01,0x00,0x00,0x00]
          vpcmpequb 291(%rax,%r14,8), %zmm29, %k4

// CHECK: vpcmpequb 8128(%rdx), %zmm29, %k4
// CHECK:  encoding: [0x62,0xf3,0x15,0x40,0x3e,0x62,0x7f,0x00]
          vpcmpequb 8128(%rdx), %zmm29, %k4

// CHECK: vpcmpequb 8192(%rdx), %zmm29, %k4
// CHECK:  encoding: [0x62,0xf3,0x15,0x40,0x3e,0xa2,0x00,0x20,0x00,0x00,0x00]
          vpcmpequb 8192(%rdx), %zmm29, %k4

// CHECK: vpcmpequb -8192(%rdx), %zmm29, %k4
// CHECK:  encoding: [0x62,0xf3,0x15,0x40,0x3e,0x62,0x80,0x00]
          vpcmpequb -8192(%rdx), %zmm29, %k4

// CHECK: vpcmpequb -8256(%rdx), %zmm29, %k4
// CHECK:  encoding: [0x62,0xf3,0x15,0x40,0x3e,0xa2,0xc0,0xdf,0xff,0xff,0x00]
          vpcmpequb -8256(%rdx), %zmm29, %k4

// CHECK: vpcmpltub %zmm22, %zmm29, %k4
// CHECK:  encoding: [0x62,0xb3,0x15,0x40,0x3e,0xe6,0x01]
          vpcmpltub %zmm22, %zmm29, %k4

// CHECK: vpcmpltub %zmm22, %zmm29, %k4 {%k7}
// CHECK:  encoding: [0x62,0xb3,0x15,0x47,0x3e,0xe6,0x01]
          vpcmpltub %zmm22, %zmm29, %k4 {%k7}

// CHECK: vpcmpltub %zmm22, %zmm29, %k4
// CHECK:  encoding: [0x62,0xb3,0x15,0x40,0x3e,0xe6,0x01]
          vpcmpltub %zmm22, %zmm29, %k4

// CHECK: vpcmpltub (%rcx), %zmm29, %k4
// CHECK:  encoding: [0x62,0xf3,0x15,0x40,0x3e,0x21,0x01]
          vpcmpltub (%rcx), %zmm29, %k4

// CHECK: vpcmpltub 291(%rax,%r14,8), %zmm29, %k4
// CHECK:  encoding: [0x62,0xb3,0x15,0x40,0x3e,0xa4,0xf0,0x23,0x01,0x00,0x00,0x01]
          vpcmpltub 291(%rax,%r14,8), %zmm29, %k4

// CHECK: vpcmpltub 8128(%rdx), %zmm29, %k4
// CHECK:  encoding: [0x62,0xf3,0x15,0x40,0x3e,0x62,0x7f,0x01]
          vpcmpltub 8128(%rdx), %zmm29, %k4

// CHECK: vpcmpltub 8192(%rdx), %zmm29, %k4
// CHECK:  encoding: [0x62,0xf3,0x15,0x40,0x3e,0xa2,0x00,0x20,0x00,0x00,0x01]
          vpcmpltub 8192(%rdx), %zmm29, %k4

// CHECK: vpcmpltub -8192(%rdx), %zmm29, %k4
// CHECK:  encoding: [0x62,0xf3,0x15,0x40,0x3e,0x62,0x80,0x01]
          vpcmpltub -8192(%rdx), %zmm29, %k4

// CHECK: vpcmpltub -8256(%rdx), %zmm29, %k4
// CHECK:  encoding: [0x62,0xf3,0x15,0x40,0x3e,0xa2,0xc0,0xdf,0xff,0xff,0x01]
          vpcmpltub -8256(%rdx), %zmm29, %k4

// CHECK: vpcmpleub %zmm22, %zmm29, %k4
// CHECK:  encoding: [0x62,0xb3,0x15,0x40,0x3e,0xe6,0x02]
          vpcmpleub %zmm22, %zmm29, %k4

// CHECK: vpcmpleub %zmm22, %zmm29, %k4 {%k7}
// CHECK:  encoding: [0x62,0xb3,0x15,0x47,0x3e,0xe6,0x02]
          vpcmpleub %zmm22, %zmm29, %k4 {%k7}

// CHECK: vpcmpleub %zmm22, %zmm29, %k4
// CHECK:  encoding: [0x62,0xb3,0x15,0x40,0x3e,0xe6,0x02]
          vpcmpleub %zmm22, %zmm29, %k4

// CHECK: vpcmpleub (%rcx), %zmm29, %k4
// CHECK:  encoding: [0x62,0xf3,0x15,0x40,0x3e,0x21,0x02]
          vpcmpleub (%rcx), %zmm29, %k4

// CHECK: vpcmpleub 291(%rax,%r14,8), %zmm29, %k4
// CHECK:  encoding: [0x62,0xb3,0x15,0x40,0x3e,0xa4,0xf0,0x23,0x01,0x00,0x00,0x02]
          vpcmpleub 291(%rax,%r14,8), %zmm29, %k4

// CHECK: vpcmpleub 8128(%rdx), %zmm29, %k4
// CHECK:  encoding: [0x62,0xf3,0x15,0x40,0x3e,0x62,0x7f,0x02]
          vpcmpleub 8128(%rdx), %zmm29, %k4

// CHECK: vpcmpleub 8192(%rdx), %zmm29, %k4
// CHECK:  encoding: [0x62,0xf3,0x15,0x40,0x3e,0xa2,0x00,0x20,0x00,0x00,0x02]
          vpcmpleub 8192(%rdx), %zmm29, %k4

// CHECK: vpcmpleub -8192(%rdx), %zmm29, %k4
// CHECK:  encoding: [0x62,0xf3,0x15,0x40,0x3e,0x62,0x80,0x02]
          vpcmpleub -8192(%rdx), %zmm29, %k4

// CHECK: vpcmpleub -8256(%rdx), %zmm29, %k4
// CHECK:  encoding: [0x62,0xf3,0x15,0x40,0x3e,0xa2,0xc0,0xdf,0xff,0xff,0x02]
          vpcmpleub -8256(%rdx), %zmm29, %k4

// CHECK: vpcmpnequb %zmm22, %zmm29, %k4
// CHECK:  encoding: [0x62,0xb3,0x15,0x40,0x3e,0xe6,0x04]
          vpcmpnequb %zmm22, %zmm29, %k4

// CHECK: vpcmpnequb %zmm22, %zmm29, %k4 {%k7}
// CHECK:  encoding: [0x62,0xb3,0x15,0x47,0x3e,0xe6,0x04]
          vpcmpnequb %zmm22, %zmm29, %k4 {%k7}

// CHECK: vpcmpnequb %zmm22, %zmm29, %k4
// CHECK:  encoding: [0x62,0xb3,0x15,0x40,0x3e,0xe6,0x04]
          vpcmpnequb %zmm22, %zmm29, %k4

// CHECK: vpcmpnequb (%rcx), %zmm29, %k4
// CHECK:  encoding: [0x62,0xf3,0x15,0x40,0x3e,0x21,0x04]
          vpcmpnequb (%rcx), %zmm29, %k4

// CHECK: vpcmpnequb 291(%rax,%r14,8), %zmm29, %k4
// CHECK:  encoding: [0x62,0xb3,0x15,0x40,0x3e,0xa4,0xf0,0x23,0x01,0x00,0x00,0x04]
          vpcmpnequb 291(%rax,%r14,8), %zmm29, %k4

// CHECK: vpcmpnequb 8128(%rdx), %zmm29, %k4
// CHECK:  encoding: [0x62,0xf3,0x15,0x40,0x3e,0x62,0x7f,0x04]
          vpcmpnequb 8128(%rdx), %zmm29, %k4

// CHECK: vpcmpnequb 8192(%rdx), %zmm29, %k4
// CHECK:  encoding: [0x62,0xf3,0x15,0x40,0x3e,0xa2,0x00,0x20,0x00,0x00,0x04]
          vpcmpnequb 8192(%rdx), %zmm29, %k4

// CHECK: vpcmpnequb -8192(%rdx), %zmm29, %k4
// CHECK:  encoding: [0x62,0xf3,0x15,0x40,0x3e,0x62,0x80,0x04]
          vpcmpnequb -8192(%rdx), %zmm29, %k4

// CHECK: vpcmpnequb -8256(%rdx), %zmm29, %k4
// CHECK:  encoding: [0x62,0xf3,0x15,0x40,0x3e,0xa2,0xc0,0xdf,0xff,0xff,0x04]
          vpcmpnequb -8256(%rdx), %zmm29, %k4

// CHECK: vpcmpnltub %zmm22, %zmm29, %k4
// CHECK:  encoding: [0x62,0xb3,0x15,0x40,0x3e,0xe6,0x05]
          vpcmpnltub %zmm22, %zmm29, %k4

// CHECK: vpcmpnltub %zmm22, %zmm29, %k4 {%k7}
// CHECK:  encoding: [0x62,0xb3,0x15,0x47,0x3e,0xe6,0x05]
          vpcmpnltub %zmm22, %zmm29, %k4 {%k7}

// CHECK: vpcmpnltub %zmm22, %zmm29, %k4
// CHECK:  encoding: [0x62,0xb3,0x15,0x40,0x3e,0xe6,0x05]
          vpcmpnltub %zmm22, %zmm29, %k4

// CHECK: vpcmpnltub (%rcx), %zmm29, %k4
// CHECK:  encoding: [0x62,0xf3,0x15,0x40,0x3e,0x21,0x05]
          vpcmpnltub (%rcx), %zmm29, %k4

// CHECK: vpcmpnltub 291(%rax,%r14,8), %zmm29, %k4
// CHECK:  encoding: [0x62,0xb3,0x15,0x40,0x3e,0xa4,0xf0,0x23,0x01,0x00,0x00,0x05]
          vpcmpnltub 291(%rax,%r14,8), %zmm29, %k4

// CHECK: vpcmpnltub 8128(%rdx), %zmm29, %k4
// CHECK:  encoding: [0x62,0xf3,0x15,0x40,0x3e,0x62,0x7f,0x05]
          vpcmpnltub 8128(%rdx), %zmm29, %k4

// CHECK: vpcmpnltub 8192(%rdx), %zmm29, %k4
// CHECK:  encoding: [0x62,0xf3,0x15,0x40,0x3e,0xa2,0x00,0x20,0x00,0x00,0x05]
          vpcmpnltub 8192(%rdx), %zmm29, %k4

// CHECK: vpcmpnltub -8192(%rdx), %zmm29, %k4
// CHECK:  encoding: [0x62,0xf3,0x15,0x40,0x3e,0x62,0x80,0x05]
          vpcmpnltub -8192(%rdx), %zmm29, %k4

// CHECK: vpcmpnltub -8256(%rdx), %zmm29, %k4
// CHECK:  encoding: [0x62,0xf3,0x15,0x40,0x3e,0xa2,0xc0,0xdf,0xff,0xff,0x05]
          vpcmpnltub -8256(%rdx), %zmm29, %k4

// CHECK: vpcmpnleub %zmm22, %zmm29, %k4
// CHECK:  encoding: [0x62,0xb3,0x15,0x40,0x3e,0xe6,0x06]
          vpcmpnleub %zmm22, %zmm29, %k4

// CHECK: vpcmpnleub %zmm22, %zmm29, %k4 {%k7}
// CHECK:  encoding: [0x62,0xb3,0x15,0x47,0x3e,0xe6,0x06]
          vpcmpnleub %zmm22, %zmm29, %k4 {%k7}

// CHECK: vpcmpnleub %zmm22, %zmm29, %k4
// CHECK:  encoding: [0x62,0xb3,0x15,0x40,0x3e,0xe6,0x06]
          vpcmpnleub %zmm22, %zmm29, %k4

// CHECK: vpcmpnleub (%rcx), %zmm29, %k4
// CHECK:  encoding: [0x62,0xf3,0x15,0x40,0x3e,0x21,0x06]
          vpcmpnleub (%rcx), %zmm29, %k4

// CHECK: vpcmpnleub 291(%rax,%r14,8), %zmm29, %k4
// CHECK:  encoding: [0x62,0xb3,0x15,0x40,0x3e,0xa4,0xf0,0x23,0x01,0x00,0x00,0x06]
          vpcmpnleub 291(%rax,%r14,8), %zmm29, %k4

// CHECK: vpcmpnleub 8128(%rdx), %zmm29, %k4
// CHECK:  encoding: [0x62,0xf3,0x15,0x40,0x3e,0x62,0x7f,0x06]
          vpcmpnleub 8128(%rdx), %zmm29, %k4

// CHECK: vpcmpnleub 8192(%rdx), %zmm29, %k4
// CHECK:  encoding: [0x62,0xf3,0x15,0x40,0x3e,0xa2,0x00,0x20,0x00,0x00,0x06]
          vpcmpnleub 8192(%rdx), %zmm29, %k4

// CHECK: vpcmpnleub -8192(%rdx), %zmm29, %k4
// CHECK:  encoding: [0x62,0xf3,0x15,0x40,0x3e,0x62,0x80,0x06]
          vpcmpnleub -8192(%rdx), %zmm29, %k4

// CHECK: vpcmpnleub -8256(%rdx), %zmm29, %k4
// CHECK:  encoding: [0x62,0xf3,0x15,0x40,0x3e,0xa2,0xc0,0xdf,0xff,0xff,0x06]
          vpcmpnleub -8256(%rdx), %zmm29, %k4

// CHECK: vpcmpuw $171, %zmm22, %zmm22, %k4
// CHECK:  encoding: [0x62,0xb3,0xcd,0x40,0x3e,0xe6,0xab]
          vpcmpuw $171, %zmm22, %zmm22, %k4

// CHECK: vpcmpuw $171, %zmm22, %zmm22, %k4 {%k7}
// CHECK:  encoding: [0x62,0xb3,0xcd,0x47,0x3e,0xe6,0xab]
          vpcmpuw $171, %zmm22, %zmm22, %k4 {%k7}

// CHECK: vpcmpuw $123, %zmm22, %zmm22, %k4
// CHECK:  encoding: [0x62,0xb3,0xcd,0x40,0x3e,0xe6,0x7b]
          vpcmpuw $123, %zmm22, %zmm22, %k4

// CHECK: vpcmpuw $123, (%rcx), %zmm22, %k4
// CHECK:  encoding: [0x62,0xf3,0xcd,0x40,0x3e,0x21,0x7b]
          vpcmpuw $123, (%rcx), %zmm22, %k4

// CHECK: vpcmpuw $123, 291(%rax,%r14,8), %zmm22, %k4
// CHECK:  encoding: [0x62,0xb3,0xcd,0x40,0x3e,0xa4,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vpcmpuw $123, 291(%rax,%r14,8), %zmm22, %k4

// CHECK: vpcmpuw $123, 8128(%rdx), %zmm22, %k4
// CHECK:  encoding: [0x62,0xf3,0xcd,0x40,0x3e,0x62,0x7f,0x7b]
          vpcmpuw $123, 8128(%rdx), %zmm22, %k4

// CHECK: vpcmpuw $123, 8192(%rdx), %zmm22, %k4
// CHECK:  encoding: [0x62,0xf3,0xcd,0x40,0x3e,0xa2,0x00,0x20,0x00,0x00,0x7b]
          vpcmpuw $123, 8192(%rdx), %zmm22, %k4

// CHECK: vpcmpuw $123, -8192(%rdx), %zmm22, %k4
// CHECK:  encoding: [0x62,0xf3,0xcd,0x40,0x3e,0x62,0x80,0x7b]
          vpcmpuw $123, -8192(%rdx), %zmm22, %k4

// CHECK: vpcmpuw $123, -8256(%rdx), %zmm22, %k4
// CHECK:  encoding: [0x62,0xf3,0xcd,0x40,0x3e,0xa2,0xc0,0xdf,0xff,0xff,0x7b]
          vpcmpuw $123, -8256(%rdx), %zmm22, %k4

// CHECK: vpcmpequw %zmm22, %zmm22, %k4
// CHECK:  encoding: [0x62,0xb3,0xcd,0x40,0x3e,0xe6,0x00]
          vpcmpequw %zmm22, %zmm22, %k4

// CHECK: vpcmpequw %zmm22, %zmm22, %k4 {%k7}
// CHECK:  encoding: [0x62,0xb3,0xcd,0x47,0x3e,0xe6,0x00]
          vpcmpequw %zmm22, %zmm22, %k4 {%k7}

// CHECK: vpcmpequw (%rcx), %zmm22, %k4
// CHECK:  encoding: [0x62,0xf3,0xcd,0x40,0x3e,0x21,0x00]
          vpcmpequw (%rcx), %zmm22, %k4

// CHECK: vpcmpequw 291(%rax,%r14,8), %zmm22, %k4
// CHECK:  encoding: [0x62,0xb3,0xcd,0x40,0x3e,0xa4,0xf0,0x23,0x01,0x00,0x00,0x00]
          vpcmpequw 291(%rax,%r14,8), %zmm22, %k4

// CHECK: vpcmpequw 8128(%rdx), %zmm22, %k4
// CHECK:  encoding: [0x62,0xf3,0xcd,0x40,0x3e,0x62,0x7f,0x00]
          vpcmpequw 8128(%rdx), %zmm22, %k4

// CHECK: vpcmpequw 8192(%rdx), %zmm22, %k4
// CHECK:  encoding: [0x62,0xf3,0xcd,0x40,0x3e,0xa2,0x00,0x20,0x00,0x00,0x00]
          vpcmpequw 8192(%rdx), %zmm22, %k4

// CHECK: vpcmpequw -8192(%rdx), %zmm22, %k4
// CHECK:  encoding: [0x62,0xf3,0xcd,0x40,0x3e,0x62,0x80,0x00]
          vpcmpequw -8192(%rdx), %zmm22, %k4

// CHECK: vpcmpequw -8256(%rdx), %zmm22, %k4
// CHECK:  encoding: [0x62,0xf3,0xcd,0x40,0x3e,0xa2,0xc0,0xdf,0xff,0xff,0x00]
          vpcmpequw -8256(%rdx), %zmm22, %k4

// CHECK: vpcmpltuw %zmm22, %zmm22, %k4
// CHECK:  encoding: [0x62,0xb3,0xcd,0x40,0x3e,0xe6,0x01]
          vpcmpltuw %zmm22, %zmm22, %k4

// CHECK: vpcmpltuw %zmm22, %zmm22, %k4 {%k7}
// CHECK:  encoding: [0x62,0xb3,0xcd,0x47,0x3e,0xe6,0x01]
          vpcmpltuw %zmm22, %zmm22, %k4 {%k7}

// CHECK: vpcmpltuw (%rcx), %zmm22, %k4
// CHECK:  encoding: [0x62,0xf3,0xcd,0x40,0x3e,0x21,0x01]
          vpcmpltuw (%rcx), %zmm22, %k4

// CHECK: vpcmpltuw 291(%rax,%r14,8), %zmm22, %k4
// CHECK:  encoding: [0x62,0xb3,0xcd,0x40,0x3e,0xa4,0xf0,0x23,0x01,0x00,0x00,0x01]
          vpcmpltuw 291(%rax,%r14,8), %zmm22, %k4

// CHECK: vpcmpltuw 8128(%rdx), %zmm22, %k4
// CHECK:  encoding: [0x62,0xf3,0xcd,0x40,0x3e,0x62,0x7f,0x01]
          vpcmpltuw 8128(%rdx), %zmm22, %k4

// CHECK: vpcmpltuw 8192(%rdx), %zmm22, %k4
// CHECK:  encoding: [0x62,0xf3,0xcd,0x40,0x3e,0xa2,0x00,0x20,0x00,0x00,0x01]
          vpcmpltuw 8192(%rdx), %zmm22, %k4

// CHECK: vpcmpltuw -8192(%rdx), %zmm22, %k4
// CHECK:  encoding: [0x62,0xf3,0xcd,0x40,0x3e,0x62,0x80,0x01]
          vpcmpltuw -8192(%rdx), %zmm22, %k4

// CHECK: vpcmpltuw -8256(%rdx), %zmm22, %k4
// CHECK:  encoding: [0x62,0xf3,0xcd,0x40,0x3e,0xa2,0xc0,0xdf,0xff,0xff,0x01]
          vpcmpltuw -8256(%rdx), %zmm22, %k4

// CHECK: vpcmpleuw %zmm22, %zmm22, %k4
// CHECK:  encoding: [0x62,0xb3,0xcd,0x40,0x3e,0xe6,0x02]
          vpcmpleuw %zmm22, %zmm22, %k4

// CHECK: vpcmpleuw %zmm22, %zmm22, %k4 {%k7}
// CHECK:  encoding: [0x62,0xb3,0xcd,0x47,0x3e,0xe6,0x02]
          vpcmpleuw %zmm22, %zmm22, %k4 {%k7}

// CHECK: vpcmpleuw (%rcx), %zmm22, %k4
// CHECK:  encoding: [0x62,0xf3,0xcd,0x40,0x3e,0x21,0x02]
          vpcmpleuw (%rcx), %zmm22, %k4

// CHECK: vpcmpleuw 291(%rax,%r14,8), %zmm22, %k4
// CHECK:  encoding: [0x62,0xb3,0xcd,0x40,0x3e,0xa4,0xf0,0x23,0x01,0x00,0x00,0x02]
          vpcmpleuw 291(%rax,%r14,8), %zmm22, %k4

// CHECK: vpcmpleuw 8128(%rdx), %zmm22, %k4
// CHECK:  encoding: [0x62,0xf3,0xcd,0x40,0x3e,0x62,0x7f,0x02]
          vpcmpleuw 8128(%rdx), %zmm22, %k4

// CHECK: vpcmpleuw 8192(%rdx), %zmm22, %k4
// CHECK:  encoding: [0x62,0xf3,0xcd,0x40,0x3e,0xa2,0x00,0x20,0x00,0x00,0x02]
          vpcmpleuw 8192(%rdx), %zmm22, %k4

// CHECK: vpcmpleuw -8192(%rdx), %zmm22, %k4
// CHECK:  encoding: [0x62,0xf3,0xcd,0x40,0x3e,0x62,0x80,0x02]
          vpcmpleuw -8192(%rdx), %zmm22, %k4

// CHECK: vpcmpleuw -8256(%rdx), %zmm22, %k4
// CHECK:  encoding: [0x62,0xf3,0xcd,0x40,0x3e,0xa2,0xc0,0xdf,0xff,0xff,0x02]
          vpcmpleuw -8256(%rdx), %zmm22, %k4

// CHECK: vpcmpnequw %zmm22, %zmm22, %k4
// CHECK:  encoding: [0x62,0xb3,0xcd,0x40,0x3e,0xe6,0x04]
          vpcmpnequw %zmm22, %zmm22, %k4

// CHECK: vpcmpnequw %zmm22, %zmm22, %k4 {%k7}
// CHECK:  encoding: [0x62,0xb3,0xcd,0x47,0x3e,0xe6,0x04]
          vpcmpnequw %zmm22, %zmm22, %k4 {%k7}

// CHECK: vpcmpnequw (%rcx), %zmm22, %k4
// CHECK:  encoding: [0x62,0xf3,0xcd,0x40,0x3e,0x21,0x04]
          vpcmpnequw (%rcx), %zmm22, %k4

// CHECK: vpcmpnequw 291(%rax,%r14,8), %zmm22, %k4
// CHECK:  encoding: [0x62,0xb3,0xcd,0x40,0x3e,0xa4,0xf0,0x23,0x01,0x00,0x00,0x04]
          vpcmpnequw 291(%rax,%r14,8), %zmm22, %k4

// CHECK: vpcmpnequw 8128(%rdx), %zmm22, %k4
// CHECK:  encoding: [0x62,0xf3,0xcd,0x40,0x3e,0x62,0x7f,0x04]
          vpcmpnequw 8128(%rdx), %zmm22, %k4

// CHECK: vpcmpnequw 8192(%rdx), %zmm22, %k4
// CHECK:  encoding: [0x62,0xf3,0xcd,0x40,0x3e,0xa2,0x00,0x20,0x00,0x00,0x04]
          vpcmpnequw 8192(%rdx), %zmm22, %k4

// CHECK: vpcmpnequw -8192(%rdx), %zmm22, %k4
// CHECK:  encoding: [0x62,0xf3,0xcd,0x40,0x3e,0x62,0x80,0x04]
          vpcmpnequw -8192(%rdx), %zmm22, %k4

// CHECK: vpcmpnequw -8256(%rdx), %zmm22, %k4
// CHECK:  encoding: [0x62,0xf3,0xcd,0x40,0x3e,0xa2,0xc0,0xdf,0xff,0xff,0x04]
          vpcmpnequw -8256(%rdx), %zmm22, %k4

// CHECK: vpcmpnltuw %zmm22, %zmm22, %k4
// CHECK:  encoding: [0x62,0xb3,0xcd,0x40,0x3e,0xe6,0x05]
          vpcmpnltuw %zmm22, %zmm22, %k4

// CHECK: vpcmpnltuw %zmm22, %zmm22, %k4 {%k7}
// CHECK:  encoding: [0x62,0xb3,0xcd,0x47,0x3e,0xe6,0x05]
          vpcmpnltuw %zmm22, %zmm22, %k4 {%k7}

// CHECK: vpcmpnltuw (%rcx), %zmm22, %k4
// CHECK:  encoding: [0x62,0xf3,0xcd,0x40,0x3e,0x21,0x05]
          vpcmpnltuw (%rcx), %zmm22, %k4

// CHECK: vpcmpnltuw 291(%rax,%r14,8), %zmm22, %k4
// CHECK:  encoding: [0x62,0xb3,0xcd,0x40,0x3e,0xa4,0xf0,0x23,0x01,0x00,0x00,0x05]
          vpcmpnltuw 291(%rax,%r14,8), %zmm22, %k4

// CHECK: vpcmpnltuw 8128(%rdx), %zmm22, %k4
// CHECK:  encoding: [0x62,0xf3,0xcd,0x40,0x3e,0x62,0x7f,0x05]
          vpcmpnltuw 8128(%rdx), %zmm22, %k4

// CHECK: vpcmpnltuw 8192(%rdx), %zmm22, %k4
// CHECK:  encoding: [0x62,0xf3,0xcd,0x40,0x3e,0xa2,0x00,0x20,0x00,0x00,0x05]
          vpcmpnltuw 8192(%rdx), %zmm22, %k4

// CHECK: vpcmpnltuw -8192(%rdx), %zmm22, %k4
// CHECK:  encoding: [0x62,0xf3,0xcd,0x40,0x3e,0x62,0x80,0x05]
          vpcmpnltuw -8192(%rdx), %zmm22, %k4

// CHECK: vpcmpnltuw -8256(%rdx), %zmm22, %k4
// CHECK:  encoding: [0x62,0xf3,0xcd,0x40,0x3e,0xa2,0xc0,0xdf,0xff,0xff,0x05]
          vpcmpnltuw -8256(%rdx), %zmm22, %k4

// CHECK: vpcmpnleuw %zmm22, %zmm22, %k4
// CHECK:  encoding: [0x62,0xb3,0xcd,0x40,0x3e,0xe6,0x06]
          vpcmpnleuw %zmm22, %zmm22, %k4

// CHECK: vpcmpnleuw %zmm22, %zmm22, %k4 {%k7}
// CHECK:  encoding: [0x62,0xb3,0xcd,0x47,0x3e,0xe6,0x06]
          vpcmpnleuw %zmm22, %zmm22, %k4 {%k7}

// CHECK: vpcmpnleuw (%rcx), %zmm22, %k4
// CHECK:  encoding: [0x62,0xf3,0xcd,0x40,0x3e,0x21,0x06]
          vpcmpnleuw (%rcx), %zmm22, %k4

// CHECK: vpcmpnleuw 291(%rax,%r14,8), %zmm22, %k4
// CHECK:  encoding: [0x62,0xb3,0xcd,0x40,0x3e,0xa4,0xf0,0x23,0x01,0x00,0x00,0x06]
          vpcmpnleuw 291(%rax,%r14,8), %zmm22, %k4

// CHECK: vpcmpnleuw 8128(%rdx), %zmm22, %k4
// CHECK:  encoding: [0x62,0xf3,0xcd,0x40,0x3e,0x62,0x7f,0x06]
          vpcmpnleuw 8128(%rdx), %zmm22, %k4

// CHECK: vpcmpnleuw 8192(%rdx), %zmm22, %k4
// CHECK:  encoding: [0x62,0xf3,0xcd,0x40,0x3e,0xa2,0x00,0x20,0x00,0x00,0x06]
          vpcmpnleuw 8192(%rdx), %zmm22, %k4

// CHECK: vpcmpnleuw -8192(%rdx), %zmm22, %k4
// CHECK:  encoding: [0x62,0xf3,0xcd,0x40,0x3e,0x62,0x80,0x06]
          vpcmpnleuw -8192(%rdx), %zmm22, %k4

// CHECK: vpcmpnleuw -8256(%rdx), %zmm22, %k4
// CHECK:  encoding: [0x62,0xf3,0xcd,0x40,0x3e,0xa2,0xc0,0xdf,0xff,0xff,0x06]
          vpcmpnleuw -8256(%rdx), %zmm22, %k4

// CHECK: vpsllw %xmm24, %zmm21, %zmm24
// CHECK:  encoding: [0x62,0x01,0x55,0x40,0xf1,0xc0]
          vpsllw %xmm24, %zmm21, %zmm24

// CHECK: vpsllw %xmm24, %zmm21, %zmm24 {%k2}
// CHECK:  encoding: [0x62,0x01,0x55,0x42,0xf1,0xc0]
          vpsllw %xmm24, %zmm21, %zmm24 {%k2}

// CHECK: vpsllw %xmm24, %zmm21, %zmm24 {%k2} {z}
// CHECK:  encoding: [0x62,0x01,0x55,0xc2,0xf1,0xc0]
          vpsllw %xmm24, %zmm21, %zmm24 {%k2} {z}

// CHECK: vpsllw (%rcx), %zmm21, %zmm24
// CHECK:  encoding: [0x62,0x61,0x55,0x40,0xf1,0x01]
          vpsllw (%rcx), %zmm21, %zmm24

// CHECK: vpsllw 291(%rax,%r14,8), %zmm21, %zmm24
// CHECK:  encoding: [0x62,0x21,0x55,0x40,0xf1,0x84,0xf0,0x23,0x01,0x00,0x00]
          vpsllw 291(%rax,%r14,8), %zmm21, %zmm24

// CHECK: vpsllw 2032(%rdx), %zmm21, %zmm24
// CHECK:  encoding: [0x62,0x61,0x55,0x40,0xf1,0x42,0x7f]
          vpsllw 2032(%rdx), %zmm21, %zmm24

// CHECK: vpsllw 2048(%rdx), %zmm21, %zmm24
// CHECK:  encoding: [0x62,0x61,0x55,0x40,0xf1,0x82,0x00,0x08,0x00,0x00]
          vpsllw 2048(%rdx), %zmm21, %zmm24

// CHECK: vpsllw -2048(%rdx), %zmm21, %zmm24
// CHECK:  encoding: [0x62,0x61,0x55,0x40,0xf1,0x42,0x80]
          vpsllw -2048(%rdx), %zmm21, %zmm24

// CHECK: vpsllw -2064(%rdx), %zmm21, %zmm24
// CHECK:  encoding: [0x62,0x61,0x55,0x40,0xf1,0x82,0xf0,0xf7,0xff,0xff]
          vpsllw -2064(%rdx), %zmm21, %zmm24

// CHECK: vpsraw %xmm21, %zmm27, %zmm28
// CHECK:  encoding: [0x62,0x21,0x25,0x40,0xe1,0xe5]
          vpsraw %xmm21, %zmm27, %zmm28

// CHECK: vpsraw %xmm21, %zmm27, %zmm28 {%k4}
// CHECK:  encoding: [0x62,0x21,0x25,0x44,0xe1,0xe5]
          vpsraw %xmm21, %zmm27, %zmm28 {%k4}

// CHECK: vpsraw %xmm21, %zmm27, %zmm28 {%k4} {z}
// CHECK:  encoding: [0x62,0x21,0x25,0xc4,0xe1,0xe5]
          vpsraw %xmm21, %zmm27, %zmm28 {%k4} {z}

// CHECK: vpsraw (%rcx), %zmm27, %zmm28
// CHECK:  encoding: [0x62,0x61,0x25,0x40,0xe1,0x21]
          vpsraw (%rcx), %zmm27, %zmm28

// CHECK: vpsraw 291(%rax,%r14,8), %zmm27, %zmm28
// CHECK:  encoding: [0x62,0x21,0x25,0x40,0xe1,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vpsraw 291(%rax,%r14,8), %zmm27, %zmm28

// CHECK: vpsraw 2032(%rdx), %zmm27, %zmm28
// CHECK:  encoding: [0x62,0x61,0x25,0x40,0xe1,0x62,0x7f]
          vpsraw 2032(%rdx), %zmm27, %zmm28

// CHECK: vpsraw 2048(%rdx), %zmm27, %zmm28
// CHECK:  encoding: [0x62,0x61,0x25,0x40,0xe1,0xa2,0x00,0x08,0x00,0x00]
          vpsraw 2048(%rdx), %zmm27, %zmm28

// CHECK: vpsraw -2048(%rdx), %zmm27, %zmm28
// CHECK:  encoding: [0x62,0x61,0x25,0x40,0xe1,0x62,0x80]
          vpsraw -2048(%rdx), %zmm27, %zmm28

// CHECK: vpsraw -2064(%rdx), %zmm27, %zmm28
// CHECK:  encoding: [0x62,0x61,0x25,0x40,0xe1,0xa2,0xf0,0xf7,0xff,0xff]
          vpsraw -2064(%rdx), %zmm27, %zmm28

// CHECK: vpsrlw %xmm22, %zmm20, %zmm23
// CHECK:  encoding: [0x62,0xa1,0x5d,0x40,0xd1,0xfe]
          vpsrlw %xmm22, %zmm20, %zmm23

// CHECK: vpsrlw %xmm22, %zmm20, %zmm23 {%k6}
// CHECK:  encoding: [0x62,0xa1,0x5d,0x46,0xd1,0xfe]
          vpsrlw %xmm22, %zmm20, %zmm23 {%k6}

// CHECK: vpsrlw %xmm22, %zmm20, %zmm23 {%k6} {z}
// CHECK:  encoding: [0x62,0xa1,0x5d,0xc6,0xd1,0xfe]
          vpsrlw %xmm22, %zmm20, %zmm23 {%k6} {z}

// CHECK: vpsrlw (%rcx), %zmm20, %zmm23
// CHECK:  encoding: [0x62,0xe1,0x5d,0x40,0xd1,0x39]
          vpsrlw (%rcx), %zmm20, %zmm23

// CHECK: vpsrlw 291(%rax,%r14,8), %zmm20, %zmm23
// CHECK:  encoding: [0x62,0xa1,0x5d,0x40,0xd1,0xbc,0xf0,0x23,0x01,0x00,0x00]
          vpsrlw 291(%rax,%r14,8), %zmm20, %zmm23

// CHECK: vpsrlw 2032(%rdx), %zmm20, %zmm23
// CHECK:  encoding: [0x62,0xe1,0x5d,0x40,0xd1,0x7a,0x7f]
          vpsrlw 2032(%rdx), %zmm20, %zmm23

// CHECK: vpsrlw 2048(%rdx), %zmm20, %zmm23
// CHECK:  encoding: [0x62,0xe1,0x5d,0x40,0xd1,0xba,0x00,0x08,0x00,0x00]
          vpsrlw 2048(%rdx), %zmm20, %zmm23

// CHECK: vpsrlw -2048(%rdx), %zmm20, %zmm23
// CHECK:  encoding: [0x62,0xe1,0x5d,0x40,0xd1,0x7a,0x80]
          vpsrlw -2048(%rdx), %zmm20, %zmm23

// CHECK: vpsrlw -2064(%rdx), %zmm20, %zmm23
// CHECK:  encoding: [0x62,0xe1,0x5d,0x40,0xd1,0xba,0xf0,0xf7,0xff,0xff]
          vpsrlw -2064(%rdx), %zmm20, %zmm23

// CHECK: vpsrlw $171, %zmm26, %zmm25
// CHECK:  encoding: [0x62,0x91,0x35,0x40,0x71,0xd2,0xab]
          vpsrlw $171, %zmm26, %zmm25

// CHECK: vpsrlw $171, %zmm26, %zmm25 {%k6}
// CHECK:  encoding: [0x62,0x91,0x35,0x46,0x71,0xd2,0xab]
          vpsrlw $171, %zmm26, %zmm25 {%k6}

// CHECK: vpsrlw $171, %zmm26, %zmm25 {%k6} {z}
// CHECK:  encoding: [0x62,0x91,0x35,0xc6,0x71,0xd2,0xab]
          vpsrlw $171, %zmm26, %zmm25 {%k6} {z}

// CHECK: vpsrlw $123, %zmm26, %zmm25
// CHECK:  encoding: [0x62,0x91,0x35,0x40,0x71,0xd2,0x7b]
          vpsrlw $123, %zmm26, %zmm25

// CHECK: vpsrlw $123, (%rcx), %zmm25
// CHECK:  encoding: [0x62,0xf1,0x35,0x40,0x71,0x11,0x7b]
          vpsrlw $123, (%rcx), %zmm25

// CHECK: vpsrlw $123, 291(%rax,%r14,8), %zmm25
// CHECK:  encoding: [0x62,0xb1,0x35,0x40,0x71,0x94,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vpsrlw $123, 291(%rax,%r14,8), %zmm25

// CHECK: vpsrlw $123, 8128(%rdx), %zmm25
// CHECK:  encoding: [0x62,0xf1,0x35,0x40,0x71,0x52,0x7f,0x7b]
          vpsrlw $123, 8128(%rdx), %zmm25

// CHECK: vpsrlw $123, 8192(%rdx), %zmm25
// CHECK:  encoding: [0x62,0xf1,0x35,0x40,0x71,0x92,0x00,0x20,0x00,0x00,0x7b]
          vpsrlw $123, 8192(%rdx), %zmm25

// CHECK: vpsrlw $123, -8192(%rdx), %zmm25
// CHECK:  encoding: [0x62,0xf1,0x35,0x40,0x71,0x52,0x80,0x7b]
          vpsrlw $123, -8192(%rdx), %zmm25

// CHECK: vpsrlw $123, -8256(%rdx), %zmm25
// CHECK:  encoding: [0x62,0xf1,0x35,0x40,0x71,0x92,0xc0,0xdf,0xff,0xff,0x7b]
          vpsrlw $123, -8256(%rdx), %zmm25

// CHECK: vpsraw $171, %zmm29, %zmm28
// CHECK:  encoding: [0x62,0x91,0x1d,0x40,0x71,0xe5,0xab]
          vpsraw $171, %zmm29, %zmm28

// CHECK: vpsraw $171, %zmm29, %zmm28 {%k4}
// CHECK:  encoding: [0x62,0x91,0x1d,0x44,0x71,0xe5,0xab]
          vpsraw $171, %zmm29, %zmm28 {%k4}

// CHECK: vpsraw $171, %zmm29, %zmm28 {%k4} {z}
// CHECK:  encoding: [0x62,0x91,0x1d,0xc4,0x71,0xe5,0xab]
          vpsraw $171, %zmm29, %zmm28 {%k4} {z}

// CHECK: vpsraw $123, %zmm29, %zmm28
// CHECK:  encoding: [0x62,0x91,0x1d,0x40,0x71,0xe5,0x7b]
          vpsraw $123, %zmm29, %zmm28

// CHECK: vpsraw $123, (%rcx), %zmm28
// CHECK:  encoding: [0x62,0xf1,0x1d,0x40,0x71,0x21,0x7b]
          vpsraw $123, (%rcx), %zmm28

// CHECK: vpsraw $123, 291(%rax,%r14,8), %zmm28
// CHECK:  encoding: [0x62,0xb1,0x1d,0x40,0x71,0xa4,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vpsraw $123, 291(%rax,%r14,8), %zmm28

// CHECK: vpsraw $123, 8128(%rdx), %zmm28
// CHECK:  encoding: [0x62,0xf1,0x1d,0x40,0x71,0x62,0x7f,0x7b]
          vpsraw $123, 8128(%rdx), %zmm28

// CHECK: vpsraw $123, 8192(%rdx), %zmm28
// CHECK:  encoding: [0x62,0xf1,0x1d,0x40,0x71,0xa2,0x00,0x20,0x00,0x00,0x7b]
          vpsraw $123, 8192(%rdx), %zmm28

// CHECK: vpsraw $123, -8192(%rdx), %zmm28
// CHECK:  encoding: [0x62,0xf1,0x1d,0x40,0x71,0x62,0x80,0x7b]
          vpsraw $123, -8192(%rdx), %zmm28

// CHECK: vpsraw $123, -8256(%rdx), %zmm28
// CHECK:  encoding: [0x62,0xf1,0x1d,0x40,0x71,0xa2,0xc0,0xdf,0xff,0xff,0x7b]
          vpsraw $123, -8256(%rdx), %zmm28

// CHECK: vpsrlvw %zmm21, %zmm18, %zmm17
// CHECK:  encoding: [0x62,0xa2,0xed,0x40,0x10,0xcd]
          vpsrlvw %zmm21, %zmm18, %zmm17

// CHECK: vpsrlvw %zmm21, %zmm18, %zmm17 {%k6}
// CHECK:  encoding: [0x62,0xa2,0xed,0x46,0x10,0xcd]
          vpsrlvw %zmm21, %zmm18, %zmm17 {%k6}

// CHECK: vpsrlvw %zmm21, %zmm18, %zmm17 {%k6} {z}
// CHECK:  encoding: [0x62,0xa2,0xed,0xc6,0x10,0xcd]
          vpsrlvw %zmm21, %zmm18, %zmm17 {%k6} {z}

// CHECK: vpsrlvw (%rcx), %zmm18, %zmm17
// CHECK:  encoding: [0x62,0xe2,0xed,0x40,0x10,0x09]
          vpsrlvw (%rcx), %zmm18, %zmm17

// CHECK: vpsrlvw 291(%rax,%r14,8), %zmm18, %zmm17
// CHECK:  encoding: [0x62,0xa2,0xed,0x40,0x10,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vpsrlvw 291(%rax,%r14,8), %zmm18, %zmm17

// CHECK: vpsrlvw 8128(%rdx), %zmm18, %zmm17
// CHECK:  encoding: [0x62,0xe2,0xed,0x40,0x10,0x4a,0x7f]
          vpsrlvw 8128(%rdx), %zmm18, %zmm17

// CHECK: vpsrlvw 8192(%rdx), %zmm18, %zmm17
// CHECK:  encoding: [0x62,0xe2,0xed,0x40,0x10,0x8a,0x00,0x20,0x00,0x00]
          vpsrlvw 8192(%rdx), %zmm18, %zmm17

// CHECK: vpsrlvw -8192(%rdx), %zmm18, %zmm17
// CHECK:  encoding: [0x62,0xe2,0xed,0x40,0x10,0x4a,0x80]
          vpsrlvw -8192(%rdx), %zmm18, %zmm17

// CHECK: vpsrlvw -8256(%rdx), %zmm18, %zmm17
// CHECK:  encoding: [0x62,0xe2,0xed,0x40,0x10,0x8a,0xc0,0xdf,0xff,0xff]
          vpsrlvw -8256(%rdx), %zmm18, %zmm17

// CHECK: vpsravw %zmm20, %zmm29, %zmm19
// CHECK:  encoding: [0x62,0xa2,0x95,0x40,0x11,0xdc]
          vpsravw %zmm20, %zmm29, %zmm19

// CHECK: vpsravw %zmm20, %zmm29, %zmm19 {%k7}
// CHECK:  encoding: [0x62,0xa2,0x95,0x47,0x11,0xdc]
          vpsravw %zmm20, %zmm29, %zmm19 {%k7}

// CHECK: vpsravw %zmm20, %zmm29, %zmm19 {%k7} {z}
// CHECK:  encoding: [0x62,0xa2,0x95,0xc7,0x11,0xdc]
          vpsravw %zmm20, %zmm29, %zmm19 {%k7} {z}

// CHECK: vpsravw (%rcx), %zmm29, %zmm19
// CHECK:  encoding: [0x62,0xe2,0x95,0x40,0x11,0x19]
          vpsravw (%rcx), %zmm29, %zmm19

// CHECK: vpsravw 291(%rax,%r14,8), %zmm29, %zmm19
// CHECK:  encoding: [0x62,0xa2,0x95,0x40,0x11,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vpsravw 291(%rax,%r14,8), %zmm29, %zmm19

// CHECK: vpsravw 8128(%rdx), %zmm29, %zmm19
// CHECK:  encoding: [0x62,0xe2,0x95,0x40,0x11,0x5a,0x7f]
          vpsravw 8128(%rdx), %zmm29, %zmm19

// CHECK: vpsravw 8192(%rdx), %zmm29, %zmm19
// CHECK:  encoding: [0x62,0xe2,0x95,0x40,0x11,0x9a,0x00,0x20,0x00,0x00]
          vpsravw 8192(%rdx), %zmm29, %zmm19

// CHECK: vpsravw -8192(%rdx), %zmm29, %zmm19
// CHECK:  encoding: [0x62,0xe2,0x95,0x40,0x11,0x5a,0x80]
          vpsravw -8192(%rdx), %zmm29, %zmm19

// CHECK: vpsravw -8256(%rdx), %zmm29, %zmm19
// CHECK:  encoding: [0x62,0xe2,0x95,0x40,0x11,0x9a,0xc0,0xdf,0xff,0xff]
          vpsravw -8256(%rdx), %zmm29, %zmm19

// CHECK: vpacksswb %zmm18, %zmm29, %zmm21
// CHECK:  encoding: [0x62,0xa1,0x15,0x40,0x63,0xea]
          vpacksswb %zmm18, %zmm29, %zmm21

// CHECK: vpacksswb %zmm18, %zmm29, %zmm21 {%k1}
// CHECK:  encoding: [0x62,0xa1,0x15,0x41,0x63,0xea]
          vpacksswb %zmm18, %zmm29, %zmm21 {%k1}

// CHECK: vpacksswb %zmm18, %zmm29, %zmm21 {%k1} {z}
// CHECK:  encoding: [0x62,0xa1,0x15,0xc1,0x63,0xea]
          vpacksswb %zmm18, %zmm29, %zmm21 {%k1} {z}

// CHECK: vpacksswb (%rcx), %zmm29, %zmm21
// CHECK:  encoding: [0x62,0xe1,0x15,0x40,0x63,0x29]
          vpacksswb (%rcx), %zmm29, %zmm21

// CHECK: vpacksswb 291(%rax,%r14,8), %zmm29, %zmm21
// CHECK:  encoding: [0x62,0xa1,0x15,0x40,0x63,0xac,0xf0,0x23,0x01,0x00,0x00]
          vpacksswb 291(%rax,%r14,8), %zmm29, %zmm21

// CHECK: vpacksswb 8128(%rdx), %zmm29, %zmm21
// CHECK:  encoding: [0x62,0xe1,0x15,0x40,0x63,0x6a,0x7f]
          vpacksswb 8128(%rdx), %zmm29, %zmm21

// CHECK: vpacksswb 8192(%rdx), %zmm29, %zmm21
// CHECK:  encoding: [0x62,0xe1,0x15,0x40,0x63,0xaa,0x00,0x20,0x00,0x00]
          vpacksswb 8192(%rdx), %zmm29, %zmm21

// CHECK: vpacksswb -8192(%rdx), %zmm29, %zmm21
// CHECK:  encoding: [0x62,0xe1,0x15,0x40,0x63,0x6a,0x80]
          vpacksswb -8192(%rdx), %zmm29, %zmm21

// CHECK: vpacksswb -8256(%rdx), %zmm29, %zmm21
// CHECK:  encoding: [0x62,0xe1,0x15,0x40,0x63,0xaa,0xc0,0xdf,0xff,0xff]
          vpacksswb -8256(%rdx), %zmm29, %zmm21

// CHECK: vpackuswb %zmm28, %zmm24, %zmm28
// CHECK:  encoding: [0x62,0x01,0x3d,0x40,0x67,0xe4]
          vpackuswb %zmm28, %zmm24, %zmm28

// CHECK: vpackuswb %zmm28, %zmm24, %zmm28 {%k6}
// CHECK:  encoding: [0x62,0x01,0x3d,0x46,0x67,0xe4]
          vpackuswb %zmm28, %zmm24, %zmm28 {%k6}

// CHECK: vpackuswb %zmm28, %zmm24, %zmm28 {%k6} {z}
// CHECK:  encoding: [0x62,0x01,0x3d,0xc6,0x67,0xe4]
          vpackuswb %zmm28, %zmm24, %zmm28 {%k6} {z}

// CHECK: vpackuswb (%rcx), %zmm24, %zmm28
// CHECK:  encoding: [0x62,0x61,0x3d,0x40,0x67,0x21]
          vpackuswb (%rcx), %zmm24, %zmm28

// CHECK: vpackuswb 291(%rax,%r14,8), %zmm24, %zmm28
// CHECK:  encoding: [0x62,0x21,0x3d,0x40,0x67,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vpackuswb 291(%rax,%r14,8), %zmm24, %zmm28

// CHECK: vpackuswb 8128(%rdx), %zmm24, %zmm28
// CHECK:  encoding: [0x62,0x61,0x3d,0x40,0x67,0x62,0x7f]
          vpackuswb 8128(%rdx), %zmm24, %zmm28

// CHECK: vpackuswb 8192(%rdx), %zmm24, %zmm28
// CHECK:  encoding: [0x62,0x61,0x3d,0x40,0x67,0xa2,0x00,0x20,0x00,0x00]
          vpackuswb 8192(%rdx), %zmm24, %zmm28

// CHECK: vpackuswb -8192(%rdx), %zmm24, %zmm28
// CHECK:  encoding: [0x62,0x61,0x3d,0x40,0x67,0x62,0x80]
          vpackuswb -8192(%rdx), %zmm24, %zmm28

// CHECK: vpackuswb -8256(%rdx), %zmm24, %zmm28
// CHECK:  encoding: [0x62,0x61,0x3d,0x40,0x67,0xa2,0xc0,0xdf,0xff,0xff]
          vpackuswb -8256(%rdx), %zmm24, %zmm28

// CHECK: vpacksswb %zmm24, %zmm29, %zmm26
// CHECK:  encoding: [0x62,0x01,0x15,0x40,0x63,0xd0]
          vpacksswb %zmm24, %zmm29, %zmm26

// CHECK: vpacksswb %zmm24, %zmm29, %zmm26 {%k6}
// CHECK:  encoding: [0x62,0x01,0x15,0x46,0x63,0xd0]
          vpacksswb %zmm24, %zmm29, %zmm26 {%k6}

// CHECK: vpacksswb %zmm24, %zmm29, %zmm26 {%k6} {z}
// CHECK:  encoding: [0x62,0x01,0x15,0xc6,0x63,0xd0]
          vpacksswb %zmm24, %zmm29, %zmm26 {%k6} {z}

// CHECK: vpacksswb (%rcx), %zmm29, %zmm26
// CHECK:  encoding: [0x62,0x61,0x15,0x40,0x63,0x11]
          vpacksswb (%rcx), %zmm29, %zmm26

// CHECK: vpacksswb 4660(%rax,%r14,8), %zmm29, %zmm26
// CHECK:  encoding: [0x62,0x21,0x15,0x40,0x63,0x94,0xf0,0x34,0x12,0x00,0x00]
          vpacksswb 4660(%rax,%r14,8), %zmm29, %zmm26

// CHECK: vpacksswb 8128(%rdx), %zmm29, %zmm26
// CHECK:  encoding: [0x62,0x61,0x15,0x40,0x63,0x52,0x7f]
          vpacksswb 8128(%rdx), %zmm29, %zmm26

// CHECK: vpacksswb 8192(%rdx), %zmm29, %zmm26
// CHECK:  encoding: [0x62,0x61,0x15,0x40,0x63,0x92,0x00,0x20,0x00,0x00]
          vpacksswb 8192(%rdx), %zmm29, %zmm26

// CHECK: vpacksswb -8192(%rdx), %zmm29, %zmm26
// CHECK:  encoding: [0x62,0x61,0x15,0x40,0x63,0x52,0x80]
          vpacksswb -8192(%rdx), %zmm29, %zmm26

// CHECK: vpacksswb -8256(%rdx), %zmm29, %zmm26
// CHECK:  encoding: [0x62,0x61,0x15,0x40,0x63,0x92,0xc0,0xdf,0xff,0xff]
          vpacksswb -8256(%rdx), %zmm29, %zmm26

// CHECK: vpackuswb %zmm23, %zmm28, %zmm18
// CHECK:  encoding: [0x62,0xa1,0x1d,0x40,0x67,0xd7]
          vpackuswb %zmm23, %zmm28, %zmm18

// CHECK: vpackuswb %zmm23, %zmm28, %zmm18 {%k4}
// CHECK:  encoding: [0x62,0xa1,0x1d,0x44,0x67,0xd7]
          vpackuswb %zmm23, %zmm28, %zmm18 {%k4}

// CHECK: vpackuswb %zmm23, %zmm28, %zmm18 {%k4} {z}
// CHECK:  encoding: [0x62,0xa1,0x1d,0xc4,0x67,0xd7]
          vpackuswb %zmm23, %zmm28, %zmm18 {%k4} {z}

// CHECK: vpackuswb (%rcx), %zmm28, %zmm18
// CHECK:  encoding: [0x62,0xe1,0x1d,0x40,0x67,0x11]
          vpackuswb (%rcx), %zmm28, %zmm18

// CHECK: vpackuswb 4660(%rax,%r14,8), %zmm28, %zmm18
// CHECK:  encoding: [0x62,0xa1,0x1d,0x40,0x67,0x94,0xf0,0x34,0x12,0x00,0x00]
          vpackuswb 4660(%rax,%r14,8), %zmm28, %zmm18

// CHECK: vpackuswb 8128(%rdx), %zmm28, %zmm18
// CHECK:  encoding: [0x62,0xe1,0x1d,0x40,0x67,0x52,0x7f]
          vpackuswb 8128(%rdx), %zmm28, %zmm18

// CHECK: vpackuswb 8192(%rdx), %zmm28, %zmm18
// CHECK:  encoding: [0x62,0xe1,0x1d,0x40,0x67,0x92,0x00,0x20,0x00,0x00]
          vpackuswb 8192(%rdx), %zmm28, %zmm18

// CHECK: vpackuswb -8192(%rdx), %zmm28, %zmm18
// CHECK:  encoding: [0x62,0xe1,0x1d,0x40,0x67,0x52,0x80]
          vpackuswb -8192(%rdx), %zmm28, %zmm18

// CHECK: vpackuswb -8256(%rdx), %zmm28, %zmm18
// CHECK:  encoding: [0x62,0xe1,0x1d,0x40,0x67,0x92,0xc0,0xdf,0xff,0xff]
          vpackuswb -8256(%rdx), %zmm28, %zmm18

// CHECK: vpackssdw %zmm22, %zmm27, %zmm24
// CHECK:  encoding: [0x62,0x21,0x25,0x40,0x6b,0xc6]
          vpackssdw %zmm22, %zmm27, %zmm24

// CHECK: vpackssdw %zmm22, %zmm27, %zmm24 {%k2}
// CHECK:  encoding: [0x62,0x21,0x25,0x42,0x6b,0xc6]
          vpackssdw %zmm22, %zmm27, %zmm24 {%k2}

// CHECK: vpackssdw %zmm22, %zmm27, %zmm24 {%k2} {z}
// CHECK:  encoding: [0x62,0x21,0x25,0xc2,0x6b,0xc6]
          vpackssdw %zmm22, %zmm27, %zmm24 {%k2} {z}

// CHECK: vpackssdw (%rcx), %zmm27, %zmm24
// CHECK:  encoding: [0x62,0x61,0x25,0x40,0x6b,0x01]
          vpackssdw (%rcx), %zmm27, %zmm24

// CHECK: vpackssdw 291(%rax,%r14,8), %zmm27, %zmm24
// CHECK:  encoding: [0x62,0x21,0x25,0x40,0x6b,0x84,0xf0,0x23,0x01,0x00,0x00]
          vpackssdw 291(%rax,%r14,8), %zmm27, %zmm24

// CHECK: vpackssdw (%rcx){1to16}, %zmm27, %zmm24
// CHECK:  encoding: [0x62,0x61,0x25,0x50,0x6b,0x01]
          vpackssdw (%rcx){1to16}, %zmm27, %zmm24

// CHECK: vpackssdw 8128(%rdx), %zmm27, %zmm24
// CHECK:  encoding: [0x62,0x61,0x25,0x40,0x6b,0x42,0x7f]
          vpackssdw 8128(%rdx), %zmm27, %zmm24

// CHECK: vpackssdw 8192(%rdx), %zmm27, %zmm24
// CHECK:  encoding: [0x62,0x61,0x25,0x40,0x6b,0x82,0x00,0x20,0x00,0x00]
          vpackssdw 8192(%rdx), %zmm27, %zmm24

// CHECK: vpackssdw -8192(%rdx), %zmm27, %zmm24
// CHECK:  encoding: [0x62,0x61,0x25,0x40,0x6b,0x42,0x80]
          vpackssdw -8192(%rdx), %zmm27, %zmm24

// CHECK: vpackssdw -8256(%rdx), %zmm27, %zmm24
// CHECK:  encoding: [0x62,0x61,0x25,0x40,0x6b,0x82,0xc0,0xdf,0xff,0xff]
          vpackssdw -8256(%rdx), %zmm27, %zmm24

// CHECK: vpackssdw 508(%rdx){1to16}, %zmm27, %zmm24
// CHECK:  encoding: [0x62,0x61,0x25,0x50,0x6b,0x42,0x7f]
          vpackssdw 508(%rdx){1to16}, %zmm27, %zmm24

// CHECK: vpackssdw 512(%rdx){1to16}, %zmm27, %zmm24
// CHECK:  encoding: [0x62,0x61,0x25,0x50,0x6b,0x82,0x00,0x02,0x00,0x00]
          vpackssdw 512(%rdx){1to16}, %zmm27, %zmm24

// CHECK: vpackssdw -512(%rdx){1to16}, %zmm27, %zmm24
// CHECK:  encoding: [0x62,0x61,0x25,0x50,0x6b,0x42,0x80]
          vpackssdw -512(%rdx){1to16}, %zmm27, %zmm24

// CHECK: vpackssdw -516(%rdx){1to16}, %zmm27, %zmm24
// CHECK:  encoding: [0x62,0x61,0x25,0x50,0x6b,0x82,0xfc,0xfd,0xff,0xff]
          vpackssdw -516(%rdx){1to16}, %zmm27, %zmm24

// CHECK: vpacksswb %zmm23, %zmm18, %zmm28
// CHECK:  encoding: [0x62,0x21,0x6d,0x40,0x63,0xe7]
          vpacksswb %zmm23, %zmm18, %zmm28

// CHECK: vpacksswb %zmm23, %zmm18, %zmm28 {%k3}
// CHECK:  encoding: [0x62,0x21,0x6d,0x43,0x63,0xe7]
          vpacksswb %zmm23, %zmm18, %zmm28 {%k3}

// CHECK: vpacksswb %zmm23, %zmm18, %zmm28 {%k3} {z}
// CHECK:  encoding: [0x62,0x21,0x6d,0xc3,0x63,0xe7]
          vpacksswb %zmm23, %zmm18, %zmm28 {%k3} {z}

// CHECK: vpacksswb (%rcx), %zmm18, %zmm28
// CHECK:  encoding: [0x62,0x61,0x6d,0x40,0x63,0x21]
          vpacksswb (%rcx), %zmm18, %zmm28

// CHECK: vpacksswb 291(%rax,%r14,8), %zmm18, %zmm28
// CHECK:  encoding: [0x62,0x21,0x6d,0x40,0x63,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vpacksswb 291(%rax,%r14,8), %zmm18, %zmm28

// CHECK: vpacksswb 8128(%rdx), %zmm18, %zmm28
// CHECK:  encoding: [0x62,0x61,0x6d,0x40,0x63,0x62,0x7f]
          vpacksswb 8128(%rdx), %zmm18, %zmm28

// CHECK: vpacksswb 8192(%rdx), %zmm18, %zmm28
// CHECK:  encoding: [0x62,0x61,0x6d,0x40,0x63,0xa2,0x00,0x20,0x00,0x00]
          vpacksswb 8192(%rdx), %zmm18, %zmm28

// CHECK: vpacksswb -8192(%rdx), %zmm18, %zmm28
// CHECK:  encoding: [0x62,0x61,0x6d,0x40,0x63,0x62,0x80]
          vpacksswb -8192(%rdx), %zmm18, %zmm28

// CHECK: vpacksswb -8256(%rdx), %zmm18, %zmm28
// CHECK:  encoding: [0x62,0x61,0x6d,0x40,0x63,0xa2,0xc0,0xdf,0xff,0xff]
          vpacksswb -8256(%rdx), %zmm18, %zmm28

// CHECK: vpackusdw %zmm21, %zmm29, %zmm18
// CHECK:  encoding: [0x62,0xa2,0x15,0x40,0x2b,0xd5]
          vpackusdw %zmm21, %zmm29, %zmm18

// CHECK: vpackusdw %zmm21, %zmm29, %zmm18 {%k2}
// CHECK:  encoding: [0x62,0xa2,0x15,0x42,0x2b,0xd5]
          vpackusdw %zmm21, %zmm29, %zmm18 {%k2}

// CHECK: vpackusdw %zmm21, %zmm29, %zmm18 {%k2} {z}
// CHECK:  encoding: [0x62,0xa2,0x15,0xc2,0x2b,0xd5]
          vpackusdw %zmm21, %zmm29, %zmm18 {%k2} {z}

// CHECK: vpackusdw (%rcx), %zmm29, %zmm18
// CHECK:  encoding: [0x62,0xe2,0x15,0x40,0x2b,0x11]
          vpackusdw (%rcx), %zmm29, %zmm18

// CHECK: vpackusdw 291(%rax,%r14,8), %zmm29, %zmm18
// CHECK:  encoding: [0x62,0xa2,0x15,0x40,0x2b,0x94,0xf0,0x23,0x01,0x00,0x00]
          vpackusdw 291(%rax,%r14,8), %zmm29, %zmm18

// CHECK: vpackusdw (%rcx){1to16}, %zmm29, %zmm18
// CHECK:  encoding: [0x62,0xe2,0x15,0x50,0x2b,0x11]
          vpackusdw (%rcx){1to16}, %zmm29, %zmm18

// CHECK: vpackusdw 8128(%rdx), %zmm29, %zmm18
// CHECK:  encoding: [0x62,0xe2,0x15,0x40,0x2b,0x52,0x7f]
          vpackusdw 8128(%rdx), %zmm29, %zmm18

// CHECK: vpackusdw 8192(%rdx), %zmm29, %zmm18
// CHECK:  encoding: [0x62,0xe2,0x15,0x40,0x2b,0x92,0x00,0x20,0x00,0x00]
          vpackusdw 8192(%rdx), %zmm29, %zmm18

// CHECK: vpackusdw -8192(%rdx), %zmm29, %zmm18
// CHECK:  encoding: [0x62,0xe2,0x15,0x40,0x2b,0x52,0x80]
          vpackusdw -8192(%rdx), %zmm29, %zmm18

// CHECK: vpackusdw -8256(%rdx), %zmm29, %zmm18
// CHECK:  encoding: [0x62,0xe2,0x15,0x40,0x2b,0x92,0xc0,0xdf,0xff,0xff]
          vpackusdw -8256(%rdx), %zmm29, %zmm18

// CHECK: vpackusdw 508(%rdx){1to16}, %zmm29, %zmm18
// CHECK:  encoding: [0x62,0xe2,0x15,0x50,0x2b,0x52,0x7f]
          vpackusdw 508(%rdx){1to16}, %zmm29, %zmm18

// CHECK: vpackusdw 512(%rdx){1to16}, %zmm29, %zmm18
// CHECK:  encoding: [0x62,0xe2,0x15,0x50,0x2b,0x92,0x00,0x02,0x00,0x00]
          vpackusdw 512(%rdx){1to16}, %zmm29, %zmm18

// CHECK: vpackusdw -512(%rdx){1to16}, %zmm29, %zmm18
// CHECK:  encoding: [0x62,0xe2,0x15,0x50,0x2b,0x52,0x80]
          vpackusdw -512(%rdx){1to16}, %zmm29, %zmm18

// CHECK: vpackusdw -516(%rdx){1to16}, %zmm29, %zmm18
// CHECK:  encoding: [0x62,0xe2,0x15,0x50,0x2b,0x92,0xfc,0xfd,0xff,0xff]
          vpackusdw -516(%rdx){1to16}, %zmm29, %zmm18

// CHECK: vpackuswb %zmm27, %zmm18, %zmm23
// CHECK:  encoding: [0x62,0x81,0x6d,0x40,0x67,0xfb]
          vpackuswb %zmm27, %zmm18, %zmm23

// CHECK: vpackuswb %zmm27, %zmm18, %zmm23 {%k5}
// CHECK:  encoding: [0x62,0x81,0x6d,0x45,0x67,0xfb]
          vpackuswb %zmm27, %zmm18, %zmm23 {%k5}

// CHECK: vpackuswb %zmm27, %zmm18, %zmm23 {%k5} {z}
// CHECK:  encoding: [0x62,0x81,0x6d,0xc5,0x67,0xfb]
          vpackuswb %zmm27, %zmm18, %zmm23 {%k5} {z}

// CHECK: vpackuswb (%rcx), %zmm18, %zmm23
// CHECK:  encoding: [0x62,0xe1,0x6d,0x40,0x67,0x39]
          vpackuswb (%rcx), %zmm18, %zmm23

// CHECK: vpackuswb 291(%rax,%r14,8), %zmm18, %zmm23
// CHECK:  encoding: [0x62,0xa1,0x6d,0x40,0x67,0xbc,0xf0,0x23,0x01,0x00,0x00]
          vpackuswb 291(%rax,%r14,8), %zmm18, %zmm23

// CHECK: vpackuswb 8128(%rdx), %zmm18, %zmm23
// CHECK:  encoding: [0x62,0xe1,0x6d,0x40,0x67,0x7a,0x7f]
          vpackuswb 8128(%rdx), %zmm18, %zmm23

// CHECK: vpackuswb 8192(%rdx), %zmm18, %zmm23
// CHECK:  encoding: [0x62,0xe1,0x6d,0x40,0x67,0xba,0x00,0x20,0x00,0x00]
          vpackuswb 8192(%rdx), %zmm18, %zmm23

// CHECK: vpackuswb -8192(%rdx), %zmm18, %zmm23
// CHECK:  encoding: [0x62,0xe1,0x6d,0x40,0x67,0x7a,0x80]
          vpackuswb -8192(%rdx), %zmm18, %zmm23

// CHECK: vpackuswb -8256(%rdx), %zmm18, %zmm23
// CHECK:  encoding: [0x62,0xe1,0x6d,0x40,0x67,0xba,0xc0,0xdf,0xff,0xff]
          vpackuswb -8256(%rdx), %zmm18, %zmm23

// CHECK: vpaddsb %zmm20, %zmm19, %zmm19
// CHECK:  encoding: [0x62,0xa1,0x65,0x40,0xec,0xdc]
          vpaddsb %zmm20, %zmm19, %zmm19

// CHECK: vpaddsb %zmm20, %zmm19, %zmm19 {%k6}
// CHECK:  encoding: [0x62,0xa1,0x65,0x46,0xec,0xdc]
          vpaddsb %zmm20, %zmm19, %zmm19 {%k6}

// CHECK: vpaddsb %zmm20, %zmm19, %zmm19 {%k6} {z}
// CHECK:  encoding: [0x62,0xa1,0x65,0xc6,0xec,0xdc]
          vpaddsb %zmm20, %zmm19, %zmm19 {%k6} {z}

// CHECK: vpaddsb (%rcx), %zmm19, %zmm19
// CHECK:  encoding: [0x62,0xe1,0x65,0x40,0xec,0x19]
          vpaddsb (%rcx), %zmm19, %zmm19

// CHECK: vpaddsb 291(%rax,%r14,8), %zmm19, %zmm19
// CHECK:  encoding: [0x62,0xa1,0x65,0x40,0xec,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vpaddsb 291(%rax,%r14,8), %zmm19, %zmm19

// CHECK: vpaddsb 8128(%rdx), %zmm19, %zmm19
// CHECK:  encoding: [0x62,0xe1,0x65,0x40,0xec,0x5a,0x7f]
          vpaddsb 8128(%rdx), %zmm19, %zmm19

// CHECK: vpaddsb 8192(%rdx), %zmm19, %zmm19
// CHECK:  encoding: [0x62,0xe1,0x65,0x40,0xec,0x9a,0x00,0x20,0x00,0x00]
          vpaddsb 8192(%rdx), %zmm19, %zmm19

// CHECK: vpaddsb -8192(%rdx), %zmm19, %zmm19
// CHECK:  encoding: [0x62,0xe1,0x65,0x40,0xec,0x5a,0x80]
          vpaddsb -8192(%rdx), %zmm19, %zmm19

// CHECK: vpaddsb -8256(%rdx), %zmm19, %zmm19
// CHECK:  encoding: [0x62,0xe1,0x65,0x40,0xec,0x9a,0xc0,0xdf,0xff,0xff]
          vpaddsb -8256(%rdx), %zmm19, %zmm19

// CHECK: vpaddsw %zmm22, %zmm19, %zmm20
// CHECK:  encoding: [0x62,0xa1,0x65,0x40,0xed,0xe6]
          vpaddsw %zmm22, %zmm19, %zmm20

// CHECK: vpaddsw %zmm22, %zmm19, %zmm20 {%k2}
// CHECK:  encoding: [0x62,0xa1,0x65,0x42,0xed,0xe6]
          vpaddsw %zmm22, %zmm19, %zmm20 {%k2}

// CHECK: vpaddsw %zmm22, %zmm19, %zmm20 {%k2} {z}
// CHECK:  encoding: [0x62,0xa1,0x65,0xc2,0xed,0xe6]
          vpaddsw %zmm22, %zmm19, %zmm20 {%k2} {z}

// CHECK: vpaddsw (%rcx), %zmm19, %zmm20
// CHECK:  encoding: [0x62,0xe1,0x65,0x40,0xed,0x21]
          vpaddsw (%rcx), %zmm19, %zmm20

// CHECK: vpaddsw 291(%rax,%r14,8), %zmm19, %zmm20
// CHECK:  encoding: [0x62,0xa1,0x65,0x40,0xed,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vpaddsw 291(%rax,%r14,8), %zmm19, %zmm20

// CHECK: vpaddsw 8128(%rdx), %zmm19, %zmm20
// CHECK:  encoding: [0x62,0xe1,0x65,0x40,0xed,0x62,0x7f]
          vpaddsw 8128(%rdx), %zmm19, %zmm20

// CHECK: vpaddsw 8192(%rdx), %zmm19, %zmm20
// CHECK:  encoding: [0x62,0xe1,0x65,0x40,0xed,0xa2,0x00,0x20,0x00,0x00]
          vpaddsw 8192(%rdx), %zmm19, %zmm20

// CHECK: vpaddsw -8192(%rdx), %zmm19, %zmm20
// CHECK:  encoding: [0x62,0xe1,0x65,0x40,0xed,0x62,0x80]
          vpaddsw -8192(%rdx), %zmm19, %zmm20

// CHECK: vpaddsw -8256(%rdx), %zmm19, %zmm20
// CHECK:  encoding: [0x62,0xe1,0x65,0x40,0xed,0xa2,0xc0,0xdf,0xff,0xff]
          vpaddsw -8256(%rdx), %zmm19, %zmm20

// CHECK: vpaddusb %zmm25, %zmm29, %zmm29
// CHECK:  encoding: [0x62,0x01,0x15,0x40,0xdc,0xe9]
          vpaddusb %zmm25, %zmm29, %zmm29

// CHECK: vpaddusb %zmm25, %zmm29, %zmm29 {%k1}
// CHECK:  encoding: [0x62,0x01,0x15,0x41,0xdc,0xe9]
          vpaddusb %zmm25, %zmm29, %zmm29 {%k1}

// CHECK: vpaddusb %zmm25, %zmm29, %zmm29 {%k1} {z}
// CHECK:  encoding: [0x62,0x01,0x15,0xc1,0xdc,0xe9]
          vpaddusb %zmm25, %zmm29, %zmm29 {%k1} {z}

// CHECK: vpaddusb (%rcx), %zmm29, %zmm29
// CHECK:  encoding: [0x62,0x61,0x15,0x40,0xdc,0x29]
          vpaddusb (%rcx), %zmm29, %zmm29

// CHECK: vpaddusb 291(%rax,%r14,8), %zmm29, %zmm29
// CHECK:  encoding: [0x62,0x21,0x15,0x40,0xdc,0xac,0xf0,0x23,0x01,0x00,0x00]
          vpaddusb 291(%rax,%r14,8), %zmm29, %zmm29

// CHECK: vpaddusb 8128(%rdx), %zmm29, %zmm29
// CHECK:  encoding: [0x62,0x61,0x15,0x40,0xdc,0x6a,0x7f]
          vpaddusb 8128(%rdx), %zmm29, %zmm29

// CHECK: vpaddusb 8192(%rdx), %zmm29, %zmm29
// CHECK:  encoding: [0x62,0x61,0x15,0x40,0xdc,0xaa,0x00,0x20,0x00,0x00]
          vpaddusb 8192(%rdx), %zmm29, %zmm29

// CHECK: vpaddusb -8192(%rdx), %zmm29, %zmm29
// CHECK:  encoding: [0x62,0x61,0x15,0x40,0xdc,0x6a,0x80]
          vpaddusb -8192(%rdx), %zmm29, %zmm29

// CHECK: vpaddusb -8256(%rdx), %zmm29, %zmm29
// CHECK:  encoding: [0x62,0x61,0x15,0x40,0xdc,0xaa,0xc0,0xdf,0xff,0xff]
          vpaddusb -8256(%rdx), %zmm29, %zmm29

// CHECK: vpaddusw %zmm17, %zmm25, %zmm21
// CHECK:  encoding: [0x62,0xa1,0x35,0x40,0xdd,0xe9]
          vpaddusw %zmm17, %zmm25, %zmm21

// CHECK: vpaddusw %zmm17, %zmm25, %zmm21 {%k4}
// CHECK:  encoding: [0x62,0xa1,0x35,0x44,0xdd,0xe9]
          vpaddusw %zmm17, %zmm25, %zmm21 {%k4}

// CHECK: vpaddusw %zmm17, %zmm25, %zmm21 {%k4} {z}
// CHECK:  encoding: [0x62,0xa1,0x35,0xc4,0xdd,0xe9]
          vpaddusw %zmm17, %zmm25, %zmm21 {%k4} {z}

// CHECK: vpaddusw (%rcx), %zmm25, %zmm21
// CHECK:  encoding: [0x62,0xe1,0x35,0x40,0xdd,0x29]
          vpaddusw (%rcx), %zmm25, %zmm21

// CHECK: vpaddusw 291(%rax,%r14,8), %zmm25, %zmm21
// CHECK:  encoding: [0x62,0xa1,0x35,0x40,0xdd,0xac,0xf0,0x23,0x01,0x00,0x00]
          vpaddusw 291(%rax,%r14,8), %zmm25, %zmm21

// CHECK: vpaddusw 8128(%rdx), %zmm25, %zmm21
// CHECK:  encoding: [0x62,0xe1,0x35,0x40,0xdd,0x6a,0x7f]
          vpaddusw 8128(%rdx), %zmm25, %zmm21

// CHECK: vpaddusw 8192(%rdx), %zmm25, %zmm21
// CHECK:  encoding: [0x62,0xe1,0x35,0x40,0xdd,0xaa,0x00,0x20,0x00,0x00]
          vpaddusw 8192(%rdx), %zmm25, %zmm21

// CHECK: vpaddusw -8192(%rdx), %zmm25, %zmm21
// CHECK:  encoding: [0x62,0xe1,0x35,0x40,0xdd,0x6a,0x80]
          vpaddusw -8192(%rdx), %zmm25, %zmm21

// CHECK: vpaddusw -8256(%rdx), %zmm25, %zmm21
// CHECK:  encoding: [0x62,0xe1,0x35,0x40,0xdd,0xaa,0xc0,0xdf,0xff,0xff]
          vpaddusw -8256(%rdx), %zmm25, %zmm21

// CHECK: vpsubsb %zmm20, %zmm24, %zmm25
// CHECK:  encoding: [0x62,0x21,0x3d,0x40,0xe8,0xcc]
          vpsubsb %zmm20, %zmm24, %zmm25

// CHECK: vpsubsb %zmm20, %zmm24, %zmm25 {%k2}
// CHECK:  encoding: [0x62,0x21,0x3d,0x42,0xe8,0xcc]
          vpsubsb %zmm20, %zmm24, %zmm25 {%k2}

// CHECK: vpsubsb %zmm20, %zmm24, %zmm25 {%k2} {z}
// CHECK:  encoding: [0x62,0x21,0x3d,0xc2,0xe8,0xcc]
          vpsubsb %zmm20, %zmm24, %zmm25 {%k2} {z}

// CHECK: vpsubsb (%rcx), %zmm24, %zmm25
// CHECK:  encoding: [0x62,0x61,0x3d,0x40,0xe8,0x09]
          vpsubsb (%rcx), %zmm24, %zmm25

// CHECK: vpsubsb 291(%rax,%r14,8), %zmm24, %zmm25
// CHECK:  encoding: [0x62,0x21,0x3d,0x40,0xe8,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vpsubsb 291(%rax,%r14,8), %zmm24, %zmm25

// CHECK: vpsubsb 8128(%rdx), %zmm24, %zmm25
// CHECK:  encoding: [0x62,0x61,0x3d,0x40,0xe8,0x4a,0x7f]
          vpsubsb 8128(%rdx), %zmm24, %zmm25

// CHECK: vpsubsb 8192(%rdx), %zmm24, %zmm25
// CHECK:  encoding: [0x62,0x61,0x3d,0x40,0xe8,0x8a,0x00,0x20,0x00,0x00]
          vpsubsb 8192(%rdx), %zmm24, %zmm25

// CHECK: vpsubsb -8192(%rdx), %zmm24, %zmm25
// CHECK:  encoding: [0x62,0x61,0x3d,0x40,0xe8,0x4a,0x80]
          vpsubsb -8192(%rdx), %zmm24, %zmm25

// CHECK: vpsubsb -8256(%rdx), %zmm24, %zmm25
// CHECK:  encoding: [0x62,0x61,0x3d,0x40,0xe8,0x8a,0xc0,0xdf,0xff,0xff]
          vpsubsb -8256(%rdx), %zmm24, %zmm25

// CHECK: vpsubsw %zmm23, %zmm22, %zmm23
// CHECK:  encoding: [0x62,0xa1,0x4d,0x40,0xe9,0xff]
          vpsubsw %zmm23, %zmm22, %zmm23

// CHECK: vpsubsw %zmm23, %zmm22, %zmm23 {%k3}
// CHECK:  encoding: [0x62,0xa1,0x4d,0x43,0xe9,0xff]
          vpsubsw %zmm23, %zmm22, %zmm23 {%k3}

// CHECK: vpsubsw %zmm23, %zmm22, %zmm23 {%k3} {z}
// CHECK:  encoding: [0x62,0xa1,0x4d,0xc3,0xe9,0xff]
          vpsubsw %zmm23, %zmm22, %zmm23 {%k3} {z}

// CHECK: vpsubsw (%rcx), %zmm22, %zmm23
// CHECK:  encoding: [0x62,0xe1,0x4d,0x40,0xe9,0x39]
          vpsubsw (%rcx), %zmm22, %zmm23

// CHECK: vpsubsw 291(%rax,%r14,8), %zmm22, %zmm23
// CHECK:  encoding: [0x62,0xa1,0x4d,0x40,0xe9,0xbc,0xf0,0x23,0x01,0x00,0x00]
          vpsubsw 291(%rax,%r14,8), %zmm22, %zmm23

// CHECK: vpsubsw 8128(%rdx), %zmm22, %zmm23
// CHECK:  encoding: [0x62,0xe1,0x4d,0x40,0xe9,0x7a,0x7f]
          vpsubsw 8128(%rdx), %zmm22, %zmm23

// CHECK: vpsubsw 8192(%rdx), %zmm22, %zmm23
// CHECK:  encoding: [0x62,0xe1,0x4d,0x40,0xe9,0xba,0x00,0x20,0x00,0x00]
          vpsubsw 8192(%rdx), %zmm22, %zmm23

// CHECK: vpsubsw -8192(%rdx), %zmm22, %zmm23
// CHECK:  encoding: [0x62,0xe1,0x4d,0x40,0xe9,0x7a,0x80]
          vpsubsw -8192(%rdx), %zmm22, %zmm23

// CHECK: vpsubsw -8256(%rdx), %zmm22, %zmm23
// CHECK:  encoding: [0x62,0xe1,0x4d,0x40,0xe9,0xba,0xc0,0xdf,0xff,0xff]
          vpsubsw -8256(%rdx), %zmm22, %zmm23

// CHECK: vpsubusb %zmm22, %zmm21, %zmm24
// CHECK:  encoding: [0x62,0x21,0x55,0x40,0xd8,0xc6]
          vpsubusb %zmm22, %zmm21, %zmm24

// CHECK: vpsubusb %zmm22, %zmm21, %zmm24 {%k4}
// CHECK:  encoding: [0x62,0x21,0x55,0x44,0xd8,0xc6]
          vpsubusb %zmm22, %zmm21, %zmm24 {%k4}

// CHECK: vpsubusb %zmm22, %zmm21, %zmm24 {%k4} {z}
// CHECK:  encoding: [0x62,0x21,0x55,0xc4,0xd8,0xc6]
          vpsubusb %zmm22, %zmm21, %zmm24 {%k4} {z}

// CHECK: vpsubusb (%rcx), %zmm21, %zmm24
// CHECK:  encoding: [0x62,0x61,0x55,0x40,0xd8,0x01]
          vpsubusb (%rcx), %zmm21, %zmm24

// CHECK: vpsubusb 291(%rax,%r14,8), %zmm21, %zmm24
// CHECK:  encoding: [0x62,0x21,0x55,0x40,0xd8,0x84,0xf0,0x23,0x01,0x00,0x00]
          vpsubusb 291(%rax,%r14,8), %zmm21, %zmm24

// CHECK: vpsubusb 8128(%rdx), %zmm21, %zmm24
// CHECK:  encoding: [0x62,0x61,0x55,0x40,0xd8,0x42,0x7f]
          vpsubusb 8128(%rdx), %zmm21, %zmm24

// CHECK: vpsubusb 8192(%rdx), %zmm21, %zmm24
// CHECK:  encoding: [0x62,0x61,0x55,0x40,0xd8,0x82,0x00,0x20,0x00,0x00]
          vpsubusb 8192(%rdx), %zmm21, %zmm24

// CHECK: vpsubusb -8192(%rdx), %zmm21, %zmm24
// CHECK:  encoding: [0x62,0x61,0x55,0x40,0xd8,0x42,0x80]
          vpsubusb -8192(%rdx), %zmm21, %zmm24

// CHECK: vpsubusb -8256(%rdx), %zmm21, %zmm24
// CHECK:  encoding: [0x62,0x61,0x55,0x40,0xd8,0x82,0xc0,0xdf,0xff,0xff]
          vpsubusb -8256(%rdx), %zmm21, %zmm24

// CHECK: vpsubusw %zmm23, %zmm17, %zmm25
// CHECK:  encoding: [0x62,0x21,0x75,0x40,0xd9,0xcf]
          vpsubusw %zmm23, %zmm17, %zmm25

// CHECK: vpsubusw %zmm23, %zmm17, %zmm25 {%k1}
// CHECK:  encoding: [0x62,0x21,0x75,0x41,0xd9,0xcf]
          vpsubusw %zmm23, %zmm17, %zmm25 {%k1}

// CHECK: vpsubusw %zmm23, %zmm17, %zmm25 {%k1} {z}
// CHECK:  encoding: [0x62,0x21,0x75,0xc1,0xd9,0xcf]
          vpsubusw %zmm23, %zmm17, %zmm25 {%k1} {z}

// CHECK: vpsubusw (%rcx), %zmm17, %zmm25
// CHECK:  encoding: [0x62,0x61,0x75,0x40,0xd9,0x09]
          vpsubusw (%rcx), %zmm17, %zmm25

// CHECK: vpsubusw 291(%rax,%r14,8), %zmm17, %zmm25
// CHECK:  encoding: [0x62,0x21,0x75,0x40,0xd9,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vpsubusw 291(%rax,%r14,8), %zmm17, %zmm25

// CHECK: vpsubusw 8128(%rdx), %zmm17, %zmm25
// CHECK:  encoding: [0x62,0x61,0x75,0x40,0xd9,0x4a,0x7f]
          vpsubusw 8128(%rdx), %zmm17, %zmm25

// CHECK: vpsubusw 8192(%rdx), %zmm17, %zmm25
// CHECK:  encoding: [0x62,0x61,0x75,0x40,0xd9,0x8a,0x00,0x20,0x00,0x00]
          vpsubusw 8192(%rdx), %zmm17, %zmm25

// CHECK: vpsubusw -8192(%rdx), %zmm17, %zmm25
// CHECK:  encoding: [0x62,0x61,0x75,0x40,0xd9,0x4a,0x80]
          vpsubusw -8192(%rdx), %zmm17, %zmm25

// CHECK: vpsubusw -8256(%rdx), %zmm17, %zmm25
// CHECK:  encoding: [0x62,0x61,0x75,0x40,0xd9,0x8a,0xc0,0xdf,0xff,0xff]
          vpsubusw -8256(%rdx), %zmm17, %zmm25

// CHECK: vpaddb %zmm26, %zmm29, %zmm21
// CHECK:  encoding: [0x62,0x81,0x15,0x40,0xfc,0xea]
          vpaddb %zmm26, %zmm29, %zmm21

// CHECK: vpaddb %zmm26, %zmm29, %zmm21 {%k5}
// CHECK:  encoding: [0x62,0x81,0x15,0x45,0xfc,0xea]
          vpaddb %zmm26, %zmm29, %zmm21 {%k5}

// CHECK: vpaddb %zmm26, %zmm29, %zmm21 {%k5} {z}
// CHECK:  encoding: [0x62,0x81,0x15,0xc5,0xfc,0xea]
          vpaddb %zmm26, %zmm29, %zmm21 {%k5} {z}

// CHECK: vpaddb (%rcx), %zmm29, %zmm21
// CHECK:  encoding: [0x62,0xe1,0x15,0x40,0xfc,0x29]
          vpaddb (%rcx), %zmm29, %zmm21

// CHECK: vpaddb 4660(%rax,%r14,8), %zmm29, %zmm21
// CHECK:  encoding: [0x62,0xa1,0x15,0x40,0xfc,0xac,0xf0,0x34,0x12,0x00,0x00]
          vpaddb 4660(%rax,%r14,8), %zmm29, %zmm21

// CHECK: vpaddb 8128(%rdx), %zmm29, %zmm21
// CHECK:  encoding: [0x62,0xe1,0x15,0x40,0xfc,0x6a,0x7f]
          vpaddb 8128(%rdx), %zmm29, %zmm21

// CHECK: vpaddb 8192(%rdx), %zmm29, %zmm21
// CHECK:  encoding: [0x62,0xe1,0x15,0x40,0xfc,0xaa,0x00,0x20,0x00,0x00]
          vpaddb 8192(%rdx), %zmm29, %zmm21

// CHECK: vpaddb -8192(%rdx), %zmm29, %zmm21
// CHECK:  encoding: [0x62,0xe1,0x15,0x40,0xfc,0x6a,0x80]
          vpaddb -8192(%rdx), %zmm29, %zmm21

// CHECK: vpaddb -8256(%rdx), %zmm29, %zmm21
// CHECK:  encoding: [0x62,0xe1,0x15,0x40,0xfc,0xaa,0xc0,0xdf,0xff,0xff]
          vpaddb -8256(%rdx), %zmm29, %zmm21

// CHECK: vpaddsb %zmm19, %zmm24, %zmm18
// CHECK:  encoding: [0x62,0xa1,0x3d,0x40,0xec,0xd3]
          vpaddsb %zmm19, %zmm24, %zmm18

// CHECK: vpaddsb %zmm19, %zmm24, %zmm18 {%k1}
// CHECK:  encoding: [0x62,0xa1,0x3d,0x41,0xec,0xd3]
          vpaddsb %zmm19, %zmm24, %zmm18 {%k1}

// CHECK: vpaddsb %zmm19, %zmm24, %zmm18 {%k1} {z}
// CHECK:  encoding: [0x62,0xa1,0x3d,0xc1,0xec,0xd3]
          vpaddsb %zmm19, %zmm24, %zmm18 {%k1} {z}

// CHECK: vpaddsb (%rcx), %zmm24, %zmm18
// CHECK:  encoding: [0x62,0xe1,0x3d,0x40,0xec,0x11]
          vpaddsb (%rcx), %zmm24, %zmm18

// CHECK: vpaddsb 4660(%rax,%r14,8), %zmm24, %zmm18
// CHECK:  encoding: [0x62,0xa1,0x3d,0x40,0xec,0x94,0xf0,0x34,0x12,0x00,0x00]
          vpaddsb 4660(%rax,%r14,8), %zmm24, %zmm18

// CHECK: vpaddsb 8128(%rdx), %zmm24, %zmm18
// CHECK:  encoding: [0x62,0xe1,0x3d,0x40,0xec,0x52,0x7f]
          vpaddsb 8128(%rdx), %zmm24, %zmm18

// CHECK: vpaddsb 8192(%rdx), %zmm24, %zmm18
// CHECK:  encoding: [0x62,0xe1,0x3d,0x40,0xec,0x92,0x00,0x20,0x00,0x00]
          vpaddsb 8192(%rdx), %zmm24, %zmm18

// CHECK: vpaddsb -8192(%rdx), %zmm24, %zmm18
// CHECK:  encoding: [0x62,0xe1,0x3d,0x40,0xec,0x52,0x80]
          vpaddsb -8192(%rdx), %zmm24, %zmm18

// CHECK: vpaddsb -8256(%rdx), %zmm24, %zmm18
// CHECK:  encoding: [0x62,0xe1,0x3d,0x40,0xec,0x92,0xc0,0xdf,0xff,0xff]
          vpaddsb -8256(%rdx), %zmm24, %zmm18

// CHECK: vpaddsw %zmm28, %zmm17, %zmm20
// CHECK:  encoding: [0x62,0x81,0x75,0x40,0xed,0xe4]
          vpaddsw %zmm28, %zmm17, %zmm20

// CHECK: vpaddsw %zmm28, %zmm17, %zmm20 {%k2}
// CHECK:  encoding: [0x62,0x81,0x75,0x42,0xed,0xe4]
          vpaddsw %zmm28, %zmm17, %zmm20 {%k2}

// CHECK: vpaddsw %zmm28, %zmm17, %zmm20 {%k2} {z}
// CHECK:  encoding: [0x62,0x81,0x75,0xc2,0xed,0xe4]
          vpaddsw %zmm28, %zmm17, %zmm20 {%k2} {z}

// CHECK: vpaddsw (%rcx), %zmm17, %zmm20
// CHECK:  encoding: [0x62,0xe1,0x75,0x40,0xed,0x21]
          vpaddsw (%rcx), %zmm17, %zmm20

// CHECK: vpaddsw 4660(%rax,%r14,8), %zmm17, %zmm20
// CHECK:  encoding: [0x62,0xa1,0x75,0x40,0xed,0xa4,0xf0,0x34,0x12,0x00,0x00]
          vpaddsw 4660(%rax,%r14,8), %zmm17, %zmm20

// CHECK: vpaddsw 8128(%rdx), %zmm17, %zmm20
// CHECK:  encoding: [0x62,0xe1,0x75,0x40,0xed,0x62,0x7f]
          vpaddsw 8128(%rdx), %zmm17, %zmm20

// CHECK: vpaddsw 8192(%rdx), %zmm17, %zmm20
// CHECK:  encoding: [0x62,0xe1,0x75,0x40,0xed,0xa2,0x00,0x20,0x00,0x00]
          vpaddsw 8192(%rdx), %zmm17, %zmm20

// CHECK: vpaddsw -8192(%rdx), %zmm17, %zmm20
// CHECK:  encoding: [0x62,0xe1,0x75,0x40,0xed,0x62,0x80]
          vpaddsw -8192(%rdx), %zmm17, %zmm20

// CHECK: vpaddsw -8256(%rdx), %zmm17, %zmm20
// CHECK:  encoding: [0x62,0xe1,0x75,0x40,0xed,0xa2,0xc0,0xdf,0xff,0xff]
          vpaddsw -8256(%rdx), %zmm17, %zmm20

// CHECK: vpaddusb %zmm22, %zmm27, %zmm19
// CHECK:  encoding: [0x62,0xa1,0x25,0x40,0xdc,0xde]
          vpaddusb %zmm22, %zmm27, %zmm19

// CHECK: vpaddusb %zmm22, %zmm27, %zmm19 {%k7}
// CHECK:  encoding: [0x62,0xa1,0x25,0x47,0xdc,0xde]
          vpaddusb %zmm22, %zmm27, %zmm19 {%k7}

// CHECK: vpaddusb %zmm22, %zmm27, %zmm19 {%k7} {z}
// CHECK:  encoding: [0x62,0xa1,0x25,0xc7,0xdc,0xde]
          vpaddusb %zmm22, %zmm27, %zmm19 {%k7} {z}

// CHECK: vpaddusb (%rcx), %zmm27, %zmm19
// CHECK:  encoding: [0x62,0xe1,0x25,0x40,0xdc,0x19]
          vpaddusb (%rcx), %zmm27, %zmm19

// CHECK: vpaddusb 4660(%rax,%r14,8), %zmm27, %zmm19
// CHECK:  encoding: [0x62,0xa1,0x25,0x40,0xdc,0x9c,0xf0,0x34,0x12,0x00,0x00]
          vpaddusb 4660(%rax,%r14,8), %zmm27, %zmm19

// CHECK: vpaddusb 8128(%rdx), %zmm27, %zmm19
// CHECK:  encoding: [0x62,0xe1,0x25,0x40,0xdc,0x5a,0x7f]
          vpaddusb 8128(%rdx), %zmm27, %zmm19

// CHECK: vpaddusb 8192(%rdx), %zmm27, %zmm19
// CHECK:  encoding: [0x62,0xe1,0x25,0x40,0xdc,0x9a,0x00,0x20,0x00,0x00]
          vpaddusb 8192(%rdx), %zmm27, %zmm19

// CHECK: vpaddusb -8192(%rdx), %zmm27, %zmm19
// CHECK:  encoding: [0x62,0xe1,0x25,0x40,0xdc,0x5a,0x80]
          vpaddusb -8192(%rdx), %zmm27, %zmm19

// CHECK: vpaddusb -8256(%rdx), %zmm27, %zmm19
// CHECK:  encoding: [0x62,0xe1,0x25,0x40,0xdc,0x9a,0xc0,0xdf,0xff,0xff]
          vpaddusb -8256(%rdx), %zmm27, %zmm19

// CHECK: vpaddusw %zmm23, %zmm23, %zmm27
// CHECK:  encoding: [0x62,0x21,0x45,0x40,0xdd,0xdf]
          vpaddusw %zmm23, %zmm23, %zmm27

// CHECK: vpaddusw %zmm23, %zmm23, %zmm27 {%k7}
// CHECK:  encoding: [0x62,0x21,0x45,0x47,0xdd,0xdf]
          vpaddusw %zmm23, %zmm23, %zmm27 {%k7}

// CHECK: vpaddusw %zmm23, %zmm23, %zmm27 {%k7} {z}
// CHECK:  encoding: [0x62,0x21,0x45,0xc7,0xdd,0xdf]
          vpaddusw %zmm23, %zmm23, %zmm27 {%k7} {z}

// CHECK: vpaddusw (%rcx), %zmm23, %zmm27
// CHECK:  encoding: [0x62,0x61,0x45,0x40,0xdd,0x19]
          vpaddusw (%rcx), %zmm23, %zmm27

// CHECK: vpaddusw 4660(%rax,%r14,8), %zmm23, %zmm27
// CHECK:  encoding: [0x62,0x21,0x45,0x40,0xdd,0x9c,0xf0,0x34,0x12,0x00,0x00]
          vpaddusw 4660(%rax,%r14,8), %zmm23, %zmm27

// CHECK: vpaddusw 8128(%rdx), %zmm23, %zmm27
// CHECK:  encoding: [0x62,0x61,0x45,0x40,0xdd,0x5a,0x7f]
          vpaddusw 8128(%rdx), %zmm23, %zmm27

// CHECK: vpaddusw 8192(%rdx), %zmm23, %zmm27
// CHECK:  encoding: [0x62,0x61,0x45,0x40,0xdd,0x9a,0x00,0x20,0x00,0x00]
          vpaddusw 8192(%rdx), %zmm23, %zmm27

// CHECK: vpaddusw -8192(%rdx), %zmm23, %zmm27
// CHECK:  encoding: [0x62,0x61,0x45,0x40,0xdd,0x5a,0x80]
          vpaddusw -8192(%rdx), %zmm23, %zmm27

// CHECK: vpaddusw -8256(%rdx), %zmm23, %zmm27
// CHECK:  encoding: [0x62,0x61,0x45,0x40,0xdd,0x9a,0xc0,0xdf,0xff,0xff]
          vpaddusw -8256(%rdx), %zmm23, %zmm27

// CHECK: vpsubsb %zmm18, %zmm28, %zmm17
// CHECK:  encoding: [0x62,0xa1,0x1d,0x40,0xe8,0xca]
          vpsubsb %zmm18, %zmm28, %zmm17

// CHECK: vpsubsb %zmm18, %zmm28, %zmm17 {%k5}
// CHECK:  encoding: [0x62,0xa1,0x1d,0x45,0xe8,0xca]
          vpsubsb %zmm18, %zmm28, %zmm17 {%k5}

// CHECK: vpsubsb %zmm18, %zmm28, %zmm17 {%k5} {z}
// CHECK:  encoding: [0x62,0xa1,0x1d,0xc5,0xe8,0xca]
          vpsubsb %zmm18, %zmm28, %zmm17 {%k5} {z}

// CHECK: vpsubsb (%rcx), %zmm28, %zmm17
// CHECK:  encoding: [0x62,0xe1,0x1d,0x40,0xe8,0x09]
          vpsubsb (%rcx), %zmm28, %zmm17

// CHECK: vpsubsb 4660(%rax,%r14,8), %zmm28, %zmm17
// CHECK:  encoding: [0x62,0xa1,0x1d,0x40,0xe8,0x8c,0xf0,0x34,0x12,0x00,0x00]
          vpsubsb 4660(%rax,%r14,8), %zmm28, %zmm17

// CHECK: vpsubsb 8128(%rdx), %zmm28, %zmm17
// CHECK:  encoding: [0x62,0xe1,0x1d,0x40,0xe8,0x4a,0x7f]
          vpsubsb 8128(%rdx), %zmm28, %zmm17

// CHECK: vpsubsb 8192(%rdx), %zmm28, %zmm17
// CHECK:  encoding: [0x62,0xe1,0x1d,0x40,0xe8,0x8a,0x00,0x20,0x00,0x00]
          vpsubsb 8192(%rdx), %zmm28, %zmm17

// CHECK: vpsubsb -8192(%rdx), %zmm28, %zmm17
// CHECK:  encoding: [0x62,0xe1,0x1d,0x40,0xe8,0x4a,0x80]
          vpsubsb -8192(%rdx), %zmm28, %zmm17

// CHECK: vpsubsb -8256(%rdx), %zmm28, %zmm17
// CHECK:  encoding: [0x62,0xe1,0x1d,0x40,0xe8,0x8a,0xc0,0xdf,0xff,0xff]
          vpsubsb -8256(%rdx), %zmm28, %zmm17

// CHECK: vpsubsw %zmm26, %zmm24, %zmm30
// CHECK:  encoding: [0x62,0x01,0x3d,0x40,0xe9,0xf2]
          vpsubsw %zmm26, %zmm24, %zmm30

// CHECK: vpsubsw %zmm26, %zmm24, %zmm30 {%k3}
// CHECK:  encoding: [0x62,0x01,0x3d,0x43,0xe9,0xf2]
          vpsubsw %zmm26, %zmm24, %zmm30 {%k3}

// CHECK: vpsubsw %zmm26, %zmm24, %zmm30 {%k3} {z}
// CHECK:  encoding: [0x62,0x01,0x3d,0xc3,0xe9,0xf2]
          vpsubsw %zmm26, %zmm24, %zmm30 {%k3} {z}

// CHECK: vpsubsw (%rcx), %zmm24, %zmm30
// CHECK:  encoding: [0x62,0x61,0x3d,0x40,0xe9,0x31]
          vpsubsw (%rcx), %zmm24, %zmm30

// CHECK: vpsubsw 4660(%rax,%r14,8), %zmm24, %zmm30
// CHECK:  encoding: [0x62,0x21,0x3d,0x40,0xe9,0xb4,0xf0,0x34,0x12,0x00,0x00]
          vpsubsw 4660(%rax,%r14,8), %zmm24, %zmm30

// CHECK: vpsubsw 8128(%rdx), %zmm24, %zmm30
// CHECK:  encoding: [0x62,0x61,0x3d,0x40,0xe9,0x72,0x7f]
          vpsubsw 8128(%rdx), %zmm24, %zmm30

// CHECK: vpsubsw 8192(%rdx), %zmm24, %zmm30
// CHECK:  encoding: [0x62,0x61,0x3d,0x40,0xe9,0xb2,0x00,0x20,0x00,0x00]
          vpsubsw 8192(%rdx), %zmm24, %zmm30

// CHECK: vpsubsw -8192(%rdx), %zmm24, %zmm30
// CHECK:  encoding: [0x62,0x61,0x3d,0x40,0xe9,0x72,0x80]
          vpsubsw -8192(%rdx), %zmm24, %zmm30

// CHECK: vpsubsw -8256(%rdx), %zmm24, %zmm30
// CHECK:  encoding: [0x62,0x61,0x3d,0x40,0xe9,0xb2,0xc0,0xdf,0xff,0xff]
          vpsubsw -8256(%rdx), %zmm24, %zmm30

// CHECK: vpsubusb %zmm28, %zmm29, %zmm28
// CHECK:  encoding: [0x62,0x01,0x15,0x40,0xd8,0xe4]
          vpsubusb %zmm28, %zmm29, %zmm28

// CHECK: vpsubusb %zmm28, %zmm29, %zmm28 {%k2}
// CHECK:  encoding: [0x62,0x01,0x15,0x42,0xd8,0xe4]
          vpsubusb %zmm28, %zmm29, %zmm28 {%k2}

// CHECK: vpsubusb %zmm28, %zmm29, %zmm28 {%k2} {z}
// CHECK:  encoding: [0x62,0x01,0x15,0xc2,0xd8,0xe4]
          vpsubusb %zmm28, %zmm29, %zmm28 {%k2} {z}

// CHECK: vpsubusb (%rcx), %zmm29, %zmm28
// CHECK:  encoding: [0x62,0x61,0x15,0x40,0xd8,0x21]
          vpsubusb (%rcx), %zmm29, %zmm28

// CHECK: vpsubusb 4660(%rax,%r14,8), %zmm29, %zmm28
// CHECK:  encoding: [0x62,0x21,0x15,0x40,0xd8,0xa4,0xf0,0x34,0x12,0x00,0x00]
          vpsubusb 4660(%rax,%r14,8), %zmm29, %zmm28

// CHECK: vpsubusb 8128(%rdx), %zmm29, %zmm28
// CHECK:  encoding: [0x62,0x61,0x15,0x40,0xd8,0x62,0x7f]
          vpsubusb 8128(%rdx), %zmm29, %zmm28

// CHECK: vpsubusb 8192(%rdx), %zmm29, %zmm28
// CHECK:  encoding: [0x62,0x61,0x15,0x40,0xd8,0xa2,0x00,0x20,0x00,0x00]
          vpsubusb 8192(%rdx), %zmm29, %zmm28

// CHECK: vpsubusb -8192(%rdx), %zmm29, %zmm28
// CHECK:  encoding: [0x62,0x61,0x15,0x40,0xd8,0x62,0x80]
          vpsubusb -8192(%rdx), %zmm29, %zmm28

// CHECK: vpsubusb -8256(%rdx), %zmm29, %zmm28
// CHECK:  encoding: [0x62,0x61,0x15,0x40,0xd8,0xa2,0xc0,0xdf,0xff,0xff]
          vpsubusb -8256(%rdx), %zmm29, %zmm28

// CHECK: vpsubusw %zmm19, %zmm28, %zmm22
// CHECK:  encoding: [0x62,0xa1,0x1d,0x40,0xd9,0xf3]
          vpsubusw %zmm19, %zmm28, %zmm22

// CHECK: vpsubusw %zmm19, %zmm28, %zmm22 {%k5}
// CHECK:  encoding: [0x62,0xa1,0x1d,0x45,0xd9,0xf3]
          vpsubusw %zmm19, %zmm28, %zmm22 {%k5}

// CHECK: vpsubusw %zmm19, %zmm28, %zmm22 {%k5} {z}
// CHECK:  encoding: [0x62,0xa1,0x1d,0xc5,0xd9,0xf3]
          vpsubusw %zmm19, %zmm28, %zmm22 {%k5} {z}

// CHECK: vpsubusw (%rcx), %zmm28, %zmm22
// CHECK:  encoding: [0x62,0xe1,0x1d,0x40,0xd9,0x31]
          vpsubusw (%rcx), %zmm28, %zmm22

// CHECK: vpsubusw 4660(%rax,%r14,8), %zmm28, %zmm22
// CHECK:  encoding: [0x62,0xa1,0x1d,0x40,0xd9,0xb4,0xf0,0x34,0x12,0x00,0x00]
          vpsubusw 4660(%rax,%r14,8), %zmm28, %zmm22

// CHECK: vpsubusw 8128(%rdx), %zmm28, %zmm22
// CHECK:  encoding: [0x62,0xe1,0x1d,0x40,0xd9,0x72,0x7f]
          vpsubusw 8128(%rdx), %zmm28, %zmm22

// CHECK: vpsubusw 8192(%rdx), %zmm28, %zmm22
// CHECK:  encoding: [0x62,0xe1,0x1d,0x40,0xd9,0xb2,0x00,0x20,0x00,0x00]
          vpsubusw 8192(%rdx), %zmm28, %zmm22

// CHECK: vpsubusw -8192(%rdx), %zmm28, %zmm22
// CHECK:  encoding: [0x62,0xe1,0x1d,0x40,0xd9,0x72,0x80]
          vpsubusw -8192(%rdx), %zmm28, %zmm22

// CHECK: vpsubusw -8256(%rdx), %zmm28, %zmm22
// CHECK:  encoding: [0x62,0xe1,0x1d,0x40,0xd9,0xb2,0xc0,0xdf,0xff,0xff]
          vpsubusw -8256(%rdx), %zmm28, %zmm22

// CHECK: vpaddsb %zmm25, %zmm19, %zmm28
// CHECK:  encoding: [0x62,0x01,0x65,0x40,0xec,0xe1]
          vpaddsb %zmm25, %zmm19, %zmm28

// CHECK: vpaddsb %zmm25, %zmm19, %zmm28 {%k4}
// CHECK:  encoding: [0x62,0x01,0x65,0x44,0xec,0xe1]
          vpaddsb %zmm25, %zmm19, %zmm28 {%k4}

// CHECK: vpaddsb %zmm25, %zmm19, %zmm28 {%k4} {z}
// CHECK:  encoding: [0x62,0x01,0x65,0xc4,0xec,0xe1]
          vpaddsb %zmm25, %zmm19, %zmm28 {%k4} {z}

// CHECK: vpaddsb (%rcx), %zmm19, %zmm28
// CHECK:  encoding: [0x62,0x61,0x65,0x40,0xec,0x21]
          vpaddsb (%rcx), %zmm19, %zmm28

// CHECK: vpaddsb 291(%rax,%r14,8), %zmm19, %zmm28
// CHECK:  encoding: [0x62,0x21,0x65,0x40,0xec,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vpaddsb 291(%rax,%r14,8), %zmm19, %zmm28

// CHECK: vpaddsb 8128(%rdx), %zmm19, %zmm28
// CHECK:  encoding: [0x62,0x61,0x65,0x40,0xec,0x62,0x7f]
          vpaddsb 8128(%rdx), %zmm19, %zmm28

// CHECK: vpaddsb 8192(%rdx), %zmm19, %zmm28
// CHECK:  encoding: [0x62,0x61,0x65,0x40,0xec,0xa2,0x00,0x20,0x00,0x00]
          vpaddsb 8192(%rdx), %zmm19, %zmm28

// CHECK: vpaddsb -8192(%rdx), %zmm19, %zmm28
// CHECK:  encoding: [0x62,0x61,0x65,0x40,0xec,0x62,0x80]
          vpaddsb -8192(%rdx), %zmm19, %zmm28

// CHECK: vpaddsb -8256(%rdx), %zmm19, %zmm28
// CHECK:  encoding: [0x62,0x61,0x65,0x40,0xec,0xa2,0xc0,0xdf,0xff,0xff]
          vpaddsb -8256(%rdx), %zmm19, %zmm28

// CHECK: vpaddsw %zmm20, %zmm22, %zmm20
// CHECK:  encoding: [0x62,0xa1,0x4d,0x40,0xed,0xe4]
          vpaddsw %zmm20, %zmm22, %zmm20

// CHECK: vpaddsw %zmm20, %zmm22, %zmm20 {%k7}
// CHECK:  encoding: [0x62,0xa1,0x4d,0x47,0xed,0xe4]
          vpaddsw %zmm20, %zmm22, %zmm20 {%k7}

// CHECK: vpaddsw %zmm20, %zmm22, %zmm20 {%k7} {z}
// CHECK:  encoding: [0x62,0xa1,0x4d,0xc7,0xed,0xe4]
          vpaddsw %zmm20, %zmm22, %zmm20 {%k7} {z}

// CHECK: vpaddsw (%rcx), %zmm22, %zmm20
// CHECK:  encoding: [0x62,0xe1,0x4d,0x40,0xed,0x21]
          vpaddsw (%rcx), %zmm22, %zmm20

// CHECK: vpaddsw 291(%rax,%r14,8), %zmm22, %zmm20
// CHECK:  encoding: [0x62,0xa1,0x4d,0x40,0xed,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vpaddsw 291(%rax,%r14,8), %zmm22, %zmm20

// CHECK: vpaddsw 8128(%rdx), %zmm22, %zmm20
// CHECK:  encoding: [0x62,0xe1,0x4d,0x40,0xed,0x62,0x7f]
          vpaddsw 8128(%rdx), %zmm22, %zmm20

// CHECK: vpaddsw 8192(%rdx), %zmm22, %zmm20
// CHECK:  encoding: [0x62,0xe1,0x4d,0x40,0xed,0xa2,0x00,0x20,0x00,0x00]
          vpaddsw 8192(%rdx), %zmm22, %zmm20

// CHECK: vpaddsw -8192(%rdx), %zmm22, %zmm20
// CHECK:  encoding: [0x62,0xe1,0x4d,0x40,0xed,0x62,0x80]
          vpaddsw -8192(%rdx), %zmm22, %zmm20

// CHECK: vpaddsw -8256(%rdx), %zmm22, %zmm20
// CHECK:  encoding: [0x62,0xe1,0x4d,0x40,0xed,0xa2,0xc0,0xdf,0xff,0xff]
          vpaddsw -8256(%rdx), %zmm22, %zmm20

// CHECK: vpaddusb %zmm17, %zmm27, %zmm26
// CHECK:  encoding: [0x62,0x21,0x25,0x40,0xdc,0xd1]
          vpaddusb %zmm17, %zmm27, %zmm26

// CHECK: vpaddusb %zmm17, %zmm27, %zmm26 {%k3}
// CHECK:  encoding: [0x62,0x21,0x25,0x43,0xdc,0xd1]
          vpaddusb %zmm17, %zmm27, %zmm26 {%k3}

// CHECK: vpaddusb %zmm17, %zmm27, %zmm26 {%k3} {z}
// CHECK:  encoding: [0x62,0x21,0x25,0xc3,0xdc,0xd1]
          vpaddusb %zmm17, %zmm27, %zmm26 {%k3} {z}

// CHECK: vpaddusb (%rcx), %zmm27, %zmm26
// CHECK:  encoding: [0x62,0x61,0x25,0x40,0xdc,0x11]
          vpaddusb (%rcx), %zmm27, %zmm26

// CHECK: vpaddusb 291(%rax,%r14,8), %zmm27, %zmm26
// CHECK:  encoding: [0x62,0x21,0x25,0x40,0xdc,0x94,0xf0,0x23,0x01,0x00,0x00]
          vpaddusb 291(%rax,%r14,8), %zmm27, %zmm26

// CHECK: vpaddusb 8128(%rdx), %zmm27, %zmm26
// CHECK:  encoding: [0x62,0x61,0x25,0x40,0xdc,0x52,0x7f]
          vpaddusb 8128(%rdx), %zmm27, %zmm26

// CHECK: vpaddusb 8192(%rdx), %zmm27, %zmm26
// CHECK:  encoding: [0x62,0x61,0x25,0x40,0xdc,0x92,0x00,0x20,0x00,0x00]
          vpaddusb 8192(%rdx), %zmm27, %zmm26

// CHECK: vpaddusb -8192(%rdx), %zmm27, %zmm26
// CHECK:  encoding: [0x62,0x61,0x25,0x40,0xdc,0x52,0x80]
          vpaddusb -8192(%rdx), %zmm27, %zmm26

// CHECK: vpaddusb -8256(%rdx), %zmm27, %zmm26
// CHECK:  encoding: [0x62,0x61,0x25,0x40,0xdc,0x92,0xc0,0xdf,0xff,0xff]
          vpaddusb -8256(%rdx), %zmm27, %zmm26

// CHECK: vpaddusw %zmm20, %zmm22, %zmm21
// CHECK:  encoding: [0x62,0xa1,0x4d,0x40,0xdd,0xec]
          vpaddusw %zmm20, %zmm22, %zmm21

// CHECK: vpaddusw %zmm20, %zmm22, %zmm21 {%k7}
// CHECK:  encoding: [0x62,0xa1,0x4d,0x47,0xdd,0xec]
          vpaddusw %zmm20, %zmm22, %zmm21 {%k7}

// CHECK: vpaddusw %zmm20, %zmm22, %zmm21 {%k7} {z}
// CHECK:  encoding: [0x62,0xa1,0x4d,0xc7,0xdd,0xec]
          vpaddusw %zmm20, %zmm22, %zmm21 {%k7} {z}

// CHECK: vpaddusw (%rcx), %zmm22, %zmm21
// CHECK:  encoding: [0x62,0xe1,0x4d,0x40,0xdd,0x29]
          vpaddusw (%rcx), %zmm22, %zmm21

// CHECK: vpaddusw 291(%rax,%r14,8), %zmm22, %zmm21
// CHECK:  encoding: [0x62,0xa1,0x4d,0x40,0xdd,0xac,0xf0,0x23,0x01,0x00,0x00]
          vpaddusw 291(%rax,%r14,8), %zmm22, %zmm21

// CHECK: vpaddusw 8128(%rdx), %zmm22, %zmm21
// CHECK:  encoding: [0x62,0xe1,0x4d,0x40,0xdd,0x6a,0x7f]
          vpaddusw 8128(%rdx), %zmm22, %zmm21

// CHECK: vpaddusw 8192(%rdx), %zmm22, %zmm21
// CHECK:  encoding: [0x62,0xe1,0x4d,0x40,0xdd,0xaa,0x00,0x20,0x00,0x00]
          vpaddusw 8192(%rdx), %zmm22, %zmm21

// CHECK: vpaddusw -8192(%rdx), %zmm22, %zmm21
// CHECK:  encoding: [0x62,0xe1,0x4d,0x40,0xdd,0x6a,0x80]
          vpaddusw -8192(%rdx), %zmm22, %zmm21

// CHECK: vpaddusw -8256(%rdx), %zmm22, %zmm21
// CHECK:  encoding: [0x62,0xe1,0x4d,0x40,0xdd,0xaa,0xc0,0xdf,0xff,0xff]
          vpaddusw -8256(%rdx), %zmm22, %zmm21

// CHECK: vpsubsb %zmm28, %zmm21, %zmm19
// CHECK:  encoding: [0x62,0x81,0x55,0x40,0xe8,0xdc]
          vpsubsb %zmm28, %zmm21, %zmm19

// CHECK: vpsubsb %zmm28, %zmm21, %zmm19 {%k2}
// CHECK:  encoding: [0x62,0x81,0x55,0x42,0xe8,0xdc]
          vpsubsb %zmm28, %zmm21, %zmm19 {%k2}

// CHECK: vpsubsb %zmm28, %zmm21, %zmm19 {%k2} {z}
// CHECK:  encoding: [0x62,0x81,0x55,0xc2,0xe8,0xdc]
          vpsubsb %zmm28, %zmm21, %zmm19 {%k2} {z}

// CHECK: vpsubsb (%rcx), %zmm21, %zmm19
// CHECK:  encoding: [0x62,0xe1,0x55,0x40,0xe8,0x19]
          vpsubsb (%rcx), %zmm21, %zmm19

// CHECK: vpsubsb 291(%rax,%r14,8), %zmm21, %zmm19
// CHECK:  encoding: [0x62,0xa1,0x55,0x40,0xe8,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vpsubsb 291(%rax,%r14,8), %zmm21, %zmm19

// CHECK: vpsubsb 8128(%rdx), %zmm21, %zmm19
// CHECK:  encoding: [0x62,0xe1,0x55,0x40,0xe8,0x5a,0x7f]
          vpsubsb 8128(%rdx), %zmm21, %zmm19

// CHECK: vpsubsb 8192(%rdx), %zmm21, %zmm19
// CHECK:  encoding: [0x62,0xe1,0x55,0x40,0xe8,0x9a,0x00,0x20,0x00,0x00]
          vpsubsb 8192(%rdx), %zmm21, %zmm19

// CHECK: vpsubsb -8192(%rdx), %zmm21, %zmm19
// CHECK:  encoding: [0x62,0xe1,0x55,0x40,0xe8,0x5a,0x80]
          vpsubsb -8192(%rdx), %zmm21, %zmm19

// CHECK: vpsubsb -8256(%rdx), %zmm21, %zmm19
// CHECK:  encoding: [0x62,0xe1,0x55,0x40,0xe8,0x9a,0xc0,0xdf,0xff,0xff]
          vpsubsb -8256(%rdx), %zmm21, %zmm19

// CHECK: vpsubsw %zmm23, %zmm23, %zmm23
// CHECK:  encoding: [0x62,0xa1,0x45,0x40,0xe9,0xff]
          vpsubsw %zmm23, %zmm23, %zmm23

// CHECK: vpsubsw %zmm23, %zmm23, %zmm23 {%k6}
// CHECK:  encoding: [0x62,0xa1,0x45,0x46,0xe9,0xff]
          vpsubsw %zmm23, %zmm23, %zmm23 {%k6}

// CHECK: vpsubsw %zmm23, %zmm23, %zmm23 {%k6} {z}
// CHECK:  encoding: [0x62,0xa1,0x45,0xc6,0xe9,0xff]
          vpsubsw %zmm23, %zmm23, %zmm23 {%k6} {z}

// CHECK: vpsubsw (%rcx), %zmm23, %zmm23
// CHECK:  encoding: [0x62,0xe1,0x45,0x40,0xe9,0x39]
          vpsubsw (%rcx), %zmm23, %zmm23

// CHECK: vpsubsw 291(%rax,%r14,8), %zmm23, %zmm23
// CHECK:  encoding: [0x62,0xa1,0x45,0x40,0xe9,0xbc,0xf0,0x23,0x01,0x00,0x00]
          vpsubsw 291(%rax,%r14,8), %zmm23, %zmm23

// CHECK: vpsubsw 8128(%rdx), %zmm23, %zmm23
// CHECK:  encoding: [0x62,0xe1,0x45,0x40,0xe9,0x7a,0x7f]
          vpsubsw 8128(%rdx), %zmm23, %zmm23

// CHECK: vpsubsw 8192(%rdx), %zmm23, %zmm23
// CHECK:  encoding: [0x62,0xe1,0x45,0x40,0xe9,0xba,0x00,0x20,0x00,0x00]
          vpsubsw 8192(%rdx), %zmm23, %zmm23

// CHECK: vpsubsw -8192(%rdx), %zmm23, %zmm23
// CHECK:  encoding: [0x62,0xe1,0x45,0x40,0xe9,0x7a,0x80]
          vpsubsw -8192(%rdx), %zmm23, %zmm23

// CHECK: vpsubsw -8256(%rdx), %zmm23, %zmm23
// CHECK:  encoding: [0x62,0xe1,0x45,0x40,0xe9,0xba,0xc0,0xdf,0xff,0xff]
          vpsubsw -8256(%rdx), %zmm23, %zmm23

// CHECK: vpsubusb %zmm25, %zmm29, %zmm27
// CHECK:  encoding: [0x62,0x01,0x15,0x40,0xd8,0xd9]
          vpsubusb %zmm25, %zmm29, %zmm27

// CHECK: vpsubusb %zmm25, %zmm29, %zmm27 {%k4}
// CHECK:  encoding: [0x62,0x01,0x15,0x44,0xd8,0xd9]
          vpsubusb %zmm25, %zmm29, %zmm27 {%k4}

// CHECK: vpsubusb %zmm25, %zmm29, %zmm27 {%k4} {z}
// CHECK:  encoding: [0x62,0x01,0x15,0xc4,0xd8,0xd9]
          vpsubusb %zmm25, %zmm29, %zmm27 {%k4} {z}

// CHECK: vpsubusb (%rcx), %zmm29, %zmm27
// CHECK:  encoding: [0x62,0x61,0x15,0x40,0xd8,0x19]
          vpsubusb (%rcx), %zmm29, %zmm27

// CHECK: vpsubusb 291(%rax,%r14,8), %zmm29, %zmm27
// CHECK:  encoding: [0x62,0x21,0x15,0x40,0xd8,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vpsubusb 291(%rax,%r14,8), %zmm29, %zmm27

// CHECK: vpsubusb 8128(%rdx), %zmm29, %zmm27
// CHECK:  encoding: [0x62,0x61,0x15,0x40,0xd8,0x5a,0x7f]
          vpsubusb 8128(%rdx), %zmm29, %zmm27

// CHECK: vpsubusb 8192(%rdx), %zmm29, %zmm27
// CHECK:  encoding: [0x62,0x61,0x15,0x40,0xd8,0x9a,0x00,0x20,0x00,0x00]
          vpsubusb 8192(%rdx), %zmm29, %zmm27

// CHECK: vpsubusb -8192(%rdx), %zmm29, %zmm27
// CHECK:  encoding: [0x62,0x61,0x15,0x40,0xd8,0x5a,0x80]
          vpsubusb -8192(%rdx), %zmm29, %zmm27

// CHECK: vpsubusb -8256(%rdx), %zmm29, %zmm27
// CHECK:  encoding: [0x62,0x61,0x15,0x40,0xd8,0x9a,0xc0,0xdf,0xff,0xff]
          vpsubusb -8256(%rdx), %zmm29, %zmm27

// CHECK: vpsubusw %zmm25, %zmm20, %zmm20
// CHECK:  encoding: [0x62,0x81,0x5d,0x40,0xd9,0xe1]
          vpsubusw %zmm25, %zmm20, %zmm20

// CHECK: vpsubusw %zmm25, %zmm20, %zmm20 {%k6}
// CHECK:  encoding: [0x62,0x81,0x5d,0x46,0xd9,0xe1]
          vpsubusw %zmm25, %zmm20, %zmm20 {%k6}

// CHECK: vpsubusw %zmm25, %zmm20, %zmm20 {%k6} {z}
// CHECK:  encoding: [0x62,0x81,0x5d,0xc6,0xd9,0xe1]
          vpsubusw %zmm25, %zmm20, %zmm20 {%k6} {z}

// CHECK: vpsubusw (%rcx), %zmm20, %zmm20
// CHECK:  encoding: [0x62,0xe1,0x5d,0x40,0xd9,0x21]
          vpsubusw (%rcx), %zmm20, %zmm20

// CHECK: vpsubusw 291(%rax,%r14,8), %zmm20, %zmm20
// CHECK:  encoding: [0x62,0xa1,0x5d,0x40,0xd9,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vpsubusw 291(%rax,%r14,8), %zmm20, %zmm20

// CHECK: vpsubusw 8128(%rdx), %zmm20, %zmm20
// CHECK:  encoding: [0x62,0xe1,0x5d,0x40,0xd9,0x62,0x7f]
          vpsubusw 8128(%rdx), %zmm20, %zmm20

// CHECK: vpsubusw 8192(%rdx), %zmm20, %zmm20
// CHECK:  encoding: [0x62,0xe1,0x5d,0x40,0xd9,0xa2,0x00,0x20,0x00,0x00]
          vpsubusw 8192(%rdx), %zmm20, %zmm20

// CHECK: vpsubusw -8192(%rdx), %zmm20, %zmm20
// CHECK:  encoding: [0x62,0xe1,0x5d,0x40,0xd9,0x62,0x80]
          vpsubusw -8192(%rdx), %zmm20, %zmm20

// CHECK: vpsubusw -8256(%rdx), %zmm20, %zmm20
// CHECK:  encoding: [0x62,0xe1,0x5d,0x40,0xd9,0xa2,0xc0,0xdf,0xff,0xff]
          vpsubusw -8256(%rdx), %zmm20, %zmm20

// CHECK: vpermw %zmm21, %zmm19, %zmm22
// CHECK:  encoding: [0x62,0xa2,0xe5,0x40,0x8d,0xf5]
          vpermw %zmm21, %zmm19, %zmm22

// CHECK: vpermw %zmm21, %zmm19, %zmm22 {%k6}
// CHECK:  encoding: [0x62,0xa2,0xe5,0x46,0x8d,0xf5]
          vpermw %zmm21, %zmm19, %zmm22 {%k6}

// CHECK: vpermw %zmm21, %zmm19, %zmm22 {%k6} {z}
// CHECK:  encoding: [0x62,0xa2,0xe5,0xc6,0x8d,0xf5]
          vpermw %zmm21, %zmm19, %zmm22 {%k6} {z}

// CHECK: vpermw (%rcx), %zmm19, %zmm22
// CHECK:  encoding: [0x62,0xe2,0xe5,0x40,0x8d,0x31]
          vpermw (%rcx), %zmm19, %zmm22

// CHECK: vpermw 291(%rax,%r14,8), %zmm19, %zmm22
// CHECK:  encoding: [0x62,0xa2,0xe5,0x40,0x8d,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vpermw 291(%rax,%r14,8), %zmm19, %zmm22

// CHECK: vpermw 8128(%rdx), %zmm19, %zmm22
// CHECK:  encoding: [0x62,0xe2,0xe5,0x40,0x8d,0x72,0x7f]
          vpermw 8128(%rdx), %zmm19, %zmm22

// CHECK: vpermw 8192(%rdx), %zmm19, %zmm22
// CHECK:  encoding: [0x62,0xe2,0xe5,0x40,0x8d,0xb2,0x00,0x20,0x00,0x00]
          vpermw 8192(%rdx), %zmm19, %zmm22

// CHECK: vpermw -8192(%rdx), %zmm19, %zmm22
// CHECK:  encoding: [0x62,0xe2,0xe5,0x40,0x8d,0x72,0x80]
          vpermw -8192(%rdx), %zmm19, %zmm22

// CHECK: vpermw -8256(%rdx), %zmm19, %zmm22
// CHECK:  encoding: [0x62,0xe2,0xe5,0x40,0x8d,0xb2,0xc0,0xdf,0xff,0xff]
          vpermw -8256(%rdx), %zmm19, %zmm22

// CHECK: vpermi2w %zmm24, %zmm24, %zmm17
// CHECK:  encoding: [0x62,0x82,0xbd,0x40,0x75,0xc8]
          vpermi2w %zmm24, %zmm24, %zmm17

// CHECK: vpermi2w %zmm24, %zmm24, %zmm17 {%k7}
// CHECK:  encoding: [0x62,0x82,0xbd,0x47,0x75,0xc8]
          vpermi2w %zmm24, %zmm24, %zmm17 {%k7}

// CHECK: vpermi2w %zmm24, %zmm24, %zmm17 {%k7} {z}
// CHECK:  encoding: [0x62,0x82,0xbd,0xc7,0x75,0xc8]
          vpermi2w %zmm24, %zmm24, %zmm17 {%k7} {z}

// CHECK: vpermi2w (%rcx), %zmm24, %zmm17
// CHECK:  encoding: [0x62,0xe2,0xbd,0x40,0x75,0x09]
          vpermi2w (%rcx), %zmm24, %zmm17

// CHECK: vpermi2w 291(%rax,%r14,8), %zmm24, %zmm17
// CHECK:  encoding: [0x62,0xa2,0xbd,0x40,0x75,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vpermi2w 291(%rax,%r14,8), %zmm24, %zmm17

// CHECK: vpermi2w 8128(%rdx), %zmm24, %zmm17
// CHECK:  encoding: [0x62,0xe2,0xbd,0x40,0x75,0x4a,0x7f]
          vpermi2w 8128(%rdx), %zmm24, %zmm17

// CHECK: vpermi2w 8192(%rdx), %zmm24, %zmm17
// CHECK:  encoding: [0x62,0xe2,0xbd,0x40,0x75,0x8a,0x00,0x20,0x00,0x00]
          vpermi2w 8192(%rdx), %zmm24, %zmm17

// CHECK: vpermi2w -8192(%rdx), %zmm24, %zmm17
// CHECK:  encoding: [0x62,0xe2,0xbd,0x40,0x75,0x4a,0x80]
          vpermi2w -8192(%rdx), %zmm24, %zmm17

// CHECK: vpermi2w -8256(%rdx), %zmm24, %zmm17
// CHECK:  encoding: [0x62,0xe2,0xbd,0x40,0x75,0x8a,0xc0,0xdf,0xff,0xff]
          vpermi2w -8256(%rdx), %zmm24, %zmm17

// CHECK: vpermt2w %zmm19, %zmm25, %zmm18
// CHECK:  encoding: [0x62,0xa2,0xb5,0x40,0x7d,0xd3]
          vpermt2w %zmm19, %zmm25, %zmm18

// CHECK: vpermt2w %zmm19, %zmm25, %zmm18 {%k2}
// CHECK:  encoding: [0x62,0xa2,0xb5,0x42,0x7d,0xd3]
          vpermt2w %zmm19, %zmm25, %zmm18 {%k2}

// CHECK: vpermt2w %zmm19, %zmm25, %zmm18 {%k2} {z}
// CHECK:  encoding: [0x62,0xa2,0xb5,0xc2,0x7d,0xd3]
          vpermt2w %zmm19, %zmm25, %zmm18 {%k2} {z}

// CHECK: vpermt2w (%rcx), %zmm25, %zmm18
// CHECK:  encoding: [0x62,0xe2,0xb5,0x40,0x7d,0x11]
          vpermt2w (%rcx), %zmm25, %zmm18

// CHECK: vpermt2w 291(%rax,%r14,8), %zmm25, %zmm18
// CHECK:  encoding: [0x62,0xa2,0xb5,0x40,0x7d,0x94,0xf0,0x23,0x01,0x00,0x00]
          vpermt2w 291(%rax,%r14,8), %zmm25, %zmm18

// CHECK: vpermt2w 8128(%rdx), %zmm25, %zmm18
// CHECK:  encoding: [0x62,0xe2,0xb5,0x40,0x7d,0x52,0x7f]
          vpermt2w 8128(%rdx), %zmm25, %zmm18

// CHECK: vpermt2w 8192(%rdx), %zmm25, %zmm18
// CHECK:  encoding: [0x62,0xe2,0xb5,0x40,0x7d,0x92,0x00,0x20,0x00,0x00]
          vpermt2w 8192(%rdx), %zmm25, %zmm18

// CHECK: vpermt2w -8192(%rdx), %zmm25, %zmm18
// CHECK:  encoding: [0x62,0xe2,0xb5,0x40,0x7d,0x52,0x80]
          vpermt2w -8192(%rdx), %zmm25, %zmm18

// CHECK: vpermt2w -8256(%rdx), %zmm25, %zmm18
// CHECK:  encoding: [0x62,0xe2,0xb5,0x40,0x7d,0x92,0xc0,0xdf,0xff,0xff]
          vpermt2w -8256(%rdx), %zmm25, %zmm18

// CHECK: vpavgb %zmm21, %zmm29, %zmm17
// CHECK:  encoding: [0x62,0xa1,0x15,0x40,0xe0,0xcd]
          vpavgb %zmm21, %zmm29, %zmm17

// CHECK: vpavgb %zmm21, %zmm29, %zmm17 {%k2}
// CHECK:  encoding: [0x62,0xa1,0x15,0x42,0xe0,0xcd]
          vpavgb %zmm21, %zmm29, %zmm17 {%k2}

// CHECK: vpavgb %zmm21, %zmm29, %zmm17 {%k2} {z}
// CHECK:  encoding: [0x62,0xa1,0x15,0xc2,0xe0,0xcd]
          vpavgb %zmm21, %zmm29, %zmm17 {%k2} {z}

// CHECK: vpavgb (%rcx), %zmm29, %zmm17
// CHECK:  encoding: [0x62,0xe1,0x15,0x40,0xe0,0x09]
          vpavgb (%rcx), %zmm29, %zmm17

// CHECK: vpavgb 291(%rax,%r14,8), %zmm29, %zmm17
// CHECK:  encoding: [0x62,0xa1,0x15,0x40,0xe0,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vpavgb 291(%rax,%r14,8), %zmm29, %zmm17

// CHECK: vpavgb 8128(%rdx), %zmm29, %zmm17
// CHECK:  encoding: [0x62,0xe1,0x15,0x40,0xe0,0x4a,0x7f]
          vpavgb 8128(%rdx), %zmm29, %zmm17

// CHECK: vpavgb 8192(%rdx), %zmm29, %zmm17
// CHECK:  encoding: [0x62,0xe1,0x15,0x40,0xe0,0x8a,0x00,0x20,0x00,0x00]
          vpavgb 8192(%rdx), %zmm29, %zmm17

// CHECK: vpavgb -8192(%rdx), %zmm29, %zmm17
// CHECK:  encoding: [0x62,0xe1,0x15,0x40,0xe0,0x4a,0x80]
          vpavgb -8192(%rdx), %zmm29, %zmm17

// CHECK: vpavgb -8256(%rdx), %zmm29, %zmm17
// CHECK:  encoding: [0x62,0xe1,0x15,0x40,0xe0,0x8a,0xc0,0xdf,0xff,0xff]
          vpavgb -8256(%rdx), %zmm29, %zmm17

// CHECK: vpavgw %zmm22, %zmm27, %zmm19
// CHECK:  encoding: [0x62,0xa1,0x25,0x40,0xe3,0xde]
          vpavgw %zmm22, %zmm27, %zmm19

// CHECK: vpavgw %zmm22, %zmm27, %zmm19 {%k4}
// CHECK:  encoding: [0x62,0xa1,0x25,0x44,0xe3,0xde]
          vpavgw %zmm22, %zmm27, %zmm19 {%k4}

// CHECK: vpavgw %zmm22, %zmm27, %zmm19 {%k4} {z}
// CHECK:  encoding: [0x62,0xa1,0x25,0xc4,0xe3,0xde]
          vpavgw %zmm22, %zmm27, %zmm19 {%k4} {z}

// CHECK: vpavgw (%rcx), %zmm27, %zmm19
// CHECK:  encoding: [0x62,0xe1,0x25,0x40,0xe3,0x19]
          vpavgw (%rcx), %zmm27, %zmm19

// CHECK: vpavgw 291(%rax,%r14,8), %zmm27, %zmm19
// CHECK:  encoding: [0x62,0xa1,0x25,0x40,0xe3,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vpavgw 291(%rax,%r14,8), %zmm27, %zmm19

// CHECK: vpavgw 8128(%rdx), %zmm27, %zmm19
// CHECK:  encoding: [0x62,0xe1,0x25,0x40,0xe3,0x5a,0x7f]
          vpavgw 8128(%rdx), %zmm27, %zmm19

// CHECK: vpavgw 8192(%rdx), %zmm27, %zmm19
// CHECK:  encoding: [0x62,0xe1,0x25,0x40,0xe3,0x9a,0x00,0x20,0x00,0x00]
          vpavgw 8192(%rdx), %zmm27, %zmm19

// CHECK: vpavgw -8192(%rdx), %zmm27, %zmm19
// CHECK:  encoding: [0x62,0xe1,0x25,0x40,0xe3,0x5a,0x80]
          vpavgw -8192(%rdx), %zmm27, %zmm19

// CHECK: vpavgw -8256(%rdx), %zmm27, %zmm19
// CHECK:  encoding: [0x62,0xe1,0x25,0x40,0xe3,0x9a,0xc0,0xdf,0xff,0xff]
          vpavgw -8256(%rdx), %zmm27, %zmm19

// CHECK: vpavgb %zmm19, %zmm27, %zmm24
// CHECK:  encoding: [0x62,0x21,0x25,0x40,0xe0,0xc3]
          vpavgb %zmm19, %zmm27, %zmm24

// CHECK: vpavgb %zmm19, %zmm27, %zmm24 {%k4}
// CHECK:  encoding: [0x62,0x21,0x25,0x44,0xe0,0xc3]
          vpavgb %zmm19, %zmm27, %zmm24 {%k4}

// CHECK: vpavgb %zmm19, %zmm27, %zmm24 {%k4} {z}
// CHECK:  encoding: [0x62,0x21,0x25,0xc4,0xe0,0xc3]
          vpavgb %zmm19, %zmm27, %zmm24 {%k4} {z}

// CHECK: vpavgb (%rcx), %zmm27, %zmm24
// CHECK:  encoding: [0x62,0x61,0x25,0x40,0xe0,0x01]
          vpavgb (%rcx), %zmm27, %zmm24

// CHECK: vpavgb 291(%rax,%r14,8), %zmm27, %zmm24
// CHECK:  encoding: [0x62,0x21,0x25,0x40,0xe0,0x84,0xf0,0x23,0x01,0x00,0x00]
          vpavgb 291(%rax,%r14,8), %zmm27, %zmm24

// CHECK: vpavgb 8128(%rdx), %zmm27, %zmm24
// CHECK:  encoding: [0x62,0x61,0x25,0x40,0xe0,0x42,0x7f]
          vpavgb 8128(%rdx), %zmm27, %zmm24

// CHECK: vpavgb 8192(%rdx), %zmm27, %zmm24
// CHECK:  encoding: [0x62,0x61,0x25,0x40,0xe0,0x82,0x00,0x20,0x00,0x00]
          vpavgb 8192(%rdx), %zmm27, %zmm24

// CHECK: vpavgb -8192(%rdx), %zmm27, %zmm24
// CHECK:  encoding: [0x62,0x61,0x25,0x40,0xe0,0x42,0x80]
          vpavgb -8192(%rdx), %zmm27, %zmm24

// CHECK: vpavgb -8256(%rdx), %zmm27, %zmm24
// CHECK:  encoding: [0x62,0x61,0x25,0x40,0xe0,0x82,0xc0,0xdf,0xff,0xff]
          vpavgb -8256(%rdx), %zmm27, %zmm24

// CHECK: vpavgw %zmm26, %zmm29, %zmm29
// CHECK:  encoding: [0x62,0x01,0x15,0x40,0xe3,0xea]
          vpavgw %zmm26, %zmm29, %zmm29

// CHECK: vpavgw %zmm26, %zmm29, %zmm29 {%k6}
// CHECK:  encoding: [0x62,0x01,0x15,0x46,0xe3,0xea]
          vpavgw %zmm26, %zmm29, %zmm29 {%k6}

// CHECK: vpavgw %zmm26, %zmm29, %zmm29 {%k6} {z}
// CHECK:  encoding: [0x62,0x01,0x15,0xc6,0xe3,0xea]
          vpavgw %zmm26, %zmm29, %zmm29 {%k6} {z}

// CHECK: vpavgw (%rcx), %zmm29, %zmm29
// CHECK:  encoding: [0x62,0x61,0x15,0x40,0xe3,0x29]
          vpavgw (%rcx), %zmm29, %zmm29

// CHECK: vpavgw 291(%rax,%r14,8), %zmm29, %zmm29
// CHECK:  encoding: [0x62,0x21,0x15,0x40,0xe3,0xac,0xf0,0x23,0x01,0x00,0x00]
          vpavgw 291(%rax,%r14,8), %zmm29, %zmm29

// CHECK: vpavgw 8128(%rdx), %zmm29, %zmm29
// CHECK:  encoding: [0x62,0x61,0x15,0x40,0xe3,0x6a,0x7f]
          vpavgw 8128(%rdx), %zmm29, %zmm29

// CHECK: vpavgw 8192(%rdx), %zmm29, %zmm29
// CHECK:  encoding: [0x62,0x61,0x15,0x40,0xe3,0xaa,0x00,0x20,0x00,0x00]
          vpavgw 8192(%rdx), %zmm29, %zmm29

// CHECK: vpavgw -8192(%rdx), %zmm29, %zmm29
// CHECK:  encoding: [0x62,0x61,0x15,0x40,0xe3,0x6a,0x80]
          vpavgw -8192(%rdx), %zmm29, %zmm29

// CHECK: vpavgw -8256(%rdx), %zmm29, %zmm29
// CHECK:  encoding: [0x62,0x61,0x15,0x40,0xe3,0xaa,0xc0,0xdf,0xff,0xff]
          vpavgw -8256(%rdx), %zmm29, %zmm29

// CHECK: vpshufb %zmm20, %zmm26, %zmm22
// CHECK:  encoding: [0x62,0xa2,0x2d,0x40,0x00,0xf4]
          vpshufb %zmm20, %zmm26, %zmm22

// CHECK: vpshufb %zmm20, %zmm26, %zmm22 {%k7}
// CHECK:  encoding: [0x62,0xa2,0x2d,0x47,0x00,0xf4]
          vpshufb %zmm20, %zmm26, %zmm22 {%k7}

// CHECK: vpshufb %zmm20, %zmm26, %zmm22 {%k7} {z}
// CHECK:  encoding: [0x62,0xa2,0x2d,0xc7,0x00,0xf4]
          vpshufb %zmm20, %zmm26, %zmm22 {%k7} {z}

// CHECK: vpshufb (%rcx), %zmm26, %zmm22
// CHECK:  encoding: [0x62,0xe2,0x2d,0x40,0x00,0x31]
          vpshufb (%rcx), %zmm26, %zmm22

// CHECK: vpshufb 291(%rax,%r14,8), %zmm26, %zmm22
// CHECK:  encoding: [0x62,0xa2,0x2d,0x40,0x00,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vpshufb 291(%rax,%r14,8), %zmm26, %zmm22

// CHECK: vpshufb 8128(%rdx), %zmm26, %zmm22
// CHECK:  encoding: [0x62,0xe2,0x2d,0x40,0x00,0x72,0x7f]
          vpshufb 8128(%rdx), %zmm26, %zmm22

// CHECK: vpshufb 8192(%rdx), %zmm26, %zmm22
// CHECK:  encoding: [0x62,0xe2,0x2d,0x40,0x00,0xb2,0x00,0x20,0x00,0x00]
          vpshufb 8192(%rdx), %zmm26, %zmm22

// CHECK: vpshufb -8192(%rdx), %zmm26, %zmm22
// CHECK:  encoding: [0x62,0xe2,0x2d,0x40,0x00,0x72,0x80]
          vpshufb -8192(%rdx), %zmm26, %zmm22

// CHECK: vpshufb -8256(%rdx), %zmm26, %zmm22
// CHECK:  encoding: [0x62,0xe2,0x2d,0x40,0x00,0xb2,0xc0,0xdf,0xff,0xff]
          vpshufb -8256(%rdx), %zmm26, %zmm22

// CHECK: vpabsb %zmm27, %zmm17
// CHECK:  encoding: [0x62,0x82,0x7d,0x48,0x1c,0xcb]
          vpabsb %zmm27, %zmm17

// CHECK: vpabsb %zmm27, %zmm17 {%k7}
// CHECK:  encoding: [0x62,0x82,0x7d,0x4f,0x1c,0xcb]
          vpabsb %zmm27, %zmm17 {%k7}

// CHECK: vpabsb %zmm27, %zmm17 {%k7} {z}
// CHECK:  encoding: [0x62,0x82,0x7d,0xcf,0x1c,0xcb]
          vpabsb %zmm27, %zmm17 {%k7} {z}

// CHECK: vpabsb (%rcx), %zmm17
// CHECK:  encoding: [0x62,0xe2,0x7d,0x48,0x1c,0x09]
          vpabsb (%rcx), %zmm17

// CHECK: vpabsb 291(%rax,%r14,8), %zmm17
// CHECK:  encoding: [0x62,0xa2,0x7d,0x48,0x1c,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vpabsb 291(%rax,%r14,8), %zmm17

// CHECK: vpabsb 8128(%rdx), %zmm17
// CHECK:  encoding: [0x62,0xe2,0x7d,0x48,0x1c,0x4a,0x7f]
          vpabsb 8128(%rdx), %zmm17

// CHECK: vpabsb 8192(%rdx), %zmm17
// CHECK:  encoding: [0x62,0xe2,0x7d,0x48,0x1c,0x8a,0x00,0x20,0x00,0x00]
          vpabsb 8192(%rdx), %zmm17

// CHECK: vpabsb -8192(%rdx), %zmm17
// CHECK:  encoding: [0x62,0xe2,0x7d,0x48,0x1c,0x4a,0x80]
          vpabsb -8192(%rdx), %zmm17

// CHECK: vpabsb -8256(%rdx), %zmm17
// CHECK:  encoding: [0x62,0xe2,0x7d,0x48,0x1c,0x8a,0xc0,0xdf,0xff,0xff]
          vpabsb -8256(%rdx), %zmm17

// CHECK: vpabsw %zmm24, %zmm30
// CHECK:  encoding: [0x62,0x02,0x7d,0x48,0x1d,0xf0]
          vpabsw %zmm24, %zmm30

// CHECK: vpabsw %zmm24, %zmm30 {%k6}
// CHECK:  encoding: [0x62,0x02,0x7d,0x4e,0x1d,0xf0]
          vpabsw %zmm24, %zmm30 {%k6}

// CHECK: vpabsw %zmm24, %zmm30 {%k6} {z}
// CHECK:  encoding: [0x62,0x02,0x7d,0xce,0x1d,0xf0]
          vpabsw %zmm24, %zmm30 {%k6} {z}

// CHECK: vpabsw (%rcx), %zmm30
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x1d,0x31]
          vpabsw (%rcx), %zmm30

// CHECK: vpabsw 291(%rax,%r14,8), %zmm30
// CHECK:  encoding: [0x62,0x22,0x7d,0x48,0x1d,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vpabsw 291(%rax,%r14,8), %zmm30

// CHECK: vpabsw 8128(%rdx), %zmm30
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x1d,0x72,0x7f]
          vpabsw 8128(%rdx), %zmm30

// CHECK: vpabsw 8192(%rdx), %zmm30
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x1d,0xb2,0x00,0x20,0x00,0x00]
          vpabsw 8192(%rdx), %zmm30

// CHECK: vpabsw -8192(%rdx), %zmm30
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x1d,0x72,0x80]
          vpabsw -8192(%rdx), %zmm30

// CHECK: vpabsw -8256(%rdx), %zmm30
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x1d,0xb2,0xc0,0xdf,0xff,0xff]
          vpabsw -8256(%rdx), %zmm30

// CHECK: vpmovwb %zmm27, %ymm22
// CHECK:  encoding: [0x62,0x22,0x7e,0x48,0x30,0xde]
          vpmovwb %zmm27, %ymm22

// CHECK: vpmovwb %zmm27, %ymm22 {%k1}
// CHECK:  encoding: [0x62,0x22,0x7e,0x49,0x30,0xde]
          vpmovwb %zmm27, %ymm22 {%k1}

// CHECK: vpmovwb %zmm27, %ymm22 {%k1} {z}
// CHECK:  encoding: [0x62,0x22,0x7e,0xc9,0x30,0xde]
          vpmovwb %zmm27, %ymm22 {%k1} {z}

// CHECK: vpmovwb %zmm22, (%rcx)
// CHECK:  encoding: [0x62,0xe2,0x7e,0x48,0x30,0x31]
          vpmovwb %zmm22, (%rcx)

// CHECK: vpmovwb %zmm22, (%rcx) {%k4}
// CHECK:  encoding: [0x62,0xe2,0x7e,0x4c,0x30,0x31]
          vpmovwb %zmm22, (%rcx) {%k4}

// CHECK: vpmovwb %zmm22, 291(%rax,%r14,8)
// CHECK:  encoding: [0x62,0xa2,0x7e,0x48,0x30,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vpmovwb %zmm22, 291(%rax,%r14,8)

// CHECK: vpmovwb %zmm22, 4064(%rdx)
// CHECK:  encoding: [0x62,0xe2,0x7e,0x48,0x30,0x72,0x7f]
          vpmovwb %zmm22, 4064(%rdx)

// CHECK: vpmovwb %zmm22, 4096(%rdx)
// CHECK:  encoding: [0x62,0xe2,0x7e,0x48,0x30,0xb2,0x00,0x10,0x00,0x00]
          vpmovwb %zmm22, 4096(%rdx)

// CHECK: vpmovwb %zmm22, -4096(%rdx)
// CHECK:  encoding: [0x62,0xe2,0x7e,0x48,0x30,0x72,0x80]
          vpmovwb %zmm22, -4096(%rdx)

// CHECK: vpmovwb %zmm22, -4128(%rdx)
// CHECK:  encoding: [0x62,0xe2,0x7e,0x48,0x30,0xb2,0xe0,0xef,0xff,0xff]
          vpmovwb %zmm22, -4128(%rdx)

// CHECK: vpmovswb %zmm18, %ymm23
// CHECK:  encoding: [0x62,0xa2,0x7e,0x48,0x20,0xd7]
          vpmovswb %zmm18, %ymm23

// CHECK: vpmovswb %zmm18, %ymm23 {%k2}
// CHECK:  encoding: [0x62,0xa2,0x7e,0x4a,0x20,0xd7]
          vpmovswb %zmm18, %ymm23 {%k2}

// CHECK: vpmovswb %zmm18, %ymm23 {%k2} {z}
// CHECK:  encoding: [0x62,0xa2,0x7e,0xca,0x20,0xd7]
          vpmovswb %zmm18, %ymm23 {%k2} {z}

// CHECK: vpmovswb %zmm24, (%rcx)
// CHECK:  encoding: [0x62,0x62,0x7e,0x48,0x20,0x01]
          vpmovswb %zmm24, (%rcx)

// CHECK: vpmovswb %zmm24, (%rcx) {%k7}
// CHECK:  encoding: [0x62,0x62,0x7e,0x4f,0x20,0x01]
          vpmovswb %zmm24, (%rcx) {%k7}

// CHECK: vpmovswb %zmm24, 291(%rax,%r14,8)
// CHECK:  encoding: [0x62,0x22,0x7e,0x48,0x20,0x84,0xf0,0x23,0x01,0x00,0x00]
          vpmovswb %zmm24, 291(%rax,%r14,8)

// CHECK: vpmovswb %zmm24, 4064(%rdx)
// CHECK:  encoding: [0x62,0x62,0x7e,0x48,0x20,0x42,0x7f]
          vpmovswb %zmm24, 4064(%rdx)

// CHECK: vpmovswb %zmm24, 4096(%rdx)
// CHECK:  encoding: [0x62,0x62,0x7e,0x48,0x20,0x82,0x00,0x10,0x00,0x00]
          vpmovswb %zmm24, 4096(%rdx)

// CHECK: vpmovswb %zmm24, -4096(%rdx)
// CHECK:  encoding: [0x62,0x62,0x7e,0x48,0x20,0x42,0x80]
          vpmovswb %zmm24, -4096(%rdx)

// CHECK: vpmovswb %zmm24, -4128(%rdx)
// CHECK:  encoding: [0x62,0x62,0x7e,0x48,0x20,0x82,0xe0,0xef,0xff,0xff]
          vpmovswb %zmm24, -4128(%rdx)

// CHECK: vpmovuswb %zmm22, %ymm28
// CHECK:  encoding: [0x62,0x82,0x7e,0x48,0x10,0xf4]
          vpmovuswb %zmm22, %ymm28

// CHECK: vpmovuswb %zmm22, %ymm28 {%k3}
// CHECK:  encoding: [0x62,0x82,0x7e,0x4b,0x10,0xf4]
          vpmovuswb %zmm22, %ymm28 {%k3}

// CHECK: vpmovuswb %zmm22, %ymm28 {%k3} {z}
// CHECK:  encoding: [0x62,0x82,0x7e,0xcb,0x10,0xf4]
          vpmovuswb %zmm22, %ymm28 {%k3} {z}

// CHECK: vpmovuswb %zmm27, (%rcx)
// CHECK:  encoding: [0x62,0x62,0x7e,0x48,0x10,0x19]
          vpmovuswb %zmm27, (%rcx)

// CHECK: vpmovuswb %zmm27, (%rcx) {%k2}
// CHECK:  encoding: [0x62,0x62,0x7e,0x4a,0x10,0x19]
          vpmovuswb %zmm27, (%rcx) {%k2}

// CHECK: vpmovuswb %zmm27, 291(%rax,%r14,8)
// CHECK:  encoding: [0x62,0x22,0x7e,0x48,0x10,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vpmovuswb %zmm27, 291(%rax,%r14,8)

// CHECK: vpmovuswb %zmm27, 4064(%rdx)
// CHECK:  encoding: [0x62,0x62,0x7e,0x48,0x10,0x5a,0x7f]
          vpmovuswb %zmm27, 4064(%rdx)

// CHECK: vpmovuswb %zmm27, 4096(%rdx)
// CHECK:  encoding: [0x62,0x62,0x7e,0x48,0x10,0x9a,0x00,0x10,0x00,0x00]
          vpmovuswb %zmm27, 4096(%rdx)

// CHECK: vpmovuswb %zmm27, -4096(%rdx)
// CHECK:  encoding: [0x62,0x62,0x7e,0x48,0x10,0x5a,0x80]
          vpmovuswb %zmm27, -4096(%rdx)

// CHECK: vpmovuswb %zmm27, -4128(%rdx)
// CHECK:  encoding: [0x62,0x62,0x7e,0x48,0x10,0x9a,0xe0,0xef,0xff,0xff]
          vpmovuswb %zmm27, -4128(%rdx)

// CHECK: vpmulhuw %zmm21, %zmm24, %zmm21
// CHECK:  encoding: [0x62,0xa1,0x3d,0x40,0xe4,0xed]
          vpmulhuw %zmm21, %zmm24, %zmm21

// CHECK: vpmulhuw %zmm21, %zmm24, %zmm21 {%k3}
// CHECK:  encoding: [0x62,0xa1,0x3d,0x43,0xe4,0xed]
          vpmulhuw %zmm21, %zmm24, %zmm21 {%k3}

// CHECK: vpmulhuw %zmm21, %zmm24, %zmm21 {%k3} {z}
// CHECK:  encoding: [0x62,0xa1,0x3d,0xc3,0xe4,0xed]
          vpmulhuw %zmm21, %zmm24, %zmm21 {%k3} {z}

// CHECK: vpmulhuw (%rcx), %zmm24, %zmm21
// CHECK:  encoding: [0x62,0xe1,0x3d,0x40,0xe4,0x29]
          vpmulhuw (%rcx), %zmm24, %zmm21

// CHECK: vpmulhuw 291(%rax,%r14,8), %zmm24, %zmm21
// CHECK:  encoding: [0x62,0xa1,0x3d,0x40,0xe4,0xac,0xf0,0x23,0x01,0x00,0x00]
          vpmulhuw 291(%rax,%r14,8), %zmm24, %zmm21

// CHECK: vpmulhuw 8128(%rdx), %zmm24, %zmm21
// CHECK:  encoding: [0x62,0xe1,0x3d,0x40,0xe4,0x6a,0x7f]
          vpmulhuw 8128(%rdx), %zmm24, %zmm21

// CHECK: vpmulhuw 8192(%rdx), %zmm24, %zmm21
// CHECK:  encoding: [0x62,0xe1,0x3d,0x40,0xe4,0xaa,0x00,0x20,0x00,0x00]
          vpmulhuw 8192(%rdx), %zmm24, %zmm21

// CHECK: vpmulhuw -8192(%rdx), %zmm24, %zmm21
// CHECK:  encoding: [0x62,0xe1,0x3d,0x40,0xe4,0x6a,0x80]
          vpmulhuw -8192(%rdx), %zmm24, %zmm21

// CHECK: vpmulhuw -8256(%rdx), %zmm24, %zmm21
// CHECK:  encoding: [0x62,0xe1,0x3d,0x40,0xe4,0xaa,0xc0,0xdf,0xff,0xff]
          vpmulhuw -8256(%rdx), %zmm24, %zmm21

// CHECK: vpmulhw %zmm27, %zmm26, %zmm30
// CHECK:  encoding: [0x62,0x01,0x2d,0x40,0xe5,0xf3]
          vpmulhw %zmm27, %zmm26, %zmm30

// CHECK: vpmulhw %zmm27, %zmm26, %zmm30 {%k6}
// CHECK:  encoding: [0x62,0x01,0x2d,0x46,0xe5,0xf3]
          vpmulhw %zmm27, %zmm26, %zmm30 {%k6}

// CHECK: vpmulhw %zmm27, %zmm26, %zmm30 {%k6} {z}
// CHECK:  encoding: [0x62,0x01,0x2d,0xc6,0xe5,0xf3]
          vpmulhw %zmm27, %zmm26, %zmm30 {%k6} {z}

// CHECK: vpmulhw (%rcx), %zmm26, %zmm30
// CHECK:  encoding: [0x62,0x61,0x2d,0x40,0xe5,0x31]
          vpmulhw (%rcx), %zmm26, %zmm30

// CHECK: vpmulhw 291(%rax,%r14,8), %zmm26, %zmm30
// CHECK:  encoding: [0x62,0x21,0x2d,0x40,0xe5,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vpmulhw 291(%rax,%r14,8), %zmm26, %zmm30

// CHECK: vpmulhw 8128(%rdx), %zmm26, %zmm30
// CHECK:  encoding: [0x62,0x61,0x2d,0x40,0xe5,0x72,0x7f]
          vpmulhw 8128(%rdx), %zmm26, %zmm30

// CHECK: vpmulhw 8192(%rdx), %zmm26, %zmm30
// CHECK:  encoding: [0x62,0x61,0x2d,0x40,0xe5,0xb2,0x00,0x20,0x00,0x00]
          vpmulhw 8192(%rdx), %zmm26, %zmm30

// CHECK: vpmulhw -8192(%rdx), %zmm26, %zmm30
// CHECK:  encoding: [0x62,0x61,0x2d,0x40,0xe5,0x72,0x80]
          vpmulhw -8192(%rdx), %zmm26, %zmm30

// CHECK: vpmulhw -8256(%rdx), %zmm26, %zmm30
// CHECK:  encoding: [0x62,0x61,0x2d,0x40,0xe5,0xb2,0xc0,0xdf,0xff,0xff]
          vpmulhw -8256(%rdx), %zmm26, %zmm30

// CHECK: vpmulhrsw %zmm25, %zmm27, %zmm21
// CHECK:  encoding: [0x62,0x82,0x25,0x40,0x0b,0xe9]
          vpmulhrsw %zmm25, %zmm27, %zmm21

// CHECK: vpmulhrsw %zmm25, %zmm27, %zmm21 {%k7}
// CHECK:  encoding: [0x62,0x82,0x25,0x47,0x0b,0xe9]
          vpmulhrsw %zmm25, %zmm27, %zmm21 {%k7}

// CHECK: vpmulhrsw %zmm25, %zmm27, %zmm21 {%k7} {z}
// CHECK:  encoding: [0x62,0x82,0x25,0xc7,0x0b,0xe9]
          vpmulhrsw %zmm25, %zmm27, %zmm21 {%k7} {z}

// CHECK: vpmulhrsw (%rcx), %zmm27, %zmm21
// CHECK:  encoding: [0x62,0xe2,0x25,0x40,0x0b,0x29]
          vpmulhrsw (%rcx), %zmm27, %zmm21

// CHECK: vpmulhrsw 291(%rax,%r14,8), %zmm27, %zmm21
// CHECK:  encoding: [0x62,0xa2,0x25,0x40,0x0b,0xac,0xf0,0x23,0x01,0x00,0x00]
          vpmulhrsw 291(%rax,%r14,8), %zmm27, %zmm21

// CHECK: vpmulhrsw 8128(%rdx), %zmm27, %zmm21
// CHECK:  encoding: [0x62,0xe2,0x25,0x40,0x0b,0x6a,0x7f]
          vpmulhrsw 8128(%rdx), %zmm27, %zmm21

// CHECK: vpmulhrsw 8192(%rdx), %zmm27, %zmm21
// CHECK:  encoding: [0x62,0xe2,0x25,0x40,0x0b,0xaa,0x00,0x20,0x00,0x00]
          vpmulhrsw 8192(%rdx), %zmm27, %zmm21

// CHECK: vpmulhrsw -8192(%rdx), %zmm27, %zmm21
// CHECK:  encoding: [0x62,0xe2,0x25,0x40,0x0b,0x6a,0x80]
          vpmulhrsw -8192(%rdx), %zmm27, %zmm21

// CHECK: vpmulhrsw -8256(%rdx), %zmm27, %zmm21
// CHECK:  encoding: [0x62,0xe2,0x25,0x40,0x0b,0xaa,0xc0,0xdf,0xff,0xff]
          vpmulhrsw -8256(%rdx), %zmm27, %zmm21

// CHECK: vpmaddubsw %zmm25, %zmm20, %zmm27
// CHECK:  encoding: [0x62,0x02,0x5d,0x40,0x04,0xd9]
          vpmaddubsw %zmm25, %zmm20, %zmm27

// CHECK: vpmaddubsw %zmm25, %zmm20, %zmm27 {%k3}
// CHECK:  encoding: [0x62,0x02,0x5d,0x43,0x04,0xd9]
          vpmaddubsw %zmm25, %zmm20, %zmm27 {%k3}

// CHECK: vpmaddubsw %zmm25, %zmm20, %zmm27 {%k3} {z}
// CHECK:  encoding: [0x62,0x02,0x5d,0xc3,0x04,0xd9]
          vpmaddubsw %zmm25, %zmm20, %zmm27 {%k3} {z}

// CHECK: vpmaddubsw (%rcx), %zmm20, %zmm27
// CHECK:  encoding: [0x62,0x62,0x5d,0x40,0x04,0x19]
          vpmaddubsw (%rcx), %zmm20, %zmm27

// CHECK: vpmaddubsw 291(%rax,%r14,8), %zmm20, %zmm27
// CHECK:  encoding: [0x62,0x22,0x5d,0x40,0x04,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vpmaddubsw 291(%rax,%r14,8), %zmm20, %zmm27

// CHECK: vpmaddubsw 8128(%rdx), %zmm20, %zmm27
// CHECK:  encoding: [0x62,0x62,0x5d,0x40,0x04,0x5a,0x7f]
          vpmaddubsw 8128(%rdx), %zmm20, %zmm27

// CHECK: vpmaddubsw 8192(%rdx), %zmm20, %zmm27
// CHECK:  encoding: [0x62,0x62,0x5d,0x40,0x04,0x9a,0x00,0x20,0x00,0x00]
          vpmaddubsw 8192(%rdx), %zmm20, %zmm27

// CHECK: vpmaddubsw -8192(%rdx), %zmm20, %zmm27
// CHECK:  encoding: [0x62,0x62,0x5d,0x40,0x04,0x5a,0x80]
          vpmaddubsw -8192(%rdx), %zmm20, %zmm27

// CHECK: vpmaddubsw -8256(%rdx), %zmm20, %zmm27
// CHECK:  encoding: [0x62,0x62,0x5d,0x40,0x04,0x9a,0xc0,0xdf,0xff,0xff]
          vpmaddubsw -8256(%rdx), %zmm20, %zmm27

// CHECK: vpmaddwd %zmm25, %zmm22, %zmm26
// CHECK:  encoding: [0x62,0x01,0x4d,0x40,0xf5,0xd1]
          vpmaddwd %zmm25, %zmm22, %zmm26

// CHECK: vpmaddwd %zmm25, %zmm22, %zmm26 {%k2}
// CHECK:  encoding: [0x62,0x01,0x4d,0x42,0xf5,0xd1]
          vpmaddwd %zmm25, %zmm22, %zmm26 {%k2}

// CHECK: vpmaddwd %zmm25, %zmm22, %zmm26 {%k2} {z}
// CHECK:  encoding: [0x62,0x01,0x4d,0xc2,0xf5,0xd1]
          vpmaddwd %zmm25, %zmm22, %zmm26 {%k2} {z}

// CHECK: vpmaddwd (%rcx), %zmm22, %zmm26
// CHECK:  encoding: [0x62,0x61,0x4d,0x40,0xf5,0x11]
          vpmaddwd (%rcx), %zmm22, %zmm26

// CHECK: vpmaddwd 291(%rax,%r14,8), %zmm22, %zmm26
// CHECK:  encoding: [0x62,0x21,0x4d,0x40,0xf5,0x94,0xf0,0x23,0x01,0x00,0x00]
          vpmaddwd 291(%rax,%r14,8), %zmm22, %zmm26

// CHECK: vpmaddwd 8128(%rdx), %zmm22, %zmm26
// CHECK:  encoding: [0x62,0x61,0x4d,0x40,0xf5,0x52,0x7f]
          vpmaddwd 8128(%rdx), %zmm22, %zmm26

// CHECK: vpmaddwd 8192(%rdx), %zmm22, %zmm26
// CHECK:  encoding: [0x62,0x61,0x4d,0x40,0xf5,0x92,0x00,0x20,0x00,0x00]
          vpmaddwd 8192(%rdx), %zmm22, %zmm26

// CHECK: vpmaddwd -8192(%rdx), %zmm22, %zmm26
// CHECK:  encoding: [0x62,0x61,0x4d,0x40,0xf5,0x52,0x80]
          vpmaddwd -8192(%rdx), %zmm22, %zmm26

// CHECK: vpmaddwd -8256(%rdx), %zmm22, %zmm26
// CHECK:  encoding: [0x62,0x61,0x4d,0x40,0xf5,0x92,0xc0,0xdf,0xff,0xff]
          vpmaddwd -8256(%rdx), %zmm22, %zmm26

// CHECK: vpunpcklbw %zmm24, %zmm17, %zmm28
// CHECK:  encoding: [0x62,0x01,0x75,0x40,0x60,0xe0]
          vpunpcklbw %zmm24, %zmm17, %zmm28

// CHECK: vpunpcklbw %zmm24, %zmm17, %zmm28 {%k1}
// CHECK:  encoding: [0x62,0x01,0x75,0x41,0x60,0xe0]
          vpunpcklbw %zmm24, %zmm17, %zmm28 {%k1}

// CHECK: vpunpcklbw %zmm24, %zmm17, %zmm28 {%k1} {z}
// CHECK:  encoding: [0x62,0x01,0x75,0xc1,0x60,0xe0]
          vpunpcklbw %zmm24, %zmm17, %zmm28 {%k1} {z}

// CHECK: vpunpcklbw (%rcx), %zmm17, %zmm28
// CHECK:  encoding: [0x62,0x61,0x75,0x40,0x60,0x21]
          vpunpcklbw (%rcx), %zmm17, %zmm28

// CHECK: vpunpcklbw 291(%rax,%r14,8), %zmm17, %zmm28
// CHECK:  encoding: [0x62,0x21,0x75,0x40,0x60,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vpunpcklbw 291(%rax,%r14,8), %zmm17, %zmm28

// CHECK: vpunpcklbw 8128(%rdx), %zmm17, %zmm28
// CHECK:  encoding: [0x62,0x61,0x75,0x40,0x60,0x62,0x7f]
          vpunpcklbw 8128(%rdx), %zmm17, %zmm28

// CHECK: vpunpcklbw 8192(%rdx), %zmm17, %zmm28
// CHECK:  encoding: [0x62,0x61,0x75,0x40,0x60,0xa2,0x00,0x20,0x00,0x00]
          vpunpcklbw 8192(%rdx), %zmm17, %zmm28

// CHECK: vpunpcklbw -8192(%rdx), %zmm17, %zmm28
// CHECK:  encoding: [0x62,0x61,0x75,0x40,0x60,0x62,0x80]
          vpunpcklbw -8192(%rdx), %zmm17, %zmm28

// CHECK: vpunpcklbw -8256(%rdx), %zmm17, %zmm28
// CHECK:  encoding: [0x62,0x61,0x75,0x40,0x60,0xa2,0xc0,0xdf,0xff,0xff]
          vpunpcklbw -8256(%rdx), %zmm17, %zmm28

// CHECK: vpunpckhbw %zmm23, %zmm19, %zmm30
// CHECK:  encoding: [0x62,0x21,0x65,0x40,0x68,0xf7]
          vpunpckhbw %zmm23, %zmm19, %zmm30

// CHECK: vpunpckhbw %zmm23, %zmm19, %zmm30 {%k7}
// CHECK:  encoding: [0x62,0x21,0x65,0x47,0x68,0xf7]
          vpunpckhbw %zmm23, %zmm19, %zmm30 {%k7}

// CHECK: vpunpckhbw %zmm23, %zmm19, %zmm30 {%k7} {z}
// CHECK:  encoding: [0x62,0x21,0x65,0xc7,0x68,0xf7]
          vpunpckhbw %zmm23, %zmm19, %zmm30 {%k7} {z}

// CHECK: vpunpckhbw (%rcx), %zmm19, %zmm30
// CHECK:  encoding: [0x62,0x61,0x65,0x40,0x68,0x31]
          vpunpckhbw (%rcx), %zmm19, %zmm30

// CHECK: vpunpckhbw 291(%rax,%r14,8), %zmm19, %zmm30
// CHECK:  encoding: [0x62,0x21,0x65,0x40,0x68,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vpunpckhbw 291(%rax,%r14,8), %zmm19, %zmm30

// CHECK: vpunpckhbw 8128(%rdx), %zmm19, %zmm30
// CHECK:  encoding: [0x62,0x61,0x65,0x40,0x68,0x72,0x7f]
          vpunpckhbw 8128(%rdx), %zmm19, %zmm30

// CHECK: vpunpckhbw 8192(%rdx), %zmm19, %zmm30
// CHECK:  encoding: [0x62,0x61,0x65,0x40,0x68,0xb2,0x00,0x20,0x00,0x00]
          vpunpckhbw 8192(%rdx), %zmm19, %zmm30

// CHECK: vpunpckhbw -8192(%rdx), %zmm19, %zmm30
// CHECK:  encoding: [0x62,0x61,0x65,0x40,0x68,0x72,0x80]
          vpunpckhbw -8192(%rdx), %zmm19, %zmm30

// CHECK: vpunpckhbw -8256(%rdx), %zmm19, %zmm30
// CHECK:  encoding: [0x62,0x61,0x65,0x40,0x68,0xb2,0xc0,0xdf,0xff,0xff]
          vpunpckhbw -8256(%rdx), %zmm19, %zmm30

// CHECK: vpunpcklwd %zmm18, %zmm24, %zmm20
// CHECK:  encoding: [0x62,0xa1,0x3d,0x40,0x61,0xe2]
          vpunpcklwd %zmm18, %zmm24, %zmm20

// CHECK: vpunpcklwd %zmm18, %zmm24, %zmm20 {%k7}
// CHECK:  encoding: [0x62,0xa1,0x3d,0x47,0x61,0xe2]
          vpunpcklwd %zmm18, %zmm24, %zmm20 {%k7}

// CHECK: vpunpcklwd %zmm18, %zmm24, %zmm20 {%k7} {z}
// CHECK:  encoding: [0x62,0xa1,0x3d,0xc7,0x61,0xe2]
          vpunpcklwd %zmm18, %zmm24, %zmm20 {%k7} {z}

// CHECK: vpunpcklwd (%rcx), %zmm24, %zmm20
// CHECK:  encoding: [0x62,0xe1,0x3d,0x40,0x61,0x21]
          vpunpcklwd (%rcx), %zmm24, %zmm20

// CHECK: vpunpcklwd 291(%rax,%r14,8), %zmm24, %zmm20
// CHECK:  encoding: [0x62,0xa1,0x3d,0x40,0x61,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vpunpcklwd 291(%rax,%r14,8), %zmm24, %zmm20

// CHECK: vpunpcklwd 8128(%rdx), %zmm24, %zmm20
// CHECK:  encoding: [0x62,0xe1,0x3d,0x40,0x61,0x62,0x7f]
          vpunpcklwd 8128(%rdx), %zmm24, %zmm20

// CHECK: vpunpcklwd 8192(%rdx), %zmm24, %zmm20
// CHECK:  encoding: [0x62,0xe1,0x3d,0x40,0x61,0xa2,0x00,0x20,0x00,0x00]
          vpunpcklwd 8192(%rdx), %zmm24, %zmm20

// CHECK: vpunpcklwd -8192(%rdx), %zmm24, %zmm20
// CHECK:  encoding: [0x62,0xe1,0x3d,0x40,0x61,0x62,0x80]
          vpunpcklwd -8192(%rdx), %zmm24, %zmm20

// CHECK: vpunpcklwd -8256(%rdx), %zmm24, %zmm20
// CHECK:  encoding: [0x62,0xe1,0x3d,0x40,0x61,0xa2,0xc0,0xdf,0xff,0xff]
          vpunpcklwd -8256(%rdx), %zmm24, %zmm20

// CHECK: vpunpckhwd %zmm24, %zmm26, %zmm30
// CHECK:  encoding: [0x62,0x01,0x2d,0x40,0x69,0xf0]
          vpunpckhwd %zmm24, %zmm26, %zmm30

// CHECK: vpunpckhwd %zmm24, %zmm26, %zmm30 {%k4}
// CHECK:  encoding: [0x62,0x01,0x2d,0x44,0x69,0xf0]
          vpunpckhwd %zmm24, %zmm26, %zmm30 {%k4}

// CHECK: vpunpckhwd %zmm24, %zmm26, %zmm30 {%k4} {z}
// CHECK:  encoding: [0x62,0x01,0x2d,0xc4,0x69,0xf0]
          vpunpckhwd %zmm24, %zmm26, %zmm30 {%k4} {z}

// CHECK: vpunpckhwd (%rcx), %zmm26, %zmm30
// CHECK:  encoding: [0x62,0x61,0x2d,0x40,0x69,0x31]
          vpunpckhwd (%rcx), %zmm26, %zmm30

// CHECK: vpunpckhwd 291(%rax,%r14,8), %zmm26, %zmm30
// CHECK:  encoding: [0x62,0x21,0x2d,0x40,0x69,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vpunpckhwd 291(%rax,%r14,8), %zmm26, %zmm30

// CHECK: vpunpckhwd 8128(%rdx), %zmm26, %zmm30
// CHECK:  encoding: [0x62,0x61,0x2d,0x40,0x69,0x72,0x7f]
          vpunpckhwd 8128(%rdx), %zmm26, %zmm30

// CHECK: vpunpckhwd 8192(%rdx), %zmm26, %zmm30
// CHECK:  encoding: [0x62,0x61,0x2d,0x40,0x69,0xb2,0x00,0x20,0x00,0x00]
          vpunpckhwd 8192(%rdx), %zmm26, %zmm30

// CHECK: vpunpckhwd -8192(%rdx), %zmm26, %zmm30
// CHECK:  encoding: [0x62,0x61,0x2d,0x40,0x69,0x72,0x80]
          vpunpckhwd -8192(%rdx), %zmm26, %zmm30

// CHECK: vpunpckhwd -8256(%rdx), %zmm26, %zmm30
// CHECK:  encoding: [0x62,0x61,0x2d,0x40,0x69,0xb2,0xc0,0xdf,0xff,0xff]
          vpunpckhwd -8256(%rdx), %zmm26, %zmm30

// CHECK: vpextrb $171, %xmm17, %eax
// CHECK:  encoding: [0x62,0xe3,0x7d,0x08,0x14,0xc8,0xab]
          vpextrb $171, %xmm17, %eax

// CHECK: vpextrb $123, %xmm17, %eax
// CHECK:  encoding: [0x62,0xe3,0x7d,0x08,0x14,0xc8,0x7b]
          vpextrb $123, %xmm17, %eax

// CHECK: vpextrb $123, %xmm17, %r8d
// CHECK:  encoding: [0x62,0xc3,0x7d,0x08,0x14,0xc8,0x7b]
          vpextrb $123, %xmm17,%r8d

// CHECK: vpextrb $123, %xmm17, (%rcx)
// CHECK:  encoding: [0x62,0xe3,0x7d,0x08,0x14,0x09,0x7b]
          vpextrb $123, %xmm17, (%rcx)

// CHECK: vpextrb $123, %xmm17, 291(%rax,%r14,8)
// CHECK:  encoding: [0x62,0xa3,0x7d,0x08,0x14,0x8c,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vpextrb $123, %xmm17, 291(%rax,%r14,8)

// CHECK: vpextrb $123, %xmm17, 127(%rdx)
// CHECK:  encoding: [0x62,0xe3,0x7d,0x08,0x14,0x4a,0x7f,0x7b]
          vpextrb $123, %xmm17, 127(%rdx)

// CHECK: vpextrb $123, %xmm17, 128(%rdx)
// CHECK:  encoding: [0x62,0xe3,0x7d,0x08,0x14,0x8a,0x80,0x00,0x00,0x00,0x7b]
          vpextrb $123, %xmm17, 128(%rdx)

// CHECK: vpextrb $123, %xmm17, -128(%rdx)
// CHECK:  encoding: [0x62,0xe3,0x7d,0x08,0x14,0x4a,0x80,0x7b]
          vpextrb $123, %xmm17, -128(%rdx)

// CHECK: vpextrb $123, %xmm17, -129(%rdx)
// CHECK:  encoding: [0x62,0xe3,0x7d,0x08,0x14,0x8a,0x7f,0xff,0xff,0xff,0x7b]
          vpextrb $123, %xmm17, -129(%rdx)
// CHECK: vpinsrb $171, %eax, %xmm25, %xmm25
// CHECK:  encoding: [0x62,0x63,0x35,0x00,0x20,0xc8,0xab]
          vpinsrb $171,%eax, %xmm25, %xmm25

// CHECK: vpinsrb $123, %eax, %xmm25, %xmm25
// CHECK:  encoding: [0x62,0x63,0x35,0x00,0x20,0xc8,0x7b]
          vpinsrb $123,%eax, %xmm25, %xmm25

// CHECK: vpinsrb $123, %ebp, %xmm25, %xmm25
// CHECK:  encoding: [0x62,0x63,0x35,0x00,0x20,0xcd,0x7b]
          vpinsrb $123,%ebp, %xmm25, %xmm25

// CHECK: vpinsrb $123, %r13d, %xmm25, %xmm25
// CHECK:  encoding: [0x62,0x43,0x35,0x00,0x20,0xcd,0x7b]
          vpinsrb $123,%r13d, %xmm25, %xmm25

// CHECK: vpinsrb $123, (%rcx), %xmm25, %xmm25
// CHECK:  encoding: [0x62,0x63,0x35,0x00,0x20,0x09,0x7b]
          vpinsrb $123, (%rcx), %xmm25, %xmm25

// CHECK: vpinsrb $123, 291(%rax,%r14,8), %xmm25, %xmm25
// CHECK:  encoding: [0x62,0x23,0x35,0x00,0x20,0x8c,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vpinsrb $123, 291(%rax,%r14,8), %xmm25, %xmm25

// CHECK: vpinsrb $123, 127(%rdx), %xmm25, %xmm25
// CHECK:  encoding: [0x62,0x63,0x35,0x00,0x20,0x4a,0x7f,0x7b]
          vpinsrb $123, 127(%rdx), %xmm25, %xmm25

// CHECK: vpinsrb $123, 128(%rdx), %xmm25, %xmm25
// CHECK:  encoding: [0x62,0x63,0x35,0x00,0x20,0x8a,0x80,0x00,0x00,0x00,0x7b]
          vpinsrb $123, 128(%rdx), %xmm25, %xmm25

// CHECK: vpinsrb $123, -128(%rdx), %xmm25, %xmm25
// CHECK:  encoding: [0x62,0x63,0x35,0x00,0x20,0x4a,0x80,0x7b]
          vpinsrb $123, -128(%rdx), %xmm25, %xmm25

// CHECK: vpinsrb $123, -129(%rdx), %xmm25, %xmm25
// CHECK:  encoding: [0x62,0x63,0x35,0x00,0x20,0x8a,0x7f,0xff,0xff,0xff,0x7b]
          vpinsrb $123, -129(%rdx), %xmm25, %xmm25

// CHECK: vpinsrw $171, %eax, %xmm25, %xmm18
// CHECK:  encoding: [0x62,0xe1,0x35,0x00,0xc4,0xd0,0xab]
          vpinsrw $171,%eax, %xmm25, %xmm18

// CHECK: vpinsrw $123, %eax, %xmm25, %xmm18
// CHECK:  encoding: [0x62,0xe1,0x35,0x00,0xc4,0xd0,0x7b]
          vpinsrw $123,%eax, %xmm25, %xmm18

// CHECK: vpinsrw $123, %ebp, %xmm25, %xmm18
// CHECK:  encoding: [0x62,0xe1,0x35,0x00,0xc4,0xd5,0x7b]
          vpinsrw $123,%ebp, %xmm25, %xmm18

// CHECK: vpinsrw $123, %r13d, %xmm25, %xmm18
// CHECK:  encoding: [0x62,0xc1,0x35,0x00,0xc4,0xd5,0x7b]
          vpinsrw $123,%r13d, %xmm25, %xmm18

// CHECK: vpinsrw $123, (%rcx), %xmm25, %xmm18
// CHECK:  encoding: [0x62,0xe1,0x35,0x00,0xc4,0x11,0x7b]
          vpinsrw $123, (%rcx), %xmm25, %xmm18

// CHECK: vpinsrw $123, 291(%rax,%r14,8), %xmm25, %xmm18
// CHECK:  encoding: [0x62,0xa1,0x35,0x00,0xc4,0x94,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vpinsrw $123, 291(%rax,%r14,8), %xmm25, %xmm18

// CHECK: vpinsrw $123, 254(%rdx), %xmm25, %xmm18
// CHECK:  encoding: [0x62,0xe1,0x35,0x00,0xc4,0x52,0x7f,0x7b]
          vpinsrw $123, 254(%rdx), %xmm25, %xmm18

// CHECK: vpinsrw $123, 256(%rdx), %xmm25, %xmm18
// CHECK:  encoding: [0x62,0xe1,0x35,0x00,0xc4,0x92,0x00,0x01,0x00,0x00,0x7b]
          vpinsrw $123, 256(%rdx), %xmm25, %xmm18

// CHECK: vpinsrw $123, -256(%rdx), %xmm25, %xmm18
// CHECK:  encoding: [0x62,0xe1,0x35,0x00,0xc4,0x52,0x80,0x7b]
          vpinsrw $123, -256(%rdx), %xmm25, %xmm18

// CHECK: vpinsrw $123, -258(%rdx), %xmm25, %xmm18
// CHECK:  encoding: [0x62,0xe1,0x35,0x00,0xc4,0x92,0xfe,0xfe,0xff,0xff,0x7b]
          vpinsrw $123, -258(%rdx), %xmm25, %xmm18

// CHECK: vpextrw $123, %xmm28, (%rcx)
// CHECK:  encoding: [0x62,0x63,0x7d,0x08,0x15,0x21,0x7b]
          vpextrw $123, %xmm28, (%rcx)

// CHECK: vpextrw $123, %xmm28, 291(%rax,%r14,8)
// CHECK:  encoding: [0x62,0x23,0x7d,0x08,0x15,0xa4,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vpextrw $123, %xmm28, 291(%rax,%r14,8)

// CHECK: vpextrw $123, %xmm28, 254(%rdx)
// CHECK:  encoding: [0x62,0x63,0x7d,0x08,0x15,0x62,0x7f,0x7b]
          vpextrw $123, %xmm28, 254(%rdx)

// CHECK: vpextrw $123, %xmm28, 256(%rdx)
// CHECK:  encoding: [0x62,0x63,0x7d,0x08,0x15,0xa2,0x00,0x01,0x00,0x00,0x7b]
          vpextrw $123, %xmm28, 256(%rdx)

// CHECK: vpextrw $123, %xmm28, -256(%rdx)
// CHECK:  encoding: [0x62,0x63,0x7d,0x08,0x15,0x62,0x80,0x7b]
          vpextrw $123, %xmm28, -256(%rdx)

// CHECK: vpextrw $123, %xmm28, -258(%rdx)
// CHECK:  encoding: [0x62,0x63,0x7d,0x08,0x15,0xa2,0xfe,0xfe,0xff,0xff,0x7b]
          vpextrw $123, %xmm28, -258(%rdx)

// CHECK: vpextrw $171, %xmm30, %eax
// CHECK:  encoding: [0x62,0x91,0x7d,0x08,0xc5,0xc6,0xab]
          vpextrw $171, %xmm30,%rax

// CHECK: vpextrw $123, %xmm30, %eax
// CHECK:  encoding: [0x62,0x91,0x7d,0x08,0xc5,0xc6,0x7b]
          vpextrw $123, %xmm30,%rax

// CHECK: vpextrw $123, %xmm30, %r8d
// CHECK:  encoding: [0x62,0x11,0x7d,0x08,0xc5,0xc6,0x7b]
          vpextrw $123, %xmm30,%r8

// CHECK: vpextrw $171, %xmm28, %eax
// CHECK:  encoding: [0x62,0x91,0x7d,0x08,0xc5,0xc4,0xab]
          vpextrw $0xab, %xmm28, %eax

// CHECK: vpextrw $123, %xmm28, %eax
// CHECK:  encoding: [0x62,0x91,0x7d,0x08,0xc5,0xc4,0x7b]
          vpextrw $0x7b, %xmm28, %eax

// CHECK: vpextrw $123, %xmm28, %r8d
// CHECK:  encoding: [0x62,0x11,0x7d,0x08,0xc5,0xc4,0x7b]
          vpextrw $0x7b, %xmm28, %r8d

// CHECK: vpextrw $171, %xmm28, %eax
// CHECK:  encoding: [0x62,0x91,0x7d,0x08,0xc5,0xc4,0xab]
          vpextrw $0xab, %xmm28, %eax

// CHECK: vpextrw $123, %xmm28, %eax
// CHECK:  encoding: [0x62,0x91,0x7d,0x08,0xc5,0xc4,0x7b]
          vpextrw $0x7b, %xmm28, %eax

// CHECK: vpextrw $123, %xmm28, %r8d
// CHECK:  encoding: [0x62,0x11,0x7d,0x08,0xc5,0xc4,0x7b]
          vpextrw $0x7b, %xmm28, %r8d

// CHECK: vpextrw $171, %xmm20, %eax
// CHECK:  encoding: [0x62,0xb1,0x7d,0x08,0xc5,0xc4,0xab]
          vpextrw $0xab, %xmm20, %eax

// CHECK: vpextrw $123, %xmm20, %eax
// CHECK:  encoding: [0x62,0xb1,0x7d,0x08,0xc5,0xc4,0x7b]
          vpextrw $0x7b, %xmm20, %eax

// CHECK: vpextrw $123, %xmm20, %r8d
// CHECK:  encoding: [0x62,0x31,0x7d,0x08,0xc5,0xc4,0x7b]
          vpextrw $0x7b, %xmm20, %r8d

// CHECK: vpextrw $171, %xmm19, %eax
// CHECK:  encoding: [0x62,0xb1,0x7d,0x08,0xc5,0xc3,0xab]
          vpextrw $0xab, %xmm19, %eax

// CHECK: vpextrw $123, %xmm19, %eax
// CHECK:  encoding: [0x62,0xb1,0x7d,0x08,0xc5,0xc3,0x7b]
          vpextrw $0x7b, %xmm19, %eax

// CHECK: vpextrw $123, %xmm19, %r8d
// CHECK:  encoding: [0x62,0x31,0x7d,0x08,0xc5,0xc3,0x7b]
          vpextrw $0x7b, %xmm19, %r8d

// CHECK: kunpckdq %k4, %k6, %k4
// CHECK:  encoding: [0xc4,0xe1,0xcc,0x4b,0xe4]
          kunpckdq %k4, %k6, %k4

// CHECK: kunpckwd %k6, %k5, %k5
// CHECK:  encoding: [0xc5,0xd4,0x4b,0xee]
          kunpckwd %k6, %k5, %k5

// CHECK: ktestd %k3, %k3
// CHECK:  encoding: [0xc4,0xe1,0xf9,0x99,0xdb]
          ktestd %k3, %k3

// CHECK: ktestq %k6, %k2
// CHECK:  encoding: [0xc4,0xe1,0xf8,0x99,0xd6]
          ktestq %k6, %k2

// CHECK: kortestd %k3, %k4
// CHECK:  encoding: [0xc4,0xe1,0xf9,0x98,0xe3]
          kortestd %k3, %k4

// CHECK: kortestq %k4, %k5
// CHECK:  encoding: [0xc4,0xe1,0xf8,0x98,0xec]
          kortestq %k4, %k5

// CHECK: kaddd  %k6, %k6, %k2
// CHECK:  encoding: [0xc4,0xe1,0xcd,0x4a,0xd6]
          kaddd  %k6, %k6, %k2

// CHECK: kaddq  %k4, %k6, %k3
// CHECK:  encoding: [0xc4,0xe1,0xcc,0x4a,0xdc]
          kaddq  %k4, %k6, %k3

// CHECK: vpalignr $171, %zmm17, %zmm26, %zmm22
// CHECK:  encoding: [0x62,0xa3,0x2d,0x40,0x0f,0xf1,0xab]
          vpalignr $171, %zmm17, %zmm26, %zmm22

// CHECK: vpalignr $171, %zmm17, %zmm26, %zmm22 {%k3}
// CHECK:  encoding: [0x62,0xa3,0x2d,0x43,0x0f,0xf1,0xab]
          vpalignr $171, %zmm17, %zmm26, %zmm22 {%k3}

// CHECK: vpalignr $171, %zmm17, %zmm26, %zmm22 {%k3} {z}
// CHECK:  encoding: [0x62,0xa3,0x2d,0xc3,0x0f,0xf1,0xab]
          vpalignr $171, %zmm17, %zmm26, %zmm22 {%k3} {z}

// CHECK: vpalignr $123, %zmm17, %zmm26, %zmm22
// CHECK:  encoding: [0x62,0xa3,0x2d,0x40,0x0f,0xf1,0x7b]
          vpalignr $123, %zmm17, %zmm26, %zmm22

// CHECK: vpalignr $123, (%rcx), %zmm26, %zmm22
// CHECK:  encoding: [0x62,0xe3,0x2d,0x40,0x0f,0x31,0x7b]
          vpalignr $123, (%rcx), %zmm26, %zmm22

// CHECK: vpalignr $123, 291(%rax,%r14,8), %zmm26, %zmm22
// CHECK:  encoding: [0x62,0xa3,0x2d,0x40,0x0f,0xb4,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vpalignr $123, 291(%rax,%r14,8), %zmm26, %zmm22

// CHECK: vpalignr $123, 8128(%rdx), %zmm26, %zmm22
// CHECK:  encoding: [0x62,0xe3,0x2d,0x40,0x0f,0x72,0x7f,0x7b]
          vpalignr $123, 8128(%rdx), %zmm26, %zmm22

// CHECK: vpalignr $123, 8192(%rdx), %zmm26, %zmm22
// CHECK:  encoding: [0x62,0xe3,0x2d,0x40,0x0f,0xb2,0x00,0x20,0x00,0x00,0x7b]
          vpalignr $123, 8192(%rdx), %zmm26, %zmm22

// CHECK: vpalignr $123, -8192(%rdx), %zmm26, %zmm22
// CHECK:  encoding: [0x62,0xe3,0x2d,0x40,0x0f,0x72,0x80,0x7b]
          vpalignr $123, -8192(%rdx), %zmm26, %zmm22

// CHECK: vpalignr $123, -8256(%rdx), %zmm26, %zmm22
// CHECK:  encoding: [0x62,0xe3,0x2d,0x40,0x0f,0xb2,0xc0,0xdf,0xff,0xff,0x7b]
          vpalignr $123, -8256(%rdx), %zmm26, %zmm22

// CHECK: vdbpsadbw $171, %zmm18, %zmm20, %zmm21
// CHECK:  encoding: [0x62,0xa3,0x5d,0x40,0x42,0xea,0xab]
          vdbpsadbw $171, %zmm18, %zmm20, %zmm21

// CHECK: vdbpsadbw $171, %zmm18, %zmm20, %zmm21 {%k1}
// CHECK:  encoding: [0x62,0xa3,0x5d,0x41,0x42,0xea,0xab]
          vdbpsadbw $171, %zmm18, %zmm20, %zmm21 {%k1}

// CHECK: vdbpsadbw $171, %zmm18, %zmm20, %zmm21 {%k1} {z}
// CHECK:  encoding: [0x62,0xa3,0x5d,0xc1,0x42,0xea,0xab]
          vdbpsadbw $171, %zmm18, %zmm20, %zmm21 {%k1} {z}

// CHECK: vdbpsadbw $123, %zmm18, %zmm20, %zmm21
// CHECK:  encoding: [0x62,0xa3,0x5d,0x40,0x42,0xea,0x7b]
          vdbpsadbw $123, %zmm18, %zmm20, %zmm21

// CHECK: vdbpsadbw $123, (%rcx), %zmm20, %zmm21
// CHECK:  encoding: [0x62,0xe3,0x5d,0x40,0x42,0x29,0x7b]
          vdbpsadbw $123, (%rcx), %zmm20, %zmm21

// CHECK: vdbpsadbw $123, 291(%rax,%r14,8), %zmm20, %zmm21
// CHECK:  encoding: [0x62,0xa3,0x5d,0x40,0x42,0xac,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vdbpsadbw $123, 291(%rax,%r14,8), %zmm20, %zmm21

// CHECK: vdbpsadbw $123, 8128(%rdx), %zmm20, %zmm21
// CHECK:  encoding: [0x62,0xe3,0x5d,0x40,0x42,0x6a,0x7f,0x7b]
          vdbpsadbw $123, 8128(%rdx), %zmm20, %zmm21

// CHECK: vdbpsadbw $123, 8192(%rdx), %zmm20, %zmm21
// CHECK:  encoding: [0x62,0xe3,0x5d,0x40,0x42,0xaa,0x00,0x20,0x00,0x00,0x7b]
          vdbpsadbw $123, 8192(%rdx), %zmm20, %zmm21

// CHECK: vdbpsadbw $123, -8192(%rdx), %zmm20, %zmm21
// CHECK:  encoding: [0x62,0xe3,0x5d,0x40,0x42,0x6a,0x80,0x7b]
          vdbpsadbw $123, -8192(%rdx), %zmm20, %zmm21

// CHECK: vdbpsadbw $123, -8256(%rdx), %zmm20, %zmm21
// CHECK:  encoding: [0x62,0xe3,0x5d,0x40,0x42,0xaa,0xc0,0xdf,0xff,0xff,0x7b]
          vdbpsadbw $123, -8256(%rdx), %zmm20, %zmm21

// CHECK: vpslldq $171, %zmm28, %zmm20
// CHECK:  encoding: [0x62,0x91,0x5d,0x40,0x73,0xfc,0xab]
          vpslldq $171, %zmm28, %zmm20

// CHECK: vpslldq $123, %zmm28, %zmm20
// CHECK:  encoding: [0x62,0x91,0x5d,0x40,0x73,0xfc,0x7b]
          vpslldq $123, %zmm28, %zmm20

// CHECK: vpslldq $123, (%rcx), %zmm20
// CHECK:  encoding: [0x62,0xf1,0x5d,0x40,0x73,0x39,0x7b]
          vpslldq $123, (%rcx), %zmm20

// CHECK: vpslldq $123, 291(%rax,%r14,8), %zmm20
// CHECK:  encoding: [0x62,0xb1,0x5d,0x40,0x73,0xbc,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vpslldq $123, 291(%rax,%r14,8), %zmm20

// CHECK: vpslldq $123, 8128(%rdx), %zmm20
// CHECK:  encoding: [0x62,0xf1,0x5d,0x40,0x73,0x7a,0x7f,0x7b]
          vpslldq $123, 8128(%rdx), %zmm20

// CHECK: vpslldq $123, 8192(%rdx), %zmm20
// CHECK:  encoding: [0x62,0xf1,0x5d,0x40,0x73,0xba,0x00,0x20,0x00,0x00,0x7b]
          vpslldq $123, 8192(%rdx), %zmm20

// CHECK: vpslldq $123, -8192(%rdx), %zmm20
// CHECK:  encoding: [0x62,0xf1,0x5d,0x40,0x73,0x7a,0x80,0x7b]
          vpslldq $123, -8192(%rdx), %zmm20

// CHECK: vpslldq $123, -8256(%rdx), %zmm20
// CHECK:  encoding: [0x62,0xf1,0x5d,0x40,0x73,0xba,0xc0,0xdf,0xff,0xff,0x7b]
          vpslldq $123, -8256(%rdx), %zmm20

// CHECK: vpsrldq $171, %zmm26, %zmm18
// CHECK:  encoding: [0x62,0x91,0x6d,0x40,0x73,0xda,0xab]
          vpsrldq $171, %zmm26, %zmm18

// CHECK: vpsrldq $123, %zmm26, %zmm18
// CHECK:  encoding: [0x62,0x91,0x6d,0x40,0x73,0xda,0x7b]
          vpsrldq $123, %zmm26, %zmm18

// CHECK: vpsrldq $123, (%rcx), %zmm18
// CHECK:  encoding: [0x62,0xf1,0x6d,0x40,0x73,0x19,0x7b]
          vpsrldq $123, (%rcx), %zmm18

// CHECK: vpsrldq $123, 291(%rax,%r14,8), %zmm18
// CHECK:  encoding: [0x62,0xb1,0x6d,0x40,0x73,0x9c,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vpsrldq $123, 291(%rax,%r14,8), %zmm18

// CHECK: vpsrldq $123, 8128(%rdx), %zmm18
// CHECK:  encoding: [0x62,0xf1,0x6d,0x40,0x73,0x5a,0x7f,0x7b]
          vpsrldq $123, 8128(%rdx), %zmm18

// CHECK: vpsrldq $123, 8192(%rdx), %zmm18
// CHECK:  encoding: [0x62,0xf1,0x6d,0x40,0x73,0x9a,0x00,0x20,0x00,0x00,0x7b]
          vpsrldq $123, 8192(%rdx), %zmm18

// CHECK: vpsrldq $123, -8192(%rdx), %zmm18
// CHECK:  encoding: [0x62,0xf1,0x6d,0x40,0x73,0x5a,0x80,0x7b]
          vpsrldq $123, -8192(%rdx), %zmm18

// CHECK: vpsrldq $123, -8256(%rdx), %zmm18
// CHECK:  encoding: [0x62,0xf1,0x6d,0x40,0x73,0x9a,0xc0,0xdf,0xff,0xff,0x7b]
          vpsrldq $123, -8256(%rdx), %zmm18

// CHECK: vpsadbw %zmm22, %zmm25, %zmm28
// CHECK:  encoding: [0x62,0x21,0x35,0x40,0xf6,0xe6]
          vpsadbw %zmm22, %zmm25, %zmm28

// CHECK: vpsadbw (%rcx), %zmm25, %zmm28
// CHECK:  encoding: [0x62,0x61,0x35,0x40,0xf6,0x21]
          vpsadbw (%rcx), %zmm25, %zmm28

// CHECK: vpsadbw 291(%rax,%r14,8), %zmm25, %zmm28
// CHECK:  encoding: [0x62,0x21,0x35,0x40,0xf6,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vpsadbw 291(%rax,%r14,8), %zmm25, %zmm28

// CHECK: vpsadbw 8128(%rdx), %zmm25, %zmm28
// CHECK:  encoding: [0x62,0x61,0x35,0x40,0xf6,0x62,0x7f]
          vpsadbw 8128(%rdx), %zmm25, %zmm28

// CHECK: vpsadbw 8192(%rdx), %zmm25, %zmm28
// CHECK:  encoding: [0x62,0x61,0x35,0x40,0xf6,0xa2,0x00,0x20,0x00,0x00]
          vpsadbw 8192(%rdx), %zmm25, %zmm28

// CHECK: vpsadbw -8192(%rdx), %zmm25, %zmm28
// CHECK:  encoding: [0x62,0x61,0x35,0x40,0xf6,0x62,0x80]
          vpsadbw -8192(%rdx), %zmm25, %zmm28

// CHECK: vpsadbw -8256(%rdx), %zmm25, %zmm28
// CHECK:  encoding: [0x62,0x61,0x35,0x40,0xf6,0xa2,0xc0,0xdf,0xff,0xff]
          vpsadbw -8256(%rdx), %zmm25, %zmm28

// CHECK: vpshuflw $171, %zmm28, %zmm26
// CHECK:  encoding: [0x62,0x01,0x7f,0x48,0x70,0xd4,0xab]
          vpshuflw $171, %zmm28, %zmm26

// CHECK: vpshuflw $171, %zmm28, %zmm26 {%k1}
// CHECK:  encoding: [0x62,0x01,0x7f,0x49,0x70,0xd4,0xab]
          vpshuflw $171, %zmm28, %zmm26 {%k1}

// CHECK: vpshuflw $171, %zmm28, %zmm26 {%k1} {z}
// CHECK:  encoding: [0x62,0x01,0x7f,0xc9,0x70,0xd4,0xab]
          vpshuflw $171, %zmm28, %zmm26 {%k1} {z}

// CHECK: vpshuflw $123, %zmm28, %zmm26
// CHECK:  encoding: [0x62,0x01,0x7f,0x48,0x70,0xd4,0x7b]
          vpshuflw $123, %zmm28, %zmm26

// CHECK: vpshuflw $123, (%rcx), %zmm26
// CHECK:  encoding: [0x62,0x61,0x7f,0x48,0x70,0x11,0x7b]
          vpshuflw $123, (%rcx), %zmm26

// CHECK: vpshuflw $123, 291(%rax,%r14,8), %zmm26
// CHECK:  encoding: [0x62,0x21,0x7f,0x48,0x70,0x94,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vpshuflw $123, 291(%rax,%r14,8), %zmm26

// CHECK: vpshuflw $123, 8128(%rdx), %zmm26
// CHECK:  encoding: [0x62,0x61,0x7f,0x48,0x70,0x52,0x7f,0x7b]
          vpshuflw $123, 8128(%rdx), %zmm26

// CHECK: vpshuflw $123, 8192(%rdx), %zmm26
// CHECK:  encoding: [0x62,0x61,0x7f,0x48,0x70,0x92,0x00,0x20,0x00,0x00,0x7b]
          vpshuflw $123, 8192(%rdx), %zmm26

// CHECK: vpshuflw $123, -8192(%rdx), %zmm26
// CHECK:  encoding: [0x62,0x61,0x7f,0x48,0x70,0x52,0x80,0x7b]
          vpshuflw $123, -8192(%rdx), %zmm26

// CHECK: vpshuflw $123, -8256(%rdx), %zmm26
// CHECK:  encoding: [0x62,0x61,0x7f,0x48,0x70,0x92,0xc0,0xdf,0xff,0xff,0x7b]
          vpshuflw $123, -8256(%rdx), %zmm26

// CHECK: vpshufhw $171, %zmm18, %zmm18
// CHECK:  encoding: [0x62,0xa1,0x7e,0x48,0x70,0xd2,0xab]
          vpshufhw $171, %zmm18, %zmm18

// CHECK: vpshufhw $171, %zmm18, %zmm18 {%k4}
// CHECK:  encoding: [0x62,0xa1,0x7e,0x4c,0x70,0xd2,0xab]
          vpshufhw $171, %zmm18, %zmm18 {%k4}

// CHECK: vpshufhw $171, %zmm18, %zmm18 {%k4} {z}
// CHECK:  encoding: [0x62,0xa1,0x7e,0xcc,0x70,0xd2,0xab]
          vpshufhw $171, %zmm18, %zmm18 {%k4} {z}

// CHECK: vpshufhw $123, %zmm18, %zmm18
// CHECK:  encoding: [0x62,0xa1,0x7e,0x48,0x70,0xd2,0x7b]
          vpshufhw $123, %zmm18, %zmm18

// CHECK: vpshufhw $123, (%rcx), %zmm18
// CHECK:  encoding: [0x62,0xe1,0x7e,0x48,0x70,0x11,0x7b]
          vpshufhw $123, (%rcx), %zmm18

// CHECK: vpshufhw $123, 291(%rax,%r14,8), %zmm18
// CHECK:  encoding: [0x62,0xa1,0x7e,0x48,0x70,0x94,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vpshufhw $123, 291(%rax,%r14,8), %zmm18

// CHECK: vpshufhw $123, 8128(%rdx), %zmm18
// CHECK:  encoding: [0x62,0xe1,0x7e,0x48,0x70,0x52,0x7f,0x7b]
          vpshufhw $123, 8128(%rdx), %zmm18

// CHECK: vpshufhw $123, 8192(%rdx), %zmm18
// CHECK:  encoding: [0x62,0xe1,0x7e,0x48,0x70,0x92,0x00,0x20,0x00,0x00,0x7b]
          vpshufhw $123, 8192(%rdx), %zmm18

// CHECK: vpshufhw $123, -8192(%rdx), %zmm18
// CHECK:  encoding: [0x62,0xe1,0x7e,0x48,0x70,0x52,0x80,0x7b]
          vpshufhw $123, -8192(%rdx), %zmm18

// CHECK: vpshufhw $123, -8256(%rdx), %zmm18
// CHECK:  encoding: [0x62,0xe1,0x7e,0x48,0x70,0x92,0xc0,0xdf,0xff,0xff,0x7b]
          vpshufhw $123, -8256(%rdx), %zmm18

// CHECK: vpbroadcastb %xmm23, %zmm25
// CHECK:  encoding: [0x62,0x22,0x7d,0x48,0x78,0xcf]
          vpbroadcastb %xmm23, %zmm25

// CHECK: vpbroadcastb %xmm23, %zmm25 {%k7}
// CHECK:  encoding: [0x62,0x22,0x7d,0x4f,0x78,0xcf]
          vpbroadcastb %xmm23, %zmm25 {%k7}

// CHECK: vpbroadcastb %xmm23, %zmm25 {%k7} {z}
// CHECK:  encoding: [0x62,0x22,0x7d,0xcf,0x78,0xcf]
          vpbroadcastb %xmm23, %zmm25 {%k7} {z}

// CHECK: vpbroadcastb (%rcx), %zmm25
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x78,0x09]
          vpbroadcastb (%rcx), %zmm25

// CHECK: vpbroadcastb 291(%rax,%r14,8), %zmm25
// CHECK:  encoding: [0x62,0x22,0x7d,0x48,0x78,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vpbroadcastb 291(%rax,%r14,8), %zmm25

// CHECK: vpbroadcastb 127(%rdx), %zmm25
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x78,0x4a,0x7f]
          vpbroadcastb 127(%rdx), %zmm25

// CHECK: vpbroadcastb 128(%rdx), %zmm25
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x78,0x8a,0x80,0x00,0x00,0x00]
          vpbroadcastb 128(%rdx), %zmm25

// CHECK: vpbroadcastb -128(%rdx), %zmm25
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x78,0x4a,0x80]
          vpbroadcastb -128(%rdx), %zmm25

// CHECK: vpbroadcastb -129(%rdx), %zmm25
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x78,0x8a,0x7f,0xff,0xff,0xff]
          vpbroadcastb -129(%rdx), %zmm25

// CHECK: vpbroadcastb %eax, %zmm19
// CHECK:  encoding: [0x62,0xe2,0x7d,0x48,0x7a,0xd8]
          vpbroadcastb %eax, %zmm19

// CHECK: vpbroadcastb %eax, %zmm19 {%k7}
// CHECK:  encoding: [0x62,0xe2,0x7d,0x4f,0x7a,0xd8]
          vpbroadcastb %eax, %zmm19 {%k7}

// CHECK: vpbroadcastb %eax, %zmm19 {%k7} {z}
// CHECK:  encoding: [0x62,0xe2,0x7d,0xcf,0x7a,0xd8]
          vpbroadcastb %eax, %zmm19 {%k7} {z}

// CHECK: vpbroadcastw %xmm19, %zmm30
// CHECK:  encoding: [0x62,0x22,0x7d,0x48,0x79,0xf3]
          vpbroadcastw %xmm19, %zmm30

// CHECK: vpbroadcastw %xmm19, %zmm30 {%k4}
// CHECK:  encoding: [0x62,0x22,0x7d,0x4c,0x79,0xf3]
          vpbroadcastw %xmm19, %zmm30 {%k4}

// CHECK: vpbroadcastw %xmm19, %zmm30 {%k4} {z}
// CHECK:  encoding: [0x62,0x22,0x7d,0xcc,0x79,0xf3]
          vpbroadcastw %xmm19, %zmm30 {%k4} {z}

// CHECK: vpbroadcastw (%rcx), %zmm30
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x79,0x31]
          vpbroadcastw (%rcx), %zmm30

// CHECK: vpbroadcastw 291(%rax,%r14,8), %zmm30
// CHECK:  encoding: [0x62,0x22,0x7d,0x48,0x79,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vpbroadcastw 291(%rax,%r14,8), %zmm30

// CHECK: vpbroadcastw 254(%rdx), %zmm30
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x79,0x72,0x7f]
          vpbroadcastw 254(%rdx), %zmm30

// CHECK: vpbroadcastw 256(%rdx), %zmm30
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x79,0xb2,0x00,0x01,0x00,0x00]
          vpbroadcastw 256(%rdx), %zmm30

// CHECK: vpbroadcastw -256(%rdx), %zmm30
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x79,0x72,0x80]
          vpbroadcastw -256(%rdx), %zmm30

// CHECK: vpbroadcastw -258(%rdx), %zmm30
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x79,0xb2,0xfe,0xfe,0xff,0xff]
          vpbroadcastw -258(%rdx), %zmm30

// CHECK: vpbroadcastw %eax, %zmm24
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x7b,0xc0]
          vpbroadcastw %eax, %zmm24

// CHECK: vpbroadcastw %eax, %zmm24 {%k1}
// CHECK:  encoding: [0x62,0x62,0x7d,0x49,0x7b,0xc0]
          vpbroadcastw %eax, %zmm24 {%k1}

// CHECK: vpbroadcastw %eax, %zmm24 {%k1} {z}
// CHECK:  encoding: [0x62,0x62,0x7d,0xc9,0x7b,0xc0]
          vpbroadcastw %eax, %zmm24 {%k1} {z}

// CHECK: vpextrw.s $171, %xmm28, %eax
// CHECK:  encoding: [0x62,0x63,0x7d,0x08,0x15,0xe0,0xab]
          vpextrw.s $0xab, %xmm28, %eax

// CHECK: vpextrw.s $123, %xmm28, %eax
// CHECK:  encoding: [0x62,0x63,0x7d,0x08,0x15,0xe0,0x7b]
          vpextrw.s $0x7b, %xmm28, %eax

// CHECK: vpextrw.s $123, %xmm28, %r8d
// CHECK:  encoding: [0x62,0x43,0x7d,0x08,0x15,0xe0,0x7b]
          vpextrw.s $0x7b, %xmm28, %r8d

// CHECK: vpextrw.s $171, %xmm28, %eax
// CHECK:  encoding: [0x62,0x63,0x7d,0x08,0x15,0xe0,0xab]
          vpextrw.s $0xab, %xmm28, %eax

// CHECK: vpextrw.s $123, %xmm28, %eax
// CHECK:  encoding: [0x62,0x63,0x7d,0x08,0x15,0xe0,0x7b]
          vpextrw.s $0x7b, %xmm28, %eax

// CHECK: vpextrw.s $123, %xmm28, %r8d
// CHECK:  encoding: [0x62,0x43,0x7d,0x08,0x15,0xe0,0x7b]
          vpextrw.s $0x7b, %xmm28, %r8d

// CHECK: vpextrw.s $171, %xmm20, %eax
// CHECK:  encoding: [0x62,0xe3,0x7d,0x08,0x15,0xe0,0xab]
          vpextrw.s $0xab, %xmm20, %eax

// CHECK: vpextrw.s $123, %xmm20, %eax
// CHECK:  encoding: [0x62,0xe3,0x7d,0x08,0x15,0xe0,0x7b]
          vpextrw.s $0x7b, %xmm20, %eax

// CHECK: vpextrw.s $123, %xmm20, %r8d
// CHECK:  encoding: [0x62,0xc3,0x7d,0x08,0x15,0xe0,0x7b]
          vpextrw.s $0x7b, %xmm20, %r8d

// CHECK: vpextrw.s $171, %xmm19, %eax
// CHECK:  encoding: [0x62,0xe3,0x7d,0x08,0x15,0xd8,0xab]
          vpextrw.s $0xab, %xmm19, %eax

// CHECK: vpextrw.s $123, %xmm19, %eax
// CHECK:  encoding: [0x62,0xe3,0x7d,0x08,0x15,0xd8,0x7b]
          vpextrw.s $0x7b, %xmm19, %eax

// CHECK: vpextrw.s $123, %xmm19, %r8d
// CHECK:  encoding: [0x62,0xc3,0x7d,0x08,0x15,0xd8,0x7b]
          vpextrw.s $0x7b, %xmm19, %r8d

// CHECK: vmovdqu16.s %zmm19, %zmm22
// CHECK:  encoding: [0x62,0xa1,0xff,0x48,0x7f,0xde]
          vmovdqu16.s %zmm19, %zmm22

// CHECK: vmovdqu16.s %zmm19, %zmm22 {%k3}
// CHECK:  encoding: [0x62,0xa1,0xff,0x4b,0x7f,0xde]
          vmovdqu16.s %zmm19, %zmm22 {%k3}

// CHECK: vmovdqu16.s %zmm19, %zmm22 {%k3} {z}
// CHECK:  encoding: [0x62,0xa1,0xff,0xcb,0x7f,0xde]
          vmovdqu16.s %zmm19, %zmm22 {%k3} {z}

// CHECK: vmovdqu16.s %zmm22, %zmm20
// CHECK:  encoding: [0x62,0xa1,0xff,0x48,0x7f,0xf4]
          vmovdqu16.s %zmm22, %zmm20

// CHECK: vmovdqu16.s %zmm22, %zmm20 {%k3}
// CHECK:  encoding: [0x62,0xa1,0xff,0x4b,0x7f,0xf4]
          vmovdqu16.s %zmm22, %zmm20 {%k3}

// CHECK: vmovdqu16.s %zmm22, %zmm20 {%k3} {z}
// CHECK:  encoding: [0x62,0xa1,0xff,0xcb,0x7f,0xf4]
          vmovdqu16.s %zmm22, %zmm20 {%k3} {z}

// CHECK: vmovdqu16.s %zmm26, %zmm26
// CHECK:  encoding: [0x62,0x01,0xff,0x48,0x7f,0xd2]
          vmovdqu16.s %zmm26, %zmm26

// CHECK: vmovdqu16.s %zmm26, %zmm26 {%k2}
// CHECK:  encoding: [0x62,0x01,0xff,0x4a,0x7f,0xd2]
          vmovdqu16.s %zmm26, %zmm26 {%k2}

// CHECK: vmovdqu16.s %zmm26, %zmm26 {%k2} {z}
// CHECK:  encoding: [0x62,0x01,0xff,0xca,0x7f,0xd2]
          vmovdqu16.s %zmm26, %zmm26 {%k2} {z}

// CHECK: vmovdqu16.s %zmm22, %zmm19
// CHECK:  encoding: [0x62,0xa1,0xff,0x48,0x7f,0xf3]
          vmovdqu16.s %zmm22, %zmm19

// CHECK: vmovdqu16.s %zmm22, %zmm19 {%k7}
// CHECK:  encoding: [0x62,0xa1,0xff,0x4f,0x7f,0xf3]
          vmovdqu16.s %zmm22, %zmm19 {%k7}

// CHECK: vmovdqu16.s %zmm22, %zmm19 {%k7} {z}
// CHECK:  encoding: [0x62,0xa1,0xff,0xcf,0x7f,0xf3]
          vmovdqu16.s %zmm22, %zmm19 {%k7} {z}

// CHECK: vmovdqu8.s %zmm23, %zmm24
// CHECK:  encoding: [0x62,0x81,0x7f,0x48,0x7f,0xf8]
          vmovdqu8.s %zmm23, %zmm24

// CHECK: vmovdqu8.s %zmm23, %zmm24 {%k3}
// CHECK:  encoding: [0x62,0x81,0x7f,0x4b,0x7f,0xf8]
          vmovdqu8.s %zmm23, %zmm24 {%k3}

// CHECK: vmovdqu8.s %zmm23, %zmm24 {%k3} {z}
// CHECK:  encoding: [0x62,0x81,0x7f,0xcb,0x7f,0xf8]
          vmovdqu8.s %zmm23, %zmm24 {%k3} {z}

// CHECK: vmovdqu8.s %zmm27, %zmm23
// CHECK:  encoding: [0x62,0x21,0x7f,0x48,0x7f,0xdf]
          vmovdqu8.s %zmm27, %zmm23

// CHECK: vmovdqu8.s %zmm27, %zmm23 {%k5}
// CHECK:  encoding: [0x62,0x21,0x7f,0x4d,0x7f,0xdf]
          vmovdqu8.s %zmm27, %zmm23 {%k5}

// CHECK: vmovdqu8.s %zmm27, %zmm23 {%k5} {z}
// CHECK:  encoding: [0x62,0x21,0x7f,0xcd,0x7f,0xdf]
          vmovdqu8.s %zmm27, %zmm23 {%k5} {z}

// CHECK: vmovdqu8.s %zmm17, %zmm23
// CHECK:  encoding: [0x62,0xa1,0x7f,0x48,0x7f,0xcf]
          vmovdqu8.s %zmm17, %zmm23

// CHECK: vmovdqu8.s %zmm17, %zmm23 {%k2}
// CHECK:  encoding: [0x62,0xa1,0x7f,0x4a,0x7f,0xcf]
          vmovdqu8.s %zmm17, %zmm23 {%k2}

// CHECK: vmovdqu8.s %zmm17, %zmm23 {%k2} {z}
// CHECK:  encoding: [0x62,0xa1,0x7f,0xca,0x7f,0xcf]
          vmovdqu8.s %zmm17, %zmm23 {%k2} {z}

// CHECK: vmovdqu8.s %zmm19, %zmm28
// CHECK:  encoding: [0x62,0x81,0x7f,0x48,0x7f,0xdc]
          vmovdqu8.s %zmm19, %zmm28

// CHECK: vmovdqu8.s %zmm19, %zmm28 {%k4}
// CHECK:  encoding: [0x62,0x81,0x7f,0x4c,0x7f,0xdc]
          vmovdqu8.s %zmm19, %zmm28 {%k4}

// CHECK: vmovdqu8.s %zmm19, %zmm28 {%k4} {z}
// CHECK:  encoding: [0x62,0x81,0x7f,0xcc,0x7f,0xdc]
          vmovdqu8.s %zmm19, %zmm28 {%k4} {z}

