/**********************************************************
 * This file has been automatically created by "typemaker2"
 * from the file "cryptparams.xml".
 * Please do not edit this file, all changes will be lost.
 * Better edit the mentioned source file instead.
 **********************************************************/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include "./cryptparams_p.h"

#include <gwenhywfar/misc.h>
#include <gwenhywfar/debug.h>

/* code headers */

/* macro functions */


AQFINTS_CRYPTPARAMS_OPMODE AQFINTS_CryptParams_OpMode_fromString(const char *p_s)
{
  if (p_s && *p_s) {
    if (strcasecmp(p_s, "none")==0)
      return AQFINTS_CryptParams_OpModeNone;
    else if (strcasecmp(p_s, "cbc")==0)
      return AQFINTS_CryptParams_OpModeCbc;
    else if (strcasecmp(p_s, "iso9796_1")==0)
      return AQFINTS_CryptParams_OpModeIso9796_1;
    else if (strcasecmp(p_s, "iso9796_2")==0)
      return AQFINTS_CryptParams_OpModeIso9796_2;
    else if (strcasecmp(p_s, "rsa_Pkcs1_v1_5")==0)
      return AQFINTS_CryptParams_OpModeRsa_Pkcs1_v1_5;
    else if (strcasecmp(p_s, "rsa_Pss")==0)
      return AQFINTS_CryptParams_OpModeRsa_Pss;
    else if (strcasecmp(p_s, "retail_MAC")==0)
      return AQFINTS_CryptParams_OpModeRetail_MAC;
  }
  return AQFINTS_CryptParams_OpModeUnknown;
}

AQFINTS_CRYPTPARAMS_HASHALGO AQFINTS_CryptParams_HashAlgo_fromString(const char *p_s)
{
  if (p_s && *p_s) {
    if (strcasecmp(p_s, "none")==0)
      return AQFINTS_CryptParams_HashAlgoNone;
    else if (strcasecmp(p_s, "sha1")==0)
      return AQFINTS_CryptParams_HashAlgoSha1;
    else if (strcasecmp(p_s, "sha256")==0)
      return AQFINTS_CryptParams_HashAlgoSha256;
    else if (strcasecmp(p_s, "sha256sha256")==0)
      return AQFINTS_CryptParams_HashAlgoSha256sha256;
    else if (strcasecmp(p_s, "ripeMd160")==0)
      return AQFINTS_CryptParams_HashAlgoRipeMd160;
  }
  return AQFINTS_CryptParams_HashAlgoUnknown;
}

AQFINTS_CRYPTPARAMS_SIGNALGO AQFINTS_CryptParams_SignAlgo_fromString(const char *p_s)
{
  if (p_s && *p_s) {
    if (strcasecmp(p_s, "none")==0)
      return AQFINTS_CryptParams_SignAlgoNone;
    else if (strcasecmp(p_s, "des")==0)
      return AQFINTS_CryptParams_SignAlgoDes;
    else if (strcasecmp(p_s, "rsa")==0)
      return AQFINTS_CryptParams_SignAlgoRsa;
  }
  return AQFINTS_CryptParams_SignAlgoUnknown;
}

AQFINTS_CRYPTPARAMS_CRYPTALGO AQFINTS_CryptParams_CryptAlgo_fromString(const char *p_s)
{
  if (p_s && *p_s) {
    if (strcasecmp(p_s, "none")==0)
      return AQFINTS_CryptParams_CryptAlgoNone;
    else if (strcasecmp(p_s, "twoKeyTripleDes")==0)
      return AQFINTS_CryptParams_CryptAlgoTwoKeyTripleDes;
    else if (strcasecmp(p_s, "aes256")==0)
      return AQFINTS_CryptParams_CryptAlgoAes256;
  }
  return AQFINTS_CryptParams_CryptAlgoUnknown;
}

AQFINTS_CRYPTPARAMS_SIGUSAGE AQFINTS_CryptParams_SigUsage_fromString(const char *p_s)
{
  if (p_s && *p_s) {
    if (strcasecmp(p_s, "none")==0)
      return AQFINTS_CryptParams_SigUsageNone;
    else if (strcasecmp(p_s, "ownerSigning")==0)
      return AQFINTS_CryptParams_SigUsageOwnerSigning;
  }
  return AQFINTS_CryptParams_SigUsageUnknown;
}

const char *AQFINTS_CryptParams_OpMode_toString(AQFINTS_CRYPTPARAMS_OPMODE p_i)
{
  switch (p_i) {
  case AQFINTS_CryptParams_OpModeNone:
    return "none";
  case AQFINTS_CryptParams_OpModeCbc:
    return "cbc";
  case AQFINTS_CryptParams_OpModeIso9796_1:
    return "iso9796_1";
  case AQFINTS_CryptParams_OpModeIso9796_2:
    return "iso9796_2";
  case AQFINTS_CryptParams_OpModeRsa_Pkcs1_v1_5:
    return "rsa_Pkcs1_v1_5";
  case AQFINTS_CryptParams_OpModeRsa_Pss:
    return "rsa_Pss";
  case AQFINTS_CryptParams_OpModeRetail_MAC:
    return "retail_MAC";
  case AQFINTS_CryptParams_OpModeUnknown:
  default:
    return "unknown";
  }
}

const char *AQFINTS_CryptParams_HashAlgo_toString(AQFINTS_CRYPTPARAMS_HASHALGO p_i)
{
  switch (p_i) {
  case AQFINTS_CryptParams_HashAlgoNone:
    return "none";
  case AQFINTS_CryptParams_HashAlgoSha1:
    return "sha1";
  case AQFINTS_CryptParams_HashAlgoSha256:
    return "sha256";
  case AQFINTS_CryptParams_HashAlgoSha256sha256:
    return "sha256sha256";
  case AQFINTS_CryptParams_HashAlgoRipeMd160:
    return "ripeMd160";
  case AQFINTS_CryptParams_HashAlgoUnknown:
  default:
    return "unknown";
  }
}

const char *AQFINTS_CryptParams_SignAlgo_toString(AQFINTS_CRYPTPARAMS_SIGNALGO p_i)
{
  switch (p_i) {
  case AQFINTS_CryptParams_SignAlgoNone:
    return "none";
  case AQFINTS_CryptParams_SignAlgoDes:
    return "des";
  case AQFINTS_CryptParams_SignAlgoRsa:
    return "rsa";
  case AQFINTS_CryptParams_SignAlgoUnknown:
  default:
    return "unknown";
  }
}

const char *AQFINTS_CryptParams_CryptAlgo_toString(AQFINTS_CRYPTPARAMS_CRYPTALGO p_i)
{
  switch (p_i) {
  case AQFINTS_CryptParams_CryptAlgoNone:
    return "none";
  case AQFINTS_CryptParams_CryptAlgoTwoKeyTripleDes:
    return "twoKeyTripleDes";
  case AQFINTS_CryptParams_CryptAlgoAes256:
    return "aes256";
  case AQFINTS_CryptParams_CryptAlgoUnknown:
  default:
    return "unknown";
  }
}

const char *AQFINTS_CryptParams_SigUsage_toString(AQFINTS_CRYPTPARAMS_SIGUSAGE p_i)
{
  switch (p_i) {
  case AQFINTS_CryptParams_SigUsageNone:
    return "none";
  case AQFINTS_CryptParams_SigUsageOwnerSigning:
    return "ownerSigning";
  case AQFINTS_CryptParams_SigUsageUnknown:
  default:
    return "unknown";
  }
}

AQFINTS_CRYPTPARAMS *AQFINTS_CryptParams_new(void)
{
  AQFINTS_CRYPTPARAMS *p_struct;

  GWEN_NEW_OBJECT(AQFINTS_CRYPTPARAMS, p_struct)
  /* members */
  p_struct->securityProfileName=NULL;
  p_struct->securityProfileVersion=0;
  p_struct->signAlgo=AQFINTS_CryptParams_SignAlgoUnknown;
  p_struct->opModeSign=AQFINTS_CryptParams_OpModeUnknown;
  p_struct->opModeAuth=AQFINTS_CryptParams_OpModeUnknown;
  p_struct->sigUsage=AQFINTS_CryptParams_SigUsageUnknown;
  p_struct->hashAlgoSign=AQFINTS_CryptParams_HashAlgoUnknown;
  p_struct->hashAlgoAuth=AQFINTS_CryptParams_HashAlgoUnknown;
  p_struct->cryptAlgo=AQFINTS_CryptParams_CryptAlgoUnknown;
  p_struct->opModeCrypt=AQFINTS_CryptParams_OpModeUnknown;
  /* virtual functions */

  return p_struct;
}

void AQFINTS_CryptParams_free(AQFINTS_CRYPTPARAMS *p_struct)
{
  if (p_struct) {
    /* members */
    free(p_struct->securityProfileName);
    p_struct->securityProfileName=NULL;
    GWEN_FREE_OBJECT(p_struct);
  }
}

AQFINTS_CRYPTPARAMS *AQFINTS_CryptParams_dup(const AQFINTS_CRYPTPARAMS *p_src)
{
  AQFINTS_CRYPTPARAMS *p_struct;

  assert(p_src);
  p_struct=AQFINTS_CryptParams_new();
  /* member "securityProfileName" */
  if (p_struct->securityProfileName) {
    free(p_struct->securityProfileName);
    p_struct->securityProfileName=NULL;
    p_struct->securityProfileName=NULL;
  }
  if (p_src->securityProfileName) {
    p_struct->securityProfileName=strdup(p_src->securityProfileName);
  }

  /* member "securityProfileVersion" */
  p_struct->securityProfileVersion=p_src->securityProfileVersion;

  /* member "signAlgo" */
  p_struct->signAlgo=p_src->signAlgo;

  /* member "opModeSign" */
  p_struct->opModeSign=p_src->opModeSign;

  /* member "opModeAuth" */
  p_struct->opModeAuth=p_src->opModeAuth;

  /* member "sigUsage" */
  p_struct->sigUsage=p_src->sigUsage;

  /* member "hashAlgoSign" */
  p_struct->hashAlgoSign=p_src->hashAlgoSign;

  /* member "hashAlgoAuth" */
  p_struct->hashAlgoAuth=p_src->hashAlgoAuth;

  /* member "cryptAlgo" */
  p_struct->cryptAlgo=p_src->cryptAlgo;

  /* member "opModeCrypt" */
  p_struct->opModeCrypt=p_src->opModeCrypt;

  return p_struct;
}

AQFINTS_CRYPTPARAMS *AQFINTS_CryptParams_copy(AQFINTS_CRYPTPARAMS *p_struct, const AQFINTS_CRYPTPARAMS *p_src)
{
  assert(p_struct);
  assert(p_src);
  /* member "securityProfileName" */
  if (p_struct->securityProfileName) {
    free(p_struct->securityProfileName);
    p_struct->securityProfileName=NULL;
    p_struct->securityProfileName=NULL;
  }
  if (p_src->securityProfileName) {
    p_struct->securityProfileName=strdup(p_src->securityProfileName);
  }

  /* member "securityProfileVersion" */
  p_struct->securityProfileVersion=p_src->securityProfileVersion;

  /* member "signAlgo" */
  p_struct->signAlgo=p_src->signAlgo;

  /* member "opModeSign" */
  p_struct->opModeSign=p_src->opModeSign;

  /* member "opModeAuth" */
  p_struct->opModeAuth=p_src->opModeAuth;

  /* member "sigUsage" */
  p_struct->sigUsage=p_src->sigUsage;

  /* member "hashAlgoSign" */
  p_struct->hashAlgoSign=p_src->hashAlgoSign;

  /* member "hashAlgoAuth" */
  p_struct->hashAlgoAuth=p_src->hashAlgoAuth;

  /* member "cryptAlgo" */
  p_struct->cryptAlgo=p_src->cryptAlgo;

  /* member "opModeCrypt" */
  p_struct->opModeCrypt=p_src->opModeCrypt;

  return p_struct;
}

const char *AQFINTS_CryptParams_GetSecurityProfileName(const AQFINTS_CRYPTPARAMS *p_struct)
{
  assert(p_struct);
  return p_struct->securityProfileName;
}

int AQFINTS_CryptParams_GetSecurityProfileVersion(const AQFINTS_CRYPTPARAMS *p_struct)
{
  assert(p_struct);
  return p_struct->securityProfileVersion;
}

AQFINTS_CRYPTPARAMS_SIGNALGO AQFINTS_CryptParams_GetSignAlgo(const AQFINTS_CRYPTPARAMS *p_struct)
{
  assert(p_struct);
  return p_struct->signAlgo;
}

AQFINTS_CRYPTPARAMS_OPMODE AQFINTS_CryptParams_GetOpModeSign(const AQFINTS_CRYPTPARAMS *p_struct)
{
  assert(p_struct);
  return p_struct->opModeSign;
}

AQFINTS_CRYPTPARAMS_OPMODE AQFINTS_CryptParams_GetOpModeAuth(const AQFINTS_CRYPTPARAMS *p_struct)
{
  assert(p_struct);
  return p_struct->opModeAuth;
}

AQFINTS_CRYPTPARAMS_SIGUSAGE AQFINTS_CryptParams_GetSigUsage(const AQFINTS_CRYPTPARAMS *p_struct)
{
  assert(p_struct);
  return p_struct->sigUsage;
}

AQFINTS_CRYPTPARAMS_HASHALGO AQFINTS_CryptParams_GetHashAlgoSign(const AQFINTS_CRYPTPARAMS *p_struct)
{
  assert(p_struct);
  return p_struct->hashAlgoSign;
}

AQFINTS_CRYPTPARAMS_HASHALGO AQFINTS_CryptParams_GetHashAlgoAuth(const AQFINTS_CRYPTPARAMS *p_struct)
{
  assert(p_struct);
  return p_struct->hashAlgoAuth;
}

AQFINTS_CRYPTPARAMS_CRYPTALGO AQFINTS_CryptParams_GetCryptAlgo(const AQFINTS_CRYPTPARAMS *p_struct)
{
  assert(p_struct);
  return p_struct->cryptAlgo;
}

AQFINTS_CRYPTPARAMS_OPMODE AQFINTS_CryptParams_GetOpModeCrypt(const AQFINTS_CRYPTPARAMS *p_struct)
{
  assert(p_struct);
  return p_struct->opModeCrypt;
}

void AQFINTS_CryptParams_SetSecurityProfileName(AQFINTS_CRYPTPARAMS *p_struct, const char *p_src)
{
  assert(p_struct);
  if (p_struct->securityProfileName) {
    free(p_struct->securityProfileName);
    p_struct->securityProfileName=NULL;
  }
  if (p_src) {
    p_struct->securityProfileName=strdup(p_src);
  }
  else {
    p_struct->securityProfileName=NULL;
  }
}

void AQFINTS_CryptParams_SetSecurityProfileVersion(AQFINTS_CRYPTPARAMS *p_struct, int p_src)
{
  assert(p_struct);
  p_struct->securityProfileVersion=p_src;
}

void AQFINTS_CryptParams_SetSignAlgo(AQFINTS_CRYPTPARAMS *p_struct, AQFINTS_CRYPTPARAMS_SIGNALGO  p_src)
{
  assert(p_struct);
  p_struct->signAlgo=p_src;
}

void AQFINTS_CryptParams_SetOpModeSign(AQFINTS_CRYPTPARAMS *p_struct, AQFINTS_CRYPTPARAMS_OPMODE  p_src)
{
  assert(p_struct);
  p_struct->opModeSign=p_src;
}

void AQFINTS_CryptParams_SetOpModeAuth(AQFINTS_CRYPTPARAMS *p_struct, AQFINTS_CRYPTPARAMS_OPMODE  p_src)
{
  assert(p_struct);
  p_struct->opModeAuth=p_src;
}

void AQFINTS_CryptParams_SetSigUsage(AQFINTS_CRYPTPARAMS *p_struct, AQFINTS_CRYPTPARAMS_SIGUSAGE  p_src)
{
  assert(p_struct);
  p_struct->sigUsage=p_src;
}

void AQFINTS_CryptParams_SetHashAlgoSign(AQFINTS_CRYPTPARAMS *p_struct, AQFINTS_CRYPTPARAMS_HASHALGO  p_src)
{
  assert(p_struct);
  p_struct->hashAlgoSign=p_src;
}

void AQFINTS_CryptParams_SetHashAlgoAuth(AQFINTS_CRYPTPARAMS *p_struct, AQFINTS_CRYPTPARAMS_HASHALGO  p_src)
{
  assert(p_struct);
  p_struct->hashAlgoAuth=p_src;
}

void AQFINTS_CryptParams_SetCryptAlgo(AQFINTS_CRYPTPARAMS *p_struct, AQFINTS_CRYPTPARAMS_CRYPTALGO  p_src)
{
  assert(p_struct);
  p_struct->cryptAlgo=p_src;
}

void AQFINTS_CryptParams_SetOpModeCrypt(AQFINTS_CRYPTPARAMS *p_struct, AQFINTS_CRYPTPARAMS_OPMODE  p_src)
{
  assert(p_struct);
  p_struct->opModeCrypt=p_src;
}

static const AQFINTS_CRYPTPARAMS cryptParamArray[]= {
  {
    "RDH",
    1,
    AQFINTS_CryptParams_SignAlgoRsa,
    AQFINTS_CryptParams_OpModeIso9796_1,
    AQFINTS_CryptParams_OpModeNone,
    AQFINTS_CryptParams_SigUsageOwnerSigning,
    AQFINTS_CryptParams_HashAlgoRipeMd160,
    AQFINTS_CryptParams_HashAlgoNone,
    AQFINTS_CryptParams_CryptAlgoTwoKeyTripleDes,
    AQFINTS_CryptParams_OpModeCbc
  },


  {
    "RDH",
    2,
    AQFINTS_CryptParams_SignAlgoRsa,
    AQFINTS_CryptParams_OpModeIso9796_2,
    AQFINTS_CryptParams_OpModeNone,
    AQFINTS_CryptParams_SigUsageOwnerSigning,
    AQFINTS_CryptParams_HashAlgoRipeMd160,
    AQFINTS_CryptParams_HashAlgoNone,
    AQFINTS_CryptParams_CryptAlgoTwoKeyTripleDes,
    AQFINTS_CryptParams_OpModeCbc
  },


  {
    "RDH",
    3,
    AQFINTS_CryptParams_SignAlgoRsa,
    AQFINTS_CryptParams_OpModeRsa_Pkcs1_v1_5,
    AQFINTS_CryptParams_OpModeIso9796_2,
    AQFINTS_CryptParams_SigUsageOwnerSigning,
    AQFINTS_CryptParams_HashAlgoSha1,
    AQFINTS_CryptParams_HashAlgoRipeMd160,
    AQFINTS_CryptParams_CryptAlgoTwoKeyTripleDes,
    AQFINTS_CryptParams_OpModeRsa_Pkcs1_v1_5
  },


  {
    "RDH",
    5,
    AQFINTS_CryptParams_SignAlgoRsa,
    AQFINTS_CryptParams_OpModeRsa_Pkcs1_v1_5,
    AQFINTS_CryptParams_OpModeNone,
    AQFINTS_CryptParams_SigUsageOwnerSigning,
    AQFINTS_CryptParams_HashAlgoSha1,
    AQFINTS_CryptParams_HashAlgoNone,
    AQFINTS_CryptParams_CryptAlgoTwoKeyTripleDes,
    AQFINTS_CryptParams_OpModeRsa_Pkcs1_v1_5
  },


  {
    "RDH",
    6,
    AQFINTS_CryptParams_SignAlgoRsa,
    AQFINTS_CryptParams_OpModeRsa_Pkcs1_v1_5,
    AQFINTS_CryptParams_OpModeRsa_Pkcs1_v1_5,
    AQFINTS_CryptParams_SigUsageOwnerSigning,
    AQFINTS_CryptParams_HashAlgoSha256,
    AQFINTS_CryptParams_HashAlgoSha256,
    AQFINTS_CryptParams_CryptAlgoTwoKeyTripleDes,
    AQFINTS_CryptParams_OpModeRsa_Pkcs1_v1_5
  },


  {
    "RDH",
    7,
    AQFINTS_CryptParams_SignAlgoRsa,
    AQFINTS_CryptParams_OpModeRsa_Pss,
    AQFINTS_CryptParams_OpModeRsa_Pss,
    AQFINTS_CryptParams_SigUsageOwnerSigning,
    AQFINTS_CryptParams_HashAlgoSha256sha256,
    AQFINTS_CryptParams_HashAlgoSha256,
    AQFINTS_CryptParams_CryptAlgoTwoKeyTripleDes,
    AQFINTS_CryptParams_OpModeRsa_Pkcs1_v1_5
  },


  {
    "RDH",
    8,
    AQFINTS_CryptParams_SignAlgoRsa,
    AQFINTS_CryptParams_OpModeRsa_Pkcs1_v1_5,
    AQFINTS_CryptParams_OpModeNone,
    AQFINTS_CryptParams_SigUsageOwnerSigning,
    AQFINTS_CryptParams_HashAlgoSha256,
    AQFINTS_CryptParams_HashAlgoNone,
    AQFINTS_CryptParams_CryptAlgoTwoKeyTripleDes,
    AQFINTS_CryptParams_OpModeRsa_Pkcs1_v1_5
  },


  {
    "RDH",
    9,
    AQFINTS_CryptParams_SignAlgoRsa,
    AQFINTS_CryptParams_OpModeRsa_Pss,
    AQFINTS_CryptParams_OpModeNone,
    AQFINTS_CryptParams_SigUsageOwnerSigning,
    AQFINTS_CryptParams_HashAlgoSha256sha256,
    AQFINTS_CryptParams_HashAlgoNone,
    AQFINTS_CryptParams_CryptAlgoTwoKeyTripleDes,
    AQFINTS_CryptParams_OpModeRsa_Pkcs1_v1_5
  },


  {
    "RDH",
    10,
    AQFINTS_CryptParams_SignAlgoRsa,
    AQFINTS_CryptParams_OpModeRsa_Pss,
    AQFINTS_CryptParams_OpModeNone,
    AQFINTS_CryptParams_SigUsageOwnerSigning,
    AQFINTS_CryptParams_HashAlgoSha256sha256,
    AQFINTS_CryptParams_HashAlgoNone,
    AQFINTS_CryptParams_CryptAlgoTwoKeyTripleDes,
    AQFINTS_CryptParams_OpModeCbc
  },


  {
    "RAH",
    7,
    AQFINTS_CryptParams_SignAlgoRsa,
    AQFINTS_CryptParams_OpModeRsa_Pss,
    AQFINTS_CryptParams_OpModeRsa_Pss,
    AQFINTS_CryptParams_SigUsageOwnerSigning,
    AQFINTS_CryptParams_HashAlgoSha256sha256,
    AQFINTS_CryptParams_HashAlgoSha256,
    AQFINTS_CryptParams_CryptAlgoAes256,
    AQFINTS_CryptParams_OpModeRsa_Pkcs1_v1_5
  },


  {
    "RAH",
    9,
    AQFINTS_CryptParams_SignAlgoRsa,
    AQFINTS_CryptParams_OpModeRsa_Pss,
    AQFINTS_CryptParams_OpModeNone,
    AQFINTS_CryptParams_SigUsageOwnerSigning,
    AQFINTS_CryptParams_HashAlgoSha256sha256,
    AQFINTS_CryptParams_HashAlgoNone,
    AQFINTS_CryptParams_CryptAlgoAes256,
    AQFINTS_CryptParams_OpModeRsa_Pkcs1_v1_5
  },


  {
    "RAH",
    10,
    AQFINTS_CryptParams_SignAlgoRsa,
    AQFINTS_CryptParams_OpModeRsa_Pss,
    AQFINTS_CryptParams_OpModeNone,
    AQFINTS_CryptParams_SigUsageOwnerSigning,
    AQFINTS_CryptParams_HashAlgoSha256sha256,
    AQFINTS_CryptParams_HashAlgoNone,
    AQFINTS_CryptParams_CryptAlgoAes256,
    AQFINTS_CryptParams_OpModeCbc
  }
};


const AQFINTS_CRYPTPARAMS *AQFINTS_CryptParams_GetParamsForSecurityProfile(const char *securityProfileName,
                                                                           int securityProfileVersion)
{
  int i;
  const AQFINTS_CRYPTPARAMS *p;
  int arrayMemberCount;

  arrayMemberCount=*(&cryptParamArray+1)-cryptParamArray;
  p=cryptParamArray;
  for (i=0; i< arrayMemberCount; i++) {
    if ((strcasecmp(p->securityProfileName, securityProfileName)==0) &&
        (p->securityProfileVersion==securityProfileVersion))
      return p;
    p++;
  }

  return NULL;
}


/* code headers */

