/*--------------------------------------------------------------------------+
$Id: StreamDrainerThread.java 26283 2010-02-18 11:18:57Z juergens $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.commons.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

import edu.tum.cs.commons.assertion.CCSMAssert;

/**
 * A thread to drain an input stream. Read content is discarded.
 * 
 * @author Elmar Juergens
 * @author Florian Deissenboeck
 * @author $Author: juergens $
 * @version $Rev: 26283 $
 * @levd.rating GREEN Hash: 540B98ECCE4EE60DC5A69D0C6A03DB2C
 */
public class StreamDrainerThread extends Thread {

	/** Stream the reader reads from. */
	private final InputStream input;

	/**
	 * Create a new reader that immediately starts to drain the content of this
	 * stream . This call is non- blocking
	 * 
	 * @param input
	 *            Stream to read from.
	 */
	public StreamDrainerThread(InputStream input) {
		super();
		this.input = input;
		start();
	}

	/** Reads content from the stream as long as the stream is not empty. */
	@Override
	public synchronized void run() {
		BufferedReader reader = new BufferedReader(new InputStreamReader(input));
		char[] buffer = new char[1024];

		try {
			@SuppressWarnings("unused")
			int read = 0;
			while ((read = reader.read(buffer)) != -1) {
				// throw away read content
			}
		} catch (IOException e) {
			CCSMAssert.fail("Error draining stream: " + e.getMessage());
		}
	}

}