/*--------------------------------------------------------------------------+
$Id: MD5DigestTest.java 28975 2010-07-01 12:09:24Z hummelb $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.commons.digest;

import java.security.MessageDigest;

import junit.framework.TestCase;
import edu.tum.cs.commons.io.SerializationUtils;

/**
 * Tests for {@link MD5Digest}.
 * 
 * @author hummelb
 * @author $Author: hummelb $
 * @version $Rev: 28975 $
 * @levd.rating GREEN Hash: 6AC5D9945744681AB763DA9A59AFDDD2
 */
public class MD5DigestTest extends TestCase {

	/** Tests whether the (custom) serialization works. */
	public void testSerialization() {
		MessageDigest md5 = Digester.getMD5();
		md5.update("TestData".getBytes());

		MD5Digest digest = new MD5Digest(md5);
		MD5Digest copy = SerializationUtils.cloneBySerialization(digest, null);

		assertNotSame(digest, copy);
		assertEquals(digest, copy);
		assertEquals(digest.hashCode(), copy.hashCode());
	}

	/** Tests comparison. */
	public void testCompare() {
		MD5Digest digest1 = new MD5Digest(new byte[] { 7, 8, 9, 1, 2, 3, 4, 5,
				6, 7, 8, 9, 10, 11, 12, 13 });
		MD5Digest digest2 = new MD5Digest(new byte[] { 7, 8, 10, 1, 2, 3, 4, 5,
				6, 7, 8, 9, 10, 11, 12, 13 });

		assertTrue(digest1.compareTo(digest1) == 0);
		assertTrue(digest2.compareTo(digest1) > 0);
		assertTrue(digest1.compareTo(digest2) < 0);
	}
}