/*--------------------------------------------------------------------------+
$Id: StateflowEvent.java 26285 2010-02-18 11:22:54Z juergens $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.simulink.model.stateflow;

import edu.tum.cs.commons.assertion.CCSMPre;

/**
 * A Stateflow event object.
 * 
 * @author deissenb
 * @author $Author: juergens $
 * @version $Rev: 26285 $
 * @levd.rating GREEN Hash: 9F7367F85F8ABD632963D2467A4ACE1A
 */
public class StateflowEvent extends StateflowDeclBase {

	/** Create event. */
	public StateflowEvent() {
		super();
	}

	/** Copy constructor for deep cloning. */
	private StateflowEvent(StateflowEvent orig) {
		super(orig);
	}

	/** Remove this event from the model. */
	@Override
	public void remove() {
		CCSMPre.isFalse(getParent() == null,
				"Event has no parent to be removed from.");
		getParent().removeEvent(this);
	}

	/** Deep clone this event. */
	public StateflowEvent deepClone() {
		return new StateflowEvent(this);
	}
}