/*
 * @(#)PackageSorter.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.codecoverage.v2.report;


import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import net.sourceforge.groboutils.codecoverage.v2.IAnalysisMetaData;


/**
 * Sorts classes into packages.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version   $Date: 2004/04/15 05:48:26 $
 * @since     December 17, 2002
 * @see       IAnalysisMetaData
 */
public class PackageSorter
{
    private Map packagesToClassSet = new HashMap();
    
    /**
     * 
     */
    public PackageSorter()
    {
        // do nothing
    }
    
    
    public void addClassSignatures( String classSigs[] )
    {
        if (classSigs == null)
        {
            throw new IllegalArgumentException("no null args");
        }
        
        for (int i = 0; i < classSigs.length; ++i)
        {
            addClassSignature( classSigs[i] );
        }
    }
    
    
    public void addClassSignature( String classSig )
    {
        if (classSig == null)
        {
            throw new IllegalArgumentException("no null args");
        }
        
        String packageName = getPackageName( classSig );
        Set classSigSet = (Set)this.packagesToClassSet.get( packageName );
        if (classSigSet == null)
        {
            classSigSet = new HashSet();
            this.packagesToClassSet.put( packageName, classSigSet );
        }
        classSigSet.add( classSig );
    }
    
    
    /**
     * Returns a list of all registered packages.
     */
    public String[] getPackages()
    {
        Set s = this.packagesToClassSet.keySet();
        String[] pkgs = (String[])s.toArray( new String[ s.size() ] );
        return pkgs;
    }
    
    
    /**
     * Returns all class signatures for a specific package.
     */
    public String[] getClassSignaturesForPackage( String packageName )
    {
        Set s = (Set)this.packagesToClassSet.get( packageName );
        if (s == null)
        {
            return new String[0];
        }
        return (String[])s.toArray( new String[ s.size() ] );
    }
    
    
    public static String getPackageName( String classSig )
    {
        if (classSig == null)
        {
            throw new IllegalArgumentException("no null args");
        }
        String pkg = "";
        int pos = classSig.lastIndexOf( '.' );
        if (pos >= 0)
        {
            pkg = classSig.substring( 0, pos );
        }
        return pkg;
    }
}

