/*
 *  @(#)IProblemManager.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Part of the GroboUtils package at:
 *  http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */
package net.sourceforge.groboutils.pmti.v1;

 

/**
 * The master class (generally a facade) responsible for interfacing the
 * programmer with the Problem Management Tracker, implementing not only the
 * query and change elements, but also enforcing the workflow logic associated
 * with the underlying tracker.
 *
 * @author     Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version    $Date: 2003/02/10 22:51:54 $
 * @since      July 7, 2002
 */
public interface IProblemManager
{
    
    /**
     * Returns a list of all issue IDs known by the PMT.  This may be an
     * extremely expensive operation, depending on the size of the underlying
     * system.  This call must never return <tt>null</tt>.  This should never
     * return new issues that have not been comitted yet.
     */
    public String[] getIssueIDs()
            throws ProblemManagerException;
    
    
    /**
     * Returns all issue IDs that match the given 'template'.  A template is
     * an issue where all <tt>null</tt> values are considered 'wildcards',
     * so that a <tt>null</tt> state, for instance, would match for any
     * state object.  May change the template in the future to a different
     * but similar type to allow for regular-expressions.
     */
    public String[] getIssueIDsForTemplate( IIssue issue )
            throws ProblemManagerException;
    
    
    /**
     * Returns the issue associated with the given unique issue ID.  If no such
     * issue exists, then <tt>null</tt> is returned.  Note that the returned
     * element is a non-editable version of the issue.
     */
    public IIssue getIssueByID( String id )
            throws ProblemManagerException;
    
    
    /**
     * Given the real issue, returns the editable version of the issue.
     */
    public IEditableIssue editIssue( IIssue issue )
            throws ProblemManagerException;
    
    
    /**
     * Creates a new issue of the given type.  If <tt>type</tt> is
     * <tt>null</tt>, then a new issue of the default issue type is
     * created and returned.
     */
    public IEditableIssue createIssue( String type )
            throws ProblemManagerException;
    
    
    /**
     * Returns all meta-data for this problem management tracker.
     */
    public IProblemManagerInfo getProblemManagerInfo();
}

