/*
 *  @(#)ITFMonitor.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Part of the GroboUtils package at:
 *  http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */
package net.sourceforge.groboutils.pmti.v1.autodoc.v1;


import net.sourceforge.groboutils.autodoc.v1.testserver.Monitor;
import net.sourceforge.groboutils.autodoc.v1.testserver.DefaultMonitor;
import net.sourceforge.groboutils.autodoc.v1.testserver.Server;
import net.sourceforge.groboutils.autodoc.v1.testserver.TestDataFactory;

import net.sourceforge.groboutils.util.classes.v1.SingletonStore;


/**
 * This implemenation of <tt>Monitor</tt> uses a Hashtable to store the
 * test data.
 * <P>
 * This probably should be rewritten so that DefaultMonitor is a delegate-to
 * inner object, not a super class.
 *
 * @author     Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @since      March 17, 2002
 * @version    $Date: 2003/02/10 22:51:56 $
 */
public class ITFMonitor extends DefaultMonitor // implements Monitor
{
    public static final String FACTORY_PROPERTY_NAME =
        ITFFactory.class.getName() + ".implementation";
    public static final Class DEFAULT_FACTORY = DefaultITFFactory.class;

    private static final SingletonStore s_factoryStore = new SingletonStore(
        ITFFactory.class, DEFAULT_FACTORY, FACTORY_PROPERTY_NAME );
    
    
    
    /**
     * Default constructor.
     */
    public ITFMonitor()
    {
        this( getFactory().getServer(), getFactory().getTestDataFactory() );
    }
    
    
    /**
     * Constructor for a Monitor requiring a reference to the Server which will
     * receive the completed <tt>TestData</tt> structures, and a reference to
     * a factory for creating new <tt>TestData</tt> instances for the particular
     * framework this Monitor belongs to.
     *
     * @param s the server to receive completed <tt>TestData</tt> entities.
     *      This cannot be <tt>null</tt>.
     * @param f the factory in charge of creating new <tt>TestData</tt>
     *      entities.  This cannot be <tt>null</tt>.
     * @exception IllegalArgumentException if <tt>s</tt> or <tt>f</tt> is
     *      <tt>null</tt>.
     */
    public ITFMonitor( Server s, TestDataFactory f )
    {
        super( s, f );
    }



    
    
    /**
     * Retrieves the pseudo-singleton factory of the correct type.
     */
    public static ITFFactory getFactory()
    {
        return (ITFFactory)getFactoryStore().getSingleton();
    }
    
    
    /**
     * Set the factory to whatever is in the system property.
     */
    public static SingletonStore getFactoryStore()
    {
        return s_factoryStore;
    }
}

