/*
 *  @(#)ITFMonitorFinder.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Part of the GroboUtils package at:
 *  http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */
package net.sourceforge.groboutils.pmti.v1.autodoc.v1;


import net.sourceforge.groboutils.autodoc.v1.testserver.MonitorFinder;
import net.sourceforge.groboutils.autodoc.v1.testserver.Monitor;

import net.sourceforge.groboutils.util.classes.v1.SingletonStore;


/**
 * Acts as a factory and singleton store for the ITFMonitor.
 *
 * @author     Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @since      March 30, 2002
 * @version    $Date: 2003/02/10 22:51:56 $
 */
public class ITFMonitorFinder implements MonitorFinder
{
    public static final String MONITOR_PROPERTY_NAME =
        ITFMonitor.class.getName() + ".implementation";
    public static final Class DEFAULT_MONITOR = ITFMonitor.class;

    private static final SingletonStore s_monitorStore = new SingletonStore(
        Monitor.class, DEFAULT_MONITOR, MONITOR_PROPERTY_NAME );
    
    
    /**
     * Retrieves the pseudo-singleton Monitor of the correct type.
     */
    public Monitor getMonitor()
    {
        return (Monitor)getMonitorStore().getSingleton();
    }
    
    
    //-------------------------------------------------------------------------
    // Static methods
    
    /**
     * Retrieve the Monitor singleton store for setting up the Monitor
     * to be used for all uninitialized or uncreated ITFMonitorFinder instances.
     */
    public static SingletonStore getMonitorStore()
    {
        return s_monitorStore;
    }
}

