/*
 * @(#)DefaultAutoDocFactoryUTest.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.autodoc.v1.defimpl;

import net.sourceforge.groboutils.autodoc.v1.spi.AutoDocLogFactory;
import net.sourceforge.groboutils.autodoc.v1.*;
import net.sourceforge.groboutils.autodoc.v1.spi.*;

import org.easymock.EasyMock;
import org.easymock.MockControl;
import net.sourceforge.groboutils.junit.v1.iftc.*;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import java.util.*;


/**
 * Tests the DefaultAutoDocFactory class.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version   $Date: 2003/02/10 22:52:15 $
 * @since     March 27, 2002
 */
public class DefaultAutoDocFactoryUTest extends TestCase
{
    //-------------------------------------------------------------------------
    // Standard JUnit Class-specific declarations
    
    private static final Class THIS_CLASS = DefaultAutoDocFactoryUTest.class;
    
    public DefaultAutoDocFactoryUTest( String name )
    {
        super( name );
    }

    
    //-------------------------------------------------------------------------
    // setup
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void setUp() throws Exception
    {
        super.setUp();
        
        // set ourself up
    }


    //-------------------------------------------------------------------------
    // Tests
    
    
    public void testGetLogFactories1()
    {
        assertHasAtLeastOne(
            (new DefaultAutoDocFactory()).getLogFactories(),
            AutoDocLogFactory.class, true );
    }
    
    
    public void testGetITFactories1()
    {
        assertHasAtLeastOne(
            (new DefaultAutoDocFactory()).getITFactories(),
            AutoDocITFactory.class, false );
    }
    
    
    public void testGetTPFactories1()
    {
        assertHasAtLeastOne(
            (new DefaultAutoDocFactory()).getTPFactories(),
            AutoDocTPFactory.class, false );
    }
    
    
    public void testGetLogFactoryStore1()
    {
        assertNotNull(
            "Log factory store must never be null.",
            DefaultAutoDocFactory.getLogFactoryStore() );
    }
    
    
    public void testGetITFactoryStore1()
    {
        assertNotNull(
            "IT factory store must never be null.",
            DefaultAutoDocFactory.getITFactoryStore() );
    }
    
    
    public void testGetTPFactoryStore1()
    {
        assertNotNull(
            "TP factory store must never be null.",
            DefaultAutoDocFactory.getTPFactoryStore() );
    }
    
    
    
    //-------------------------------------------------------------------------
    // Helpers
    
    
    protected void assertHasAtLeastOne( Enumeration enum, Class parent,
            boolean mustHaveAtLeastOne )
    {
        assertNotNull(
            "Enumeration cannot be null.",
            enum );
        if (mustHaveAtLeastOne)
        {
            assertTrue(
                "Enumeration does not have any contents.",
            enum.hasMoreElements() );
        }
        
        while (enum.hasMoreElements())
        {
            Object o = enum.nextElement();
            assertTrue(
                "Enum contains "+o.getClass().getName()+
                    ", but is not of type "+parent.getName()+".",
                parent.isInstance( o ) );
        }
    }
    
    
    //-------------------------------------------------------------------------
    // Standard JUnit declarations
    
    
    public static Test suite()
    {
        InterfaceTestSuite suite = AutoDocFactoryUTestI.suite();
        suite.addTestSuite( THIS_CLASS );
        suite.addFactory( new CxFactory( "A" ) {
            public Object createImplObject() {
                return new DefaultAutoDocFactory();
            }
        } );
        
        return suite;
    }
    
    public static void main( String[] args )
    {
        String[] name = { THIS_CLASS.getName() };
        
        // junit.textui.TestRunner.main( name );
        // junit.swingui.TestRunner.main( name );
        
        junit.textui.TestRunner.main( name );
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void tearDown() throws Exception
    {
        // tear ourself down
        
        super.tearDown();
    }
}

