/*
 * @(#)IScriptMakerUTestI.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.uicapture.v1;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import net.sourceforge.groboutils.junit.v1.iftc.*;

import java.io.*;


/**
 * Tests the IScriptMaker interface.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version   $Date: 2003/02/10 22:52:34 $
 * @since     Oct 3, 2002
 */
public class IScriptMakerUTestI extends InterfaceTestCase
{
    
    
    //-------------------------------------------------------------------------
    // Standard JUnit Class-specific declarations
    
    private static final Class THIS_CLASS = IScriptMakerUTestI.class;
    
    public IScriptMakerUTestI( String name, ImplFactory f )
    {
        super( name, IScriptMaker.class, f );
    }

    
    //-------------------------------------------------------------------------
    // setup
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void setUp() throws Exception
    {
        super.setUp();
        
        // set ourself up
    }
    
    
    
    private IScriptMaker createIScriptMaker()
    {
        return (IScriptMaker)createImplObject();
    }
    
    
    //-------------------------------------------------------------------------
    // Tests
    
    
    public void testStart1()
    {
        IScriptMaker ism = createIScriptMaker();
        ism.start();
    }
    
    
    public void testStart2()
    {
        IScriptMaker ism = createIScriptMaker();
        ism.start();
        
        try
        {
            ism.start();
            fail( "Did not throw IllegalStateException." );
        }
        catch (IllegalStateException e)
        {
            // test exception?
        }
    }
    
    
    public void testStart3()
    {
        IScriptMaker ism = createIScriptMaker();
        ism.start();
        ism.end();
        
        try
        {
            ism.start();
            fail( "Did not throw IllegalStateException." );
        }
        catch (IllegalStateException e)
        {
            // test exception?
        }
    }
    
    
    public void testEnd1()
    {
        IScriptMaker ism = createIScriptMaker();
        ism.start();
        
        ism.end();
    }
    
    
    public void testEnd2()
    {
        IScriptMaker ism = createIScriptMaker();
        try
        {
            ism.end();
            fail( "Did not throw IllegalStateException." );
        }
        catch (IllegalStateException e)
        {
            // test exception?
        }
    }
    
    
    public void testGenerateDelay1()
    {
        IScriptMaker ism = createIScriptMaker();
        ism.start();
        
        ism.generateDelay( 100 );
    }
    
    
    public void testGenerateMoveMouseWheel1()
    {
        IScriptMaker ism = createIScriptMaker();
        ism.start();
        
        ism.generateMoveMouseWheel( 10 );
    }
    
    
    public void testGenerateMoveMouse1()
    {
        IScriptMaker ism = createIScriptMaker();
        ism.start();
        
        ism.generateMoveMouse( 10, 20 );
    }
    
    
    public void testGeneratePressMouse1()
    {
        IScriptMaker ism = createIScriptMaker();
        ism.start();
        
        ism.generatePressMouse( 0 );
    }
    
    
    public void testGenerateReleaseMouse1()
    {
        IScriptMaker ism = createIScriptMaker();
        ism.start();
        
        ism.generateReleaseMouse( 0 );
    }
    
    
    public void testGeneratePressKey1()
    {
        IScriptMaker ism = createIScriptMaker();
        ism.start();
        
        ism.generatePressKey( 1 );
    }
    
    
    public void testGenerateReleaseKey1()
    {
        IScriptMaker ism = createIScriptMaker();
        ism.start();
        
        ism.generateReleaseKey( 1 );
    }
    
    
    public void testGenerateScreenCapture1()
            throws IOException
    {
        IScriptMaker ism = createIScriptMaker();
        ism.start();
        
        File f = new File( "blah" );
        FileWriter fw = new FileWriter( f );
        try
        {
            fw.write( "blah blah" );
            fw.flush();
            fw.close();
        
            ism.generateScreenCapture( f, 1, 100, 30, 30 );
        }
        finally
        {
            f.delete();
        }
    }
    
    
    
    //-------------------------------------------------------------------------
    // Helpers
    
    
        
    //-------------------------------------------------------------------------
    // Standard JUnit declarations
    
    
    public static InterfaceTestSuite suite()
    {
        InterfaceTestSuite suite = new InterfaceTestSuite( THIS_CLASS );
        
        return suite;
    }
    
    public static void main( String[] args )
    {
        String[] name = { THIS_CLASS.getName() };
        
        // junit.textui.TestRunner.main( name );
        // junit.swingui.TestRunner.main( name );
        
        junit.textui.TestRunner.main( name );
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void tearDown() throws Exception
    {
        // tear ourself down
        
        
        super.tearDown();
    }
}

