<?xml version="1.0" encoding="ISO-8859-1"?>

<!--
  Base website construction style
  version $Date: 2004/02/02 21:34:56 $
-->

<xsl:stylesheet xmlns:xsl='http://www.w3.org/1999/XSL/Transform' version='1.0'>
    <xsl:output method="html" indent="no" />

    <xsl:param name="logoBGColor" select="'#000000'" />
    <xsl:param name="logo2BGColor" select="'#FFFFFF'" />

    <xsl:variable name="summary" select="document('input-summary.xml')"/>

    <!-- base document -->
    <xsl:template match="document">
<HTML>
<xsl:comment>
WARNING: DO NOT EDIT THIS FILE

This file was auto-generated.  Please look at the .xml version of this file
and edit that one instead.
</xsl:comment>
<HEAD>
    <LINK HREF="favicon.ico" REL="SHORTCUT ICON" />
    <TITLE>GroboUtils - <xsl:value-of select="head/name/text()" />
    </TITLE>
    <LINK REL="stylesheet" TYPE="text/css" HREF="stylesheet.css" TITLE="Style" />
    <LINK REL="start" HREF="index.html" TITLE="GroboUtils Home" />
    <xsl:if test="head/name/@url != 'index.html'">
        <LINK REL="up" HREF="index.html" />
    </xsl:if>
</HEAD>
<BODY>
<TABLE BORDER="0" WIDTH="100%">
<!--
    <TR><TD COLSPAN="2" ALIGN="LEFT" VALIGN="TOP">
        <xsl:attribute name="BGCOLOR"><xsl:value-of select="$logoBGColor" /></xsl:attribute>
    <IMG SRC="images/logo.png" ALT="GroboUtils" HEIGHT="100" WIDTH="401" />
    </TD></TR>
-->
    
    <TR><TD WIDTH="20%" VALIGN="TOP" NOWRAP="TRUE">
<!-- start nav bar -->
<TABLE><TR><TD>
        <xsl:attribute name="BGCOLOR"><xsl:value-of select="$logo2BGColor" /></xsl:attribute>
<A HREF="index.html">
<IMG SRC="images/logo2.png" ALT="GroboUtils" HEIGHT="180" WIDTH="175" />
<!-- actual dimensions: HEIGHT="211" WIDTH="205" -->
</A>
</TD></TR></TABLE>
<P><STRONG>About GroboUtils</STRONG></P>
<UL><LI>
<xsl:call-template name="NavBarEl">
  <xsl:with-param name="Title" select="'Welcome'" />
  <xsl:with-param name="Url" select="'index.html'" />
</xsl:call-template>
</LI><LI>
<xsl:call-template name="NavBarEl">
  <xsl:with-param name="Title" select="'License'" />
  <xsl:with-param name="Url" select="'license.html'" />
</xsl:call-template>
</LI><LI>
<xsl:call-template name="NavBarEl">
  <xsl:with-param name="Title" select="'Project List'" />
  <xsl:with-param name="Url" select="'allprojects.html'" />
</xsl:call-template>
</LI><LI>
<xsl:call-template name="NavBarEl">
  <xsl:with-param name="Title" select="'Contacts'" />
  <xsl:with-param name="Url" select="'contacts.html'" />
</xsl:call-template>
</LI><LI>
<xsl:call-template name="NavBarEl">
  <xsl:with-param name="Title" select="'Articles'" />
  <xsl:with-param name="Url" select="'articles.html'" />
</xsl:call-template>
</LI></UL>
<P><STRONG><a href="https://sourceforge.net/projects/groboutils/">Sourceforge<BR
/>Project</a></STRONG></P>
<UL><LI>
<a href="https://sourceforge.net/forum/?group_id=22594">Forums</a>
</LI><LI>
<a href="https://sourceforge.net/tracker/?group_id=22594&amp;atid=375589">Bugs</a>
</LI><LI>
<a href="https://sourceforge.net/tracker/?atid=375592&amp;group_id=22594">Feature Requests</a>
</LI></UL>

<P><STRONG>For Developers</STRONG></P>
<UL><LI>
<xsl:call-template name="NavBarEl">
  <xsl:with-param name="Title" select="'Downloads'" />
  <xsl:with-param name="Url" select="'downloads.html'" />
</xsl:call-template>
</LI><LI>
<xsl:call-template name="NavBarEl">
  <xsl:with-param name="Title" select="'Javadoc'" />
  <xsl:with-param name="Url" select="'documents.html'" />
</xsl:call-template>
</LI><LI>
<xsl:call-template name="NavBarEl">
  <xsl:with-param name="Title" select="'Dependencies'" />
  <xsl:with-param name="Url" select="'dependencies.html'" />
</xsl:call-template>
</LI><LI>
<xsl:call-template name="NavBarEl">
  <xsl:with-param name="Title" select="'Building'" />
  <xsl:with-param name="Url" select="'building.html'" />
</xsl:call-template>
<!--
</LI><LI>
<xsl:call-template name="NavBarEl">
  <xsl:with-param name="Title" select="'Samples'" />
  <xsl:with-param name="Url" select="'samples.html'" />
</xsl:call-template>
-->
</LI></UL>

<P><STRONG>Sub-Projects</STRONG></P>
<UL>
<xsl:for-each select="$summary//set/project-id" >
    <LI>
    <xsl:variable name="pname" select="@name" />
    <xsl:variable name="dname" select="@dir" />
    <!--
    <xsl:message terminate="no">
    Found project <xsl:value-of select="$pname" />.
    </xsl:message>
    -->
    <xsl:call-template name="NavBarEl">
        <xsl:with-param name="Title" select="$pname" />
        <xsl:with-param name="Url" select="concat( $dname, '/index.html' )" />
    </xsl:call-template>
    </LI>
</xsl:for-each>
</UL>
</TD>
<!-- end nav bar -->

<!-- start the current page -->
<TD WIDTH="80%" ALIGN="LEFT" VALIGN="TOP">
<CENTER>
<H1><xsl:value-of select="head/name/text()" /></H1>
</CENTER>
<xsl:apply-templates select="body" />
</TD></TR>
</TABLE>
<BR /><BR />
<TABLE WIDTH="100%">
<TR>
    <TD COLSPAN="2" WIDTH="100%">
        <HR />
    </TD>
</TR>
<TR>
    <TD ALIGN="LEFT">
        <A href="https://sourceforge.net"><IMG
            src="https://sourceforge.net/sflogo.php?group_id=22594&amp;type=1"
            width="88" height="31" border="0" alt="SourceForge Logo" /></A>
        <BR />
        <I>This space graciously provided by the SourceForge project</I>
    </TD>
    <TD ALIGN="RIGHT">
        <I><xsl:text disable-output-escaping="yes">Copyright &amp;copy;
2002-2003 GroboUtils Project.</xsl:text><BR />All rights reserved.</I>
    </TD>
</TR>
</TABLE>
</BODY>
</HTML>
    </xsl:template>

    <xsl:template name="NavBarEl">
        <xsl:param name="Title" select="unknown" />
        <xsl:param name="Url" select="unknown" />
        <!--
        <xsl:message terminate="no">
        Nav link for <xsl:value-of select="$Title" />.
        </xsl:message>
        -->
        <xsl:choose>
            <xsl:when test="head/name/@url = $Url" >
                <font color="gray"> <xsl:value-of select="$Title" /> </font>
            </xsl:when>
            <xsl:otherwise>
                <a href="{$Url}"><xsl:value-of select="$Title" /></a>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <!-- Copy all the text -->
    <xsl:template match="body">
        <xsl:apply-templates select="text()|*" />
    </xsl:template>
    
    <xsl:template match="section">
        <H3><xsl:apply-templates select="text()|*" /></H3>
    </xsl:template>
    
    <xsl:template match="project-list">
    <TABLE BORDER="1" WIDTH="100%">
        <TR><TH>Subproject</TH><TH>Package</TH><TH>Overview</TH></TR>
        
        <xsl:apply-templates />
    </TABLE>
    </xsl:template>
    
    <xsl:template match="project-category">
        <TR>
            <TD COLSPAN="3" BGCOLOR="BLACK"><FONT COLOR="WHITE">
            <xsl:value-of select="@name" /></FONT>
            </TD>
        </TR>
        
        <xsl:apply-templates />
    </xsl:template>
    
    <xsl:template match="subproject">
        <TR>
            <TD>
                <a>
                    <xsl:attribute name="href"><xsl:value-of
                        select="name/text()" />/index.html</xsl:attribute>
                    <xsl:value-of select="name/text()" />
                </a>
            <xsl:if test="part">
            <BR />
            <I><xsl:value-of select="part/text()" /></I>
            </xsl:if>
            <BR />
            <FONT COLOR="#000080">
            <xsl:value-of select="@project" /> v<xsl:value-of select="@version" />
            </FONT>
            </TD>
            <TD><xsl:value-of select="package/text()" /></TD>
            <TD>
                <P>
                <xsl:apply-templates select="description" />
                </P>
                <xsl:if test="class">
                    <UL>
                        <xsl:for-each select="class" >
                            <LI><B><xsl:value-of select="name/text()" /></B>:
                            <xsl:apply-templates select="description" />
                            </LI>
                        </xsl:for-each>
                    </UL>
                </xsl:if>
                <xsl:if test="status">
                    <P><B>Status</B>:
                    <xsl:apply-templates select="status" />
                    </P>
                </xsl:if>
            </TD>
        </TR>
    </xsl:template>

    <xsl:template match="download">
        <xsl:call-template name="fcn-download">
            <xsl:with-param name="file" select="@file" />
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template match="definition">
        <LI>
        <B><xsl:value-of select="@term" />:</B>
        <xsl:apply-templates select="text()|*" />
        </LI>
    </xsl:template>
    
    <xsl:template match="definition-link">
        <LI>
        <B><a href="{@href}"><xsl:value-of select="@term" /></a>:</B>
        <xsl:apply-templates select="text()|*" />
        </LI>
    </xsl:template>
    
    <xsl:template match="download-package">
        <xsl:value-of select="@version" />
            <BR /><xsl:call-template name="CopyChildWithTemplates" />
            <UL>
            <LI><xsl:call-template name="fcn-download">
                <xsl:with-param name="file"><xsl:value-of
                    select="@project" />-<xsl:value-of select="@version"
                    />.zip</xsl:with-param>
                </xsl:call-template> - JAR, documentation, and source code.</LI>
            <LI><xsl:call-template name="fcn-download">
                <xsl:with-param name="file"><xsl:value-of
                    select="@project" />-<xsl:value-of select="@version"
                    />.tar.gz</xsl:with-param>
                </xsl:call-template> - JAR, documentation, and source code in
                a tar-ball.</LI>
            <LI><xsl:call-template name="fcn-download">
                <xsl:with-param name="file"><xsl:value-of
                    select="@project" />-<xsl:value-of select="@version"
                    />-doc.zip</xsl:with-param>
                </xsl:call-template> - documentation.</LI>
            <LI><xsl:call-template name="fcn-download">
                <xsl:with-param name="file"><xsl:value-of
                    select="@project" />-<xsl:value-of select="@version"
                    />-src.zip</xsl:with-param>
                </xsl:call-template> - source code.</LI>
            <LI><xsl:call-template name="fcn-download">
                <xsl:with-param name="file"><xsl:value-of
                    select="@project" />-<xsl:value-of select="@version"
                    />.jar</xsl:with-param>
                </xsl:call-template> - Library (compiled) jar file.</LI>
            </UL>
    </xsl:template>
    
    
    <xsl:template match="article-link">
        <xsl:variable name="article" select="
            document( concat( '../../../', @package, '/xdocs/', @file, '.xml' ) )"/>
        <!-- quick test to see the error
        <xsl:message terminate="no">
            <xsl:value-of select="$article//document/head/name/text()" />
        </xsl:message>
        -->
        <xsl:choose>
            <!-- If the article specified exists, then output the article -->
            <xsl:when test="$article">
                <xsl:variable name="title"
                    select="$article//document/head/name/text()" />
                <xsl:variable name="updated1"
                    select="$article//document/head/doc-version/text()" />
                <xsl:variable name="updated"
                    select="substring( $updated1, 8, string-length( $updated1 )-9 )" />
                <A>
                    <xsl:attribute name="HREF"><xsl:value-of
                        select="@package" />/<xsl:value-of
                        select="@file" />.html</xsl:attribute>
                    <xsl:value-of select="$title" />
                </A>
                <xsl:if test="string-length($updated) > 0">
                <xsl:text>    </xsl:text>
                <I>(Last updated on <xsl:value-of select="$updated" />)</I>
                </xsl:if>
            </xsl:when>
            <!-- Otherwise, fail! -->
            <xsl:otherwise>
                <xsl:message terminate="yes">
                Invalid article-link: file
                '<xsl:value-of select="@file" />.xml'
                does not exist in the directory
                '../../../<xsl:value-of select="@package" />/xdocs'
                </xsl:message>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    
    <xsl:template match="@*|node()" name="CopyWithTemplates">
        <xsl:copy>
            <xsl:apply-templates select="@*|node()" />
        </xsl:copy>
    </xsl:template>
    
    <xsl:template name="CopyChildWithTemplates">
        <xsl:apply-templates select="child::*" />
    </xsl:template>
    
    <xsl:template name="fcn-download" >
        <xsl:param name="file" select="not-specified" />
        <a href="http://prdownloads.sourceforge.net/groboutils/{$file}">
        <xsl:value-of select="$file" />
        </a>
    </xsl:template>
</xsl:stylesheet>
