/**
 * \file pappsomspp/msfile/mzformatenumstr.cpp
 * \date 12/2/2021
 * \author Olivier Langella <olivier.langella@universite-paris-saclay.fr>
 * \brief convert mzformat enumerations to strings
 *
 */

/*******************************************************************************
 * Copyright (c) 2021 Olivier Langella
 *<olivier.langella@universite-paris-saclay.fr>.
 *
 * This file is part of the PAPPSOms++ library.
 *
 *     PAPPSOms++ is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms++ is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms++.  If not, see <http://www.gnu.org/licenses/>.
 *
 ******************************************************************************/

#include "mzformatenumstr.h"
#include "pappsomspp/core/pappsoexception.h"
#include <QObject>

using namespace pappso;

const QString
pappso::MsDataFormatEnumStr::toString(Enums::MsDataFormat ms_data_format_enum)
{

  QString ms_data_format_str;
  switch(ms_data_format_enum)
    {
      case Enums::MsDataFormat::abSciexT2D:
        ms_data_format_str = "abSciexT2D";
        break;
      case Enums::MsDataFormat::abSciexWiff:
        ms_data_format_str = "abSciexWiff";
        break;
      case Enums::MsDataFormat::agilentMassHunter:
        ms_data_format_str = "agilentMassHunter";
        break;
      case Enums::MsDataFormat::brukerBaf:
        ms_data_format_str = "brukerBaf";
        break;
      case Enums::MsDataFormat::brukerFid:
        ms_data_format_str = "brukerFid";
        break;
      case Enums::MsDataFormat::brukerTims:
        ms_data_format_str = "brukerTims";
        break;
      case Enums::MsDataFormat::brukerYep:
        ms_data_format_str = "brukerYep";
        break;
      case Enums::MsDataFormat::MGF:
        ms_data_format_str = "MGF";
        break;
      case Enums::MsDataFormat::msn:
        ms_data_format_str = "msn";
        break;
      case Enums::MsDataFormat::mz5:
        ms_data_format_str = "mz5";
        break;
      case Enums::MsDataFormat::mzML:
        ms_data_format_str = "mzML";
        break;
      case Enums::MsDataFormat::mzXML:
        ms_data_format_str = "mzXML";
        break;
      case Enums::MsDataFormat::SQLite3:
        ms_data_format_str = "SQLite3";
        break;
      case Enums::MsDataFormat::thermoRaw:
        ms_data_format_str = "thermoRaw";
        break;
      case Enums::MsDataFormat::watersRaw:
        ms_data_format_str = "watersRaw";
        break;
      case Enums::MsDataFormat::xy:
        ms_data_format_str = "xy";
        break;
      default:
        throw pappso::PappsoException(
          QObject::tr("Enums::MsDataFormat unknown :\n%1")
            .arg((std::uint8_t)ms_data_format_enum));
    }
  return ms_data_format_str;
}
