#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>

#include "testinput.h"

/**
 * Main procedure for standalone fuzzing engine.
 *
 * Reads filenames from the argument array. For each filename, read the file
 * into memory and then call the fuzzing interface with the data.
 */
int main(int argc, char **argv)
{
  int ii;
  for(ii = 1; ii < argc; ii++)
  {
    FILE *infile;
    printf("[%s] ", argv[ii]);

    /* Try and open the file. */
    infile = fopen(argv[ii], "rb");
    if(infile)
    {
      uint8_t *buffer = NULL;
      size_t buffer_len;

      printf("Opened.. ");

      /* Get the length of the file. */
      fseek(infile, 0L, SEEK_END);
      buffer_len = ftell(infile);

      /* Reset the file indicator to the beginning of the file. */
      fseek(infile, 0L, SEEK_SET);

      /* Allocate a buffer for the file contents. */
      buffer = (uint8_t *)calloc(buffer_len, sizeof(uint8_t));
      if(buffer)
      {
        size_t result;

        /* Read all the text from the file into the buffer. */
        result = fread(buffer, sizeof(uint8_t), buffer_len, infile);

        if (result == buffer_len)
        {
          printf("Read %zu bytes, fuzzing.. ", buffer_len);
          /* Call the fuzzer with the data. */
          LLVMFuzzerTestOneInput(buffer, buffer_len);

          printf("complete !!");
        }
        else
        {
          fprintf(stderr,
                  "Failed to read %zu bytes (result %zu)\n",
                  buffer_len,
                  result);
        }

        /* Free the buffer as it's no longer needed. */
        free(buffer);
        buffer = NULL;
      }
      else
      {
        fprintf(stderr,
                "[%s] Failed to allocate %zu bytes \n",
                argv[ii],
                buffer_len);
      }

      /* Close the file as it's no longer needed. */
      fclose(infile);
      infile = NULL;
    }
    else
    {
      /* Failed to open the file. Maybe wrong name or wrong permissions? */
      fprintf(stderr, "[%s] Open failed. \n", argv[ii]);
    }

    printf("\n");
  }
}
