// Generated by gmmproc 2.39.4 -- DO NOT MODIFY!


#include <glibmm.h>

#include <wnckmm/window.h>
#include <wnckmm/private/window_p.h>


/** This file is part of wnckmm

    Copyright (c) 2013 Povilas Kanapickas  <povilas@radix.lt>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with this library.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <wnckmm/libwnck-wrapper.h>
#include <wnckmm/application.h>
#include <wnckmm/class-group.h>
#include <wnckmm/screen.h>
#include <wnckmm/workspace.h>

namespace Wnck {

Gdk::Rectangle Window::get_client_geometry() const
{
    int x, y, width, height;
    wnck_window_get_client_window_geometry(const_cast<WnckWindow*>(gobj()),
                                           &x, &y, &width, &height);
    return Gdk::Rectangle(x, y, width, height);
}

Gdk::Rectangle Window::get_geometry() const
{
    int x, y, width, height;
    wnck_window_get_geometry(const_cast<WnckWindow*>(gobj()),
                             &x, &y, &width, &height);
    return Gdk::Rectangle(x, y, width, height);
}

void Window::set_geometry(WindowGravity gravity, WindowMoveResizeMask geometry_mask,
                          const Gdk::Rectangle& geom)
{
    set_geometry(gravity, geometry_mask,
                 geom.get_x(), geom.get_y(), geom.get_width(), geom.get_height());
}

void Window::set_icon_geometry(const Gdk::Rectangle& geom)
{
    set_icon_geometry(geom.get_x(), geom.get_y(),
                      geom.get_width(), geom.get_height());

}

} // namespace Wnck


namespace
{


static void Window_signal_actions_changed_callback(WnckWindow* self, WnckWindowActions p0,WnckWindowActions p1,void* data)
{
  using namespace Wnck;
  typedef sigc::slot< void,WindowActions,WindowActions > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(((WindowActions)(p0))
, ((WindowActions)(p1))
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
}

static const Glib::SignalProxyInfo Window_signal_actions_changed_info =
{
  "actions-changed",
  (GCallback) &Window_signal_actions_changed_callback,
  (GCallback) &Window_signal_actions_changed_callback
};


static const Glib::SignalProxyInfo Window_signal_geometry_changed_info =
{
  "geometry-changed",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static void Window_signal_state_changed_callback(WnckWindow* self, WnckWindowState p0,WnckWindowState p1,void* data)
{
  using namespace Wnck;
  typedef sigc::slot< void,WindowState,WindowState > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(((WindowState)(p0))
, ((WindowState)(p1))
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
}

static const Glib::SignalProxyInfo Window_signal_state_changed_info =
{
  "state-changed",
  (GCallback) &Window_signal_state_changed_callback,
  (GCallback) &Window_signal_state_changed_callback
};


static const Glib::SignalProxyInfo Window_signal_workspace_changed_info =
{
  "workspace-changed",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static const Glib::SignalProxyInfo Window_signal_icon_changed_info =
{
  "icon-changed",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static const Glib::SignalProxyInfo Window_signal_name_changed_info =
{
  "name-changed",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


} // anonymous namespace

// static
GType Glib::Value<Wnck::WindowType>::value_type()
{
  return wnck_window_type_get_type();
}

// static
GType Glib::Value<Wnck::WindowState>::value_type()
{
  return wnck_window_state_get_type();
}

// static
GType Glib::Value<Wnck::WindowActions>::value_type()
{
  return wnck_window_actions_get_type();
}

// static
GType Glib::Value<Wnck::WindowGravity>::value_type()
{
  return wnck_window_gravity_get_type();
}

// static
GType Glib::Value<Wnck::WindowMoveResizeMask>::value_type()
{
  return wnck_window_move_resize_mask_get_type();
}


namespace Glib
{

Wnck::Window* wrap(WnckWindow* object, bool take_copy)
{
  return dynamic_cast<Wnck::Window*> (Glib::wrap_auto ((GObject*)(object), take_copy));
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Wnck
{


/* The *_Class implementation: */

const Glib::Class& Window_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &Window_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(wnck_window_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:

  }

  return *this;
}


void Window_Class::class_init_function(void* g_class, void* class_data)
{
  BaseClassType *const klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);


  klass->actions_changed = &actions_changed_callback;
  klass->geometry_changed = &geometry_changed_callback;
  klass->state_changed = &state_changed_callback;
  klass->workspace_changed = &workspace_changed_callback;
  klass->icon_changed = &icon_changed_callback;
  klass->name_changed = &name_changed_callback;
}


void Window_Class::actions_changed_callback(WnckWindow* self, WnckWindowActions p0, WnckWindowActions p1)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_actions_changed(((WindowActions)(p0))
, ((WindowActions)(p1))
);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->actions_changed)
    (*base->actions_changed)(self, p0, p1);
}
void Window_Class::geometry_changed_callback(WnckWindow* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_geometry_changed();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->geometry_changed)
    (*base->geometry_changed)(self);
}
void Window_Class::state_changed_callback(WnckWindow* self, WnckWindowState p0, WnckWindowState p1)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_state_changed(((WindowState)(p0))
, ((WindowState)(p1))
);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->state_changed)
    (*base->state_changed)(self, p0, p1);
}
void Window_Class::workspace_changed_callback(WnckWindow* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_workspace_changed();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->workspace_changed)
    (*base->workspace_changed)(self);
}
void Window_Class::icon_changed_callback(WnckWindow* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_icon_changed();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->icon_changed)
    (*base->icon_changed)(self);
}
void Window_Class::name_changed_callback(WnckWindow* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_name_changed();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->name_changed)
    (*base->name_changed)(self);
}


Glib::ObjectBase* Window_Class::wrap_new(GObject* object)
{
  return new Window((WnckWindow*)object);
}


Window::Window(const Glib::ConstructParams& construct_params)
:
  Glib::Object(construct_params)
{

}

Window::Window(WnckWindow* castitem)
:
  Glib::Object((GObject*)(castitem))
{}


Window::~Window()
{}


Window::CppClassType Window::window_class_; // initialize static member

GType Window::get_type()
{
  return window_class_.init().get_type();
}


GType Window::get_base_type()
{
  return wnck_window_get_type();
}


Window::Window()
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(0),
  Glib::Object(Glib::ConstructParams(window_class_.init()))
{
  

}

Window* Window::get_for_xid(gulong xid)
{
  return Glib::wrap(wnck_window_get(xid));
}


Screen* Window::get_screen() const
{
  return Glib::wrap(wnck_window_get_screen(const_cast<WnckWindow*>(gobj())));
}

bool Window::has_name() const
{
  return wnck_window_has_name(const_cast<WnckWindow*>(gobj()));
}

std::string Window::get_name() const
{
  return Glib::convert_const_gchar_ptr_to_stdstring(wnck_window_get_name(const_cast<WnckWindow*>(gobj())));
}

bool Window::has_icon_name() const
{
  return wnck_window_has_icon_name(const_cast<WnckWindow*>(gobj()));
}

std::string Window::get_icon_name() const
{
  return Glib::convert_const_gchar_ptr_to_stdstring(wnck_window_get_icon_name(const_cast<WnckWindow*>(gobj())));
}

bool Window::is_icon_fallback() const
{
  return wnck_window_get_icon_is_fallback(const_cast<WnckWindow*>(gobj()));
}

Glib::RefPtr<Gdk::Pixbuf> Window::get_icon() const
{
  Glib::RefPtr<Gdk::Pixbuf> retvalue = Glib::wrap(wnck_window_get_icon(const_cast<WnckWindow*>(gobj())));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<Gdk::Pixbuf> Window::get_mini_icon() const
{
  Glib::RefPtr<Gdk::Pixbuf> retvalue = Glib::wrap(wnck_window_get_mini_icon(const_cast<WnckWindow*>(gobj())));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Application* Window::get_application() const
{
  return Glib::wrap(wnck_window_get_application(const_cast<WnckWindow*>(gobj())));
}

Window* Window::get_transient() const
{
  return Glib::wrap(wnck_window_get_transient(const_cast<WnckWindow*>(gobj())));
}

gulong Window::get_group_leader() const
{
  return wnck_window_get_group_leader(const_cast<WnckWindow*>(gobj()));
}

gulong Window::get_xid() const
{
  return wnck_window_get_xid(const_cast<WnckWindow*>(gobj()));
}

ClassGroup* Window::get_class_group() const
{
  return Glib::wrap(wnck_window_get_class_group(const_cast<WnckWindow*>(gobj())));
}

std::string Window::get_session_id() const
{
  return Glib::convert_const_gchar_ptr_to_stdstring(wnck_window_get_session_id(const_cast<WnckWindow*>(gobj())));
}

std::string Window::get_session_id_utf8() const
{
  return Glib::convert_const_gchar_ptr_to_stdstring(wnck_window_get_session_id_utf8(const_cast<WnckWindow*>(gobj())));
}

int Window::get_pid() const
{
  return wnck_window_get_pid(const_cast<WnckWindow*>(gobj()));
}

int Window::get_sort_order() const
{
  return wnck_window_get_sort_order(const_cast<WnckWindow*>(gobj()));
}

void Window::set_sort_order(int order)
{
  wnck_window_set_sort_order(gobj(), order);
}

WindowType Window::get_window_type() const
{
  return ((WindowType)(wnck_window_get_window_type(const_cast<WnckWindow*>(gobj()))));
}

void Window::set_window_type(WindowType order)
{
  wnck_window_set_window_type(gobj(), ((WnckWindowType)(order)));
}

WindowState Window::get_state() const
{
  return ((WindowState)(wnck_window_get_state(const_cast<WnckWindow*>(gobj()))));
}

bool Window::is_minimized() const
{
  return wnck_window_is_minimized(const_cast<WnckWindow*>(gobj()));
}

bool Window::is_maximized_horizontally() const
{
  return wnck_window_is_maximized_horizontally(const_cast<WnckWindow*>(gobj()));
}

bool Window::is_maximized_vertically() const
{
  return wnck_window_is_maximized_vertically(const_cast<WnckWindow*>(gobj()));
}

bool Window::is_maximized() const
{
  return wnck_window_is_maximized(const_cast<WnckWindow*>(gobj()));
}

bool Window::is_shaded() const
{
  return wnck_window_is_shaded(const_cast<WnckWindow*>(gobj()));
}

bool Window::is_pinned() const
{
  return wnck_window_is_pinned(const_cast<WnckWindow*>(gobj()));
}

bool Window::is_sticky() const
{
  return wnck_window_is_sticky(const_cast<WnckWindow*>(gobj()));
}

bool Window::is_above() const
{
  return wnck_window_is_above(const_cast<WnckWindow*>(gobj()));
}

bool Window::is_below() const
{
  return wnck_window_is_below(const_cast<WnckWindow*>(gobj()));
}

bool Window::is_skip_pager() const
{
  return wnck_window_is_skip_pager(const_cast<WnckWindow*>(gobj()));
}

bool Window::is_skip_tasklist() const
{
  return wnck_window_is_skip_tasklist(const_cast<WnckWindow*>(gobj()));
}

bool Window::is_fullscreen() const
{
  return wnck_window_is_fullscreen(const_cast<WnckWindow*>(gobj()));
}

bool Window::is_needs_attention() const
{
  return wnck_window_needs_attention(const_cast<WnckWindow*>(gobj()));
}

bool Window::is_needs_attention_or_transient() const
{
  return wnck_window_or_transient_needs_attention(const_cast<WnckWindow*>(gobj()));
}

WindowActions Window::get_actions() const
{
  return ((WindowActions)(wnck_window_get_actions(const_cast<WnckWindow*>(gobj()))));
}

void Window::minimize()
{
  wnck_window_minimize(gobj());
}

void Window::unminimize(guint32 timestamp)
{
  wnck_window_minimize(gobj());
}

void Window::maximize()
{
  wnck_window_maximize(gobj());
}

void Window::unmaximize()
{
  wnck_window_unmaximize(gobj());
}

void Window::maximize_vertically()
{
  wnck_window_maximize_vertically(gobj());
}

void Window::unmaximize_vertically()
{
  wnck_window_unmaximize_vertically(gobj());
}

void Window::maximize_horizontally()
{
  wnck_window_maximize_horizontally(gobj());
}

void Window::unmaximize_horizontally()
{
  wnck_window_unmaximize_horizontally(gobj());
}

void Window::shade()
{
  wnck_window_shade(gobj());
}

void Window::unshade()
{
  wnck_window_unshade(gobj());
}

void Window::pin()
{
  wnck_window_pin(gobj());
}

void Window::unpin()
{
  wnck_window_unpin(gobj());
}

void Window::stick()
{
  wnck_window_stick(gobj());
}

void Window::unstick()
{
  wnck_window_unstick(gobj());
}

void Window::make_above()
{
  wnck_window_make_above(gobj());
}

void Window::unmake_above()
{
  wnck_window_unmake_above(gobj());
}

void Window::make_below()
{
  wnck_window_make_below(gobj());
}

void Window::unmake_below()
{
  wnck_window_unmake_below(gobj());
}

void Window::set_skip_pager(bool skip)
{
  wnck_window_set_skip_pager(gobj(), static_cast<int>(skip));
}

void Window::set_skip_tasklist(bool skip)
{
  wnck_window_set_skip_tasklist(gobj(), static_cast<int>(skip));
}

void Window::set_fullscreen(bool fullscreen)
{
  wnck_window_set_fullscreen(gobj(), static_cast<int>(fullscreen));
}

void Window::close(guint32 timestamp)
{
  wnck_window_close(gobj(), timestamp);
}

Workspace* Window::get_workspace() const
{
  return Glib::wrap(wnck_window_get_workspace(const_cast<WnckWindow*>(gobj())));
}

bool Window::is_on_workspace(const Workspace* workspace) const
{
  return wnck_window_is_on_workspace(const_cast<WnckWindow*>(gobj()), const_cast<WnckWorkspace*>(workspace->gobj()));
}

bool Window::is_visible_on_workspace(const Workspace* workspace) const
{
  return wnck_window_is_visible_on_workspace(const_cast<WnckWindow*>(gobj()), const_cast<WnckWorkspace*>(workspace->gobj()));
}

void Window::move_to_workspace(const Workspace* workspace)
{
  wnck_window_move_to_workspace(gobj(), const_cast<WnckWorkspace*>(workspace->gobj()));
}

bool Window::is_in_viewport(const Workspace* workspace) const
{
  return wnck_window_is_in_viewport(const_cast<WnckWindow*>(gobj()), const_cast<WnckWorkspace*>(workspace->gobj()));
}

void Window::activate(guint32 timestamp)
{
  wnck_window_activate(gobj(), timestamp);
}

bool Window::is_active() const
{
  return wnck_window_is_active(const_cast<WnckWindow*>(gobj()));
}

bool Window::is_most_recently_activated() const
{
  return wnck_window_is_most_recently_activated(const_cast<WnckWindow*>(gobj()));
}

void Window::activate_transient(guint32 timestamp)
{
  wnck_window_activate_transient(gobj(), timestamp);
}

bool Window::is_transient_most_recently_activated() const
{
  return wnck_window_transient_is_most_recently_activated(const_cast<WnckWindow*>(gobj()));
}

void Window::set_icon_geometry(int x, int y, int width, int height)
{
  wnck_window_set_icon_geometry(gobj(), x, y, width, height);
}

void Window::set_geometry(WindowGravity gravity, WindowMoveResizeMask geometry_mask, int x, int y, int width, int height)
{
  wnck_window_set_geometry(gobj(), ((WnckWindowGravity)(gravity)), ((WnckWindowMoveResizeMask)(geometry_mask)), x, y, width, height);
}

void Window::keyboard_move()
{
  wnck_window_keyboard_move(gobj());
}

void Window::keyboard_size()
{
  wnck_window_keyboard_size(gobj());
}


Glib::SignalProxy2< void,WindowActions,WindowActions > Window::signal_actions_changed()
{
  return Glib::SignalProxy2< void,WindowActions,WindowActions >(this, &Window_signal_actions_changed_info);
}


Glib::SignalProxy0< void > Window::signal_geometry_changed()
{
  return Glib::SignalProxy0< void >(this, &Window_signal_geometry_changed_info);
}


Glib::SignalProxy2< void,WindowState,WindowState > Window::signal_state_changed()
{
  return Glib::SignalProxy2< void,WindowState,WindowState >(this, &Window_signal_state_changed_info);
}


Glib::SignalProxy0< void > Window::signal_workspace_changed()
{
  return Glib::SignalProxy0< void >(this, &Window_signal_workspace_changed_info);
}


Glib::SignalProxy0< void > Window::signal_icon_changed()
{
  return Glib::SignalProxy0< void >(this, &Window_signal_icon_changed_info);
}


Glib::SignalProxy0< void > Window::signal_name_changed()
{
  return Glib::SignalProxy0< void >(this, &Window_signal_name_changed_info);
}


void Wnck::Window::on_actions_changed(WindowActions changed_mask, WindowActions new_state)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->actions_changed)
    (*base->actions_changed)(gobj(),((WnckWindowActions)(changed_mask)),((WnckWindowActions)(new_state)));
}
void Wnck::Window::on_geometry_changed()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->geometry_changed)
    (*base->geometry_changed)(gobj());
}
void Wnck::Window::on_state_changed(WindowState changed_mask, WindowState new_state)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->state_changed)
    (*base->state_changed)(gobj(),((WnckWindowState)(changed_mask)),((WnckWindowState)(new_state)));
}
void Wnck::Window::on_workspace_changed()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->workspace_changed)
    (*base->workspace_changed)(gobj());
}
void Wnck::Window::on_icon_changed()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->icon_changed)
    (*base->icon_changed)(gobj());
}
void Wnck::Window::on_name_changed()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->name_changed)
    (*base->name_changed)(gobj());
}


} // namespace Wnck


