.\" Copyright (c) 1991  X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation
.\" the rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons to whom the
.\" Software furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included in
.\" all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
.\" THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
.\" WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
.\" OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
.\" SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall not
.\" be used in advertising or otherwise to promote the sale, use or other
.\" dealing in this Software without prior written authorization from the
.\" X Consortium.
.\"
.\" Copyright (c) 2006, Oracle and/or its affiliates. All rights reserved.
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation
.\" the rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons to whom the
.\" Software is furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice (including the next
.\" paragraph) shall be included in all copies or substantial portions of the
.\" Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
.\" THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
.\" LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
.\" FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
.\" DEALINGS IN THE SOFTWARE.
.\"
.\" X Window System is a trademark of The Open Group.
.\"
.de ZN
.ie t \fB\^\\$1\^\fR\\$2
.el \fI\^\\$1\^\fP\\$2
..
.TH XShm __libmansuffix__ __xorgversion__ "X FUNCTIONS"
.SH NAME
XShmQueryExtension, XShmQueryVersion, XShmPixmapFormat, XShmAttach, XShmDetach
XShmCreateImage, XShmPutImage, XShmGetImage, XShmCreatePixmap, XShmGetEventBase - X Shared Memory extension functions
.SH SYNTAX
.nf
.LP
\&#include <X11/Xlib.h>
\&#include <sys/ipc.h>
\&#include <sys/shm.h>
\&#include <X11/extensions/XShm.h>
.LP
Bool	XShmQueryExtension(
	Display *display);
.LP
Bool XShmQueryVersion(
	Display *display;
	int *major, *minor;
	Bool *pixmaps);
.LP
int XShmPixmapFormat(
	Display *display);
.LP
Bool XShmAttach(
	Display *display;
	XShmSegmentInfo *shminfo);
.LP
Bool XShmDetach(
	Display *display;
	XShmSegmentInfo *shminfo);

.LP
XImage *XShmCreateImage (
	Display *display;
	Visual *visual;
	unsigned int depth;
	int format;
	char *data;
	XShmSegmentInfo *shminfo;
	unsigned int width, height);
.LP
Bool XShmPutImage(
	Display *display;
	Drawable d;
	GC gc;
	XImage *image;
	int src_x, src_y, dest_x, dest_y;
	unsigned int width, height;
	bool send_event);
.LP
Bool XShmGetImage (
	Display *display;
	Drawable d;
	XImage *image;
	int x, y;
	unsigned long plane_mask);
.LP
Pixmap XShmCreatePixmap(
        Display *display;
        Drawable d;
        char *data;
	XShmSegmentInfo *shminfo;
	unsigned int width, height, depth);
.LP
Status XShmGetEventBase(
	Display *display);
.LP

.fi
.SH STRUCTURES
.nf
.ta 3i
\fIEvents:\fP
typedef struct {
    int type;               /\&* of event */
    unsigned long serial;   /\&* # of last request processed by server*/
    Bool send_event;        /\&* true if this came from a SendEvent request*/
    Display *display;       /\&* Display the event was read from */
    Drawable drawable;      /\&* drawable of request */
    int major_code;         /\&* ShmReqCode */
    int minor_code;         /\&* X_ShmPutImage */
    ShmSeg shmseg;          /\&* the ShmSeg used in the request*/
    unsigned long offset;   /\&* the offset into ShmSeg used in the request*/
} XShmCompletionEvent;
.LP
\fIa structure of type XShmSegmentInfo :\fP

typedef struct {
    ShmSeg shmseg;      /\&* resource id */
    int shmid;          /\&* kernel id */
    char *shmaddr;      /\&* address in client */
    Bool readOnly;      /\&* how the server should attach it */
} XShmSegmentInfo;

.SH DESCRIPTION
.PP
.PP
.ZN XShmQueryExtension
checks to see if the shared memory extensions are available for the
specified display.
.PP
.ZN XShmQueryVersion
returns the version numbers of the extension implementation. Shared
memory pixmaps are supported if the pixmaps argument returns true.
.PP
.ZN XShmAttach
tells the server to attach to your shared memory segment. If all goes
well, you will get a non-zero status, back and your XImage is ready
for use.
.PP
.ZN XShmDetach
tells the server to detach from your shared memory segment.
.PP
.ZN XShmPutImage
combines an image in memory with a shape of the specified drawable. If
XYBitmap format is used, the depth must be one, or a ``BadMatch''
error results. The foreground pixel in the GC defines the source for
the one bits in the image, and the background pixel defines the source
for the zero bits. For XYPixmap and ZPixmap, the depth must match the
depth of the drawable, or a ``BadMatch'' error results.
.PP
.ZN XShmGetImage
reads image data into a shared memory XImage where display is the
display of interest, drawable is the source drawable, image is the
destination XImage, x and y are offsets within the drawable, and
plane_mask defines which planes are to be read.
.PP
.ZN XShmCreateImage
allocates the memory needed for an XImage structure for the specified
display but does not allocate space for the image itself.
.PP
.ZN XShmPixmapFormat
gets the format for the server. If your application can deal with the
server pixmap data format, a shared memory segment and shminfo
structure are created.
.PP
.ZN XShmCreatePixmap
points to a pixmap which you can manipulate in all of the usual ways,
with the added bonus of being able to edit its contents directly
through the shared memory segment.
.PP
.ZN XShmGetEventBase
gets the completion event value.
.PP
.SH SEE ALSO
\fIMIT-SHM - The MIT Shared Memory Extension \fP
