#include "mcdp.h"
short pluskey=0;  /* 0..9|X is played */
short updates[4]; /* see mcdp.h */
short offset=1; /* vertical offset */

int main(int argc, char **argv, char **environ) {
 struct mcdp *cd=malloc(sizeof(struct mcdp));
 int quit=0;
 char ch;

 cd_initdev(argv[1],&cd[0]);
 tty_mode(TERM_INIT);
 signal(SIGINT,mcdp_quit);
 signal(SIGQUIT,mcdp_quit);
 signal(SIGTERM,mcdp_quit);

 updates[U_ALL]=1;
 while (!quit) {
  draw_updatescr(&cd[0]);
  if (1 == select_wait(0,1)) {
   read(0,&ch,1);
   switch (ch) {
   case '\033':
    read(0,&ch,1);read(0,&ch,1); /* XXX - should be done in another way ? */
    switch(ch) {
     case 'A': cd_skip(&cd[0], FW_FAST);break; /* c_up */
     case 'B': cd_skip(&cd[0],-RW_FAST);break; /* c_down */
     case 'C': cd_skip(&cd[0], FW_SLOW);break; /* c_left */
     case 'D': cd_skip(&cd[0],-RW_SLOW);break; /* c_right */
    }
    break;
   case ' ': /* next */
    cd->title[0]++;cd_start(&cd[0]);
    updates[U_TRACKS]=1;
    break;
   case 'b': /* previous */
   case 'B':
    cd->title[0]--;cd_start(&cd[0]);
    updates[U_TRACKS]=1;
    break;
   case 'r':
   case 'R':
    updates[U_ALL]=1;
    break;
   case 'm':
    if (cd->method<M_INTRO) cd->method++;
    else cd->method=M_PLAY_CD;
    updates[U_TRACKS]=updates[U_METHOD]=1;
    break;
   case 'M':
    if (cd->method>M_PLAY_CD) cd->method--;
    else cd->method=M_INTRO;
    updates[U_METHOD]=1;
    break;
   case 'P':
   case 'p':
    cd_pauseresume(&cd[0]);
    updates[U_STATUS]=1;
    break;
   case 'S':
   case 's':
    if (cd->status==CDROM_AUDIO_PLAY) {
     cd_stop(&cd[0]);
    } else {
     cd->title[0]=1;
     cd_start(&cd[0]);
    }
    updates[U_STATUS]=updates[U_TRACKS]=1;
    break;
   case 'E':
   case 'e':
    cd_eject(&cd->fd);
    updates[U_ALL]=1;
    break;
   case 'C':
   case 'c':
    cd_close(&cd->fd);
    updates[U_ALL]=1;
    break;
   case '?':
   case 'H':
   case 'h':
    system("man mcdp");
    break;
   case '+':
    if (pluskey<9) pluskey++; else pluskey=0;
    updates[U_TRACKS]=1;
    break;
   case '-':
    if (pluskey>0) pluskey--; else pluskey=9;
    updates[U_TRACKS]=1;
    break;
   case '<':
    cd->vol.channel0=cd->vol.channel1=cd->vol.channel2=cd->vol.channel3=
     (cd->vol.channel0>0)?cd->vol.channel0-=3:255;
    if (ioctl(cd->fd,CDROMVOLCTRL,&cd->vol)<0)
     draw_status("error: setting volume",1);
    updates[U_VOLUME]=1;
    break;
   case '>':
    cd->vol.channel0=cd->vol.channel1=cd->vol.channel2=cd->vol.channel3=
     (cd->vol.channel0<255)?cd->vol.channel0+=3:0;
    if (ioctl(cd->fd,CDROMVOLCTRL,&cd->vol)<0)
     draw_status("error: setting volume",1);
    updates[U_VOLUME]=1;
    break;
   case ',':
    cd->vol.channel0=cd->vol.channel1=cd->vol.channel2=cd->vol.channel3=
        (cd->vol.channel0>25)?cd->vol.channel0-=25:255;
    if(ioctl(cd->fd,CDROMVOLCTRL,&cd->vol)<0)
        draw_status("error: setting volume",1);
    updates[U_VOLUME]=1;
    break;
   case '.':
    cd->vol.channel0=cd->vol.channel1=cd->vol.channel2=cd->vol.channel3=
        (cd->vol.channel0<230)?cd->vol.channel0+=25:0;
    if(ioctl(cd->fd,CDROMVOLCTRL,&cd->vol)<0)
        draw_status("error: setting volume",1);
    updates[U_VOLUME]=1;
    break;
   case 'q':
   case 'Q':
    quit=1;
    break;
   case '0':
    if (!pluskey && !((int)ch-48)) {
     draw_status("isn't valid!",1);
     break;
    }
   case '1': case '2': case '3': case '4': case '5': case '6':
   case '7': case '8': case '9':
    if ((pluskey*10)+((int)ch-48)>cd->title[1] || (pluskey*10)+((int)ch-48)<1) break;
    else {
     cd->title[0]=((pluskey*10)+((int)ch-48));
     cd_start(&cd[0]);
     updates[U_TRACKS]=1;
    }
    break;
   case ']':
    if(cd->title[1]>(maxy-9))
    offset=(offset<(cd->title[1]-maxy+10))?offset+1:(cd->title[1]-maxy+10);
    updates[U_TRACKS]=2; break;
   case '[':
    if(cd->title[1]>(maxy-9))
    offset=(offset>1)?offset-1:offset;
    updates[U_TRACKS]=2; break;
   case '}':
    if(cd->title[1]>(maxy-9))
    offset=((offset+5)<(cd->title[1]-maxy+10))?(offset+5):(cd->title[1]-maxy+10);
    updates[U_TRACKS]=2; break;
   case '{':
    if(cd->title[1]>(maxy-9))
    offset=((offset-5)>1)?(offset-5):1;
    updates[U_TRACKS]=2; break;
   } /* switch */
  } /* select */
 } /* while */
 mcdp_quit(1); /* cleanup */
 exit(0);
}

void mcdp_quit(int i) {
 show1(T_NORMAL T_HOME T_CLEAR T_BOLD "ByeBye...\n\n" T_NORMAL);
 tty_mode(TERM_QUIT);
}
