# filelist.py
#
#   Copyright (C) 2003 Daniel Burrows <dburrows@debian.org>
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import filecollection

# A class that provides a simple implementation of a file collection, just
# based on a list of files.

class FileList(filecollection.FileCollection):
    def __init__(self, gui, items=[]):
        filecollection.FileCollection.__init__(self, gui)

        self.__contents=[]
        for item in items:
            self.add_file(item)

    def children(self):
        return self.__contents

    def add_file(self, file):
        # yuck, expensive.  Cheat and use a dictionary?
        if not file in self.__contents:
            self.inc_count(file.items())

            self.__contents.append(file)
            file.add_listener(self.file_updated)

    def remove_file(self, file):
        if file in self.__contents:
            self.dec_count(file.items())

            self.__contents.remove(file)
            file.remove_listener(self.file_updated)

    def file_updated(self, file, olddict):
        self.dec_count(olddict.items())
        self.inc_count(file.items())

    def title_editable(self):
        return len(self.__contents)==1

    # Editable interface -- return a string or None if no label is
    # appropriate.
    def get_label(self):
        if len(self.__contents) <> 1:
            return None
        else:
            titles=self.__contents[0].get_tag('TITLE')
            if len(titles)>0:
                return titles[0]
            elif hasattr(self.__contents[0], 'filename'):
                return self.__contents[0].filename
            else:
                return None
