/*
 * Copyright 2019, OpenCensus Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.opencensus.benchmarks.tags;

import io.opencensus.tags.TagContext;
import io.opencensus.tags.Tagger;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;

/** Benchmarks for {@link io.opencensus.trace.TagContextBuilder}. */
public class NestedTagContextCreationBenchmark {

  @State(org.openjdk.jmh.annotations.Scope.Benchmark)
  public static class Data {
    private Tagger tagger;
    private TagContext baseTagContext;

    @Param({"impl", "impl-lite"})
    String implementation;

    @Param({"0", "1", "2", "4", "8", "16"})
    int numTags;

    @Param({"0", "1", "2", "4", "8", "16"})
    int numBaseTags;

    @Setup
    public void setup() {
      tagger = TagsBenchmarksUtil.getTagger(implementation);
      baseTagContext = TagsBenchmarksUtil.createTagContext(tagger.emptyBuilder(), numBaseTags);
    }
  }

  /** Build nested tag context. */
  @Benchmark
  @BenchmarkMode(Mode.AverageTime)
  @OutputTimeUnit(TimeUnit.NANOSECONDS)
  public TagContext timeNestedTagContext(Data data) {
    return TagsBenchmarksUtil.createTagContext(
        data.tagger.toBuilder(data.baseTagContext), data.numTags);
  }
}
