#ifndef KPKREADER_H
#define KPKREADER_H

#include "SHUReader.h"

class CKPKReader :
	public CECPReader
{
public:
	CKPKReader(CReader *Owner,CBaseCommunication *Communicator);
	virtual ~CKPKReader(void);
	virtual void SetHWString(char *String);
	virtual void GetProductString(uint8_t *Product);
	virtual CJ_RESULT CtSetBacklight(EBacklight eBacklight,uint32_t *Result);	
	virtual CJ_RESULT CtSetContrast(EContrast eContrast, uint32_t *Result);

protected:
private:
	void SetNFCSpeedLimit();

protected:
	virtual bool ATRFilter(bool IsWarm, uint8_t Slot = 0);
	virtual bool HastModulestoreInfo();
	virtual RSCT_IFD_RESULT _IfdPower(uint32_t Mode, uint8_t *ATR, uint32_t *ATR_Length, uint32_t Timeout, uint8_t Slot = 0);
	virtual RSCT_IFD_RESULT IfdSetProtocol(uint32_t *Protocol, uint8_t Slot = 0);
	virtual RSCT_IFD_RESULT _IfdTransmit(const uint8_t *cmd, uint16_t cmd_len, uint8_t *response, uint16_t *response_len, uint8_t Slot = 0);
	virtual RSCT_IFD_RESULT IfdVendor(uint32_t IoCtrlCode, uint8_t *Input, uint32_t InputLength, uint8_t *Output, uint32_t *OutputLength);
	virtual CJ_RESULT BuildReaderInfo();
	virtual uint32_t GetReadersInputBufferSize();
	virtual CJ_RESULT CtSetSilentMode(bool boolMode, bool *pboolMode, uint32_t *Result);
	virtual CJ_RESULT CtGetSilentMode(bool *pboolMode, uint32_t *Result);
	virtual bool PinDirectSupported();
	virtual CJ_RESULT SpecialLess3_0_41();
	virtual void DoInterruptCallback(uint8_t *Data, uint32_t ulDataLen);
protected:
	clock_t m_last_insertation_time;
	bool m_b_Is_absent;


};

#endif

