# Pencil2D Developer Documentation

Welcome! This documentation is aimed at developers working *on* Pencil2D, if you’re just looking for help working *with* Pencil2D, please have a look at [our user documentation](https://www.pencil2d.org/doc/) and [our community](https://www.pencil2d.org/community/) instead. Also please note that this documentation is still very much work in progress and far from complete. It is generated from comments in the source code and pages in the docs/ directory, so if you’d like to help out don’t hesitate to contribute!

To work on Pencil2D, you will need to use C++ and Qt. If you have any difficulties getting involved or finding answers to your questions, please bring those to [our Discord chat room](https://discord.gg/8FxdV2g) or [our forum](https://discuss.pencil2d.org) so that we can help you.

## Getting Started

Get started with this documentation and start building and fixing bugs in just a few steps.

- [How to compile Pencil2D on macOS](docs/build_mac.md)
- [How to compile Pencil2D on Linux](docs/build_linux.md)
- [How to compile Pencil2D on Windows](docs/build_win.md)

## Development

- [Current Development Status](https://github.com/pencil2d/pencil/projects/1): See what developers are doing at the moment
- [Issue List](https://github.com/pencil2d/pencil/issues/): A pending list of bugs, information and to-do tasks
- [Roadmap](https://github.com/pencil2d/pencil/issues/540)
- Developers’ online chat room (both channels are synced):
  - [#pencil2d on freenode IRC](https://webchat.freenode.net/?channels=#pencil2d)
  - #general-development on [our Discord server](https://discord.gg/8FxdV2g)
