---
name: 'Bug Report'
about: 'This is a bug report issue'
labels: 'type:bug, status:incoming'
---

<!-- Provide a general summary of your problem in the Title above. -->
<!-- You can erase any parts of this template not applicable to your Issue. -->
<!-- Show that you have done a step, by checking the checkboxes. -->

Thank you for your contribution!

It's great, that you want contribute to pyDataverse.

First, start by reading the [Bug reports, enhancement requests and other issues](https://pydataverse.readthedocs.io/en/master/contributing/contributing.html) section.

### Before we can start

Before moving on, please check some things first:

* [ ] Your issue may already be reported! Please search on the [issue tracker](https://github.com/gdcc/pyDataverse/issues) before creating one.
* [ ] Is this something you can **debug and fix**? Send a pull request! For more information, see the [Contributor Guide](https://pydataverse.readthedocs.io/en/master/contributing/contributing.html).
* [ ] We as maintainers foster an open and welcoming environment. Be respectfull, supportive and nice to each other! :)

### Prerequisites

* [ ] Are you running the expected version of pyDataverse? (check via `pip freeze`).

### Bug report

[Please replace this line with a brief summary of your issue and add code and/or screenshots or other media to it if available]

To write a bug report, we have defined a small, helpful workflow, to keep communication effective.

**1. Describe your environment**

* [ ] OS: NAME, VERSION, 64/32bit <!-- (e. g. Linux, Ubuntu 18.04, 64bit) -->
* [ ] pyDataverse: VERSION <!-- (e. g. 0.2.1) -->
* [ ] Python: VERSION <!-- (e. g. 3.6.9) -->
* [ ] Dataverse: VERSION <!-- (optional, e. g. 4.18.1) -->

**2. Actual behaviour:**

[What actually happened]
[Add logs, code, data, screenshots or other media if available.]

**3. Expected behaviour:**

[What have you expected to happen?]

**4. Steps to reproduce**

1. [First Step]
2. [Second Step]
3. [and so on...]

[Add logs, code, data, screenshots or other media if available.]

**5. Possible solution**

[If you have a clue, tell what could be the actual solution to the problem]

**6. Check your bug report**

Before you submit the issue:

* Check if all information necessary to understand the problem is in.
* Check if your language is written in a positive way.
