# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .recovery_point import RecoveryPoint


class AzureWorkloadRecoveryPoint(RecoveryPoint):
    """Workload specific recoverypoint, specifcally encaspulates full/diff
    recoverypoint.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureWorkloadSQLRecoveryPoint

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    :param recovery_point_time_in_utc: UTC time at which recoverypoint was
     created
    :type recovery_point_time_in_utc: datetime
    :param type: Type of restore point. Possible values include: 'Invalid',
     'Full', 'Log', 'Differential'
    :type type: str or
     ~azure.mgmt.recoveryservicesbackup.models.RestorePointType
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'recovery_point_time_in_utc': {'key': 'recoveryPointTimeInUTC', 'type': 'iso-8601'},
        'type': {'key': 'type', 'type': 'str'},
    }

    _subtype_map = {
        'object_type': {'AzureWorkloadSQLRecoveryPoint': 'AzureWorkloadSQLRecoveryPoint'}
    }

    def __init__(self, **kwargs):
        super(AzureWorkloadRecoveryPoint, self).__init__(**kwargs)
        self.recovery_point_time_in_utc = kwargs.get('recovery_point_time_in_utc', None)
        self.type = kwargs.get('type', None)
        self.object_type = 'AzureWorkloadRecoveryPoint'
