# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class MigrationValidationOptions(Model):
    """Types of validations to run after the migration.

    :param enable_schema_validation: Allows to compare the schema information
     between source and target.
    :type enable_schema_validation: bool
    :param enable_data_integrity_validation: Allows to perform a checksum
     based data integrity validation between source and target for the selected
     database / tables .
    :type enable_data_integrity_validation: bool
    :param enable_query_analysis_validation: Allows to perform a quick and
     intelligent query analysis by retrieving queries from the source database
     and executes them in the target. The result will have execution statistics
     for executions in source and target databases for the extracted queries.
    :type enable_query_analysis_validation: bool
    """

    _attribute_map = {
        'enable_schema_validation': {'key': 'enableSchemaValidation', 'type': 'bool'},
        'enable_data_integrity_validation': {'key': 'enableDataIntegrityValidation', 'type': 'bool'},
        'enable_query_analysis_validation': {'key': 'enableQueryAnalysisValidation', 'type': 'bool'},
    }

    def __init__(self, *, enable_schema_validation: bool=None, enable_data_integrity_validation: bool=None, enable_query_analysis_validation: bool=None, **kwargs) -> None:
        super(MigrationValidationOptions, self).__init__(**kwargs)
        self.enable_schema_validation = enable_schema_validation
        self.enable_data_integrity_validation = enable_data_integrity_validation
        self.enable_query_analysis_validation = enable_query_analysis_validation
