# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class AadSolutionProperties(Model):
    """The external security solution properties for AAD solutions.

    :param device_vendor:
    :type device_vendor: str
    :param device_type:
    :type device_type: str
    :param workspace:
    :type workspace: ~azure.mgmt.security.models.ConnectedWorkspace
    :param connectivity_state: The connectivity state of the external AAD
     solution . Possible values include: 'Discovered', 'NotLicensed',
     'Connected'
    :type connectivity_state: str or
     ~azure.mgmt.security.models.AadConnectivityState
    """

    _attribute_map = {
        'device_vendor': {'key': 'deviceVendor', 'type': 'str'},
        'device_type': {'key': 'deviceType', 'type': 'str'},
        'workspace': {'key': 'workspace', 'type': 'ConnectedWorkspace'},
        'connectivity_state': {'key': 'connectivityState', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AadSolutionProperties, self).__init__(**kwargs)
        self.device_vendor = kwargs.get('device_vendor', None)
        self.device_type = kwargs.get('device_type', None)
        self.workspace = kwargs.get('workspace', None)
        self.connectivity_state = kwargs.get('connectivity_state', None)
