# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class DiagnosticsStorageAccountConfig(Model):
    """The storage account information for storing Service Fabric diagnostic logs.

    All required parameters must be populated in order to send to Azure.

    :param storage_account_name: Required. The Azure storage account name.
    :type storage_account_name: str
    :param protected_account_key_name: Required. The protected diagnostics
     storage key name.
    :type protected_account_key_name: str
    :param blob_endpoint: Required. The blob endpoint of the azure storage
     account.
    :type blob_endpoint: str
    :param queue_endpoint: Required. The queue endpoint of the azure storage
     account.
    :type queue_endpoint: str
    :param table_endpoint: Required. The table endpoint of the azure storage
     account.
    :type table_endpoint: str
    """

    _validation = {
        'storage_account_name': {'required': True},
        'protected_account_key_name': {'required': True},
        'blob_endpoint': {'required': True},
        'queue_endpoint': {'required': True},
        'table_endpoint': {'required': True},
    }

    _attribute_map = {
        'storage_account_name': {'key': 'storageAccountName', 'type': 'str'},
        'protected_account_key_name': {'key': 'protectedAccountKeyName', 'type': 'str'},
        'blob_endpoint': {'key': 'blobEndpoint', 'type': 'str'},
        'queue_endpoint': {'key': 'queueEndpoint', 'type': 'str'},
        'table_endpoint': {'key': 'tableEndpoint', 'type': 'str'},
    }

    def __init__(self, *, storage_account_name: str, protected_account_key_name: str, blob_endpoint: str, queue_endpoint: str, table_endpoint: str, **kwargs) -> None:
        super(DiagnosticsStorageAccountConfig, self).__init__(**kwargs)
        self.storage_account_name = storage_account_name
        self.protected_account_key_name = protected_account_key_name
        self.blob_endpoint = blob_endpoint
        self.queue_endpoint = queue_endpoint
        self.table_endpoint = table_endpoint
