"""
.. _ex-shift-evoked:

==================================
Shifting time-scale in evoked data
==================================

"""
# Author: Mainak Jas <mainak@neuro.hut.fi>
#
# License: BSD-3-Clause
# Copyright the MNE-Python contributors.

# %%

import matplotlib.pyplot as plt

import mne
from mne.datasets import sample

print(__doc__)

data_path = sample.data_path()
meg_path = data_path / "MEG" / "sample"
fname = meg_path / "sample_audvis-ave.fif"

# Reading evoked data
condition = "Left Auditory"
evoked = mne.read_evokeds(fname, condition=condition, baseline=(None, 0), proj=True)

picks = ["MEG 2332"]

# Create subplots
f, (ax1, ax2, ax3) = plt.subplots(3)
evoked.plot(
    exclude=[],
    picks=picks,
    axes=ax1,
    titles=dict(grad="Before time shifting"),
    time_unit="s",
)

# Apply relative time-shift of 500 ms
evoked.shift_time(0.5, relative=True)

evoked.plot(
    exclude=[],
    picks=picks,
    axes=ax2,
    titles=dict(grad="Relative shift: 500 ms"),
    time_unit="s",
)

# Apply absolute time-shift of 500 ms
evoked.shift_time(0.5, relative=False)

evoked.plot(
    exclude=[],
    picks=picks,
    axes=ax3,
    titles=dict(grad="Absolute shift: 500 ms"),
    time_unit="s",
)
