"""
Chromsize dictionaries, as downloaded from UCSC.  Need more? Use::

    pybedtools.get_chromsizes_from_ucsc('assemblyname')

"""
# Figure out which version of OrderedDict we want....
import sys

if (sys.version_info[0] == 2) and (sys.version_info[1] < 7):
    from ordereddict import OrderedDict
else:
    from collections import OrderedDict

dm6 = OrderedDict(
    (
        ("chr2L", (0, 23513712)),
        ("chr2R", (0, 25286936)),
        ("chr3L", (0, 28110227)),
        ("chr3R", (0, 32079331)),
        ("chr4", (0, 1348131)),
        ("chrM", (0, 19524)),
        ("chrUn_CP007071v1", (0, 19956)),
        ("chrUn_CP007072v1", (0, 44411)),
        ("chrUn_CP007073v1", (0, 13157)),
        ("chrUn_CP007074v1", (0, 76224)),
        ("chrUn_CP007075v1", (0, 11983)),
        ("chrUn_CP007076v1", (0, 87365)),
        ("chrUn_CP007077v1", (0, 36913)),
        ("chrUn_CP007078v1", (0, 22604)),
        ("chrUn_CP007079v1", (0, 23238)),
        ("chrUn_CP007080v1", (0, 86267)),
        ("chrUn_CP007081v1", (0, 88768)),
        ("chrUn_CP007082v1", (0, 36482)),
        ("chrUn_CP007083v1", (0, 25537)),
        ("chrUn_CP007084v1", (0, 62570)),
        ("chrUn_CP007085v1", (0, 45120)),
        ("chrUn_CP007086v1", (0, 22882)),
        ("chrUn_CP007087v1", (0, 46986)),
        ("chrUn_CP007088v1", (0, 37106)),
        ("chrUn_CP007089v1", (0, 16157)),
        ("chrUn_CP007090v1", (0, 57785)),
        ("chrUn_CP007091v1", (0, 20763)),
        ("chrUn_CP007092v1", (0, 28305)),
        ("chrUn_CP007093v1", (0, 25698)),
        ("chrUn_CP007094v1", (0, 29583)),
        ("chrUn_CP007095v1", (0, 25560)),
        ("chrUn_CP007096v1", (0, 26115)),
        ("chrUn_CP007097v1", (0, 13455)),
        ("chrUn_CP007098v1", (0, 43383)),
        ("chrUn_CP007099v1", (0, 12632)),
        ("chrUn_CP007100v1", (0, 10091)),
        ("chrUn_CP007101v1", (0, 24503)),
        ("chrUn_CP007102v1", (0, 12714)),
        ("chrUn_CP007105v1", (0, 47411)),
        ("chrUn_CP007120v1", (0, 76973)),
        ("chrUn_DS483562v1", (0, 50625)),
        ("chrUn_DS483629v1", (0, 15417)),
        ("chrUn_DS483641v1", (0, 14503)),
        ("chrUn_DS483646v1", (0, 14098)),
        ("chrUn_DS483647v1", (0, 14028)),
        ("chrUn_DS483649v1", (0, 13935)),
        ("chrUn_DS483650v1", (0, 13906)),
        ("chrUn_DS483658v1", (0, 13455)),
        ("chrUn_DS483659v1", (0, 13416)),
        ("chrUn_DS483662v1", (0, 13317)),
        ("chrUn_DS483663v1", (0, 13256)),
        ("chrUn_DS483670v1", (0, 12827)),
        ("chrUn_DS483673v1", (0, 12654)),
        ("chrUn_DS483674v1", (0, 12632)),
        ("chrUn_DS483675v1", (0, 12536)),
        ("chrUn_DS483678v1", (0, 12424)),
        ("chrUn_DS483679v1", (0, 12424)),
        ("chrUn_DS483680v1", (0, 12399)),
        ("chrUn_DS483681v1", (0, 12368)),
        ("chrUn_DS483682v1", (0, 12354)),
        ("chrUn_DS483686v1", (0, 12148)),
        ("chrUn_DS483687v1", (0, 12142)),
        ("chrUn_DS483688v1", (0, 12095)),
        ("chrUn_DS483689v1", (0, 12034)),
        ("chrUn_DS483692v1", (0, 11985)),
        ("chrUn_DS483693v1", (0, 11958)),
        ("chrUn_DS483694v1", (0, 11951)),
        ("chrUn_DS483695v1", (0, 11743)),
        ("chrUn_DS483700v1", (0, 11430)),
        ("chrUn_DS483701v1", (0, 11220)),
        ("chrUn_DS483702v1", (0, 11148)),
        ("chrUn_DS483703v1", (0, 11126)),
        ("chrUn_DS483705v1", (0, 27456)),
        ("chrUn_DS483707v1", (0, 25840)),
        ("chrUn_DS483709v1", (0, 18299)),
        ("chrUn_DS483711v1", (0, 14687)),
        ("chrUn_DS483712v1", (0, 14199)),
        ("chrUn_DS483719v1", (0, 12027)),
        ("chrUn_DS483723v1", (0, 21074)),
        ("chrUn_DS483724v1", (0, 13501)),
        ("chrUn_DS483726v1", (0, 14983)),
        ("chrUn_DS483728v1", (0, 12681)),
        ("chrUn_DS483734v1", (0, 15522)),
        ("chrUn_DS483735v1", (0, 15068)),
        ("chrUn_DS483736v1", (0, 14006)),
        ("chrUn_DS483737v1", (0, 13553)),
        ("chrUn_DS483738v1", (0, 12856)),
        ("chrUn_DS483739v1", (0, 12459)),
        ("chrUn_DS483740v1", (0, 12002)),
        ("chrUn_DS483741v1", (0, 11807)),
        ("chrUn_DS483743v1", (0, 11569)),
        ("chrUn_DS483744v1", (0, 9865)),
        ("chrUn_DS483746v1", (0, 9341)),
        ("chrUn_DS483748v1", (0, 8346)),
        ("chrUn_DS483749v1", (0, 8007)),
        ("chrUn_DS483750v1", (0, 7722)),
        ("chrUn_DS483751v1", (0, 7314)),
        ("chrUn_DS483753v1", (0, 7123)),
        ("chrUn_DS483754v1", (0, 7003)),
        ("chrUn_DS483755v1", (0, 6936)),
        ("chrUn_DS483757v1", (0, 6900)),
        ("chrUn_DS483758v1", (0, 6860)),
        ("chrUn_DS483759v1", (0, 6860)),
        ("chrUn_DS483760v1", (0, 6825)),
        ("chrUn_DS483762v1", (0, 6698)),
        ("chrUn_DS483763v1", (0, 6546)),
        ("chrUn_DS483767v1", (0, 6396)),
        ("chrUn_DS483768v1", (0, 6294)),
        ("chrUn_DS483769v1", (0, 6237)),
        ("chrUn_DS483770v1", (0, 6193)),
        ("chrUn_DS483772v1", (0, 6076)),
        ("chrUn_DS483773v1", (0, 6062)),
        ("chrUn_DS483774v1", (0, 6041)),
        ("chrUn_DS483776v1", (0, 6000)),
        ("chrUn_DS483780v1", (0, 5968)),
        ("chrUn_DS483781v1", (0, 5952)),
        ("chrUn_DS483782v1", (0, 5915)),
        ("chrUn_DS483783v1", (0, 5891)),
        ("chrUn_DS483785v1", (0, 5772)),
        ("chrUn_DS483787v1", (0, 5698)),
        ("chrUn_DS483792v1", (0, 5465)),
        ("chrUn_DS483793v1", (0, 5463)),
        ("chrUn_DS483796v1", (0, 5383)),
        ("chrUn_DS483797v1", (0, 5360)),
        ("chrUn_DS483798v1", (0, 5324)),
        ("chrUn_DS483799v1", (0, 5323)),
        ("chrUn_DS483800v1", (0, 5316)),
        ("chrUn_DS483801v1", (0, 5281)),
        ("chrUn_DS483804v1", (0, 5189)),
        ("chrUn_DS483805v1", (0, 5182)),
        ("chrUn_DS483806v1", (0, 5098)),
        ("chrUn_DS483807v1", (0, 5061)),
        ("chrUn_DS483808v1", (0, 5060)),
        ("chrUn_DS483810v1", (0, 5026)),
        ("chrUn_DS483811v1", (0, 5000)),
        ("chrUn_DS483812v1", (0, 4996)),
        ("chrUn_DS483813v1", (0, 4994)),
        ("chrUn_DS483814v1", (0, 4986)),
        ("chrUn_DS483815v1", (0, 4967)),
        ("chrUn_DS483816v1", (0, 4939)),
        ("chrUn_DS483817v1", (0, 4933)),
        ("chrUn_DS483819v1", (0, 4903)),
        ("chrUn_DS483820v1", (0, 4888)),
        ("chrUn_DS483822v1", (0, 4865)),
        ("chrUn_DS483824v1", (0, 4820)),
        ("chrUn_DS483825v1", (0, 4815)),
        ("chrUn_DS483828v1", (0, 4785)),
        ("chrUn_DS483832v1", (0, 4705)),
        ("chrUn_DS483833v1", (0, 4701)),
        ("chrUn_DS483837v1", (0, 4608)),
        ("chrUn_DS483839v1", (0, 4581)),
        ("chrUn_DS483840v1", (0, 4573)),
        ("chrUn_DS483841v1", (0, 4553)),
        ("chrUn_DS483844v1", (0, 4471)),
        ("chrUn_DS483845v1", (0, 4465)),
        ("chrUn_DS483846v1", (0, 4452)),
        ("chrUn_DS483848v1", (0, 4436)),
        ("chrUn_DS483849v1", (0, 4400)),
        ("chrUn_DS483853v1", (0, 4381)),
        ("chrUn_DS483854v1", (0, 4378)),
        ("chrUn_DS483855v1", (0, 4377)),
        ("chrUn_DS483856v1", (0, 4370)),
        ("chrUn_DS483858v1", (0, 4361)),
        ("chrUn_DS483859v1", (0, 4336)),
        ("chrUn_DS483861v1", (0, 4310)),
        ("chrUn_DS483862v1", (0, 4310)),
        ("chrUn_DS483863v1", (0, 4305)),
        ("chrUn_DS483864v1", (0, 4295)),
        ("chrUn_DS483865v1", (0, 4289)),
        ("chrUn_DS483866v1", (0, 4273)),
        ("chrUn_DS483867v1", (0, 4272)),
        ("chrUn_DS483868v1", (0, 4256)),
        ("chrUn_DS483870v1", (0, 4231)),
        ("chrUn_DS483871v1", (0, 4225)),
        ("chrUn_DS483872v1", (0, 4222)),
        ("chrUn_DS483873v1", (0, 4222)),
        ("chrUn_DS483874v1", (0, 4202)),
        ("chrUn_DS483876v1", (0, 4188)),
        ("chrUn_DS483877v1", (0, 4183)),
        ("chrUn_DS483878v1", (0, 4182)),
        ("chrUn_DS483879v1", (0, 4163)),
        ("chrUn_DS483880v1", (0, 4150)),
        ("chrUn_DS483881v1", (0, 4135)),
        ("chrUn_DS483886v1", (0, 4081)),
        ("chrUn_DS483891v1", (0, 4030)),
        ("chrUn_DS483895v1", (0, 4006)),
        ("chrUn_DS483896v1", (0, 3991)),
        ("chrUn_DS483898v1", (0, 3970)),
        ("chrUn_DS483899v1", (0, 3964)),
        ("chrUn_DS483900v1", (0, 3960)),
        ("chrUn_DS483901v1", (0, 3950)),
        ("chrUn_DS483904v1", (0, 3932)),
        ("chrUn_DS483906v1", (0, 3924)),
        ("chrUn_DS483908v1", (0, 3913)),
        ("chrUn_DS483910v1", (0, 3906)),
        ("chrUn_DS483913v1", (0, 3871)),
        ("chrUn_DS483914v1", (0, 3864)),
        ("chrUn_DS483915v1", (0, 3858)),
        ("chrUn_DS483918v1", (0, 3818)),
        ("chrUn_DS483919v1", (0, 3807)),
        ("chrUn_DS483920v1", (0, 3806)),
        ("chrUn_DS483921v1", (0, 3806)),
        ("chrUn_DS483925v1", (0, 3755)),
        ("chrUn_DS483927v1", (0, 3737)),
        ("chrUn_DS483929v1", (0, 3717)),
        ("chrUn_DS483930v1", (0, 3716)),
        ("chrUn_DS483933v1", (0, 3708)),
        ("chrUn_DS483936v1", (0, 3681)),
        ("chrUn_DS483937v1", (0, 3660)),
        ("chrUn_DS483938v1", (0, 3650)),
        ("chrUn_DS483939v1", (0, 3649)),
        ("chrUn_DS483940v1", (0, 3648)),
        ("chrUn_DS483941v1", (0, 3646)),
        ("chrUn_DS483943v1", (0, 3638)),
        ("chrUn_DS483944v1", (0, 3622)),
        ("chrUn_DS483945v1", (0, 3622)),
        ("chrUn_DS483947v1", (0, 3603)),
        ("chrUn_DS483949v1", (0, 3593)),
        ("chrUn_DS483951v1", (0, 3574)),
        ("chrUn_DS483953v1", (0, 3557)),
        ("chrUn_DS483954v1", (0, 3554)),
        ("chrUn_DS483956v1", (0, 3553)),
        ("chrUn_DS483957v1", (0, 3553)),
        ("chrUn_DS483960v1", (0, 3527)),
        ("chrUn_DS483961v1", (0, 3527)),
        ("chrUn_DS483964v1", (0, 3519)),
        ("chrUn_DS483965v1", (0, 3503)),
        ("chrUn_DS483970v1", (0, 3490)),
        ("chrUn_DS483972v1", (0, 3477)),
        ("chrUn_DS483975v1", (0, 3466)),
        ("chrUn_DS483976v1", (0, 3463)),
        ("chrUn_DS483977v1", (0, 3458)),
        ("chrUn_DS483979v1", (0, 3434)),
        ("chrUn_DS483982v1", (0, 3402)),
        ("chrUn_DS483983v1", (0, 3396)),
        ("chrUn_DS483985v1", (0, 3389)),
        ("chrUn_DS483986v1", (0, 3386)),
        ("chrUn_DS483989v1", (0, 3373)),
        ("chrUn_DS483992v1", (0, 3365)),
        ("chrUn_DS483994v1", (0, 3348)),
        ("chrUn_DS483998v1", (0, 3313)),
        ("chrUn_DS483999v1", (0, 3308)),
        ("chrUn_DS484000v1", (0, 3302)),
        ("chrUn_DS484001v1", (0, 3299)),
        ("chrUn_DS484003v1", (0, 3284)),
        ("chrUn_DS484004v1", (0, 3277)),
        ("chrUn_DS484006v1", (0, 3268)),
        ("chrUn_DS484007v1", (0, 3262)),
        ("chrUn_DS484009v1", (0, 3259)),
        ("chrUn_DS484010v1", (0, 3259)),
        ("chrUn_DS484013v1", (0, 3252)),
        ("chrUn_DS484015v1", (0, 3234)),
        ("chrUn_DS484017v1", (0, 3227)),
        ("chrUn_DS484018v1", (0, 3223)),
        ("chrUn_DS484020v1", (0, 3218)),
        ("chrUn_DS484022v1", (0, 3209)),
        ("chrUn_DS484025v1", (0, 3201)),
        ("chrUn_DS484027v1", (0, 3197)),
        ("chrUn_DS484028v1", (0, 3196)),
        ("chrUn_DS484031v1", (0, 3190)),
        ("chrUn_DS484036v1", (0, 3174)),
        ("chrUn_DS484038v1", (0, 3171)),
        ("chrUn_DS484039v1", (0, 3162)),
        ("chrUn_DS484040v1", (0, 3159)),
        ("chrUn_DS484041v1", (0, 3157)),
        ("chrUn_DS484042v1", (0, 3156)),
        ("chrUn_DS484044v1", (0, 3144)),
        ("chrUn_DS484045v1", (0, 3129)),
        ("chrUn_DS484047v1", (0, 3123)),
        ("chrUn_DS484048v1", (0, 3120)),
        ("chrUn_DS484050v1", (0, 3100)),
        ("chrUn_DS484052v1", (0, 3089)),
        ("chrUn_DS484053v1", (0, 3085)),
        ("chrUn_DS484054v1", (0, 3080)),
        ("chrUn_DS484055v1", (0, 3080)),
        ("chrUn_DS484058v1", (0, 3073)),
        ("chrUn_DS484059v1", (0, 3073)),
        ("chrUn_DS484062v1", (0, 3058)),
        ("chrUn_DS484064v1", (0, 3044)),
        ("chrUn_DS484065v1", (0, 3043)),
        ("chrUn_DS484066v1", (0, 3025)),
        ("chrUn_DS484068v1", (0, 3013)),
        ("chrUn_DS484069v1", (0, 3010)),
        ("chrUn_DS484070v1", (0, 3009)),
        ("chrUn_DS484073v1", (0, 2999)),
        ("chrUn_DS484076v1", (0, 2991)),
        ("chrUn_DS484077v1", (0, 2984)),
        ("chrUn_DS484078v1", (0, 2982)),
        ("chrUn_DS484079v1", (0, 2982)),
        ("chrUn_DS484080v1", (0, 2971)),
        ("chrUn_DS484083v1", (0, 2957)),
        ("chrUn_DS484086v1", (0, 2943)),
        ("chrUn_DS484087v1", (0, 2937)),
        ("chrUn_DS484089v1", (0, 2928)),
        ("chrUn_DS484090v1", (0, 2927)),
        ("chrUn_DS484091v1", (0, 2926)),
        ("chrUn_DS484092v1", (0, 2924)),
        ("chrUn_DS484093v1", (0, 2922)),
        ("chrUn_DS484095v1", (0, 2919)),
        ("chrUn_DS484096v1", (0, 2916)),
        ("chrUn_DS484097v1", (0, 2914)),
        ("chrUn_DS484098v1", (0, 2911)),
        ("chrUn_DS484100v1", (0, 2905)),
        ("chrUn_DS484102v1", (0, 2903)),
        ("chrUn_DS484104v1", (0, 2893)),
        ("chrUn_DS484105v1", (0, 2889)),
        ("chrUn_DS484106v1", (0, 2884)),
        ("chrUn_DS484107v1", (0, 2882)),
        ("chrUn_DS484108v1", (0, 2882)),
        ("chrUn_DS484109v1", (0, 2882)),
        ("chrUn_DS484111v1", (0, 2881)),
        ("chrUn_DS484113v1", (0, 2876)),
        ("chrUn_DS484116v1", (0, 2860)),
        ("chrUn_DS484117v1", (0, 2860)),
        ("chrUn_DS484118v1", (0, 2858)),
        ("chrUn_DS484120v1", (0, 2855)),
        ("chrUn_DS484122v1", (0, 2849)),
        ("chrUn_DS484123v1", (0, 2848)),
        ("chrUn_DS484134v1", (0, 2828)),
        ("chrUn_DS484138v1", (0, 2822)),
        ("chrUn_DS484139v1", (0, 2820)),
        ("chrUn_DS484144v1", (0, 2811)),
        ("chrUn_DS484145v1", (0, 2804)),
        ("chrUn_DS484147v1", (0, 2796)),
        ("chrUn_DS484148v1", (0, 2795)),
        ("chrUn_DS484149v1", (0, 2795)),
        ("chrUn_DS484151v1", (0, 2794)),
        ("chrUn_DS484152v1", (0, 2793)),
        ("chrUn_DS484153v1", (0, 2793)),
        ("chrUn_DS484154v1", (0, 2791)),
        ("chrUn_DS484155v1", (0, 2790)),
        ("chrUn_DS484156v1", (0, 2788)),
        ("chrUn_DS484157v1", (0, 2787)),
        ("chrUn_DS484159v1", (0, 2784)),
        ("chrUn_DS484160v1", (0, 2783)),
        ("chrUn_DS484167v1", (0, 2745)),
        ("chrUn_DS484168v1", (0, 2744)),
        ("chrUn_DS484169v1", (0, 2736)),
        ("chrUn_DS484170v1", (0, 2733)),
        ("chrUn_DS484176v1", (0, 2708)),
        ("chrUn_DS484177v1", (0, 2703)),
        ("chrUn_DS484180v1", (0, 2697)),
        ("chrUn_DS484183v1", (0, 2688)),
        ("chrUn_DS484188v1", (0, 2670)),
        ("chrUn_DS484189v1", (0, 2669)),
        ("chrUn_DS484190v1", (0, 2668)),
        ("chrUn_DS484191v1", (0, 2665)),
        ("chrUn_DS484192v1", (0, 2664)),
        ("chrUn_DS484193v1", (0, 2647)),
        ("chrUn_DS484196v1", (0, 2644)),
        ("chrUn_DS484202v1", (0, 2636)),
        ("chrUn_DS484205v1", (0, 2629)),
        ("chrUn_DS484206v1", (0, 2628)),
        ("chrUn_DS484207v1", (0, 2626)),
        ("chrUn_DS484209v1", (0, 2618)),
        ("chrUn_DS484210v1", (0, 2617)),
        ("chrUn_DS484212v1", (0, 2612)),
        ("chrUn_DS484213v1", (0, 2611)),
        ("chrUn_DS484217v1", (0, 2603)),
        ("chrUn_DS484220v1", (0, 2588)),
        ("chrUn_DS484221v1", (0, 2584)),
        ("chrUn_DS484222v1", (0, 2583)),
        ("chrUn_DS484224v1", (0, 2577)),
        ("chrUn_DS484225v1", (0, 2577)),
        ("chrUn_DS484226v1", (0, 2576)),
        ("chrUn_DS484228v1", (0, 2575)),
        ("chrUn_DS484229v1", (0, 2575)),
        ("chrUn_DS484230v1", (0, 2575)),
        ("chrUn_DS484231v1", (0, 2574)),
        ("chrUn_DS484232v1", (0, 2570)),
        ("chrUn_DS484234v1", (0, 2561)),
        ("chrUn_DS484236v1", (0, 2556)),
        ("chrUn_DS484238v1", (0, 2555)),
        ("chrUn_DS484239v1", (0, 2549)),
        ("chrUn_DS484241v1", (0, 2547)),
        ("chrUn_DS484242v1", (0, 2541)),
        ("chrUn_DS484243v1", (0, 2541)),
        ("chrUn_DS484244v1", (0, 2536)),
        ("chrUn_DS484246v1", (0, 2529)),
        ("chrUn_DS484247v1", (0, 2529)),
        ("chrUn_DS484251v1", (0, 2521)),
        ("chrUn_DS484253v1", (0, 2520)),
        ("chrUn_DS484254v1", (0, 2517)),
        ("chrUn_DS484255v1", (0, 2516)),
        ("chrUn_DS484256v1", (0, 2511)),
        ("chrUn_DS484257v1", (0, 2511)),
        ("chrUn_DS484258v1", (0, 2510)),
        ("chrUn_DS484262v1", (0, 2491)),
        ("chrUn_DS484263v1", (0, 2487)),
        ("chrUn_DS484264v1", (0, 2479)),
        ("chrUn_DS484267v1", (0, 2476)),
        ("chrUn_DS484271v1", (0, 2470)),
        ("chrUn_DS484274v1", (0, 2462)),
        ("chrUn_DS484275v1", (0, 2451)),
        ("chrUn_DS484276v1", (0, 2447)),
        ("chrUn_DS484277v1", (0, 2442)),
        ("chrUn_DS484279v1", (0, 2438)),
        ("chrUn_DS484280v1", (0, 2438)),
        ("chrUn_DS484281v1", (0, 2438)),
        ("chrUn_DS484282v1", (0, 2435)),
        ("chrUn_DS484283v1", (0, 2434)),
        ("chrUn_DS484285v1", (0, 2431)),
        ("chrUn_DS484286v1", (0, 2429)),
        ("chrUn_DS484287v1", (0, 2428)),
        ("chrUn_DS484289v1", (0, 2425)),
        ("chrUn_DS484291v1", (0, 2421)),
        ("chrUn_DS484292v1", (0, 2421)),
        ("chrUn_DS484294v1", (0, 2419)),
        ("chrUn_DS484296v1", (0, 2417)),
        ("chrUn_DS484300v1", (0, 2400)),
        ("chrUn_DS484301v1", (0, 2394)),
        ("chrUn_DS484303v1", (0, 2390)),
        ("chrUn_DS484304v1", (0, 2390)),
        ("chrUn_DS484306v1", (0, 2385)),
        ("chrUn_DS484307v1", (0, 2385)),
        ("chrUn_DS484308v1", (0, 2385)),
        ("chrUn_DS484309v1", (0, 2384)),
        ("chrUn_DS484310v1", (0, 2383)),
        ("chrUn_DS484311v1", (0, 2383)),
        ("chrUn_DS484312v1", (0, 2382)),
        ("chrUn_DS484313v1", (0, 2381)),
        ("chrUn_DS484314v1", (0, 2381)),
        ("chrUn_DS484315v1", (0, 2379)),
        ("chrUn_DS484317v1", (0, 2378)),
        ("chrUn_DS484318v1", (0, 2375)),
        ("chrUn_DS484320v1", (0, 2369)),
        ("chrUn_DS484321v1", (0, 2368)),
        ("chrUn_DS484329v1", (0, 2354)),
        ("chrUn_DS484331v1", (0, 2352)),
        ("chrUn_DS484333v1", (0, 2344)),
        ("chrUn_DS484335v1", (0, 2342)),
        ("chrUn_DS484339v1", (0, 2330)),
        ("chrUn_DS484340v1", (0, 2328)),
        ("chrUn_DS484342v1", (0, 2326)),
        ("chrUn_DS484343v1", (0, 2325)),
        ("chrUn_DS484348v1", (0, 2308)),
        ("chrUn_DS484350v1", (0, 2304)),
        ("chrUn_DS484353v1", (0, 2295)),
        ("chrUn_DS484355v1", (0, 2291)),
        ("chrUn_DS484363v1", (0, 2270)),
        ("chrUn_DS484366v1", (0, 2266)),
        ("chrUn_DS484369v1", (0, 2253)),
        ("chrUn_DS484370v1", (0, 2248)),
        ("chrUn_DS484375v1", (0, 2234)),
        ("chrUn_DS484378v1", (0, 2232)),
        ("chrUn_DS484380v1", (0, 2227)),
        ("chrUn_DS484383v1", (0, 2221)),
        ("chrUn_DS484385v1", (0, 2217)),
        ("chrUn_DS484386v1", (0, 2216)),
        ("chrUn_DS484389v1", (0, 2207)),
        ("chrUn_DS484391v1", (0, 2205)),
        ("chrUn_DS484394v1", (0, 2200)),
        ("chrUn_DS484395v1", (0, 2198)),
        ("chrUn_DS484396v1", (0, 2198)),
        ("chrUn_DS484400v1", (0, 2190)),
        ("chrUn_DS484403v1", (0, 2187)),
        ("chrUn_DS484404v1", (0, 2185)),
        ("chrUn_DS484407v1", (0, 2176)),
        ("chrUn_DS484408v1", (0, 2173)),
        ("chrUn_DS484412v1", (0, 2161)),
        ("chrUn_DS484414v1", (0, 2157)),
        ("chrUn_DS484421v1", (0, 2129)),
        ("chrUn_DS484424v1", (0, 2124)),
        ("chrUn_DS484425v1", (0, 2124)),
        ("chrUn_DS484426v1", (0, 2119)),
        ("chrUn_DS484427v1", (0, 2117)),
        ("chrUn_DS484432v1", (0, 2112)),
        ("chrUn_DS484434v1", (0, 2108)),
        ("chrUn_DS484435v1", (0, 2105)),
        ("chrUn_DS484436v1", (0, 2105)),
        ("chrUn_DS484437v1", (0, 2103)),
        ("chrUn_DS484438v1", (0, 2102)),
        ("chrUn_DS484443v1", (0, 2094)),
        ("chrUn_DS484445v1", (0, 2092)),
        ("chrUn_DS484446v1", (0, 2090)),
        ("chrUn_DS484448v1", (0, 2088)),
        ("chrUn_DS484449v1", (0, 2087)),
        ("chrUn_DS484452v1", (0, 2086)),
        ("chrUn_DS484454v1", (0, 2084)),
        ("chrUn_DS484456v1", (0, 2081)),
        ("chrUn_DS484458v1", (0, 2079)),
        ("chrUn_DS484460v1", (0, 2076)),
        ("chrUn_DS484463v1", (0, 2064)),
        ("chrUn_DS484464v1", (0, 2063)),
        ("chrUn_DS484466v1", (0, 2062)),
        ("chrUn_DS484467v1", (0, 2060)),
        ("chrUn_DS484469v1", (0, 2060)),
        ("chrUn_DS484470v1", (0, 2059)),
        ("chrUn_DS484471v1", (0, 2050)),
        ("chrUn_DS484472v1", (0, 2046)),
        ("chrUn_DS484475v1", (0, 2043)),
        ("chrUn_DS484478v1", (0, 2033)),
        ("chrUn_DS484479v1", (0, 2033)),
        ("chrUn_DS484480v1", (0, 2030)),
        ("chrUn_DS484481v1", (0, 2027)),
        ("chrUn_DS484484v1", (0, 2020)),
        ("chrUn_DS484485v1", (0, 2017)),
        ("chrUn_DS484486v1", (0, 2014)),
        ("chrUn_DS484487v1", (0, 2010)),
        ("chrUn_DS484489v1", (0, 2008)),
        ("chrUn_DS484490v1", (0, 2006)),
        ("chrUn_DS484491v1", (0, 2006)),
        ("chrUn_DS484493v1", (0, 2005)),
        ("chrUn_DS484496v1", (0, 1998)),
        ("chrUn_DS484498v1", (0, 1998)),
        ("chrUn_DS484499v1", (0, 1995)),
        ("chrUn_DS484501v1", (0, 1990)),
        ("chrUn_DS484502v1", (0, 1990)),
        ("chrUn_DS484503v1", (0, 1988)),
        ("chrUn_DS484505v1", (0, 1986)),
        ("chrUn_DS484508v1", (0, 1976)),
        ("chrUn_DS484509v1", (0, 1976)),
        ("chrUn_DS484510v1", (0, 1975)),
        ("chrUn_DS484511v1", (0, 1974)),
        ("chrUn_DS484513v1", (0, 1966)),
        ("chrUn_DS484514v1", (0, 1966)),
        ("chrUn_DS484515v1", (0, 1966)),
        ("chrUn_DS484520v1", (0, 1962)),
        ("chrUn_DS484521v1", (0, 1962)),
        ("chrUn_DS484522v1", (0, 1962)),
        ("chrUn_DS484524v1", (0, 1961)),
        ("chrUn_DS484525v1", (0, 1961)),
        ("chrUn_DS484527v1", (0, 1956)),
        ("chrUn_DS484528v1", (0, 1947)),
        ("chrUn_DS484532v1", (0, 1945)),
        ("chrUn_DS484534v1", (0, 1943)),
        ("chrUn_DS484539v1", (0, 1936)),
        ("chrUn_DS484542v1", (0, 1933)),
        ("chrUn_DS484543v1", (0, 1931)),
        ("chrUn_DS484544v1", (0, 1929)),
        ("chrUn_DS484546v1", (0, 1928)),
        ("chrUn_DS484548v1", (0, 1926)),
        ("chrUn_DS484549v1", (0, 1926)),
        ("chrUn_DS484550v1", (0, 1924)),
        ("chrUn_DS484553v1", (0, 1917)),
        ("chrUn_DS484557v1", (0, 1907)),
        ("chrUn_DS484559v1", (0, 1905)),
        ("chrUn_DS484561v1", (0, 1903)),
        ("chrUn_DS484565v1", (0, 1901)),
        ("chrUn_DS484566v1", (0, 1900)),
        ("chrUn_DS484567v1", (0, 1900)),
        ("chrUn_DS484571v1", (0, 1893)),
        ("chrUn_DS484573v1", (0, 1890)),
        ("chrUn_DS484577v1", (0, 1882)),
        ("chrUn_DS484578v1", (0, 1872)),
        ("chrUn_DS484579v1", (0, 1872)),
        ("chrUn_DS484581v1", (0, 1870)),
        ("chrUn_DS484584v1", (0, 1869)),
        ("chrUn_DS484588v1", (0, 1863)),
        ("chrUn_DS484591v1", (0, 1854)),
        ("chrUn_DS484592v1", (0, 1851)),
        ("chrUn_DS484593v1", (0, 1849)),
        ("chrUn_DS484595v1", (0, 1843)),
        ("chrUn_DS484601v1", (0, 1832)),
        ("chrUn_DS484602v1", (0, 1832)),
        ("chrUn_DS484606v1", (0, 1826)),
        ("chrUn_DS484607v1", (0, 1819)),
        ("chrUn_DS484614v1", (0, 1806)),
        ("chrUn_DS484616v1", (0, 1802)),
        ("chrUn_DS484617v1", (0, 1801)),
        ("chrUn_DS484619v1", (0, 1800)),
        ("chrUn_DS484621v1", (0, 1797)),
        ("chrUn_DS484629v1", (0, 1785)),
        ("chrUn_DS484630v1", (0, 1776)),
        ("chrUn_DS484632v1", (0, 1775)),
        ("chrUn_DS484635v1", (0, 1770)),
        ("chrUn_DS484639v1", (0, 1761)),
        ("chrUn_DS484642v1", (0, 1754)),
        ("chrUn_DS484646v1", (0, 1747)),
        ("chrUn_DS484649v1", (0, 1738)),
        ("chrUn_DS484651v1", (0, 1734)),
        ("chrUn_DS484652v1", (0, 1733)),
        ("chrUn_DS484653v1", (0, 1732)),
        ("chrUn_DS484654v1", (0, 1728)),
        ("chrUn_DS484656v1", (0, 1724)),
        ("chrUn_DS484658v1", (0, 1719)),
        ("chrUn_DS484659v1", (0, 1719)),
        ("chrUn_DS484661v1", (0, 1716)),
        ("chrUn_DS484662v1", (0, 1715)),
        ("chrUn_DS484663v1", (0, 1714)),
        ("chrUn_DS484667v1", (0, 1710)),
        ("chrUn_DS484671v1", (0, 1703)),
        ("chrUn_DS484673v1", (0, 1696)),
        ("chrUn_DS484678v1", (0, 1685)),
        ("chrUn_DS484685v1", (0, 1675)),
        ("chrUn_DS484686v1", (0, 1667)),
        ("chrUn_DS484689v1", (0, 1650)),
        ("chrUn_DS484692v1", (0, 1643)),
        ("chrUn_DS484693v1", (0, 1641)),
        ("chrUn_DS484699v1", (0, 1629)),
        ("chrUn_DS484700v1", (0, 1625)),
        ("chrUn_DS484707v1", (0, 1614)),
        ("chrUn_DS484709v1", (0, 1611)),
        ("chrUn_DS484710v1", (0, 1610)),
        ("chrUn_DS484712v1", (0, 1610)),
        ("chrUn_DS484713v1", (0, 1608)),
        ("chrUn_DS484714v1", (0, 1597)),
        ("chrUn_DS484716v1", (0, 1594)),
        ("chrUn_DS484718v1", (0, 1586)),
        ("chrUn_DS484720v1", (0, 1586)),
        ("chrUn_DS484721v1", (0, 1581)),
        ("chrUn_DS484722v1", (0, 1577)),
        ("chrUn_DS484726v1", (0, 1571)),
        ("chrUn_DS484727v1", (0, 1567)),
        ("chrUn_DS484728v1", (0, 1566)),
        ("chrUn_DS484729v1", (0, 1560)),
        ("chrUn_DS484734v1", (0, 1555)),
        ("chrUn_DS484735v1", (0, 1553)),
        ("chrUn_DS484736v1", (0, 1552)),
        ("chrUn_DS484738v1", (0, 1550)),
        ("chrUn_DS484739v1", (0, 1549)),
        ("chrUn_DS484742v1", (0, 1543)),
        ("chrUn_DS484746v1", (0, 1540)),
        ("chrUn_DS484748v1", (0, 1538)),
        ("chrUn_DS484750v1", (0, 1533)),
        ("chrUn_DS484751v1", (0, 1533)),
        ("chrUn_DS484752v1", (0, 1532)),
        ("chrUn_DS484754v1", (0, 1527)),
        ("chrUn_DS484756v1", (0, 1525)),
        ("chrUn_DS484760v1", (0, 1521)),
        ("chrUn_DS484762v1", (0, 1520)),
        ("chrUn_DS484764v1", (0, 1518)),
        ("chrUn_DS484769v1", (0, 1508)),
        ("chrUn_DS484770v1", (0, 1504)),
        ("chrUn_DS484771v1", (0, 1504)),
        ("chrUn_DS484772v1", (0, 1502)),
        ("chrUn_DS484773v1", (0, 1494)),
        ("chrUn_DS484774v1", (0, 1492)),
        ("chrUn_DS484776v1", (0, 1490)),
        ("chrUn_DS484779v1", (0, 1487)),
        ("chrUn_DS484780v1", (0, 1487)),
        ("chrUn_DS484782v1", (0, 1484)),
        ("chrUn_DS484787v1", (0, 1475)),
        ("chrUn_DS484789v1", (0, 1473)),
        ("chrUn_DS484792v1", (0, 1471)),
        ("chrUn_DS484796v1", (0, 1468)),
        ("chrUn_DS484797v1", (0, 1467)),
        ("chrUn_DS484798v1", (0, 1466)),
        ("chrUn_DS484799v1", (0, 1464)),
        ("chrUn_DS484802v1", (0, 1462)),
        ("chrUn_DS484804v1", (0, 1461)),
        ("chrUn_DS484806v1", (0, 1458)),
        ("chrUn_DS484812v1", (0, 1451)),
        ("chrUn_DS484815v1", (0, 1446)),
        ("chrUn_DS484816v1", (0, 1446)),
        ("chrUn_DS484817v1", (0, 1445)),
        ("chrUn_DS484822v1", (0, 1436)),
        ("chrUn_DS484825v1", (0, 1432)),
        ("chrUn_DS484827v1", (0, 1432)),
        ("chrUn_DS484828v1", (0, 1430)),
        ("chrUn_DS484831v1", (0, 1429)),
        ("chrUn_DS484834v1", (0, 1424)),
        ("chrUn_DS484836v1", (0, 1424)),
        ("chrUn_DS484838v1", (0, 1422)),
        ("chrUn_DS484841v1", (0, 1416)),
        ("chrUn_DS484842v1", (0, 1416)),
        ("chrUn_DS484843v1", (0, 1416)),
        ("chrUn_DS484844v1", (0, 1415)),
        ("chrUn_DS484846v1", (0, 1412)),
        ("chrUn_DS484847v1", (0, 1411)),
        ("chrUn_DS484848v1", (0, 1410)),
        ("chrUn_DS484851v1", (0, 1408)),
        ("chrUn_DS484852v1", (0, 1407)),
        ("chrUn_DS484853v1", (0, 1406)),
        ("chrUn_DS484855v1", (0, 1404)),
        ("chrUn_DS484861v1", (0, 1395)),
        ("chrUn_DS484862v1", (0, 1394)),
        ("chrUn_DS484865v1", (0, 1391)),
        ("chrUn_DS484866v1", (0, 1391)),
        ("chrUn_DS484869v1", (0, 1391)),
        ("chrUn_DS484870v1", (0, 1386)),
        ("chrUn_DS484872v1", (0, 1385)),
        ("chrUn_DS484874v1", (0, 1384)),
        ("chrUn_DS484878v1", (0, 1381)),
        ("chrUn_DS484881v1", (0, 1380)),
        ("chrUn_DS484882v1", (0, 1379)),
        ("chrUn_DS484884v1", (0, 1378)),
        ("chrUn_DS484886v1", (0, 1377)),
        ("chrUn_DS484887v1", (0, 1377)),
        ("chrUn_DS484888v1", (0, 1377)),
        ("chrUn_DS484889v1", (0, 1377)),
        ("chrUn_DS484894v1", (0, 1375)),
        ("chrUn_DS484895v1", (0, 1374)),
        ("chrUn_DS484896v1", (0, 1374)),
        ("chrUn_DS484897v1", (0, 1373)),
        ("chrUn_DS484898v1", (0, 1371)),
        ("chrUn_DS484899v1", (0, 1369)),
        ("chrUn_DS484901v1", (0, 1368)),
        ("chrUn_DS484904v1", (0, 1366)),
        ("chrUn_DS484910v1", (0, 1356)),
        ("chrUn_DS484916v1", (0, 1352)),
        ("chrUn_DS484917v1", (0, 1351)),
        ("chrUn_DS484919v1", (0, 1347)),
        ("chrUn_DS484920v1", (0, 1347)),
        ("chrUn_DS484921v1", (0, 1346)),
        ("chrUn_DS484922v1", (0, 1344)),
        ("chrUn_DS484923v1", (0, 1343)),
        ("chrUn_DS484926v1", (0, 1340)),
        ("chrUn_DS484927v1", (0, 1340)),
        ("chrUn_DS484929v1", (0, 1339)),
        ("chrUn_DS484930v1", (0, 1339)),
        ("chrUn_DS484932v1", (0, 1337)),
        ("chrUn_DS484933v1", (0, 1337)),
        ("chrUn_DS484938v1", (0, 1334)),
        ("chrUn_DS484940v1", (0, 1333)),
        ("chrUn_DS484941v1", (0, 1333)),
        ("chrUn_DS484943v1", (0, 1332)),
        ("chrUn_DS484944v1", (0, 1330)),
        ("chrUn_DS484948v1", (0, 1328)),
        ("chrUn_DS484954v1", (0, 1323)),
        ("chrUn_DS484960v1", (0, 1316)),
        ("chrUn_DS484962v1", (0, 1315)),
        ("chrUn_DS484964v1", (0, 1315)),
        ("chrUn_DS484967v1", (0, 1311)),
        ("chrUn_DS484972v1", (0, 1310)),
        ("chrUn_DS484976v1", (0, 1308)),
        ("chrUn_DS484979v1", (0, 1304)),
        ("chrUn_DS484982v1", (0, 1304)),
        ("chrUn_DS484984v1", (0, 1304)),
        ("chrUn_DS484985v1", (0, 1303)),
        ("chrUn_DS484987v1", (0, 1302)),
        ("chrUn_DS484988v1", (0, 1301)),
        ("chrUn_DS484991v1", (0, 1299)),
        ("chrUn_DS484993v1", (0, 1297)),
        ("chrUn_DS484998v1", (0, 1294)),
        ("chrUn_DS484999v1", (0, 1294)),
        ("chrUn_DS485000v1", (0, 1293)),
        ("chrUn_DS485002v1", (0, 1291)),
        ("chrUn_DS485004v1", (0, 1290)),
        ("chrUn_DS485005v1", (0, 1289)),
        ("chrUn_DS485007v1", (0, 1287)),
        ("chrUn_DS485010v1", (0, 1286)),
        ("chrUn_DS485011v1", (0, 1285)),
        ("chrUn_DS485019v1", (0, 1280)),
        ("chrUn_DS485020v1", (0, 1280)),
        ("chrUn_DS485022v1", (0, 1279)),
        ("chrUn_DS485024v1", (0, 1278)),
        ("chrUn_DS485025v1", (0, 1278)),
        ("chrUn_DS485026v1", (0, 1278)),
        ("chrUn_DS485027v1", (0, 1277)),
        ("chrUn_DS485029v1", (0, 1277)),
        ("chrUn_DS485030v1", (0, 1276)),
        ("chrUn_DS485031v1", (0, 1275)),
        ("chrUn_DS485032v1", (0, 1275)),
        ("chrUn_DS485035v1", (0, 1274)),
        ("chrUn_DS485036v1", (0, 1274)),
        ("chrUn_DS485038v1", (0, 1272)),
        ("chrUn_DS485041v1", (0, 1271)),
        ("chrUn_DS485045v1", (0, 1271)),
        ("chrUn_DS485046v1", (0, 1270)),
        ("chrUn_DS485047v1", (0, 1270)),
        ("chrUn_DS485053v1", (0, 1266)),
        ("chrUn_DS485055v1", (0, 1264)),
        ("chrUn_DS485056v1", (0, 1263)),
        ("chrUn_DS485058v1", (0, 1263)),
        ("chrUn_DS485059v1", (0, 1263)),
        ("chrUn_DS485062v1", (0, 1262)),
        ("chrUn_DS485064v1", (0, 1262)),
        ("chrUn_DS485065v1", (0, 1262)),
        ("chrUn_DS485066v1", (0, 1261)),
        ("chrUn_DS485067v1", (0, 1261)),
        ("chrUn_DS485068v1", (0, 1260)),
        ("chrUn_DS485071v1", (0, 1260)),
        ("chrUn_DS485073v1", (0, 1259)),
        ("chrUn_DS485076v1", (0, 1258)),
        ("chrUn_DS485079v1", (0, 1253)),
        ("chrUn_DS485082v1", (0, 1251)),
        ("chrUn_DS485083v1", (0, 1251)),
        ("chrUn_DS485085v1", (0, 1251)),
        ("chrUn_DS485086v1", (0, 1250)),
        ("chrUn_DS485087v1", (0, 1249)),
        ("chrUn_DS485088v1", (0, 1248)),
        ("chrUn_DS485089v1", (0, 1247)),
        ("chrUn_DS485091v1", (0, 1246)),
        ("chrUn_DS485092v1", (0, 1246)),
        ("chrUn_DS485098v1", (0, 1242)),
        ("chrUn_DS485100v1", (0, 1241)),
        ("chrUn_DS485102v1", (0, 1240)),
        ("chrUn_DS485105v1", (0, 1240)),
        ("chrUn_DS485107v1", (0, 1239)),
        ("chrUn_DS485117v1", (0, 1236)),
        ("chrUn_DS485118v1", (0, 1235)),
        ("chrUn_DS485122v1", (0, 1234)),
        ("chrUn_DS485123v1", (0, 1234)),
        ("chrUn_DS485125v1", (0, 1234)),
        ("chrUn_DS485127v1", (0, 1233)),
        ("chrUn_DS485130v1", (0, 1232)),
        ("chrUn_DS485132v1", (0, 1231)),
        ("chrUn_DS485133v1", (0, 1231)),
        ("chrUn_DS485134v1", (0, 1231)),
        ("chrUn_DS485136v1", (0, 1231)),
        ("chrUn_DS485138v1", (0, 1229)),
        ("chrUn_DS485140v1", (0, 1229)),
        ("chrUn_DS485144v1", (0, 1227)),
        ("chrUn_DS485146v1", (0, 1227)),
        ("chrUn_DS485148v1", (0, 1227)),
        ("chrUn_DS485149v1", (0, 1226)),
        ("chrUn_DS485150v1", (0, 1226)),
        ("chrUn_DS485151v1", (0, 1226)),
        ("chrUn_DS485152v1", (0, 1225)),
        ("chrUn_DS485153v1", (0, 1225)),
        ("chrUn_DS485154v1", (0, 1225)),
        ("chrUn_DS485155v1", (0, 1225)),
        ("chrUn_DS485156v1", (0, 1225)),
        ("chrUn_DS485157v1", (0, 1225)),
        ("chrUn_DS485160v1", (0, 1224)),
        ("chrUn_DS485161v1", (0, 1224)),
        ("chrUn_DS485162v1", (0, 1223)),
        ("chrUn_DS485163v1", (0, 1223)),
        ("chrUn_DS485165v1", (0, 1222)),
        ("chrUn_DS485169v1", (0, 1220)),
        ("chrUn_DS485173v1", (0, 1219)),
        ("chrUn_DS485174v1", (0, 1219)),
        ("chrUn_DS485176v1", (0, 1219)),
        ("chrUn_DS485177v1", (0, 1218)),
        ("chrUn_DS485181v1", (0, 1214)),
        ("chrUn_DS485182v1", (0, 1213)),
        ("chrUn_DS485184v1", (0, 1212)),
        ("chrUn_DS485190v1", (0, 1211)),
        ("chrUn_DS485192v1", (0, 1210)),
        ("chrUn_DS485194v1", (0, 1209)),
        ("chrUn_DS485198v1", (0, 1209)),
        ("chrUn_DS485199v1", (0, 1208)),
        ("chrUn_DS485200v1", (0, 1208)),
        ("chrUn_DS485203v1", (0, 1208)),
        ("chrUn_DS485204v1", (0, 1207)),
        ("chrUn_DS485205v1", (0, 1206)),
        ("chrUn_DS485208v1", (0, 1205)),
        ("chrUn_DS485209v1", (0, 1205)),
        ("chrUn_DS485211v1", (0, 1205)),
        ("chrUn_DS485215v1", (0, 1203)),
        ("chrUn_DS485216v1", (0, 1203)),
        ("chrUn_DS485218v1", (0, 1203)),
        ("chrUn_DS485220v1", (0, 1202)),
        ("chrUn_DS485221v1", (0, 1201)),
        ("chrUn_DS485223v1", (0, 1200)),
        ("chrUn_DS485224v1", (0, 1200)),
        ("chrUn_DS485226v1", (0, 1199)),
        ("chrUn_DS485227v1", (0, 1199)),
        ("chrUn_DS485228v1", (0, 1198)),
        ("chrUn_DS485229v1", (0, 1198)),
        ("chrUn_DS485230v1", (0, 1197)),
        ("chrUn_DS485233v1", (0, 1197)),
        ("chrUn_DS485239v1", (0, 1195)),
        ("chrUn_DS485240v1", (0, 1195)),
        ("chrUn_DS485242v1", (0, 1194)),
        ("chrUn_DS485243v1", (0, 1193)),
        ("chrUn_DS485245v1", (0, 1193)),
        ("chrUn_DS485246v1", (0, 1193)),
        ("chrUn_DS485247v1", (0, 1193)),
        ("chrUn_DS485249v1", (0, 1192)),
        ("chrUn_DS485251v1", (0, 1192)),
        ("chrUn_DS485252v1", (0, 1191)),
        ("chrUn_DS485253v1", (0, 1191)),
        ("chrUn_DS485254v1", (0, 1190)),
        ("chrUn_DS485255v1", (0, 1190)),
        ("chrUn_DS485256v1", (0, 1190)),
        ("chrUn_DS485258v1", (0, 1189)),
        ("chrUn_DS485259v1", (0, 1189)),
        ("chrUn_DS485260v1", (0, 1189)),
        ("chrUn_DS485261v1", (0, 1189)),
        ("chrUn_DS485263v1", (0, 1188)),
        ("chrUn_DS485264v1", (0, 1186)),
        ("chrUn_DS485265v1", (0, 1186)),
        ("chrUn_DS485270v1", (0, 1185)),
        ("chrUn_DS485273v1", (0, 1185)),
        ("chrUn_DS485275v1", (0, 1185)),
        ("chrUn_DS485280v1", (0, 1184)),
        ("chrUn_DS485284v1", (0, 1182)),
        ("chrUn_DS485285v1", (0, 1181)),
        ("chrUn_DS485290v1", (0, 1179)),
        ("chrUn_DS485291v1", (0, 1179)),
        ("chrUn_DS485292v1", (0, 1179)),
        ("chrUn_DS485294v1", (0, 1178)),
        ("chrUn_DS485296v1", (0, 1178)),
        ("chrUn_DS485297v1", (0, 1178)),
        ("chrUn_DS485298v1", (0, 1178)),
        ("chrUn_DS485301v1", (0, 1177)),
        ("chrUn_DS485304v1", (0, 1175)),
        ("chrUn_DS485306v1", (0, 1174)),
        ("chrUn_DS485309v1", (0, 1173)),
        ("chrUn_DS485311v1", (0, 1173)),
        ("chrUn_DS485313v1", (0, 1171)),
        ("chrUn_DS485314v1", (0, 1171)),
        ("chrUn_DS485319v1", (0, 1169)),
        ("chrUn_DS485322v1", (0, 1168)),
        ("chrUn_DS485323v1", (0, 1167)),
        ("chrUn_DS485324v1", (0, 1167)),
        ("chrUn_DS485325v1", (0, 1167)),
        ("chrUn_DS485326v1", (0, 1166)),
        ("chrUn_DS485330v1", (0, 1166)),
        ("chrUn_DS485331v1", (0, 1165)),
        ("chrUn_DS485333v1", (0, 1165)),
        ("chrUn_DS485337v1", (0, 1163)),
        ("chrUn_DS485338v1", (0, 1163)),
        ("chrUn_DS485339v1", (0, 1163)),
        ("chrUn_DS485340v1", (0, 1163)),
        ("chrUn_DS485341v1", (0, 1162)),
        ("chrUn_DS485342v1", (0, 1162)),
        ("chrUn_DS485349v1", (0, 1161)),
        ("chrUn_DS485353v1", (0, 1160)),
        ("chrUn_DS485354v1", (0, 1160)),
        ("chrUn_DS485356v1", (0, 1160)),
        ("chrUn_DS485357v1", (0, 1159)),
        ("chrUn_DS485361v1", (0, 1159)),
        ("chrUn_DS485362v1", (0, 1158)),
        ("chrUn_DS485365v1", (0, 1157)),
        ("chrUn_DS485368v1", (0, 1157)),
        ("chrUn_DS485370v1", (0, 1156)),
        ("chrUn_DS485371v1", (0, 1156)),
        ("chrUn_DS485376v1", (0, 1155)),
        ("chrUn_DS485379v1", (0, 1154)),
        ("chrUn_DS485381v1", (0, 1154)),
        ("chrUn_DS485382v1", (0, 1154)),
        ("chrUn_DS485383v1", (0, 1154)),
        ("chrUn_DS485385v1", (0, 1153)),
        ("chrUn_DS485386v1", (0, 1153)),
        ("chrUn_DS485387v1", (0, 1152)),
        ("chrUn_DS485389v1", (0, 1152)),
        ("chrUn_DS485390v1", (0, 1152)),
        ("chrUn_DS485392v1", (0, 1151)),
        ("chrUn_DS485393v1", (0, 1150)),
        ("chrUn_DS485395v1", (0, 1150)),
        ("chrUn_DS485397v1", (0, 1148)),
        ("chrUn_DS485398v1", (0, 1148)),
        ("chrUn_DS485400v1", (0, 1148)),
        ("chrUn_DS485401v1", (0, 1148)),
        ("chrUn_DS485403v1", (0, 1148)),
        ("chrUn_DS485407v1", (0, 1147)),
        ("chrUn_DS485410v1", (0, 1147)),
        ("chrUn_DS485411v1", (0, 1146)),
        ("chrUn_DS485415v1", (0, 1146)),
        ("chrUn_DS485419v1", (0, 1144)),
        ("chrUn_DS485420v1", (0, 1144)),
        ("chrUn_DS485421v1", (0, 1144)),
        ("chrUn_DS485424v1", (0, 1143)),
        ("chrUn_DS485425v1", (0, 1143)),
        ("chrUn_DS485426v1", (0, 1142)),
        ("chrUn_DS485428v1", (0, 1142)),
        ("chrUn_DS485429v1", (0, 1141)),
        ("chrUn_DS485433v1", (0, 1140)),
        ("chrUn_DS485434v1", (0, 1140)),
        ("chrUn_DS485437v1", (0, 1140)),
        ("chrUn_DS485438v1", (0, 1139)),
        ("chrUn_DS485439v1", (0, 1139)),
        ("chrUn_DS485441v1", (0, 1139)),
        ("chrUn_DS485442v1", (0, 1139)),
        ("chrUn_DS485443v1", (0, 1138)),
        ("chrUn_DS485448v1", (0, 1137)),
        ("chrUn_DS485451v1", (0, 1136)),
        ("chrUn_DS485453v1", (0, 1136)),
        ("chrUn_DS485456v1", (0, 1135)),
        ("chrUn_DS485457v1", (0, 1135)),
        ("chrUn_DS485461v1", (0, 1134)),
        ("chrUn_DS485462v1", (0, 1134)),
        ("chrUn_DS485464v1", (0, 1133)),
        ("chrUn_DS485466v1", (0, 1133)),
        ("chrUn_DS485467v1", (0, 1132)),
        ("chrUn_DS485468v1", (0, 1132)),
        ("chrUn_DS485469v1", (0, 1132)),
        ("chrUn_DS485472v1", (0, 1131)),
        ("chrUn_DS485475v1", (0, 1130)),
        ("chrUn_DS485477v1", (0, 1130)),
        ("chrUn_DS485481v1", (0, 1129)),
        ("chrUn_DS485482v1", (0, 1129)),
        ("chrUn_DS485488v1", (0, 1127)),
        ("chrUn_DS485490v1", (0, 1127)),
        ("chrUn_DS485491v1", (0, 1126)),
        ("chrUn_DS485494v1", (0, 1126)),
        ("chrUn_DS485495v1", (0, 1126)),
        ("chrUn_DS485496v1", (0, 1126)),
        ("chrUn_DS485497v1", (0, 1125)),
        ("chrUn_DS485498v1", (0, 1125)),
        ("chrUn_DS485500v1", (0, 1124)),
        ("chrUn_DS485501v1", (0, 1124)),
        ("chrUn_DS485503v1", (0, 1123)),
        ("chrUn_DS485504v1", (0, 1123)),
        ("chrUn_DS485505v1", (0, 1123)),
        ("chrUn_DS485506v1", (0, 1123)),
        ("chrUn_DS485509v1", (0, 1123)),
        ("chrUn_DS485515v1", (0, 1120)),
        ("chrUn_DS485517v1", (0, 1119)),
        ("chrUn_DS485518v1", (0, 1119)),
        ("chrUn_DS485520v1", (0, 1118)),
        ("chrUn_DS485521v1", (0, 1118)),
        ("chrUn_DS485522v1", (0, 1118)),
        ("chrUn_DS485525v1", (0, 1117)),
        ("chrUn_DS485526v1", (0, 1117)),
        ("chrUn_DS485527v1", (0, 1117)),
        ("chrUn_DS485528v1", (0, 1117)),
        ("chrUn_DS485529v1", (0, 1117)),
        ("chrUn_DS485530v1", (0, 1117)),
        ("chrUn_DS485531v1", (0, 1116)),
        ("chrUn_DS485533v1", (0, 1116)),
        ("chrUn_DS485535v1", (0, 1116)),
        ("chrUn_DS485536v1", (0, 1116)),
        ("chrUn_DS485538v1", (0, 1115)),
        ("chrUn_DS485539v1", (0, 1115)),
        ("chrUn_DS485540v1", (0, 1114)),
        ("chrUn_DS485541v1", (0, 1114)),
        ("chrUn_DS485542v1", (0, 1114)),
        ("chrUn_DS485543v1", (0, 1114)),
        ("chrUn_DS485544v1", (0, 1114)),
        ("chrUn_DS485545v1", (0, 1114)),
        ("chrUn_DS485547v1", (0, 1112)),
        ("chrUn_DS485548v1", (0, 1112)),
        ("chrUn_DS485557v1", (0, 1110)),
        ("chrUn_DS485558v1", (0, 1110)),
        ("chrUn_DS485559v1", (0, 1110)),
        ("chrUn_DS485563v1", (0, 1109)),
        ("chrUn_DS485565v1", (0, 1109)),
        ("chrUn_DS485566v2", (0, 544)),
        ("chrUn_DS485567v1", (0, 1108)),
        ("chrUn_DS485569v1", (0, 1108)),
        ("chrUn_DS485571v1", (0, 1107)),
        ("chrUn_DS485572v1", (0, 1107)),
        ("chrUn_DS485574v1", (0, 1106)),
        ("chrUn_DS485578v1", (0, 1105)),
        ("chrUn_DS485579v1", (0, 1105)),
        ("chrUn_DS485581v1", (0, 1105)),
        ("chrUn_DS485582v1", (0, 1105)),
        ("chrUn_DS485583v1", (0, 1105)),
        ("chrUn_DS485584v1", (0, 1105)),
        ("chrUn_DS485585v1", (0, 1103)),
        ("chrUn_DS485587v1", (0, 1103)),
        ("chrUn_DS485588v1", (0, 1103)),
        ("chrUn_DS485589v1", (0, 1102)),
        ("chrUn_DS485591v1", (0, 1102)),
        ("chrUn_DS485593v1", (0, 1101)),
        ("chrUn_DS485595v1", (0, 1101)),
        ("chrUn_DS485601v1", (0, 1099)),
        ("chrUn_DS485602v1", (0, 1099)),
        ("chrUn_DS485605v1", (0, 1098)),
        ("chrUn_DS485607v1", (0, 1097)),
        ("chrUn_DS485608v1", (0, 1097)),
        ("chrUn_DS485609v1", (0, 1096)),
        ("chrUn_DS485610v1", (0, 1096)),
        ("chrUn_DS485614v1", (0, 1094)),
        ("chrUn_DS485621v1", (0, 1091)),
        ("chrUn_DS485622v1", (0, 1090)),
        ("chrUn_DS485623v1", (0, 1090)),
        ("chrUn_DS485624v1", (0, 1090)),
        ("chrUn_DS485627v1", (0, 1090)),
        ("chrUn_DS485628v1", (0, 1089)),
        ("chrUn_DS485630v1", (0, 1089)),
        ("chrUn_DS485632v1", (0, 1088)),
        ("chrUn_DS485634v1", (0, 1088)),
        ("chrUn_DS485636v1", (0, 1088)),
        ("chrUn_DS485640v1", (0, 1087)),
        ("chrUn_DS485642v1", (0, 1087)),
        ("chrUn_DS485643v1", (0, 1086)),
        ("chrUn_DS485648v1", (0, 1086)),
        ("chrUn_DS485650v1", (0, 1084)),
        ("chrUn_DS485653v1", (0, 1084)),
        ("chrUn_DS485654v1", (0, 1084)),
        ("chrUn_DS485655v1", (0, 1083)),
        ("chrUn_DS485656v1", (0, 1083)),
        ("chrUn_DS485657v1", (0, 1083)),
        ("chrUn_DS485659v1", (0, 1082)),
        ("chrUn_DS485661v1", (0, 1081)),
        ("chrUn_DS485664v1", (0, 1081)),
        ("chrUn_DS485666v1", (0, 1080)),
        ("chrUn_DS485667v1", (0, 1080)),
        ("chrUn_DS485668v1", (0, 1080)),
        ("chrUn_DS485670v1", (0, 1079)),
        ("chrUn_DS485671v1", (0, 1079)),
        ("chrUn_DS485673v1", (0, 1078)),
        ("chrUn_DS485675v1", (0, 1078)),
        ("chrUn_DS485678v1", (0, 1077)),
        ("chrUn_DS485679v1", (0, 1077)),
        ("chrUn_DS485681v1", (0, 1076)),
        ("chrUn_DS485682v1", (0, 1076)),
        ("chrUn_DS485683v1", (0, 1076)),
        ("chrUn_DS485684v1", (0, 1076)),
        ("chrUn_DS485686v1", (0, 1075)),
        ("chrUn_DS485688v1", (0, 1075)),
        ("chrUn_DS485692v1", (0, 1074)),
        ("chrUn_DS485693v1", (0, 1074)),
        ("chrUn_DS485694v1", (0, 1074)),
        ("chrUn_DS485695v2", (0, 564)),
        ("chrUn_DS485701v1", (0, 1072)),
        ("chrUn_DS485703v1", (0, 1071)),
        ("chrUn_DS485709v1", (0, 1070)),
        ("chrUn_DS485711v1", (0, 1070)),
        ("chrUn_DS485712v1", (0, 1070)),
        ("chrUn_DS485714v1", (0, 1069)),
        ("chrUn_DS485717v1", (0, 1069)),
        ("chrUn_DS485722v1", (0, 1067)),
        ("chrUn_DS485724v1", (0, 1067)),
        ("chrUn_DS485725v1", (0, 1066)),
        ("chrUn_DS485728v1", (0, 1064)),
        ("chrUn_DS485729v1", (0, 1064)),
        ("chrUn_DS485733v1", (0, 1063)),
        ("chrUn_DS485737v1", (0, 1063)),
        ("chrUn_DS485740v1", (0, 1063)),
        ("chrUn_DS485741v1", (0, 1063)),
        ("chrUn_DS485742v1", (0, 1062)),
        ("chrUn_DS485743v1", (0, 1062)),
        ("chrUn_DS485746v1", (0, 1062)),
        ("chrUn_DS485747v1", (0, 1062)),
        ("chrUn_DS485748v1", (0, 1061)),
        ("chrUn_DS485750v1", (0, 1060)),
        ("chrUn_DS485751v1", (0, 1060)),
        ("chrUn_DS485753v1", (0, 1059)),
        ("chrUn_DS485754v1", (0, 1059)),
        ("chrUn_DS485757v1", (0, 1058)),
        ("chrUn_DS485760v1", (0, 1058)),
        ("chrUn_DS485766v1", (0, 1056)),
        ("chrUn_DS485770v1", (0, 1055)),
        ("chrUn_DS485773v1", (0, 1054)),
        ("chrUn_DS485774v1", (0, 1053)),
        ("chrUn_DS485775v1", (0, 1053)),
        ("chrUn_DS485780v1", (0, 1053)),
        ("chrUn_DS485781v1", (0, 1052)),
        ("chrUn_DS485783v1", (0, 1052)),
        ("chrUn_DS485788v1", (0, 1051)),
        ("chrUn_DS485789v1", (0, 1051)),
        ("chrUn_DS485792v1", (0, 1050)),
        ("chrUn_DS485793v1", (0, 1050)),
        ("chrUn_DS485794v1", (0, 1049)),
        ("chrUn_DS485796v1", (0, 1049)),
        ("chrUn_DS485802v1", (0, 1048)),
        ("chrUn_DS485803v1", (0, 1048)),
        ("chrUn_DS485806v1", (0, 1048)),
        ("chrUn_DS485807v1", (0, 1048)),
        ("chrUn_DS485808v1", (0, 1047)),
        ("chrUn_DS485810v1", (0, 1047)),
        ("chrUn_DS485812v1", (0, 1047)),
        ("chrUn_DS485818v1", (0, 1045)),
        ("chrUn_DS485820v1", (0, 1045)),
        ("chrUn_DS485821v1", (0, 1045)),
        ("chrUn_DS485822v1", (0, 1045)),
        ("chrUn_DS485823v1", (0, 1044)),
        ("chrUn_DS485825v1", (0, 1044)),
        ("chrUn_DS485826v1", (0, 1044)),
        ("chrUn_DS485827v1", (0, 1043)),
        ("chrUn_DS485828v1", (0, 1043)),
        ("chrUn_DS485832v1", (0, 1042)),
        ("chrUn_DS485833v1", (0, 1042)),
        ("chrUn_DS485838v1", (0, 1042)),
        ("chrUn_DS485841v1", (0, 1041)),
        ("chrUn_DS485842v1", (0, 1041)),
        ("chrUn_DS485846v1", (0, 1040)),
        ("chrUn_DS485847v1", (0, 1040)),
        ("chrUn_DS485848v1", (0, 1040)),
        ("chrUn_DS485850v1", (0, 1039)),
        ("chrUn_DS485851v1", (0, 1039)),
        ("chrUn_DS485853v1", (0, 1038)),
        ("chrUn_DS485854v1", (0, 1038)),
        ("chrUn_DS485859v1", (0, 1036)),
        ("chrUn_DS485863v1", (0, 1035)),
        ("chrUn_DS485864v1", (0, 1035)),
        ("chrUn_DS485867v1", (0, 1035)),
        ("chrUn_DS485868v1", (0, 1035)),
        ("chrUn_DS485870v1", (0, 1033)),
        ("chrUn_DS485872v1", (0, 1033)),
        ("chrUn_DS485874v1", (0, 1033)),
        ("chrUn_DS485876v1", (0, 1032)),
        ("chrUn_DS485878v1", (0, 1032)),
        ("chrUn_DS485880v1", (0, 1031)),
        ("chrUn_DS485882v1", (0, 1031)),
        ("chrUn_DS485883v1", (0, 1030)),
        ("chrUn_DS485886v1", (0, 1030)),
        ("chrUn_DS485887v1", (0, 1029)),
        ("chrUn_DS485889v1", (0, 1029)),
        ("chrUn_DS485891v1", (0, 1029)),
        ("chrUn_DS485893v1", (0, 1029)),
        ("chrUn_DS485897v1", (0, 1028)),
        ("chrUn_DS485900v1", (0, 1027)),
        ("chrUn_DS485902v1", (0, 1026)),
        ("chrUn_DS485903v1", (0, 1026)),
        ("chrUn_DS485904v1", (0, 1025)),
        ("chrUn_DS485905v1", (0, 1025)),
        ("chrUn_DS485906v1", (0, 1025)),
        ("chrUn_DS485907v1", (0, 1025)),
        ("chrUn_DS485911v1", (0, 1023)),
        ("chrUn_DS485912v1", (0, 1022)),
        ("chrUn_DS485915v1", (0, 1022)),
        ("chrUn_DS485917v1", (0, 1022)),
        ("chrUn_DS485918v1", (0, 1021)),
        ("chrUn_DS485919v1", (0, 1021)),
        ("chrUn_DS485923v1", (0, 1021)),
        ("chrUn_DS485925v1", (0, 1020)),
        ("chrUn_DS485929v1", (0, 1020)),
        ("chrUn_DS485932v1", (0, 1019)),
        ("chrUn_DS485933v1", (0, 1019)),
        ("chrUn_DS485935v1", (0, 1019)),
        ("chrUn_DS485939v1", (0, 1018)),
        ("chrUn_DS485940v1", (0, 1018)),
        ("chrUn_DS485944v1", (0, 1016)),
        ("chrUn_DS485946v1", (0, 1016)),
        ("chrUn_DS485947v1", (0, 1016)),
        ("chrUn_DS485948v1", (0, 1015)),
        ("chrUn_DS485952v1", (0, 1014)),
        ("chrUn_DS485953v1", (0, 1014)),
        ("chrUn_DS485954v1", (0, 1014)),
        ("chrUn_DS485955v1", (0, 1014)),
        ("chrUn_DS485957v1", (0, 1013)),
        ("chrUn_DS485958v1", (0, 1013)),
        ("chrUn_DS485964v1", (0, 1012)),
        ("chrUn_DS485965v1", (0, 1012)),
        ("chrUn_DS485966v1", (0, 1011)),
        ("chrUn_DS485968v1", (0, 1011)),
        ("chrUn_DS485969v1", (0, 1011)),
        ("chrUn_DS485973v1", (0, 1010)),
        ("chrUn_DS485979v1", (0, 1008)),
        ("chrUn_DS485980v1", (0, 1008)),
        ("chrUn_DS485982v1", (0, 1007)),
        ("chrUn_DS485983v1", (0, 1006)),
        ("chrUn_DS485984v1", (0, 1006)),
        ("chrUn_DS485985v1", (0, 1006)),
        ("chrUn_DS485986v1", (0, 1005)),
        ("chrUn_DS485988v1", (0, 1005)),
        ("chrUn_DS485989v1", (0, 1005)),
        ("chrUn_DS485991v1", (0, 1005)),
        ("chrUn_DS485995v1", (0, 1004)),
        ("chrUn_DS485996v1", (0, 1004)),
        ("chrUn_DS485997v1", (0, 1004)),
        ("chrUn_DS485998v1", (0, 1003)),
        ("chrUn_DS486002v1", (0, 1001)),
        ("chrUn_DS486004v1", (0, 1001)),
        ("chrUn_DS486005v1", (0, 1001)),
        ("chrUn_DS486008v1", (0, 1001)),
        ("chrX", (0, 23542271)),
        ("chrX_CP007103v1_random", (0, 33320)),
        ("chrX_CP007104v1_random", (0, 27447)),
        ("chrX_DS483648v1_random", (0, 13940)),
        ("chrX_DS483655v1_random", (0, 13549)),
        ("chrX_DS483660v1_random", (0, 13394)),
        ("chrX_DS483665v1_random", (0, 13234)),
        ("chrX_DS483666v1_random", (0, 13108)),
        ("chrX_DS483669v1_random", (0, 12848)),
        ("chrX_DS483685v1_random", (0, 12187)),
        ("chrX_DS483698v1_random", (0, 11522)),
        ("chrX_DS483745v1_random", (0, 9368)),
        ("chrX_DS483784v1_random", (0, 5832)),
        ("chrX_DS483789v1_random", (0, 5555)),
        ("chrX_DS483795v1_random", (0, 5387)),
        ("chrX_DS483803v1_random", (0, 5232)),
        ("chrX_DS483809v1_random", (0, 5057)),
        ("chrX_DS483818v1_random", (0, 4917)),
        ("chrX_DS483821v1_random", (0, 4879)),
        ("chrX_DS483843v1_random", (0, 4515)),
        ("chrX_DS483851v1_random", (0, 4395)),
        ("chrX_DS483885v1_random", (0, 4085)),
        ("chrX_DS483888v1_random", (0, 4072)),
        ("chrX_DS483892v1_random", (0, 4013)),
        ("chrX_DS483893v1_random", (0, 4012)),
        ("chrX_DS483897v1_random", (0, 3984)),
        ("chrX_DS483903v1_random", (0, 3941)),
        ("chrX_DS483905v1_random", (0, 3926)),
        ("chrX_DS483907v1_random", (0, 3921)),
        ("chrX_DS483909v1_random", (0, 3913)),
        ("chrX_DS483923v1_random", (0, 3775)),
        ("chrX_DS483926v1_random", (0, 3745)),
        ("chrX_DS483928v1_random", (0, 3730)),
        ("chrX_DS483946v1_random", (0, 3603)),
        ("chrX_DS483948v1_random", (0, 3602)),
        ("chrX_DS483950v1_random", (0, 3582)),
        ("chrX_DS483955v1_random", (0, 3553)),
        ("chrX_DS483963v1_random", (0, 3523)),
        ("chrX_DS483969v1_random", (0, 3498)),
        ("chrX_DS483971v1_random", (0, 3478)),
        ("chrX_DS483974v1_random", (0, 3473)),
        ("chrX_DS483995v1_random", (0, 3347)),
        ("chrX_DS484002v1_random", (0, 3290)),
        ("chrX_DS484005v1_random", (0, 3275)),
        ("chrX_DS484012v1_random", (0, 3254)),
        ("chrX_DS484023v1_random", (0, 3206)),
        ("chrX_DS484026v1_random", (0, 3201)),
        ("chrX_DS484046v1_random", (0, 3123)),
        ("chrX_DS484051v1_random", (0, 3100)),
        ("chrX_DS484057v1_random", (0, 3076)),
        ("chrX_DS484060v1_random", (0, 3065)),
        ("chrX_DS484061v1_random", (0, 3059)),
        ("chrX_DS484067v1_random", (0, 3024)),
        ("chrX_DS484072v1_random", (0, 3002)),
        ("chrX_DS484074v1_random", (0, 2999)),
        ("chrX_DS484075v1_random", (0, 2996)),
        ("chrX_DS484081v1_random", (0, 2964)),
        ("chrX_DS484084v1_random", (0, 2956)),
        ("chrX_DS484085v1_random", (0, 2945)),
        ("chrX_DS484088v1_random", (0, 2937)),
        ("chrX_DS484099v1_random", (0, 2910)),
        ("chrX_DS484101v1_random", (0, 2904)),
        ("chrX_DS484112v1_random", (0, 2877)),
        ("chrX_DS484114v1_random", (0, 2871)),
        ("chrX_DS484124v1_random", (0, 2846)),
        ("chrX_DS484125v1_random", (0, 2844)),
        ("chrX_DS484126v1_random", (0, 2841)),
        ("chrX_DS484130v1_random", (0, 2834)),
        ("chrX_DS484131v1_random", (0, 2833)),
        ("chrX_DS484132v1_random", (0, 2830)),
        ("chrX_DS484133v1_random", (0, 2829)),
        ("chrX_DS484135v1_random", (0, 2825)),
        ("chrX_DS484136v1_random", (0, 2823)),
        ("chrX_DS484137v1_random", (0, 2822)),
        ("chrX_DS484140v1_random", (0, 2819)),
        ("chrX_DS484143v1_random", (0, 2814)),
        ("chrX_DS484161v1_random", (0, 2781)),
        ("chrX_DS484162v1_random", (0, 2765)),
        ("chrX_DS484165v1_random", (0, 2751)),
        ("chrX_DS484166v1_random", (0, 2750)),
        ("chrX_DS484178v1_random", (0, 2698)),
        ("chrX_DS484182v1_random", (0, 2689)),
        ("chrX_DS484185v1_random", (0, 2686)),
        ("chrX_DS484187v1_random", (0, 2671)),
        ("chrX_DS484198v1_random", (0, 2641)),
        ("chrX_DS484200v1_random", (0, 2639)),
        ("chrX_DS484201v1_random", (0, 2637)),
        ("chrX_DS484203v1_random", (0, 2635)),
        ("chrX_DS484215v1_random", (0, 2605)),
        ("chrX_DS484216v1_random", (0, 2603)),
        ("chrX_DS484219v1_random", (0, 2591)),
        ("chrX_DS484235v1_random", (0, 2557)),
        ("chrX_DS484252v1_random", (0, 2520)),
        ("chrX_DS484260v1_random", (0, 2505)),
        ("chrX_DS484261v1_random", (0, 2500)),
        ("chrX_DS484268v1_random", (0, 2475)),
        ("chrX_DS484272v1_random", (0, 2464)),
        ("chrX_DS484273v1_random", (0, 2463)),
        ("chrX_DS484278v1_random", (0, 2439)),
        ("chrX_DS484284v1_random", (0, 2432)),
        ("chrX_DS484288v1_random", (0, 2425)),
        ("chrX_DS484293v1_random", (0, 2420)),
        ("chrX_DS484297v1_random", (0, 2413)),
        ("chrX_DS484298v1_random", (0, 2412)),
        ("chrX_DS484305v1_random", (0, 2389)),
        ("chrX_DS484316v1_random", (0, 2379)),
        ("chrX_DS484319v1_random", (0, 2372)),
        ("chrX_DS484322v1_random", (0, 2366)),
        ("chrX_DS484323v1_random", (0, 2363)),
        ("chrX_DS484326v1_random", (0, 2357)),
        ("chrX_DS484328v1_random", (0, 2355)),
        ("chrX_DS484330v1_random", (0, 2353)),
        ("chrX_DS484337v1_random", (0, 2335)),
        ("chrX_DS484341v1_random", (0, 2328)),
        ("chrX_DS484344v1_random", (0, 2322)),
        ("chrX_DS484345v1_random", (0, 2318)),
        ("chrX_DS484346v1_random", (0, 2317)),
        ("chrX_DS484349v1_random", (0, 2307)),
        ("chrX_DS484354v1_random", (0, 2293)),
        ("chrX_DS484356v1_random", (0, 2289)),
        ("chrX_DS484357v1_random", (0, 2287)),
        ("chrX_DS484358v1_random", (0, 2286)),
        ("chrX_DS484359v1_random", (0, 2284)),
        ("chrX_DS484360v1_random", (0, 2283)),
        ("chrX_DS484361v1_random", (0, 2282)),
        ("chrX_DS484362v1_random", (0, 2273)),
        ("chrX_DS484364v1_random", (0, 2269)),
        ("chrX_DS484367v1_random", (0, 2259)),
        ("chrX_DS484368v1_random", (0, 2259)),
        ("chrX_DS484371v1_random", (0, 2247)),
        ("chrX_DS484374v1_random", (0, 2237)),
        ("chrX_DS484379v1_random", (0, 2228)),
        ("chrX_DS484382v1_random", (0, 2223)),
        ("chrX_DS484384v1_random", (0, 2220)),
        ("chrX_DS484387v1_random", (0, 2210)),
        ("chrX_DS484388v1_random", (0, 2209)),
        ("chrX_DS484393v1_random", (0, 2201)),
        ("chrX_DS484397v1_random", (0, 2196)),
        ("chrX_DS484399v1_random", (0, 2192)),
        ("chrX_DS484401v1_random", (0, 2189)),
        ("chrX_DS484402v1_random", (0, 2189)),
        ("chrX_DS484406v1_random", (0, 2177)),
        ("chrX_DS484409v1_random", (0, 2166)),
        ("chrX_DS484411v1_random", (0, 2161)),
        ("chrX_DS484415v1_random", (0, 2147)),
        ("chrX_DS484417v1_random", (0, 2139)),
        ("chrX_DS484419v1_random", (0, 2132)),
        ("chrX_DS484423v1_random", (0, 2126)),
        ("chrX_DS484428v1_random", (0, 2114)),
        ("chrX_DS484429v1_random", (0, 2113)),
        ("chrX_DS484430v1_random", (0, 2113)),
        ("chrX_DS484431v1_random", (0, 2113)),
        ("chrX_DS484433v1_random", (0, 2109)),
        ("chrX_DS484442v1_random", (0, 2096)),
        ("chrX_DS484444v1_random", (0, 2094)),
        ("chrX_DS484447v1_random", (0, 2089)),
        ("chrX_DS484450v1_random", (0, 2087)),
        ("chrX_DS484457v1_random", (0, 2079)),
        ("chrX_DS484459v1_random", (0, 2078)),
        ("chrX_DS484462v1_random", (0, 2068)),
        ("chrX_DS484468v1_random", (0, 2060)),
        ("chrX_DS484474v1_random", (0, 2044)),
        ("chrX_DS484477v1_random", (0, 2035)),
        ("chrX_DS484483v1_random", (0, 2021)),
        ("chrX_DS484488v1_random", (0, 2009)),
        ("chrX_DS484497v1_random", (0, 1998)),
        ("chrX_DS484500v1_random", (0, 1993)),
        ("chrX_DS484504v1_random", (0, 1986)),
        ("chrX_DS484506v1_random", (0, 1980)),
        ("chrX_DS484507v1_random", (0, 1978)),
        ("chrX_DS484512v1_random", (0, 1970)),
        ("chrX_DS484518v1_random", (0, 1964)),
        ("chrX_DS484519v1_random", (0, 1963)),
        ("chrX_DS484526v1_random", (0, 1956)),
        ("chrX_DS484529v1_random", (0, 1947)),
        ("chrX_DS484533v1_random", (0, 1944)),
        ("chrX_DS484535v1_random", (0, 1939)),
        ("chrX_DS484538v1_random", (0, 1936)),
        ("chrX_DS484540v1_random", (0, 1935)),
        ("chrX_DS484541v1_random", (0, 1933)),
        ("chrX_DS484545v1_random", (0, 1928)),
        ("chrX_DS484547v1_random", (0, 1927)),
        ("chrX_DS484552v1_random", (0, 1920)),
        ("chrX_DS484555v1_random", (0, 1916)),
        ("chrX_DS484556v1_random", (0, 1916)),
        ("chrX_DS484558v1_random", (0, 1906)),
        ("chrX_DS484560v1_random", (0, 1904)),
        ("chrX_DS484562v1_random", (0, 1903)),
        ("chrX_DS484563v1_random", (0, 1903)),
        ("chrX_DS484564v1_random", (0, 1902)),
        ("chrX_DS484568v1_random", (0, 1899)),
        ("chrX_DS484569v1_random", (0, 1895)),
        ("chrX_DS484570v1_random", (0, 1895)),
        ("chrX_DS484572v1_random", (0, 1891)),
        ("chrX_DS484576v1_random", (0, 1888)),
        ("chrX_DS484580v1_random", (0, 1871)),
        ("chrX_DS484582v1_random", (0, 1870)),
        ("chrX_DS484583v1_random", (0, 1869)),
        ("chrX_DS484585v1_random", (0, 1869)),
        ("chrX_DS484586v1_random", (0, 1868)),
        ("chrX_DS484587v1_random", (0, 1865)),
        ("chrX_DS484590v1_random", (0, 1856)),
        ("chrX_DS484594v1_random", (0, 1843)),
        ("chrX_DS484596v1_random", (0, 1843)),
        ("chrX_DS484597v1_random", (0, 1843)),
        ("chrX_DS484598v1_random", (0, 1842)),
        ("chrX_DS484599v1_random", (0, 1841)),
        ("chrX_DS484600v1_random", (0, 1841)),
        ("chrX_DS484603v1_random", (0, 1830)),
        ("chrX_DS484604v1_random", (0, 1829)),
        ("chrX_DS484605v1_random", (0, 1829)),
        ("chrX_DS484608v1_random", (0, 1818)),
        ("chrX_DS484609v1_random", (0, 1818)),
        ("chrX_DS484610v1_random", (0, 1813)),
        ("chrX_DS484611v1_random", (0, 1813)),
        ("chrX_DS484615v1_random", (0, 1803)),
        ("chrX_DS484618v1_random", (0, 1800)),
        ("chrX_DS484620v1_random", (0, 1798)),
        ("chrX_DS484622v1_random", (0, 1793)),
        ("chrX_DS484623v1_random", (0, 1792)),
        ("chrX_DS484625v1_random", (0, 1787)),
        ("chrX_DS484626v1_random", (0, 1786)),
        ("chrX_DS484628v1_random", (0, 1785)),
        ("chrX_DS484633v1_random", (0, 1775)),
        ("chrX_DS484636v1_random", (0, 1769)),
        ("chrX_DS484644v1_random", (0, 1747)),
        ("chrX_DS484645v1_random", (0, 1747)),
        ("chrX_DS484647v1_random", (0, 1743)),
        ("chrX_DS484648v1_random", (0, 1741)),
        ("chrX_DS484650v1_random", (0, 1737)),
        ("chrX_DS484657v1_random", (0, 1724)),
        ("chrX_DS484660v1_random", (0, 1716)),
        ("chrX_DS484664v1_random", (0, 1713)),
        ("chrX_DS484666v1_random", (0, 1710)),
        ("chrX_DS484668v1_random", (0, 1709)),
        ("chrX_DS484669v1_random", (0, 1708)),
        ("chrX_DS484670v1_random", (0, 1704)),
        ("chrX_DS484672v1_random", (0, 1703)),
        ("chrX_DS484677v1_random", (0, 1687)),
        ("chrX_DS484679v1_random", (0, 1683)),
        ("chrX_DS484682v1_random", (0, 1680)),
        ("chrX_DS484683v1_random", (0, 1679)),
        ("chrX_DS484684v1_random", (0, 1678)),
        ("chrX_DS484688v1_random", (0, 1657)),
        ("chrX_DS484690v1_random", (0, 1645)),
        ("chrX_DS484691v1_random", (0, 1643)),
        ("chrX_DS484694v1_random", (0, 1637)),
        ("chrX_DS484695v1_random", (0, 1637)),
        ("chrX_DS484697v1_random", (0, 1636)),
        ("chrX_DS484698v1_random", (0, 1630)),
        ("chrX_DS484701v1_random", (0, 1625)),
        ("chrX_DS484702v1_random", (0, 1623)),
        ("chrX_DS484703v1_random", (0, 1622)),
        ("chrX_DS484715v1_random", (0, 1595)),
        ("chrX_DS484719v1_random", (0, 1586)),
        ("chrX_DS484723v1_random", (0, 1577)),
        ("chrX_DS484724v1_random", (0, 1575)),
        ("chrX_DS484725v1_random", (0, 1573)),
        ("chrX_DS484730v1_random", (0, 1560)),
        ("chrX_DS484731v1_random", (0, 1558)),
        ("chrX_DS484732v1_random", (0, 1556)),
        ("chrX_DS484733v1_random", (0, 1556)),
        ("chrX_DS484737v1_random", (0, 1550)),
        ("chrX_DS484740v1_random", (0, 1546)),
        ("chrX_DS484741v1_random", (0, 1544)),
        ("chrX_DS484745v1_random", (0, 1541)),
        ("chrX_DS484749v1_random", (0, 1534)),
        ("chrX_DS484753v1_random", (0, 1529)),
        ("chrX_DS484758v1_random", (0, 1525)),
        ("chrX_DS484763v1_random", (0, 1519)),
        ("chrX_DS484765v1_random", (0, 1516)),
        ("chrX_DS484767v1_random", (0, 1510)),
        ("chrX_DS484768v1_random", (0, 1509)),
        ("chrX_DS484775v1_random", (0, 1492)),
        ("chrX_DS484777v1_random", (0, 1489)),
        ("chrX_DS484778v1_random", (0, 1488)),
        ("chrX_DS484783v1_random", (0, 1482)),
        ("chrX_DS484785v1_random", (0, 1478)),
        ("chrX_DS484786v1_random", (0, 1476)),
        ("chrX_DS484803v1_random", (0, 1461)),
        ("chrX_DS484809v1_random", (0, 1453)),
        ("chrX_DS484810v1_random", (0, 1452)),
        ("chrX_DS484811v1_random", (0, 1452)),
        ("chrX_DS484819v1_random", (0, 1441)),
        ("chrX_DS484826v1_random", (0, 1432)),
        ("chrX_DS484832v1_random", (0, 1425)),
        ("chrX_DS484833v1_random", (0, 1424)),
        ("chrX_DS484837v1_random", (0, 1423)),
        ("chrX_DS484839v1_random", (0, 1421)),
        ("chrX_DS484840v1_random", (0, 1419)),
        ("chrX_DS484845v1_random", (0, 1412)),
        ("chrX_DS484850v1_random", (0, 1408)),
        ("chrX_DS484857v1_random", (0, 1402)),
        ("chrX_DS484871v1_random", (0, 1386)),
        ("chrX_DS484879v1_random", (0, 1381)),
        ("chrX_DS484880v1_random", (0, 1380)),
        ("chrX_DS484890v1_random", (0, 1376)),
        ("chrX_DS484907v1_random", (0, 1361)),
        ("chrX_DS484911v1_random", (0, 1355)),
        ("chrX_DS484913v1_random", (0, 1355)),
        ("chrX_DS484928v1_random", (0, 1340)),
        ("chrX_DS484935v1_random", (0, 1336)),
        ("chrX_DS484951v1_random", (0, 1327)),
        ("chrX_DS484952v1_random", (0, 1326)),
        ("chrX_DS484953v1_random", (0, 1326)),
        ("chrX_DS484955v1_random", (0, 1323)),
        ("chrX_DS484961v1_random", (0, 1315)),
        ("chrX_DS484963v1_random", (0, 1315)),
        ("chrX_DS484965v1_random", (0, 1312)),
        ("chrX_DS484968v1_random", (0, 1311)),
        ("chrX_DS484970v1_random", (0, 1310)),
        ("chrX_DS484974v1_random", (0, 1309)),
        ("chrX_DS484978v1_random", (0, 1306)),
        ("chrX_DS484990v1_random", (0, 1301)),
        ("chrX_DS484995v1_random", (0, 1296)),
        ("chrX_DS484996v1_random", (0, 1295)),
        ("chrX_DS484997v1_random", (0, 1294)),
        ("chrX_DS485012v1_random", (0, 1284)),
        ("chrX_DS485015v1_random", (0, 1283)),
        ("chrX_DS485017v1_random", (0, 1281)),
        ("chrX_DS485043v1_random", (0, 1271)),
        ("chrX_DS485044v1_random", (0, 1271)),
        ("chrX_DS485049v1_random", (0, 1269)),
        ("chrX_DS485050v1_random", (0, 1268)),
        ("chrX_DS485054v1_random", (0, 1265)),
        ("chrX_DS485072v1_random", (0, 1260)),
        ("chrX_DS485074v1_random", (0, 1258)),
        ("chrX_DS485077v1_random", (0, 1258)),
        ("chrX_DS485078v1_random", (0, 1257)),
        ("chrX_DS485080v1_random", (0, 1253)),
        ("chrX_DS485081v1_random", (0, 1252)),
        ("chrX_DS485084v1_random", (0, 1251)),
        ("chrX_DS485096v1_random", (0, 1244)),
        ("chrX_DS485101v1_random", (0, 1241)),
        ("chrX_DS485104v1_random", (0, 1240)),
        ("chrX_DS485109v1_random", (0, 1238)),
        ("chrX_DS485110v1_random", (0, 1238)),
        ("chrX_DS485111v1_random", (0, 1238)),
        ("chrX_DS485112v1_random", (0, 1238)),
        ("chrX_DS485119v1_random", (0, 1235)),
        ("chrX_DS485126v1_random", (0, 1233)),
        ("chrX_DS485141v1_random", (0, 1228)),
        ("chrX_DS485164v1_random", (0, 1223)),
        ("chrX_DS485167v1_random", (0, 1221)),
        ("chrX_DS485172v1_random", (0, 1220)),
        ("chrX_DS485186v1_random", (0, 1212)),
        ("chrX_DS485189v1_random", (0, 1211)),
        ("chrX_DS485195v1_random", (0, 1209)),
        ("chrX_DS485201v1_random", (0, 1208)),
        ("chrX_DS485225v1_random", (0, 1200)),
        ("chrX_DS485235v1_random", (0, 1195)),
        ("chrX_DS485238v1_random", (0, 1195)),
        ("chrX_DS485257v1_random", (0, 1189)),
        ("chrX_DS485262v1_random", (0, 1189)),
        ("chrX_DS485266v1_random", (0, 1186)),
        ("chrX_DS485268v1_random", (0, 1186)),
        ("chrX_DS485271v1_random", (0, 1185)),
        ("chrX_DS485277v1_random", (0, 1184)),
        ("chrX_DS485278v1_random", (0, 1184)),
        ("chrX_DS485281v1_random", (0, 1184)),
        ("chrX_DS485287v1_random", (0, 1181)),
        ("chrX_DS485299v1_random", (0, 1178)),
        ("chrX_DS485300v1_random", (0, 1178)),
        ("chrX_DS485303v1_random", (0, 1175)),
        ("chrX_DS485305v1_random", (0, 1174)),
        ("chrX_DS485310v1_random", (0, 1173)),
        ("chrX_DS485334v1_random", (0, 1164)),
        ("chrX_DS485336v1_random", (0, 1163)),
        ("chrX_DS485345v1_random", (0, 1161)),
        ("chrX_DS485351v1_random", (0, 1161)),
        ("chrX_DS485358v1_random", (0, 1159)),
        ("chrX_DS485360v1_random", (0, 1159)),
        ("chrX_DS485364v1_random", (0, 1158)),
        ("chrX_DS485378v1_random", (0, 1155)),
        ("chrX_DS485384v1_random", (0, 1153)),
        ("chrX_DS485418v1_random", (0, 1145)),
        ("chrX_DS485454v1_random", (0, 1135)),
        ("chrX_DS485459v1_random", (0, 1134)),
        ("chrX_DS485465v1_random", (0, 1133)),
        ("chrX_DS485471v1_random", (0, 1131)),
        ("chrX_DS485476v1_random", (0, 1130)),
        ("chrX_DS485478v1_random", (0, 1129)),
        ("chrX_DS485514v1_random", (0, 1121)),
        ("chrX_DS485537v1_random", (0, 1115)),
        ("chrX_DS485549v1_random", (0, 1112)),
        ("chrX_DS485550v1_random", (0, 1112)),
        ("chrX_DS485562v1_random", (0, 1109)),
        ("chrX_DS485573v1_random", (0, 1107)),
        ("chrX_DS485592v1_random", (0, 1102)),
        ("chrX_DS485597v1_random", (0, 1100)),
        ("chrX_DS485599v1_random", (0, 1100)),
        ("chrX_DS485603v1_random", (0, 1098)),
        ("chrX_DS485606v1_random", (0, 1097)),
        ("chrX_DS485617v1_random", (0, 1093)),
        ("chrX_DS485618v1_random", (0, 1092)),
        ("chrX_DS485620v1_random", (0, 1091)),
        ("chrX_DS485635v1_random", (0, 1088)),
        ("chrX_DS485647v1_random", (0, 1086)),
        ("chrX_DS485649v1_random", (0, 1084)),
        ("chrX_DS485651v1_random", (0, 1084)),
        ("chrX_DS485660v1_random", (0, 1082)),
        ("chrX_DS485672v1_random", (0, 1078)),
        ("chrX_DS485676v1_random", (0, 1078)),
        ("chrX_DS485687v1_random", (0, 1075)),
        ("chrX_DS485691v1_random", (0, 1074)),
        ("chrX_DS485707v1_random", (0, 1071)),
        ("chrX_DS485723v1_random", (0, 1067)),
        ("chrX_DS485735v1_random", (0, 1063)),
        ("chrX_DS485738v1_random", (0, 1063)),
        ("chrX_DS485745v1_random", (0, 1062)),
        ("chrX_DS485756v1_random", (0, 1058)),
        ("chrX_DS485762v1_random", (0, 1057)),
        ("chrX_DS485765v1_random", (0, 1056)),
        ("chrX_DS485769v1_random", (0, 1055)),
        ("chrX_DS485771v1_random", (0, 1055)),
        ("chrX_DS485778v1_random", (0, 1053)),
        ("chrX_DS485782v1_random", (0, 1052)),
        ("chrX_DS485785v1_random", (0, 1051)),
        ("chrX_DS485790v1_random", (0, 1051)),
        ("chrX_DS485797v1_random", (0, 1049)),
        ("chrX_DS485798v1_random", (0, 1049)),
        ("chrX_DS485801v1_random", (0, 1048)),
        ("chrX_DS485813v1_random", (0, 1047)),
        ("chrX_DS485816v1_random", (0, 1046)),
        ("chrX_DS485836v1_random", (0, 1042)),
        ("chrX_DS485845v1_random", (0, 1040)),
        ("chrX_DS485852v1_random", (0, 1038)),
        ("chrX_DS485855v1_random", (0, 1037)),
        ("chrX_DS485856v1_random", (0, 1037)),
        ("chrX_DS485857v1_random", (0, 1037)),
        ("chrX_DS485860v1_random", (0, 1036)),
        ("chrX_DS485879v1_random", (0, 1031)),
        ("chrX_DS485898v1_random", (0, 1028)),
        ("chrX_DS485899v1_random", (0, 1027)),
        ("chrX_DS485909v1_random", (0, 1023)),
        ("chrX_DS485913v1_random", (0, 1022)),
        ("chrX_DS485934v1_random", (0, 1019)),
        ("chrX_DS485941v1_random", (0, 1018)),
        ("chrX_DS485942v1_random", (0, 1018)),
        ("chrX_DS485950v1_random", (0, 1015)),
        ("chrX_DS485959v1_random", (0, 1013)),
        ("chrX_DS485962v1_random", (0, 1012)),
        ("chrX_DS485967v1_random", (0, 1011)),
        ("chrX_DS485978v1_random", (0, 1008)),
        ("chrX_DS485981v1_random", (0, 1007)),
        ("chrX_DS485987v1_random", (0, 1005)),
        ("chrX_DS485994v1_random", (0, 1004)),
        ("chrY", (0, 3667352)),
        ("chrY_CP007107v1_random", (0, 73091)),
        ("chrY_CP007108v1_random", (0, 66731)),
        ("chrY_CP007109v1_random", (0, 66439)),
        ("chrY_CP007110v1_random", (0, 33316)),
        ("chrY_CP007111v1_random", (0, 34521)),
        ("chrY_CP007112v1_random", (0, 39041)),
        ("chrY_CP007113v1_random", (0, 34359)),
        ("chrY_CP007114v1_random", (0, 31460)),
        ("chrY_CP007115v1_random", (0, 21921)),
        ("chrY_CP007116v1_random", (0, 25805)),
        ("chrY_CP007117v1_random", (0, 24380)),
        ("chrY_CP007118v1_random", (0, 44104)),
        ("chrY_CP007119v1_random", (0, 11498)),
        ("chrY_DS483677v1_random", (0, 12513)),
        ("chrY_DS483690v1_random", (0, 12001)),
        ("chrY_DS483725v1_random", (0, 13079)),
        ("chrY_DS483742v1_random", (0, 11763)),
        ("chrY_DS483778v1_random", (0, 5984)),
        ("chrY_DS483788v1_random", (0, 5564)),
        ("chrY_DS483790v1_random", (0, 5520)),
        ("chrY_DS483875v1_random", (0, 4197)),
        ("chrY_DS483889v1_random", (0, 4059)),
        ("chrY_DS483931v1_random", (0, 3713)),
        ("chrY_DS483959v1_random", (0, 3537)),
        ("chrY_DS483966v1_random", (0, 3502)),
        ("chrY_DS483967v1_random", (0, 3499)),
        ("chrY_DS483987v1_random", (0, 3375)),
        ("chrY_DS483988v1_random", (0, 3374)),
        ("chrY_DS483996v1_random", (0, 3341)),
        ("chrY_DS484021v1_random", (0, 3213)),
        ("chrY_DS484029v1_random", (0, 3195)),
        ("chrY_DS484037v1_random", (0, 3173)),
        ("chrY_DS484043v1_random", (0, 3154)),
        ("chrY_DS484049v1_random", (0, 3102)),
        ("chrY_DS484056v1_random", (0, 3077)),
        ("chrY_DS484063v1_random", (0, 3046)),
        ("chrY_DS484094v1_random", (0, 2922)),
        ("chrY_DS484103v1_random", (0, 2899)),
        ("chrY_DS484128v1_random", (0, 2836)),
        ("chrY_DS484142v1_random", (0, 2815)),
        ("chrY_DS484146v1_random", (0, 2799)),
        ("chrY_DS484164v1_random", (0, 2762)),
        ("chrY_DS484171v1_random", (0, 2728)),
        ("chrY_DS484175v1_random", (0, 2709)),
        ("chrY_DS484181v1_random", (0, 2694)),
        ("chrY_DS484184v1_random", (0, 2688)),
        ("chrY_DS484197v1_random", (0, 2642)),
        ("chrY_DS484233v1_random", (0, 2565)),
        ("chrY_DS484249v1_random", (0, 2522)),
        ("chrY_DS484250v1_random", (0, 2521)),
        ("chrY_DS484259v1_random", (0, 2508)),
        ("chrY_DS484266v1_random", (0, 2477)),
        ("chrY_DS484270v1_random", (0, 2473)),
        ("chrY_DS484336v1_random", (0, 2342)),
        ("chrY_DS484351v1_random", (0, 2303)),
        ("chrY_DS484377v1_random", (0, 2232)),
        ("chrY_DS484390v1_random", (0, 2206)),
        ("chrY_DS484441v1_random", (0, 2096)),
        ("chrY_DS484465v1_random", (0, 2063)),
        ("chrY_DS484492v1_random", (0, 2005)),
        ("chrY_DS484523v1_random", (0, 1961)),
        ("chrY_DS484530v1_random", (0, 1947)),
        ("chrY_DS484531v1_random", (0, 1946)),
        ("chrY_DS484574v1_random", (0, 1890)),
        ("chrY_DS484589v1_random", (0, 1863)),
        ("chrY_DS484631v1_random", (0, 1775)),
        ("chrY_DS484637v1_random", (0, 1766)),
        ("chrY_DS484641v1_random", (0, 1756)),
        ("chrY_DS484643v1_random", (0, 1751)),
        ("chrY_DS484665v1_random", (0, 1712)),
        ("chrY_DS484674v1_random", (0, 1690)),
        ("chrY_DS484675v1_random", (0, 1690)),
        ("chrY_DS484680v1_random", (0, 1683)),
        ("chrY_DS484681v1_random", (0, 1683)),
        ("chrY_DS484696v1_random", (0, 1637)),
        ("chrY_DS484706v1_random", (0, 1619)),
        ("chrY_DS484757v1_random", (0, 1525)),
        ("chrY_DS484781v1_random", (0, 1485)),
        ("chrY_DS484805v1_random", (0, 1459)),
        ("chrY_DS484807v1_random", (0, 1456)),
        ("chrY_DS484818v1_random", (0, 1443)),
        ("chrY_DS484820v1_random", (0, 1440)),
        ("chrY_DS484830v1_random", (0, 1429)),
        ("chrY_DS484863v1_random", (0, 1393)),
        ("chrY_DS484875v1_random", (0, 1383)),
        ("chrY_DS484876v1_random", (0, 1382)),
        ("chrY_DS484908v1_random", (0, 1360)),
        ("chrY_DS484909v1_random", (0, 1356)),
        ("chrY_DS484924v1_random", (0, 1341)),
        ("chrY_DS484942v1_random", (0, 1333)),
        ("chrY_DS484945v1_random", (0, 1330)),
        ("chrY_DS484956v1_random", (0, 1322)),
        ("chrY_DS484983v1_random", (0, 1304)),
        ("chrY_DS484986v1_random", (0, 1303)),
        ("chrY_DS484992v1_random", (0, 1297)),
        ("chrY_DS484994v1_random", (0, 1297)),
        ("chrY_DS485013v1_random", (0, 1284)),
        ("chrY_DS485014v1_random", (0, 1283)),
        ("chrY_DS485016v1_random", (0, 1282)),
        ("chrY_DS485028v1_random", (0, 1277)),
        ("chrY_DS485042v1_random", (0, 1271)),
        ("chrY_DS485048v1_random", (0, 1270)),
        ("chrY_DS485051v1_random", (0, 1268)),
        ("chrY_DS485070v1_random", (0, 1260)),
        ("chrY_DS485097v1_random", (0, 1243)),
        ("chrY_DS485099v1_random", (0, 1241)),
        ("chrY_DS485113v1_random", (0, 1237)),
        ("chrY_DS485137v1_random", (0, 1230)),
        ("chrY_DS485143v1_random", (0, 1227)),
        ("chrY_DS485158v1_random", (0, 1224)),
        ("chrY_DS485159v1_random", (0, 1224)),
        ("chrY_DS485166v1_random", (0, 1222)),
        ("chrY_DS485178v1_random", (0, 1218)),
        ("chrY_DS485219v1_random", (0, 1202)),
        ("chrY_DS485236v1_random", (0, 1195)),
        ("chrY_DS485250v1_random", (0, 1192)),
        ("chrY_DS485267v1_random", (0, 1186)),
        ("chrY_DS485283v1_random", (0, 1182)),
        ("chrY_DS485288v1_random", (0, 1181)),
        ("chrY_DS485302v1_random", (0, 1176)),
        ("chrY_DS485315v1_random", (0, 1171)),
        ("chrY_DS485316v1_random", (0, 1171)),
        ("chrY_DS485318v1_random", (0, 1170)),
        ("chrY_DS485320v1_random", (0, 1169)),
        ("chrY_DS485328v1_random", (0, 1166)),
        ("chrY_DS485329v1_random", (0, 1166)),
        ("chrY_DS485335v1_random", (0, 1163)),
        ("chrY_DS485343v1_random", (0, 1162)),
        ("chrY_DS485359v1_random", (0, 1159)),
        ("chrY_DS485363v1_random", (0, 1158)),
        ("chrY_DS485374v1_random", (0, 1155)),
        ("chrY_DS485375v1_random", (0, 1155)),
        ("chrY_DS485388v1_random", (0, 1152)),
        ("chrY_DS485399v1_random", (0, 1148)),
        ("chrY_DS485409v1_random", (0, 1147)),
        ("chrY_DS485416v1_random", (0, 1146)),
        ("chrY_DS485422v1_random", (0, 1144)),
        ("chrY_DS485423v1_random", (0, 1144)),
        ("chrY_DS485427v1_random", (0, 1142)),
        ("chrY_DS485430v1_random", (0, 1141)),
        ("chrY_DS485436v1_random", (0, 1140)),
        ("chrY_DS485440v1_random", (0, 1139)),
        ("chrY_DS485450v1_random", (0, 1136)),
        ("chrY_DS485452v1_random", (0, 1136)),
        ("chrY_DS485460v1_random", (0, 1134)),
        ("chrY_DS485470v1_random", (0, 1132)),
        ("chrY_DS485473v1_random", (0, 1131)),
        ("chrY_DS485483v1_random", (0, 1129)),
        ("chrY_DS485492v1_random", (0, 1126)),
        ("chrY_DS485512v1_random", (0, 1122)),
        ("chrY_DS485523v1_random", (0, 1118)),
        ("chrY_DS485532v1_random", (0, 1116)),
        ("chrY_DS485534v1_random", (0, 1116)),
        ("chrY_DS485552v1_random", (0, 1111)),
        ("chrY_DS485560v1_random", (0, 1110)),
        ("chrY_DS485561v1_random", (0, 1109)),
        ("chrY_DS485575v1_random", (0, 1106)),
        ("chrY_DS485594v1_random", (0, 1101)),
        ("chrY_DS485604v1_random", (0, 1098)),
        ("chrY_DS485625v1_random", (0, 1090)),
        ("chrY_DS485641v1_random", (0, 1087)),
        ("chrY_DS485646v1_random", (0, 1086)),
        ("chrY_DS485685v1_random", (0, 1075)),
        ("chrY_DS485696v1_random", (0, 1073)),
        ("chrY_DS485698v1_random", (0, 1072)),
        ("chrY_DS485718v1_random", (0, 1068)),
        ("chrY_DS485732v1_random", (0, 1064)),
        ("chrY_DS485736v1_random", (0, 1063)),
        ("chrY_DS485739v1_random", (0, 1063)),
        ("chrY_DS485749v1_random", (0, 1060)),
        ("chrY_DS485752v1_random", (0, 1059)),
        ("chrY_DS485755v1_random", (0, 1058)),
        ("chrY_DS485764v1_random", (0, 1056)),
        ("chrY_DS485767v1_random", (0, 1056)),
        ("chrY_DS485772v1_random", (0, 1054)),
        ("chrY_DS485776v1_random", (0, 1053)),
        ("chrY_DS485786v1_random", (0, 1051)),
        ("chrY_DS485795v1_random", (0, 1049)),
        ("chrY_DS485839v1_random", (0, 1042)),
        ("chrY_DS485840v1_random", (0, 1041)),
        ("chrY_DS485849v1_random", (0, 1039)),
        ("chrY_DS485858v1_random", (0, 1037)),
        ("chrY_DS485865v1_random", (0, 1035)),
        ("chrY_DS485873v1_random", (0, 1033)),
        ("chrY_DS485875v1_random", (0, 1032)),
        ("chrY_DS485885v1_random", (0, 1030)),
        ("chrY_DS485888v1_random", (0, 1029)),
        ("chrY_DS485892v1_random", (0, 1029)),
        ("chrY_DS485894v1_random", (0, 1029)),
        ("chrY_DS485901v1_random", (0, 1027)),
        ("chrY_DS485927v1_random", (0, 1020)),
        ("chrY_DS485938v1_random", (0, 1019)),
        ("chrY_DS485956v1_random", (0, 1014)),
        ("chrY_DS485960v1_random", (0, 1012)),
        ("chrY_DS485963v1_random", (0, 1012)),
        ("chrY_DS485972v1_random", (0, 1010)),
        ("chrY_DS485974v1_random", (0, 1010)),
        ("chrY_DS485975v1_random", (0, 1010)),
        ("chrY_DS486003v1_random", (0, 1001)),
    )
)


dm6.default = OrderedDict()
for chrom, size in list(dm6.items()):
    if "_random" in chrom or "Un_" in chrom:
        continue
    dm6.default[chrom] = size


dm3 = OrderedDict(
    (
        ("chr2L", (0, 23011544)),
        ("chr2R", (0, 21146708)),
        ("chr3L", (0, 24543557)),
        ("chr3R", (0, 27905053)),
        ("chr4", (0, 1351857)),
        ("chrX", (0, 22422827)),
        ("chr2LHet", (0, 368872)),
        ("chr2RHet", (0, 3288761)),
        ("chr3LHet", (0, 2555491)),
        ("chr3RHet", (0, 2517507)),
        ("chrM", (0, 19517)),
        ("chrU", (0, 10049037)),
        ("chrUextra", (0, 29004656)),
        ("chrXHet", (0, 204112)),
        ("chrYHet", (0, 347038)),
    )
)

# No chrUextra or chrM
dm3.default = OrderedDict()
for chrom, size in list(dm3.items()):
    if chrom in ["chrUextra", "chrM"]:
        continue
    dm3.default[chrom] = size

# No chrU*, chr*Het, or chrM
dm3.euchromatic = OrderedDict()
for chrom, size in list(dm3.default.items()):
    if "chrU" in chrom:
        continue
    if "Het" in chrom:
        continue
    dm3.euchromatic[chrom] = size


mm10 = OrderedDict(
    (
        ("chr1", (0, 195471971)),
        ("chr2", (0, 182113224)),
        ("chr3", (0, 160039680)),
        ("chr4", (0, 156508116)),
        ("chr5", (0, 151834684)),
        ("chr6", (0, 149736546)),
        ("chr7", (0, 145441459)),
        ("chr8", (0, 129401213)),
        ("chr9", (0, 124595110)),
        ("chr10", (0, 130694993)),
        ("chr11", (0, 122082543)),
        ("chr12", (0, 120129022)),
        ("chr13", (0, 120421639)),
        ("chr14", (0, 124902244)),
        ("chr15", (0, 104043685)),
        ("chr16", (0, 98207768)),
        ("chr17", (0, 94987271)),
        ("chr18", (0, 90702639)),
        ("chr19", (0, 61431566)),
        ("chrM", (0, 16299)),
        ("chrX", (0, 171031299)),
        ("chrY", (0, 91744698)),
        ("chr1_GL456210_random", (0, 169725)),
        ("chr1_GL456211_random", (0, 241735)),
        ("chr1_GL456212_random", (0, 153618)),
        ("chr1_GL456213_random", (0, 39340)),
        ("chr1_GL456221_random", (0, 206961)),
        ("chr4_GL456216_random", (0, 66673)),
        ("chr4_GL456350_random", (0, 227966)),
        ("chr4_JH584292_random", (0, 14945)),
        ("chr4_JH584293_random", (0, 207968)),
        ("chr4_JH584294_random", (0, 191905)),
        ("chr4_JH584295_random", (0, 1976)),
        ("chr5_GL456354_random", (0, 195993)),
        ("chr5_JH584296_random", (0, 199368)),
        ("chr5_JH584297_random", (0, 205776)),
        ("chr5_JH584298_random", (0, 184189)),
        ("chr5_JH584299_random", (0, 953012)),
        ("chr7_GL456219_random", (0, 175968)),
        ("chrUn_GL456239", (0, 40056)),
        ("chrUn_GL456359", (0, 22974)),
        ("chrUn_GL456360", (0, 31704)),
        ("chrUn_GL456366", (0, 47073)),
        ("chrUn_GL456367", (0, 42057)),
        ("chrUn_GL456368", (0, 20208)),
        ("chrUn_GL456370", (0, 26764)),
        ("chrUn_GL456372", (0, 28664)),
        ("chrUn_GL456378", (0, 31602)),
        ("chrUn_GL456379", (0, 72385)),
        ("chrUn_GL456381", (0, 25871)),
        ("chrUn_GL456382", (0, 23158)),
        ("chrUn_GL456383", (0, 38659)),
        ("chrUn_GL456385", (0, 35240)),
        ("chrUn_GL456387", (0, 24685)),
        ("chrUn_GL456389", (0, 28772)),
        ("chrUn_GL456390", (0, 24668)),
        ("chrUn_GL456392", (0, 23629)),
        ("chrUn_GL456393", (0, 55711)),
        ("chrUn_GL456394", (0, 24323)),
        ("chrUn_GL456396", (0, 21240)),
        ("chrUn_JH584304", (0, 114452)),
        ("chrX_GL456233_random", (0, 336933)),
        ("chrY_JH584300_random", (0, 182347)),
        ("chrY_JH584301_random", (0, 259875)),
        ("chrY_JH584302_random", (0, 155838)),
        ("chrY_JH584303_random", (0, 158099)),
    )
)
mm10.default = OrderedDict()
for chrom, size in list(mm10.items()):
    if "_random" in chrom or "Un_" in chrom:
        continue
    mm10.default[chrom] = size

mm9 = OrderedDict(
    (
        ("chr1", (0, 197195432)),
        ("chr2", (0, 181748087)),
        ("chr3", (0, 159599783)),
        ("chr4", (0, 155630120)),
        ("chr5", (0, 152537259)),
        ("chr6", (0, 149517037)),
        ("chr7", (0, 152524553)),
        ("chr8", (0, 131738871)),
        ("chr9", (0, 124076172)),
        ("chr10", (0, 129993255)),
        ("chr11", (0, 121843856)),
        ("chr12", (0, 121257530)),
        ("chr13", (0, 120284312)),
        ("chr14", (0, 125194864)),
        ("chr15", (0, 103494974)),
        ("chr16", (0, 98319150)),
        ("chr17", (0, 95272651)),
        ("chr18", (0, 90772031)),
        ("chr19", (0, 61342430)),
        ("chrX", (0, 166650296)),
        ("chrY", (0, 15902555)),
        ("chrM", (0, 16299)),
        ("chr13_random", (0, 400311)),
        ("chr16_random", (0, 3994)),
        ("chr17_random", (0, 628739)),
        ("chr1_random", (0, 1231697)),
        ("chr3_random", (0, 41899)),
        ("chr4_random", (0, 160594)),
        ("chr5_random", (0, 357350)),
        ("chr7_random", (0, 362490)),
        ("chr8_random", (0, 849593)),
        ("chr9_random", (0, 449403)),
        ("chrUn_random", (0, 5900358)),
        ("chrX_random", (0, 1785075)),
        ("chrY_random", (0, 58682461)),
    )
)

mm9.default = OrderedDict()
for chrom, size in list(mm9.items()):
    if "_random" in chrom:
        continue
    if chrom == "chrM":
        continue
    mm9.default[chrom] = size


hg18 = OrderedDict(
    (
        ("chr1", (0, 247249719)),
        ("chr2", (0, 242951149)),
        ("chr3", (0, 199501827)),
        ("chr4", (0, 191273063)),
        ("chr5", (0, 180857866)),
        ("chr6", (0, 170899992)),
        ("chr7", (0, 158821424)),
        ("chr8", (0, 146274826)),
        ("chr9", (0, 140273252)),
        ("chr10", (0, 135374737)),
        ("chr11", (0, 134452384)),
        ("chr12", (0, 132349534)),
        ("chr13", (0, 114142980)),
        ("chr14", (0, 106368585)),
        ("chr15", (0, 100338915)),
        ("chr16", (0, 88827254)),
        ("chr17", (0, 78774742)),
        ("chr18", (0, 76117153)),
        ("chr19", (0, 63811651)),
        ("chr20", (0, 62435964)),
        ("chr21", (0, 46944323)),
        ("chr22", (0, 49691432)),
        ("chrX", (0, 154913754)),
        ("chrY", (0, 57772954)),
        ("chrM", (0, 16571)),
        ("chr10_random", (0, 113275)),
        ("chr11_random", (0, 215294)),
        ("chr13_random", (0, 186858)),
        ("chr15_random", (0, 784346)),
        ("chr16_random", (0, 105485)),
        ("chr17_random", (0, 2617613)),
        ("chr18_random", (0, 4262)),
        ("chr19_random", (0, 301858)),
        ("chr1_random", (0, 1663265)),
        ("chr21_random", (0, 1679693)),
        ("chr22_h2_hap1", (0, 63661)),
        ("chr22_random", (0, 257318)),
        ("chr2_random", (0, 185571)),
        ("chr3_random", (0, 749256)),
        ("chr4_random", (0, 842648)),
        ("chr5_h2_hap1", (0, 1794870)),
        ("chr5_random", (0, 143687)),
        ("chr6_cox_hap1", (0, 4731698)),
        ("chr6_qbl_hap2", (0, 4565931)),
        ("chr6_random", (0, 1875562)),
        ("chr7_random", (0, 549659)),
        ("chr8_random", (0, 943810)),
        ("chr9_random", (0, 1146434)),
        ("chrX_random", (0, 1719168)),
    )
)

hg18.default = OrderedDict()
for chrom, size in list(hg18.items()):
    if "_" in chrom:
        continue
    if chrom == "chrM":
        continue
    hg18.default[chrom] = size


hg19 = OrderedDict(
    (
        ("chr1", (0, 249250621)),
        ("chr2", (0, 243199373)),
        ("chr3", (0, 198022430)),
        ("chr4", (0, 191154276)),
        ("chr5", (0, 180915260)),
        ("chr6", (0, 171115067)),
        ("chr7", (0, 159138663)),
        ("chr8", (0, 146364022)),
        ("chr9", (0, 141213431)),
        ("chr10", (0, 135534747)),
        ("chr11", (0, 135006516)),
        ("chr12", (0, 133851895)),
        ("chr13", (0, 115169878)),
        ("chr14", (0, 107349540)),
        ("chr15", (0, 102531392)),
        ("chr16", (0, 90354753)),
        ("chr17", (0, 81195210)),
        ("chr18", (0, 78077248)),
        ("chr19", (0, 59128983)),
        ("chr20", (0, 63025520)),
        ("chr21", (0, 48129895)),
        ("chr22", (0, 51304566)),
        ("chrX", (0, 155270560)),
        ("chrY", (0, 59373566)),
        ("chrM", (0, 16571)),
        ("chr6_ssto_hap7", (0, 4928567)),
        ("chr6_mcf_hap5", (0, 4833398)),
        ("chr6_cox_hap2", (0, 4795371)),
        ("chr6_mann_hap4", (0, 4683263)),
        ("chr6_apd_hap1", (0, 4622290)),
        ("chr6_qbl_hap6", (0, 4611984)),
        ("chr6_dbb_hap3", (0, 4610396)),
        ("chr17_ctg5_hap1", (0, 1680828)),
        ("chr4_ctg9_hap1", (0, 590426)),
        ("chr1_gl000192_random", (0, 547496)),
        ("chrUn_gl000225", (0, 211173)),
        ("chr4_gl000194_random", (0, 191469)),
        ("chr4_gl000193_random", (0, 189789)),
        ("chr9_gl000200_random", (0, 187035)),
        ("chrUn_gl000222", (0, 186861)),
        ("chrUn_gl000212", (0, 186858)),
        ("chr7_gl000195_random", (0, 182896)),
        ("chrUn_gl000223", (0, 180455)),
        ("chrUn_gl000224", (0, 179693)),
        ("chrUn_gl000219", (0, 179198)),
        ("chr17_gl000205_random", (0, 174588)),
        ("chrUn_gl000215", (0, 172545)),
        ("chrUn_gl000216", (0, 172294)),
        ("chrUn_gl000217", (0, 172149)),
        ("chr9_gl000199_random", (0, 169874)),
        ("chrUn_gl000211", (0, 166566)),
        ("chrUn_gl000213", (0, 164239)),
        ("chrUn_gl000220", (0, 161802)),
        ("chrUn_gl000218", (0, 161147)),
        ("chr19_gl000209_random", (0, 159169)),
        ("chrUn_gl000221", (0, 155397)),
        ("chrUn_gl000214", (0, 137718)),
        ("chrUn_gl000228", (0, 129120)),
        ("chrUn_gl000227", (0, 128374)),
        ("chr1_gl000191_random", (0, 106433)),
        ("chr19_gl000208_random", (0, 92689)),
        ("chr9_gl000198_random", (0, 90085)),
        ("chr17_gl000204_random", (0, 81310)),
        ("chrUn_gl000233", (0, 45941)),
        ("chrUn_gl000237", (0, 45867)),
        ("chrUn_gl000230", (0, 43691)),
        ("chrUn_gl000242", (0, 43523)),
        ("chrUn_gl000243", (0, 43341)),
        ("chrUn_gl000241", (0, 42152)),
        ("chrUn_gl000236", (0, 41934)),
        ("chrUn_gl000240", (0, 41933)),
        ("chr17_gl000206_random", (0, 41001)),
        ("chrUn_gl000232", (0, 40652)),
        ("chrUn_gl000234", (0, 40531)),
        ("chr11_gl000202_random", (0, 40103)),
        ("chrUn_gl000238", (0, 39939)),
        ("chrUn_gl000244", (0, 39929)),
        ("chrUn_gl000248", (0, 39786)),
        ("chr8_gl000196_random", (0, 38914)),
        ("chrUn_gl000249", (0, 38502)),
        ("chrUn_gl000246", (0, 38154)),
        ("chr17_gl000203_random", (0, 37498)),
        ("chr8_gl000197_random", (0, 37175)),
        ("chrUn_gl000245", (0, 36651)),
        ("chrUn_gl000247", (0, 36422)),
        ("chr9_gl000201_random", (0, 36148)),
        ("chrUn_gl000235", (0, 34474)),
        ("chrUn_gl000239", (0, 33824)),
        ("chr21_gl000210_random", (0, 27682)),
        ("chrUn_gl000231", (0, 27386)),
        ("chrUn_gl000229", (0, 19913)),
        ("chrUn_gl000226", (0, 15008)),
        ("chr18_gl000207_random", (0, 4262)),
    )
)

hg19.default = OrderedDict()
for chrom, size in list(hg19.items()):
    if "_" in chrom:
        continue
    if chrom == "chrM":
        continue
    hg19.default[chrom] = size


hg38 = OrderedDict(
    (
        ("chr1", (0, 248956422)),
        ("chr2", (0, 242193529)),
        ("chr3", (0, 198295559)),
        ("chr4", (0, 190214555)),
        ("chr5", (0, 181538259)),
        ("chr6", (0, 170805979)),
        ("chr7", (0, 159345973)),
        ("chrX", (0, 156040895)),
        ("chr8", (0, 145138636)),
        ("chr9", (0, 138394717)),
        ("chr11", (0, 135086622)),
        ("chr10", (0, 133797422)),
        ("chr12", (0, 133275309)),
        ("chr13", (0, 114364328)),
        ("chr14", (0, 107043718)),
        ("chr15", (0, 101991189)),
        ("chr16", (0, 90338345)),
        ("chr17", (0, 83257441)),
        ("chr18", (0, 80373285)),
        ("chr20", (0, 64444167)),
        ("chr19", (0, 58617616)),
        ("chrY", (0, 57227415)),
        ("chr22", (0, 50818468)),
        ("chr21", (0, 46709983)),
        ("chr15_KI270905v1_alt", (0, 5161414)),
        ("chr6_GL000256v2_alt", (0, 4929269)),
        ("chr6_GL000254v2_alt", (0, 4827813)),
        ("chr6_GL000251v2_alt", (0, 4795265)),
        ("chr6_GL000253v2_alt", (0, 4677643)),
        ("chr6_GL000250v2_alt", (0, 4672374)),
        ("chr6_GL000255v2_alt", (0, 4606388)),
        ("chr6_GL000252v2_alt", (0, 4604811)),
        ("chr17_KI270857v1_alt", (0, 2877074)),
        ("chr16_KI270853v1_alt", (0, 2659700)),
        ("chr16_KI270728v1_random", (0, 1872759)),
        ("chr17_GL000258v2_alt", (0, 1821992)),
        ("chr5_GL339449v2_alt", (0, 1612928)),
        ("chr14_KI270847v1_alt", (0, 1511111)),
        ("chr17_KI270908v1_alt", (0, 1423190)),
        ("chr14_KI270846v1_alt", (0, 1351393)),
        ("chr5_KI270897v1_alt", (0, 1144418)),
        ("chr7_KI270803v1_alt", (0, 1111570)),
        ("chr19_GL949749v2_alt", (0, 1091841)),
        ("chr19_KI270938v1_alt", (0, 1066800)),
        ("chr19_GL949750v2_alt", (0, 1066390)),
        ("chr19_GL949748v2_alt", (0, 1064304)),
        ("chr19_GL949751v2_alt", (0, 1002683)),
        ("chr19_GL949746v1_alt", (0, 987716)),
        ("chr19_GL949752v1_alt", (0, 987100)),
        ("chr8_KI270821v1_alt", (0, 985506)),
        ("chr1_KI270763v1_alt", (0, 911658)),
        ("chr6_KI270801v1_alt", (0, 870480)),
        ("chr19_GL949753v2_alt", (0, 796479)),
        ("chr19_GL949747v2_alt", (0, 729520)),
        ("chr8_KI270822v1_alt", (0, 624492)),
        ("chr4_GL000257v2_alt", (0, 586476)),
        ("chr12_KI270904v1_alt", (0, 572349)),
        ("chr4_KI270925v1_alt", (0, 555799)),
        ("chr15_KI270852v1_alt", (0, 478999)),
        ("chr15_KI270727v1_random", (0, 448248)),
        ("chr9_KI270823v1_alt", (0, 439082)),
        ("chr15_KI270850v1_alt", (0, 430880)),
        ("chr1_KI270759v1_alt", (0, 425601)),
        ("chr12_GL877876v1_alt", (0, 408271)),
        ("chrUn_KI270442v1", (0, 392061)),
        ("chr17_KI270862v1_alt", (0, 391357)),
        ("chr15_GL383555v2_alt", (0, 388773)),
        ("chr19_GL383573v1_alt", (0, 385657)),
        ("chr4_KI270896v1_alt", (0, 378547)),
        ("chr4_GL383528v1_alt", (0, 376187)),
        ("chr17_GL383563v3_alt", (0, 375691)),
        ("chr8_KI270810v1_alt", (0, 374415)),
        ("chr1_GL383520v2_alt", (0, 366580)),
        ("chr1_KI270762v1_alt", (0, 354444)),
        ("chr15_KI270848v1_alt", (0, 327382)),
        ("chr17_KI270909v1_alt", (0, 325800)),
        ("chr14_KI270844v1_alt", (0, 322166)),
        ("chr8_KI270900v1_alt", (0, 318687)),
        ("chr10_GL383546v1_alt", (0, 309802)),
        ("chr13_KI270838v1_alt", (0, 306913)),
        ("chr8_KI270816v1_alt", (0, 305841)),
        ("chr22_KI270879v1_alt", (0, 304135)),
        ("chr8_KI270813v1_alt", (0, 300230)),
        ("chr11_KI270831v1_alt", (0, 296895)),
        ("chr15_GL383554v1_alt", (0, 296527)),
        ("chr8_KI270811v1_alt", (0, 292436)),
        ("chr18_GL383567v1_alt", (0, 289831)),
        ("chrX_KI270880v1_alt", (0, 284869)),
        ("chr8_KI270812v1_alt", (0, 282736)),
        ("chr19_KI270921v1_alt", (0, 282224)),
        ("chr17_KI270729v1_random", (0, 280839)),
        ("chr17_JH159146v1_alt", (0, 278131)),
        ("chrX_KI270913v1_alt", (0, 274009)),
        ("chr6_KI270798v1_alt", (0, 271782)),
        ("chr7_KI270808v1_alt", (0, 271455)),
        ("chr22_KI270876v1_alt", (0, 263666)),
        ("chr15_KI270851v1_alt", (0, 263054)),
        ("chr22_KI270875v1_alt", (0, 259914)),
        ("chr1_KI270766v1_alt", (0, 256271)),
        ("chr19_KI270882v1_alt", (0, 248807)),
        ("chr3_KI270778v1_alt", (0, 248252)),
        ("chr15_KI270849v1_alt", (0, 244917)),
        ("chr4_KI270786v1_alt", (0, 244096)),
        ("chr12_KI270835v1_alt", (0, 238139)),
        ("chr17_KI270858v1_alt", (0, 235827)),
        ("chr19_KI270867v1_alt", (0, 233762)),
        ("chr16_KI270855v1_alt", (0, 232857)),
        ("chr8_KI270926v1_alt", (0, 229282)),
        ("chr5_GL949742v1_alt", (0, 226852)),
        ("chr3_KI270780v1_alt", (0, 224108)),
        ("chr17_GL383565v1_alt", (0, 223995)),
        ("chr2_KI270774v1_alt", (0, 223625)),
        ("chr4_KI270790v1_alt", (0, 220246)),
        ("chr11_KI270927v1_alt", (0, 218612)),
        ("chr19_KI270932v1_alt", (0, 215732)),
        ("chr11_KI270903v1_alt", (0, 214625)),
        ("chr2_KI270894v1_alt", (0, 214158)),
        ("chr14_GL000225v1_random", (0, 211173)),
        ("chrUn_KI270743v1", (0, 210658)),
        ("chr11_KI270832v1_alt", (0, 210133)),
        ("chr7_KI270805v1_alt", (0, 209988)),
        ("chr4_GL000008v2_random", (0, 209709)),
        ("chr7_KI270809v1_alt", (0, 209586)),
        ("chr19_KI270887v1_alt", (0, 209512)),
        ("chr4_KI270789v1_alt", (0, 205944)),
        ("chr3_KI270779v1_alt", (0, 205312)),
        ("chr19_KI270914v1_alt", (0, 205194)),
        ("chr19_KI270886v1_alt", (0, 204239)),
        ("chr11_KI270829v1_alt", (0, 204059)),
        ("chr14_GL000009v2_random", (0, 201709)),
        ("chr21_GL383579v2_alt", (0, 201197)),
        ("chr11_JH159136v1_alt", (0, 200998)),
        ("chr19_KI270930v1_alt", (0, 200773)),
        ("chrUn_KI270747v1", (0, 198735)),
        ("chr18_GL383571v1_alt", (0, 198278)),
        ("chr19_KI270920v1_alt", (0, 198005)),
        ("chr6_KI270797v1_alt", (0, 197536)),
        ("chr3_KI270935v1_alt", (0, 197351)),
        ("chr17_KI270861v1_alt", (0, 196688)),
        ("chr15_KI270906v1_alt", (0, 196384)),
        ("chr5_KI270791v1_alt", (0, 195710)),
        ("chr14_KI270722v1_random", (0, 194050)),
        ("chr16_GL383556v1_alt", (0, 192462)),
        ("chr13_KI270840v1_alt", (0, 191684)),
        ("chr14_GL000194v1_random", (0, 191469)),
        ("chr11_JH159137v1_alt", (0, 191409)),
        ("chr19_KI270917v1_alt", (0, 190932)),
        ("chr7_KI270899v1_alt", (0, 190869)),
        ("chr19_KI270923v1_alt", (0, 189352)),
        ("chr10_KI270825v1_alt", (0, 188315)),
        ("chr19_GL383576v1_alt", (0, 188024)),
        ("chr19_KI270922v1_alt", (0, 187935)),
        ("chrUn_KI270742v1", (0, 186739)),
        ("chr22_KI270878v1_alt", (0, 186262)),
        ("chr19_KI270929v1_alt", (0, 186203)),
        ("chr11_KI270826v1_alt", (0, 186169)),
        ("chr6_KB021644v2_alt", (0, 185823)),
        ("chr17_GL000205v2_random", (0, 185591)),
        ("chr1_KI270765v1_alt", (0, 185285)),
        ("chr19_KI270916v1_alt", (0, 184516)),
        ("chr19_KI270890v1_alt", (0, 184499)),
        ("chr3_KI270784v1_alt", (0, 184404)),
        ("chr12_GL383551v1_alt", (0, 184319)),
        ("chr20_KI270870v1_alt", (0, 183433)),
        ("chrUn_GL000195v1", (0, 182896)),
        ("chr1_GL383518v1_alt", (0, 182439)),
        ("chr22_KI270736v1_random", (0, 181920)),
        ("chr10_KI270824v1_alt", (0, 181496)),
        ("chr14_KI270845v1_alt", (0, 180703)),
        ("chr3_GL383526v1_alt", (0, 180671)),
        ("chr13_KI270839v1_alt", (0, 180306)),
        ("chr22_KI270733v1_random", (0, 179772)),
        ("chrUn_GL000224v1", (0, 179693)),
        ("chr10_GL383545v1_alt", (0, 179254)),
        ("chrUn_GL000219v1", (0, 179198)),
        ("chr5_KI270792v1_alt", (0, 179043)),
        ("chr17_KI270860v1_alt", (0, 178921)),
        ("chr19_GL000209v2_alt", (0, 177381)),
        ("chr11_KI270830v1_alt", (0, 177092)),
        ("chr9_KI270719v1_random", (0, 176845)),
        ("chrUn_GL000216v2", (0, 176608)),
        ("chr22_KI270928v1_alt", (0, 176103)),
        ("chr1_KI270712v1_random", (0, 176043)),
        ("chr6_KI270800v1_alt", (0, 175808)),
        ("chr1_KI270706v1_random", (0, 175055)),
        ("chr2_KI270776v1_alt", (0, 174166)),
        ("chr18_KI270912v1_alt", (0, 174061)),
        ("chr3_KI270777v1_alt", (0, 173649)),
        ("chr5_GL383531v1_alt", (0, 173459)),
        ("chr3_JH636055v2_alt", (0, 173151)),
        ("chr14_KI270725v1_random", (0, 172810)),
        ("chr5_KI270796v1_alt", (0, 172708)),
        ("chr9_GL383541v1_alt", (0, 171286)),
        ("chr19_KI270885v1_alt", (0, 171027)),
        ("chr19_KI270919v1_alt", (0, 170701)),
        ("chr19_KI270889v1_alt", (0, 170698)),
        ("chr19_KI270891v1_alt", (0, 170680)),
        ("chr19_KI270915v1_alt", (0, 170665)),
        ("chr19_KI270933v1_alt", (0, 170537)),
        ("chr19_KI270883v1_alt", (0, 170399)),
        ("chr19_GL383575v2_alt", (0, 170222)),
        ("chr19_KI270931v1_alt", (0, 170148)),
        ("chr12_GL383550v2_alt", (0, 169178)),
        ("chr13_KI270841v1_alt", (0, 169134)),
        ("chrUn_KI270744v1", (0, 168472)),
        ("chr18_KI270863v1_alt", (0, 167999)),
        ("chr18_GL383569v1_alt", (0, 167950)),
        ("chr12_GL877875v1_alt", (0, 167313)),
        ("chr21_KI270874v1_alt", (0, 166743)),
        ("chr3_KI270924v1_alt", (0, 166540)),
        ("chr1_KI270761v1_alt", (0, 165834)),
        ("chr3_KI270937v1_alt", (0, 165607)),
        ("chr22_KI270734v1_random", (0, 165050)),
        ("chr18_GL383570v1_alt", (0, 164789)),
        ("chr5_KI270794v1_alt", (0, 164558)),
        ("chr4_GL383527v1_alt", (0, 164536)),
        ("chrUn_GL000213v1", (0, 164239)),
        ("chr3_KI270936v1_alt", (0, 164170)),
        ("chr3_KI270934v1_alt", (0, 163458)),
        ("chr9_GL383539v1_alt", (0, 162988)),
        ("chr3_KI270895v1_alt", (0, 162896)),
        ("chr22_GL383582v2_alt", (0, 162811)),
        ("chr3_KI270782v1_alt", (0, 162429)),
        ("chr1_KI270892v1_alt", (0, 162212)),
        ("chrUn_GL000220v1", (0, 161802)),
        ("chr2_KI270767v1_alt", (0, 161578)),
        ("chr2_KI270715v1_random", (0, 161471)),
        ("chr2_KI270893v1_alt", (0, 161218)),
        ("chrUn_GL000218v1", (0, 161147)),
        ("chr18_GL383572v1_alt", (0, 159547)),
        ("chr8_KI270817v1_alt", (0, 158983)),
        ("chr4_KI270788v1_alt", (0, 158965)),
        ("chrUn_KI270749v1", (0, 158759)),
        ("chr7_KI270806v1_alt", (0, 158166)),
        ("chr7_KI270804v1_alt", (0, 157952)),
        ("chr18_KI270911v1_alt", (0, 157710)),
        ("chrUn_KI270741v1", (0, 157432)),
        ("chr17_KI270910v1_alt", (0, 157099)),
        ("chr19_KI270884v1_alt", (0, 157053)),
        ("chr19_GL383574v1_alt", (0, 155864)),
        ("chr19_KI270888v1_alt", (0, 155532)),
        ("chr3_GL000221v1_random", (0, 155397)),
        ("chr11_GL383547v1_alt", (0, 154407)),
        ("chr2_KI270716v1_random", (0, 153799)),
        ("chr12_GL383553v2_alt", (0, 152874)),
        ("chr6_KI270799v1_alt", (0, 152148)),
        ("chr22_KI270731v1_random", (0, 150754)),
        ("chrUn_KI270751v1", (0, 150742)),
        ("chrUn_KI270750v1", (0, 148850)),
        ("chr8_KI270818v1_alt", (0, 145606)),
        ("chrX_KI270881v1_alt", (0, 144206)),
        ("chr21_KI270873v1_alt", (0, 143900)),
        ("chr2_GL383521v1_alt", (0, 143390)),
        ("chr8_KI270814v1_alt", (0, 141812)),
        ("chr12_GL383552v1_alt", (0, 138655)),
        ("chrUn_KI270519v1", (0, 138126)),
        ("chr2_KI270775v1_alt", (0, 138019)),
        ("chr17_KI270907v1_alt", (0, 137721)),
        ("chrUn_GL000214v1", (0, 137718)),
        ("chr8_KI270901v1_alt", (0, 136959)),
        ("chr2_KI270770v1_alt", (0, 136240)),
        ("chr16_KI270854v1_alt", (0, 134193)),
        ("chr8_KI270819v1_alt", (0, 133535)),
        ("chr17_GL383564v2_alt", (0, 133151)),
        ("chr2_KI270772v1_alt", (0, 133041)),
        ("chr8_KI270815v1_alt", (0, 132244)),
        ("chr5_KI270795v1_alt", (0, 131892)),
        ("chr5_KI270898v1_alt", (0, 130957)),
        ("chr20_GL383577v2_alt", (0, 128386)),
        ("chr1_KI270708v1_random", (0, 127682)),
        ("chr7_KI270807v1_alt", (0, 126434)),
        ("chr5_KI270793v1_alt", (0, 126136)),
        ("chr6_GL383533v1_alt", (0, 124736)),
        ("chr2_GL383522v1_alt", (0, 123821)),
        ("chr19_KI270918v1_alt", (0, 123111)),
        ("chr12_GL383549v1_alt", (0, 120804)),
        ("chr2_KI270769v1_alt", (0, 120616)),
        ("chr4_KI270785v1_alt", (0, 119912)),
        ("chr12_KI270834v1_alt", (0, 119498)),
        ("chr7_GL383534v2_alt", (0, 119183)),
        ("chr20_KI270869v1_alt", (0, 118774)),
        ("chr21_GL383581v2_alt", (0, 116689)),
        ("chr3_KI270781v1_alt", (0, 113034)),
        ("chr17_KI270730v1_random", (0, 112551)),
        ("chrUn_KI270438v1", (0, 112505)),
        ("chr4_KI270787v1_alt", (0, 111943)),
        ("chr18_KI270864v1_alt", (0, 111737)),
        ("chr2_KI270771v1_alt", (0, 110395)),
        ("chr1_GL383519v1_alt", (0, 110268)),
        ("chr2_KI270768v1_alt", (0, 110099)),
        ("chr1_KI270760v1_alt", (0, 109528)),
        ("chr3_KI270783v1_alt", (0, 109187)),
        ("chr17_KI270859v1_alt", (0, 108763)),
        ("chr11_KI270902v1_alt", (0, 106711)),
        ("chr18_GL383568v1_alt", (0, 104552)),
        ("chr22_KI270737v1_random", (0, 103838)),
        ("chr13_KI270843v1_alt", (0, 103832)),
        ("chr22_KI270877v1_alt", (0, 101331)),
        ("chr5_GL383530v1_alt", (0, 101241)),
        ("chr11_KI270721v1_random", (0, 100316)),
        ("chr22_KI270738v1_random", (0, 99375)),
        ("chr22_GL383583v2_alt", (0, 96924)),
        ("chr2_GL582966v2_alt", (0, 96131)),
        ("chrUn_KI270748v1", (0, 93321)),
        ("chrUn_KI270435v1", (0, 92983)),
        ("chr5_GL000208v1_random", (0, 92689)),
        ("chrUn_KI270538v1", (0, 91309)),
        ("chr17_GL383566v1_alt", (0, 90219)),
        ("chr16_GL383557v1_alt", (0, 89672)),
        ("chr17_JH159148v1_alt", (0, 88070)),
        ("chr5_GL383532v1_alt", (0, 82728)),
        ("chr21_KI270872v1_alt", (0, 82692)),
        ("chrUn_KI270756v1", (0, 79590)),
        ("chr6_KI270758v1_alt", (0, 76752)),
        ("chr12_KI270833v1_alt", (0, 76061)),
        ("chr6_KI270802v1_alt", (0, 75005)),
        ("chr21_GL383580v2_alt", (0, 74653)),
        ("chr22_KB663609v1_alt", (0, 74013)),
        ("chr22_KI270739v1_random", (0, 73985)),
        ("chr9_GL383540v1_alt", (0, 71551)),
        ("chrUn_KI270757v1", (0, 71251)),
        ("chr2_KI270773v1_alt", (0, 70887)),
        ("chr17_JH159147v1_alt", (0, 70345)),
        ("chr11_KI270827v1_alt", (0, 67707)),
        ("chr1_KI270709v1_random", (0, 66860)),
        ("chrUn_KI270746v1", (0, 66486)),
        ("chr16_KI270856v1_alt", (0, 63982)),
        ("chr21_GL383578v2_alt", (0, 63917)),
        ("chrUn_KI270753v1", (0, 62944)),
        ("chr19_KI270868v1_alt", (0, 61734)),
        ("chr9_GL383542v1_alt", (0, 60032)),
        ("chr20_KI270871v1_alt", (0, 58661)),
        ("chr12_KI270836v1_alt", (0, 56134)),
        ("chr19_KI270865v1_alt", (0, 52969)),
        ("chr1_KI270764v1_alt", (0, 50258)),
        ("chrUn_KI270589v1", (0, 44474)),
        ("chr14_KI270726v1_random", (0, 43739)),
        ("chr19_KI270866v1_alt", (0, 43156)),
        ("chr22_KI270735v1_random", (0, 42811)),
        ("chr1_KI270711v1_random", (0, 42210)),
        ("chrUn_KI270745v1", (0, 41891)),
        ("chr1_KI270714v1_random", (0, 41717)),
        ("chr22_KI270732v1_random", (0, 41543)),
        ("chr1_KI270713v1_random", (0, 40745)),
        ("chrUn_KI270754v1", (0, 40191)),
        ("chr1_KI270710v1_random", (0, 40176)),
        ("chr12_KI270837v1_alt", (0, 40090)),
        ("chr9_KI270717v1_random", (0, 40062)),
        ("chr14_KI270724v1_random", (0, 39555)),
        ("chr9_KI270720v1_random", (0, 39050)),
        ("chr14_KI270723v1_random", (0, 38115)),
        ("chr9_KI270718v1_random", (0, 38054)),
        ("chrUn_KI270317v1", (0, 37690)),
        ("chr13_KI270842v1_alt", (0, 37287)),
        ("chrY_KI270740v1_random", (0, 37240)),
        ("chrUn_KI270755v1", (0, 36723)),
        ("chr8_KI270820v1_alt", (0, 36640)),
        ("chr1_KI270707v1_random", (0, 32032)),
        ("chrUn_KI270579v1", (0, 31033)),
        ("chrUn_KI270752v1", (0, 27745)),
        ("chrUn_KI270512v1", (0, 22689)),
        ("chrUn_KI270322v1", (0, 21476)),
        ("chrM", (0, 16569)),
        ("chrUn_GL000226v1", (0, 15008)),
        ("chrUn_KI270311v1", (0, 12399)),
        ("chrUn_KI270366v1", (0, 8320)),
        ("chrUn_KI270511v1", (0, 8127)),
        ("chrUn_KI270448v1", (0, 7992)),
        ("chrUn_KI270521v1", (0, 7642)),
        ("chrUn_KI270581v1", (0, 7046)),
        ("chrUn_KI270582v1", (0, 6504)),
        ("chrUn_KI270515v1", (0, 6361)),
        ("chrUn_KI270588v1", (0, 6158)),
        ("chrUn_KI270591v1", (0, 5796)),
        ("chrUn_KI270522v1", (0, 5674)),
        ("chrUn_KI270507v1", (0, 5353)),
        ("chrUn_KI270590v1", (0, 4685)),
        ("chrUn_KI270584v1", (0, 4513)),
        ("chrUn_KI270320v1", (0, 4416)),
        ("chrUn_KI270382v1", (0, 4215)),
        ("chrUn_KI270468v1", (0, 4055)),
        ("chrUn_KI270467v1", (0, 3920)),
        ("chrUn_KI270362v1", (0, 3530)),
        ("chrUn_KI270517v1", (0, 3253)),
        ("chrUn_KI270593v1", (0, 3041)),
        ("chrUn_KI270528v1", (0, 2983)),
        ("chrUn_KI270587v1", (0, 2969)),
        ("chrUn_KI270364v1", (0, 2855)),
        ("chrUn_KI270371v1", (0, 2805)),
        ("chrUn_KI270333v1", (0, 2699)),
        ("chrUn_KI270374v1", (0, 2656)),
        ("chrUn_KI270411v1", (0, 2646)),
        ("chrUn_KI270414v1", (0, 2489)),
        ("chrUn_KI270510v1", (0, 2415)),
        ("chrUn_KI270390v1", (0, 2387)),
        ("chrUn_KI270375v1", (0, 2378)),
        ("chrUn_KI270420v1", (0, 2321)),
        ("chrUn_KI270509v1", (0, 2318)),
        ("chrUn_KI270315v1", (0, 2276)),
        ("chrUn_KI270302v1", (0, 2274)),
        ("chrUn_KI270518v1", (0, 2186)),
        ("chrUn_KI270530v1", (0, 2168)),
        ("chrUn_KI270304v1", (0, 2165)),
        ("chrUn_KI270418v1", (0, 2145)),
        ("chrUn_KI270424v1", (0, 2140)),
        ("chrUn_KI270417v1", (0, 2043)),
        ("chrUn_KI270508v1", (0, 1951)),
        ("chrUn_KI270303v1", (0, 1942)),
        ("chrUn_KI270381v1", (0, 1930)),
        ("chrUn_KI270529v1", (0, 1899)),
        ("chrUn_KI270425v1", (0, 1884)),
        ("chrUn_KI270396v1", (0, 1880)),
        ("chrUn_KI270363v1", (0, 1803)),
        ("chrUn_KI270386v1", (0, 1788)),
        ("chrUn_KI270465v1", (0, 1774)),
        ("chrUn_KI270383v1", (0, 1750)),
        ("chrUn_KI270384v1", (0, 1658)),
        ("chrUn_KI270330v1", (0, 1652)),
        ("chrUn_KI270372v1", (0, 1650)),
        ("chrUn_KI270548v1", (0, 1599)),
        ("chrUn_KI270580v1", (0, 1553)),
        ("chrUn_KI270387v1", (0, 1537)),
        ("chrUn_KI270391v1", (0, 1484)),
        ("chrUn_KI270305v1", (0, 1472)),
        ("chrUn_KI270373v1", (0, 1451)),
        ("chrUn_KI270422v1", (0, 1445)),
        ("chrUn_KI270316v1", (0, 1444)),
        ("chrUn_KI270338v1", (0, 1428)),
        ("chrUn_KI270340v1", (0, 1428)),
        ("chrUn_KI270583v1", (0, 1400)),
        ("chrUn_KI270334v1", (0, 1368)),
        ("chrUn_KI270429v1", (0, 1361)),
        ("chrUn_KI270393v1", (0, 1308)),
        ("chrUn_KI270516v1", (0, 1300)),
        ("chrUn_KI270389v1", (0, 1298)),
        ("chrUn_KI270466v1", (0, 1233)),
        ("chrUn_KI270388v1", (0, 1216)),
        ("chrUn_KI270544v1", (0, 1202)),
        ("chrUn_KI270310v1", (0, 1201)),
        ("chrUn_KI270412v1", (0, 1179)),
        ("chrUn_KI270395v1", (0, 1143)),
        ("chrUn_KI270376v1", (0, 1136)),
        ("chrUn_KI270337v1", (0, 1121)),
        ("chrUn_KI270335v1", (0, 1048)),
        ("chrUn_KI270378v1", (0, 1048)),
        ("chrUn_KI270379v1", (0, 1045)),
        ("chrUn_KI270329v1", (0, 1040)),
        ("chrUn_KI270419v1", (0, 1029)),
        ("chrUn_KI270336v1", (0, 1026)),
        ("chrUn_KI270312v1", (0, 998)),
        ("chrUn_KI270539v1", (0, 993)),
        ("chrUn_KI270385v1", (0, 990)),
        ("chrUn_KI270423v1", (0, 981)),
        ("chrUn_KI270392v1", (0, 971)),
        ("chrUn_KI270394v1", (0, 970)),
    )
)

hg38.default = OrderedDict()
for chrom, size in hg38.items():
    if "_" in chrom:
        continue
    if chrom == "chrM":
        continue
    hg38.default[chrom] = size
