# Copyright (c) 2025 Thomas Goirand
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
# implied.
# See the License for the specific language governing permissions and
# limitations under the License.

try:
    from unittest import mock
except ImportError:
    import mock
import testtools

from keystoneauth1 import fixture as ksa_fixture
from osc_lib import shell
from osc_lib.tests import utils


class FakeApp(object):
    def __init__(self):
        self.client_manager = None


class TestCase(testtools.TestCase):
    """Test case base class for all unit tests."""

    def setUp(self):
        super(TestCase, self).setUp()
        self.app = FakeApp()
        self.shell = shell.OpenStackShell()


class TestCommand(TestCase):
    """Test case base class for command tests."""

    def setUp(self):
        super(TestCommand, self).setUp()
        self.app = mock.Mock()
        self.app.client_manager = mock.Mock()
        self.app.client_manager.vmms = mock.Mock()
