Copyright (C) 2007 Sebastien Guillot

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License

as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of

MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software

Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.


#ifndef FormMain_H
#define FormMain_H

#include <QMainWindow>
#include <QBasicTimer>
#include <QDomDocument>
#include <QTableWidget>
#include <QProgressBar>
#include <QPushButton>
#include <QHttp>
#include <QTextBrowser>

#ifdef Q_OS_MAC
#include "ui_main.h"
#endif
#ifdef Q_OS_WIN32
#include "ui_main.h"
#endif
#ifdef Q_OS_LINUX
#include "ui_main_nux.h"
#endif



class MainForm: public QMainWindow, private Ui::MainWindow
{
	Q_OBJECT

	public:
		MainForm();	//Constructeur de la classe MainForm
		void setNomfic(QString Nomfic);
	private:
		QString id;
		QString pass;
		QString id_session;
		QString idt;
		QBasicTimer timer;	// Timer Gnral
		QBasicTimer timerReload;
		QToolBar *MainToolBar;
		QDomDocument AdBook;
		QTableWidget *twBook;
		QLineEdit *leNom;
		QLineEdit *leNumero;
		QProgressBar *bar;
		//QHttp http("adsl.free.fr",80);
		QHttp http;
		QPushButton *AnnulEnvoi;
		bool EnvoiAnnule;
		bool getid(QString *id_session,QString *idt,QString *ErrorId);
		bool endRequest;	// Indique la fin de requte http
		bool errorRequest;	// Indique une erreur de requte Http
		bool timeout;	// Indique un Timeout lors de l'interrogation http
		void AfficheImage();
		void LectureCarnet();
		void SauverCarnet();
		void toggleControls(bool etat);
		void verif_maj();

	private slots:	
		void on_actionQuitter_triggered();
		void on_actionEffacer_les_identifiants_triggered();
		void on_actionChanger_les_Identifiants_triggered();
		void on_actionModifier_les_informations_de_votre_ligne_fax_triggered();
		void on_actionRecherche_automatique_des_mises_jour_triggered();
		void on_actionA_propos_de_triggered();
		void on_btnEnvoyer_clicked();
		void on_BtnRafraichir_clicked();
		void on_BtnParcourir_clicked();
		void on_BtnCarnet_clicked();
		bool ChangerIdentifants();	// Affiche la boite de changement des identifiants	
		void finClientHttp(bool error);
		void timerEvent(QTimerEvent *event);
		void dataSendProgress ( int done, int total );
		void dataUploadProgress ( int done, int total );
		void cellChanged ( int ligne, int colonne);
		void AjouterDestinataire();
		void AnnulerEnvoi();
		void requestFinished ( int id, bool error );
	protected:
		void dragEnterEvent(QDragEnterEvent *event);
		void dragMoveEvent(QDragMoveEvent *event);
		void dragLeaveEvent(QDragLeaveEvent *event);
		void dropEvent(QDropEvent *event);
		
};


#endif
