/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.haha.guava.collect;

import com.squareup.haha.guava.base.Ascii;
import com.squareup.haha.guava.collect.ImmutableList;
import com.squareup.haha.guava.collect.Iterators;
import com.squareup.haha.guava.collect.UnmodifiableIterator;
import java.util.List;
import javax.annotation.Nullable;

final class SingletonImmutableList<E>
extends ImmutableList<E> {
    private transient E element;

    SingletonImmutableList(E element) {
        this.element = Ascii.checkNotNull(element);
    }

    @Override
    public final E get(int index) {
        Ascii.checkElementIndex(index, 1);
        return this.element;
    }

    @Override
    public final int indexOf(@Nullable Object object) {
        if (this.element.equals(object)) {
            return 0;
        }
        return -1;
    }

    @Override
    public final UnmodifiableIterator<E> iterator() {
        return Iterators.singletonIterator(this.element);
    }

    @Override
    public final int lastIndexOf(@Nullable Object object) {
        return this.indexOf(object);
    }

    @Override
    public final int size() {
        return 1;
    }

    @Override
    public final ImmutableList<E> subList(int fromIndex, int toIndex) {
        Ascii.checkPositionIndexes(fromIndex, toIndex, 1);
        if (fromIndex == toIndex) {
            return ImmutableList.EMPTY;
        }
        return this;
    }

    @Override
    public final ImmutableList<E> reverse() {
        return this;
    }

    @Override
    public final boolean contains(@Nullable Object object) {
        return this.element.equals(object);
    }

    @Override
    public final boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof List) {
            List that = (List)object;
            return that.size() == 1 && this.element.equals(that.get(0));
        }
        return false;
    }

    @Override
    public final int hashCode() {
        return 31 + this.element.hashCode();
    }

    @Override
    public final String toString() {
        String elementToString = this.element.toString();
        return new StringBuilder(elementToString.length() + 2).append('[').append(elementToString).append(']').toString();
    }

    @Override
    public final boolean isEmpty() {
        return false;
    }

    @Override
    final boolean isPartialView() {
        return false;
    }

    @Override
    final int copyIntoArray(Object[] dst, int offset) {
        dst[offset] = this.element;
        return offset + 1;
    }
}

