// Copyright 2017 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
// Protocol Buffer 2 Copyright 2008 Google Inc.
// All other code copyright its respective owners.

/**
 * @fileoverview Generated Protocol Buffer code for file
 * third_party/sketchology/proto/sengine.proto.
 * Generated by //net/proto2/compiler/public:protocol_compiler.
 * @suppress {messageConventions} 
 */

goog.provide('sketchology.proto.Command');
goog.provide('sketchology.proto.CommandList');
goog.provide('sketchology.proto.NoArgCommand');
goog.provide('sketchology.proto.ReplaceElementsCommand');
goog.provide('sketchology.proto.EvictImageData');
goog.provide('sketchology.proto.Viewport');
goog.provide('sketchology.proto.ImageExport');
goog.provide('sketchology.proto.LinearPathAnimation');
goog.provide('sketchology.proto.LineSize');
goog.provide('sketchology.proto.LineSize.SizeType');
goog.provide('sketchology.proto.PusherToolParams');
goog.provide('sketchology.proto.ToolParams');
goog.provide('sketchology.proto.ToolParams.ToolType');
goog.provide('sketchology.proto.FlagAssignment');
goog.provide('sketchology.proto.AddElement');
goog.provide('sketchology.proto.OutOfBoundsColor');
goog.provide('sketchology.proto.SInputStream');
goog.provide('sketchology.proto.SInput');
goog.provide('sketchology.proto.SInput.InputType');
goog.provide('sketchology.proto.SimulatedInput');
goog.provide('sketchology.proto.SequencePoint');
goog.provide('sketchology.proto.SetCallbackFlags');
goog.provide('sketchology.proto.EngineState');
goog.provide('sketchology.proto.CameraBoundsConfig');
goog.provide('sketchology.proto.ImageInfo');
goog.provide('sketchology.proto.ImageInfo.AssetType');
goog.provide('sketchology.proto.ImageRect');
goog.provide('sketchology.proto.GridInfo');
goog.provide('sketchology.proto.CreateDocument');
goog.provide('sketchology.proto.AddPath');
goog.provide('sketchology.proto.PusherPositionUpdate');
goog.provide('sketchology.proto.ElementQueryData');
goog.provide('sketchology.proto.ElementQueryItem');
goog.provide('sketchology.proto.SelectionState');
goog.provide('sketchology.proto.ToolEvent');
goog.provide('sketchology.proto.RenderingStrategy');
goog.provide('sketchology.proto.BrushType');
goog.provide('sketchology.proto.Flag');
goog.provide('sketchology.proto.DocumentType');
goog.provide('sketchology.proto.StorageType');

goog.require('goog.proto2.Message');
goog.require('sketchology.proto.BackgroundColor');
goog.require('sketchology.proto.BackgroundImageInfo');
goog.require('sketchology.proto.Border');
goog.require('sketchology.proto.CallbackFlags');
goog.require('sketchology.proto.ElementAnimation');
goog.require('sketchology.proto.ElementAttributes');
goog.require('sketchology.proto.ElementBundle');
goog.require('sketchology.proto.ElementMutation');
goog.require('sketchology.proto.Path');
goog.require('sketchology.proto.Point');
goog.require('sketchology.proto.Rect');
goog.require('sketchology.proto.Snapshot');
goog.require('sketchology.proto.SourceDetails');


/**
 * Enumeration RenderingStrategy.
 * @enum {number}
 */
sketchology.proto.RenderingStrategy = {
  UNKNOWN_RENDERER: 0,
  BUFFERED_RENDERER: 1,
  DIRECT_RENDERER: 2
};


/**
 * Enumeration BrushType.
 * @enum {number}
 */
sketchology.proto.BrushType = {
  UNKNOWN_BRUSH: 0,
  CALLIGRAPHY: 1,
  INKPEN: 2,
  MARKER: 3,
  BALLPOINT: 4,
  PENCIL: 5,
  ERASER: 6,
  AIRBRUSH: 7,
  HIGHLIGHTER: 8,
  GRADIENT: 9,
  CHISEL: 10,
  BALLPOINT_IN_PEN_MODE_ELSE_MARKER: 11
};


/**
 * Enumeration Flag.
 * @enum {number}
 */
sketchology.proto.Flag = {
  UNKNOWN: 0,
  READ_ONLY_MODE: 1,
  ENABLE_PAN_ZOOM: 2,
  ENABLE_ROTATION: 3,
  ENABLE_AUTO_PEN_MODE: 4,
  ENABLE_PEN_MODE: 5,
  LOW_MEMORY_MODE: 6,
  OPAQUE_PREDICTED_SEGMENT: 7
};


/**
 * Enumeration DocumentType.
 * @enum {number}
 */
sketchology.proto.DocumentType = {
  UNKNOWN_DOCUMENT_TYPE: 0,
  SINGLE_USER_DOCUMENT: 1,
  PASSTHROUGH_DOCUMENT: 2
};


/**
 * Enumeration StorageType.
 * @enum {number}
 */
sketchology.proto.StorageType = {
  UNKNOWN_STORAGE_TYPE: 0,
  IN_MEMORY_STORAGE: 1,
  SQLITE_STORAGE: 2
};



/**
 * Message Command.
 * @constructor
 * @extends {goog.proto2.Message}
 * @final
 */
sketchology.proto.Command = function() {
  goog.proto2.Message.call(this);
};
goog.inherits(sketchology.proto.Command, goog.proto2.Message);


/**
 * Descriptor for this message, deserialized lazily in getDescriptor().
 * @private {?goog.proto2.Descriptor}
 */
sketchology.proto.Command.descriptor_ = null;


/**
 * Overrides {@link goog.proto2.Message#clone} to specify its exact return type.
 * @return {!sketchology.proto.Command} The cloned message.
 * @override
 */
sketchology.proto.Command.prototype.clone;


/**
 * Gets the value of the set_viewport field.
 * @return {?sketchology.proto.Viewport} The value.
 */
sketchology.proto.Command.prototype.getSetViewport = function() {
  return /** @type {?sketchology.proto.Viewport} */ (this.get$Value(1));
};


/**
 * Gets the value of the set_viewport field or the default value if not set.
 * @return {!sketchology.proto.Viewport} The value.
 */
sketchology.proto.Command.prototype.getSetViewportOrDefault = function() {
  return /** @type {!sketchology.proto.Viewport} */ (this.get$ValueOrDefault(1));
};


/**
 * Sets the value of the set_viewport field.
 * @param {!sketchology.proto.Viewport} value The value.
 */
sketchology.proto.Command.prototype.setSetViewport = function(value) {
  this.set$Value(1, value);
};


/**
 * @return {boolean} Whether the set_viewport field has a value.
 */
sketchology.proto.Command.prototype.hasSetViewport = function() {
  return this.has$Value(1);
};


/**
 * @return {number} The number of values in the set_viewport field.
 */
sketchology.proto.Command.prototype.setViewportCount = function() {
  return this.count$Values(1);
};


/**
 * Clears the values in the set_viewport field.
 */
sketchology.proto.Command.prototype.clearSetViewport = function() {
  this.clear$Field(1);
};


/**
 * Gets the value of the tool_params field.
 * @return {?sketchology.proto.ToolParams} The value.
 */
sketchology.proto.Command.prototype.getToolParams = function() {
  return /** @type {?sketchology.proto.ToolParams} */ (this.get$Value(2));
};


/**
 * Gets the value of the tool_params field or the default value if not set.
 * @return {!sketchology.proto.ToolParams} The value.
 */
sketchology.proto.Command.prototype.getToolParamsOrDefault = function() {
  return /** @type {!sketchology.proto.ToolParams} */ (this.get$ValueOrDefault(2));
};


/**
 * Sets the value of the tool_params field.
 * @param {!sketchology.proto.ToolParams} value The value.
 */
sketchology.proto.Command.prototype.setToolParams = function(value) {
  this.set$Value(2, value);
};


/**
 * @return {boolean} Whether the tool_params field has a value.
 */
sketchology.proto.Command.prototype.hasToolParams = function() {
  return this.has$Value(2);
};


/**
 * @return {number} The number of values in the tool_params field.
 */
sketchology.proto.Command.prototype.toolParamsCount = function() {
  return this.count$Values(2);
};


/**
 * Clears the values in the tool_params field.
 */
sketchology.proto.Command.prototype.clearToolParams = function() {
  this.clear$Field(2);
};


/**
 * Gets the value of the add_path field.
 * @return {?sketchology.proto.AddPath} The value.
 */
sketchology.proto.Command.prototype.getAddPath = function() {
  return /** @type {?sketchology.proto.AddPath} */ (this.get$Value(3));
};


/**
 * Gets the value of the add_path field or the default value if not set.
 * @return {!sketchology.proto.AddPath} The value.
 */
sketchology.proto.Command.prototype.getAddPathOrDefault = function() {
  return /** @type {!sketchology.proto.AddPath} */ (this.get$ValueOrDefault(3));
};


/**
 * Sets the value of the add_path field.
 * @param {!sketchology.proto.AddPath} value The value.
 */
sketchology.proto.Command.prototype.setAddPath = function(value) {
  this.set$Value(3, value);
};


/**
 * @return {boolean} Whether the add_path field has a value.
 */
sketchology.proto.Command.prototype.hasAddPath = function() {
  return this.has$Value(3);
};


/**
 * @return {number} The number of values in the add_path field.
 */
sketchology.proto.Command.prototype.addPathCount = function() {
  return this.count$Values(3);
};


/**
 * Clears the values in the add_path field.
 */
sketchology.proto.Command.prototype.clearAddPath = function() {
  this.clear$Field(3);
};


/**
 * Gets the value of the camera_position field.
 * @return {?sketchology.proto.Rect} The value.
 */
sketchology.proto.Command.prototype.getCameraPosition = function() {
  return /** @type {?sketchology.proto.Rect} */ (this.get$Value(4));
};


/**
 * Gets the value of the camera_position field or the default value if not set.
 * @return {!sketchology.proto.Rect} The value.
 */
sketchology.proto.Command.prototype.getCameraPositionOrDefault = function() {
  return /** @type {!sketchology.proto.Rect} */ (this.get$ValueOrDefault(4));
};


/**
 * Sets the value of the camera_position field.
 * @param {!sketchology.proto.Rect} value The value.
 */
sketchology.proto.Command.prototype.setCameraPosition = function(value) {
  this.set$Value(4, value);
};


/**
 * @return {boolean} Whether the camera_position field has a value.
 */
sketchology.proto.Command.prototype.hasCameraPosition = function() {
  return this.has$Value(4);
};


/**
 * @return {number} The number of values in the camera_position field.
 */
sketchology.proto.Command.prototype.cameraPositionCount = function() {
  return this.count$Values(4);
};


/**
 * Clears the values in the camera_position field.
 */
sketchology.proto.Command.prototype.clearCameraPosition = function() {
  this.clear$Field(4);
};


/**
 * Gets the value of the page_bounds field.
 * @return {?sketchology.proto.Rect} The value.
 */
sketchology.proto.Command.prototype.getPageBounds = function() {
  return /** @type {?sketchology.proto.Rect} */ (this.get$Value(5));
};


/**
 * Gets the value of the page_bounds field or the default value if not set.
 * @return {!sketchology.proto.Rect} The value.
 */
sketchology.proto.Command.prototype.getPageBoundsOrDefault = function() {
  return /** @type {!sketchology.proto.Rect} */ (this.get$ValueOrDefault(5));
};


/**
 * Sets the value of the page_bounds field.
 * @param {!sketchology.proto.Rect} value The value.
 */
sketchology.proto.Command.prototype.setPageBounds = function(value) {
  this.set$Value(5, value);
};


/**
 * @return {boolean} Whether the page_bounds field has a value.
 */
sketchology.proto.Command.prototype.hasPageBounds = function() {
  return this.has$Value(5);
};


/**
 * @return {number} The number of values in the page_bounds field.
 */
sketchology.proto.Command.prototype.pageBoundsCount = function() {
  return this.count$Values(5);
};


/**
 * Clears the values in the page_bounds field.
 */
sketchology.proto.Command.prototype.clearPageBounds = function() {
  this.clear$Field(5);
};


/**
 * Gets the value of the image_export field.
 * @return {?sketchology.proto.ImageExport} The value.
 */
sketchology.proto.Command.prototype.getImageExport = function() {
  return /** @type {?sketchology.proto.ImageExport} */ (this.get$Value(6));
};


/**
 * Gets the value of the image_export field or the default value if not set.
 * @return {!sketchology.proto.ImageExport} The value.
 */
sketchology.proto.Command.prototype.getImageExportOrDefault = function() {
  return /** @type {!sketchology.proto.ImageExport} */ (this.get$ValueOrDefault(6));
};


/**
 * Sets the value of the image_export field.
 * @param {!sketchology.proto.ImageExport} value The value.
 */
sketchology.proto.Command.prototype.setImageExport = function(value) {
  this.set$Value(6, value);
};


/**
 * @return {boolean} Whether the image_export field has a value.
 */
sketchology.proto.Command.prototype.hasImageExport = function() {
  return this.has$Value(6);
};


/**
 * @return {number} The number of values in the image_export field.
 */
sketchology.proto.Command.prototype.imageExportCount = function() {
  return this.count$Values(6);
};


/**
 * Clears the values in the image_export field.
 */
sketchology.proto.Command.prototype.clearImageExport = function() {
  this.clear$Field(6);
};


/**
 * Gets the value of the flag_assignment field.
 * @return {?sketchology.proto.FlagAssignment} The value.
 */
sketchology.proto.Command.prototype.getFlagAssignment = function() {
  return /** @type {?sketchology.proto.FlagAssignment} */ (this.get$Value(7));
};


/**
 * Gets the value of the flag_assignment field or the default value if not set.
 * @return {!sketchology.proto.FlagAssignment} The value.
 */
sketchology.proto.Command.prototype.getFlagAssignmentOrDefault = function() {
  return /** @type {!sketchology.proto.FlagAssignment} */ (this.get$ValueOrDefault(7));
};


/**
 * Sets the value of the flag_assignment field.
 * @param {!sketchology.proto.FlagAssignment} value The value.
 */
sketchology.proto.Command.prototype.setFlagAssignment = function(value) {
  this.set$Value(7, value);
};


/**
 * @return {boolean} Whether the flag_assignment field has a value.
 */
sketchology.proto.Command.prototype.hasFlagAssignment = function() {
  return this.has$Value(7);
};


/**
 * @return {number} The number of values in the flag_assignment field.
 */
sketchology.proto.Command.prototype.flagAssignmentCount = function() {
  return this.count$Values(7);
};


/**
 * Clears the values in the flag_assignment field.
 */
sketchology.proto.Command.prototype.clearFlagAssignment = function() {
  this.clear$Field(7);
};


/**
 * Gets the value of the set_element_transforms field.
 * @return {?sketchology.proto.ElementMutation} The value.
 */
sketchology.proto.Command.prototype.getSetElementTransforms = function() {
  return /** @type {?sketchology.proto.ElementMutation} */ (this.get$Value(8));
};


/**
 * Gets the value of the set_element_transforms field or the default value if not set.
 * @return {!sketchology.proto.ElementMutation} The value.
 */
sketchology.proto.Command.prototype.getSetElementTransformsOrDefault = function() {
  return /** @type {!sketchology.proto.ElementMutation} */ (this.get$ValueOrDefault(8));
};


/**
 * Sets the value of the set_element_transforms field.
 * @param {!sketchology.proto.ElementMutation} value The value.
 */
sketchology.proto.Command.prototype.setSetElementTransforms = function(value) {
  this.set$Value(8, value);
};


/**
 * @return {boolean} Whether the set_element_transforms field has a value.
 */
sketchology.proto.Command.prototype.hasSetElementTransforms = function() {
  return this.has$Value(8);
};


/**
 * @return {number} The number of values in the set_element_transforms field.
 */
sketchology.proto.Command.prototype.setElementTransformsCount = function() {
  return this.count$Values(8);
};


/**
 * Clears the values in the set_element_transforms field.
 */
sketchology.proto.Command.prototype.clearSetElementTransforms = function() {
  this.clear$Field(8);
};


/**
 * Gets the value of the add_element field.
 * @return {?sketchology.proto.AddElement} The value.
 */
sketchology.proto.Command.prototype.getAddElement = function() {
  return /** @type {?sketchology.proto.AddElement} */ (this.get$Value(9));
};


/**
 * Gets the value of the add_element field or the default value if not set.
 * @return {!sketchology.proto.AddElement} The value.
 */
sketchology.proto.Command.prototype.getAddElementOrDefault = function() {
  return /** @type {!sketchology.proto.AddElement} */ (this.get$ValueOrDefault(9));
};


/**
 * Sets the value of the add_element field.
 * @param {!sketchology.proto.AddElement} value The value.
 */
sketchology.proto.Command.prototype.setAddElement = function(value) {
  this.set$Value(9, value);
};


/**
 * @return {boolean} Whether the add_element field has a value.
 */
sketchology.proto.Command.prototype.hasAddElement = function() {
  return this.has$Value(9);
};


/**
 * @return {number} The number of values in the add_element field.
 */
sketchology.proto.Command.prototype.addElementCount = function() {
  return this.count$Values(9);
};


/**
 * Clears the values in the add_element field.
 */
sketchology.proto.Command.prototype.clearAddElement = function() {
  this.clear$Field(9);
};


/**
 * Gets the value of the background_image field.
 * @return {?sketchology.proto.BackgroundImageInfo} The value.
 */
sketchology.proto.Command.prototype.getBackgroundImage = function() {
  return /** @type {?sketchology.proto.BackgroundImageInfo} */ (this.get$Value(10));
};


/**
 * Gets the value of the background_image field or the default value if not set.
 * @return {!sketchology.proto.BackgroundImageInfo} The value.
 */
sketchology.proto.Command.prototype.getBackgroundImageOrDefault = function() {
  return /** @type {!sketchology.proto.BackgroundImageInfo} */ (this.get$ValueOrDefault(10));
};


/**
 * Sets the value of the background_image field.
 * @param {!sketchology.proto.BackgroundImageInfo} value The value.
 */
sketchology.proto.Command.prototype.setBackgroundImage = function(value) {
  this.set$Value(10, value);
};


/**
 * @return {boolean} Whether the background_image field has a value.
 */
sketchology.proto.Command.prototype.hasBackgroundImage = function() {
  return this.has$Value(10);
};


/**
 * @return {number} The number of values in the background_image field.
 */
sketchology.proto.Command.prototype.backgroundImageCount = function() {
  return this.count$Values(10);
};


/**
 * Clears the values in the background_image field.
 */
sketchology.proto.Command.prototype.clearBackgroundImage = function() {
  this.clear$Field(10);
};


/**
 * Gets the value of the background_color field.
 * @return {?sketchology.proto.BackgroundColor} The value.
 */
sketchology.proto.Command.prototype.getBackgroundColor = function() {
  return /** @type {?sketchology.proto.BackgroundColor} */ (this.get$Value(11));
};


/**
 * Gets the value of the background_color field or the default value if not set.
 * @return {!sketchology.proto.BackgroundColor} The value.
 */
sketchology.proto.Command.prototype.getBackgroundColorOrDefault = function() {
  return /** @type {!sketchology.proto.BackgroundColor} */ (this.get$ValueOrDefault(11));
};


/**
 * Sets the value of the background_color field.
 * @param {!sketchology.proto.BackgroundColor} value The value.
 */
sketchology.proto.Command.prototype.setBackgroundColor = function(value) {
  this.set$Value(11, value);
};


/**
 * @return {boolean} Whether the background_color field has a value.
 */
sketchology.proto.Command.prototype.hasBackgroundColor = function() {
  return this.has$Value(11);
};


/**
 * @return {number} The number of values in the background_color field.
 */
sketchology.proto.Command.prototype.backgroundColorCount = function() {
  return this.count$Values(11);
};


/**
 * Clears the values in the background_color field.
 */
sketchology.proto.Command.prototype.clearBackgroundColor = function() {
  this.clear$Field(11);
};


/**
 * Gets the value of the set_out_of_bounds_color field.
 * @return {?sketchology.proto.OutOfBoundsColor} The value.
 */
sketchology.proto.Command.prototype.getSetOutOfBoundsColor = function() {
  return /** @type {?sketchology.proto.OutOfBoundsColor} */ (this.get$Value(12));
};


/**
 * Gets the value of the set_out_of_bounds_color field or the default value if not set.
 * @return {!sketchology.proto.OutOfBoundsColor} The value.
 */
sketchology.proto.Command.prototype.getSetOutOfBoundsColorOrDefault = function() {
  return /** @type {!sketchology.proto.OutOfBoundsColor} */ (this.get$ValueOrDefault(12));
};


/**
 * Sets the value of the set_out_of_bounds_color field.
 * @param {!sketchology.proto.OutOfBoundsColor} value The value.
 */
sketchology.proto.Command.prototype.setSetOutOfBoundsColor = function(value) {
  this.set$Value(12, value);
};


/**
 * @return {boolean} Whether the set_out_of_bounds_color field has a value.
 */
sketchology.proto.Command.prototype.hasSetOutOfBoundsColor = function() {
  return this.has$Value(12);
};


/**
 * @return {number} The number of values in the set_out_of_bounds_color field.
 */
sketchology.proto.Command.prototype.setOutOfBoundsColorCount = function() {
  return this.count$Values(12);
};


/**
 * Clears the values in the set_out_of_bounds_color field.
 */
sketchology.proto.Command.prototype.clearSetOutOfBoundsColor = function() {
  this.clear$Field(12);
};


/**
 * Gets the value of the set_page_border field.
 * @return {?sketchology.proto.Border} The value.
 */
sketchology.proto.Command.prototype.getSetPageBorder = function() {
  return /** @type {?sketchology.proto.Border} */ (this.get$Value(13));
};


/**
 * Gets the value of the set_page_border field or the default value if not set.
 * @return {!sketchology.proto.Border} The value.
 */
sketchology.proto.Command.prototype.getSetPageBorderOrDefault = function() {
  return /** @type {!sketchology.proto.Border} */ (this.get$ValueOrDefault(13));
};


/**
 * Sets the value of the set_page_border field.
 * @param {!sketchology.proto.Border} value The value.
 */
sketchology.proto.Command.prototype.setSetPageBorder = function(value) {
  this.set$Value(13, value);
};


/**
 * @return {boolean} Whether the set_page_border field has a value.
 */
sketchology.proto.Command.prototype.hasSetPageBorder = function() {
  return this.has$Value(13);
};


/**
 * @return {number} The number of values in the set_page_border field.
 */
sketchology.proto.Command.prototype.setPageBorderCount = function() {
  return this.count$Values(13);
};


/**
 * Clears the values in the set_page_border field.
 */
sketchology.proto.Command.prototype.clearSetPageBorder = function() {
  this.clear$Field(13);
};


/**
 * Gets the value of the send_input_stream field.
 * @return {?sketchology.proto.SInputStream} The value.
 */
sketchology.proto.Command.prototype.getSendInputStream = function() {
  return /** @type {?sketchology.proto.SInputStream} */ (this.get$Value(14));
};


/**
 * Gets the value of the send_input_stream field or the default value if not set.
 * @return {!sketchology.proto.SInputStream} The value.
 */
sketchology.proto.Command.prototype.getSendInputStreamOrDefault = function() {
  return /** @type {!sketchology.proto.SInputStream} */ (this.get$ValueOrDefault(14));
};


/**
 * Sets the value of the send_input_stream field.
 * @param {!sketchology.proto.SInputStream} value The value.
 */
sketchology.proto.Command.prototype.setSendInputStream = function(value) {
  this.set$Value(14, value);
};


/**
 * @return {boolean} Whether the send_input_stream field has a value.
 */
sketchology.proto.Command.prototype.hasSendInputStream = function() {
  return this.has$Value(14);
};


/**
 * @return {number} The number of values in the send_input_stream field.
 */
sketchology.proto.Command.prototype.sendInputStreamCount = function() {
  return this.count$Values(14);
};


/**
 * Clears the values in the send_input_stream field.
 */
sketchology.proto.Command.prototype.clearSendInputStream = function() {
  this.clear$Field(14);
};


/**
 * Gets the value of the sequence_point field.
 * @return {?sketchology.proto.SequencePoint} The value.
 */
sketchology.proto.Command.prototype.getSequencePoint = function() {
  return /** @type {?sketchology.proto.SequencePoint} */ (this.get$Value(15));
};


/**
 * Gets the value of the sequence_point field or the default value if not set.
 * @return {!sketchology.proto.SequencePoint} The value.
 */
sketchology.proto.Command.prototype.getSequencePointOrDefault = function() {
  return /** @type {!sketchology.proto.SequencePoint} */ (this.get$ValueOrDefault(15));
};


/**
 * Sets the value of the sequence_point field.
 * @param {!sketchology.proto.SequencePoint} value The value.
 */
sketchology.proto.Command.prototype.setSequencePoint = function(value) {
  this.set$Value(15, value);
};


/**
 * @return {boolean} Whether the sequence_point field has a value.
 */
sketchology.proto.Command.prototype.hasSequencePoint = function() {
  return this.has$Value(15);
};


/**
 * @return {number} The number of values in the sequence_point field.
 */
sketchology.proto.Command.prototype.sequencePointCount = function() {
  return this.count$Values(15);
};


/**
 * Clears the values in the sequence_point field.
 */
sketchology.proto.Command.prototype.clearSequencePoint = function() {
  this.clear$Field(15);
};


/**
 * Gets the value of the set_callback_flags field.
 * @return {?sketchology.proto.SetCallbackFlags} The value.
 */
sketchology.proto.Command.prototype.getSetCallbackFlags = function() {
  return /** @type {?sketchology.proto.SetCallbackFlags} */ (this.get$Value(16));
};


/**
 * Gets the value of the set_callback_flags field or the default value if not set.
 * @return {!sketchology.proto.SetCallbackFlags} The value.
 */
sketchology.proto.Command.prototype.getSetCallbackFlagsOrDefault = function() {
  return /** @type {!sketchology.proto.SetCallbackFlags} */ (this.get$ValueOrDefault(16));
};


/**
 * Sets the value of the set_callback_flags field.
 * @param {!sketchology.proto.SetCallbackFlags} value The value.
 */
sketchology.proto.Command.prototype.setSetCallbackFlags = function(value) {
  this.set$Value(16, value);
};


/**
 * @return {boolean} Whether the set_callback_flags field has a value.
 */
sketchology.proto.Command.prototype.hasSetCallbackFlags = function() {
  return this.has$Value(16);
};


/**
 * @return {number} The number of values in the set_callback_flags field.
 */
sketchology.proto.Command.prototype.setCallbackFlagsCount = function() {
  return this.count$Values(16);
};


/**
 * Clears the values in the set_callback_flags field.
 */
sketchology.proto.Command.prototype.clearSetCallbackFlags = function() {
  this.clear$Field(16);
};


/**
 * Gets the value of the set_camera_bounds_config field.
 * @return {?sketchology.proto.CameraBoundsConfig} The value.
 */
sketchology.proto.Command.prototype.getSetCameraBoundsConfig = function() {
  return /** @type {?sketchology.proto.CameraBoundsConfig} */ (this.get$Value(17));
};


/**
 * Gets the value of the set_camera_bounds_config field or the default value if not set.
 * @return {!sketchology.proto.CameraBoundsConfig} The value.
 */
sketchology.proto.Command.prototype.getSetCameraBoundsConfigOrDefault = function() {
  return /** @type {!sketchology.proto.CameraBoundsConfig} */ (this.get$ValueOrDefault(17));
};


/**
 * Sets the value of the set_camera_bounds_config field.
 * @param {!sketchology.proto.CameraBoundsConfig} value The value.
 */
sketchology.proto.Command.prototype.setSetCameraBoundsConfig = function(value) {
  this.set$Value(17, value);
};


/**
 * @return {boolean} Whether the set_camera_bounds_config field has a value.
 */
sketchology.proto.Command.prototype.hasSetCameraBoundsConfig = function() {
  return this.has$Value(17);
};


/**
 * @return {number} The number of values in the set_camera_bounds_config field.
 */
sketchology.proto.Command.prototype.setCameraBoundsConfigCount = function() {
  return this.count$Values(17);
};


/**
 * Clears the values in the set_camera_bounds_config field.
 */
sketchology.proto.Command.prototype.clearSetCameraBoundsConfig = function() {
  this.clear$Field(17);
};


/**
 * Gets the value of the deselect_all field.
 * @return {?sketchology.proto.NoArgCommand} The value.
 */
sketchology.proto.Command.prototype.getDeselectAll = function() {
  return /** @type {?sketchology.proto.NoArgCommand} */ (this.get$Value(18));
};


/**
 * Gets the value of the deselect_all field or the default value if not set.
 * @return {!sketchology.proto.NoArgCommand} The value.
 */
sketchology.proto.Command.prototype.getDeselectAllOrDefault = function() {
  return /** @type {!sketchology.proto.NoArgCommand} */ (this.get$ValueOrDefault(18));
};


/**
 * Sets the value of the deselect_all field.
 * @param {!sketchology.proto.NoArgCommand} value The value.
 */
sketchology.proto.Command.prototype.setDeselectAll = function(value) {
  this.set$Value(18, value);
};


/**
 * @return {boolean} Whether the deselect_all field has a value.
 */
sketchology.proto.Command.prototype.hasDeselectAll = function() {
  return this.has$Value(18);
};


/**
 * @return {number} The number of values in the deselect_all field.
 */
sketchology.proto.Command.prototype.deselectAllCount = function() {
  return this.count$Values(18);
};


/**
 * Clears the values in the deselect_all field.
 */
sketchology.proto.Command.prototype.clearDeselectAll = function() {
  this.clear$Field(18);
};


/**
 * Gets the value of the add_image_rect field.
 * @return {?sketchology.proto.ImageRect} The value.
 */
sketchology.proto.Command.prototype.getAddImageRect = function() {
  return /** @type {?sketchology.proto.ImageRect} */ (this.get$Value(19));
};


/**
 * Gets the value of the add_image_rect field or the default value if not set.
 * @return {!sketchology.proto.ImageRect} The value.
 */
sketchology.proto.Command.prototype.getAddImageRectOrDefault = function() {
  return /** @type {!sketchology.proto.ImageRect} */ (this.get$ValueOrDefault(19));
};


/**
 * Sets the value of the add_image_rect field.
 * @param {!sketchology.proto.ImageRect} value The value.
 */
sketchology.proto.Command.prototype.setAddImageRect = function(value) {
  this.set$Value(19, value);
};


/**
 * @return {boolean} Whether the add_image_rect field has a value.
 */
sketchology.proto.Command.prototype.hasAddImageRect = function() {
  return this.has$Value(19);
};


/**
 * @return {number} The number of values in the add_image_rect field.
 */
sketchology.proto.Command.prototype.addImageRectCount = function() {
  return this.count$Values(19);
};


/**
 * Clears the values in the add_image_rect field.
 */
sketchology.proto.Command.prototype.clearAddImageRect = function() {
  this.clear$Field(19);
};


/**
 * Gets the value of the clear field.
 * @return {?sketchology.proto.NoArgCommand} The value.
 */
sketchology.proto.Command.prototype.getClear = function() {
  return /** @type {?sketchology.proto.NoArgCommand} */ (this.get$Value(21));
};


/**
 * Gets the value of the clear field or the default value if not set.
 * @return {!sketchology.proto.NoArgCommand} The value.
 */
sketchology.proto.Command.prototype.getClearOrDefault = function() {
  return /** @type {!sketchology.proto.NoArgCommand} */ (this.get$ValueOrDefault(21));
};


/**
 * Sets the value of the clear field.
 * @param {!sketchology.proto.NoArgCommand} value The value.
 */
sketchology.proto.Command.prototype.setClear = function(value) {
  this.set$Value(21, value);
};


/**
 * @return {boolean} Whether the clear field has a value.
 */
sketchology.proto.Command.prototype.hasClear = function() {
  return this.has$Value(21);
};


/**
 * @return {number} The number of values in the clear field.
 */
sketchology.proto.Command.prototype.clearCount = function() {
  return this.count$Values(21);
};


/**
 * Clears the values in the clear field.
 */
sketchology.proto.Command.prototype.clearClear = function() {
  this.clear$Field(21);
};


/**
 * Gets the value of the remove_all_elements field.
 * @return {?sketchology.proto.NoArgCommand} The value.
 */
sketchology.proto.Command.prototype.getRemoveAllElements = function() {
  return /** @type {?sketchology.proto.NoArgCommand} */ (this.get$Value(22));
};


/**
 * Gets the value of the remove_all_elements field or the default value if not set.
 * @return {!sketchology.proto.NoArgCommand} The value.
 */
sketchology.proto.Command.prototype.getRemoveAllElementsOrDefault = function() {
  return /** @type {!sketchology.proto.NoArgCommand} */ (this.get$ValueOrDefault(22));
};


/**
 * Sets the value of the remove_all_elements field.
 * @param {!sketchology.proto.NoArgCommand} value The value.
 */
sketchology.proto.Command.prototype.setRemoveAllElements = function(value) {
  this.set$Value(22, value);
};


/**
 * @return {boolean} Whether the remove_all_elements field has a value.
 */
sketchology.proto.Command.prototype.hasRemoveAllElements = function() {
  return this.has$Value(22);
};


/**
 * @return {number} The number of values in the remove_all_elements field.
 */
sketchology.proto.Command.prototype.removeAllElementsCount = function() {
  return this.count$Values(22);
};


/**
 * Clears the values in the remove_all_elements field.
 */
sketchology.proto.Command.prototype.clearRemoveAllElements = function() {
  this.clear$Field(22);
};


/**
 * Gets the value of the undo field.
 * @return {?sketchology.proto.NoArgCommand} The value.
 */
sketchology.proto.Command.prototype.getUndo = function() {
  return /** @type {?sketchology.proto.NoArgCommand} */ (this.get$Value(23));
};


/**
 * Gets the value of the undo field or the default value if not set.
 * @return {!sketchology.proto.NoArgCommand} The value.
 */
sketchology.proto.Command.prototype.getUndoOrDefault = function() {
  return /** @type {!sketchology.proto.NoArgCommand} */ (this.get$ValueOrDefault(23));
};


/**
 * Sets the value of the undo field.
 * @param {!sketchology.proto.NoArgCommand} value The value.
 */
sketchology.proto.Command.prototype.setUndo = function(value) {
  this.set$Value(23, value);
};


/**
 * @return {boolean} Whether the undo field has a value.
 */
sketchology.proto.Command.prototype.hasUndo = function() {
  return this.has$Value(23);
};


/**
 * @return {number} The number of values in the undo field.
 */
sketchology.proto.Command.prototype.undoCount = function() {
  return this.count$Values(23);
};


/**
 * Clears the values in the undo field.
 */
sketchology.proto.Command.prototype.clearUndo = function() {
  this.clear$Field(23);
};


/**
 * Gets the value of the redo field.
 * @return {?sketchology.proto.NoArgCommand} The value.
 */
sketchology.proto.Command.prototype.getRedo = function() {
  return /** @type {?sketchology.proto.NoArgCommand} */ (this.get$Value(24));
};


/**
 * Gets the value of the redo field or the default value if not set.
 * @return {!sketchology.proto.NoArgCommand} The value.
 */
sketchology.proto.Command.prototype.getRedoOrDefault = function() {
  return /** @type {!sketchology.proto.NoArgCommand} */ (this.get$ValueOrDefault(24));
};


/**
 * Sets the value of the redo field.
 * @param {!sketchology.proto.NoArgCommand} value The value.
 */
sketchology.proto.Command.prototype.setRedo = function(value) {
  this.set$Value(24, value);
};


/**
 * @return {boolean} Whether the redo field has a value.
 */
sketchology.proto.Command.prototype.hasRedo = function() {
  return this.has$Value(24);
};


/**
 * @return {number} The number of values in the redo field.
 */
sketchology.proto.Command.prototype.redoCount = function() {
  return this.count$Values(24);
};


/**
 * Clears the values in the redo field.
 */
sketchology.proto.Command.prototype.clearRedo = function() {
  this.clear$Field(24);
};


/**
 * Gets the value of the evict_image_data field.
 * @return {?sketchology.proto.EvictImageData} The value.
 */
sketchology.proto.Command.prototype.getEvictImageData = function() {
  return /** @type {?sketchology.proto.EvictImageData} */ (this.get$Value(25));
};


/**
 * Gets the value of the evict_image_data field or the default value if not set.
 * @return {!sketchology.proto.EvictImageData} The value.
 */
sketchology.proto.Command.prototype.getEvictImageDataOrDefault = function() {
  return /** @type {!sketchology.proto.EvictImageData} */ (this.get$ValueOrDefault(25));
};


/**
 * Sets the value of the evict_image_data field.
 * @param {!sketchology.proto.EvictImageData} value The value.
 */
sketchology.proto.Command.prototype.setEvictImageData = function(value) {
  this.set$Value(25, value);
};


/**
 * @return {boolean} Whether the evict_image_data field has a value.
 */
sketchology.proto.Command.prototype.hasEvictImageData = function() {
  return this.has$Value(25);
};


/**
 * @return {number} The number of values in the evict_image_data field.
 */
sketchology.proto.Command.prototype.evictImageDataCount = function() {
  return this.count$Values(25);
};


/**
 * Clears the values in the evict_image_data field.
 */
sketchology.proto.Command.prototype.clearEvictImageData = function() {
  this.clear$Field(25);
};


/**
 * Gets the value of the replace_elements field.
 * @return {?sketchology.proto.ReplaceElementsCommand} The value.
 */
sketchology.proto.Command.prototype.getReplaceElements = function() {
  return /** @type {?sketchology.proto.ReplaceElementsCommand} */ (this.get$Value(26));
};


/**
 * Gets the value of the replace_elements field or the default value if not set.
 * @return {!sketchology.proto.ReplaceElementsCommand} The value.
 */
sketchology.proto.Command.prototype.getReplaceElementsOrDefault = function() {
  return /** @type {!sketchology.proto.ReplaceElementsCommand} */ (this.get$ValueOrDefault(26));
};


/**
 * Sets the value of the replace_elements field.
 * @param {!sketchology.proto.ReplaceElementsCommand} value The value.
 */
sketchology.proto.Command.prototype.setReplaceElements = function(value) {
  this.set$Value(26, value);
};


/**
 * @return {boolean} Whether the replace_elements field has a value.
 */
sketchology.proto.Command.prototype.hasReplaceElements = function() {
  return this.has$Value(26);
};


/**
 * @return {number} The number of values in the replace_elements field.
 */
sketchology.proto.Command.prototype.replaceElementsCount = function() {
  return this.count$Values(26);
};


/**
 * Clears the values in the replace_elements field.
 */
sketchology.proto.Command.prototype.clearReplaceElements = function() {
  this.clear$Field(26);
};


/**
 * Gets the value of the commit_crop field.
 * @return {?sketchology.proto.NoArgCommand} The value.
 */
sketchology.proto.Command.prototype.getCommitCrop = function() {
  return /** @type {?sketchology.proto.NoArgCommand} */ (this.get$Value(27));
};


/**
 * Gets the value of the commit_crop field or the default value if not set.
 * @return {!sketchology.proto.NoArgCommand} The value.
 */
sketchology.proto.Command.prototype.getCommitCropOrDefault = function() {
  return /** @type {!sketchology.proto.NoArgCommand} */ (this.get$ValueOrDefault(27));
};


/**
 * Sets the value of the commit_crop field.
 * @param {!sketchology.proto.NoArgCommand} value The value.
 */
sketchology.proto.Command.prototype.setCommitCrop = function(value) {
  this.set$Value(27, value);
};


/**
 * @return {boolean} Whether the commit_crop field has a value.
 */
sketchology.proto.Command.prototype.hasCommitCrop = function() {
  return this.has$Value(27);
};


/**
 * @return {number} The number of values in the commit_crop field.
 */
sketchology.proto.Command.prototype.commitCropCount = function() {
  return this.count$Values(27);
};


/**
 * Clears the values in the commit_crop field.
 */
sketchology.proto.Command.prototype.clearCommitCrop = function() {
  this.clear$Field(27);
};


/**
 * Gets the value of the element_animation field.
 * @return {?sketchology.proto.ElementAnimation} The value.
 */
sketchology.proto.Command.prototype.getElementAnimation = function() {
  return /** @type {?sketchology.proto.ElementAnimation} */ (this.get$Value(28));
};


/**
 * Gets the value of the element_animation field or the default value if not set.
 * @return {!sketchology.proto.ElementAnimation} The value.
 */
sketchology.proto.Command.prototype.getElementAnimationOrDefault = function() {
  return /** @type {!sketchology.proto.ElementAnimation} */ (this.get$ValueOrDefault(28));
};


/**
 * Sets the value of the element_animation field.
 * @param {!sketchology.proto.ElementAnimation} value The value.
 */
sketchology.proto.Command.prototype.setElementAnimation = function(value) {
  this.set$Value(28, value);
};


/**
 * @return {boolean} Whether the element_animation field has a value.
 */
sketchology.proto.Command.prototype.hasElementAnimation = function() {
  return this.has$Value(28);
};


/**
 * @return {number} The number of values in the element_animation field.
 */
sketchology.proto.Command.prototype.elementAnimationCount = function() {
  return this.count$Values(28);
};


/**
 * Clears the values in the element_animation field.
 */
sketchology.proto.Command.prototype.clearElementAnimation = function() {
  this.clear$Field(28);
};


/**
 * Gets the value of the set_grid field.
 * @return {?sketchology.proto.GridInfo} The value.
 */
sketchology.proto.Command.prototype.getSetGrid = function() {
  return /** @type {?sketchology.proto.GridInfo} */ (this.get$Value(29));
};


/**
 * Gets the value of the set_grid field or the default value if not set.
 * @return {!sketchology.proto.GridInfo} The value.
 */
sketchology.proto.Command.prototype.getSetGridOrDefault = function() {
  return /** @type {!sketchology.proto.GridInfo} */ (this.get$ValueOrDefault(29));
};


/**
 * Sets the value of the set_grid field.
 * @param {!sketchology.proto.GridInfo} value The value.
 */
sketchology.proto.Command.prototype.setSetGrid = function(value) {
  this.set$Value(29, value);
};


/**
 * @return {boolean} Whether the set_grid field has a value.
 */
sketchology.proto.Command.prototype.hasSetGrid = function() {
  return this.has$Value(29);
};


/**
 * @return {number} The number of values in the set_grid field.
 */
sketchology.proto.Command.prototype.setGridCount = function() {
  return this.count$Values(29);
};


/**
 * Clears the values in the set_grid field.
 */
sketchology.proto.Command.prototype.clearSetGrid = function() {
  this.clear$Field(29);
};


/**
 * Gets the value of the clear_grid field.
 * @return {?sketchology.proto.NoArgCommand} The value.
 */
sketchology.proto.Command.prototype.getClearGrid = function() {
  return /** @type {?sketchology.proto.NoArgCommand} */ (this.get$Value(30));
};


/**
 * Gets the value of the clear_grid field or the default value if not set.
 * @return {!sketchology.proto.NoArgCommand} The value.
 */
sketchology.proto.Command.prototype.getClearGridOrDefault = function() {
  return /** @type {!sketchology.proto.NoArgCommand} */ (this.get$ValueOrDefault(30));
};


/**
 * Sets the value of the clear_grid field.
 * @param {!sketchology.proto.NoArgCommand} value The value.
 */
sketchology.proto.Command.prototype.setClearGrid = function(value) {
  this.set$Value(30, value);
};


/**
 * @return {boolean} Whether the clear_grid field has a value.
 */
sketchology.proto.Command.prototype.hasClearGrid = function() {
  return this.has$Value(30);
};


/**
 * @return {number} The number of values in the clear_grid field.
 */
sketchology.proto.Command.prototype.clearGridCount = function() {
  return this.count$Values(30);
};


/**
 * Clears the values in the clear_grid field.
 */
sketchology.proto.Command.prototype.clearClearGrid = function() {
  this.clear$Field(30);
};



/**
 * Message CommandList.
 * @constructor
 * @extends {goog.proto2.Message}
 * @final
 */
sketchology.proto.CommandList = function() {
  goog.proto2.Message.call(this);
};
goog.inherits(sketchology.proto.CommandList, goog.proto2.Message);


/**
 * Descriptor for this message, deserialized lazily in getDescriptor().
 * @private {?goog.proto2.Descriptor}
 */
sketchology.proto.CommandList.descriptor_ = null;


/**
 * Overrides {@link goog.proto2.Message#clone} to specify its exact return type.
 * @return {!sketchology.proto.CommandList} The cloned message.
 * @override
 */
sketchology.proto.CommandList.prototype.clone;


/**
 * Gets the value of the commands field at the index given.
 * @param {number} index The index to lookup.
 * @return {?sketchology.proto.Command} The value.
 */
sketchology.proto.CommandList.prototype.getCommands = function(index) {
  return /** @type {?sketchology.proto.Command} */ (this.get$Value(1, index));
};


/**
 * Gets the value of the commands field at the index given or the default value if not set.
 * @param {number} index The index to lookup.
 * @return {!sketchology.proto.Command} The value.
 */
sketchology.proto.CommandList.prototype.getCommandsOrDefault = function(index) {
  return /** @type {!sketchology.proto.Command} */ (this.get$ValueOrDefault(1, index));
};


/**
 * Adds a value to the commands field.
 * @param {!sketchology.proto.Command} value The value to add.
 */
sketchology.proto.CommandList.prototype.addCommands = function(value) {
  this.add$Value(1, value);
};


/**
 * Returns the array of values in the commands field.
 * @return {!Array<!sketchology.proto.Command>} The values in the field.
 */
sketchology.proto.CommandList.prototype.commandsArray = function() {
  return /** @type {!Array<!sketchology.proto.Command>} */ (this.array$Values(1));
};


/**
 * @return {boolean} Whether the commands field has a value.
 */
sketchology.proto.CommandList.prototype.hasCommands = function() {
  return this.has$Value(1);
};


/**
 * @return {number} The number of values in the commands field.
 */
sketchology.proto.CommandList.prototype.commandsCount = function() {
  return this.count$Values(1);
};


/**
 * Clears the values in the commands field.
 */
sketchology.proto.CommandList.prototype.clearCommands = function() {
  this.clear$Field(1);
};



/**
 * Message NoArgCommand.
 * @constructor
 * @extends {goog.proto2.Message}
 * @final
 */
sketchology.proto.NoArgCommand = function() {
  goog.proto2.Message.call(this);
};
goog.inherits(sketchology.proto.NoArgCommand, goog.proto2.Message);


/**
 * Descriptor for this message, deserialized lazily in getDescriptor().
 * @private {?goog.proto2.Descriptor}
 */
sketchology.proto.NoArgCommand.descriptor_ = null;


/**
 * Overrides {@link goog.proto2.Message#clone} to specify its exact return type.
 * @return {!sketchology.proto.NoArgCommand} The cloned message.
 * @override
 */
sketchology.proto.NoArgCommand.prototype.clone;



/**
 * Message ReplaceElementsCommand.
 * @constructor
 * @extends {goog.proto2.Message}
 * @final
 */
sketchology.proto.ReplaceElementsCommand = function() {
  goog.proto2.Message.call(this);
};
goog.inherits(sketchology.proto.ReplaceElementsCommand, goog.proto2.Message);


/**
 * Descriptor for this message, deserialized lazily in getDescriptor().
 * @private {?goog.proto2.Descriptor}
 */
sketchology.proto.ReplaceElementsCommand.descriptor_ = null;


/**
 * Overrides {@link goog.proto2.Message#clone} to specify its exact return type.
 * @return {!sketchology.proto.ReplaceElementsCommand} The cloned message.
 * @override
 */
sketchology.proto.ReplaceElementsCommand.prototype.clone;


/**
 * Gets the value of the uuids_to_remove field at the index given.
 * @param {number} index The index to lookup.
 * @return {?string} The value.
 */
sketchology.proto.ReplaceElementsCommand.prototype.getUuidsToRemove = function(index) {
  return /** @type {?string} */ (this.get$Value(1, index));
};


/**
 * Gets the value of the uuids_to_remove field at the index given or the default value if not set.
 * @param {number} index The index to lookup.
 * @return {string} The value.
 */
sketchology.proto.ReplaceElementsCommand.prototype.getUuidsToRemoveOrDefault = function(index) {
  return /** @type {string} */ (this.get$ValueOrDefault(1, index));
};


/**
 * Adds a value to the uuids_to_remove field.
 * @param {string} value The value to add.
 */
sketchology.proto.ReplaceElementsCommand.prototype.addUuidsToRemove = function(value) {
  this.add$Value(1, value);
};


/**
 * Returns the array of values in the uuids_to_remove field.
 * @return {!Array<string>} The values in the field.
 */
sketchology.proto.ReplaceElementsCommand.prototype.uuidsToRemoveArray = function() {
  return /** @type {!Array<string>} */ (this.array$Values(1));
};


/**
 * @return {boolean} Whether the uuids_to_remove field has a value.
 */
sketchology.proto.ReplaceElementsCommand.prototype.hasUuidsToRemove = function() {
  return this.has$Value(1);
};


/**
 * @return {number} The number of values in the uuids_to_remove field.
 */
sketchology.proto.ReplaceElementsCommand.prototype.uuidsToRemoveCount = function() {
  return this.count$Values(1);
};


/**
 * Clears the values in the uuids_to_remove field.
 */
sketchology.proto.ReplaceElementsCommand.prototype.clearUuidsToRemove = function() {
  this.clear$Field(1);
};


/**
 * Gets the value of the paths_to_add field at the index given.
 * @param {number} index The index to lookup.
 * @return {?sketchology.proto.Path} The value.
 */
sketchology.proto.ReplaceElementsCommand.prototype.getPathsToAdd = function(index) {
  return /** @type {?sketchology.proto.Path} */ (this.get$Value(2, index));
};


/**
 * Gets the value of the paths_to_add field at the index given or the default value if not set.
 * @param {number} index The index to lookup.
 * @return {!sketchology.proto.Path} The value.
 */
sketchology.proto.ReplaceElementsCommand.prototype.getPathsToAddOrDefault = function(index) {
  return /** @type {!sketchology.proto.Path} */ (this.get$ValueOrDefault(2, index));
};


/**
 * Adds a value to the paths_to_add field.
 * @param {!sketchology.proto.Path} value The value to add.
 */
sketchology.proto.ReplaceElementsCommand.prototype.addPathsToAdd = function(value) {
  this.add$Value(2, value);
};


/**
 * Returns the array of values in the paths_to_add field.
 * @return {!Array<!sketchology.proto.Path>} The values in the field.
 */
sketchology.proto.ReplaceElementsCommand.prototype.pathsToAddArray = function() {
  return /** @type {!Array<!sketchology.proto.Path>} */ (this.array$Values(2));
};


/**
 * @return {boolean} Whether the paths_to_add field has a value.
 */
sketchology.proto.ReplaceElementsCommand.prototype.hasPathsToAdd = function() {
  return this.has$Value(2);
};


/**
 * @return {number} The number of values in the paths_to_add field.
 */
sketchology.proto.ReplaceElementsCommand.prototype.pathsToAddCount = function() {
  return this.count$Values(2);
};


/**
 * Clears the values in the paths_to_add field.
 */
sketchology.proto.ReplaceElementsCommand.prototype.clearPathsToAdd = function() {
  this.clear$Field(2);
};



/**
 * Message EvictImageData.
 * @constructor
 * @extends {goog.proto2.Message}
 * @final
 */
sketchology.proto.EvictImageData = function() {
  goog.proto2.Message.call(this);
};
goog.inherits(sketchology.proto.EvictImageData, goog.proto2.Message);


/**
 * Descriptor for this message, deserialized lazily in getDescriptor().
 * @private {?goog.proto2.Descriptor}
 */
sketchology.proto.EvictImageData.descriptor_ = null;


/**
 * Overrides {@link goog.proto2.Message#clone} to specify its exact return type.
 * @return {!sketchology.proto.EvictImageData} The cloned message.
 * @override
 */
sketchology.proto.EvictImageData.prototype.clone;


/**
 * Gets the value of the uri field.
 * @return {?string} The value.
 */
sketchology.proto.EvictImageData.prototype.getUri = function() {
  return /** @type {?string} */ (this.get$Value(1));
};


/**
 * Gets the value of the uri field or the default value if not set.
 * @return {string} The value.
 */
sketchology.proto.EvictImageData.prototype.getUriOrDefault = function() {
  return /** @type {string} */ (this.get$ValueOrDefault(1));
};


/**
 * Sets the value of the uri field.
 * @param {string} value The value.
 */
sketchology.proto.EvictImageData.prototype.setUri = function(value) {
  this.set$Value(1, value);
};


/**
 * @return {boolean} Whether the uri field has a value.
 */
sketchology.proto.EvictImageData.prototype.hasUri = function() {
  return this.has$Value(1);
};


/**
 * @return {number} The number of values in the uri field.
 */
sketchology.proto.EvictImageData.prototype.uriCount = function() {
  return this.count$Values(1);
};


/**
 * Clears the values in the uri field.
 */
sketchology.proto.EvictImageData.prototype.clearUri = function() {
  this.clear$Field(1);
};



/**
 * Message Viewport.
 * @constructor
 * @extends {goog.proto2.Message}
 * @final
 */
sketchology.proto.Viewport = function() {
  goog.proto2.Message.call(this);
};
goog.inherits(sketchology.proto.Viewport, goog.proto2.Message);


/**
 * Descriptor for this message, deserialized lazily in getDescriptor().
 * @private {?goog.proto2.Descriptor}
 */
sketchology.proto.Viewport.descriptor_ = null;


/**
 * Overrides {@link goog.proto2.Message#clone} to specify its exact return type.
 * @return {!sketchology.proto.Viewport} The cloned message.
 * @override
 */
sketchology.proto.Viewport.prototype.clone;


/**
 * Gets the value of the fbo_handle field.
 * @return {?number} The value.
 */
sketchology.proto.Viewport.prototype.getFboHandle = function() {
  return /** @type {?number} */ (this.get$Value(1));
};


/**
 * Gets the value of the fbo_handle field or the default value if not set.
 * @return {number} The value.
 */
sketchology.proto.Viewport.prototype.getFboHandleOrDefault = function() {
  return /** @type {number} */ (this.get$ValueOrDefault(1));
};


/**
 * Sets the value of the fbo_handle field.
 * @param {number} value The value.
 */
sketchology.proto.Viewport.prototype.setFboHandle = function(value) {
  this.set$Value(1, value);
};


/**
 * @return {boolean} Whether the fbo_handle field has a value.
 */
sketchology.proto.Viewport.prototype.hasFboHandle = function() {
  return this.has$Value(1);
};


/**
 * @return {number} The number of values in the fbo_handle field.
 */
sketchology.proto.Viewport.prototype.fboHandleCount = function() {
  return this.count$Values(1);
};


/**
 * Clears the values in the fbo_handle field.
 */
sketchology.proto.Viewport.prototype.clearFboHandle = function() {
  this.clear$Field(1);
};


/**
 * Gets the value of the width field.
 * @return {?number} The value.
 */
sketchology.proto.Viewport.prototype.getWidth = function() {
  return /** @type {?number} */ (this.get$Value(2));
};


/**
 * Gets the value of the width field or the default value if not set.
 * @return {number} The value.
 */
sketchology.proto.Viewport.prototype.getWidthOrDefault = function() {
  return /** @type {number} */ (this.get$ValueOrDefault(2));
};


/**
 * Sets the value of the width field.
 * @param {number} value The value.
 */
sketchology.proto.Viewport.prototype.setWidth = function(value) {
  this.set$Value(2, value);
};


/**
 * @return {boolean} Whether the width field has a value.
 */
sketchology.proto.Viewport.prototype.hasWidth = function() {
  return this.has$Value(2);
};


/**
 * @return {number} The number of values in the width field.
 */
sketchology.proto.Viewport.prototype.widthCount = function() {
  return this.count$Values(2);
};


/**
 * Clears the values in the width field.
 */
sketchology.proto.Viewport.prototype.clearWidth = function() {
  this.clear$Field(2);
};


/**
 * Gets the value of the height field.
 * @return {?number} The value.
 */
sketchology.proto.Viewport.prototype.getHeight = function() {
  return /** @type {?number} */ (this.get$Value(3));
};


/**
 * Gets the value of the height field or the default value if not set.
 * @return {number} The value.
 */
sketchology.proto.Viewport.prototype.getHeightOrDefault = function() {
  return /** @type {number} */ (this.get$ValueOrDefault(3));
};


/**
 * Sets the value of the height field.
 * @param {number} value The value.
 */
sketchology.proto.Viewport.prototype.setHeight = function(value) {
  this.set$Value(3, value);
};


/**
 * @return {boolean} Whether the height field has a value.
 */
sketchology.proto.Viewport.prototype.hasHeight = function() {
  return this.has$Value(3);
};


/**
 * @return {number} The number of values in the height field.
 */
sketchology.proto.Viewport.prototype.heightCount = function() {
  return this.count$Values(3);
};


/**
 * Clears the values in the height field.
 */
sketchology.proto.Viewport.prototype.clearHeight = function() {
  this.clear$Field(3);
};


/**
 * Gets the value of the ppi field.
 * @return {?number} The value.
 */
sketchology.proto.Viewport.prototype.getPpi = function() {
  return /** @type {?number} */ (this.get$Value(4));
};


/**
 * Gets the value of the ppi field or the default value if not set.
 * @return {number} The value.
 */
sketchology.proto.Viewport.prototype.getPpiOrDefault = function() {
  return /** @type {number} */ (this.get$ValueOrDefault(4));
};


/**
 * Sets the value of the ppi field.
 * @param {number} value The value.
 */
sketchology.proto.Viewport.prototype.setPpi = function(value) {
  this.set$Value(4, value);
};


/**
 * @return {boolean} Whether the ppi field has a value.
 */
sketchology.proto.Viewport.prototype.hasPpi = function() {
  return this.has$Value(4);
};


/**
 * @return {number} The number of values in the ppi field.
 */
sketchology.proto.Viewport.prototype.ppiCount = function() {
  return this.count$Values(4);
};


/**
 * Clears the values in the ppi field.
 */
sketchology.proto.Viewport.prototype.clearPpi = function() {
  this.clear$Field(4);
};



/**
 * Message ImageExport.
 * @constructor
 * @extends {goog.proto2.Message}
 * @final
 */
sketchology.proto.ImageExport = function() {
  goog.proto2.Message.call(this);
};
goog.inherits(sketchology.proto.ImageExport, goog.proto2.Message);


/**
 * Descriptor for this message, deserialized lazily in getDescriptor().
 * @private {?goog.proto2.Descriptor}
 */
sketchology.proto.ImageExport.descriptor_ = null;


/**
 * Overrides {@link goog.proto2.Message#clone} to specify its exact return type.
 * @return {!sketchology.proto.ImageExport} The cloned message.
 * @override
 */
sketchology.proto.ImageExport.prototype.clone;


/**
 * Gets the value of the max_dimension_px field.
 * @return {?number} The value.
 */
sketchology.proto.ImageExport.prototype.getMaxDimensionPx = function() {
  return /** @type {?number} */ (this.get$Value(1));
};


/**
 * Gets the value of the max_dimension_px field or the default value if not set.
 * @return {number} The value.
 */
sketchology.proto.ImageExport.prototype.getMaxDimensionPxOrDefault = function() {
  return /** @type {number} */ (this.get$ValueOrDefault(1));
};


/**
 * Sets the value of the max_dimension_px field.
 * @param {number} value The value.
 */
sketchology.proto.ImageExport.prototype.setMaxDimensionPx = function(value) {
  this.set$Value(1, value);
};


/**
 * @return {boolean} Whether the max_dimension_px field has a value.
 */
sketchology.proto.ImageExport.prototype.hasMaxDimensionPx = function() {
  return this.has$Value(1);
};


/**
 * @return {number} The number of values in the max_dimension_px field.
 */
sketchology.proto.ImageExport.prototype.maxDimensionPxCount = function() {
  return this.count$Values(1);
};


/**
 * Clears the values in the max_dimension_px field.
 */
sketchology.proto.ImageExport.prototype.clearMaxDimensionPx = function() {
  this.clear$Field(1);
};


/**
 * Gets the value of the should_draw_background field.
 * @return {?boolean} The value.
 */
sketchology.proto.ImageExport.prototype.getShouldDrawBackground = function() {
  return /** @type {?boolean} */ (this.get$Value(2));
};


/**
 * Gets the value of the should_draw_background field or the default value if not set.
 * @return {boolean} The value.
 */
sketchology.proto.ImageExport.prototype.getShouldDrawBackgroundOrDefault = function() {
  return /** @type {boolean} */ (this.get$ValueOrDefault(2));
};


/**
 * Sets the value of the should_draw_background field.
 * @param {boolean} value The value.
 */
sketchology.proto.ImageExport.prototype.setShouldDrawBackground = function(value) {
  this.set$Value(2, value);
};


/**
 * @return {boolean} Whether the should_draw_background field has a value.
 */
sketchology.proto.ImageExport.prototype.hasShouldDrawBackground = function() {
  return this.has$Value(2);
};


/**
 * @return {number} The number of values in the should_draw_background field.
 */
sketchology.proto.ImageExport.prototype.shouldDrawBackgroundCount = function() {
  return this.count$Values(2);
};


/**
 * Clears the values in the should_draw_background field.
 */
sketchology.proto.ImageExport.prototype.clearShouldDrawBackground = function() {
  this.clear$Field(2);
};



/**
 * Message LinearPathAnimation.
 * @constructor
 * @extends {goog.proto2.Message}
 * @final
 */
sketchology.proto.LinearPathAnimation = function() {
  goog.proto2.Message.call(this);
};
goog.inherits(sketchology.proto.LinearPathAnimation, goog.proto2.Message);


/**
 * Descriptor for this message, deserialized lazily in getDescriptor().
 * @private {?goog.proto2.Descriptor}
 */
sketchology.proto.LinearPathAnimation.descriptor_ = null;


/**
 * Overrides {@link goog.proto2.Message#clone} to specify its exact return type.
 * @return {!sketchology.proto.LinearPathAnimation} The cloned message.
 * @override
 */
sketchology.proto.LinearPathAnimation.prototype.clone;


/**
 * Gets the value of the rgba_from field.
 * @return {?number} The value.
 */
sketchology.proto.LinearPathAnimation.prototype.getRgbaFrom = function() {
  return /** @type {?number} */ (this.get$Value(1));
};


/**
 * Gets the value of the rgba_from field or the default value if not set.
 * @return {number} The value.
 */
sketchology.proto.LinearPathAnimation.prototype.getRgbaFromOrDefault = function() {
  return /** @type {number} */ (this.get$ValueOrDefault(1));
};


/**
 * Sets the value of the rgba_from field.
 * @param {number} value The value.
 */
sketchology.proto.LinearPathAnimation.prototype.setRgbaFrom = function(value) {
  this.set$Value(1, value);
};


/**
 * @return {boolean} Whether the rgba_from field has a value.
 */
sketchology.proto.LinearPathAnimation.prototype.hasRgbaFrom = function() {
  return this.has$Value(1);
};


/**
 * @return {number} The number of values in the rgba_from field.
 */
sketchology.proto.LinearPathAnimation.prototype.rgbaFromCount = function() {
  return this.count$Values(1);
};


/**
 * Clears the values in the rgba_from field.
 */
sketchology.proto.LinearPathAnimation.prototype.clearRgbaFrom = function() {
  this.clear$Field(1);
};


/**
 * Gets the value of the rgba_seconds field.
 * @return {?number} The value.
 */
sketchology.proto.LinearPathAnimation.prototype.getRgbaSeconds = function() {
  return /** @type {?number} */ (this.get$Value(2));
};


/**
 * Gets the value of the rgba_seconds field or the default value if not set.
 * @return {number} The value.
 */
sketchology.proto.LinearPathAnimation.prototype.getRgbaSecondsOrDefault = function() {
  return /** @type {number} */ (this.get$ValueOrDefault(2));
};


/**
 * Sets the value of the rgba_seconds field.
 * @param {number} value The value.
 */
sketchology.proto.LinearPathAnimation.prototype.setRgbaSeconds = function(value) {
  this.set$Value(2, value);
};


/**
 * @return {boolean} Whether the rgba_seconds field has a value.
 */
sketchology.proto.LinearPathAnimation.prototype.hasRgbaSeconds = function() {
  return this.has$Value(2);
};


/**
 * @return {number} The number of values in the rgba_seconds field.
 */
sketchology.proto.LinearPathAnimation.prototype.rgbaSecondsCount = function() {
  return this.count$Values(2);
};


/**
 * Clears the values in the rgba_seconds field.
 */
sketchology.proto.LinearPathAnimation.prototype.clearRgbaSeconds = function() {
  this.clear$Field(2);
};


/**
 * Gets the value of the dilation_from field.
 * @return {?number} The value.
 */
sketchology.proto.LinearPathAnimation.prototype.getDilationFrom = function() {
  return /** @type {?number} */ (this.get$Value(3));
};


/**
 * Gets the value of the dilation_from field or the default value if not set.
 * @return {number} The value.
 */
sketchology.proto.LinearPathAnimation.prototype.getDilationFromOrDefault = function() {
  return /** @type {number} */ (this.get$ValueOrDefault(3));
};


/**
 * Sets the value of the dilation_from field.
 * @param {number} value The value.
 */
sketchology.proto.LinearPathAnimation.prototype.setDilationFrom = function(value) {
  this.set$Value(3, value);
};


/**
 * @return {boolean} Whether the dilation_from field has a value.
 */
sketchology.proto.LinearPathAnimation.prototype.hasDilationFrom = function() {
  return this.has$Value(3);
};


/**
 * @return {number} The number of values in the dilation_from field.
 */
sketchology.proto.LinearPathAnimation.prototype.dilationFromCount = function() {
  return this.count$Values(3);
};


/**
 * Clears the values in the dilation_from field.
 */
sketchology.proto.LinearPathAnimation.prototype.clearDilationFrom = function() {
  this.clear$Field(3);
};


/**
 * Gets the value of the dilation_seconds field.
 * @return {?number} The value.
 */
sketchology.proto.LinearPathAnimation.prototype.getDilationSeconds = function() {
  return /** @type {?number} */ (this.get$Value(4));
};


/**
 * Gets the value of the dilation_seconds field or the default value if not set.
 * @return {number} The value.
 */
sketchology.proto.LinearPathAnimation.prototype.getDilationSecondsOrDefault = function() {
  return /** @type {number} */ (this.get$ValueOrDefault(4));
};


/**
 * Sets the value of the dilation_seconds field.
 * @param {number} value The value.
 */
sketchology.proto.LinearPathAnimation.prototype.setDilationSeconds = function(value) {
  this.set$Value(4, value);
};


/**
 * @return {boolean} Whether the dilation_seconds field has a value.
 */
sketchology.proto.LinearPathAnimation.prototype.hasDilationSeconds = function() {
  return this.has$Value(4);
};


/**
 * @return {number} The number of values in the dilation_seconds field.
 */
sketchology.proto.LinearPathAnimation.prototype.dilationSecondsCount = function() {
  return this.count$Values(4);
};


/**
 * Clears the values in the dilation_seconds field.
 */
sketchology.proto.LinearPathAnimation.prototype.clearDilationSeconds = function() {
  this.clear$Field(4);
};



/**
 * Message LineSize.
 * @constructor
 * @extends {goog.proto2.Message}
 * @final
 */
sketchology.proto.LineSize = function() {
  goog.proto2.Message.call(this);
};
goog.inherits(sketchology.proto.LineSize, goog.proto2.Message);


/**
 * Descriptor for this message, deserialized lazily in getDescriptor().
 * @private {?goog.proto2.Descriptor}
 */
sketchology.proto.LineSize.descriptor_ = null;


/**
 * Overrides {@link goog.proto2.Message#clone} to specify its exact return type.
 * @return {!sketchology.proto.LineSize} The cloned message.
 * @override
 */
sketchology.proto.LineSize.prototype.clone;


/**
 * Gets the value of the stroke_width field.
 * @return {?number} The value.
 */
sketchology.proto.LineSize.prototype.getStrokeWidth = function() {
  return /** @type {?number} */ (this.get$Value(7));
};


/**
 * Gets the value of the stroke_width field or the default value if not set.
 * @return {number} The value.
 */
sketchology.proto.LineSize.prototype.getStrokeWidthOrDefault = function() {
  return /** @type {number} */ (this.get$ValueOrDefault(7));
};


/**
 * Sets the value of the stroke_width field.
 * @param {number} value The value.
 */
sketchology.proto.LineSize.prototype.setStrokeWidth = function(value) {
  this.set$Value(7, value);
};


/**
 * @return {boolean} Whether the stroke_width field has a value.
 */
sketchology.proto.LineSize.prototype.hasStrokeWidth = function() {
  return this.has$Value(7);
};


/**
 * @return {number} The number of values in the stroke_width field.
 */
sketchology.proto.LineSize.prototype.strokeWidthCount = function() {
  return this.count$Values(7);
};


/**
 * Clears the values in the stroke_width field.
 */
sketchology.proto.LineSize.prototype.clearStrokeWidth = function() {
  this.clear$Field(7);
};


/**
 * Gets the value of the units field.
 * @return {?sketchology.proto.LineSize.SizeType} The value.
 */
sketchology.proto.LineSize.prototype.getUnits = function() {
  return /** @type {?sketchology.proto.LineSize.SizeType} */ (this.get$Value(8));
};


/**
 * Gets the value of the units field or the default value if not set.
 * @return {!sketchology.proto.LineSize.SizeType} The value.
 */
sketchology.proto.LineSize.prototype.getUnitsOrDefault = function() {
  return /** @type {!sketchology.proto.LineSize.SizeType} */ (this.get$ValueOrDefault(8));
};


/**
 * Sets the value of the units field.
 * @param {!sketchology.proto.LineSize.SizeType} value The value.
 */
sketchology.proto.LineSize.prototype.setUnits = function(value) {
  this.set$Value(8, value);
};


/**
 * @return {boolean} Whether the units field has a value.
 */
sketchology.proto.LineSize.prototype.hasUnits = function() {
  return this.has$Value(8);
};


/**
 * @return {number} The number of values in the units field.
 */
sketchology.proto.LineSize.prototype.unitsCount = function() {
  return this.count$Values(8);
};


/**
 * Clears the values in the units field.
 */
sketchology.proto.LineSize.prototype.clearUnits = function() {
  this.clear$Field(8);
};


/**
 * Enumeration SizeType.
 * @enum {number}
 */
sketchology.proto.LineSize.SizeType = {
  UNKNOWN_SIZE: 0,
  WORLD_UNITS: 1,
  POINTS: 2,
  ZOOM_INDEPENDENT_DP: 3,
  PERCENT_WORLD: 4,
  PERCENT_ZOOM_INDEPENDENT: 5
};



/**
 * Message PusherToolParams.
 * @constructor
 * @extends {goog.proto2.Message}
 * @final
 */
sketchology.proto.PusherToolParams = function() {
  goog.proto2.Message.call(this);
};
goog.inherits(sketchology.proto.PusherToolParams, goog.proto2.Message);


/**
 * Descriptor for this message, deserialized lazily in getDescriptor().
 * @private {?goog.proto2.Descriptor}
 */
sketchology.proto.PusherToolParams.descriptor_ = null;


/**
 * Overrides {@link goog.proto2.Message#clone} to specify its exact return type.
 * @return {!sketchology.proto.PusherToolParams} The cloned message.
 * @override
 */
sketchology.proto.PusherToolParams.prototype.clone;


/**
 * Gets the value of the manipulate_stickers field.
 * @return {?boolean} The value.
 */
sketchology.proto.PusherToolParams.prototype.getManipulateStickers = function() {
  return /** @type {?boolean} */ (this.get$Value(1));
};


/**
 * Gets the value of the manipulate_stickers field or the default value if not set.
 * @return {boolean} The value.
 */
sketchology.proto.PusherToolParams.prototype.getManipulateStickersOrDefault = function() {
  return /** @type {boolean} */ (this.get$ValueOrDefault(1));
};


/**
 * Sets the value of the manipulate_stickers field.
 * @param {boolean} value The value.
 */
sketchology.proto.PusherToolParams.prototype.setManipulateStickers = function(value) {
  this.set$Value(1, value);
};


/**
 * @return {boolean} Whether the manipulate_stickers field has a value.
 */
sketchology.proto.PusherToolParams.prototype.hasManipulateStickers = function() {
  return this.has$Value(1);
};


/**
 * @return {number} The number of values in the manipulate_stickers field.
 */
sketchology.proto.PusherToolParams.prototype.manipulateStickersCount = function() {
  return this.count$Values(1);
};


/**
 * Clears the values in the manipulate_stickers field.
 */
sketchology.proto.PusherToolParams.prototype.clearManipulateStickers = function() {
  this.clear$Field(1);
};


/**
 * Gets the value of the manipulate_text field.
 * @return {?boolean} The value.
 */
sketchology.proto.PusherToolParams.prototype.getManipulateText = function() {
  return /** @type {?boolean} */ (this.get$Value(2));
};


/**
 * Gets the value of the manipulate_text field or the default value if not set.
 * @return {boolean} The value.
 */
sketchology.proto.PusherToolParams.prototype.getManipulateTextOrDefault = function() {
  return /** @type {boolean} */ (this.get$ValueOrDefault(2));
};


/**
 * Sets the value of the manipulate_text field.
 * @param {boolean} value The value.
 */
sketchology.proto.PusherToolParams.prototype.setManipulateText = function(value) {
  this.set$Value(2, value);
};


/**
 * @return {boolean} Whether the manipulate_text field has a value.
 */
sketchology.proto.PusherToolParams.prototype.hasManipulateText = function() {
  return this.has$Value(2);
};


/**
 * @return {number} The number of values in the manipulate_text field.
 */
sketchology.proto.PusherToolParams.prototype.manipulateTextCount = function() {
  return this.count$Values(2);
};


/**
 * Clears the values in the manipulate_text field.
 */
sketchology.proto.PusherToolParams.prototype.clearManipulateText = function() {
  this.clear$Field(2);
};



/**
 * Message ToolParams.
 * @constructor
 * @extends {goog.proto2.Message}
 * @final
 */
sketchology.proto.ToolParams = function() {
  goog.proto2.Message.call(this);
};
goog.inherits(sketchology.proto.ToolParams, goog.proto2.Message);


/**
 * Descriptor for this message, deserialized lazily in getDescriptor().
 * @private {?goog.proto2.Descriptor}
 */
sketchology.proto.ToolParams.descriptor_ = null;


/**
 * Overrides {@link goog.proto2.Message#clone} to specify its exact return type.
 * @return {!sketchology.proto.ToolParams} The cloned message.
 * @override
 */
sketchology.proto.ToolParams.prototype.clone;


/**
 * Gets the value of the tool field.
 * @return {?sketchology.proto.ToolParams.ToolType} The value.
 */
sketchology.proto.ToolParams.prototype.getTool = function() {
  return /** @type {?sketchology.proto.ToolParams.ToolType} */ (this.get$Value(1));
};


/**
 * Gets the value of the tool field or the default value if not set.
 * @return {!sketchology.proto.ToolParams.ToolType} The value.
 */
sketchology.proto.ToolParams.prototype.getToolOrDefault = function() {
  return /** @type {!sketchology.proto.ToolParams.ToolType} */ (this.get$ValueOrDefault(1));
};


/**
 * Sets the value of the tool field.
 * @param {!sketchology.proto.ToolParams.ToolType} value The value.
 */
sketchology.proto.ToolParams.prototype.setTool = function(value) {
  this.set$Value(1, value);
};


/**
 * @return {boolean} Whether the tool field has a value.
 */
sketchology.proto.ToolParams.prototype.hasTool = function() {
  return this.has$Value(1);
};


/**
 * @return {number} The number of values in the tool field.
 */
sketchology.proto.ToolParams.prototype.toolCount = function() {
  return this.count$Values(1);
};


/**
 * Clears the values in the tool field.
 */
sketchology.proto.ToolParams.prototype.clearTool = function() {
  this.clear$Field(1);
};


/**
 * Gets the value of the rgba field.
 * @return {?number} The value.
 */
sketchology.proto.ToolParams.prototype.getRgba = function() {
  return /** @type {?number} */ (this.get$Value(2));
};


/**
 * Gets the value of the rgba field or the default value if not set.
 * @return {number} The value.
 */
sketchology.proto.ToolParams.prototype.getRgbaOrDefault = function() {
  return /** @type {number} */ (this.get$ValueOrDefault(2));
};


/**
 * Sets the value of the rgba field.
 * @param {number} value The value.
 */
sketchology.proto.ToolParams.prototype.setRgba = function(value) {
  this.set$Value(2, value);
};


/**
 * @return {boolean} Whether the rgba field has a value.
 */
sketchology.proto.ToolParams.prototype.hasRgba = function() {
  return this.has$Value(2);
};


/**
 * @return {number} The number of values in the rgba field.
 */
sketchology.proto.ToolParams.prototype.rgbaCount = function() {
  return this.count$Values(2);
};


/**
 * Clears the values in the rgba field.
 */
sketchology.proto.ToolParams.prototype.clearRgba = function() {
  this.clear$Field(2);
};


/**
 * Gets the value of the line_size field.
 * @return {?sketchology.proto.LineSize} The value.
 */
sketchology.proto.ToolParams.prototype.getLineSize = function() {
  return /** @type {?sketchology.proto.LineSize} */ (this.get$Value(3));
};


/**
 * Gets the value of the line_size field or the default value if not set.
 * @return {!sketchology.proto.LineSize} The value.
 */
sketchology.proto.ToolParams.prototype.getLineSizeOrDefault = function() {
  return /** @type {!sketchology.proto.LineSize} */ (this.get$ValueOrDefault(3));
};


/**
 * Sets the value of the line_size field.
 * @param {!sketchology.proto.LineSize} value The value.
 */
sketchology.proto.ToolParams.prototype.setLineSize = function(value) {
  this.set$Value(3, value);
};


/**
 * @return {boolean} Whether the line_size field has a value.
 */
sketchology.proto.ToolParams.prototype.hasLineSize = function() {
  return this.has$Value(3);
};


/**
 * @return {number} The number of values in the line_size field.
 */
sketchology.proto.ToolParams.prototype.lineSizeCount = function() {
  return this.count$Values(3);
};


/**
 * Clears the values in the line_size field.
 */
sketchology.proto.ToolParams.prototype.clearLineSize = function() {
  this.clear$Field(3);
};


/**
 * Gets the value of the pusher_tool_params field.
 * @return {?sketchology.proto.PusherToolParams} The value.
 */
sketchology.proto.ToolParams.prototype.getPusherToolParams = function() {
  return /** @type {?sketchology.proto.PusherToolParams} */ (this.get$Value(4));
};


/**
 * Gets the value of the pusher_tool_params field or the default value if not set.
 * @return {!sketchology.proto.PusherToolParams} The value.
 */
sketchology.proto.ToolParams.prototype.getPusherToolParamsOrDefault = function() {
  return /** @type {!sketchology.proto.PusherToolParams} */ (this.get$ValueOrDefault(4));
};


/**
 * Sets the value of the pusher_tool_params field.
 * @param {!sketchology.proto.PusherToolParams} value The value.
 */
sketchology.proto.ToolParams.prototype.setPusherToolParams = function(value) {
  this.set$Value(4, value);
};


/**
 * @return {boolean} Whether the pusher_tool_params field has a value.
 */
sketchology.proto.ToolParams.prototype.hasPusherToolParams = function() {
  return this.has$Value(4);
};


/**
 * @return {number} The number of values in the pusher_tool_params field.
 */
sketchology.proto.ToolParams.prototype.pusherToolParamsCount = function() {
  return this.count$Values(4);
};


/**
 * Clears the values in the pusher_tool_params field.
 */
sketchology.proto.ToolParams.prototype.clearPusherToolParams = function() {
  this.clear$Field(4);
};


/**
 * Gets the value of the brush_type field.
 * @return {?sketchology.proto.BrushType} The value.
 */
sketchology.proto.ToolParams.prototype.getBrushType = function() {
  return /** @type {?sketchology.proto.BrushType} */ (this.get$Value(5));
};


/**
 * Gets the value of the brush_type field or the default value if not set.
 * @return {!sketchology.proto.BrushType} The value.
 */
sketchology.proto.ToolParams.prototype.getBrushTypeOrDefault = function() {
  return /** @type {!sketchology.proto.BrushType} */ (this.get$ValueOrDefault(5));
};


/**
 * Sets the value of the brush_type field.
 * @param {!sketchology.proto.BrushType} value The value.
 */
sketchology.proto.ToolParams.prototype.setBrushType = function(value) {
  this.set$Value(5, value);
};


/**
 * @return {boolean} Whether the brush_type field has a value.
 */
sketchology.proto.ToolParams.prototype.hasBrushType = function() {
  return this.has$Value(5);
};


/**
 * @return {number} The number of values in the brush_type field.
 */
sketchology.proto.ToolParams.prototype.brushTypeCount = function() {
  return this.count$Values(5);
};


/**
 * Clears the values in the brush_type field.
 */
sketchology.proto.ToolParams.prototype.clearBrushType = function() {
  this.clear$Field(5);
};


/**
 * Gets the value of the linear_path_animation field.
 * @return {?sketchology.proto.LinearPathAnimation} The value.
 */
sketchology.proto.ToolParams.prototype.getLinearPathAnimation = function() {
  return /** @type {?sketchology.proto.LinearPathAnimation} */ (this.get$Value(6));
};


/**
 * Gets the value of the linear_path_animation field or the default value if not set.
 * @return {!sketchology.proto.LinearPathAnimation} The value.
 */
sketchology.proto.ToolParams.prototype.getLinearPathAnimationOrDefault = function() {
  return /** @type {!sketchology.proto.LinearPathAnimation} */ (this.get$ValueOrDefault(6));
};


/**
 * Sets the value of the linear_path_animation field.
 * @param {!sketchology.proto.LinearPathAnimation} value The value.
 */
sketchology.proto.ToolParams.prototype.setLinearPathAnimation = function(value) {
  this.set$Value(6, value);
};


/**
 * @return {boolean} Whether the linear_path_animation field has a value.
 */
sketchology.proto.ToolParams.prototype.hasLinearPathAnimation = function() {
  return this.has$Value(6);
};


/**
 * @return {number} The number of values in the linear_path_animation field.
 */
sketchology.proto.ToolParams.prototype.linearPathAnimationCount = function() {
  return this.count$Values(6);
};


/**
 * Clears the values in the linear_path_animation field.
 */
sketchology.proto.ToolParams.prototype.clearLinearPathAnimation = function() {
  this.clear$Field(6);
};


/**
 * Enumeration ToolType.
 * @enum {number}
 */
sketchology.proto.ToolParams.ToolType = {
  UNKNOWN: 0,
  LINE: 1,
  EDIT: 2,
  MAGIC_ERASE: 3,
  QUERY: 4,
  NOTOOL: 5,
  FILTER_CHOOSER: 6,
  PUSHER: 7,
  CROP: 8
};



/**
 * Message FlagAssignment.
 * @constructor
 * @extends {goog.proto2.Message}
 * @final
 */
sketchology.proto.FlagAssignment = function() {
  goog.proto2.Message.call(this);
};
goog.inherits(sketchology.proto.FlagAssignment, goog.proto2.Message);


/**
 * Descriptor for this message, deserialized lazily in getDescriptor().
 * @private {?goog.proto2.Descriptor}
 */
sketchology.proto.FlagAssignment.descriptor_ = null;


/**
 * Overrides {@link goog.proto2.Message#clone} to specify its exact return type.
 * @return {!sketchology.proto.FlagAssignment} The cloned message.
 * @override
 */
sketchology.proto.FlagAssignment.prototype.clone;


/**
 * Gets the value of the flag field.
 * @return {?sketchology.proto.Flag} The value.
 */
sketchology.proto.FlagAssignment.prototype.getFlag = function() {
  return /** @type {?sketchology.proto.Flag} */ (this.get$Value(1));
};


/**
 * Gets the value of the flag field or the default value if not set.
 * @return {!sketchology.proto.Flag} The value.
 */
sketchology.proto.FlagAssignment.prototype.getFlagOrDefault = function() {
  return /** @type {!sketchology.proto.Flag} */ (this.get$ValueOrDefault(1));
};


/**
 * Sets the value of the flag field.
 * @param {!sketchology.proto.Flag} value The value.
 */
sketchology.proto.FlagAssignment.prototype.setFlag = function(value) {
  this.set$Value(1, value);
};


/**
 * @return {boolean} Whether the flag field has a value.
 */
sketchology.proto.FlagAssignment.prototype.hasFlag = function() {
  return this.has$Value(1);
};


/**
 * @return {number} The number of values in the flag field.
 */
sketchology.proto.FlagAssignment.prototype.flagCount = function() {
  return this.count$Values(1);
};


/**
 * Clears the values in the flag field.
 */
sketchology.proto.FlagAssignment.prototype.clearFlag = function() {
  this.clear$Field(1);
};


/**
 * Gets the value of the bool_value field.
 * @return {?boolean} The value.
 */
sketchology.proto.FlagAssignment.prototype.getBoolValue = function() {
  return /** @type {?boolean} */ (this.get$Value(2));
};


/**
 * Gets the value of the bool_value field or the default value if not set.
 * @return {boolean} The value.
 */
sketchology.proto.FlagAssignment.prototype.getBoolValueOrDefault = function() {
  return /** @type {boolean} */ (this.get$ValueOrDefault(2));
};


/**
 * Sets the value of the bool_value field.
 * @param {boolean} value The value.
 */
sketchology.proto.FlagAssignment.prototype.setBoolValue = function(value) {
  this.set$Value(2, value);
};


/**
 * @return {boolean} Whether the bool_value field has a value.
 */
sketchology.proto.FlagAssignment.prototype.hasBoolValue = function() {
  return this.has$Value(2);
};


/**
 * @return {number} The number of values in the bool_value field.
 */
sketchology.proto.FlagAssignment.prototype.boolValueCount = function() {
  return this.count$Values(2);
};


/**
 * Clears the values in the bool_value field.
 */
sketchology.proto.FlagAssignment.prototype.clearBoolValue = function() {
  this.clear$Field(2);
};



/**
 * Message AddElement.
 * @constructor
 * @extends {goog.proto2.Message}
 * @final
 */
sketchology.proto.AddElement = function() {
  goog.proto2.Message.call(this);
};
goog.inherits(sketchology.proto.AddElement, goog.proto2.Message);


/**
 * Descriptor for this message, deserialized lazily in getDescriptor().
 * @private {?goog.proto2.Descriptor}
 */
sketchology.proto.AddElement.descriptor_ = null;


/**
 * Overrides {@link goog.proto2.Message#clone} to specify its exact return type.
 * @return {!sketchology.proto.AddElement} The cloned message.
 * @override
 */
sketchology.proto.AddElement.prototype.clone;


/**
 * Gets the value of the bundle field.
 * @return {?sketchology.proto.ElementBundle} The value.
 */
sketchology.proto.AddElement.prototype.getBundle = function() {
  return /** @type {?sketchology.proto.ElementBundle} */ (this.get$Value(1));
};


/**
 * Gets the value of the bundle field or the default value if not set.
 * @return {!sketchology.proto.ElementBundle} The value.
 */
sketchology.proto.AddElement.prototype.getBundleOrDefault = function() {
  return /** @type {!sketchology.proto.ElementBundle} */ (this.get$ValueOrDefault(1));
};


/**
 * Sets the value of the bundle field.
 * @param {!sketchology.proto.ElementBundle} value The value.
 */
sketchology.proto.AddElement.prototype.setBundle = function(value) {
  this.set$Value(1, value);
};


/**
 * @return {boolean} Whether the bundle field has a value.
 */
sketchology.proto.AddElement.prototype.hasBundle = function() {
  return this.has$Value(1);
};


/**
 * @return {number} The number of values in the bundle field.
 */
sketchology.proto.AddElement.prototype.bundleCount = function() {
  return this.count$Values(1);
};


/**
 * Clears the values in the bundle field.
 */
sketchology.proto.AddElement.prototype.clearBundle = function() {
  this.clear$Field(1);
};


/**
 * Gets the value of the below_element_with_uuid field.
 * @return {?string} The value.
 */
sketchology.proto.AddElement.prototype.getBelowElementWithUuid = function() {
  return /** @type {?string} */ (this.get$Value(2));
};


/**
 * Gets the value of the below_element_with_uuid field or the default value if not set.
 * @return {string} The value.
 */
sketchology.proto.AddElement.prototype.getBelowElementWithUuidOrDefault = function() {
  return /** @type {string} */ (this.get$ValueOrDefault(2));
};


/**
 * Sets the value of the below_element_with_uuid field.
 * @param {string} value The value.
 */
sketchology.proto.AddElement.prototype.setBelowElementWithUuid = function(value) {
  this.set$Value(2, value);
};


/**
 * @return {boolean} Whether the below_element_with_uuid field has a value.
 */
sketchology.proto.AddElement.prototype.hasBelowElementWithUuid = function() {
  return this.has$Value(2);
};


/**
 * @return {number} The number of values in the below_element_with_uuid field.
 */
sketchology.proto.AddElement.prototype.belowElementWithUuidCount = function() {
  return this.count$Values(2);
};


/**
 * Clears the values in the below_element_with_uuid field.
 */
sketchology.proto.AddElement.prototype.clearBelowElementWithUuid = function() {
  this.clear$Field(2);
};



/**
 * Message OutOfBoundsColor.
 * @constructor
 * @extends {goog.proto2.Message}
 * @final
 */
sketchology.proto.OutOfBoundsColor = function() {
  goog.proto2.Message.call(this);
};
goog.inherits(sketchology.proto.OutOfBoundsColor, goog.proto2.Message);


/**
 * Descriptor for this message, deserialized lazily in getDescriptor().
 * @private {?goog.proto2.Descriptor}
 */
sketchology.proto.OutOfBoundsColor.descriptor_ = null;


/**
 * Overrides {@link goog.proto2.Message#clone} to specify its exact return type.
 * @return {!sketchology.proto.OutOfBoundsColor} The cloned message.
 * @override
 */
sketchology.proto.OutOfBoundsColor.prototype.clone;


/**
 * Gets the value of the rgba field.
 * @return {?number} The value.
 */
sketchology.proto.OutOfBoundsColor.prototype.getRgba = function() {
  return /** @type {?number} */ (this.get$Value(1));
};


/**
 * Gets the value of the rgba field or the default value if not set.
 * @return {number} The value.
 */
sketchology.proto.OutOfBoundsColor.prototype.getRgbaOrDefault = function() {
  return /** @type {number} */ (this.get$ValueOrDefault(1));
};


/**
 * Sets the value of the rgba field.
 * @param {number} value The value.
 */
sketchology.proto.OutOfBoundsColor.prototype.setRgba = function(value) {
  this.set$Value(1, value);
};


/**
 * @return {boolean} Whether the rgba field has a value.
 */
sketchology.proto.OutOfBoundsColor.prototype.hasRgba = function() {
  return this.has$Value(1);
};


/**
 * @return {number} The number of values in the rgba field.
 */
sketchology.proto.OutOfBoundsColor.prototype.rgbaCount = function() {
  return this.count$Values(1);
};


/**
 * Clears the values in the rgba field.
 */
sketchology.proto.OutOfBoundsColor.prototype.clearRgba = function() {
  this.clear$Field(1);
};



/**
 * Message SInputStream.
 * @constructor
 * @extends {goog.proto2.Message}
 * @final
 */
sketchology.proto.SInputStream = function() {
  goog.proto2.Message.call(this);
};
goog.inherits(sketchology.proto.SInputStream, goog.proto2.Message);


/**
 * Descriptor for this message, deserialized lazily in getDescriptor().
 * @private {?goog.proto2.Descriptor}
 */
sketchology.proto.SInputStream.descriptor_ = null;


/**
 * Overrides {@link goog.proto2.Message#clone} to specify its exact return type.
 * @return {!sketchology.proto.SInputStream} The cloned message.
 * @override
 */
sketchology.proto.SInputStream.prototype.clone;


/**
 * Gets the value of the screen_width field.
 * @return {?number} The value.
 */
sketchology.proto.SInputStream.prototype.getScreenWidth = function() {
  return /** @type {?number} */ (this.get$Value(1));
};


/**
 * Gets the value of the screen_width field or the default value if not set.
 * @return {number} The value.
 */
sketchology.proto.SInputStream.prototype.getScreenWidthOrDefault = function() {
  return /** @type {number} */ (this.get$ValueOrDefault(1));
};


/**
 * Sets the value of the screen_width field.
 * @param {number} value The value.
 */
sketchology.proto.SInputStream.prototype.setScreenWidth = function(value) {
  this.set$Value(1, value);
};


/**
 * @return {boolean} Whether the screen_width field has a value.
 */
sketchology.proto.SInputStream.prototype.hasScreenWidth = function() {
  return this.has$Value(1);
};


/**
 * @return {number} The number of values in the screen_width field.
 */
sketchology.proto.SInputStream.prototype.screenWidthCount = function() {
  return this.count$Values(1);
};


/**
 * Clears the values in the screen_width field.
 */
sketchology.proto.SInputStream.prototype.clearScreenWidth = function() {
  this.clear$Field(1);
};


/**
 * Gets the value of the screen_height field.
 * @return {?number} The value.
 */
sketchology.proto.SInputStream.prototype.getScreenHeight = function() {
  return /** @type {?number} */ (this.get$Value(2));
};


/**
 * Gets the value of the screen_height field or the default value if not set.
 * @return {number} The value.
 */
sketchology.proto.SInputStream.prototype.getScreenHeightOrDefault = function() {
  return /** @type {number} */ (this.get$ValueOrDefault(2));
};


/**
 * Sets the value of the screen_height field.
 * @param {number} value The value.
 */
sketchology.proto.SInputStream.prototype.setScreenHeight = function(value) {
  this.set$Value(2, value);
};


/**
 * @return {boolean} Whether the screen_height field has a value.
 */
sketchology.proto.SInputStream.prototype.hasScreenHeight = function() {
  return this.has$Value(2);
};


/**
 * @return {number} The number of values in the screen_height field.
 */
sketchology.proto.SInputStream.prototype.screenHeightCount = function() {
  return this.count$Values(2);
};


/**
 * Clears the values in the screen_height field.
 */
sketchology.proto.SInputStream.prototype.clearScreenHeight = function() {
  this.clear$Field(2);
};


/**
 * Gets the value of the screen_ppi field.
 * @return {?number} The value.
 */
sketchology.proto.SInputStream.prototype.getScreenPpi = function() {
  return /** @type {?number} */ (this.get$Value(3));
};


/**
 * Gets the value of the screen_ppi field or the default value if not set.
 * @return {number} The value.
 */
sketchology.proto.SInputStream.prototype.getScreenPpiOrDefault = function() {
  return /** @type {number} */ (this.get$ValueOrDefault(3));
};


/**
 * Sets the value of the screen_ppi field.
 * @param {number} value The value.
 */
sketchology.proto.SInputStream.prototype.setScreenPpi = function(value) {
  this.set$Value(3, value);
};


/**
 * @return {boolean} Whether the screen_ppi field has a value.
 */
sketchology.proto.SInputStream.prototype.hasScreenPpi = function() {
  return this.has$Value(3);
};


/**
 * @return {number} The number of values in the screen_ppi field.
 */
sketchology.proto.SInputStream.prototype.screenPpiCount = function() {
  return this.count$Values(3);
};


/**
 * Clears the values in the screen_ppi field.
 */
sketchology.proto.SInputStream.prototype.clearScreenPpi = function() {
  this.clear$Field(3);
};


/**
 * Gets the value of the input field at the index given.
 * @param {number} index The index to lookup.
 * @return {?sketchology.proto.SInput} The value.
 */
sketchology.proto.SInputStream.prototype.getInput = function(index) {
  return /** @type {?sketchology.proto.SInput} */ (this.get$Value(4, index));
};


/**
 * Gets the value of the input field at the index given or the default value if not set.
 * @param {number} index The index to lookup.
 * @return {!sketchology.proto.SInput} The value.
 */
sketchology.proto.SInputStream.prototype.getInputOrDefault = function(index) {
  return /** @type {!sketchology.proto.SInput} */ (this.get$ValueOrDefault(4, index));
};


/**
 * Adds a value to the input field.
 * @param {!sketchology.proto.SInput} value The value to add.
 */
sketchology.proto.SInputStream.prototype.addInput = function(value) {
  this.add$Value(4, value);
};


/**
 * Returns the array of values in the input field.
 * @return {!Array<!sketchology.proto.SInput>} The values in the field.
 */
sketchology.proto.SInputStream.prototype.inputArray = function() {
  return /** @type {!Array<!sketchology.proto.SInput>} */ (this.array$Values(4));
};


/**
 * @return {boolean} Whether the input field has a value.
 */
sketchology.proto.SInputStream.prototype.hasInput = function() {
  return this.has$Value(4);
};


/**
 * @return {number} The number of values in the input field.
 */
sketchology.proto.SInputStream.prototype.inputCount = function() {
  return this.count$Values(4);
};


/**
 * Clears the values in the input field.
 */
sketchology.proto.SInputStream.prototype.clearInput = function() {
  this.clear$Field(4);
};



/**
 * Message SInput.
 * @constructor
 * @extends {goog.proto2.Message}
 * @final
 */
sketchology.proto.SInput = function() {
  goog.proto2.Message.call(this);
};
goog.inherits(sketchology.proto.SInput, goog.proto2.Message);


/**
 * Descriptor for this message, deserialized lazily in getDescriptor().
 * @private {?goog.proto2.Descriptor}
 */
sketchology.proto.SInput.descriptor_ = null;


/**
 * Overrides {@link goog.proto2.Message#clone} to specify its exact return type.
 * @return {!sketchology.proto.SInput} The cloned message.
 * @override
 */
sketchology.proto.SInput.prototype.clone;


/**
 * Gets the value of the type field.
 * @return {?sketchology.proto.SInput.InputType} The value.
 */
sketchology.proto.SInput.prototype.getType = function() {
  return /** @type {?sketchology.proto.SInput.InputType} */ (this.get$Value(1));
};


/**
 * Gets the value of the type field or the default value if not set.
 * @return {!sketchology.proto.SInput.InputType} The value.
 */
sketchology.proto.SInput.prototype.getTypeOrDefault = function() {
  return /** @type {!sketchology.proto.SInput.InputType} */ (this.get$ValueOrDefault(1));
};


/**
 * Sets the value of the type field.
 * @param {!sketchology.proto.SInput.InputType} value The value.
 */
sketchology.proto.SInput.prototype.setType = function(value) {
  this.set$Value(1, value);
};


/**
 * @return {boolean} Whether the type field has a value.
 */
sketchology.proto.SInput.prototype.hasType = function() {
  return this.has$Value(1);
};


/**
 * @return {number} The number of values in the type field.
 */
sketchology.proto.SInput.prototype.typeCount = function() {
  return this.count$Values(1);
};


/**
 * Clears the values in the type field.
 */
sketchology.proto.SInput.prototype.clearType = function() {
  this.clear$Field(1);
};


/**
 * Gets the value of the id field.
 * @return {?number} The value.
 */
sketchology.proto.SInput.prototype.getId = function() {
  return /** @type {?number} */ (this.get$Value(2));
};


/**
 * Gets the value of the id field or the default value if not set.
 * @return {number} The value.
 */
sketchology.proto.SInput.prototype.getIdOrDefault = function() {
  return /** @type {number} */ (this.get$ValueOrDefault(2));
};


/**
 * Sets the value of the id field.
 * @param {number} value The value.
 */
sketchology.proto.SInput.prototype.setId = function(value) {
  this.set$Value(2, value);
};


/**
 * @return {boolean} Whether the id field has a value.
 */
sketchology.proto.SInput.prototype.hasId = function() {
  return this.has$Value(2);
};


/**
 * @return {number} The number of values in the id field.
 */
sketchology.proto.SInput.prototype.idCount = function() {
  return this.count$Values(2);
};


/**
 * Clears the values in the id field.
 */
sketchology.proto.SInput.prototype.clearId = function() {
  this.clear$Field(2);
};


/**
 * Gets the value of the flags field.
 * @return {?number} The value.
 */
sketchology.proto.SInput.prototype.getFlags = function() {
  return /** @type {?number} */ (this.get$Value(3));
};


/**
 * Gets the value of the flags field or the default value if not set.
 * @return {number} The value.
 */
sketchology.proto.SInput.prototype.getFlagsOrDefault = function() {
  return /** @type {number} */ (this.get$ValueOrDefault(3));
};


/**
 * Sets the value of the flags field.
 * @param {number} value The value.
 */
sketchology.proto.SInput.prototype.setFlags = function(value) {
  this.set$Value(3, value);
};


/**
 * @return {boolean} Whether the flags field has a value.
 */
sketchology.proto.SInput.prototype.hasFlags = function() {
  return this.has$Value(3);
};


/**
 * @return {number} The number of values in the flags field.
 */
sketchology.proto.SInput.prototype.flagsCount = function() {
  return this.count$Values(3);
};


/**
 * Clears the values in the flags field.
 */
sketchology.proto.SInput.prototype.clearFlags = function() {
  this.clear$Field(3);
};


/**
 * Gets the value of the time_s field.
 * @return {?number} The value.
 */
sketchology.proto.SInput.prototype.getTimeS = function() {
  return /** @type {?number} */ (this.get$Value(4));
};


/**
 * Gets the value of the time_s field or the default value if not set.
 * @return {number} The value.
 */
sketchology.proto.SInput.prototype.getTimeSOrDefault = function() {
  return /** @type {number} */ (this.get$ValueOrDefault(4));
};


/**
 * Sets the value of the time_s field.
 * @param {number} value The value.
 */
sketchology.proto.SInput.prototype.setTimeS = function(value) {
  this.set$Value(4, value);
};


/**
 * @return {boolean} Whether the time_s field has a value.
 */
sketchology.proto.SInput.prototype.hasTimeS = function() {
  return this.has$Value(4);
};


/**
 * @return {number} The number of values in the time_s field.
 */
sketchology.proto.SInput.prototype.timeSCount = function() {
  return this.count$Values(4);
};


/**
 * Clears the values in the time_s field.
 */
sketchology.proto.SInput.prototype.clearTimeS = function() {
  this.clear$Field(4);
};


/**
 * Gets the value of the screen_pos_x field.
 * @return {?number} The value.
 */
sketchology.proto.SInput.prototype.getScreenPosX = function() {
  return /** @type {?number} */ (this.get$Value(5));
};


/**
 * Gets the value of the screen_pos_x field or the default value if not set.
 * @return {number} The value.
 */
sketchology.proto.SInput.prototype.getScreenPosXOrDefault = function() {
  return /** @type {number} */ (this.get$ValueOrDefault(5));
};


/**
 * Sets the value of the screen_pos_x field.
 * @param {number} value The value.
 */
sketchology.proto.SInput.prototype.setScreenPosX = function(value) {
  this.set$Value(5, value);
};


/**
 * @return {boolean} Whether the screen_pos_x field has a value.
 */
sketchology.proto.SInput.prototype.hasScreenPosX = function() {
  return this.has$Value(5);
};


/**
 * @return {number} The number of values in the screen_pos_x field.
 */
sketchology.proto.SInput.prototype.screenPosXCount = function() {
  return this.count$Values(5);
};


/**
 * Clears the values in the screen_pos_x field.
 */
sketchology.proto.SInput.prototype.clearScreenPosX = function() {
  this.clear$Field(5);
};


/**
 * Gets the value of the screen_pos_y field.
 * @return {?number} The value.
 */
sketchology.proto.SInput.prototype.getScreenPosY = function() {
  return /** @type {?number} */ (this.get$Value(6));
};


/**
 * Gets the value of the screen_pos_y field or the default value if not set.
 * @return {number} The value.
 */
sketchology.proto.SInput.prototype.getScreenPosYOrDefault = function() {
  return /** @type {number} */ (this.get$ValueOrDefault(6));
};


/**
 * Sets the value of the screen_pos_y field.
 * @param {number} value The value.
 */
sketchology.proto.SInput.prototype.setScreenPosY = function(value) {
  this.set$Value(6, value);
};


/**
 * @return {boolean} Whether the screen_pos_y field has a value.
 */
sketchology.proto.SInput.prototype.hasScreenPosY = function() {
  return this.has$Value(6);
};


/**
 * @return {number} The number of values in the screen_pos_y field.
 */
sketchology.proto.SInput.prototype.screenPosYCount = function() {
  return this.count$Values(6);
};


/**
 * Clears the values in the screen_pos_y field.
 */
sketchology.proto.SInput.prototype.clearScreenPosY = function() {
  this.clear$Field(6);
};


/**
 * Gets the value of the pressure field.
 * @return {?number} The value.
 */
sketchology.proto.SInput.prototype.getPressure = function() {
  return /** @type {?number} */ (this.get$Value(7));
};


/**
 * Gets the value of the pressure field or the default value if not set.
 * @return {number} The value.
 */
sketchology.proto.SInput.prototype.getPressureOrDefault = function() {
  return /** @type {number} */ (this.get$ValueOrDefault(7));
};


/**
 * Sets the value of the pressure field.
 * @param {number} value The value.
 */
sketchology.proto.SInput.prototype.setPressure = function(value) {
  this.set$Value(7, value);
};


/**
 * @return {boolean} Whether the pressure field has a value.
 */
sketchology.proto.SInput.prototype.hasPressure = function() {
  return this.has$Value(7);
};


/**
 * @return {number} The number of values in the pressure field.
 */
sketchology.proto.SInput.prototype.pressureCount = function() {
  return this.count$Values(7);
};


/**
 * Clears the values in the pressure field.
 */
sketchology.proto.SInput.prototype.clearPressure = function() {
  this.clear$Field(7);
};


/**
 * Gets the value of the wheel_delta field.
 * @return {?number} The value.
 */
sketchology.proto.SInput.prototype.getWheelDelta = function() {
  return /** @type {?number} */ (this.get$Value(8));
};


/**
 * Gets the value of the wheel_delta field or the default value if not set.
 * @return {number} The value.
 */
sketchology.proto.SInput.prototype.getWheelDeltaOrDefault = function() {
  return /** @type {number} */ (this.get$ValueOrDefault(8));
};


/**
 * Sets the value of the wheel_delta field.
 * @param {number} value The value.
 */
sketchology.proto.SInput.prototype.setWheelDelta = function(value) {
  this.set$Value(8, value);
};


/**
 * @return {boolean} Whether the wheel_delta field has a value.
 */
sketchology.proto.SInput.prototype.hasWheelDelta = function() {
  return this.has$Value(8);
};


/**
 * @return {number} The number of values in the wheel_delta field.
 */
sketchology.proto.SInput.prototype.wheelDeltaCount = function() {
  return this.count$Values(8);
};


/**
 * Clears the values in the wheel_delta field.
 */
sketchology.proto.SInput.prototype.clearWheelDelta = function() {
  this.clear$Field(8);
};


/**
 * Gets the value of the tilt field.
 * @return {?number} The value.
 */
sketchology.proto.SInput.prototype.getTilt = function() {
  return /** @type {?number} */ (this.get$Value(9));
};


/**
 * Gets the value of the tilt field or the default value if not set.
 * @return {number} The value.
 */
sketchology.proto.SInput.prototype.getTiltOrDefault = function() {
  return /** @type {number} */ (this.get$ValueOrDefault(9));
};


/**
 * Sets the value of the tilt field.
 * @param {number} value The value.
 */
sketchology.proto.SInput.prototype.setTilt = function(value) {
  this.set$Value(9, value);
};


/**
 * @return {boolean} Whether the tilt field has a value.
 */
sketchology.proto.SInput.prototype.hasTilt = function() {
  return this.has$Value(9);
};


/**
 * @return {number} The number of values in the tilt field.
 */
sketchology.proto.SInput.prototype.tiltCount = function() {
  return this.count$Values(9);
};


/**
 * Clears the values in the tilt field.
 */
sketchology.proto.SInput.prototype.clearTilt = function() {
  this.clear$Field(9);
};


/**
 * Gets the value of the orientation field.
 * @return {?number} The value.
 */
sketchology.proto.SInput.prototype.getOrientation = function() {
  return /** @type {?number} */ (this.get$Value(10));
};


/**
 * Gets the value of the orientation field or the default value if not set.
 * @return {number} The value.
 */
sketchology.proto.SInput.prototype.getOrientationOrDefault = function() {
  return /** @type {number} */ (this.get$ValueOrDefault(10));
};


/**
 * Sets the value of the orientation field.
 * @param {number} value The value.
 */
sketchology.proto.SInput.prototype.setOrientation = function(value) {
  this.set$Value(10, value);
};


/**
 * @return {boolean} Whether the orientation field has a value.
 */
sketchology.proto.SInput.prototype.hasOrientation = function() {
  return this.has$Value(10);
};


/**
 * @return {number} The number of values in the orientation field.
 */
sketchology.proto.SInput.prototype.orientationCount = function() {
  return this.count$Values(10);
};


/**
 * Clears the values in the orientation field.
 */
sketchology.proto.SInput.prototype.clearOrientation = function() {
  this.clear$Field(10);
};


/**
 * Enumeration InputType.
 * @enum {number}
 */
sketchology.proto.SInput.InputType = {
  UNKNOWN: 0,
  MOUSE: 1,
  TOUCH: 2,
  PEN: 3,
  ERASER: 4
};



/**
 * Message SimulatedInput.
 * @constructor
 * @extends {goog.proto2.Message}
 * @final
 */
sketchology.proto.SimulatedInput = function() {
  goog.proto2.Message.call(this);
};
goog.inherits(sketchology.proto.SimulatedInput, goog.proto2.Message);


/**
 * Descriptor for this message, deserialized lazily in getDescriptor().
 * @private {?goog.proto2.Descriptor}
 */
sketchology.proto.SimulatedInput.descriptor_ = null;


/**
 * Overrides {@link goog.proto2.Message#clone} to specify its exact return type.
 * @return {!sketchology.proto.SimulatedInput} The cloned message.
 * @override
 */
sketchology.proto.SimulatedInput.prototype.clone;


/**
 * Gets the value of the xs field at the index given.
 * @param {number} index The index to lookup.
 * @return {?number} The value.
 */
sketchology.proto.SimulatedInput.prototype.getXs = function(index) {
  return /** @type {?number} */ (this.get$Value(1, index));
};


/**
 * Gets the value of the xs field at the index given or the default value if not set.
 * @param {number} index The index to lookup.
 * @return {number} The value.
 */
sketchology.proto.SimulatedInput.prototype.getXsOrDefault = function(index) {
  return /** @type {number} */ (this.get$ValueOrDefault(1, index));
};


/**
 * Adds a value to the xs field.
 * @param {number} value The value to add.
 */
sketchology.proto.SimulatedInput.prototype.addXs = function(value) {
  this.add$Value(1, value);
};


/**
 * Returns the array of values in the xs field.
 * @return {!Array<number>} The values in the field.
 */
sketchology.proto.SimulatedInput.prototype.xsArray = function() {
  return /** @type {!Array<number>} */ (this.array$Values(1));
};


/**
 * @return {boolean} Whether the xs field has a value.
 */
sketchology.proto.SimulatedInput.prototype.hasXs = function() {
  return this.has$Value(1);
};


/**
 * @return {number} The number of values in the xs field.
 */
sketchology.proto.SimulatedInput.prototype.xsCount = function() {
  return this.count$Values(1);
};


/**
 * Clears the values in the xs field.
 */
sketchology.proto.SimulatedInput.prototype.clearXs = function() {
  this.clear$Field(1);
};


/**
 * Gets the value of the ys field at the index given.
 * @param {number} index The index to lookup.
 * @return {?number} The value.
 */
sketchology.proto.SimulatedInput.prototype.getYs = function(index) {
  return /** @type {?number} */ (this.get$Value(2, index));
};


/**
 * Gets the value of the ys field at the index given or the default value if not set.
 * @param {number} index The index to lookup.
 * @return {number} The value.
 */
sketchology.proto.SimulatedInput.prototype.getYsOrDefault = function(index) {
  return /** @type {number} */ (this.get$ValueOrDefault(2, index));
};


/**
 * Adds a value to the ys field.
 * @param {number} value The value to add.
 */
sketchology.proto.SimulatedInput.prototype.addYs = function(value) {
  this.add$Value(2, value);
};


/**
 * Returns the array of values in the ys field.
 * @return {!Array<number>} The values in the field.
 */
sketchology.proto.SimulatedInput.prototype.ysArray = function() {
  return /** @type {!Array<number>} */ (this.array$Values(2));
};


/**
 * @return {boolean} Whether the ys field has a value.
 */
sketchology.proto.SimulatedInput.prototype.hasYs = function() {
  return this.has$Value(2);
};


/**
 * @return {number} The number of values in the ys field.
 */
sketchology.proto.SimulatedInput.prototype.ysCount = function() {
  return this.count$Values(2);
};


/**
 * Clears the values in the ys field.
 */
sketchology.proto.SimulatedInput.prototype.clearYs = function() {
  this.clear$Field(2);
};


/**
 * Gets the value of the ts_secs field at the index given.
 * @param {number} index The index to lookup.
 * @return {?number} The value.
 */
sketchology.proto.SimulatedInput.prototype.getTsSecs = function(index) {
  return /** @type {?number} */ (this.get$Value(3, index));
};


/**
 * Gets the value of the ts_secs field at the index given or the default value if not set.
 * @param {number} index The index to lookup.
 * @return {number} The value.
 */
sketchology.proto.SimulatedInput.prototype.getTsSecsOrDefault = function(index) {
  return /** @type {number} */ (this.get$ValueOrDefault(3, index));
};


/**
 * Adds a value to the ts_secs field.
 * @param {number} value The value to add.
 */
sketchology.proto.SimulatedInput.prototype.addTsSecs = function(value) {
  this.add$Value(3, value);
};


/**
 * Returns the array of values in the ts_secs field.
 * @return {!Array<number>} The values in the field.
 */
sketchology.proto.SimulatedInput.prototype.tsSecsArray = function() {
  return /** @type {!Array<number>} */ (this.array$Values(3));
};


/**
 * @return {boolean} Whether the ts_secs field has a value.
 */
sketchology.proto.SimulatedInput.prototype.hasTsSecs = function() {
  return this.has$Value(3);
};


/**
 * @return {number} The number of values in the ts_secs field.
 */
sketchology.proto.SimulatedInput.prototype.tsSecsCount = function() {
  return this.count$Values(3);
};


/**
 * Clears the values in the ts_secs field.
 */
sketchology.proto.SimulatedInput.prototype.clearTsSecs = function() {
  this.clear$Field(3);
};


/**
 * Gets the value of the source_details field.
 * @return {?sketchology.proto.SourceDetails} The value.
 */
sketchology.proto.SimulatedInput.prototype.getSourceDetails = function() {
  return /** @type {?sketchology.proto.SourceDetails} */ (this.get$Value(4));
};


/**
 * Gets the value of the source_details field or the default value if not set.
 * @return {!sketchology.proto.SourceDetails} The value.
 */
sketchology.proto.SimulatedInput.prototype.getSourceDetailsOrDefault = function() {
  return /** @type {!sketchology.proto.SourceDetails} */ (this.get$ValueOrDefault(4));
};


/**
 * Sets the value of the source_details field.
 * @param {!sketchology.proto.SourceDetails} value The value.
 */
sketchology.proto.SimulatedInput.prototype.setSourceDetails = function(value) {
  this.set$Value(4, value);
};


/**
 * @return {boolean} Whether the source_details field has a value.
 */
sketchology.proto.SimulatedInput.prototype.hasSourceDetails = function() {
  return this.has$Value(4);
};


/**
 * @return {number} The number of values in the source_details field.
 */
sketchology.proto.SimulatedInput.prototype.sourceDetailsCount = function() {
  return this.count$Values(4);
};


/**
 * Clears the values in the source_details field.
 */
sketchology.proto.SimulatedInput.prototype.clearSourceDetails = function() {
  this.clear$Field(4);
};



/**
 * Message SequencePoint.
 * @constructor
 * @extends {goog.proto2.Message}
 * @final
 */
sketchology.proto.SequencePoint = function() {
  goog.proto2.Message.call(this);
};
goog.inherits(sketchology.proto.SequencePoint, goog.proto2.Message);


/**
 * Descriptor for this message, deserialized lazily in getDescriptor().
 * @private {?goog.proto2.Descriptor}
 */
sketchology.proto.SequencePoint.descriptor_ = null;


/**
 * Overrides {@link goog.proto2.Message#clone} to specify its exact return type.
 * @return {!sketchology.proto.SequencePoint} The cloned message.
 * @override
 */
sketchology.proto.SequencePoint.prototype.clone;


/**
 * Gets the value of the id field.
 * @return {?number} The value.
 */
sketchology.proto.SequencePoint.prototype.getId = function() {
  return /** @type {?number} */ (this.get$Value(1));
};


/**
 * Gets the value of the id field or the default value if not set.
 * @return {number} The value.
 */
sketchology.proto.SequencePoint.prototype.getIdOrDefault = function() {
  return /** @type {number} */ (this.get$ValueOrDefault(1));
};


/**
 * Sets the value of the id field.
 * @param {number} value The value.
 */
sketchology.proto.SequencePoint.prototype.setId = function(value) {
  this.set$Value(1, value);
};


/**
 * @return {boolean} Whether the id field has a value.
 */
sketchology.proto.SequencePoint.prototype.hasId = function() {
  return this.has$Value(1);
};


/**
 * @return {number} The number of values in the id field.
 */
sketchology.proto.SequencePoint.prototype.idCount = function() {
  return this.count$Values(1);
};


/**
 * Clears the values in the id field.
 */
sketchology.proto.SequencePoint.prototype.clearId = function() {
  this.clear$Field(1);
};



/**
 * Message SetCallbackFlags.
 * @constructor
 * @extends {goog.proto2.Message}
 * @final
 */
sketchology.proto.SetCallbackFlags = function() {
  goog.proto2.Message.call(this);
};
goog.inherits(sketchology.proto.SetCallbackFlags, goog.proto2.Message);


/**
 * Descriptor for this message, deserialized lazily in getDescriptor().
 * @private {?goog.proto2.Descriptor}
 */
sketchology.proto.SetCallbackFlags.descriptor_ = null;


/**
 * Overrides {@link goog.proto2.Message#clone} to specify its exact return type.
 * @return {!sketchology.proto.SetCallbackFlags} The cloned message.
 * @override
 */
sketchology.proto.SetCallbackFlags.prototype.clone;


/**
 * Gets the value of the source_details field.
 * @return {?sketchology.proto.SourceDetails} The value.
 */
sketchology.proto.SetCallbackFlags.prototype.getSourceDetails = function() {
  return /** @type {?sketchology.proto.SourceDetails} */ (this.get$Value(1));
};


/**
 * Gets the value of the source_details field or the default value if not set.
 * @return {!sketchology.proto.SourceDetails} The value.
 */
sketchology.proto.SetCallbackFlags.prototype.getSourceDetailsOrDefault = function() {
  return /** @type {!sketchology.proto.SourceDetails} */ (this.get$ValueOrDefault(1));
};


/**
 * Sets the value of the source_details field.
 * @param {!sketchology.proto.SourceDetails} value The value.
 */
sketchology.proto.SetCallbackFlags.prototype.setSourceDetails = function(value) {
  this.set$Value(1, value);
};


/**
 * @return {boolean} Whether the source_details field has a value.
 */
sketchology.proto.SetCallbackFlags.prototype.hasSourceDetails = function() {
  return this.has$Value(1);
};


/**
 * @return {number} The number of values in the source_details field.
 */
sketchology.proto.SetCallbackFlags.prototype.sourceDetailsCount = function() {
  return this.count$Values(1);
};


/**
 * Clears the values in the source_details field.
 */
sketchology.proto.SetCallbackFlags.prototype.clearSourceDetails = function() {
  this.clear$Field(1);
};


/**
 * Gets the value of the callback_flags field.
 * @return {?sketchology.proto.CallbackFlags} The value.
 */
sketchology.proto.SetCallbackFlags.prototype.getCallbackFlags = function() {
  return /** @type {?sketchology.proto.CallbackFlags} */ (this.get$Value(2));
};


/**
 * Gets the value of the callback_flags field or the default value if not set.
 * @return {!sketchology.proto.CallbackFlags} The value.
 */
sketchology.proto.SetCallbackFlags.prototype.getCallbackFlagsOrDefault = function() {
  return /** @type {!sketchology.proto.CallbackFlags} */ (this.get$ValueOrDefault(2));
};


/**
 * Sets the value of the callback_flags field.
 * @param {!sketchology.proto.CallbackFlags} value The value.
 */
sketchology.proto.SetCallbackFlags.prototype.setCallbackFlags = function(value) {
  this.set$Value(2, value);
};


/**
 * @return {boolean} Whether the callback_flags field has a value.
 */
sketchology.proto.SetCallbackFlags.prototype.hasCallbackFlags = function() {
  return this.has$Value(2);
};


/**
 * @return {number} The number of values in the callback_flags field.
 */
sketchology.proto.SetCallbackFlags.prototype.callbackFlagsCount = function() {
  return this.count$Values(2);
};


/**
 * Clears the values in the callback_flags field.
 */
sketchology.proto.SetCallbackFlags.prototype.clearCallbackFlags = function() {
  this.clear$Field(2);
};



/**
 * Message EngineState.
 * @constructor
 * @extends {goog.proto2.Message}
 * @final
 */
sketchology.proto.EngineState = function() {
  goog.proto2.Message.call(this);
};
goog.inherits(sketchology.proto.EngineState, goog.proto2.Message);


/**
 * Descriptor for this message, deserialized lazily in getDescriptor().
 * @private {?goog.proto2.Descriptor}
 */
sketchology.proto.EngineState.descriptor_ = null;


/**
 * Overrides {@link goog.proto2.Message#clone} to specify its exact return type.
 * @return {!sketchology.proto.EngineState} The cloned message.
 * @override
 */
sketchology.proto.EngineState.prototype.clone;


/**
 * Gets the value of the camera_position field.
 * @return {?sketchology.proto.Rect} The value.
 */
sketchology.proto.EngineState.prototype.getCameraPosition = function() {
  return /** @type {?sketchology.proto.Rect} */ (this.get$Value(1));
};


/**
 * Gets the value of the camera_position field or the default value if not set.
 * @return {!sketchology.proto.Rect} The value.
 */
sketchology.proto.EngineState.prototype.getCameraPositionOrDefault = function() {
  return /** @type {!sketchology.proto.Rect} */ (this.get$ValueOrDefault(1));
};


/**
 * Sets the value of the camera_position field.
 * @param {!sketchology.proto.Rect} value The value.
 */
sketchology.proto.EngineState.prototype.setCameraPosition = function(value) {
  this.set$Value(1, value);
};


/**
 * @return {boolean} Whether the camera_position field has a value.
 */
sketchology.proto.EngineState.prototype.hasCameraPosition = function() {
  return this.has$Value(1);
};


/**
 * @return {number} The number of values in the camera_position field.
 */
sketchology.proto.EngineState.prototype.cameraPositionCount = function() {
  return this.count$Values(1);
};


/**
 * Clears the values in the camera_position field.
 */
sketchology.proto.EngineState.prototype.clearCameraPosition = function() {
  this.clear$Field(1);
};


/**
 * Gets the value of the page_bounds field.
 * @return {?sketchology.proto.Rect} The value.
 */
sketchology.proto.EngineState.prototype.getPageBounds = function() {
  return /** @type {?sketchology.proto.Rect} */ (this.get$Value(2));
};


/**
 * Gets the value of the page_bounds field or the default value if not set.
 * @return {!sketchology.proto.Rect} The value.
 */
sketchology.proto.EngineState.prototype.getPageBoundsOrDefault = function() {
  return /** @type {!sketchology.proto.Rect} */ (this.get$ValueOrDefault(2));
};


/**
 * Sets the value of the page_bounds field.
 * @param {!sketchology.proto.Rect} value The value.
 */
sketchology.proto.EngineState.prototype.setPageBounds = function(value) {
  this.set$Value(2, value);
};


/**
 * @return {boolean} Whether the page_bounds field has a value.
 */
sketchology.proto.EngineState.prototype.hasPageBounds = function() {
  return this.has$Value(2);
};


/**
 * @return {number} The number of values in the page_bounds field.
 */
sketchology.proto.EngineState.prototype.pageBoundsCount = function() {
  return this.count$Values(2);
};


/**
 * Clears the values in the page_bounds field.
 */
sketchology.proto.EngineState.prototype.clearPageBounds = function() {
  this.clear$Field(2);
};


/**
 * Gets the value of the selection_is_live field.
 * @return {?boolean} The value.
 */
sketchology.proto.EngineState.prototype.getSelectionIsLive = function() {
  return /** @type {?boolean} */ (this.get$Value(3));
};


/**
 * Gets the value of the selection_is_live field or the default value if not set.
 * @return {boolean} The value.
 */
sketchology.proto.EngineState.prototype.getSelectionIsLiveOrDefault = function() {
  return /** @type {boolean} */ (this.get$ValueOrDefault(3));
};


/**
 * Sets the value of the selection_is_live field.
 * @param {boolean} value The value.
 */
sketchology.proto.EngineState.prototype.setSelectionIsLive = function(value) {
  this.set$Value(3, value);
};


/**
 * @return {boolean} Whether the selection_is_live field has a value.
 */
sketchology.proto.EngineState.prototype.hasSelectionIsLive = function() {
  return this.has$Value(3);
};


/**
 * @return {number} The number of values in the selection_is_live field.
 */
sketchology.proto.EngineState.prototype.selectionIsLiveCount = function() {
  return this.count$Values(3);
};


/**
 * Clears the values in the selection_is_live field.
 */
sketchology.proto.EngineState.prototype.clearSelectionIsLive = function() {
  this.clear$Field(3);
};



/**
 * Message CameraBoundsConfig.
 * @constructor
 * @extends {goog.proto2.Message}
 * @final
 */
sketchology.proto.CameraBoundsConfig = function() {
  goog.proto2.Message.call(this);
};
goog.inherits(sketchology.proto.CameraBoundsConfig, goog.proto2.Message);


/**
 * Descriptor for this message, deserialized lazily in getDescriptor().
 * @private {?goog.proto2.Descriptor}
 */
sketchology.proto.CameraBoundsConfig.descriptor_ = null;


/**
 * Overrides {@link goog.proto2.Message#clone} to specify its exact return type.
 * @return {!sketchology.proto.CameraBoundsConfig} The cloned message.
 * @override
 */
sketchology.proto.CameraBoundsConfig.prototype.clone;


/**
 * Gets the value of the margin_left_px field.
 * @return {?number} The value.
 */
sketchology.proto.CameraBoundsConfig.prototype.getMarginLeftPx = function() {
  return /** @type {?number} */ (this.get$Value(1));
};


/**
 * Gets the value of the margin_left_px field or the default value if not set.
 * @return {number} The value.
 */
sketchology.proto.CameraBoundsConfig.prototype.getMarginLeftPxOrDefault = function() {
  return /** @type {number} */ (this.get$ValueOrDefault(1));
};


/**
 * Sets the value of the margin_left_px field.
 * @param {number} value The value.
 */
sketchology.proto.CameraBoundsConfig.prototype.setMarginLeftPx = function(value) {
  this.set$Value(1, value);
};


/**
 * @return {boolean} Whether the margin_left_px field has a value.
 */
sketchology.proto.CameraBoundsConfig.prototype.hasMarginLeftPx = function() {
  return this.has$Value(1);
};


/**
 * @return {number} The number of values in the margin_left_px field.
 */
sketchology.proto.CameraBoundsConfig.prototype.marginLeftPxCount = function() {
  return this.count$Values(1);
};


/**
 * Clears the values in the margin_left_px field.
 */
sketchology.proto.CameraBoundsConfig.prototype.clearMarginLeftPx = function() {
  this.clear$Field(1);
};


/**
 * Gets the value of the margin_right_px field.
 * @return {?number} The value.
 */
sketchology.proto.CameraBoundsConfig.prototype.getMarginRightPx = function() {
  return /** @type {?number} */ (this.get$Value(2));
};


/**
 * Gets the value of the margin_right_px field or the default value if not set.
 * @return {number} The value.
 */
sketchology.proto.CameraBoundsConfig.prototype.getMarginRightPxOrDefault = function() {
  return /** @type {number} */ (this.get$ValueOrDefault(2));
};


/**
 * Sets the value of the margin_right_px field.
 * @param {number} value The value.
 */
sketchology.proto.CameraBoundsConfig.prototype.setMarginRightPx = function(value) {
  this.set$Value(2, value);
};


/**
 * @return {boolean} Whether the margin_right_px field has a value.
 */
sketchology.proto.CameraBoundsConfig.prototype.hasMarginRightPx = function() {
  return this.has$Value(2);
};


/**
 * @return {number} The number of values in the margin_right_px field.
 */
sketchology.proto.CameraBoundsConfig.prototype.marginRightPxCount = function() {
  return this.count$Values(2);
};


/**
 * Clears the values in the margin_right_px field.
 */
sketchology.proto.CameraBoundsConfig.prototype.clearMarginRightPx = function() {
  this.clear$Field(2);
};


/**
 * Gets the value of the margin_bottom_px field.
 * @return {?number} The value.
 */
sketchology.proto.CameraBoundsConfig.prototype.getMarginBottomPx = function() {
  return /** @type {?number} */ (this.get$Value(3));
};


/**
 * Gets the value of the margin_bottom_px field or the default value if not set.
 * @return {number} The value.
 */
sketchology.proto.CameraBoundsConfig.prototype.getMarginBottomPxOrDefault = function() {
  return /** @type {number} */ (this.get$ValueOrDefault(3));
};


/**
 * Sets the value of the margin_bottom_px field.
 * @param {number} value The value.
 */
sketchology.proto.CameraBoundsConfig.prototype.setMarginBottomPx = function(value) {
  this.set$Value(3, value);
};


/**
 * @return {boolean} Whether the margin_bottom_px field has a value.
 */
sketchology.proto.CameraBoundsConfig.prototype.hasMarginBottomPx = function() {
  return this.has$Value(3);
};


/**
 * @return {number} The number of values in the margin_bottom_px field.
 */
sketchology.proto.CameraBoundsConfig.prototype.marginBottomPxCount = function() {
  return this.count$Values(3);
};


/**
 * Clears the values in the margin_bottom_px field.
 */
sketchology.proto.CameraBoundsConfig.prototype.clearMarginBottomPx = function() {
  this.clear$Field(3);
};


/**
 * Gets the value of the margin_top_px field.
 * @return {?number} The value.
 */
sketchology.proto.CameraBoundsConfig.prototype.getMarginTopPx = function() {
  return /** @type {?number} */ (this.get$Value(4));
};


/**
 * Gets the value of the margin_top_px field or the default value if not set.
 * @return {number} The value.
 */
sketchology.proto.CameraBoundsConfig.prototype.getMarginTopPxOrDefault = function() {
  return /** @type {number} */ (this.get$ValueOrDefault(4));
};


/**
 * Sets the value of the margin_top_px field.
 * @param {number} value The value.
 */
sketchology.proto.CameraBoundsConfig.prototype.setMarginTopPx = function(value) {
  this.set$Value(4, value);
};


/**
 * @return {boolean} Whether the margin_top_px field has a value.
 */
sketchology.proto.CameraBoundsConfig.prototype.hasMarginTopPx = function() {
  return this.has$Value(4);
};


/**
 * @return {number} The number of values in the margin_top_px field.
 */
sketchology.proto.CameraBoundsConfig.prototype.marginTopPxCount = function() {
  return this.count$Values(4);
};


/**
 * Clears the values in the margin_top_px field.
 */
sketchology.proto.CameraBoundsConfig.prototype.clearMarginTopPx = function() {
  this.clear$Field(4);
};


/**
 * Gets the value of the fraction_padding field.
 * @return {?number} The value.
 */
sketchology.proto.CameraBoundsConfig.prototype.getFractionPadding = function() {
  return /** @type {?number} */ (this.get$Value(5));
};


/**
 * Gets the value of the fraction_padding field or the default value if not set.
 * @return {number} The value.
 */
sketchology.proto.CameraBoundsConfig.prototype.getFractionPaddingOrDefault = function() {
  return /** @type {number} */ (this.get$ValueOrDefault(5));
};


/**
 * Sets the value of the fraction_padding field.
 * @param {number} value The value.
 */
sketchology.proto.CameraBoundsConfig.prototype.setFractionPadding = function(value) {
  this.set$Value(5, value);
};


/**
 * @return {boolean} Whether the fraction_padding field has a value.
 */
sketchology.proto.CameraBoundsConfig.prototype.hasFractionPadding = function() {
  return this.has$Value(5);
};


/**
 * @return {number} The number of values in the fraction_padding field.
 */
sketchology.proto.CameraBoundsConfig.prototype.fractionPaddingCount = function() {
  return this.count$Values(5);
};


/**
 * Clears the values in the fraction_padding field.
 */
sketchology.proto.CameraBoundsConfig.prototype.clearFractionPadding = function() {
  this.clear$Field(5);
};



/**
 * Message ImageInfo.
 * @constructor
 * @extends {goog.proto2.Message}
 * @final
 */
sketchology.proto.ImageInfo = function() {
  goog.proto2.Message.call(this);
};
goog.inherits(sketchology.proto.ImageInfo, goog.proto2.Message);


/**
 * Descriptor for this message, deserialized lazily in getDescriptor().
 * @private {?goog.proto2.Descriptor}
 */
sketchology.proto.ImageInfo.descriptor_ = null;


/**
 * Overrides {@link goog.proto2.Message#clone} to specify its exact return type.
 * @return {!sketchology.proto.ImageInfo} The cloned message.
 * @override
 */
sketchology.proto.ImageInfo.prototype.clone;


/**
 * Gets the value of the uri field.
 * @return {?string} The value.
 */
sketchology.proto.ImageInfo.prototype.getUri = function() {
  return /** @type {?string} */ (this.get$Value(1));
};


/**
 * Gets the value of the uri field or the default value if not set.
 * @return {string} The value.
 */
sketchology.proto.ImageInfo.prototype.getUriOrDefault = function() {
  return /** @type {string} */ (this.get$ValueOrDefault(1));
};


/**
 * Sets the value of the uri field.
 * @param {string} value The value.
 */
sketchology.proto.ImageInfo.prototype.setUri = function(value) {
  this.set$Value(1, value);
};


/**
 * @return {boolean} Whether the uri field has a value.
 */
sketchology.proto.ImageInfo.prototype.hasUri = function() {
  return this.has$Value(1);
};


/**
 * @return {number} The number of values in the uri field.
 */
sketchology.proto.ImageInfo.prototype.uriCount = function() {
  return this.count$Values(1);
};


/**
 * Clears the values in the uri field.
 */
sketchology.proto.ImageInfo.prototype.clearUri = function() {
  this.clear$Field(1);
};


/**
 * Gets the value of the asset_type field.
 * @return {?sketchology.proto.ImageInfo.AssetType} The value.
 */
sketchology.proto.ImageInfo.prototype.getAssetType = function() {
  return /** @type {?sketchology.proto.ImageInfo.AssetType} */ (this.get$Value(2));
};


/**
 * Gets the value of the asset_type field or the default value if not set.
 * @return {!sketchology.proto.ImageInfo.AssetType} The value.
 */
sketchology.proto.ImageInfo.prototype.getAssetTypeOrDefault = function() {
  return /** @type {!sketchology.proto.ImageInfo.AssetType} */ (this.get$ValueOrDefault(2));
};


/**
 * Sets the value of the asset_type field.
 * @param {!sketchology.proto.ImageInfo.AssetType} value The value.
 */
sketchology.proto.ImageInfo.prototype.setAssetType = function(value) {
  this.set$Value(2, value);
};


/**
 * @return {boolean} Whether the asset_type field has a value.
 */
sketchology.proto.ImageInfo.prototype.hasAssetType = function() {
  return this.has$Value(2);
};


/**
 * @return {number} The number of values in the asset_type field.
 */
sketchology.proto.ImageInfo.prototype.assetTypeCount = function() {
  return this.count$Values(2);
};


/**
 * Clears the values in the asset_type field.
 */
sketchology.proto.ImageInfo.prototype.clearAssetType = function() {
  this.clear$Field(2);
};


/**
 * Enumeration AssetType.
 * @enum {number}
 */
sketchology.proto.ImageInfo.AssetType = {
  DEFAULT: 0,
  BORDER: 1,
  STICKER: 2,
  GRID: 3
};



/**
 * Message ImageRect.
 * @constructor
 * @extends {goog.proto2.Message}
 * @final
 */
sketchology.proto.ImageRect = function() {
  goog.proto2.Message.call(this);
};
goog.inherits(sketchology.proto.ImageRect, goog.proto2.Message);


/**
 * Descriptor for this message, deserialized lazily in getDescriptor().
 * @private {?goog.proto2.Descriptor}
 */
sketchology.proto.ImageRect.descriptor_ = null;


/**
 * Overrides {@link goog.proto2.Message#clone} to specify its exact return type.
 * @return {!sketchology.proto.ImageRect} The cloned message.
 * @override
 */
sketchology.proto.ImageRect.prototype.clone;


/**
 * Gets the value of the rect field.
 * @return {?sketchology.proto.Rect} The value.
 */
sketchology.proto.ImageRect.prototype.getRect = function() {
  return /** @type {?sketchology.proto.Rect} */ (this.get$Value(1));
};


/**
 * Gets the value of the rect field or the default value if not set.
 * @return {!sketchology.proto.Rect} The value.
 */
sketchology.proto.ImageRect.prototype.getRectOrDefault = function() {
  return /** @type {!sketchology.proto.Rect} */ (this.get$ValueOrDefault(1));
};


/**
 * Sets the value of the rect field.
 * @param {!sketchology.proto.Rect} value The value.
 */
sketchology.proto.ImageRect.prototype.setRect = function(value) {
  this.set$Value(1, value);
};


/**
 * @return {boolean} Whether the rect field has a value.
 */
sketchology.proto.ImageRect.prototype.hasRect = function() {
  return this.has$Value(1);
};


/**
 * @return {number} The number of values in the rect field.
 */
sketchology.proto.ImageRect.prototype.rectCount = function() {
  return this.count$Values(1);
};


/**
 * Clears the values in the rect field.
 */
sketchology.proto.ImageRect.prototype.clearRect = function() {
  this.clear$Field(1);
};


/**
 * Gets the value of the bitmap_uri field.
 * @return {?string} The value.
 */
sketchology.proto.ImageRect.prototype.getBitmapUri = function() {
  return /** @type {?string} */ (this.get$Value(2));
};


/**
 * Gets the value of the bitmap_uri field or the default value if not set.
 * @return {string} The value.
 */
sketchology.proto.ImageRect.prototype.getBitmapUriOrDefault = function() {
  return /** @type {string} */ (this.get$ValueOrDefault(2));
};


/**
 * Sets the value of the bitmap_uri field.
 * @param {string} value The value.
 */
sketchology.proto.ImageRect.prototype.setBitmapUri = function(value) {
  this.set$Value(2, value);
};


/**
 * @return {boolean} Whether the bitmap_uri field has a value.
 */
sketchology.proto.ImageRect.prototype.hasBitmapUri = function() {
  return this.has$Value(2);
};


/**
 * @return {number} The number of values in the bitmap_uri field.
 */
sketchology.proto.ImageRect.prototype.bitmapUriCount = function() {
  return this.count$Values(2);
};


/**
 * Clears the values in the bitmap_uri field.
 */
sketchology.proto.ImageRect.prototype.clearBitmapUri = function() {
  this.clear$Field(2);
};


/**
 * Gets the value of the attributes field.
 * @return {?sketchology.proto.ElementAttributes} The value.
 */
sketchology.proto.ImageRect.prototype.getAttributes = function() {
  return /** @type {?sketchology.proto.ElementAttributes} */ (this.get$Value(3));
};


/**
 * Gets the value of the attributes field or the default value if not set.
 * @return {!sketchology.proto.ElementAttributes} The value.
 */
sketchology.proto.ImageRect.prototype.getAttributesOrDefault = function() {
  return /** @type {!sketchology.proto.ElementAttributes} */ (this.get$ValueOrDefault(3));
};


/**
 * Sets the value of the attributes field.
 * @param {!sketchology.proto.ElementAttributes} value The value.
 */
sketchology.proto.ImageRect.prototype.setAttributes = function(value) {
  this.set$Value(3, value);
};


/**
 * @return {boolean} Whether the attributes field has a value.
 */
sketchology.proto.ImageRect.prototype.hasAttributes = function() {
  return this.has$Value(3);
};


/**
 * @return {number} The number of values in the attributes field.
 */
sketchology.proto.ImageRect.prototype.attributesCount = function() {
  return this.count$Values(3);
};


/**
 * Clears the values in the attributes field.
 */
sketchology.proto.ImageRect.prototype.clearAttributes = function() {
  this.clear$Field(3);
};


/**
 * Gets the value of the rotation_radians field.
 * @return {?number} The value.
 */
sketchology.proto.ImageRect.prototype.getRotationRadians = function() {
  return /** @type {?number} */ (this.get$Value(4));
};


/**
 * Gets the value of the rotation_radians field or the default value if not set.
 * @return {number} The value.
 */
sketchology.proto.ImageRect.prototype.getRotationRadiansOrDefault = function() {
  return /** @type {number} */ (this.get$ValueOrDefault(4));
};


/**
 * Sets the value of the rotation_radians field.
 * @param {number} value The value.
 */
sketchology.proto.ImageRect.prototype.setRotationRadians = function(value) {
  this.set$Value(4, value);
};


/**
 * @return {boolean} Whether the rotation_radians field has a value.
 */
sketchology.proto.ImageRect.prototype.hasRotationRadians = function() {
  return this.has$Value(4);
};


/**
 * @return {number} The number of values in the rotation_radians field.
 */
sketchology.proto.ImageRect.prototype.rotationRadiansCount = function() {
  return this.count$Values(4);
};


/**
 * Clears the values in the rotation_radians field.
 */
sketchology.proto.ImageRect.prototype.clearRotationRadians = function() {
  this.clear$Field(4);
};



/**
 * Message GridInfo.
 * @constructor
 * @extends {goog.proto2.Message}
 * @final
 */
sketchology.proto.GridInfo = function() {
  goog.proto2.Message.call(this);
};
goog.inherits(sketchology.proto.GridInfo, goog.proto2.Message);


/**
 * Descriptor for this message, deserialized lazily in getDescriptor().
 * @private {?goog.proto2.Descriptor}
 */
sketchology.proto.GridInfo.descriptor_ = null;


/**
 * Overrides {@link goog.proto2.Message#clone} to specify its exact return type.
 * @return {!sketchology.proto.GridInfo} The cloned message.
 * @override
 */
sketchology.proto.GridInfo.prototype.clone;


/**
 * Gets the value of the uri field.
 * @return {?string} The value.
 */
sketchology.proto.GridInfo.prototype.getUri = function() {
  return /** @type {?string} */ (this.get$Value(1));
};


/**
 * Gets the value of the uri field or the default value if not set.
 * @return {string} The value.
 */
sketchology.proto.GridInfo.prototype.getUriOrDefault = function() {
  return /** @type {string} */ (this.get$ValueOrDefault(1));
};


/**
 * Sets the value of the uri field.
 * @param {string} value The value.
 */
sketchology.proto.GridInfo.prototype.setUri = function(value) {
  this.set$Value(1, value);
};


/**
 * @return {boolean} Whether the uri field has a value.
 */
sketchology.proto.GridInfo.prototype.hasUri = function() {
  return this.has$Value(1);
};


/**
 * @return {number} The number of values in the uri field.
 */
sketchology.proto.GridInfo.prototype.uriCount = function() {
  return this.count$Values(1);
};


/**
 * Clears the values in the uri field.
 */
sketchology.proto.GridInfo.prototype.clearUri = function() {
  this.clear$Field(1);
};



/**
 * Message CreateDocument.
 * @constructor
 * @extends {goog.proto2.Message}
 * @final
 */
sketchology.proto.CreateDocument = function() {
  goog.proto2.Message.call(this);
};
goog.inherits(sketchology.proto.CreateDocument, goog.proto2.Message);


/**
 * Descriptor for this message, deserialized lazily in getDescriptor().
 * @private {?goog.proto2.Descriptor}
 */
sketchology.proto.CreateDocument.descriptor_ = null;


/**
 * Overrides {@link goog.proto2.Message#clone} to specify its exact return type.
 * @return {!sketchology.proto.CreateDocument} The cloned message.
 * @override
 */
sketchology.proto.CreateDocument.prototype.clone;


/**
 * Gets the value of the document_type field.
 * @return {?sketchology.proto.DocumentType} The value.
 */
sketchology.proto.CreateDocument.prototype.getDocumentType = function() {
  return /** @type {?sketchology.proto.DocumentType} */ (this.get$Value(1));
};


/**
 * Gets the value of the document_type field or the default value if not set.
 * @return {!sketchology.proto.DocumentType} The value.
 */
sketchology.proto.CreateDocument.prototype.getDocumentTypeOrDefault = function() {
  return /** @type {!sketchology.proto.DocumentType} */ (this.get$ValueOrDefault(1));
};


/**
 * Sets the value of the document_type field.
 * @param {!sketchology.proto.DocumentType} value The value.
 */
sketchology.proto.CreateDocument.prototype.setDocumentType = function(value) {
  this.set$Value(1, value);
};


/**
 * @return {boolean} Whether the document_type field has a value.
 */
sketchology.proto.CreateDocument.prototype.hasDocumentType = function() {
  return this.has$Value(1);
};


/**
 * @return {number} The number of values in the document_type field.
 */
sketchology.proto.CreateDocument.prototype.documentTypeCount = function() {
  return this.count$Values(1);
};


/**
 * Clears the values in the document_type field.
 */
sketchology.proto.CreateDocument.prototype.clearDocumentType = function() {
  this.clear$Field(1);
};


/**
 * Gets the value of the storage_type field.
 * @return {?sketchology.proto.StorageType} The value.
 */
sketchology.proto.CreateDocument.prototype.getStorageType = function() {
  return /** @type {?sketchology.proto.StorageType} */ (this.get$Value(2));
};


/**
 * Gets the value of the storage_type field or the default value if not set.
 * @return {!sketchology.proto.StorageType} The value.
 */
sketchology.proto.CreateDocument.prototype.getStorageTypeOrDefault = function() {
  return /** @type {!sketchology.proto.StorageType} */ (this.get$ValueOrDefault(2));
};


/**
 * Sets the value of the storage_type field.
 * @param {!sketchology.proto.StorageType} value The value.
 */
sketchology.proto.CreateDocument.prototype.setStorageType = function(value) {
  this.set$Value(2, value);
};


/**
 * @return {boolean} Whether the storage_type field has a value.
 */
sketchology.proto.CreateDocument.prototype.hasStorageType = function() {
  return this.has$Value(2);
};


/**
 * @return {number} The number of values in the storage_type field.
 */
sketchology.proto.CreateDocument.prototype.storageTypeCount = function() {
  return this.count$Values(2);
};


/**
 * Clears the values in the storage_type field.
 */
sketchology.proto.CreateDocument.prototype.clearStorageType = function() {
  this.clear$Field(2);
};


/**
 * Gets the value of the storage_path field.
 * @return {?string} The value.
 */
sketchology.proto.CreateDocument.prototype.getStoragePath = function() {
  return /** @type {?string} */ (this.get$Value(3));
};


/**
 * Gets the value of the storage_path field or the default value if not set.
 * @return {string} The value.
 */
sketchology.proto.CreateDocument.prototype.getStoragePathOrDefault = function() {
  return /** @type {string} */ (this.get$ValueOrDefault(3));
};


/**
 * Sets the value of the storage_path field.
 * @param {string} value The value.
 */
sketchology.proto.CreateDocument.prototype.setStoragePath = function(value) {
  this.set$Value(3, value);
};


/**
 * @return {boolean} Whether the storage_path field has a value.
 */
sketchology.proto.CreateDocument.prototype.hasStoragePath = function() {
  return this.has$Value(3);
};


/**
 * @return {number} The number of values in the storage_path field.
 */
sketchology.proto.CreateDocument.prototype.storagePathCount = function() {
  return this.count$Values(3);
};


/**
 * Clears the values in the storage_path field.
 */
sketchology.proto.CreateDocument.prototype.clearStoragePath = function() {
  this.clear$Field(3);
};


/**
 * Gets the value of the snapshot field.
 * @return {?sketchology.proto.Snapshot} The value.
 */
sketchology.proto.CreateDocument.prototype.getSnapshot = function() {
  return /** @type {?sketchology.proto.Snapshot} */ (this.get$Value(4));
};


/**
 * Gets the value of the snapshot field or the default value if not set.
 * @return {!sketchology.proto.Snapshot} The value.
 */
sketchology.proto.CreateDocument.prototype.getSnapshotOrDefault = function() {
  return /** @type {!sketchology.proto.Snapshot} */ (this.get$ValueOrDefault(4));
};


/**
 * Sets the value of the snapshot field.
 * @param {!sketchology.proto.Snapshot} value The value.
 */
sketchology.proto.CreateDocument.prototype.setSnapshot = function(value) {
  this.set$Value(4, value);
};


/**
 * @return {boolean} Whether the snapshot field has a value.
 */
sketchology.proto.CreateDocument.prototype.hasSnapshot = function() {
  return this.has$Value(4);
};


/**
 * @return {number} The number of values in the snapshot field.
 */
sketchology.proto.CreateDocument.prototype.snapshotCount = function() {
  return this.count$Values(4);
};


/**
 * Clears the values in the snapshot field.
 */
sketchology.proto.CreateDocument.prototype.clearSnapshot = function() {
  this.clear$Field(4);
};



/**
 * Message AddPath.
 * @constructor
 * @extends {goog.proto2.Message}
 * @final
 */
sketchology.proto.AddPath = function() {
  goog.proto2.Message.call(this);
};
goog.inherits(sketchology.proto.AddPath, goog.proto2.Message);


/**
 * Descriptor for this message, deserialized lazily in getDescriptor().
 * @private {?goog.proto2.Descriptor}
 */
sketchology.proto.AddPath.descriptor_ = null;


/**
 * Overrides {@link goog.proto2.Message#clone} to specify its exact return type.
 * @return {!sketchology.proto.AddPath} The cloned message.
 * @override
 */
sketchology.proto.AddPath.prototype.clone;


/**
 * Gets the value of the path field.
 * @return {?sketchology.proto.Path} The value.
 */
sketchology.proto.AddPath.prototype.getPath = function() {
  return /** @type {?sketchology.proto.Path} */ (this.get$Value(1));
};


/**
 * Gets the value of the path field or the default value if not set.
 * @return {!sketchology.proto.Path} The value.
 */
sketchology.proto.AddPath.prototype.getPathOrDefault = function() {
  return /** @type {!sketchology.proto.Path} */ (this.get$ValueOrDefault(1));
};


/**
 * Sets the value of the path field.
 * @param {!sketchology.proto.Path} value The value.
 */
sketchology.proto.AddPath.prototype.setPath = function(value) {
  this.set$Value(1, value);
};


/**
 * @return {boolean} Whether the path field has a value.
 */
sketchology.proto.AddPath.prototype.hasPath = function() {
  return this.has$Value(1);
};


/**
 * @return {number} The number of values in the path field.
 */
sketchology.proto.AddPath.prototype.pathCount = function() {
  return this.count$Values(1);
};


/**
 * Clears the values in the path field.
 */
sketchology.proto.AddPath.prototype.clearPath = function() {
  this.clear$Field(1);
};


/**
 * Gets the value of the uuid field.
 * @return {?string} The value.
 */
sketchology.proto.AddPath.prototype.getUuid = function() {
  return /** @type {?string} */ (this.get$Value(2));
};


/**
 * Gets the value of the uuid field or the default value if not set.
 * @return {string} The value.
 */
sketchology.proto.AddPath.prototype.getUuidOrDefault = function() {
  return /** @type {string} */ (this.get$ValueOrDefault(2));
};


/**
 * Sets the value of the uuid field.
 * @param {string} value The value.
 */
sketchology.proto.AddPath.prototype.setUuid = function(value) {
  this.set$Value(2, value);
};


/**
 * @return {boolean} Whether the uuid field has a value.
 */
sketchology.proto.AddPath.prototype.hasUuid = function() {
  return this.has$Value(2);
};


/**
 * @return {number} The number of values in the uuid field.
 */
sketchology.proto.AddPath.prototype.uuidCount = function() {
  return this.count$Values(2);
};


/**
 * Clears the values in the uuid field.
 */
sketchology.proto.AddPath.prototype.clearUuid = function() {
  this.clear$Field(2);
};



/**
 * Message PusherPositionUpdate.
 * @constructor
 * @extends {goog.proto2.Message}
 * @final
 */
sketchology.proto.PusherPositionUpdate = function() {
  goog.proto2.Message.call(this);
};
goog.inherits(sketchology.proto.PusherPositionUpdate, goog.proto2.Message);


/**
 * Descriptor for this message, deserialized lazily in getDescriptor().
 * @private {?goog.proto2.Descriptor}
 */
sketchology.proto.PusherPositionUpdate.descriptor_ = null;


/**
 * Overrides {@link goog.proto2.Message#clone} to specify its exact return type.
 * @return {!sketchology.proto.PusherPositionUpdate} The cloned message.
 * @override
 */
sketchology.proto.PusherPositionUpdate.prototype.clone;


/**
 * Gets the value of the uuid field.
 * @return {?string} The value.
 */
sketchology.proto.PusherPositionUpdate.prototype.getUuid = function() {
  return /** @type {?string} */ (this.get$Value(1));
};


/**
 * Gets the value of the uuid field or the default value if not set.
 * @return {string} The value.
 */
sketchology.proto.PusherPositionUpdate.prototype.getUuidOrDefault = function() {
  return /** @type {string} */ (this.get$ValueOrDefault(1));
};


/**
 * Sets the value of the uuid field.
 * @param {string} value The value.
 */
sketchology.proto.PusherPositionUpdate.prototype.setUuid = function(value) {
  this.set$Value(1, value);
};


/**
 * @return {boolean} Whether the uuid field has a value.
 */
sketchology.proto.PusherPositionUpdate.prototype.hasUuid = function() {
  return this.has$Value(1);
};


/**
 * @return {number} The number of values in the uuid field.
 */
sketchology.proto.PusherPositionUpdate.prototype.uuidCount = function() {
  return this.count$Values(1);
};


/**
 * Clears the values in the uuid field.
 */
sketchology.proto.PusherPositionUpdate.prototype.clearUuid = function() {
  this.clear$Field(1);
};


/**
 * Gets the value of the pointer_location field at the index given.
 * @param {number} index The index to lookup.
 * @return {?sketchology.proto.Point} The value.
 */
sketchology.proto.PusherPositionUpdate.prototype.getPointerLocation = function(index) {
  return /** @type {?sketchology.proto.Point} */ (this.get$Value(2, index));
};


/**
 * Gets the value of the pointer_location field at the index given or the default value if not set.
 * @param {number} index The index to lookup.
 * @return {!sketchology.proto.Point} The value.
 */
sketchology.proto.PusherPositionUpdate.prototype.getPointerLocationOrDefault = function(index) {
  return /** @type {!sketchology.proto.Point} */ (this.get$ValueOrDefault(2, index));
};


/**
 * Adds a value to the pointer_location field.
 * @param {!sketchology.proto.Point} value The value to add.
 */
sketchology.proto.PusherPositionUpdate.prototype.addPointerLocation = function(value) {
  this.add$Value(2, value);
};


/**
 * Returns the array of values in the pointer_location field.
 * @return {!Array<!sketchology.proto.Point>} The values in the field.
 */
sketchology.proto.PusherPositionUpdate.prototype.pointerLocationArray = function() {
  return /** @type {!Array<!sketchology.proto.Point>} */ (this.array$Values(2));
};


/**
 * @return {boolean} Whether the pointer_location field has a value.
 */
sketchology.proto.PusherPositionUpdate.prototype.hasPointerLocation = function() {
  return this.has$Value(2);
};


/**
 * @return {number} The number of values in the pointer_location field.
 */
sketchology.proto.PusherPositionUpdate.prototype.pointerLocationCount = function() {
  return this.count$Values(2);
};


/**
 * Clears the values in the pointer_location field.
 */
sketchology.proto.PusherPositionUpdate.prototype.clearPointerLocation = function() {
  this.clear$Field(2);
};



/**
 * Message ElementQueryData.
 * @constructor
 * @extends {goog.proto2.Message}
 * @final
 */
sketchology.proto.ElementQueryData = function() {
  goog.proto2.Message.call(this);
};
goog.inherits(sketchology.proto.ElementQueryData, goog.proto2.Message);


/**
 * Descriptor for this message, deserialized lazily in getDescriptor().
 * @private {?goog.proto2.Descriptor}
 */
sketchology.proto.ElementQueryData.descriptor_ = null;


/**
 * Overrides {@link goog.proto2.Message#clone} to specify its exact return type.
 * @return {!sketchology.proto.ElementQueryData} The cloned message.
 * @override
 */
sketchology.proto.ElementQueryData.prototype.clone;


/**
 * Gets the value of the item field at the index given.
 * @param {number} index The index to lookup.
 * @return {?sketchology.proto.ElementQueryItem} The value.
 */
sketchology.proto.ElementQueryData.prototype.getItem = function(index) {
  return /** @type {?sketchology.proto.ElementQueryItem} */ (this.get$Value(1, index));
};


/**
 * Gets the value of the item field at the index given or the default value if not set.
 * @param {number} index The index to lookup.
 * @return {!sketchology.proto.ElementQueryItem} The value.
 */
sketchology.proto.ElementQueryData.prototype.getItemOrDefault = function(index) {
  return /** @type {!sketchology.proto.ElementQueryItem} */ (this.get$ValueOrDefault(1, index));
};


/**
 * Adds a value to the item field.
 * @param {!sketchology.proto.ElementQueryItem} value The value to add.
 */
sketchology.proto.ElementQueryData.prototype.addItem = function(value) {
  this.add$Value(1, value);
};


/**
 * Returns the array of values in the item field.
 * @return {!Array<!sketchology.proto.ElementQueryItem>} The values in the field.
 */
sketchology.proto.ElementQueryData.prototype.itemArray = function() {
  return /** @type {!Array<!sketchology.proto.ElementQueryItem>} */ (this.array$Values(1));
};


/**
 * @return {boolean} Whether the item field has a value.
 */
sketchology.proto.ElementQueryData.prototype.hasItem = function() {
  return this.has$Value(1);
};


/**
 * @return {number} The number of values in the item field.
 */
sketchology.proto.ElementQueryData.prototype.itemCount = function() {
  return this.count$Values(1);
};


/**
 * Clears the values in the item field.
 */
sketchology.proto.ElementQueryData.prototype.clearItem = function() {
  this.clear$Field(1);
};


/**
 * Gets the value of the up_world_location field.
 * @return {?sketchology.proto.Point} The value.
 */
sketchology.proto.ElementQueryData.prototype.getUpWorldLocation = function() {
  return /** @type {?sketchology.proto.Point} */ (this.get$Value(2));
};


/**
 * Gets the value of the up_world_location field or the default value if not set.
 * @return {!sketchology.proto.Point} The value.
 */
sketchology.proto.ElementQueryData.prototype.getUpWorldLocationOrDefault = function() {
  return /** @type {!sketchology.proto.Point} */ (this.get$ValueOrDefault(2));
};


/**
 * Sets the value of the up_world_location field.
 * @param {!sketchology.proto.Point} value The value.
 */
sketchology.proto.ElementQueryData.prototype.setUpWorldLocation = function(value) {
  this.set$Value(2, value);
};


/**
 * @return {boolean} Whether the up_world_location field has a value.
 */
sketchology.proto.ElementQueryData.prototype.hasUpWorldLocation = function() {
  return this.has$Value(2);
};


/**
 * @return {number} The number of values in the up_world_location field.
 */
sketchology.proto.ElementQueryData.prototype.upWorldLocationCount = function() {
  return this.count$Values(2);
};


/**
 * Clears the values in the up_world_location field.
 */
sketchology.proto.ElementQueryData.prototype.clearUpWorldLocation = function() {
  this.clear$Field(2);
};


/**
 * Gets the value of the down_world_location field.
 * @return {?sketchology.proto.Point} The value.
 */
sketchology.proto.ElementQueryData.prototype.getDownWorldLocation = function() {
  return /** @type {?sketchology.proto.Point} */ (this.get$Value(3));
};


/**
 * Gets the value of the down_world_location field or the default value if not set.
 * @return {!sketchology.proto.Point} The value.
 */
sketchology.proto.ElementQueryData.prototype.getDownWorldLocationOrDefault = function() {
  return /** @type {!sketchology.proto.Point} */ (this.get$ValueOrDefault(3));
};


/**
 * Sets the value of the down_world_location field.
 * @param {!sketchology.proto.Point} value The value.
 */
sketchology.proto.ElementQueryData.prototype.setDownWorldLocation = function(value) {
  this.set$Value(3, value);
};


/**
 * @return {boolean} Whether the down_world_location field has a value.
 */
sketchology.proto.ElementQueryData.prototype.hasDownWorldLocation = function() {
  return this.has$Value(3);
};


/**
 * @return {number} The number of values in the down_world_location field.
 */
sketchology.proto.ElementQueryData.prototype.downWorldLocationCount = function() {
  return this.count$Values(3);
};


/**
 * Clears the values in the down_world_location field.
 */
sketchology.proto.ElementQueryData.prototype.clearDownWorldLocation = function() {
  this.clear$Field(3);
};



/**
 * Message ElementQueryItem.
 * @constructor
 * @extends {goog.proto2.Message}
 * @final
 */
sketchology.proto.ElementQueryItem = function() {
  goog.proto2.Message.call(this);
};
goog.inherits(sketchology.proto.ElementQueryItem, goog.proto2.Message);


/**
 * Descriptor for this message, deserialized lazily in getDescriptor().
 * @private {?goog.proto2.Descriptor}
 */
sketchology.proto.ElementQueryItem.descriptor_ = null;


/**
 * Overrides {@link goog.proto2.Message#clone} to specify its exact return type.
 * @return {!sketchology.proto.ElementQueryItem} The cloned message.
 * @override
 */
sketchology.proto.ElementQueryItem.prototype.clone;


/**
 * Gets the value of the uuid field.
 * @return {?string} The value.
 */
sketchology.proto.ElementQueryItem.prototype.getUuid = function() {
  return /** @type {?string} */ (this.get$Value(1));
};


/**
 * Gets the value of the uuid field or the default value if not set.
 * @return {string} The value.
 */
sketchology.proto.ElementQueryItem.prototype.getUuidOrDefault = function() {
  return /** @type {string} */ (this.get$ValueOrDefault(1));
};


/**
 * Sets the value of the uuid field.
 * @param {string} value The value.
 */
sketchology.proto.ElementQueryItem.prototype.setUuid = function(value) {
  this.set$Value(1, value);
};


/**
 * @return {boolean} Whether the uuid field has a value.
 */
sketchology.proto.ElementQueryItem.prototype.hasUuid = function() {
  return this.has$Value(1);
};


/**
 * @return {number} The number of values in the uuid field.
 */
sketchology.proto.ElementQueryItem.prototype.uuidCount = function() {
  return this.count$Values(1);
};


/**
 * Clears the values in the uuid field.
 */
sketchology.proto.ElementQueryItem.prototype.clearUuid = function() {
  this.clear$Field(1);
};


/**
 * Gets the value of the world_bounds field.
 * @return {?sketchology.proto.Rect} The value.
 */
sketchology.proto.ElementQueryItem.prototype.getWorldBounds = function() {
  return /** @type {?sketchology.proto.Rect} */ (this.get$Value(2));
};


/**
 * Gets the value of the world_bounds field or the default value if not set.
 * @return {!sketchology.proto.Rect} The value.
 */
sketchology.proto.ElementQueryItem.prototype.getWorldBoundsOrDefault = function() {
  return /** @type {!sketchology.proto.Rect} */ (this.get$ValueOrDefault(2));
};


/**
 * Sets the value of the world_bounds field.
 * @param {!sketchology.proto.Rect} value The value.
 */
sketchology.proto.ElementQueryItem.prototype.setWorldBounds = function(value) {
  this.set$Value(2, value);
};


/**
 * @return {boolean} Whether the world_bounds field has a value.
 */
sketchology.proto.ElementQueryItem.prototype.hasWorldBounds = function() {
  return this.has$Value(2);
};


/**
 * @return {number} The number of values in the world_bounds field.
 */
sketchology.proto.ElementQueryItem.prototype.worldBoundsCount = function() {
  return this.count$Values(2);
};


/**
 * Clears the values in the world_bounds field.
 */
sketchology.proto.ElementQueryItem.prototype.clearWorldBounds = function() {
  this.clear$Field(2);
};


/**
 * Gets the value of the uri field.
 * @return {?string} The value.
 */
sketchology.proto.ElementQueryItem.prototype.getUri = function() {
  return /** @type {?string} */ (this.get$Value(3));
};


/**
 * Gets the value of the uri field or the default value if not set.
 * @return {string} The value.
 */
sketchology.proto.ElementQueryItem.prototype.getUriOrDefault = function() {
  return /** @type {string} */ (this.get$ValueOrDefault(3));
};


/**
 * Sets the value of the uri field.
 * @param {string} value The value.
 */
sketchology.proto.ElementQueryItem.prototype.setUri = function(value) {
  this.set$Value(3, value);
};


/**
 * @return {boolean} Whether the uri field has a value.
 */
sketchology.proto.ElementQueryItem.prototype.hasUri = function() {
  return this.has$Value(3);
};


/**
 * @return {number} The number of values in the uri field.
 */
sketchology.proto.ElementQueryItem.prototype.uriCount = function() {
  return this.count$Values(3);
};


/**
 * Clears the values in the uri field.
 */
sketchology.proto.ElementQueryItem.prototype.clearUri = function() {
  this.clear$Field(3);
};



/**
 * Message SelectionState.
 * @constructor
 * @extends {goog.proto2.Message}
 * @final
 */
sketchology.proto.SelectionState = function() {
  goog.proto2.Message.call(this);
};
goog.inherits(sketchology.proto.SelectionState, goog.proto2.Message);


/**
 * Descriptor for this message, deserialized lazily in getDescriptor().
 * @private {?goog.proto2.Descriptor}
 */
sketchology.proto.SelectionState.descriptor_ = null;


/**
 * Overrides {@link goog.proto2.Message#clone} to specify its exact return type.
 * @return {!sketchology.proto.SelectionState} The cloned message.
 * @override
 */
sketchology.proto.SelectionState.prototype.clone;


/**
 * Gets the value of the anything_selected field.
 * @return {?boolean} The value.
 */
sketchology.proto.SelectionState.prototype.getAnythingSelected = function() {
  return /** @type {?boolean} */ (this.get$Value(1));
};


/**
 * Gets the value of the anything_selected field or the default value if not set.
 * @return {boolean} The value.
 */
sketchology.proto.SelectionState.prototype.getAnythingSelectedOrDefault = function() {
  return /** @type {boolean} */ (this.get$ValueOrDefault(1));
};


/**
 * Sets the value of the anything_selected field.
 * @param {boolean} value The value.
 */
sketchology.proto.SelectionState.prototype.setAnythingSelected = function(value) {
  this.set$Value(1, value);
};


/**
 * @return {boolean} Whether the anything_selected field has a value.
 */
sketchology.proto.SelectionState.prototype.hasAnythingSelected = function() {
  return this.has$Value(1);
};


/**
 * @return {number} The number of values in the anything_selected field.
 */
sketchology.proto.SelectionState.prototype.anythingSelectedCount = function() {
  return this.count$Values(1);
};


/**
 * Clears the values in the anything_selected field.
 */
sketchology.proto.SelectionState.prototype.clearAnythingSelected = function() {
  this.clear$Field(1);
};



/**
 * Message ToolEvent.
 * @constructor
 * @extends {goog.proto2.Message}
 * @final
 */
sketchology.proto.ToolEvent = function() {
  goog.proto2.Message.call(this);
};
goog.inherits(sketchology.proto.ToolEvent, goog.proto2.Message);


/**
 * Descriptor for this message, deserialized lazily in getDescriptor().
 * @private {?goog.proto2.Descriptor}
 */
sketchology.proto.ToolEvent.descriptor_ = null;


/**
 * Overrides {@link goog.proto2.Message#clone} to specify its exact return type.
 * @return {!sketchology.proto.ToolEvent} The cloned message.
 * @override
 */
sketchology.proto.ToolEvent.prototype.clone;


/**
 * Gets the value of the pusher_position_update field.
 * @return {?sketchology.proto.PusherPositionUpdate} The value.
 */
sketchology.proto.ToolEvent.prototype.getPusherPositionUpdate = function() {
  return /** @type {?sketchology.proto.PusherPositionUpdate} */ (this.get$Value(1));
};


/**
 * Gets the value of the pusher_position_update field or the default value if not set.
 * @return {!sketchology.proto.PusherPositionUpdate} The value.
 */
sketchology.proto.ToolEvent.prototype.getPusherPositionUpdateOrDefault = function() {
  return /** @type {!sketchology.proto.PusherPositionUpdate} */ (this.get$ValueOrDefault(1));
};


/**
 * Sets the value of the pusher_position_update field.
 * @param {!sketchology.proto.PusherPositionUpdate} value The value.
 */
sketchology.proto.ToolEvent.prototype.setPusherPositionUpdate = function(value) {
  this.set$Value(1, value);
};


/**
 * @return {boolean} Whether the pusher_position_update field has a value.
 */
sketchology.proto.ToolEvent.prototype.hasPusherPositionUpdate = function() {
  return this.has$Value(1);
};


/**
 * @return {number} The number of values in the pusher_position_update field.
 */
sketchology.proto.ToolEvent.prototype.pusherPositionUpdateCount = function() {
  return this.count$Values(1);
};


/**
 * Clears the values in the pusher_position_update field.
 */
sketchology.proto.ToolEvent.prototype.clearPusherPositionUpdate = function() {
  this.clear$Field(1);
};


/**
 * Gets the value of the element_query_data field.
 * @return {?sketchology.proto.ElementQueryData} The value.
 */
sketchology.proto.ToolEvent.prototype.getElementQueryData = function() {
  return /** @type {?sketchology.proto.ElementQueryData} */ (this.get$Value(2));
};


/**
 * Gets the value of the element_query_data field or the default value if not set.
 * @return {!sketchology.proto.ElementQueryData} The value.
 */
sketchology.proto.ToolEvent.prototype.getElementQueryDataOrDefault = function() {
  return /** @type {!sketchology.proto.ElementQueryData} */ (this.get$ValueOrDefault(2));
};


/**
 * Sets the value of the element_query_data field.
 * @param {!sketchology.proto.ElementQueryData} value The value.
 */
sketchology.proto.ToolEvent.prototype.setElementQueryData = function(value) {
  this.set$Value(2, value);
};


/**
 * @return {boolean} Whether the element_query_data field has a value.
 */
sketchology.proto.ToolEvent.prototype.hasElementQueryData = function() {
  return this.has$Value(2);
};


/**
 * @return {number} The number of values in the element_query_data field.
 */
sketchology.proto.ToolEvent.prototype.elementQueryDataCount = function() {
  return this.count$Values(2);
};


/**
 * Clears the values in the element_query_data field.
 */
sketchology.proto.ToolEvent.prototype.clearElementQueryData = function() {
  this.clear$Field(2);
};


/**
 * Gets the value of the selection_state field.
 * @return {?sketchology.proto.SelectionState} The value.
 */
sketchology.proto.ToolEvent.prototype.getSelectionState = function() {
  return /** @type {?sketchology.proto.SelectionState} */ (this.get$Value(3));
};


/**
 * Gets the value of the selection_state field or the default value if not set.
 * @return {!sketchology.proto.SelectionState} The value.
 */
sketchology.proto.ToolEvent.prototype.getSelectionStateOrDefault = function() {
  return /** @type {!sketchology.proto.SelectionState} */ (this.get$ValueOrDefault(3));
};


/**
 * Sets the value of the selection_state field.
 * @param {!sketchology.proto.SelectionState} value The value.
 */
sketchology.proto.ToolEvent.prototype.setSelectionState = function(value) {
  this.set$Value(3, value);
};


/**
 * @return {boolean} Whether the selection_state field has a value.
 */
sketchology.proto.ToolEvent.prototype.hasSelectionState = function() {
  return this.has$Value(3);
};


/**
 * @return {number} The number of values in the selection_state field.
 */
sketchology.proto.ToolEvent.prototype.selectionStateCount = function() {
  return this.count$Values(3);
};


/**
 * Clears the values in the selection_state field.
 */
sketchology.proto.ToolEvent.prototype.clearSelectionState = function() {
  this.clear$Field(3);
};


/** @override */
sketchology.proto.Command.prototype.getDescriptor = function() {
  var descriptor = sketchology.proto.Command.descriptor_;
  if (!descriptor) {
    // The descriptor is created lazily when we instantiate a new instance.
    var descriptorObj = {
      0: {
        name: 'Command',
        fullName: 'sketchology.proto.Command'
      },
      1: {
        name: 'set_viewport',
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.Viewport
      },
      2: {
        name: 'tool_params',
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.ToolParams
      },
      3: {
        name: 'add_path',
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.AddPath
      },
      4: {
        name: 'camera_position',
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.Rect
      },
      5: {
        name: 'page_bounds',
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.Rect
      },
      6: {
        name: 'image_export',
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.ImageExport
      },
      7: {
        name: 'flag_assignment',
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.FlagAssignment
      },
      8: {
        name: 'set_element_transforms',
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.ElementMutation
      },
      9: {
        name: 'add_element',
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.AddElement
      },
      10: {
        name: 'background_image',
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.BackgroundImageInfo
      },
      11: {
        name: 'background_color',
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.BackgroundColor
      },
      12: {
        name: 'set_out_of_bounds_color',
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.OutOfBoundsColor
      },
      13: {
        name: 'set_page_border',
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.Border
      },
      14: {
        name: 'send_input_stream',
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.SInputStream
      },
      15: {
        name: 'sequence_point',
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.SequencePoint
      },
      16: {
        name: 'set_callback_flags',
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.SetCallbackFlags
      },
      17: {
        name: 'set_camera_bounds_config',
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.CameraBoundsConfig
      },
      18: {
        name: 'deselect_all',
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.NoArgCommand
      },
      19: {
        name: 'add_image_rect',
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.ImageRect
      },
      21: {
        name: 'clear',
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.NoArgCommand
      },
      22: {
        name: 'remove_all_elements',
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.NoArgCommand
      },
      23: {
        name: 'undo',
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.NoArgCommand
      },
      24: {
        name: 'redo',
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.NoArgCommand
      },
      25: {
        name: 'evict_image_data',
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.EvictImageData
      },
      26: {
        name: 'replace_elements',
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.ReplaceElementsCommand
      },
      27: {
        name: 'commit_crop',
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.NoArgCommand
      },
      28: {
        name: 'element_animation',
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.ElementAnimation
      },
      29: {
        name: 'set_grid',
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.GridInfo
      },
      30: {
        name: 'clear_grid',
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.NoArgCommand
      }
    };
    sketchology.proto.Command.descriptor_ = descriptor =
        goog.proto2.Message.createDescriptor(
             sketchology.proto.Command, descriptorObj);
  }
  return descriptor;
};


/** @nocollapse */
sketchology.proto.Command.getDescriptor =
    sketchology.proto.Command.prototype.getDescriptor;


/** @override */
sketchology.proto.CommandList.prototype.getDescriptor = function() {
  var descriptor = sketchology.proto.CommandList.descriptor_;
  if (!descriptor) {
    // The descriptor is created lazily when we instantiate a new instance.
    var descriptorObj = {
      0: {
        name: 'CommandList',
        fullName: 'sketchology.proto.CommandList'
      },
      1: {
        name: 'commands',
        repeated: true,
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.Command
      }
    };
    sketchology.proto.CommandList.descriptor_ = descriptor =
        goog.proto2.Message.createDescriptor(
             sketchology.proto.CommandList, descriptorObj);
  }
  return descriptor;
};


/** @nocollapse */
sketchology.proto.CommandList.getDescriptor =
    sketchology.proto.CommandList.prototype.getDescriptor;


/** @override */
sketchology.proto.NoArgCommand.prototype.getDescriptor = function() {
  var descriptor = sketchology.proto.NoArgCommand.descriptor_;
  if (!descriptor) {
    // The descriptor is created lazily when we instantiate a new instance.
    var descriptorObj = {
      0: {
        name: 'NoArgCommand',
        fullName: 'sketchology.proto.NoArgCommand'
      }
    };
    sketchology.proto.NoArgCommand.descriptor_ = descriptor =
        goog.proto2.Message.createDescriptor(
             sketchology.proto.NoArgCommand, descriptorObj);
  }
  return descriptor;
};


/** @nocollapse */
sketchology.proto.NoArgCommand.getDescriptor =
    sketchology.proto.NoArgCommand.prototype.getDescriptor;


/** @override */
sketchology.proto.ReplaceElementsCommand.prototype.getDescriptor = function() {
  var descriptor = sketchology.proto.ReplaceElementsCommand.descriptor_;
  if (!descriptor) {
    // The descriptor is created lazily when we instantiate a new instance.
    var descriptorObj = {
      0: {
        name: 'ReplaceElementsCommand',
        fullName: 'sketchology.proto.ReplaceElementsCommand'
      },
      1: {
        name: 'uuids_to_remove',
        repeated: true,
        fieldType: goog.proto2.Message.FieldType.STRING,
        type: String
      },
      2: {
        name: 'paths_to_add',
        repeated: true,
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.Path
      }
    };
    sketchology.proto.ReplaceElementsCommand.descriptor_ = descriptor =
        goog.proto2.Message.createDescriptor(
             sketchology.proto.ReplaceElementsCommand, descriptorObj);
  }
  return descriptor;
};


/** @nocollapse */
sketchology.proto.ReplaceElementsCommand.getDescriptor =
    sketchology.proto.ReplaceElementsCommand.prototype.getDescriptor;


/** @override */
sketchology.proto.EvictImageData.prototype.getDescriptor = function() {
  var descriptor = sketchology.proto.EvictImageData.descriptor_;
  if (!descriptor) {
    // The descriptor is created lazily when we instantiate a new instance.
    var descriptorObj = {
      0: {
        name: 'EvictImageData',
        fullName: 'sketchology.proto.EvictImageData'
      },
      1: {
        name: 'uri',
        fieldType: goog.proto2.Message.FieldType.STRING,
        type: String
      }
    };
    sketchology.proto.EvictImageData.descriptor_ = descriptor =
        goog.proto2.Message.createDescriptor(
             sketchology.proto.EvictImageData, descriptorObj);
  }
  return descriptor;
};


/** @nocollapse */
sketchology.proto.EvictImageData.getDescriptor =
    sketchology.proto.EvictImageData.prototype.getDescriptor;


/** @override */
sketchology.proto.Viewport.prototype.getDescriptor = function() {
  var descriptor = sketchology.proto.Viewport.descriptor_;
  if (!descriptor) {
    // The descriptor is created lazily when we instantiate a new instance.
    var descriptorObj = {
      0: {
        name: 'Viewport',
        fullName: 'sketchology.proto.Viewport'
      },
      1: {
        name: 'fbo_handle',
        fieldType: goog.proto2.Message.FieldType.UINT32,
        type: Number
      },
      2: {
        name: 'width',
        fieldType: goog.proto2.Message.FieldType.UINT32,
        type: Number
      },
      3: {
        name: 'height',
        fieldType: goog.proto2.Message.FieldType.UINT32,
        type: Number
      },
      4: {
        name: 'ppi',
        fieldType: goog.proto2.Message.FieldType.FLOAT,
        type: Number
      }
    };
    sketchology.proto.Viewport.descriptor_ = descriptor =
        goog.proto2.Message.createDescriptor(
             sketchology.proto.Viewport, descriptorObj);
  }
  return descriptor;
};


/** @nocollapse */
sketchology.proto.Viewport.getDescriptor =
    sketchology.proto.Viewport.prototype.getDescriptor;


/** @override */
sketchology.proto.ImageExport.prototype.getDescriptor = function() {
  var descriptor = sketchology.proto.ImageExport.descriptor_;
  if (!descriptor) {
    // The descriptor is created lazily when we instantiate a new instance.
    var descriptorObj = {
      0: {
        name: 'ImageExport',
        fullName: 'sketchology.proto.ImageExport'
      },
      1: {
        name: 'max_dimension_px',
        fieldType: goog.proto2.Message.FieldType.UINT32,
        defaultValue: 1024,
        type: Number
      },
      2: {
        name: 'should_draw_background',
        fieldType: goog.proto2.Message.FieldType.BOOL,
        defaultValue: true,
        type: Boolean
      }
    };
    sketchology.proto.ImageExport.descriptor_ = descriptor =
        goog.proto2.Message.createDescriptor(
             sketchology.proto.ImageExport, descriptorObj);
  }
  return descriptor;
};


/** @nocollapse */
sketchology.proto.ImageExport.getDescriptor =
    sketchology.proto.ImageExport.prototype.getDescriptor;


/** @override */
sketchology.proto.LinearPathAnimation.prototype.getDescriptor = function() {
  var descriptor = sketchology.proto.LinearPathAnimation.descriptor_;
  if (!descriptor) {
    // The descriptor is created lazily when we instantiate a new instance.
    var descriptorObj = {
      0: {
        name: 'LinearPathAnimation',
        fullName: 'sketchology.proto.LinearPathAnimation'
      },
      1: {
        name: 'rgba_from',
        fieldType: goog.proto2.Message.FieldType.UINT32,
        type: Number
      },
      2: {
        name: 'rgba_seconds',
        fieldType: goog.proto2.Message.FieldType.DOUBLE,
        type: Number
      },
      3: {
        name: 'dilation_from',
        fieldType: goog.proto2.Message.FieldType.FLOAT,
        type: Number
      },
      4: {
        name: 'dilation_seconds',
        fieldType: goog.proto2.Message.FieldType.DOUBLE,
        type: Number
      }
    };
    sketchology.proto.LinearPathAnimation.descriptor_ = descriptor =
        goog.proto2.Message.createDescriptor(
             sketchology.proto.LinearPathAnimation, descriptorObj);
  }
  return descriptor;
};


/** @nocollapse */
sketchology.proto.LinearPathAnimation.getDescriptor =
    sketchology.proto.LinearPathAnimation.prototype.getDescriptor;


/** @override */
sketchology.proto.LineSize.prototype.getDescriptor = function() {
  var descriptor = sketchology.proto.LineSize.descriptor_;
  if (!descriptor) {
    // The descriptor is created lazily when we instantiate a new instance.
    var descriptorObj = {
      0: {
        name: 'LineSize',
        fullName: 'sketchology.proto.LineSize'
      },
      7: {
        name: 'stroke_width',
        fieldType: goog.proto2.Message.FieldType.FLOAT,
        type: Number
      },
      8: {
        name: 'units',
        fieldType: goog.proto2.Message.FieldType.ENUM,
        defaultValue: sketchology.proto.LineSize.SizeType.WORLD_UNITS,
        type: sketchology.proto.LineSize.SizeType
      }
    };
    sketchology.proto.LineSize.descriptor_ = descriptor =
        goog.proto2.Message.createDescriptor(
             sketchology.proto.LineSize, descriptorObj);
  }
  return descriptor;
};


/** @nocollapse */
sketchology.proto.LineSize.getDescriptor =
    sketchology.proto.LineSize.prototype.getDescriptor;


/** @override */
sketchology.proto.PusherToolParams.prototype.getDescriptor = function() {
  var descriptor = sketchology.proto.PusherToolParams.descriptor_;
  if (!descriptor) {
    // The descriptor is created lazily when we instantiate a new instance.
    var descriptorObj = {
      0: {
        name: 'PusherToolParams',
        fullName: 'sketchology.proto.PusherToolParams'
      },
      1: {
        name: 'manipulate_stickers',
        fieldType: goog.proto2.Message.FieldType.BOOL,
        type: Boolean
      },
      2: {
        name: 'manipulate_text',
        fieldType: goog.proto2.Message.FieldType.BOOL,
        type: Boolean
      }
    };
    sketchology.proto.PusherToolParams.descriptor_ = descriptor =
        goog.proto2.Message.createDescriptor(
             sketchology.proto.PusherToolParams, descriptorObj);
  }
  return descriptor;
};


/** @nocollapse */
sketchology.proto.PusherToolParams.getDescriptor =
    sketchology.proto.PusherToolParams.prototype.getDescriptor;


/** @override */
sketchology.proto.ToolParams.prototype.getDescriptor = function() {
  var descriptor = sketchology.proto.ToolParams.descriptor_;
  if (!descriptor) {
    // The descriptor is created lazily when we instantiate a new instance.
    var descriptorObj = {
      0: {
        name: 'ToolParams',
        fullName: 'sketchology.proto.ToolParams'
      },
      1: {
        name: 'tool',
        fieldType: goog.proto2.Message.FieldType.ENUM,
        defaultValue: sketchology.proto.ToolParams.ToolType.UNKNOWN,
        type: sketchology.proto.ToolParams.ToolType
      },
      2: {
        name: 'rgba',
        fieldType: goog.proto2.Message.FieldType.UINT32,
        type: Number
      },
      3: {
        name: 'line_size',
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.LineSize
      },
      4: {
        name: 'pusher_tool_params',
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.PusherToolParams
      },
      5: {
        name: 'brush_type',
        fieldType: goog.proto2.Message.FieldType.ENUM,
        defaultValue: sketchology.proto.BrushType.UNKNOWN_BRUSH,
        type: sketchology.proto.BrushType
      },
      6: {
        name: 'linear_path_animation',
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.LinearPathAnimation
      }
    };
    sketchology.proto.ToolParams.descriptor_ = descriptor =
        goog.proto2.Message.createDescriptor(
             sketchology.proto.ToolParams, descriptorObj);
  }
  return descriptor;
};


/** @nocollapse */
sketchology.proto.ToolParams.getDescriptor =
    sketchology.proto.ToolParams.prototype.getDescriptor;


/** @override */
sketchology.proto.FlagAssignment.prototype.getDescriptor = function() {
  var descriptor = sketchology.proto.FlagAssignment.descriptor_;
  if (!descriptor) {
    // The descriptor is created lazily when we instantiate a new instance.
    var descriptorObj = {
      0: {
        name: 'FlagAssignment',
        fullName: 'sketchology.proto.FlagAssignment'
      },
      1: {
        name: 'flag',
        fieldType: goog.proto2.Message.FieldType.ENUM,
        defaultValue: sketchology.proto.Flag.UNKNOWN,
        type: sketchology.proto.Flag
      },
      2: {
        name: 'bool_value',
        fieldType: goog.proto2.Message.FieldType.BOOL,
        type: Boolean
      }
    };
    sketchology.proto.FlagAssignment.descriptor_ = descriptor =
        goog.proto2.Message.createDescriptor(
             sketchology.proto.FlagAssignment, descriptorObj);
  }
  return descriptor;
};


/** @nocollapse */
sketchology.proto.FlagAssignment.getDescriptor =
    sketchology.proto.FlagAssignment.prototype.getDescriptor;


/** @override */
sketchology.proto.AddElement.prototype.getDescriptor = function() {
  var descriptor = sketchology.proto.AddElement.descriptor_;
  if (!descriptor) {
    // The descriptor is created lazily when we instantiate a new instance.
    var descriptorObj = {
      0: {
        name: 'AddElement',
        fullName: 'sketchology.proto.AddElement'
      },
      1: {
        name: 'bundle',
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.ElementBundle
      },
      2: {
        name: 'below_element_with_uuid',
        fieldType: goog.proto2.Message.FieldType.STRING,
        type: String
      }
    };
    sketchology.proto.AddElement.descriptor_ = descriptor =
        goog.proto2.Message.createDescriptor(
             sketchology.proto.AddElement, descriptorObj);
  }
  return descriptor;
};


/** @nocollapse */
sketchology.proto.AddElement.getDescriptor =
    sketchology.proto.AddElement.prototype.getDescriptor;


/** @override */
sketchology.proto.OutOfBoundsColor.prototype.getDescriptor = function() {
  var descriptor = sketchology.proto.OutOfBoundsColor.descriptor_;
  if (!descriptor) {
    // The descriptor is created lazily when we instantiate a new instance.
    var descriptorObj = {
      0: {
        name: 'OutOfBoundsColor',
        fullName: 'sketchology.proto.OutOfBoundsColor'
      },
      1: {
        name: 'rgba',
        fieldType: goog.proto2.Message.FieldType.UINT32,
        type: Number
      }
    };
    sketchology.proto.OutOfBoundsColor.descriptor_ = descriptor =
        goog.proto2.Message.createDescriptor(
             sketchology.proto.OutOfBoundsColor, descriptorObj);
  }
  return descriptor;
};


/** @nocollapse */
sketchology.proto.OutOfBoundsColor.getDescriptor =
    sketchology.proto.OutOfBoundsColor.prototype.getDescriptor;


/** @override */
sketchology.proto.SInputStream.prototype.getDescriptor = function() {
  var descriptor = sketchology.proto.SInputStream.descriptor_;
  if (!descriptor) {
    // The descriptor is created lazily when we instantiate a new instance.
    var descriptorObj = {
      0: {
        name: 'SInputStream',
        fullName: 'sketchology.proto.SInputStream'
      },
      1: {
        name: 'screen_width',
        fieldType: goog.proto2.Message.FieldType.UINT32,
        type: Number
      },
      2: {
        name: 'screen_height',
        fieldType: goog.proto2.Message.FieldType.UINT32,
        type: Number
      },
      3: {
        name: 'screen_ppi',
        fieldType: goog.proto2.Message.FieldType.FLOAT,
        type: Number
      },
      4: {
        name: 'input',
        repeated: true,
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.SInput
      }
    };
    sketchology.proto.SInputStream.descriptor_ = descriptor =
        goog.proto2.Message.createDescriptor(
             sketchology.proto.SInputStream, descriptorObj);
  }
  return descriptor;
};


/** @nocollapse */
sketchology.proto.SInputStream.getDescriptor =
    sketchology.proto.SInputStream.prototype.getDescriptor;


/** @override */
sketchology.proto.SInput.prototype.getDescriptor = function() {
  var descriptor = sketchology.proto.SInput.descriptor_;
  if (!descriptor) {
    // The descriptor is created lazily when we instantiate a new instance.
    var descriptorObj = {
      0: {
        name: 'SInput',
        fullName: 'sketchology.proto.SInput'
      },
      1: {
        name: 'type',
        fieldType: goog.proto2.Message.FieldType.ENUM,
        defaultValue: sketchology.proto.SInput.InputType.UNKNOWN,
        type: sketchology.proto.SInput.InputType
      },
      2: {
        name: 'id',
        fieldType: goog.proto2.Message.FieldType.UINT32,
        type: Number
      },
      3: {
        name: 'flags',
        fieldType: goog.proto2.Message.FieldType.UINT32,
        type: Number
      },
      4: {
        name: 'time_s',
        fieldType: goog.proto2.Message.FieldType.DOUBLE,
        type: Number
      },
      5: {
        name: 'screen_pos_x',
        fieldType: goog.proto2.Message.FieldType.FLOAT,
        type: Number
      },
      6: {
        name: 'screen_pos_y',
        fieldType: goog.proto2.Message.FieldType.FLOAT,
        type: Number
      },
      7: {
        name: 'pressure',
        fieldType: goog.proto2.Message.FieldType.FLOAT,
        type: Number
      },
      8: {
        name: 'wheel_delta',
        fieldType: goog.proto2.Message.FieldType.FLOAT,
        type: Number
      },
      9: {
        name: 'tilt',
        fieldType: goog.proto2.Message.FieldType.FLOAT,
        type: Number
      },
      10: {
        name: 'orientation',
        fieldType: goog.proto2.Message.FieldType.FLOAT,
        type: Number
      }
    };
    sketchology.proto.SInput.descriptor_ = descriptor =
        goog.proto2.Message.createDescriptor(
             sketchology.proto.SInput, descriptorObj);
  }
  return descriptor;
};


/** @nocollapse */
sketchology.proto.SInput.getDescriptor =
    sketchology.proto.SInput.prototype.getDescriptor;


/** @override */
sketchology.proto.SimulatedInput.prototype.getDescriptor = function() {
  var descriptor = sketchology.proto.SimulatedInput.descriptor_;
  if (!descriptor) {
    // The descriptor is created lazily when we instantiate a new instance.
    var descriptorObj = {
      0: {
        name: 'SimulatedInput',
        fullName: 'sketchology.proto.SimulatedInput'
      },
      1: {
        name: 'xs',
        repeated: true,
        fieldType: goog.proto2.Message.FieldType.FLOAT,
        type: Number
      },
      2: {
        name: 'ys',
        repeated: true,
        fieldType: goog.proto2.Message.FieldType.FLOAT,
        type: Number
      },
      3: {
        name: 'ts_secs',
        repeated: true,
        fieldType: goog.proto2.Message.FieldType.DOUBLE,
        type: Number
      },
      4: {
        name: 'source_details',
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.SourceDetails
      }
    };
    sketchology.proto.SimulatedInput.descriptor_ = descriptor =
        goog.proto2.Message.createDescriptor(
             sketchology.proto.SimulatedInput, descriptorObj);
  }
  return descriptor;
};


/** @nocollapse */
sketchology.proto.SimulatedInput.getDescriptor =
    sketchology.proto.SimulatedInput.prototype.getDescriptor;


/** @override */
sketchology.proto.SequencePoint.prototype.getDescriptor = function() {
  var descriptor = sketchology.proto.SequencePoint.descriptor_;
  if (!descriptor) {
    // The descriptor is created lazily when we instantiate a new instance.
    var descriptorObj = {
      0: {
        name: 'SequencePoint',
        fullName: 'sketchology.proto.SequencePoint'
      },
      1: {
        name: 'id',
        fieldType: goog.proto2.Message.FieldType.INT32,
        type: Number
      }
    };
    sketchology.proto.SequencePoint.descriptor_ = descriptor =
        goog.proto2.Message.createDescriptor(
             sketchology.proto.SequencePoint, descriptorObj);
  }
  return descriptor;
};


/** @nocollapse */
sketchology.proto.SequencePoint.getDescriptor =
    sketchology.proto.SequencePoint.prototype.getDescriptor;


/** @override */
sketchology.proto.SetCallbackFlags.prototype.getDescriptor = function() {
  var descriptor = sketchology.proto.SetCallbackFlags.descriptor_;
  if (!descriptor) {
    // The descriptor is created lazily when we instantiate a new instance.
    var descriptorObj = {
      0: {
        name: 'SetCallbackFlags',
        fullName: 'sketchology.proto.SetCallbackFlags'
      },
      1: {
        name: 'source_details',
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.SourceDetails
      },
      2: {
        name: 'callback_flags',
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.CallbackFlags
      }
    };
    sketchology.proto.SetCallbackFlags.descriptor_ = descriptor =
        goog.proto2.Message.createDescriptor(
             sketchology.proto.SetCallbackFlags, descriptorObj);
  }
  return descriptor;
};


/** @nocollapse */
sketchology.proto.SetCallbackFlags.getDescriptor =
    sketchology.proto.SetCallbackFlags.prototype.getDescriptor;


/** @override */
sketchology.proto.EngineState.prototype.getDescriptor = function() {
  var descriptor = sketchology.proto.EngineState.descriptor_;
  if (!descriptor) {
    // The descriptor is created lazily when we instantiate a new instance.
    var descriptorObj = {
      0: {
        name: 'EngineState',
        fullName: 'sketchology.proto.EngineState'
      },
      1: {
        name: 'camera_position',
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.Rect
      },
      2: {
        name: 'page_bounds',
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.Rect
      },
      3: {
        name: 'selection_is_live',
        fieldType: goog.proto2.Message.FieldType.BOOL,
        type: Boolean
      }
    };
    sketchology.proto.EngineState.descriptor_ = descriptor =
        goog.proto2.Message.createDescriptor(
             sketchology.proto.EngineState, descriptorObj);
  }
  return descriptor;
};


/** @nocollapse */
sketchology.proto.EngineState.getDescriptor =
    sketchology.proto.EngineState.prototype.getDescriptor;


/** @override */
sketchology.proto.CameraBoundsConfig.prototype.getDescriptor = function() {
  var descriptor = sketchology.proto.CameraBoundsConfig.descriptor_;
  if (!descriptor) {
    // The descriptor is created lazily when we instantiate a new instance.
    var descriptorObj = {
      0: {
        name: 'CameraBoundsConfig',
        fullName: 'sketchology.proto.CameraBoundsConfig'
      },
      1: {
        name: 'margin_left_px',
        fieldType: goog.proto2.Message.FieldType.FLOAT,
        type: Number
      },
      2: {
        name: 'margin_right_px',
        fieldType: goog.proto2.Message.FieldType.FLOAT,
        type: Number
      },
      3: {
        name: 'margin_bottom_px',
        fieldType: goog.proto2.Message.FieldType.FLOAT,
        type: Number
      },
      4: {
        name: 'margin_top_px',
        fieldType: goog.proto2.Message.FieldType.FLOAT,
        type: Number
      },
      5: {
        name: 'fraction_padding',
        fieldType: goog.proto2.Message.FieldType.FLOAT,
        defaultValue: 0.1,
        type: Number
      }
    };
    sketchology.proto.CameraBoundsConfig.descriptor_ = descriptor =
        goog.proto2.Message.createDescriptor(
             sketchology.proto.CameraBoundsConfig, descriptorObj);
  }
  return descriptor;
};


/** @nocollapse */
sketchology.proto.CameraBoundsConfig.getDescriptor =
    sketchology.proto.CameraBoundsConfig.prototype.getDescriptor;


/** @override */
sketchology.proto.ImageInfo.prototype.getDescriptor = function() {
  var descriptor = sketchology.proto.ImageInfo.descriptor_;
  if (!descriptor) {
    // The descriptor is created lazily when we instantiate a new instance.
    var descriptorObj = {
      0: {
        name: 'ImageInfo',
        fullName: 'sketchology.proto.ImageInfo'
      },
      1: {
        name: 'uri',
        fieldType: goog.proto2.Message.FieldType.STRING,
        type: String
      },
      2: {
        name: 'asset_type',
        fieldType: goog.proto2.Message.FieldType.ENUM,
        defaultValue: sketchology.proto.ImageInfo.AssetType.DEFAULT,
        type: sketchology.proto.ImageInfo.AssetType
      }
    };
    sketchology.proto.ImageInfo.descriptor_ = descriptor =
        goog.proto2.Message.createDescriptor(
             sketchology.proto.ImageInfo, descriptorObj);
  }
  return descriptor;
};


/** @nocollapse */
sketchology.proto.ImageInfo.getDescriptor =
    sketchology.proto.ImageInfo.prototype.getDescriptor;


/** @override */
sketchology.proto.ImageRect.prototype.getDescriptor = function() {
  var descriptor = sketchology.proto.ImageRect.descriptor_;
  if (!descriptor) {
    // The descriptor is created lazily when we instantiate a new instance.
    var descriptorObj = {
      0: {
        name: 'ImageRect',
        fullName: 'sketchology.proto.ImageRect'
      },
      1: {
        name: 'rect',
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.Rect
      },
      2: {
        name: 'bitmap_uri',
        fieldType: goog.proto2.Message.FieldType.STRING,
        type: String
      },
      3: {
        name: 'attributes',
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.ElementAttributes
      },
      4: {
        name: 'rotation_radians',
        fieldType: goog.proto2.Message.FieldType.FLOAT,
        type: Number
      }
    };
    sketchology.proto.ImageRect.descriptor_ = descriptor =
        goog.proto2.Message.createDescriptor(
             sketchology.proto.ImageRect, descriptorObj);
  }
  return descriptor;
};


/** @nocollapse */
sketchology.proto.ImageRect.getDescriptor =
    sketchology.proto.ImageRect.prototype.getDescriptor;


/** @override */
sketchology.proto.GridInfo.prototype.getDescriptor = function() {
  var descriptor = sketchology.proto.GridInfo.descriptor_;
  if (!descriptor) {
    // The descriptor is created lazily when we instantiate a new instance.
    var descriptorObj = {
      0: {
        name: 'GridInfo',
        fullName: 'sketchology.proto.GridInfo'
      },
      1: {
        name: 'uri',
        fieldType: goog.proto2.Message.FieldType.STRING,
        type: String
      }
    };
    sketchology.proto.GridInfo.descriptor_ = descriptor =
        goog.proto2.Message.createDescriptor(
             sketchology.proto.GridInfo, descriptorObj);
  }
  return descriptor;
};


/** @nocollapse */
sketchology.proto.GridInfo.getDescriptor =
    sketchology.proto.GridInfo.prototype.getDescriptor;


/** @override */
sketchology.proto.CreateDocument.prototype.getDescriptor = function() {
  var descriptor = sketchology.proto.CreateDocument.descriptor_;
  if (!descriptor) {
    // The descriptor is created lazily when we instantiate a new instance.
    var descriptorObj = {
      0: {
        name: 'CreateDocument',
        fullName: 'sketchology.proto.CreateDocument'
      },
      1: {
        name: 'document_type',
        fieldType: goog.proto2.Message.FieldType.ENUM,
        defaultValue: sketchology.proto.DocumentType.SINGLE_USER_DOCUMENT,
        type: sketchology.proto.DocumentType
      },
      2: {
        name: 'storage_type',
        fieldType: goog.proto2.Message.FieldType.ENUM,
        defaultValue: sketchology.proto.StorageType.IN_MEMORY_STORAGE,
        type: sketchology.proto.StorageType
      },
      3: {
        name: 'storage_path',
        fieldType: goog.proto2.Message.FieldType.STRING,
        type: String
      },
      4: {
        name: 'snapshot',
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.Snapshot
      }
    };
    sketchology.proto.CreateDocument.descriptor_ = descriptor =
        goog.proto2.Message.createDescriptor(
             sketchology.proto.CreateDocument, descriptorObj);
  }
  return descriptor;
};


/** @nocollapse */
sketchology.proto.CreateDocument.getDescriptor =
    sketchology.proto.CreateDocument.prototype.getDescriptor;


/** @override */
sketchology.proto.AddPath.prototype.getDescriptor = function() {
  var descriptor = sketchology.proto.AddPath.descriptor_;
  if (!descriptor) {
    // The descriptor is created lazily when we instantiate a new instance.
    var descriptorObj = {
      0: {
        name: 'AddPath',
        fullName: 'sketchology.proto.AddPath'
      },
      1: {
        name: 'path',
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.Path
      },
      2: {
        name: 'uuid',
        fieldType: goog.proto2.Message.FieldType.STRING,
        type: String
      }
    };
    sketchology.proto.AddPath.descriptor_ = descriptor =
        goog.proto2.Message.createDescriptor(
             sketchology.proto.AddPath, descriptorObj);
  }
  return descriptor;
};


/** @nocollapse */
sketchology.proto.AddPath.getDescriptor =
    sketchology.proto.AddPath.prototype.getDescriptor;


/** @override */
sketchology.proto.PusherPositionUpdate.prototype.getDescriptor = function() {
  var descriptor = sketchology.proto.PusherPositionUpdate.descriptor_;
  if (!descriptor) {
    // The descriptor is created lazily when we instantiate a new instance.
    var descriptorObj = {
      0: {
        name: 'PusherPositionUpdate',
        fullName: 'sketchology.proto.PusherPositionUpdate'
      },
      1: {
        name: 'uuid',
        fieldType: goog.proto2.Message.FieldType.STRING,
        type: String
      },
      2: {
        name: 'pointer_location',
        repeated: true,
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.Point
      }
    };
    sketchology.proto.PusherPositionUpdate.descriptor_ = descriptor =
        goog.proto2.Message.createDescriptor(
             sketchology.proto.PusherPositionUpdate, descriptorObj);
  }
  return descriptor;
};


/** @nocollapse */
sketchology.proto.PusherPositionUpdate.getDescriptor =
    sketchology.proto.PusherPositionUpdate.prototype.getDescriptor;


/** @override */
sketchology.proto.ElementQueryData.prototype.getDescriptor = function() {
  var descriptor = sketchology.proto.ElementQueryData.descriptor_;
  if (!descriptor) {
    // The descriptor is created lazily when we instantiate a new instance.
    var descriptorObj = {
      0: {
        name: 'ElementQueryData',
        fullName: 'sketchology.proto.ElementQueryData'
      },
      1: {
        name: 'item',
        repeated: true,
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.ElementQueryItem
      },
      2: {
        name: 'up_world_location',
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.Point
      },
      3: {
        name: 'down_world_location',
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.Point
      }
    };
    sketchology.proto.ElementQueryData.descriptor_ = descriptor =
        goog.proto2.Message.createDescriptor(
             sketchology.proto.ElementQueryData, descriptorObj);
  }
  return descriptor;
};


/** @nocollapse */
sketchology.proto.ElementQueryData.getDescriptor =
    sketchology.proto.ElementQueryData.prototype.getDescriptor;


/** @override */
sketchology.proto.ElementQueryItem.prototype.getDescriptor = function() {
  var descriptor = sketchology.proto.ElementQueryItem.descriptor_;
  if (!descriptor) {
    // The descriptor is created lazily when we instantiate a new instance.
    var descriptorObj = {
      0: {
        name: 'ElementQueryItem',
        fullName: 'sketchology.proto.ElementQueryItem'
      },
      1: {
        name: 'uuid',
        fieldType: goog.proto2.Message.FieldType.STRING,
        type: String
      },
      2: {
        name: 'world_bounds',
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.Rect
      },
      3: {
        name: 'uri',
        fieldType: goog.proto2.Message.FieldType.STRING,
        type: String
      }
    };
    sketchology.proto.ElementQueryItem.descriptor_ = descriptor =
        goog.proto2.Message.createDescriptor(
             sketchology.proto.ElementQueryItem, descriptorObj);
  }
  return descriptor;
};


/** @nocollapse */
sketchology.proto.ElementQueryItem.getDescriptor =
    sketchology.proto.ElementQueryItem.prototype.getDescriptor;


/** @override */
sketchology.proto.SelectionState.prototype.getDescriptor = function() {
  var descriptor = sketchology.proto.SelectionState.descriptor_;
  if (!descriptor) {
    // The descriptor is created lazily when we instantiate a new instance.
    var descriptorObj = {
      0: {
        name: 'SelectionState',
        fullName: 'sketchology.proto.SelectionState'
      },
      1: {
        name: 'anything_selected',
        fieldType: goog.proto2.Message.FieldType.BOOL,
        type: Boolean
      }
    };
    sketchology.proto.SelectionState.descriptor_ = descriptor =
        goog.proto2.Message.createDescriptor(
             sketchology.proto.SelectionState, descriptorObj);
  }
  return descriptor;
};


/** @nocollapse */
sketchology.proto.SelectionState.getDescriptor =
    sketchology.proto.SelectionState.prototype.getDescriptor;


/** @override */
sketchology.proto.ToolEvent.prototype.getDescriptor = function() {
  var descriptor = sketchology.proto.ToolEvent.descriptor_;
  if (!descriptor) {
    // The descriptor is created lazily when we instantiate a new instance.
    var descriptorObj = {
      0: {
        name: 'ToolEvent',
        fullName: 'sketchology.proto.ToolEvent'
      },
      1: {
        name: 'pusher_position_update',
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.PusherPositionUpdate
      },
      2: {
        name: 'element_query_data',
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.ElementQueryData
      },
      3: {
        name: 'selection_state',
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.SelectionState
      }
    };
    sketchology.proto.ToolEvent.descriptor_ = descriptor =
        goog.proto2.Message.createDescriptor(
             sketchology.proto.ToolEvent, descriptorObj);
  }
  return descriptor;
};


/** @nocollapse */
sketchology.proto.ToolEvent.getDescriptor =
    sketchology.proto.ToolEvent.prototype.getDescriptor;
