% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/set_methods.R
\name{covariates_names}
\alias{covariates_names}
\alias{covariates_names<-}
\alias{covariates_names,MOFA-method}
\alias{covariates,MOFA-method}
\alias{covariates_names<-,MOFA,vector-method}
\title{covariates_names: set and retrieve covariate names}
\usage{
covariates_names(object)

covariates_names(object) <- value

\S4method{covariates_names}{MOFA}(object)

\S4method{covariates_names}{MOFA,vector}(object) <- value
}
\arguments{
\item{object}{a \code{\link{MOFA}} object.}

\item{value}{a character vector of covariate names}
}
\value{
character vector with the covariate names
}
\description{
covariates_names: set and retrieve covariate names
}
\examples{
# Using an existing trained model on simulated data
file <- system.file("extdata", "MEFISTO_model.hdf5", package = "MOFA2")
model <- load_model(file)
covariates_names(model)
}
