% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BreakpointGRanges.R
\name{partner}
\alias{partner}
\title{GRanges representing the breakend coordinates of
structural variants
#@export
Partner breakend for each breakend.}
\usage{
partner(gr, selfPartnerSingleBreakends = FALSE)
}
\arguments{
\item{gr}{GRanges object of SV breakends}

\item{selfPartnerSingleBreakends}{treat single breakends as their own partner.}
}
\value{
A GRanges object in which each entry is the partner breakend of
those in the input object.
}
\description{
GRanges representing the breakend coordinates of
structural variants
#@export
Partner breakend for each breakend.
}
\details{
All breakends must have their partner breakend included
in the GRanges.
}
\examples{
#reading in a VCF file as \code{vcf}
vcf.file <- system.file("extdata", "gridss.vcf", package = "StructuralVariantAnnotation")
vcf <- VariantAnnotation::readVcf(vcf.file, "hg19")
#parsing \code{vcf} to GRanges object \code{gr}
gr <- breakpointRanges(vcf)
#output partner breakend of each breakend in \code{gr}
partner(gr)
}
