% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/credentials_user_oauth2.R
\name{credentials_user_oauth2}
\alias{credentials_user_oauth2}
\title{Get an OAuth token for a user}
\usage{
credentials_user_oauth2(
  scopes = NULL,
  app = gargle_client(),
  package = "gargle",
  ...
)
}
\arguments{
\item{scopes}{A character vector of scopes to request. Pick from those listed
at \url{https://developers.google.com/identity/protocols/oauth2/scopes}.

For certain token flows, the
\code{"https://www.googleapis.com/auth/userinfo.email"} scope is unconditionally
included. This grants permission to retrieve the email address associated
with a token; gargle uses this to index cached OAuth tokens. This grants no
permission to view or send email and is generally considered a low-value
scope.}

\item{app}{A Google OAuth client, preferably constructed via
\code{\link[=gargle_oauth_client_from_json]{gargle_oauth_client_from_json()}}, which returns an instance of
\code{gargle_oauth_client}. For backwards compatibility, for a limited time,
gargle will still accept an "OAuth app" created with \code{\link[httr:oauth_app]{httr::oauth_app()}}.}

\item{package}{Name of the package requesting a token. Used in messages.}

\item{...}{
  Arguments passed on to \code{\link[=gargle2.0_token]{gargle2.0_token}}
  \describe{
    \item{\code{email}}{Optional. Allows user to target a specific Google identity. If
specified, this is used for token lookup, i.e. to determine if a suitable
token is already available in the cache. If no such token is found, \code{email}
is used to pre-select the targetted Google identity in the OAuth chooser.
Note, however, that the email associated with a token when it's cached is
always determined from the token itself, never from this argument. Use \code{NA}
or \code{FALSE} to match nothing and force the OAuth dance in the browser. Use
\code{TRUE} to allow email auto-discovery, if exactly one matching token is
found in the cache. Specify just the domain with a glob pattern, e.g.
\code{"*@example.com"}, to create code that "just works" for both
\code{alice@example.com} and \code{bob@example.com}. Defaults to the option named
"gargle_oauth_email", retrieved by \code{\link[=gargle_oauth_email]{gargle_oauth_email()}}.}
    \item{\code{use_oob}}{Whether to prefer out-of-band authentication. Defaults to the
value returned by \code{\link[=gargle_oob_default]{gargle_oob_default()}}.}
    \item{\code{cache}}{Specifies the OAuth token cache. Defaults to the option named
\code{"gargle_oauth_cache"}, retrieved via \code{\link[=gargle_oauth_cache]{gargle_oauth_cache()}}.}
    \item{\code{credentials}}{Advanced use only: allows you to completely customise
token generation.}
  }}
}
\value{
A \link{Gargle2.0} token.
}
\description{
Consults the token cache for a suitable OAuth token and, if
unsuccessful, gets a token via the browser flow. A cached token is suitable
if it's compatible with the user's request in this sense:
\itemize{
\item OAuth client must be same.
\item Scopes must be same.
\item Email, if provided, must be same. If specified email is a glob pattern
like \code{"*@example.com"}, email matching is done at the domain level.
}

gargle is very conservative about using OAuth tokens discovered in the user's
cache and will generally seek interactive confirmation. Therefore, in a
non-interactive setting, it's important to explicitly specify the \code{"email"}
of the target account or to explicitly authorize automatic discovery. See
\code{\link[=gargle2.0_token]{gargle2.0_token()}}, which this function wraps, for more. Non-interactive use
also suggests it might be time to use a \link[=credentials_service_account]{service account token} or \link[=credentials_external_account]{workload identity federation}.
}
\examples{
\dontrun{
# Drive scope, built-in gargle demo client
scopes <- "https://www.googleapis.com/auth/drive"
credentials_user_oauth2(scopes, app = gargle_client())

# bring your own client
client <- gargle_oauth_client_from_json(
  path = "/path/to/the/JSON/you/downloaded/from/gcp/console.json",
  name = "my-nifty-oauth-client"
)
credentials_user_oauth2(scopes, client)
}
}
\seealso{
Other credential functions: 
\code{\link{credentials_app_default}()},
\code{\link{credentials_byo_oauth2}()},
\code{\link{credentials_external_account}()},
\code{\link{credentials_gce}()},
\code{\link{credentials_service_account}()},
\code{\link{token_fetch}()}
}
\concept{credential functions}
