% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout_matrix.R
\name{layout_tbl_graph_matrix}
\alias{layout_tbl_graph_matrix}
\title{Place nodes on a diagonal}
\usage{
layout_tbl_graph_matrix(graph, circular = FALSE, sort.by = NULL)
}
\arguments{
\item{graph}{An \code{tbl_graph} object}

\item{circular}{Ignored}

\item{sort.by}{An expression providing the sorting of the nodes. If \code{NULL}
the nodes will be ordered by their index in the graph.}
}
\value{
A data.frame with the columns \code{x}, \code{y}, \code{circular} as
well as any information stored as node variables in the tbl_graph object.
}
\description{
This layout puts all nodes on a diagonal, thus preparing the layout for use
with \code{\link[=geom_edge_point]{geom_edge_point()}} resulting in a matrix layout. While matrix
layouts excel in scalability, the interpretation of the visual is very
dependent on the sorting of the nodes. Different sorting algorithms have been
implemented in \code{tidygraph} and these can be used directly. Behrisch
\emph{et al.} (2016) have provided a nice overview of some of the different
sorting algorithms and what insight they might bring, along with a rundown of
different patterns to look out for.
}
\references{
Behrisch, M., Bach, B., Riche, N. H., Schreck, T., Fekete, J.-D. (2016).
\emph{Matrix Reordering Methods for Table and Network Visualization}.
Computer Graphics Forum, 35: 693–716. \doi{10.1111/cgf.12935}
}
\seealso{
Other layout_tbl_graph_*: 
\code{\link{layout_tbl_graph_auto}()},
\code{\link{layout_tbl_graph_backbone}()},
\code{\link{layout_tbl_graph_centrality}()},
\code{\link{layout_tbl_graph_circlepack}()},
\code{\link{layout_tbl_graph_dendrogram}()},
\code{\link{layout_tbl_graph_eigen}()},
\code{\link{layout_tbl_graph_fabric}()},
\code{\link{layout_tbl_graph_focus}()},
\code{\link{layout_tbl_graph_hive}()},
\code{\link{layout_tbl_graph_igraph}()},
\code{\link{layout_tbl_graph_linear}()},
\code{\link{layout_tbl_graph_manual}()},
\code{\link{layout_tbl_graph_partition}()},
\code{\link{layout_tbl_graph_pmds}()},
\code{\link{layout_tbl_graph_stress}()},
\code{\link{layout_tbl_graph_treemap}()},
\code{\link{layout_tbl_graph_unrooted}()}
}
\concept{layout_tbl_graph_*}
