% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rbind.R
\name{rbind.mids}
\alias{rbind.mids}
\title{Combine \code{mids} objects by rows}
\usage{
rbind.mids(x, y = NULL, ...)
}
\arguments{
\item{x}{A \code{mids} object.}

\item{y}{A \code{mids} object, or a \code{data.frame}, \code{matrix}, \code{factor}
or \code{vector}.}

\item{\dots}{Additional \code{data.frame}, \code{matrix}, \code{vector} or \code{factor}.
These can be given as named arguments.}
}
\value{
An S3 object of class \code{mids}
}
\description{
This function combines two \code{mids} objects rowwise into a single
\code{mids} object, or combines a \code{mids} object with a vector, matrix,
factor or dataframe rowwise into a \code{mids} object.
}
\details{
If \code{y} is a
\code{mids} object, then \code{rbind} requires that the number of
multiple imputations in \code{x} and \code{y} is identical. Also,
columns of \code{x$data} and \code{y$data} should match.

If \code{y} is not a \code{mids} object, the columns of \code{x$data}
and \code{y} should match. The \code{where} matrix for \code{y} is set
to \code{FALSE}, signaling that any missing values
in \code{y} were not imputed. The \code{ignore} vector for \code{y} is
set to \code{FALSE}, elements of \code{y} will therefore influence
the parameters of the imputation model in future iterations.
}
\note{
The function construct the elements of the new \code{mids} object as follows:
\tabular{ll}{
\code{data}     \tab Rowwise combination of the (incomplete) data in \code{x} and \code{y}\cr
\code{imp}      \tab Equals \code{rbind(x$imp[[j]], y$imp[[j]])} if \code{y} is \code{mids} object; otherwise
the data of \code{y} will be copied\cr
\code{m}        \tab Equals \code{x$m}\cr
\code{where}    \tab Rowwise combination of \code{where} arguments\cr
\code{blocks}   \tab Equals \code{x$blocks}\cr
\code{call}     \tab Vector, \code{call[1]} creates \code{x}, \code{call[2]} is call to \code{rbind.mids}\cr
\code{nmis}     \tab \code{x$nmis} + \code{y$nmis}\cr
\code{method}   \tab Taken from \code{x$method}\cr
\code{predictorMatrix} \tab Taken from \code{x$predictorMatrix}\cr
\code{visitSequence}   \tab Taken from \code{x$visitSequence}\cr
\code{formulas}  \tab Taken from \code{x$formulas}\cr
\code{post}      \tab Taken from \code{x$post}\cr
\code{blots}     \tab Taken from \code{x$blots}\cr
\code{ignore}    \tab Concatenate \code{x$ignore} and \code{y$ignore}\cr
\code{seed}            \tab Taken from \code{x$seed}\cr
\code{iteration}       \tab Taken from \code{x$iteration}\cr
\code{lastSeedValue}   \tab Taken from \code{x$lastSeedValue}\cr
\code{chainMean}       \tab Set to \code{NA}\cr
\code{chainVar}        \tab Set to \code{NA}\cr
\code{loggedEvents}    \tab Taken from \code{x$loggedEvents}\cr
\code{version}    \tab Taken from \code{x$version}\cr
\code{date}       \tab Taken from \code{x$date}
}
}
\examples{
imp1 <- mice(nhanes[1:13, ], m = 2, maxit = 1, print = FALSE)
imp5 <- mice(nhanes[1:13, ], m = 2, maxit = 2, print = FALSE)
mylist <- list(age = NA, bmi = NA, hyp = NA, chl = NA)

nrow(complete(rbind(imp1, imp5)))
nrow(complete(rbind(imp1, mylist)))

nrow(complete(rbind(imp1, data.frame(mylist))))
nrow(complete(rbind(imp1, complete(imp5))))
}
\references{
van Buuren S and Groothuis-Oudshoorn K (2011). \code{mice}:
Multivariate Imputation by Chained Equations in \code{R}. \emph{Journal of
Statistical Software}, \bold{45}(3), 1-67.
\doi{10.18637/jss.v045.i03}
}
\seealso{
\code{\link{cbind.mids}}, \code{\link{ibind}}, \code{\link[=mids-class]{mids}}
}
\author{
Karin Groothuis-Oudshoorn, Stef van Buuren
}
\keyword{manip}
