% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/env-binding.R
\name{env_unbind}
\alias{env_unbind}
\title{Remove bindings from an environment}
\usage{
env_unbind(env = caller_env(), nms, inherit = FALSE)
}
\arguments{
\item{env}{An environment.}

\item{nms}{A character vector containing the names of the bindings
to remove.}

\item{inherit}{Whether to look for bindings in the parent
environments.}
}
\value{
The input object \code{env} with its associated environment
modified in place, invisibly.
}
\description{
\code{env_unbind()} is the complement of \code{\link[=env_bind]{env_bind()}}. Like \code{env_has()},
it ignores the parent environments of \code{env} by default. Set
\code{inherit} to \code{TRUE} to track down bindings in parent environments.
}
\examples{
data <- set_names(as_list(letters), letters)
env_bind(environment(), !!! data)
env_has(environment(), letters)

# env_unbind() removes bindings:
env_unbind(environment(), letters)
env_has(environment(), letters)

# With inherit = TRUE, it removes bindings in parent environments
# as well:
parent <- child_env(NULL, foo = "a")
env <- child_env(parent, foo = "b")
env_unbind(env, "foo", inherit = TRUE)
env_has(env, "foo", inherit = TRUE)
}
