### WARNING: This file is auto-generated by our OpenAPI spec. Do not
### edit it manually.

require_relative '../../resource_includes/response_helper'

module Asana
  module Resources
    class UserTaskListsBase < Resource

      def self.inherited(base)
        Registry.register(base)
      end

      class << self
        # Get a user task list
        #
        # user_task_list_gid - [str]  (required) Globally unique identifier for the user task list.
        # options - [Hash] the request I/O options
        # > opt_fields - [list[str]]  Defines fields to return. Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below. The id of included objects will always be returned, regardless of the field options.
        # > opt_pretty - [bool]  Provides “pretty” output. Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
        def get_user_task_list(client, user_task_list_gid: required("user_task_list_gid"), options: {})
          path = "/user_task_lists/{user_task_list_gid}"
          path["{user_task_list_gid}"] = user_task_list_gid
          UserTaskList.new(parse(client.get(path, options: options)).first, client: client)
        end

        # Get a user's task list
        #
        # user_gid - [str]  (required) A string identifying a user. This can either be the string \"me\", an email, or the gid of a user.
        # workspace - [str]  (required) The workspace in which to get the user task list.
        # options - [Hash] the request I/O options
        # > opt_fields - [list[str]]  Defines fields to return. Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below. The id of included objects will always be returned, regardless of the field options.
        # > opt_pretty - [bool]  Provides “pretty” output. Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
        def get_user_task_list_for_user(client, user_gid: required("user_gid"), workspace: nil, options: {})
          path = "/users/{user_gid}/user_task_list"
          path["{user_gid}"] = user_gid
          params = { workspace: workspace }.reject { |_,v| v.nil? || Array(v).empty? }
          UserTaskList.new(parse(client.get(path, params: params, options: options)).first, client: client)
        end

      end
    end
  end
end
