# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator 1.2.2.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::ARM::EventHub
  #
  # Azure Event Hubs client
  #
  class EventHubs
    include MsRestAzure

    #
    # Creates and initializes a new instance of the EventHubs class.
    # @param client service class for accessing basic functionality.
    #
    def initialize(client)
      @client = client
    end

    # @return [EventHubManagementClient] reference to the EventHubManagementClient
    attr_reader :client

    #
    # Gets all the Event Hubs in a Namespace.
    #
    # @param resource_group_name [String] Name of the resource group within the
    # azure subscription.
    # @param namespace_name [String] The Namespace name
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<Eventhub>] operation results.
    #
    def list_by_namespace(resource_group_name, namespace_name, custom_headers = nil)
      first_page = list_by_namespace_as_lazy(resource_group_name, namespace_name, custom_headers)
      first_page.get_all_items
    end

    #
    # Gets all the Event Hubs in a Namespace.
    #
    # @param resource_group_name [String] Name of the resource group within the
    # azure subscription.
    # @param namespace_name [String] The Namespace name
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_by_namespace_with_http_info(resource_group_name, namespace_name, custom_headers = nil)
      list_by_namespace_async(resource_group_name, namespace_name, custom_headers).value!
    end

    #
    # Gets all the Event Hubs in a Namespace.
    #
    # @param resource_group_name [String] Name of the resource group within the
    # azure subscription.
    # @param namespace_name [String] The Namespace name
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_by_namespace_async(resource_group_name, namespace_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'namespace_name is nil' if namespace_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/eventhubs'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'namespaceName' => namespace_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::EventHub::Models::EventHubListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Creates or updates a new Event Hub as a nested resource within a Namespace.
    #
    # @param resource_group_name [String] Name of the resource group within the
    # azure subscription.
    # @param namespace_name [String] The Namespace name
    # @param event_hub_name [String] The Event Hub name
    # @param parameters [Eventhub] Parameters supplied to create an Event Hub
    # resource.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Eventhub] operation results.
    #
    def create_or_update(resource_group_name, namespace_name, event_hub_name, parameters, custom_headers = nil)
      response = create_or_update_async(resource_group_name, namespace_name, event_hub_name, parameters, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Creates or updates a new Event Hub as a nested resource within a Namespace.
    #
    # @param resource_group_name [String] Name of the resource group within the
    # azure subscription.
    # @param namespace_name [String] The Namespace name
    # @param event_hub_name [String] The Event Hub name
    # @param parameters [Eventhub] Parameters supplied to create an Event Hub
    # resource.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def create_or_update_with_http_info(resource_group_name, namespace_name, event_hub_name, parameters, custom_headers = nil)
      create_or_update_async(resource_group_name, namespace_name, event_hub_name, parameters, custom_headers).value!
    end

    #
    # Creates or updates a new Event Hub as a nested resource within a Namespace.
    #
    # @param resource_group_name [String] Name of the resource group within the
    # azure subscription.
    # @param namespace_name [String] The Namespace name
    # @param event_hub_name [String] The Event Hub name
    # @param parameters [Eventhub] Parameters supplied to create an Event Hub
    # resource.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def create_or_update_async(resource_group_name, namespace_name, event_hub_name, parameters, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'namespace_name is nil' if namespace_name.nil?
      fail ArgumentError, 'event_hub_name is nil' if event_hub_name.nil?
      fail ArgumentError, 'parameters is nil' if parameters.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::EventHub::Models::Eventhub.mapper()
      request_content = @client.serialize(request_mapper,  parameters)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/eventhubs/{eventHubName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'namespaceName' => namespace_name,'eventHubName' => event_hub_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::EventHub::Models::Eventhub.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Deletes an Event Hub from the specified Namespace and resource group.
    #
    # @param resource_group_name [String] Name of the resource group within the
    # azure subscription.
    # @param namespace_name [String] The Namespace name
    # @param event_hub_name [String] The Event Hub name
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def delete(resource_group_name, namespace_name, event_hub_name, custom_headers = nil)
      response = delete_async(resource_group_name, namespace_name, event_hub_name, custom_headers).value!
      nil
    end

    #
    # Deletes an Event Hub from the specified Namespace and resource group.
    #
    # @param resource_group_name [String] Name of the resource group within the
    # azure subscription.
    # @param namespace_name [String] The Namespace name
    # @param event_hub_name [String] The Event Hub name
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_with_http_info(resource_group_name, namespace_name, event_hub_name, custom_headers = nil)
      delete_async(resource_group_name, namespace_name, event_hub_name, custom_headers).value!
    end

    #
    # Deletes an Event Hub from the specified Namespace and resource group.
    #
    # @param resource_group_name [String] Name of the resource group within the
    # azure subscription.
    # @param namespace_name [String] The Namespace name
    # @param event_hub_name [String] The Event Hub name
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_async(resource_group_name, namespace_name, event_hub_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'namespace_name is nil' if namespace_name.nil?
      fail ArgumentError, 'event_hub_name is nil' if event_hub_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/eventhubs/{eventHubName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'namespaceName' => namespace_name,'eventHubName' => event_hub_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 204 || status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Gets an Event Hubs description for the specified Event Hub.
    #
    # @param resource_group_name [String] Name of the resource group within the
    # azure subscription.
    # @param namespace_name [String] The Namespace name
    # @param event_hub_name [String] The Event Hub name
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Eventhub] operation results.
    #
    def get(resource_group_name, namespace_name, event_hub_name, custom_headers = nil)
      response = get_async(resource_group_name, namespace_name, event_hub_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets an Event Hubs description for the specified Event Hub.
    #
    # @param resource_group_name [String] Name of the resource group within the
    # azure subscription.
    # @param namespace_name [String] The Namespace name
    # @param event_hub_name [String] The Event Hub name
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_with_http_info(resource_group_name, namespace_name, event_hub_name, custom_headers = nil)
      get_async(resource_group_name, namespace_name, event_hub_name, custom_headers).value!
    end

    #
    # Gets an Event Hubs description for the specified Event Hub.
    #
    # @param resource_group_name [String] Name of the resource group within the
    # azure subscription.
    # @param namespace_name [String] The Namespace name
    # @param event_hub_name [String] The Event Hub name
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_async(resource_group_name, namespace_name, event_hub_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'namespace_name is nil' if namespace_name.nil?
      fail ArgumentError, 'event_hub_name is nil' if event_hub_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/eventhubs/{eventHubName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'namespaceName' => namespace_name,'eventHubName' => event_hub_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::EventHub::Models::Eventhub.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the authorization rules for an Event Hub.
    #
    # @param resource_group_name [String] Name of the resource group within the
    # azure subscription.
    # @param namespace_name [String] The Namespace name
    # @param event_hub_name [String] The Event Hub name
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<AuthorizationRule>] operation results.
    #
    def list_authorization_rules(resource_group_name, namespace_name, event_hub_name, custom_headers = nil)
      first_page = list_authorization_rules_as_lazy(resource_group_name, namespace_name, event_hub_name, custom_headers)
      first_page.get_all_items
    end

    #
    # Gets the authorization rules for an Event Hub.
    #
    # @param resource_group_name [String] Name of the resource group within the
    # azure subscription.
    # @param namespace_name [String] The Namespace name
    # @param event_hub_name [String] The Event Hub name
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_authorization_rules_with_http_info(resource_group_name, namespace_name, event_hub_name, custom_headers = nil)
      list_authorization_rules_async(resource_group_name, namespace_name, event_hub_name, custom_headers).value!
    end

    #
    # Gets the authorization rules for an Event Hub.
    #
    # @param resource_group_name [String] Name of the resource group within the
    # azure subscription.
    # @param namespace_name [String] The Namespace name
    # @param event_hub_name [String] The Event Hub name
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_authorization_rules_async(resource_group_name, namespace_name, event_hub_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'namespace_name is nil' if namespace_name.nil?
      fail ArgumentError, 'event_hub_name is nil' if event_hub_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/eventhubs/{eventHubName}/authorizationRules'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'namespaceName' => namespace_name,'eventHubName' => event_hub_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::EventHub::Models::AuthorizationRuleListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Creates or updates an AuthorizationRule for the specified Event Hub.
    #
    # @param resource_group_name [String] Name of the resource group within the
    # azure subscription.
    # @param namespace_name [String] The Namespace name
    # @param event_hub_name [String] The Event Hub name
    # @param authorization_rule_name [String] The authorization rule name.
    # @param parameters [AuthorizationRule] The shared access AuthorizationRule.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [AuthorizationRule] operation results.
    #
    def create_or_update_authorization_rule(resource_group_name, namespace_name, event_hub_name, authorization_rule_name, parameters, custom_headers = nil)
      response = create_or_update_authorization_rule_async(resource_group_name, namespace_name, event_hub_name, authorization_rule_name, parameters, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Creates or updates an AuthorizationRule for the specified Event Hub.
    #
    # @param resource_group_name [String] Name of the resource group within the
    # azure subscription.
    # @param namespace_name [String] The Namespace name
    # @param event_hub_name [String] The Event Hub name
    # @param authorization_rule_name [String] The authorization rule name.
    # @param parameters [AuthorizationRule] The shared access AuthorizationRule.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def create_or_update_authorization_rule_with_http_info(resource_group_name, namespace_name, event_hub_name, authorization_rule_name, parameters, custom_headers = nil)
      create_or_update_authorization_rule_async(resource_group_name, namespace_name, event_hub_name, authorization_rule_name, parameters, custom_headers).value!
    end

    #
    # Creates or updates an AuthorizationRule for the specified Event Hub.
    #
    # @param resource_group_name [String] Name of the resource group within the
    # azure subscription.
    # @param namespace_name [String] The Namespace name
    # @param event_hub_name [String] The Event Hub name
    # @param authorization_rule_name [String] The authorization rule name.
    # @param parameters [AuthorizationRule] The shared access AuthorizationRule.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def create_or_update_authorization_rule_async(resource_group_name, namespace_name, event_hub_name, authorization_rule_name, parameters, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'namespace_name is nil' if namespace_name.nil?
      fail ArgumentError, 'event_hub_name is nil' if event_hub_name.nil?
      fail ArgumentError, 'authorization_rule_name is nil' if authorization_rule_name.nil?
      fail ArgumentError, 'parameters is nil' if parameters.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::EventHub::Models::AuthorizationRule.mapper()
      request_content = @client.serialize(request_mapper,  parameters)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/eventhubs/{eventHubName}/authorizationRules/{authorizationRuleName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'namespaceName' => namespace_name,'eventHubName' => event_hub_name,'authorizationRuleName' => authorization_rule_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::EventHub::Models::AuthorizationRule.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets an AuthorizationRule for an Event Hub by rule name.
    #
    # @param resource_group_name [String] Name of the resource group within the
    # azure subscription.
    # @param namespace_name [String] The Namespace name
    # @param event_hub_name [String] The Event Hub name
    # @param authorization_rule_name [String] The authorization rule name.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [AuthorizationRule] operation results.
    #
    def get_authorization_rule(resource_group_name, namespace_name, event_hub_name, authorization_rule_name, custom_headers = nil)
      response = get_authorization_rule_async(resource_group_name, namespace_name, event_hub_name, authorization_rule_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets an AuthorizationRule for an Event Hub by rule name.
    #
    # @param resource_group_name [String] Name of the resource group within the
    # azure subscription.
    # @param namespace_name [String] The Namespace name
    # @param event_hub_name [String] The Event Hub name
    # @param authorization_rule_name [String] The authorization rule name.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_authorization_rule_with_http_info(resource_group_name, namespace_name, event_hub_name, authorization_rule_name, custom_headers = nil)
      get_authorization_rule_async(resource_group_name, namespace_name, event_hub_name, authorization_rule_name, custom_headers).value!
    end

    #
    # Gets an AuthorizationRule for an Event Hub by rule name.
    #
    # @param resource_group_name [String] Name of the resource group within the
    # azure subscription.
    # @param namespace_name [String] The Namespace name
    # @param event_hub_name [String] The Event Hub name
    # @param authorization_rule_name [String] The authorization rule name.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_authorization_rule_async(resource_group_name, namespace_name, event_hub_name, authorization_rule_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'namespace_name is nil' if namespace_name.nil?
      fail ArgumentError, 'event_hub_name is nil' if event_hub_name.nil?
      fail ArgumentError, 'authorization_rule_name is nil' if authorization_rule_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/eventhubs/{eventHubName}/authorizationRules/{authorizationRuleName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'namespaceName' => namespace_name,'eventHubName' => event_hub_name,'authorizationRuleName' => authorization_rule_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::EventHub::Models::AuthorizationRule.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Deletes an Event Hub AuthorizationRule.
    #
    # @param resource_group_name [String] Name of the resource group within the
    # azure subscription.
    # @param namespace_name [String] The Namespace name
    # @param event_hub_name [String] The Event Hub name
    # @param authorization_rule_name [String] The authorization rule name.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def delete_authorization_rule(resource_group_name, namespace_name, event_hub_name, authorization_rule_name, custom_headers = nil)
      response = delete_authorization_rule_async(resource_group_name, namespace_name, event_hub_name, authorization_rule_name, custom_headers).value!
      nil
    end

    #
    # Deletes an Event Hub AuthorizationRule.
    #
    # @param resource_group_name [String] Name of the resource group within the
    # azure subscription.
    # @param namespace_name [String] The Namespace name
    # @param event_hub_name [String] The Event Hub name
    # @param authorization_rule_name [String] The authorization rule name.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_authorization_rule_with_http_info(resource_group_name, namespace_name, event_hub_name, authorization_rule_name, custom_headers = nil)
      delete_authorization_rule_async(resource_group_name, namespace_name, event_hub_name, authorization_rule_name, custom_headers).value!
    end

    #
    # Deletes an Event Hub AuthorizationRule.
    #
    # @param resource_group_name [String] Name of the resource group within the
    # azure subscription.
    # @param namespace_name [String] The Namespace name
    # @param event_hub_name [String] The Event Hub name
    # @param authorization_rule_name [String] The authorization rule name.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_authorization_rule_async(resource_group_name, namespace_name, event_hub_name, authorization_rule_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'namespace_name is nil' if namespace_name.nil?
      fail ArgumentError, 'event_hub_name is nil' if event_hub_name.nil?
      fail ArgumentError, 'authorization_rule_name is nil' if authorization_rule_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/eventhubs/{eventHubName}/authorizationRules/{authorizationRuleName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'namespaceName' => namespace_name,'eventHubName' => event_hub_name,'authorizationRuleName' => authorization_rule_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 204 || status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Gets the ACS and SAS connection strings for the Event Hub.
    #
    # @param resource_group_name [String] Name of the resource group within the
    # azure subscription.
    # @param namespace_name [String] The Namespace name
    # @param event_hub_name [String] The Event Hub name
    # @param authorization_rule_name [String] The authorization rule name.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [AccessKeys] operation results.
    #
    def list_keys(resource_group_name, namespace_name, event_hub_name, authorization_rule_name, custom_headers = nil)
      response = list_keys_async(resource_group_name, namespace_name, event_hub_name, authorization_rule_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the ACS and SAS connection strings for the Event Hub.
    #
    # @param resource_group_name [String] Name of the resource group within the
    # azure subscription.
    # @param namespace_name [String] The Namespace name
    # @param event_hub_name [String] The Event Hub name
    # @param authorization_rule_name [String] The authorization rule name.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_keys_with_http_info(resource_group_name, namespace_name, event_hub_name, authorization_rule_name, custom_headers = nil)
      list_keys_async(resource_group_name, namespace_name, event_hub_name, authorization_rule_name, custom_headers).value!
    end

    #
    # Gets the ACS and SAS connection strings for the Event Hub.
    #
    # @param resource_group_name [String] Name of the resource group within the
    # azure subscription.
    # @param namespace_name [String] The Namespace name
    # @param event_hub_name [String] The Event Hub name
    # @param authorization_rule_name [String] The authorization rule name.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_keys_async(resource_group_name, namespace_name, event_hub_name, authorization_rule_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'namespace_name is nil' if namespace_name.nil?
      fail ArgumentError, 'event_hub_name is nil' if event_hub_name.nil?
      fail ArgumentError, 'authorization_rule_name is nil' if authorization_rule_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/eventhubs/{eventHubName}/authorizationRules/{authorizationRuleName}/ListKeys'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'namespaceName' => namespace_name,'eventHubName' => event_hub_name,'authorizationRuleName' => authorization_rule_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::EventHub::Models::AccessKeys.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Regenerates the ACS and SAS connection strings for the Event Hub.
    #
    # @param resource_group_name [String] Name of the resource group within the
    # azure subscription.
    # @param namespace_name [String] The Namespace name
    # @param event_hub_name [String] The Event Hub name
    # @param authorization_rule_name [String] The authorization rule name.
    # @param parameters [RegenerateAccessKeyParameters] Parameters supplied to
    # regenerate the AuthorizationRule Keys (PrimaryKey/SecondaryKey).
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [AccessKeys] operation results.
    #
    def regenerate_keys(resource_group_name, namespace_name, event_hub_name, authorization_rule_name, parameters, custom_headers = nil)
      response = regenerate_keys_async(resource_group_name, namespace_name, event_hub_name, authorization_rule_name, parameters, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Regenerates the ACS and SAS connection strings for the Event Hub.
    #
    # @param resource_group_name [String] Name of the resource group within the
    # azure subscription.
    # @param namespace_name [String] The Namespace name
    # @param event_hub_name [String] The Event Hub name
    # @param authorization_rule_name [String] The authorization rule name.
    # @param parameters [RegenerateAccessKeyParameters] Parameters supplied to
    # regenerate the AuthorizationRule Keys (PrimaryKey/SecondaryKey).
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def regenerate_keys_with_http_info(resource_group_name, namespace_name, event_hub_name, authorization_rule_name, parameters, custom_headers = nil)
      regenerate_keys_async(resource_group_name, namespace_name, event_hub_name, authorization_rule_name, parameters, custom_headers).value!
    end

    #
    # Regenerates the ACS and SAS connection strings for the Event Hub.
    #
    # @param resource_group_name [String] Name of the resource group within the
    # azure subscription.
    # @param namespace_name [String] The Namespace name
    # @param event_hub_name [String] The Event Hub name
    # @param authorization_rule_name [String] The authorization rule name.
    # @param parameters [RegenerateAccessKeyParameters] Parameters supplied to
    # regenerate the AuthorizationRule Keys (PrimaryKey/SecondaryKey).
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def regenerate_keys_async(resource_group_name, namespace_name, event_hub_name, authorization_rule_name, parameters, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'namespace_name is nil' if namespace_name.nil?
      fail ArgumentError, 'event_hub_name is nil' if event_hub_name.nil?
      fail ArgumentError, 'authorization_rule_name is nil' if authorization_rule_name.nil?
      fail ArgumentError, 'parameters is nil' if parameters.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::EventHub::Models::RegenerateAccessKeyParameters.mapper()
      request_content = @client.serialize(request_mapper,  parameters)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/eventhubs/{eventHubName}/authorizationRules/{authorizationRuleName}/regenerateKeys'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'namespaceName' => namespace_name,'eventHubName' => event_hub_name,'authorizationRuleName' => authorization_rule_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::EventHub::Models::AccessKeys.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets all the Event Hubs in a Namespace.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [EventHubListResult] operation results.
    #
    def list_by_namespace_next(next_page_link, custom_headers = nil)
      response = list_by_namespace_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets all the Event Hubs in a Namespace.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_by_namespace_next_with_http_info(next_page_link, custom_headers = nil)
      list_by_namespace_next_async(next_page_link, custom_headers).value!
    end

    #
    # Gets all the Event Hubs in a Namespace.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_by_namespace_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::EventHub::Models::EventHubListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the authorization rules for an Event Hub.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [AuthorizationRuleListResult] operation results.
    #
    def list_authorization_rules_next(next_page_link, custom_headers = nil)
      response = list_authorization_rules_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the authorization rules for an Event Hub.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_authorization_rules_next_with_http_info(next_page_link, custom_headers = nil)
      list_authorization_rules_next_async(next_page_link, custom_headers).value!
    end

    #
    # Gets the authorization rules for an Event Hub.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_authorization_rules_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::EventHub::Models::AuthorizationRuleListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets all the Event Hubs in a Namespace.
    #
    # @param resource_group_name [String] Name of the resource group within the
    # azure subscription.
    # @param namespace_name [String] The Namespace name
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [EventHubListResult] which provide lazy access to pages of the
    # response.
    #
    def list_by_namespace_as_lazy(resource_group_name, namespace_name, custom_headers = nil)
      response = list_by_namespace_async(resource_group_name, namespace_name, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_by_namespace_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Gets the authorization rules for an Event Hub.
    #
    # @param resource_group_name [String] Name of the resource group within the
    # azure subscription.
    # @param namespace_name [String] The Namespace name
    # @param event_hub_name [String] The Event Hub name
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [AuthorizationRuleListResult] which provide lazy access to pages of
    # the response.
    #
    def list_authorization_rules_as_lazy(resource_group_name, namespace_name, event_hub_name, custom_headers = nil)
      response = list_authorization_rules_async(resource_group_name, namespace_name, event_hub_name, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_authorization_rules_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

  end
end
