# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator 1.2.2.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::ARM::Monitor
  module Models
    #
    # The log profile resource for patch operations.
    #
    class LogProfileResourcePatch

      include MsRestAzure

      include MsRest::JSONable
      # @return [Hash{String => String}] Resource tags
      attr_accessor :tags

      # @return [String] the resource id of the storage account to which you
      # would like to send the Activity Log.
      attr_accessor :storage_account_id

      # @return [String] The service bus rule ID of the service bus namespace
      # in which you would like to have Event Hubs created for streaming the
      # Activity Log. The rule ID is of the format: '{service bus resource
      # ID}/authorizationrules/{key name}'.
      attr_accessor :service_bus_rule_id

      # @return [Array<String>] List of regions for which Activity Log events
      # should be stored or streamed. It is a comma separated list of valid ARM
      # locations including the 'global' location.
      attr_accessor :locations

      # @return [Array<String>] the categories of the logs. These categories
      # are created as is convenient to the user. Some values are: 'Write',
      # 'Delete', and/or 'Action.'
      attr_accessor :categories

      # @return [RetentionPolicy] the retention policy for the events in the
      # log.
      attr_accessor :retention_policy


      #
      # Mapper for LogProfileResourcePatch class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          required: false,
          serialized_name: 'LogProfileResourcePatch',
          type: {
            name: 'Composite',
            class_name: 'LogProfileResourcePatch',
            model_properties: {
              tags: {
                required: false,
                serialized_name: 'tags',
                type: {
                  name: 'Dictionary',
                  value: {
                      required: false,
                      serialized_name: 'StringElementType',
                      type: {
                        name: 'String'
                      }
                  }
                }
              },
              storage_account_id: {
                required: false,
                serialized_name: 'properties.storageAccountId',
                type: {
                  name: 'String'
                }
              },
              service_bus_rule_id: {
                required: false,
                serialized_name: 'properties.serviceBusRuleId',
                type: {
                  name: 'String'
                }
              },
              locations: {
                required: true,
                serialized_name: 'properties.locations',
                type: {
                  name: 'Sequence',
                  element: {
                      required: false,
                      serialized_name: 'StringElementType',
                      type: {
                        name: 'String'
                      }
                  }
                }
              },
              categories: {
                required: true,
                serialized_name: 'properties.categories',
                type: {
                  name: 'Sequence',
                  element: {
                      required: false,
                      serialized_name: 'StringElementType',
                      type: {
                        name: 'String'
                      }
                  }
                }
              },
              retention_policy: {
                required: true,
                serialized_name: 'properties.retentionPolicy',
                type: {
                  name: 'Composite',
                  class_name: 'RetentionPolicy'
                }
              }
            }
          }
        }
      end
    end
  end
end
