# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator 1.2.2.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::ARM::ServerManagement
  module Models
    #
    # Data model for an arm gateway resource.
    #
    class GatewayResource < MsRestAzure::Resource

      include MsRestAzure

      include MsRest::JSONable
      # @return [DateTime] UTC date and time when gateway was first added to
      # management service.
      attr_accessor :created

      # @return [DateTime] UTC date and time when node was last updated.
      attr_accessor :updated

      # @return [UpgradeMode] The upgradeMode property gives the flexibility to
      # gateway to auto upgrade itself. If properties value not specified, then
      # we assume upgradeMode = Automatic. Possible values include: 'Manual',
      # 'Automatic'
      attr_accessor :upgrade_mode

      # @return [String] Latest available MSI version.
      attr_accessor :desired_version

      # @return [Array<GatewayStatus>] Names of the nodes in the gateway.
      attr_accessor :instances

      # @return [Integer] Number of active messages.
      attr_accessor :active_message_count

      # @return [String] Last published MSI version.
      attr_accessor :latest_published_msi_version

      # @return [DateTime] The date/time of the last published gateway.
      attr_accessor :published_time_utc

      # @return [String] Installer download uri.
      attr_accessor :installer_download

      # @return [String] Minimum gateway version.
      attr_accessor :minimum_version


      #
      # Mapper for GatewayResource class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          required: false,
          serialized_name: 'GatewayResource',
          type: {
            name: 'Composite',
            class_name: 'GatewayResource',
            model_properties: {
              id: {
                required: false,
                read_only: true,
                serialized_name: 'id',
                type: {
                  name: 'String'
                }
              },
              type: {
                required: false,
                read_only: true,
                serialized_name: 'type',
                type: {
                  name: 'String'
                }
              },
              name: {
                required: false,
                read_only: true,
                serialized_name: 'name',
                type: {
                  name: 'String'
                }
              },
              location: {
                required: false,
                read_only: true,
                serialized_name: 'location',
                type: {
                  name: 'String'
                }
              },
              tags: {
                required: false,
                serialized_name: 'tags',
                type: {
                  name: 'Dictionary',
                  value: {
                      required: false,
                      serialized_name: 'StringElementType',
                      type: {
                        name: 'String'
                      }
                  }
                }
              },
              etag: {
                required: false,
                serialized_name: 'etag',
                type: {
                  name: 'String'
                }
              },
              created: {
                required: false,
                serialized_name: 'properties.created',
                type: {
                  name: 'DateTime'
                }
              },
              updated: {
                required: false,
                serialized_name: 'properties.updated',
                type: {
                  name: 'DateTime'
                }
              },
              upgrade_mode: {
                required: false,
                serialized_name: 'properties.upgradeMode',
                type: {
                  name: 'Enum',
                  module: 'UpgradeMode'
                }
              },
              desired_version: {
                required: false,
                serialized_name: 'properties.desiredVersion',
                type: {
                  name: 'String'
                }
              },
              instances: {
                required: false,
                serialized_name: 'properties.instances',
                type: {
                  name: 'Sequence',
                  element: {
                      required: false,
                      serialized_name: 'GatewayStatusElementType',
                      type: {
                        name: 'Composite',
                        class_name: 'GatewayStatus'
                      }
                  }
                }
              },
              active_message_count: {
                required: false,
                serialized_name: 'properties.activeMessageCount',
                type: {
                  name: 'Number'
                }
              },
              latest_published_msi_version: {
                required: false,
                serialized_name: 'properties.latestPublishedMsiVersion',
                type: {
                  name: 'String'
                }
              },
              published_time_utc: {
                required: false,
                serialized_name: 'properties.publishedTimeUtc',
                type: {
                  name: 'DateTime'
                }
              },
              installer_download: {
                required: false,
                read_only: true,
                serialized_name: 'properties.installerDownload',
                type: {
                  name: 'String'
                }
              },
              minimum_version: {
                required: false,
                read_only: true,
                serialized_name: 'properties.minimumVersion',
                type: {
                  name: 'String'
                }
              }
            }
          }
        }
      end
    end
  end
end
