# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator 1.2.2.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::ARM::SQL
  module Models
    #
    # Import database parameters.
    #
    class ImportRequest < ExportRequest

      include MsRestAzure

      include MsRest::JSONable
      # @return [String] The name of the database to import.
      attr_accessor :database_name

      # @return [DatabaseEdition] The edition for the database being created.
      # Possible values include: 'Web', 'Business', 'Basic', 'Standard',
      # 'Premium', 'Free', 'Stretch', 'DataWarehouse', 'System', 'System2'
      attr_accessor :edition

      # @return [ServiceObjectiveName] The name of the service objective to
      # assign to the database. Possible values include: 'Basic', 'S0', 'S1',
      # 'S2', 'S3', 'P1', 'P2', 'P3', 'P4', 'P6', 'P11', 'P15', 'System',
      # 'System2', 'ElasticPool'
      attr_accessor :service_objective_name

      # @return [String] The maximum size for the newly imported database.
      attr_accessor :max_size_bytes


      #
      # Mapper for ImportRequest class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          required: false,
          serialized_name: 'ImportRequest',
          type: {
            name: 'Composite',
            class_name: 'ImportRequest',
            model_properties: {
              storage_key_type: {
                required: true,
                serialized_name: 'storageKeyType',
                type: {
                  name: 'Enum',
                  module: 'StorageKeyType'
                }
              },
              storage_key: {
                required: true,
                serialized_name: 'storageKey',
                type: {
                  name: 'String'
                }
              },
              storage_uri: {
                required: true,
                serialized_name: 'storageUri',
                type: {
                  name: 'String'
                }
              },
              administrator_login: {
                required: true,
                serialized_name: 'administratorLogin',
                type: {
                  name: 'String'
                }
              },
              administrator_login_password: {
                required: true,
                serialized_name: 'administratorLoginPassword',
                type: {
                  name: 'String'
                }
              },
              authentication_type: {
                required: false,
                serialized_name: 'authenticationType',
                default_value: 'SQL',
                type: {
                  name: 'Enum',
                  module: 'AuthenticationType'
                }
              },
              database_name: {
                required: true,
                serialized_name: 'databaseName',
                type: {
                  name: 'String'
                }
              },
              edition: {
                required: true,
                serialized_name: 'edition',
                type: {
                  name: 'String'
                }
              },
              service_objective_name: {
                required: true,
                serialized_name: 'serviceObjectiveName',
                type: {
                  name: 'String'
                }
              },
              max_size_bytes: {
                required: true,
                serialized_name: 'maxSizeBytes',
                type: {
                  name: 'String'
                }
              }
            }
          }
        }
      end
    end
  end
end
