# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator 1.2.2.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::ARM::Web
  #
  # WebSite Management Client
  #
  class WebApps
    include MsRestAzure

    #
    # Creates and initializes a new instance of the WebApps class.
    # @param client service class for accessing basic functionality.
    #
    def initialize(client)
      @client = client
    end

    # @return [WebSiteManagementClient] reference to the WebSiteManagementClient
    attr_reader :client

    #
    # Get all apps for a subscription.
    #
    # Get all apps for a subscription.
    #
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<Site>] operation results.
    #
    def list(custom_headers = nil)
      first_page = list_as_lazy(custom_headers)
      first_page.get_all_items
    end

    #
    # Get all apps for a subscription.
    #
    # Get all apps for a subscription.
    #
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_with_http_info(custom_headers = nil)
      list_async(custom_headers).value!
    end

    #
    # Get all apps for a subscription.
    #
    # Get all apps for a subscription.
    #
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_async(custom_headers = nil)
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/providers/Microsoft.Web/sites'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::WebAppCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets all web, mobile, and API apps in the specified resource group.
    #
    # Gets all web, mobile, and API apps in the specified resource group.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param include_slots [Boolean] Specify <strong>true</strong> to include
    # deployment slots in results. The default is false, which only gives you the
    # production slot of all apps.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<Site>] operation results.
    #
    def list_by_resource_group(resource_group_name, include_slots = nil, custom_headers = nil)
      first_page = list_by_resource_group_as_lazy(resource_group_name, include_slots, custom_headers)
      first_page.get_all_items
    end

    #
    # Gets all web, mobile, and API apps in the specified resource group.
    #
    # Gets all web, mobile, and API apps in the specified resource group.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param include_slots [Boolean] Specify <strong>true</strong> to include
    # deployment slots in results. The default is false, which only gives you the
    # production slot of all apps.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_by_resource_group_with_http_info(resource_group_name, include_slots = nil, custom_headers = nil)
      list_by_resource_group_async(resource_group_name, include_slots, custom_headers).value!
    end

    #
    # Gets all web, mobile, and API apps in the specified resource group.
    #
    # Gets all web, mobile, and API apps in the specified resource group.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param include_slots [Boolean] Specify <strong>true</strong> to include
    # deployment slots in results. The default is false, which only gives you the
    # production slot of all apps.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_by_resource_group_async(resource_group_name, include_slots = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'subscriptionId' => @client.subscription_id},
          query_params: {'includeSlots' => include_slots,'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::WebAppCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the details of a web, mobile, or API app.
    #
    # Gets the details of a web, mobile, or API app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Site] operation results.
    #
    def get(resource_group_name, name, custom_headers = nil)
      response = get_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the details of a web, mobile, or API app.
    #
    # Gets the details of a web, mobile, or API app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_with_http_info(resource_group_name, name, custom_headers = nil)
      get_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Gets the details of a web, mobile, or API app.
    #
    # Gets the details of a web, mobile, or API app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::Site.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Creates a new web, mobile, or API app in an existing resource group, or
    # updates an existing app.
    #
    # Creates a new web, mobile, or API app in an existing resource group, or
    # updates an existing app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Unique name of the app to create or update. To create or
    # update a deployment slot, use the {slot} parameter.
    # @param site_envelope [Site] A JSON representation of the app properties. See
    # example.
    # @param skip_dns_registration [Boolean] If true web app hostname is not
    # registered with DNS on creation. This parameter is
    # only used for app creation
    # @param skip_custom_domain_verification [Boolean] If true, custom (non
    # *.azurewebsites.net) domains associated with web app are not verified.
    # @param force_dns_registration [Boolean] If true, web app hostname is force
    # registered with DNS
    # @param ttl_in_seconds [String] Time to live in seconds for web app's default
    # domain name
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Site] operation results.
    #
    def create_or_update(resource_group_name, name, site_envelope, skip_dns_registration = nil, skip_custom_domain_verification = nil, force_dns_registration = nil, ttl_in_seconds = nil, custom_headers = nil)
      response = create_or_update_async(resource_group_name, name, site_envelope, skip_dns_registration, skip_custom_domain_verification, force_dns_registration, ttl_in_seconds, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Unique name of the app to create or update. To create or
    # update a deployment slot, use the {slot} parameter.
    # @param site_envelope [Site] A JSON representation of the app properties. See
    # example.
    # @param skip_dns_registration [Boolean] If true web app hostname is not
    # registered with DNS on creation. This parameter is
    # only used for app creation
    # @param skip_custom_domain_verification [Boolean] If true, custom (non
    # *.azurewebsites.net) domains associated with web app are not verified.
    # @param force_dns_registration [Boolean] If true, web app hostname is force
    # registered with DNS
    # @param ttl_in_seconds [String] Time to live in seconds for web app's default
    # domain name
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def create_or_update_async(resource_group_name, name, site_envelope, skip_dns_registration = nil, skip_custom_domain_verification = nil, force_dns_registration = nil, ttl_in_seconds = nil, custom_headers = nil)
      # Send request
      promise = begin_create_or_update_async(resource_group_name, name, site_envelope, skip_dns_registration, skip_custom_domain_verification, force_dns_registration, ttl_in_seconds, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Azure::ARM::Web::Models::Site.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response)
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Deletes a web, mobile, or API app, or one of the deployment slots.
    #
    # Deletes a web, mobile, or API app, or one of the deployment slots.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app to delete.
    # @param delete_metrics [Boolean] If true, web app metrics are also deleted
    # @param delete_empty_server_farm [Boolean] Specify true if the App Service
    # plan will be empty after app deletion and you want to delete the empty App
    # Service plan. By default, the empty App Service plan is not deleted.
    # @param skip_dns_registration [Boolean] If true, DNS registration is skipped
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def delete(resource_group_name, name, delete_metrics = nil, delete_empty_server_farm = nil, skip_dns_registration = nil, custom_headers = nil)
      response = delete_async(resource_group_name, name, delete_metrics, delete_empty_server_farm, skip_dns_registration, custom_headers).value!
      nil
    end

    #
    # Deletes a web, mobile, or API app, or one of the deployment slots.
    #
    # Deletes a web, mobile, or API app, or one of the deployment slots.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app to delete.
    # @param delete_metrics [Boolean] If true, web app metrics are also deleted
    # @param delete_empty_server_farm [Boolean] Specify true if the App Service
    # plan will be empty after app deletion and you want to delete the empty App
    # Service plan. By default, the empty App Service plan is not deleted.
    # @param skip_dns_registration [Boolean] If true, DNS registration is skipped
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_with_http_info(resource_group_name, name, delete_metrics = nil, delete_empty_server_farm = nil, skip_dns_registration = nil, custom_headers = nil)
      delete_async(resource_group_name, name, delete_metrics, delete_empty_server_farm, skip_dns_registration, custom_headers).value!
    end

    #
    # Deletes a web, mobile, or API app, or one of the deployment slots.
    #
    # Deletes a web, mobile, or API app, or one of the deployment slots.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app to delete.
    # @param delete_metrics [Boolean] If true, web app metrics are also deleted
    # @param delete_empty_server_farm [Boolean] Specify true if the App Service
    # plan will be empty after app deletion and you want to delete the empty App
    # Service plan. By default, the empty App Service plan is not deleted.
    # @param skip_dns_registration [Boolean] If true, DNS registration is skipped
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_async(resource_group_name, name, delete_metrics = nil, delete_empty_server_farm = nil, skip_dns_registration = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'deleteMetrics' => delete_metrics,'deleteEmptyServerFarm' => delete_empty_server_farm,'skipDnsRegistration' => skip_dns_registration,'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 404
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Analyze a custom hostname.
    #
    # Analyze a custom hostname.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of web app
    # @param host_name [String] Custom hostname
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [CustomHostnameAnalysisResult] operation results.
    #
    def analyze_custom_hostname(resource_group_name, name, host_name = nil, custom_headers = nil)
      response = analyze_custom_hostname_async(resource_group_name, name, host_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Analyze a custom hostname.
    #
    # Analyze a custom hostname.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of web app
    # @param host_name [String] Custom hostname
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def analyze_custom_hostname_with_http_info(resource_group_name, name, host_name = nil, custom_headers = nil)
      analyze_custom_hostname_async(resource_group_name, name, host_name, custom_headers).value!
    end

    #
    # Analyze a custom hostname.
    #
    # Analyze a custom hostname.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of web app
    # @param host_name [String] Custom hostname
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def analyze_custom_hostname_async(resource_group_name, name, host_name = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/analyzeCustomHostname'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'hostName' => host_name,'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::CustomHostnameAnalysisResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Applies the configuration settings from the target slot onto the current
    # slot.
    #
    # Applies the configuration settings from the target slot onto the current
    # slot.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot_swap_entity [CsmSlotEntity] JSON object that contains the target
    # slot name. See example.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def apply_slot_config_to_production(resource_group_name, name, slot_swap_entity, custom_headers = nil)
      response = apply_slot_config_to_production_async(resource_group_name, name, slot_swap_entity, custom_headers).value!
      nil
    end

    #
    # Applies the configuration settings from the target slot onto the current
    # slot.
    #
    # Applies the configuration settings from the target slot onto the current
    # slot.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot_swap_entity [CsmSlotEntity] JSON object that contains the target
    # slot name. See example.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def apply_slot_config_to_production_with_http_info(resource_group_name, name, slot_swap_entity, custom_headers = nil)
      apply_slot_config_to_production_async(resource_group_name, name, slot_swap_entity, custom_headers).value!
    end

    #
    # Applies the configuration settings from the target slot onto the current
    # slot.
    #
    # Applies the configuration settings from the target slot onto the current
    # slot.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot_swap_entity [CsmSlotEntity] JSON object that contains the target
    # slot name. See example.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def apply_slot_config_to_production_async(resource_group_name, name, slot_swap_entity, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot_swap_entity is nil' if slot_swap_entity.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::Web::Models::CsmSlotEntity.mapper()
      request_content = @client.serialize(request_mapper,  slot_swap_entity)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/applySlotConfig'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Creates a backup of an app.
    #
    # Creates a backup of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param request [BackupRequest] Backup configuration. You can use the JSON
    # response from the POST action as input here.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [BackupItem] operation results.
    #
    def backup(resource_group_name, name, request, custom_headers = nil)
      response = backup_async(resource_group_name, name, request, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Creates a backup of an app.
    #
    # Creates a backup of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param request [BackupRequest] Backup configuration. You can use the JSON
    # response from the POST action as input here.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def backup_with_http_info(resource_group_name, name, request, custom_headers = nil)
      backup_async(resource_group_name, name, request, custom_headers).value!
    end

    #
    # Creates a backup of an app.
    #
    # Creates a backup of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param request [BackupRequest] Backup configuration. You can use the JSON
    # response from the POST action as input here.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def backup_async(resource_group_name, name, request, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'request is nil' if request.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::Web::Models::BackupRequest.mapper()
      request_content = @client.serialize(request_mapper,  request)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/backup'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::BackupItem.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets existing backups of an app.
    #
    # Gets existing backups of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<BackupItem>] operation results.
    #
    def list_backups(resource_group_name, name, custom_headers = nil)
      first_page = list_backups_as_lazy(resource_group_name, name, custom_headers)
      first_page.get_all_items
    end

    #
    # Gets existing backups of an app.
    #
    # Gets existing backups of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_backups_with_http_info(resource_group_name, name, custom_headers = nil)
      list_backups_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Gets existing backups of an app.
    #
    # Gets existing backups of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_backups_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/backups'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::BackupItemCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Discovers an existing app backup that can be restored from a blob in Azure
    # storage.
    #
    # Discovers an existing app backup that can be restored from a blob in Azure
    # storage.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param request [RestoreRequest] A RestoreRequest object that includes Azure
    # storage URL and blog name for discovery of backup.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [RestoreRequest] operation results.
    #
    def discover_restore(resource_group_name, name, request, custom_headers = nil)
      response = discover_restore_async(resource_group_name, name, request, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Discovers an existing app backup that can be restored from a blob in Azure
    # storage.
    #
    # Discovers an existing app backup that can be restored from a blob in Azure
    # storage.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param request [RestoreRequest] A RestoreRequest object that includes Azure
    # storage URL and blog name for discovery of backup.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def discover_restore_with_http_info(resource_group_name, name, request, custom_headers = nil)
      discover_restore_async(resource_group_name, name, request, custom_headers).value!
    end

    #
    # Discovers an existing app backup that can be restored from a blob in Azure
    # storage.
    #
    # Discovers an existing app backup that can be restored from a blob in Azure
    # storage.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param request [RestoreRequest] A RestoreRequest object that includes Azure
    # storage URL and blog name for discovery of backup.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def discover_restore_async(resource_group_name, name, request, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'request is nil' if request.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::Web::Models::RestoreRequest.mapper()
      request_content = @client.serialize(request_mapper,  request)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/backups/discover'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::RestoreRequest.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets a backup of an app by its ID.
    #
    # Gets a backup of an app by its ID.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param backup_id [String] ID of the backup.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [BackupItem] operation results.
    #
    def get_backup_status(resource_group_name, name, backup_id, custom_headers = nil)
      response = get_backup_status_async(resource_group_name, name, backup_id, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets a backup of an app by its ID.
    #
    # Gets a backup of an app by its ID.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param backup_id [String] ID of the backup.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_backup_status_with_http_info(resource_group_name, name, backup_id, custom_headers = nil)
      get_backup_status_async(resource_group_name, name, backup_id, custom_headers).value!
    end

    #
    # Gets a backup of an app by its ID.
    #
    # Gets a backup of an app by its ID.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param backup_id [String] ID of the backup.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_backup_status_async(resource_group_name, name, backup_id, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'backup_id is nil' if backup_id.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/backups/{backupId}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'backupId' => backup_id,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::BackupItem.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Deletes a backup of an app by its ID.
    #
    # Deletes a backup of an app by its ID.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param backup_id [String] ID of the backup.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def delete_backup(resource_group_name, name, backup_id, custom_headers = nil)
      response = delete_backup_async(resource_group_name, name, backup_id, custom_headers).value!
      nil
    end

    #
    # Deletes a backup of an app by its ID.
    #
    # Deletes a backup of an app by its ID.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param backup_id [String] ID of the backup.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_backup_with_http_info(resource_group_name, name, backup_id, custom_headers = nil)
      delete_backup_async(resource_group_name, name, backup_id, custom_headers).value!
    end

    #
    # Deletes a backup of an app by its ID.
    #
    # Deletes a backup of an app by its ID.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param backup_id [String] ID of the backup.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_backup_async(resource_group_name, name, backup_id, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'backup_id is nil' if backup_id.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/backups/{backupId}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'backupId' => backup_id,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 404
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Gets status of a web app backup that may be in progress, including secrets
    # associated with the backup, such as the Azure Storage SAS URL. Also can be
    # used to update the SAS URL for the backup if a new URL is passed in the
    # request body.
    #
    # Gets status of a web app backup that may be in progress, including secrets
    # associated with the backup, such as the Azure Storage SAS URL. Also can be
    # used to update the SAS URL for the backup if a new URL is passed in the
    # request body.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of web app
    # @param backup_id [String] Id of backup
    # @param request [BackupRequest] Information on backup request
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [BackupItem] operation results.
    #
    def list_backup_status_secrets(resource_group_name, name, backup_id, request, custom_headers = nil)
      response = list_backup_status_secrets_async(resource_group_name, name, backup_id, request, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets status of a web app backup that may be in progress, including secrets
    # associated with the backup, such as the Azure Storage SAS URL. Also can be
    # used to update the SAS URL for the backup if a new URL is passed in the
    # request body.
    #
    # Gets status of a web app backup that may be in progress, including secrets
    # associated with the backup, such as the Azure Storage SAS URL. Also can be
    # used to update the SAS URL for the backup if a new URL is passed in the
    # request body.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of web app
    # @param backup_id [String] Id of backup
    # @param request [BackupRequest] Information on backup request
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_backup_status_secrets_with_http_info(resource_group_name, name, backup_id, request, custom_headers = nil)
      list_backup_status_secrets_async(resource_group_name, name, backup_id, request, custom_headers).value!
    end

    #
    # Gets status of a web app backup that may be in progress, including secrets
    # associated with the backup, such as the Azure Storage SAS URL. Also can be
    # used to update the SAS URL for the backup if a new URL is passed in the
    # request body.
    #
    # Gets status of a web app backup that may be in progress, including secrets
    # associated with the backup, such as the Azure Storage SAS URL. Also can be
    # used to update the SAS URL for the backup if a new URL is passed in the
    # request body.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of web app
    # @param backup_id [String] Id of backup
    # @param request [BackupRequest] Information on backup request
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_backup_status_secrets_async(resource_group_name, name, backup_id, request, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'backup_id is nil' if backup_id.nil?
      fail ArgumentError, 'request is nil' if request.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::Web::Models::BackupRequest.mapper()
      request_content = @client.serialize(request_mapper,  request)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/backups/{backupId}/list'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'backupId' => backup_id,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::BackupItem.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Restores a specific backup to another app (or deployment slot, if specified).
    #
    # Restores a specific backup to another app (or deployment slot, if specified).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param backup_id [String] ID of the backup.
    # @param request [RestoreRequest] Information on restore request
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [RestoreResponse] operation results.
    #
    def restore(resource_group_name, name, backup_id, request, custom_headers = nil)
      response = restore_async(resource_group_name, name, backup_id, request, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param backup_id [String] ID of the backup.
    # @param request [RestoreRequest] Information on restore request
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def restore_async(resource_group_name, name, backup_id, request, custom_headers = nil)
      # Send request
      promise = begin_restore_async(resource_group_name, name, backup_id, request, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Azure::ARM::Web::Models::RestoreResponse.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response)
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # List the configurations of an app
    #
    # List the configurations of an app
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<SiteConfigResource>] operation results.
    #
    def list_configurations(resource_group_name, name, custom_headers = nil)
      first_page = list_configurations_as_lazy(resource_group_name, name, custom_headers)
      first_page.get_all_items
    end

    #
    # List the configurations of an app
    #
    # List the configurations of an app
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_configurations_with_http_info(resource_group_name, name, custom_headers = nil)
      list_configurations_async(resource_group_name, name, custom_headers).value!
    end

    #
    # List the configurations of an app
    #
    # List the configurations of an app
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_configurations_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::SiteConfigResourceCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Replaces the application settings of an app.
    #
    # Replaces the application settings of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param app_settings [StringDictionary] Application settings of the app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [StringDictionary] operation results.
    #
    def update_application_settings(resource_group_name, name, app_settings, custom_headers = nil)
      response = update_application_settings_async(resource_group_name, name, app_settings, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Replaces the application settings of an app.
    #
    # Replaces the application settings of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param app_settings [StringDictionary] Application settings of the app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_application_settings_with_http_info(resource_group_name, name, app_settings, custom_headers = nil)
      update_application_settings_async(resource_group_name, name, app_settings, custom_headers).value!
    end

    #
    # Replaces the application settings of an app.
    #
    # Replaces the application settings of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param app_settings [StringDictionary] Application settings of the app.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_application_settings_async(resource_group_name, name, app_settings, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'app_settings is nil' if app_settings.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::Web::Models::StringDictionary.mapper()
      request_content = @client.serialize(request_mapper,  app_settings)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/appsettings'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::StringDictionary.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the application settings of an app.
    #
    # Gets the application settings of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [StringDictionary] operation results.
    #
    def list_application_settings(resource_group_name, name, custom_headers = nil)
      response = list_application_settings_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the application settings of an app.
    #
    # Gets the application settings of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_application_settings_with_http_info(resource_group_name, name, custom_headers = nil)
      list_application_settings_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Gets the application settings of an app.
    #
    # Gets the application settings of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_application_settings_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/appsettings/list'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::StringDictionary.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Updates the Authentication / Authorization settings associated with web app.
    #
    # Updates the Authentication / Authorization settings associated with web app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of web app
    # @param site_auth_settings [SiteAuthSettings] Auth settings associated with
    # web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteAuthSettings] operation results.
    #
    def update_auth_settings(resource_group_name, name, site_auth_settings, custom_headers = nil)
      response = update_auth_settings_async(resource_group_name, name, site_auth_settings, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Updates the Authentication / Authorization settings associated with web app.
    #
    # Updates the Authentication / Authorization settings associated with web app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of web app
    # @param site_auth_settings [SiteAuthSettings] Auth settings associated with
    # web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_auth_settings_with_http_info(resource_group_name, name, site_auth_settings, custom_headers = nil)
      update_auth_settings_async(resource_group_name, name, site_auth_settings, custom_headers).value!
    end

    #
    # Updates the Authentication / Authorization settings associated with web app.
    #
    # Updates the Authentication / Authorization settings associated with web app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of web app
    # @param site_auth_settings [SiteAuthSettings] Auth settings associated with
    # web app
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_auth_settings_async(resource_group_name, name, site_auth_settings, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'site_auth_settings is nil' if site_auth_settings.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::Web::Models::SiteAuthSettings.mapper()
      request_content = @client.serialize(request_mapper,  site_auth_settings)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/authsettings'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::SiteAuthSettings.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the Authentication/Authorization settings of an app.
    #
    # Gets the Authentication/Authorization settings of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteAuthSettings] operation results.
    #
    def get_auth_settings(resource_group_name, name, custom_headers = nil)
      response = get_auth_settings_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the Authentication/Authorization settings of an app.
    #
    # Gets the Authentication/Authorization settings of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_auth_settings_with_http_info(resource_group_name, name, custom_headers = nil)
      get_auth_settings_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Gets the Authentication/Authorization settings of an app.
    #
    # Gets the Authentication/Authorization settings of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_auth_settings_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/authsettings/list'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::SiteAuthSettings.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Updates the backup configuration of an app.
    #
    # Updates the backup configuration of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param request [BackupRequest] Edited backup configuration.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [BackupRequest] operation results.
    #
    def update_backup_configuration(resource_group_name, name, request, custom_headers = nil)
      response = update_backup_configuration_async(resource_group_name, name, request, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Updates the backup configuration of an app.
    #
    # Updates the backup configuration of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param request [BackupRequest] Edited backup configuration.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_backup_configuration_with_http_info(resource_group_name, name, request, custom_headers = nil)
      update_backup_configuration_async(resource_group_name, name, request, custom_headers).value!
    end

    #
    # Updates the backup configuration of an app.
    #
    # Updates the backup configuration of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param request [BackupRequest] Edited backup configuration.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_backup_configuration_async(resource_group_name, name, request, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'request is nil' if request.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::Web::Models::BackupRequest.mapper()
      request_content = @client.serialize(request_mapper,  request)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/backup'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::BackupRequest.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Deletes the backup configuration of an app.
    #
    # Deletes the backup configuration of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def delete_backup_configuration(resource_group_name, name, custom_headers = nil)
      response = delete_backup_configuration_async(resource_group_name, name, custom_headers).value!
      nil
    end

    #
    # Deletes the backup configuration of an app.
    #
    # Deletes the backup configuration of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_backup_configuration_with_http_info(resource_group_name, name, custom_headers = nil)
      delete_backup_configuration_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Deletes the backup configuration of an app.
    #
    # Deletes the backup configuration of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_backup_configuration_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/backup'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Gets the backup configuration of an app.
    #
    # Gets the backup configuration of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [BackupRequest] operation results.
    #
    def get_backup_configuration(resource_group_name, name, custom_headers = nil)
      response = get_backup_configuration_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the backup configuration of an app.
    #
    # Gets the backup configuration of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_backup_configuration_with_http_info(resource_group_name, name, custom_headers = nil)
      get_backup_configuration_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Gets the backup configuration of an app.
    #
    # Gets the backup configuration of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_backup_configuration_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/backup/list'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::BackupRequest.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Replaces the connection strings of an app.
    #
    # Replaces the connection strings of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param connection_strings [ConnectionStringDictionary] Connection strings of
    # the app or deployment slot. See example.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ConnectionStringDictionary] operation results.
    #
    def update_connection_strings(resource_group_name, name, connection_strings, custom_headers = nil)
      response = update_connection_strings_async(resource_group_name, name, connection_strings, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Replaces the connection strings of an app.
    #
    # Replaces the connection strings of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param connection_strings [ConnectionStringDictionary] Connection strings of
    # the app or deployment slot. See example.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_connection_strings_with_http_info(resource_group_name, name, connection_strings, custom_headers = nil)
      update_connection_strings_async(resource_group_name, name, connection_strings, custom_headers).value!
    end

    #
    # Replaces the connection strings of an app.
    #
    # Replaces the connection strings of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param connection_strings [ConnectionStringDictionary] Connection strings of
    # the app or deployment slot. See example.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_connection_strings_async(resource_group_name, name, connection_strings, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'connection_strings is nil' if connection_strings.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::Web::Models::ConnectionStringDictionary.mapper()
      request_content = @client.serialize(request_mapper,  connection_strings)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/connectionstrings'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::ConnectionStringDictionary.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the connection strings of an app.
    #
    # Gets the connection strings of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ConnectionStringDictionary] operation results.
    #
    def list_connection_strings(resource_group_name, name, custom_headers = nil)
      response = list_connection_strings_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the connection strings of an app.
    #
    # Gets the connection strings of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_connection_strings_with_http_info(resource_group_name, name, custom_headers = nil)
      list_connection_strings_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Gets the connection strings of an app.
    #
    # Gets the connection strings of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_connection_strings_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/connectionstrings/list'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::ConnectionStringDictionary.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the logging configuration of an app.
    #
    # Gets the logging configuration of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteLogsConfig] operation results.
    #
    def get_diagnostic_logs_configuration(resource_group_name, name, custom_headers = nil)
      response = get_diagnostic_logs_configuration_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the logging configuration of an app.
    #
    # Gets the logging configuration of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_diagnostic_logs_configuration_with_http_info(resource_group_name, name, custom_headers = nil)
      get_diagnostic_logs_configuration_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Gets the logging configuration of an app.
    #
    # Gets the logging configuration of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_diagnostic_logs_configuration_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/logs'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::SiteLogsConfig.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Updates the logging configuration of an app.
    #
    # Updates the logging configuration of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param site_logs_config [SiteLogsConfig] A SiteLogsConfig JSON object that
    # contains the logging configuration to change in the "properties" property.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteLogsConfig] operation results.
    #
    def update_diagnostic_logs_config(resource_group_name, name, site_logs_config, custom_headers = nil)
      response = update_diagnostic_logs_config_async(resource_group_name, name, site_logs_config, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Updates the logging configuration of an app.
    #
    # Updates the logging configuration of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param site_logs_config [SiteLogsConfig] A SiteLogsConfig JSON object that
    # contains the logging configuration to change in the "properties" property.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_diagnostic_logs_config_with_http_info(resource_group_name, name, site_logs_config, custom_headers = nil)
      update_diagnostic_logs_config_async(resource_group_name, name, site_logs_config, custom_headers).value!
    end

    #
    # Updates the logging configuration of an app.
    #
    # Updates the logging configuration of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param site_logs_config [SiteLogsConfig] A SiteLogsConfig JSON object that
    # contains the logging configuration to change in the "properties" property.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_diagnostic_logs_config_async(resource_group_name, name, site_logs_config, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'site_logs_config is nil' if site_logs_config.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::Web::Models::SiteLogsConfig.mapper()
      request_content = @client.serialize(request_mapper,  site_logs_config)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/logs'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::SiteLogsConfig.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Replaces the metadata of an app.
    #
    # Replaces the metadata of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param metadata [StringDictionary] Edited metadata of the app or deployment
    # slot. See example.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [StringDictionary] operation results.
    #
    def update_metadata(resource_group_name, name, metadata, custom_headers = nil)
      response = update_metadata_async(resource_group_name, name, metadata, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Replaces the metadata of an app.
    #
    # Replaces the metadata of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param metadata [StringDictionary] Edited metadata of the app or deployment
    # slot. See example.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_metadata_with_http_info(resource_group_name, name, metadata, custom_headers = nil)
      update_metadata_async(resource_group_name, name, metadata, custom_headers).value!
    end

    #
    # Replaces the metadata of an app.
    #
    # Replaces the metadata of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param metadata [StringDictionary] Edited metadata of the app or deployment
    # slot. See example.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_metadata_async(resource_group_name, name, metadata, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'metadata is nil' if metadata.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::Web::Models::StringDictionary.mapper()
      request_content = @client.serialize(request_mapper,  metadata)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/metadata'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::StringDictionary.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the metadata of an app.
    #
    # Gets the metadata of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [StringDictionary] operation results.
    #
    def list_metadata(resource_group_name, name, custom_headers = nil)
      response = list_metadata_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the metadata of an app.
    #
    # Gets the metadata of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_metadata_with_http_info(resource_group_name, name, custom_headers = nil)
      list_metadata_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Gets the metadata of an app.
    #
    # Gets the metadata of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_metadata_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/metadata/list'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::StringDictionary.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the Git/FTP publishing credentials of an app.
    #
    # Gets the Git/FTP publishing credentials of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [User] operation results.
    #
    def list_publishing_credentials(resource_group_name, name, custom_headers = nil)
      response = list_publishing_credentials_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def list_publishing_credentials_async(resource_group_name, name, custom_headers = nil)
      # Send request
      promise = begin_list_publishing_credentials_async(resource_group_name, name, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Azure::ARM::Web::Models::User.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response)
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Updates the Push settings associated with web app.
    #
    # Updates the Push settings associated with web app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of web app
    # @param push_settings [PushSettings] Push settings associated with web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [PushSettings] operation results.
    #
    def update_site_push_settings(resource_group_name, name, push_settings, custom_headers = nil)
      response = update_site_push_settings_async(resource_group_name, name, push_settings, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Updates the Push settings associated with web app.
    #
    # Updates the Push settings associated with web app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of web app
    # @param push_settings [PushSettings] Push settings associated with web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_site_push_settings_with_http_info(resource_group_name, name, push_settings, custom_headers = nil)
      update_site_push_settings_async(resource_group_name, name, push_settings, custom_headers).value!
    end

    #
    # Updates the Push settings associated with web app.
    #
    # Updates the Push settings associated with web app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of web app
    # @param push_settings [PushSettings] Push settings associated with web app
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_site_push_settings_async(resource_group_name, name, push_settings, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'push_settings is nil' if push_settings.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::Web::Models::PushSettings.mapper()
      request_content = @client.serialize(request_mapper,  push_settings)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/pushsettings'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::PushSettings.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the Push settings associated with web app.
    #
    # Gets the Push settings associated with web app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [PushSettings] operation results.
    #
    def list_site_push_settings(resource_group_name, name, custom_headers = nil)
      response = list_site_push_settings_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the Push settings associated with web app.
    #
    # Gets the Push settings associated with web app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_site_push_settings_with_http_info(resource_group_name, name, custom_headers = nil)
      list_site_push_settings_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Gets the Push settings associated with web app.
    #
    # Gets the Push settings associated with web app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of web app
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_site_push_settings_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/pushsettings/list'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::PushSettings.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the names of app settings and connection strings that stick to the slot
    # (not swapped).
    #
    # Gets the names of app settings and connection strings that stick to the slot
    # (not swapped).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SlotConfigNamesResource] operation results.
    #
    def list_slot_configuration_names(resource_group_name, name, custom_headers = nil)
      response = list_slot_configuration_names_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the names of app settings and connection strings that stick to the slot
    # (not swapped).
    #
    # Gets the names of app settings and connection strings that stick to the slot
    # (not swapped).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_slot_configuration_names_with_http_info(resource_group_name, name, custom_headers = nil)
      list_slot_configuration_names_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Gets the names of app settings and connection strings that stick to the slot
    # (not swapped).
    #
    # Gets the names of app settings and connection strings that stick to the slot
    # (not swapped).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_slot_configuration_names_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/slotConfigNames'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::SlotConfigNamesResource.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Updates the names of application settings and connection string that remain
    # with the slot during swap operation.
    #
    # Updates the names of application settings and connection string that remain
    # with the slot during swap operation.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot_config_names [SlotConfigNamesResource] Names of application
    # settings and connection strings. See example.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SlotConfigNamesResource] operation results.
    #
    def update_slot_configuration_names(resource_group_name, name, slot_config_names, custom_headers = nil)
      response = update_slot_configuration_names_async(resource_group_name, name, slot_config_names, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Updates the names of application settings and connection string that remain
    # with the slot during swap operation.
    #
    # Updates the names of application settings and connection string that remain
    # with the slot during swap operation.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot_config_names [SlotConfigNamesResource] Names of application
    # settings and connection strings. See example.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_slot_configuration_names_with_http_info(resource_group_name, name, slot_config_names, custom_headers = nil)
      update_slot_configuration_names_async(resource_group_name, name, slot_config_names, custom_headers).value!
    end

    #
    # Updates the names of application settings and connection string that remain
    # with the slot during swap operation.
    #
    # Updates the names of application settings and connection string that remain
    # with the slot during swap operation.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot_config_names [SlotConfigNamesResource] Names of application
    # settings and connection strings. See example.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_slot_configuration_names_async(resource_group_name, name, slot_config_names, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot_config_names is nil' if slot_config_names.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::Web::Models::SlotConfigNamesResource.mapper()
      request_content = @client.serialize(request_mapper,  slot_config_names)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/slotConfigNames'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::SlotConfigNamesResource.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the configuration of an app, such as platform version and bitness,
    # default documents, virtual applications, Always On, etc.
    #
    # Gets the configuration of an app, such as platform version and bitness,
    # default documents, virtual applications, Always On, etc.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteConfigResource] operation results.
    #
    def get_configuration(resource_group_name, name, custom_headers = nil)
      response = get_configuration_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the configuration of an app, such as platform version and bitness,
    # default documents, virtual applications, Always On, etc.
    #
    # Gets the configuration of an app, such as platform version and bitness,
    # default documents, virtual applications, Always On, etc.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_configuration_with_http_info(resource_group_name, name, custom_headers = nil)
      get_configuration_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Gets the configuration of an app, such as platform version and bitness,
    # default documents, virtual applications, Always On, etc.
    #
    # Gets the configuration of an app, such as platform version and bitness,
    # default documents, virtual applications, Always On, etc.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_configuration_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/web'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::SiteConfigResource.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Updates the configuration of an app.
    #
    # Updates the configuration of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param site_config [SiteConfigResource] JSON representation of a SiteConfig
    # object. See example.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteConfigResource] operation results.
    #
    def create_or_update_configuration(resource_group_name, name, site_config, custom_headers = nil)
      response = create_or_update_configuration_async(resource_group_name, name, site_config, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Updates the configuration of an app.
    #
    # Updates the configuration of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param site_config [SiteConfigResource] JSON representation of a SiteConfig
    # object. See example.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def create_or_update_configuration_with_http_info(resource_group_name, name, site_config, custom_headers = nil)
      create_or_update_configuration_async(resource_group_name, name, site_config, custom_headers).value!
    end

    #
    # Updates the configuration of an app.
    #
    # Updates the configuration of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param site_config [SiteConfigResource] JSON representation of a SiteConfig
    # object. See example.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def create_or_update_configuration_async(resource_group_name, name, site_config, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'site_config is nil' if site_config.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::Web::Models::SiteConfigResource.mapper()
      request_content = @client.serialize(request_mapper,  site_config)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/web'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::SiteConfigResource.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Updates the configuration of an app.
    #
    # Updates the configuration of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param site_config [SiteConfigResource] JSON representation of a SiteConfig
    # object. See example.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteConfigResource] operation results.
    #
    def update_configuration(resource_group_name, name, site_config, custom_headers = nil)
      response = update_configuration_async(resource_group_name, name, site_config, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Updates the configuration of an app.
    #
    # Updates the configuration of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param site_config [SiteConfigResource] JSON representation of a SiteConfig
    # object. See example.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_configuration_with_http_info(resource_group_name, name, site_config, custom_headers = nil)
      update_configuration_async(resource_group_name, name, site_config, custom_headers).value!
    end

    #
    # Updates the configuration of an app.
    #
    # Updates the configuration of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param site_config [SiteConfigResource] JSON representation of a SiteConfig
    # object. See example.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_configuration_async(resource_group_name, name, site_config, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'site_config is nil' if site_config.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::Web::Models::SiteConfigResource.mapper()
      request_content = @client.serialize(request_mapper,  site_config)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/web'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:patch, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::SiteConfigResource.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets a list of web app configuration snapshots identifiers. Each element of
    # the list contains a timestamp and the ID of the snapshot.
    #
    # Gets a list of web app configuration snapshots identifiers. Each element of
    # the list contains a timestamp and the ID of the snapshot.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array] operation results.
    #
    def list_configuration_snapshot_info(resource_group_name, name, custom_headers = nil)
      response = list_configuration_snapshot_info_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets a list of web app configuration snapshots identifiers. Each element of
    # the list contains a timestamp and the ID of the snapshot.
    #
    # Gets a list of web app configuration snapshots identifiers. Each element of
    # the list contains a timestamp and the ID of the snapshot.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_configuration_snapshot_info_with_http_info(resource_group_name, name, custom_headers = nil)
      list_configuration_snapshot_info_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Gets a list of web app configuration snapshots identifiers. Each element of
    # the list contains a timestamp and the ID of the snapshot.
    #
    # Gets a list of web app configuration snapshots identifiers. Each element of
    # the list contains a timestamp and the ID of the snapshot.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_configuration_snapshot_info_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/web/snapshots'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = {
              required: false,
              serialized_name: 'parsed_response',
              type: {
                name: 'Sequence',
                element: {
                    required: false,
                    serialized_name: 'SiteConfigurationSnapshotInfoElementType',
                    type: {
                      name: 'Composite',
                      class_name: 'SiteConfigurationSnapshotInfo'
                    }
                }
              }
            }
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets a snapshot of the configuration of an app at a previous point in time.
    #
    # Gets a snapshot of the configuration of an app at a previous point in time.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param snapshot_id [String] The ID of the snapshot to read.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteConfigResource] operation results.
    #
    def get_configuration_snapshot(resource_group_name, name, snapshot_id, custom_headers = nil)
      response = get_configuration_snapshot_async(resource_group_name, name, snapshot_id, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets a snapshot of the configuration of an app at a previous point in time.
    #
    # Gets a snapshot of the configuration of an app at a previous point in time.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param snapshot_id [String] The ID of the snapshot to read.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_configuration_snapshot_with_http_info(resource_group_name, name, snapshot_id, custom_headers = nil)
      get_configuration_snapshot_async(resource_group_name, name, snapshot_id, custom_headers).value!
    end

    #
    # Gets a snapshot of the configuration of an app at a previous point in time.
    #
    # Gets a snapshot of the configuration of an app at a previous point in time.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param snapshot_id [String] The ID of the snapshot to read.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_configuration_snapshot_async(resource_group_name, name, snapshot_id, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'snapshot_id is nil' if snapshot_id.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/web/snapshots/{snapshotId}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'snapshotId' => snapshot_id,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::SiteConfigResource.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Reverts the configuration of an app to a previous snapshot.
    #
    # Reverts the configuration of an app to a previous snapshot.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param snapshot_id [String] The ID of the snapshot to read.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def recover_site_configuration_snapshot(resource_group_name, name, snapshot_id, custom_headers = nil)
      response = recover_site_configuration_snapshot_async(resource_group_name, name, snapshot_id, custom_headers).value!
      nil
    end

    #
    # Reverts the configuration of an app to a previous snapshot.
    #
    # Reverts the configuration of an app to a previous snapshot.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param snapshot_id [String] The ID of the snapshot to read.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def recover_site_configuration_snapshot_with_http_info(resource_group_name, name, snapshot_id, custom_headers = nil)
      recover_site_configuration_snapshot_async(resource_group_name, name, snapshot_id, custom_headers).value!
    end

    #
    # Reverts the configuration of an app to a previous snapshot.
    #
    # Reverts the configuration of an app to a previous snapshot.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param snapshot_id [String] The ID of the snapshot to read.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def recover_site_configuration_snapshot_async(resource_group_name, name, snapshot_id, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'snapshot_id is nil' if snapshot_id.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/web/snapshots/{snapshotId}/recover'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'snapshotId' => snapshot_id,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 204
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # List deployments for an app, or a deployment slot, or for an instance of a
    # scaled-out app.
    #
    # List deployments for an app, or a deployment slot, or for an instance of a
    # scaled-out app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<Deployment>] operation results.
    #
    def list_deployments(resource_group_name, name, custom_headers = nil)
      first_page = list_deployments_as_lazy(resource_group_name, name, custom_headers)
      first_page.get_all_items
    end

    #
    # List deployments for an app, or a deployment slot, or for an instance of a
    # scaled-out app.
    #
    # List deployments for an app, or a deployment slot, or for an instance of a
    # scaled-out app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_deployments_with_http_info(resource_group_name, name, custom_headers = nil)
      list_deployments_async(resource_group_name, name, custom_headers).value!
    end

    #
    # List deployments for an app, or a deployment slot, or for an instance of a
    # scaled-out app.
    #
    # List deployments for an app, or a deployment slot, or for an instance of a
    # scaled-out app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_deployments_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/deployments'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::DeploymentCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get a deployment by its ID for an app, a specific deployment slot, and/or a
    # specific scaled-out instance.
    #
    # Get a deployment by its ID for an app, a specific deployment slot, and/or a
    # specific scaled-out instance.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param id [String] Deployment ID.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Deployment] operation results.
    #
    def get_deployment(resource_group_name, name, id, custom_headers = nil)
      response = get_deployment_async(resource_group_name, name, id, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get a deployment by its ID for an app, a specific deployment slot, and/or a
    # specific scaled-out instance.
    #
    # Get a deployment by its ID for an app, a specific deployment slot, and/or a
    # specific scaled-out instance.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param id [String] Deployment ID.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_deployment_with_http_info(resource_group_name, name, id, custom_headers = nil)
      get_deployment_async(resource_group_name, name, id, custom_headers).value!
    end

    #
    # Get a deployment by its ID for an app, a specific deployment slot, and/or a
    # specific scaled-out instance.
    #
    # Get a deployment by its ID for an app, a specific deployment slot, and/or a
    # specific scaled-out instance.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param id [String] Deployment ID.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_deployment_async(resource_group_name, name, id, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'id is nil' if id.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/deployments/{id}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'id' => id,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::Deployment.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Create a deployment for an app, a specific deployment slot, and/or a specific
    # scaled-out instance.
    #
    # Create a deployment for an app, a specific deployment slot, and/or a specific
    # scaled-out instance.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param id [String] ID of an existing deployment.
    # @param deployment [Deployment] Deployment details.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Deployment] operation results.
    #
    def create_deployment(resource_group_name, name, id, deployment, custom_headers = nil)
      response = create_deployment_async(resource_group_name, name, id, deployment, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Create a deployment for an app, a specific deployment slot, and/or a specific
    # scaled-out instance.
    #
    # Create a deployment for an app, a specific deployment slot, and/or a specific
    # scaled-out instance.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param id [String] ID of an existing deployment.
    # @param deployment [Deployment] Deployment details.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def create_deployment_with_http_info(resource_group_name, name, id, deployment, custom_headers = nil)
      create_deployment_async(resource_group_name, name, id, deployment, custom_headers).value!
    end

    #
    # Create a deployment for an app, a specific deployment slot, and/or a specific
    # scaled-out instance.
    #
    # Create a deployment for an app, a specific deployment slot, and/or a specific
    # scaled-out instance.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param id [String] ID of an existing deployment.
    # @param deployment [Deployment] Deployment details.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def create_deployment_async(resource_group_name, name, id, deployment, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'id is nil' if id.nil?
      fail ArgumentError, 'deployment is nil' if deployment.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::Web::Models::Deployment.mapper()
      request_content = @client.serialize(request_mapper,  deployment)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/deployments/{id}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'id' => id,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::Deployment.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Delete a deployment by its ID for an app, a specific deployment slot, and/or
    # a specific scaled-out instance.
    #
    # Delete a deployment by its ID for an app, a specific deployment slot, and/or
    # a specific scaled-out instance.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param id [String] Deployment ID.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def delete_deployment(resource_group_name, name, id, custom_headers = nil)
      response = delete_deployment_async(resource_group_name, name, id, custom_headers).value!
      nil
    end

    #
    # Delete a deployment by its ID for an app, a specific deployment slot, and/or
    # a specific scaled-out instance.
    #
    # Delete a deployment by its ID for an app, a specific deployment slot, and/or
    # a specific scaled-out instance.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param id [String] Deployment ID.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_deployment_with_http_info(resource_group_name, name, id, custom_headers = nil)
      delete_deployment_async(resource_group_name, name, id, custom_headers).value!
    end

    #
    # Delete a deployment by its ID for an app, a specific deployment slot, and/or
    # a specific scaled-out instance.
    #
    # Delete a deployment by its ID for an app, a specific deployment slot, and/or
    # a specific scaled-out instance.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param id [String] Deployment ID.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_deployment_async(resource_group_name, name, id, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'id is nil' if id.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/deployments/{id}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'id' => id,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 204
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Lists ownership identifiers for domain associated with web app.
    #
    # Lists ownership identifiers for domain associated with web app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<Identifier>] operation results.
    #
    def list_domain_ownership_identifiers(resource_group_name, name, custom_headers = nil)
      first_page = list_domain_ownership_identifiers_as_lazy(resource_group_name, name, custom_headers)
      first_page.get_all_items
    end

    #
    # Lists ownership identifiers for domain associated with web app.
    #
    # Lists ownership identifiers for domain associated with web app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_domain_ownership_identifiers_with_http_info(resource_group_name, name, custom_headers = nil)
      list_domain_ownership_identifiers_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Lists ownership identifiers for domain associated with web app.
    #
    # Lists ownership identifiers for domain associated with web app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_domain_ownership_identifiers_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/domainOwnershipIdentifiers'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::IdentifierCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get domain ownership identifier for web app.
    #
    # Get domain ownership identifier for web app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param domain_ownership_identifier_name [String] Name of domain ownership
    # identifier.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Identifier] operation results.
    #
    def get_domain_ownership_identifier(resource_group_name, name, domain_ownership_identifier_name, custom_headers = nil)
      response = get_domain_ownership_identifier_async(resource_group_name, name, domain_ownership_identifier_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get domain ownership identifier for web app.
    #
    # Get domain ownership identifier for web app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param domain_ownership_identifier_name [String] Name of domain ownership
    # identifier.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_domain_ownership_identifier_with_http_info(resource_group_name, name, domain_ownership_identifier_name, custom_headers = nil)
      get_domain_ownership_identifier_async(resource_group_name, name, domain_ownership_identifier_name, custom_headers).value!
    end

    #
    # Get domain ownership identifier for web app.
    #
    # Get domain ownership identifier for web app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param domain_ownership_identifier_name [String] Name of domain ownership
    # identifier.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_domain_ownership_identifier_async(resource_group_name, name, domain_ownership_identifier_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'domain_ownership_identifier_name is nil' if domain_ownership_identifier_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/domainOwnershipIdentifiers/{domainOwnershipIdentifierName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'domainOwnershipIdentifierName' => domain_ownership_identifier_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::Identifier.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Creates a domain ownership identifier for web app, or updates an existing
    # ownership identifier.
    #
    # Creates a domain ownership identifier for web app, or updates an existing
    # ownership identifier.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param domain_ownership_identifier_name [String] Name of domain ownership
    # identifier.
    # @param domain_ownership_identifier [Identifier] A JSON representation of the
    # domain ownership properties.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Identifier] operation results.
    #
    def create_or_update_domain_ownership_identifier(resource_group_name, name, domain_ownership_identifier_name, domain_ownership_identifier, custom_headers = nil)
      response = create_or_update_domain_ownership_identifier_async(resource_group_name, name, domain_ownership_identifier_name, domain_ownership_identifier, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Creates a domain ownership identifier for web app, or updates an existing
    # ownership identifier.
    #
    # Creates a domain ownership identifier for web app, or updates an existing
    # ownership identifier.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param domain_ownership_identifier_name [String] Name of domain ownership
    # identifier.
    # @param domain_ownership_identifier [Identifier] A JSON representation of the
    # domain ownership properties.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def create_or_update_domain_ownership_identifier_with_http_info(resource_group_name, name, domain_ownership_identifier_name, domain_ownership_identifier, custom_headers = nil)
      create_or_update_domain_ownership_identifier_async(resource_group_name, name, domain_ownership_identifier_name, domain_ownership_identifier, custom_headers).value!
    end

    #
    # Creates a domain ownership identifier for web app, or updates an existing
    # ownership identifier.
    #
    # Creates a domain ownership identifier for web app, or updates an existing
    # ownership identifier.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param domain_ownership_identifier_name [String] Name of domain ownership
    # identifier.
    # @param domain_ownership_identifier [Identifier] A JSON representation of the
    # domain ownership properties.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def create_or_update_domain_ownership_identifier_async(resource_group_name, name, domain_ownership_identifier_name, domain_ownership_identifier, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'domain_ownership_identifier_name is nil' if domain_ownership_identifier_name.nil?
      fail ArgumentError, 'domain_ownership_identifier is nil' if domain_ownership_identifier.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::Web::Models::Identifier.mapper()
      request_content = @client.serialize(request_mapper,  domain_ownership_identifier)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/domainOwnershipIdentifiers/{domainOwnershipIdentifierName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'domainOwnershipIdentifierName' => domain_ownership_identifier_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::Identifier.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Deletes a domain ownership identifier for a web app.
    #
    # Deletes a domain ownership identifier for a web app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param domain_ownership_identifier_name [String] Name of domain ownership
    # identifier.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def delete_domain_ownership_identifier(resource_group_name, name, domain_ownership_identifier_name, custom_headers = nil)
      response = delete_domain_ownership_identifier_async(resource_group_name, name, domain_ownership_identifier_name, custom_headers).value!
      nil
    end

    #
    # Deletes a domain ownership identifier for a web app.
    #
    # Deletes a domain ownership identifier for a web app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param domain_ownership_identifier_name [String] Name of domain ownership
    # identifier.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_domain_ownership_identifier_with_http_info(resource_group_name, name, domain_ownership_identifier_name, custom_headers = nil)
      delete_domain_ownership_identifier_async(resource_group_name, name, domain_ownership_identifier_name, custom_headers).value!
    end

    #
    # Deletes a domain ownership identifier for a web app.
    #
    # Deletes a domain ownership identifier for a web app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param domain_ownership_identifier_name [String] Name of domain ownership
    # identifier.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_domain_ownership_identifier_async(resource_group_name, name, domain_ownership_identifier_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'domain_ownership_identifier_name is nil' if domain_ownership_identifier_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/domainOwnershipIdentifiers/{domainOwnershipIdentifierName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'domainOwnershipIdentifierName' => domain_ownership_identifier_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 204
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Creates a domain ownership identifier for web app, or updates an existing
    # ownership identifier.
    #
    # Creates a domain ownership identifier for web app, or updates an existing
    # ownership identifier.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param domain_ownership_identifier_name [String] Name of domain ownership
    # identifier.
    # @param domain_ownership_identifier [Identifier] A JSON representation of the
    # domain ownership properties.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Identifier] operation results.
    #
    def update_domain_ownership_identifier(resource_group_name, name, domain_ownership_identifier_name, domain_ownership_identifier, custom_headers = nil)
      response = update_domain_ownership_identifier_async(resource_group_name, name, domain_ownership_identifier_name, domain_ownership_identifier, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Creates a domain ownership identifier for web app, or updates an existing
    # ownership identifier.
    #
    # Creates a domain ownership identifier for web app, or updates an existing
    # ownership identifier.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param domain_ownership_identifier_name [String] Name of domain ownership
    # identifier.
    # @param domain_ownership_identifier [Identifier] A JSON representation of the
    # domain ownership properties.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_domain_ownership_identifier_with_http_info(resource_group_name, name, domain_ownership_identifier_name, domain_ownership_identifier, custom_headers = nil)
      update_domain_ownership_identifier_async(resource_group_name, name, domain_ownership_identifier_name, domain_ownership_identifier, custom_headers).value!
    end

    #
    # Creates a domain ownership identifier for web app, or updates an existing
    # ownership identifier.
    #
    # Creates a domain ownership identifier for web app, or updates an existing
    # ownership identifier.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param domain_ownership_identifier_name [String] Name of domain ownership
    # identifier.
    # @param domain_ownership_identifier [Identifier] A JSON representation of the
    # domain ownership properties.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_domain_ownership_identifier_async(resource_group_name, name, domain_ownership_identifier_name, domain_ownership_identifier, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'domain_ownership_identifier_name is nil' if domain_ownership_identifier_name.nil?
      fail ArgumentError, 'domain_ownership_identifier is nil' if domain_ownership_identifier.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::Web::Models::Identifier.mapper()
      request_content = @client.serialize(request_mapper,  domain_ownership_identifier)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/domainOwnershipIdentifiers/{domainOwnershipIdentifierName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'domainOwnershipIdentifierName' => domain_ownership_identifier_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:patch, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::Identifier.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get hostname bindings for an app or a deployment slot.
    #
    # Get hostname bindings for an app or a deployment slot.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<HostNameBinding>] operation results.
    #
    def list_host_name_bindings(resource_group_name, name, custom_headers = nil)
      first_page = list_host_name_bindings_as_lazy(resource_group_name, name, custom_headers)
      first_page.get_all_items
    end

    #
    # Get hostname bindings for an app or a deployment slot.
    #
    # Get hostname bindings for an app or a deployment slot.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_host_name_bindings_with_http_info(resource_group_name, name, custom_headers = nil)
      list_host_name_bindings_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Get hostname bindings for an app or a deployment slot.
    #
    # Get hostname bindings for an app or a deployment slot.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_host_name_bindings_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hostNameBindings'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::HostNameBindingCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get the named hostname binding for an app (or deployment slot, if specified).
    #
    # Get the named hostname binding for an app (or deployment slot, if specified).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param host_name [String] Hostname in the hostname binding.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [HostNameBinding] operation results.
    #
    def get_host_name_binding(resource_group_name, name, host_name, custom_headers = nil)
      response = get_host_name_binding_async(resource_group_name, name, host_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get the named hostname binding for an app (or deployment slot, if specified).
    #
    # Get the named hostname binding for an app (or deployment slot, if specified).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param host_name [String] Hostname in the hostname binding.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_host_name_binding_with_http_info(resource_group_name, name, host_name, custom_headers = nil)
      get_host_name_binding_async(resource_group_name, name, host_name, custom_headers).value!
    end

    #
    # Get the named hostname binding for an app (or deployment slot, if specified).
    #
    # Get the named hostname binding for an app (or deployment slot, if specified).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param host_name [String] Hostname in the hostname binding.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_host_name_binding_async(resource_group_name, name, host_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'host_name is nil' if host_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hostNameBindings/{hostName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'hostName' => host_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::HostNameBinding.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Creates a hostname binding for an app.
    #
    # Creates a hostname binding for an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param host_name [String] Hostname in the hostname binding.
    # @param host_name_binding [HostNameBinding] Binding details. This is the JSON
    # representation of a HostNameBinding object.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [HostNameBinding] operation results.
    #
    def create_or_update_host_name_binding(resource_group_name, name, host_name, host_name_binding, custom_headers = nil)
      response = create_or_update_host_name_binding_async(resource_group_name, name, host_name, host_name_binding, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Creates a hostname binding for an app.
    #
    # Creates a hostname binding for an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param host_name [String] Hostname in the hostname binding.
    # @param host_name_binding [HostNameBinding] Binding details. This is the JSON
    # representation of a HostNameBinding object.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def create_or_update_host_name_binding_with_http_info(resource_group_name, name, host_name, host_name_binding, custom_headers = nil)
      create_or_update_host_name_binding_async(resource_group_name, name, host_name, host_name_binding, custom_headers).value!
    end

    #
    # Creates a hostname binding for an app.
    #
    # Creates a hostname binding for an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param host_name [String] Hostname in the hostname binding.
    # @param host_name_binding [HostNameBinding] Binding details. This is the JSON
    # representation of a HostNameBinding object.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def create_or_update_host_name_binding_async(resource_group_name, name, host_name, host_name_binding, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'host_name is nil' if host_name.nil?
      fail ArgumentError, 'host_name_binding is nil' if host_name_binding.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::Web::Models::HostNameBinding.mapper()
      request_content = @client.serialize(request_mapper,  host_name_binding)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hostNameBindings/{hostName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'hostName' => host_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::HostNameBinding.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Deletes a hostname binding for an app.
    #
    # Deletes a hostname binding for an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param host_name [String] Hostname in the hostname binding.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def delete_host_name_binding(resource_group_name, name, host_name, custom_headers = nil)
      response = delete_host_name_binding_async(resource_group_name, name, host_name, custom_headers).value!
      nil
    end

    #
    # Deletes a hostname binding for an app.
    #
    # Deletes a hostname binding for an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param host_name [String] Hostname in the hostname binding.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_host_name_binding_with_http_info(resource_group_name, name, host_name, custom_headers = nil)
      delete_host_name_binding_async(resource_group_name, name, host_name, custom_headers).value!
    end

    #
    # Deletes a hostname binding for an app.
    #
    # Deletes a hostname binding for an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param host_name [String] Hostname in the hostname binding.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_host_name_binding_async(resource_group_name, name, host_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'host_name is nil' if host_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hostNameBindings/{hostName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'hostName' => host_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 204
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Retrieves a specific Service Bus Hybrid Connection used by this Web App.
    #
    # Retrieves a specific Service Bus Hybrid Connection used by this Web App.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] The name of the web app
    # @param namespace_name [String] The namespace for this hybrid connection
    # @param relay_name [String] The relay name for this hybrid connection
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [HybridConnection] operation results.
    #
    def get_hybrid_connection(resource_group_name, name, namespace_name, relay_name, custom_headers = nil)
      response = get_hybrid_connection_async(resource_group_name, name, namespace_name, relay_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Retrieves a specific Service Bus Hybrid Connection used by this Web App.
    #
    # Retrieves a specific Service Bus Hybrid Connection used by this Web App.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] The name of the web app
    # @param namespace_name [String] The namespace for this hybrid connection
    # @param relay_name [String] The relay name for this hybrid connection
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_hybrid_connection_with_http_info(resource_group_name, name, namespace_name, relay_name, custom_headers = nil)
      get_hybrid_connection_async(resource_group_name, name, namespace_name, relay_name, custom_headers).value!
    end

    #
    # Retrieves a specific Service Bus Hybrid Connection used by this Web App.
    #
    # Retrieves a specific Service Bus Hybrid Connection used by this Web App.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] The name of the web app
    # @param namespace_name [String] The namespace for this hybrid connection
    # @param relay_name [String] The relay name for this hybrid connection
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_hybrid_connection_async(resource_group_name, name, namespace_name, relay_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'namespace_name is nil' if namespace_name.nil?
      fail ArgumentError, 'relay_name is nil' if relay_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'namespaceName' => namespace_name,'relayName' => relay_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::HybridConnection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Creates a new Hybrid Connection using a Service Bus relay.
    #
    # Creates a new Hybrid Connection using a Service Bus relay.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] The name of the web app
    # @param namespace_name [String] The namespace for this hybrid connection
    # @param relay_name [String] The relay name for this hybrid connection
    # @param connection_envelope [HybridConnection] The details of the hybrid
    # connection
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [HybridConnection] operation results.
    #
    def create_or_update_hybrid_connection(resource_group_name, name, namespace_name, relay_name, connection_envelope, custom_headers = nil)
      response = create_or_update_hybrid_connection_async(resource_group_name, name, namespace_name, relay_name, connection_envelope, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Creates a new Hybrid Connection using a Service Bus relay.
    #
    # Creates a new Hybrid Connection using a Service Bus relay.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] The name of the web app
    # @param namespace_name [String] The namespace for this hybrid connection
    # @param relay_name [String] The relay name for this hybrid connection
    # @param connection_envelope [HybridConnection] The details of the hybrid
    # connection
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def create_or_update_hybrid_connection_with_http_info(resource_group_name, name, namespace_name, relay_name, connection_envelope, custom_headers = nil)
      create_or_update_hybrid_connection_async(resource_group_name, name, namespace_name, relay_name, connection_envelope, custom_headers).value!
    end

    #
    # Creates a new Hybrid Connection using a Service Bus relay.
    #
    # Creates a new Hybrid Connection using a Service Bus relay.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] The name of the web app
    # @param namespace_name [String] The namespace for this hybrid connection
    # @param relay_name [String] The relay name for this hybrid connection
    # @param connection_envelope [HybridConnection] The details of the hybrid
    # connection
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def create_or_update_hybrid_connection_async(resource_group_name, name, namespace_name, relay_name, connection_envelope, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'namespace_name is nil' if namespace_name.nil?
      fail ArgumentError, 'relay_name is nil' if relay_name.nil?
      fail ArgumentError, 'connection_envelope is nil' if connection_envelope.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::Web::Models::HybridConnection.mapper()
      request_content = @client.serialize(request_mapper,  connection_envelope)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'namespaceName' => namespace_name,'relayName' => relay_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::HybridConnection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Removes a Hybrid Connection from this site.
    #
    # Removes a Hybrid Connection from this site.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] The name of the web app
    # @param namespace_name [String] The namespace for this hybrid connection
    # @param relay_name [String] The relay name for this hybrid connection
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def delete_hybrid_connection(resource_group_name, name, namespace_name, relay_name, custom_headers = nil)
      response = delete_hybrid_connection_async(resource_group_name, name, namespace_name, relay_name, custom_headers).value!
      nil
    end

    #
    # Removes a Hybrid Connection from this site.
    #
    # Removes a Hybrid Connection from this site.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] The name of the web app
    # @param namespace_name [String] The namespace for this hybrid connection
    # @param relay_name [String] The relay name for this hybrid connection
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_hybrid_connection_with_http_info(resource_group_name, name, namespace_name, relay_name, custom_headers = nil)
      delete_hybrid_connection_async(resource_group_name, name, namespace_name, relay_name, custom_headers).value!
    end

    #
    # Removes a Hybrid Connection from this site.
    #
    # Removes a Hybrid Connection from this site.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] The name of the web app
    # @param namespace_name [String] The namespace for this hybrid connection
    # @param relay_name [String] The relay name for this hybrid connection
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_hybrid_connection_async(resource_group_name, name, namespace_name, relay_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'namespace_name is nil' if namespace_name.nil?
      fail ArgumentError, 'relay_name is nil' if relay_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'namespaceName' => namespace_name,'relayName' => relay_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 404
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Creates a new Hybrid Connection using a Service Bus relay.
    #
    # Creates a new Hybrid Connection using a Service Bus relay.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] The name of the web app
    # @param namespace_name [String] The namespace for this hybrid connection
    # @param relay_name [String] The relay name for this hybrid connection
    # @param connection_envelope [HybridConnection] The details of the hybrid
    # connection
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [HybridConnection] operation results.
    #
    def update_hybrid_connection(resource_group_name, name, namespace_name, relay_name, connection_envelope, custom_headers = nil)
      response = update_hybrid_connection_async(resource_group_name, name, namespace_name, relay_name, connection_envelope, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Creates a new Hybrid Connection using a Service Bus relay.
    #
    # Creates a new Hybrid Connection using a Service Bus relay.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] The name of the web app
    # @param namespace_name [String] The namespace for this hybrid connection
    # @param relay_name [String] The relay name for this hybrid connection
    # @param connection_envelope [HybridConnection] The details of the hybrid
    # connection
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_hybrid_connection_with_http_info(resource_group_name, name, namespace_name, relay_name, connection_envelope, custom_headers = nil)
      update_hybrid_connection_async(resource_group_name, name, namespace_name, relay_name, connection_envelope, custom_headers).value!
    end

    #
    # Creates a new Hybrid Connection using a Service Bus relay.
    #
    # Creates a new Hybrid Connection using a Service Bus relay.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] The name of the web app
    # @param namespace_name [String] The namespace for this hybrid connection
    # @param relay_name [String] The relay name for this hybrid connection
    # @param connection_envelope [HybridConnection] The details of the hybrid
    # connection
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_hybrid_connection_async(resource_group_name, name, namespace_name, relay_name, connection_envelope, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'namespace_name is nil' if namespace_name.nil?
      fail ArgumentError, 'relay_name is nil' if relay_name.nil?
      fail ArgumentError, 'connection_envelope is nil' if connection_envelope.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::Web::Models::HybridConnection.mapper()
      request_content = @client.serialize(request_mapper,  connection_envelope)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'namespaceName' => namespace_name,'relayName' => relay_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:patch, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::HybridConnection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the send key name and value for a Hybrid Connection.
    #
    # Gets the send key name and value for a Hybrid Connection.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] The name of the web app
    # @param namespace_name [String] The namespace for this hybrid connection
    # @param relay_name [String] The relay name for this hybrid connection
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [HybridConnectionKey] operation results.
    #
    def list_hybrid_connection_keys(resource_group_name, name, namespace_name, relay_name, custom_headers = nil)
      response = list_hybrid_connection_keys_async(resource_group_name, name, namespace_name, relay_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the send key name and value for a Hybrid Connection.
    #
    # Gets the send key name and value for a Hybrid Connection.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] The name of the web app
    # @param namespace_name [String] The namespace for this hybrid connection
    # @param relay_name [String] The relay name for this hybrid connection
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_hybrid_connection_keys_with_http_info(resource_group_name, name, namespace_name, relay_name, custom_headers = nil)
      list_hybrid_connection_keys_async(resource_group_name, name, namespace_name, relay_name, custom_headers).value!
    end

    #
    # Gets the send key name and value for a Hybrid Connection.
    #
    # Gets the send key name and value for a Hybrid Connection.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] The name of the web app
    # @param namespace_name [String] The namespace for this hybrid connection
    # @param relay_name [String] The relay name for this hybrid connection
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_hybrid_connection_keys_async(resource_group_name, name, namespace_name, relay_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'namespace_name is nil' if namespace_name.nil?
      fail ArgumentError, 'relay_name is nil' if relay_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}/listKeys'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'namespaceName' => namespace_name,'relayName' => relay_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::HybridConnectionKey.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Retrieves all Service Bus Hybrid Connections used by this Web App.
    #
    # Retrieves all Service Bus Hybrid Connections used by this Web App.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] The name of the web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [HybridConnection] operation results.
    #
    def list_hybrid_connections(resource_group_name, name, custom_headers = nil)
      response = list_hybrid_connections_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Retrieves all Service Bus Hybrid Connections used by this Web App.
    #
    # Retrieves all Service Bus Hybrid Connections used by this Web App.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] The name of the web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_hybrid_connections_with_http_info(resource_group_name, name, custom_headers = nil)
      list_hybrid_connections_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Retrieves all Service Bus Hybrid Connections used by this Web App.
    #
    # Retrieves all Service Bus Hybrid Connections used by this Web App.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] The name of the web app
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_hybrid_connections_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridConnectionRelays'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::HybridConnection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets hybrid connections configured for an app (or deployment slot, if
    # specified).
    #
    # Gets hybrid connections configured for an app (or deployment slot, if
    # specified).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [RelayServiceConnectionEntity] operation results.
    #
    def list_relay_service_connections(resource_group_name, name, custom_headers = nil)
      response = list_relay_service_connections_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets hybrid connections configured for an app (or deployment slot, if
    # specified).
    #
    # Gets hybrid connections configured for an app (or deployment slot, if
    # specified).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_relay_service_connections_with_http_info(resource_group_name, name, custom_headers = nil)
      list_relay_service_connections_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Gets hybrid connections configured for an app (or deployment slot, if
    # specified).
    #
    # Gets hybrid connections configured for an app (or deployment slot, if
    # specified).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_relay_service_connections_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridconnection'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::RelayServiceConnectionEntity.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets a hybrid connection configuration by its name.
    #
    # Gets a hybrid connection configuration by its name.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param entity_name [String] Name of the hybrid connection.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [RelayServiceConnectionEntity] operation results.
    #
    def get_relay_service_connection(resource_group_name, name, entity_name, custom_headers = nil)
      response = get_relay_service_connection_async(resource_group_name, name, entity_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets a hybrid connection configuration by its name.
    #
    # Gets a hybrid connection configuration by its name.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param entity_name [String] Name of the hybrid connection.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_relay_service_connection_with_http_info(resource_group_name, name, entity_name, custom_headers = nil)
      get_relay_service_connection_async(resource_group_name, name, entity_name, custom_headers).value!
    end

    #
    # Gets a hybrid connection configuration by its name.
    #
    # Gets a hybrid connection configuration by its name.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param entity_name [String] Name of the hybrid connection.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_relay_service_connection_async(resource_group_name, name, entity_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'entity_name is nil' if entity_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridconnection/{entityName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'entityName' => entity_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::RelayServiceConnectionEntity.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Creates a new hybrid connection configuration (PUT), or updates an existing
    # one (PATCH).
    #
    # Creates a new hybrid connection configuration (PUT), or updates an existing
    # one (PATCH).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param entity_name [String] Name of the hybrid connection configuration.
    # @param connection_envelope [RelayServiceConnectionEntity] Details of the
    # hybrid connection configuration.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [RelayServiceConnectionEntity] operation results.
    #
    def create_or_update_relay_service_connection(resource_group_name, name, entity_name, connection_envelope, custom_headers = nil)
      response = create_or_update_relay_service_connection_async(resource_group_name, name, entity_name, connection_envelope, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Creates a new hybrid connection configuration (PUT), or updates an existing
    # one (PATCH).
    #
    # Creates a new hybrid connection configuration (PUT), or updates an existing
    # one (PATCH).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param entity_name [String] Name of the hybrid connection configuration.
    # @param connection_envelope [RelayServiceConnectionEntity] Details of the
    # hybrid connection configuration.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def create_or_update_relay_service_connection_with_http_info(resource_group_name, name, entity_name, connection_envelope, custom_headers = nil)
      create_or_update_relay_service_connection_async(resource_group_name, name, entity_name, connection_envelope, custom_headers).value!
    end

    #
    # Creates a new hybrid connection configuration (PUT), or updates an existing
    # one (PATCH).
    #
    # Creates a new hybrid connection configuration (PUT), or updates an existing
    # one (PATCH).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param entity_name [String] Name of the hybrid connection configuration.
    # @param connection_envelope [RelayServiceConnectionEntity] Details of the
    # hybrid connection configuration.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def create_or_update_relay_service_connection_async(resource_group_name, name, entity_name, connection_envelope, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'entity_name is nil' if entity_name.nil?
      fail ArgumentError, 'connection_envelope is nil' if connection_envelope.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::Web::Models::RelayServiceConnectionEntity.mapper()
      request_content = @client.serialize(request_mapper,  connection_envelope)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridconnection/{entityName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'entityName' => entity_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::RelayServiceConnectionEntity.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Deletes a relay service connection by its name.
    #
    # Deletes a relay service connection by its name.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param entity_name [String] Name of the hybrid connection configuration.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def delete_relay_service_connection(resource_group_name, name, entity_name, custom_headers = nil)
      response = delete_relay_service_connection_async(resource_group_name, name, entity_name, custom_headers).value!
      nil
    end

    #
    # Deletes a relay service connection by its name.
    #
    # Deletes a relay service connection by its name.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param entity_name [String] Name of the hybrid connection configuration.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_relay_service_connection_with_http_info(resource_group_name, name, entity_name, custom_headers = nil)
      delete_relay_service_connection_async(resource_group_name, name, entity_name, custom_headers).value!
    end

    #
    # Deletes a relay service connection by its name.
    #
    # Deletes a relay service connection by its name.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param entity_name [String] Name of the hybrid connection configuration.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_relay_service_connection_async(resource_group_name, name, entity_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'entity_name is nil' if entity_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridconnection/{entityName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'entityName' => entity_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 404
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Creates a new hybrid connection configuration (PUT), or updates an existing
    # one (PATCH).
    #
    # Creates a new hybrid connection configuration (PUT), or updates an existing
    # one (PATCH).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param entity_name [String] Name of the hybrid connection configuration.
    # @param connection_envelope [RelayServiceConnectionEntity] Details of the
    # hybrid connection configuration.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [RelayServiceConnectionEntity] operation results.
    #
    def update_relay_service_connection(resource_group_name, name, entity_name, connection_envelope, custom_headers = nil)
      response = update_relay_service_connection_async(resource_group_name, name, entity_name, connection_envelope, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Creates a new hybrid connection configuration (PUT), or updates an existing
    # one (PATCH).
    #
    # Creates a new hybrid connection configuration (PUT), or updates an existing
    # one (PATCH).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param entity_name [String] Name of the hybrid connection configuration.
    # @param connection_envelope [RelayServiceConnectionEntity] Details of the
    # hybrid connection configuration.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_relay_service_connection_with_http_info(resource_group_name, name, entity_name, connection_envelope, custom_headers = nil)
      update_relay_service_connection_async(resource_group_name, name, entity_name, connection_envelope, custom_headers).value!
    end

    #
    # Creates a new hybrid connection configuration (PUT), or updates an existing
    # one (PATCH).
    #
    # Creates a new hybrid connection configuration (PUT), or updates an existing
    # one (PATCH).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param entity_name [String] Name of the hybrid connection configuration.
    # @param connection_envelope [RelayServiceConnectionEntity] Details of the
    # hybrid connection configuration.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_relay_service_connection_async(resource_group_name, name, entity_name, connection_envelope, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'entity_name is nil' if entity_name.nil?
      fail ArgumentError, 'connection_envelope is nil' if connection_envelope.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::Web::Models::RelayServiceConnectionEntity.mapper()
      request_content = @client.serialize(request_mapper,  connection_envelope)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridconnection/{entityName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'entityName' => entity_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:patch, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::RelayServiceConnectionEntity.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets all scale-out instances of an app.
    #
    # Gets all scale-out instances of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<SiteInstance>] operation results.
    #
    def list_instance_identifiers(resource_group_name, name, custom_headers = nil)
      first_page = list_instance_identifiers_as_lazy(resource_group_name, name, custom_headers)
      first_page.get_all_items
    end

    #
    # Gets all scale-out instances of an app.
    #
    # Gets all scale-out instances of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_instance_identifiers_with_http_info(resource_group_name, name, custom_headers = nil)
      list_instance_identifiers_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Gets all scale-out instances of an app.
    #
    # Gets all scale-out instances of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_instance_identifiers_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::WebAppInstanceCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # List deployments for an app, or a deployment slot, or for an instance of a
    # scaled-out app.
    #
    # List deployments for an app, or a deployment slot, or for an instance of a
    # scaled-out app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param instance_id [String] The ID of a specific scaled-out instance. This is
    # the value of the name property in the JSON response from "GET
    # api/sites/{siteName}/instances"
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<Deployment>] operation results.
    #
    def list_instance_deployments(resource_group_name, name, instance_id, custom_headers = nil)
      first_page = list_instance_deployments_as_lazy(resource_group_name, name, instance_id, custom_headers)
      first_page.get_all_items
    end

    #
    # List deployments for an app, or a deployment slot, or for an instance of a
    # scaled-out app.
    #
    # List deployments for an app, or a deployment slot, or for an instance of a
    # scaled-out app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param instance_id [String] The ID of a specific scaled-out instance. This is
    # the value of the name property in the JSON response from "GET
    # api/sites/{siteName}/instances"
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_instance_deployments_with_http_info(resource_group_name, name, instance_id, custom_headers = nil)
      list_instance_deployments_async(resource_group_name, name, instance_id, custom_headers).value!
    end

    #
    # List deployments for an app, or a deployment slot, or for an instance of a
    # scaled-out app.
    #
    # List deployments for an app, or a deployment slot, or for an instance of a
    # scaled-out app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param instance_id [String] The ID of a specific scaled-out instance. This is
    # the value of the name property in the JSON response from "GET
    # api/sites/{siteName}/instances"
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_instance_deployments_async(resource_group_name, name, instance_id, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'instance_id is nil' if instance_id.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/deployments'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'instanceId' => instance_id,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::DeploymentCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get a deployment by its ID for an app, a specific deployment slot, and/or a
    # specific scaled-out instance.
    #
    # Get a deployment by its ID for an app, a specific deployment slot, and/or a
    # specific scaled-out instance.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param id [String] Deployment ID.
    # @param instance_id [String] ID of a specific scaled-out instance. This is the
    # value of the name property in the JSON response from "GET
    # api/sites/{siteName}/instances"
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Deployment] operation results.
    #
    def get_instance_deployment(resource_group_name, name, id, instance_id, custom_headers = nil)
      response = get_instance_deployment_async(resource_group_name, name, id, instance_id, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get a deployment by its ID for an app, a specific deployment slot, and/or a
    # specific scaled-out instance.
    #
    # Get a deployment by its ID for an app, a specific deployment slot, and/or a
    # specific scaled-out instance.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param id [String] Deployment ID.
    # @param instance_id [String] ID of a specific scaled-out instance. This is the
    # value of the name property in the JSON response from "GET
    # api/sites/{siteName}/instances"
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_instance_deployment_with_http_info(resource_group_name, name, id, instance_id, custom_headers = nil)
      get_instance_deployment_async(resource_group_name, name, id, instance_id, custom_headers).value!
    end

    #
    # Get a deployment by its ID for an app, a specific deployment slot, and/or a
    # specific scaled-out instance.
    #
    # Get a deployment by its ID for an app, a specific deployment slot, and/or a
    # specific scaled-out instance.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param id [String] Deployment ID.
    # @param instance_id [String] ID of a specific scaled-out instance. This is the
    # value of the name property in the JSON response from "GET
    # api/sites/{siteName}/instances"
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_instance_deployment_async(resource_group_name, name, id, instance_id, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'id is nil' if id.nil?
      fail ArgumentError, 'instance_id is nil' if instance_id.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/deployments/{id}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'id' => id,'instanceId' => instance_id,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::Deployment.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Create a deployment for an app, a specific deployment slot, and/or a specific
    # scaled-out instance.
    #
    # Create a deployment for an app, a specific deployment slot, and/or a specific
    # scaled-out instance.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param id [String] ID of an existing deployment.
    # @param instance_id [String] ID of a specific scaled-out instance. This is the
    # value of the name property in the JSON response from "GET
    # api/sites/{siteName}/instances"
    # @param deployment [Deployment] Deployment details.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Deployment] operation results.
    #
    def create_instance_deployment(resource_group_name, name, id, instance_id, deployment, custom_headers = nil)
      response = create_instance_deployment_async(resource_group_name, name, id, instance_id, deployment, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Create a deployment for an app, a specific deployment slot, and/or a specific
    # scaled-out instance.
    #
    # Create a deployment for an app, a specific deployment slot, and/or a specific
    # scaled-out instance.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param id [String] ID of an existing deployment.
    # @param instance_id [String] ID of a specific scaled-out instance. This is the
    # value of the name property in the JSON response from "GET
    # api/sites/{siteName}/instances"
    # @param deployment [Deployment] Deployment details.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def create_instance_deployment_with_http_info(resource_group_name, name, id, instance_id, deployment, custom_headers = nil)
      create_instance_deployment_async(resource_group_name, name, id, instance_id, deployment, custom_headers).value!
    end

    #
    # Create a deployment for an app, a specific deployment slot, and/or a specific
    # scaled-out instance.
    #
    # Create a deployment for an app, a specific deployment slot, and/or a specific
    # scaled-out instance.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param id [String] ID of an existing deployment.
    # @param instance_id [String] ID of a specific scaled-out instance. This is the
    # value of the name property in the JSON response from "GET
    # api/sites/{siteName}/instances"
    # @param deployment [Deployment] Deployment details.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def create_instance_deployment_async(resource_group_name, name, id, instance_id, deployment, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'id is nil' if id.nil?
      fail ArgumentError, 'instance_id is nil' if instance_id.nil?
      fail ArgumentError, 'deployment is nil' if deployment.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::Web::Models::Deployment.mapper()
      request_content = @client.serialize(request_mapper,  deployment)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/deployments/{id}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'id' => id,'instanceId' => instance_id,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::Deployment.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Delete a deployment by its ID for an app, a specific deployment slot, and/or
    # a specific scaled-out instance.
    #
    # Delete a deployment by its ID for an app, a specific deployment slot, and/or
    # a specific scaled-out instance.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param id [String] Deployment ID.
    # @param instance_id [String] ID of a specific scaled-out instance. This is the
    # value of the name property in the JSON response from "GET
    # api/sites/{siteName}/instances"
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def delete_instance_deployment(resource_group_name, name, id, instance_id, custom_headers = nil)
      response = delete_instance_deployment_async(resource_group_name, name, id, instance_id, custom_headers).value!
      nil
    end

    #
    # Delete a deployment by its ID for an app, a specific deployment slot, and/or
    # a specific scaled-out instance.
    #
    # Delete a deployment by its ID for an app, a specific deployment slot, and/or
    # a specific scaled-out instance.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param id [String] Deployment ID.
    # @param instance_id [String] ID of a specific scaled-out instance. This is the
    # value of the name property in the JSON response from "GET
    # api/sites/{siteName}/instances"
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_instance_deployment_with_http_info(resource_group_name, name, id, instance_id, custom_headers = nil)
      delete_instance_deployment_async(resource_group_name, name, id, instance_id, custom_headers).value!
    end

    #
    # Delete a deployment by its ID for an app, a specific deployment slot, and/or
    # a specific scaled-out instance.
    #
    # Delete a deployment by its ID for an app, a specific deployment slot, and/or
    # a specific scaled-out instance.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param id [String] Deployment ID.
    # @param instance_id [String] ID of a specific scaled-out instance. This is the
    # value of the name property in the JSON response from "GET
    # api/sites/{siteName}/instances"
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_instance_deployment_async(resource_group_name, name, id, instance_id, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'id is nil' if id.nil?
      fail ArgumentError, 'instance_id is nil' if instance_id.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/deployments/{id}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'id' => id,'instanceId' => instance_id,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 204
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Shows whether an app can be cloned to another resource group or subscription.
    #
    # Shows whether an app can be cloned to another resource group or subscription.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteCloneability] operation results.
    #
    def is_cloneable(resource_group_name, name, custom_headers = nil)
      response = is_cloneable_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Shows whether an app can be cloned to another resource group or subscription.
    #
    # Shows whether an app can be cloned to another resource group or subscription.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def is_cloneable_with_http_info(resource_group_name, name, custom_headers = nil)
      is_cloneable_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Shows whether an app can be cloned to another resource group or subscription.
    #
    # Shows whether an app can be cloned to another resource group or subscription.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def is_cloneable_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/iscloneable'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::SiteCloneability.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets all metric definitions of an app (or deployment slot, if specified).
    #
    # Gets all metric definitions of an app (or deployment slot, if specified).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<ResourceMetricDefinition>] operation results.
    #
    def list_metric_definitions(resource_group_name, name, custom_headers = nil)
      first_page = list_metric_definitions_as_lazy(resource_group_name, name, custom_headers)
      first_page.get_all_items
    end

    #
    # Gets all metric definitions of an app (or deployment slot, if specified).
    #
    # Gets all metric definitions of an app (or deployment slot, if specified).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_metric_definitions_with_http_info(resource_group_name, name, custom_headers = nil)
      list_metric_definitions_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Gets all metric definitions of an app (or deployment slot, if specified).
    #
    # Gets all metric definitions of an app (or deployment slot, if specified).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_metric_definitions_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/metricdefinitions'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::ResourceMetricDefinitionCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets performance metrics of an app (or deployment slot, if specified).
    #
    # Gets performance metrics of an app (or deployment slot, if specified).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param details [Boolean] Specify "true" to include metric details in the
    # response. It is "false" by default.
    # @param filter [String] Return only metrics specified in the filter (using
    # OData syntax). For example: $filter=(name.value eq 'Metric1' or name.value eq
    # 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and endTime eq
    # '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<ResourceMetric>] operation results.
    #
    def list_metrics(resource_group_name, name, details = nil, filter = nil, custom_headers = nil)
      first_page = list_metrics_as_lazy(resource_group_name, name, details, filter, custom_headers)
      first_page.get_all_items
    end

    #
    # Gets performance metrics of an app (or deployment slot, if specified).
    #
    # Gets performance metrics of an app (or deployment slot, if specified).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param details [Boolean] Specify "true" to include metric details in the
    # response. It is "false" by default.
    # @param filter [String] Return only metrics specified in the filter (using
    # OData syntax). For example: $filter=(name.value eq 'Metric1' or name.value eq
    # 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and endTime eq
    # '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_metrics_with_http_info(resource_group_name, name, details = nil, filter = nil, custom_headers = nil)
      list_metrics_async(resource_group_name, name, details, filter, custom_headers).value!
    end

    #
    # Gets performance metrics of an app (or deployment slot, if specified).
    #
    # Gets performance metrics of an app (or deployment slot, if specified).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param details [Boolean] Specify "true" to include metric details in the
    # response. It is "false" by default.
    # @param filter [String] Return only metrics specified in the filter (using
    # OData syntax). For example: $filter=(name.value eq 'Metric1' or name.value eq
    # 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and endTime eq
    # '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_metrics_async(resource_group_name, name, details = nil, filter = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/metrics'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'details' => details,'api-version' => api_version},
          skip_encoding_query_params: {'$filter' => filter},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::ResourceMetricCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Restores a web app.
    #
    # Restores a web app.
    #
    # @param subscription_name [String] Azure subscription
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of web app
    # @param migration_options [StorageMigrationOptions] Migration migrationOptions
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [StorageMigrationResponse] operation results.
    #
    def migrate_storage(subscription_name, resource_group_name, name, migration_options, custom_headers = nil)
      response = migrate_storage_async(subscription_name, resource_group_name, name, migration_options, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param subscription_name [String] Azure subscription
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of web app
    # @param migration_options [StorageMigrationOptions] Migration migrationOptions
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def migrate_storage_async(subscription_name, resource_group_name, name, migration_options, custom_headers = nil)
      # Send request
      promise = begin_migrate_storage_async(subscription_name, resource_group_name, name, migration_options, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Azure::ARM::Web::Models::StorageMigrationResponse.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response)
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Migrates a local (in-app) MySql database to a remote MySql database.
    #
    # Migrates a local (in-app) MySql database to a remote MySql database.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of web app
    # @param migration_request_envelope [MigrateMySqlRequest] MySql migration
    # options
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Operation] operation results.
    #
    def migrate_my_sql(resource_group_name, name, migration_request_envelope, custom_headers = nil)
      response = migrate_my_sql_async(resource_group_name, name, migration_request_envelope, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of web app
    # @param migration_request_envelope [MigrateMySqlRequest] MySql migration
    # options
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def migrate_my_sql_async(resource_group_name, name, migration_request_envelope, custom_headers = nil)
      # Send request
      promise = begin_migrate_my_sql_async(resource_group_name, name, migration_request_envelope, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Azure::ARM::Web::Models::Operation.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response)
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Returns the status of MySql in app migration, if one is active, and whether
    # or not MySql in app is enabled
    #
    # Returns the status of MySql in app migration, if one is active, and whether
    # or not MySql in app is enabled
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MigrateMySqlStatus] operation results.
    #
    def get_migrate_my_sql_status(resource_group_name, name, custom_headers = nil)
      response = get_migrate_my_sql_status_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Returns the status of MySql in app migration, if one is active, and whether
    # or not MySql in app is enabled
    #
    # Returns the status of MySql in app migration, if one is active, and whether
    # or not MySql in app is enabled
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_migrate_my_sql_status_with_http_info(resource_group_name, name, custom_headers = nil)
      get_migrate_my_sql_status_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Returns the status of MySql in app migration, if one is active, and whether
    # or not MySql in app is enabled
    #
    # Returns the status of MySql in app migration, if one is active, and whether
    # or not MySql in app is enabled
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of web app
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_migrate_my_sql_status_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/migratemysql/status'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::MigrateMySqlStatus.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets all network features used by the app (or deployment slot, if specified).
    #
    # Gets all network features used by the app (or deployment slot, if specified).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param view [String] The type of view. This can either be "summary" or
    # "detailed".
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [NetworkFeatures] operation results.
    #
    def list_network_features(resource_group_name, name, view, custom_headers = nil)
      response = list_network_features_async(resource_group_name, name, view, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets all network features used by the app (or deployment slot, if specified).
    #
    # Gets all network features used by the app (or deployment slot, if specified).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param view [String] The type of view. This can either be "summary" or
    # "detailed".
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_network_features_with_http_info(resource_group_name, name, view, custom_headers = nil)
      list_network_features_async(resource_group_name, name, view, custom_headers).value!
    end

    #
    # Gets all network features used by the app (or deployment slot, if specified).
    #
    # Gets all network features used by the app (or deployment slot, if specified).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param view [String] The type of view. This can either be "summary" or
    # "detailed".
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_network_features_async(resource_group_name, name, view, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'view is nil' if view.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/networkFeatures/{view}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'view' => view,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 404
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::NetworkFeatures.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Start capturing network packets for the site.
    #
    # Start capturing network packets for the site.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] The name of the web app.
    # @param duration_in_seconds [Integer] The duration to keep capturing in
    # seconds.
    # @param max_frame_length [Integer] The maximum frame length in bytes
    # (Optional).
    # @param sas_url [String] The Blob URL to store capture file.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [String] operation results.
    #
    def start_web_site_network_trace(resource_group_name, name, duration_in_seconds = nil, max_frame_length = nil, sas_url = nil, custom_headers = nil)
      response = start_web_site_network_trace_async(resource_group_name, name, duration_in_seconds, max_frame_length, sas_url, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Start capturing network packets for the site.
    #
    # Start capturing network packets for the site.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] The name of the web app.
    # @param duration_in_seconds [Integer] The duration to keep capturing in
    # seconds.
    # @param max_frame_length [Integer] The maximum frame length in bytes
    # (Optional).
    # @param sas_url [String] The Blob URL to store capture file.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def start_web_site_network_trace_with_http_info(resource_group_name, name, duration_in_seconds = nil, max_frame_length = nil, sas_url = nil, custom_headers = nil)
      start_web_site_network_trace_async(resource_group_name, name, duration_in_seconds, max_frame_length, sas_url, custom_headers).value!
    end

    #
    # Start capturing network packets for the site.
    #
    # Start capturing network packets for the site.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] The name of the web app.
    # @param duration_in_seconds [Integer] The duration to keep capturing in
    # seconds.
    # @param max_frame_length [Integer] The maximum frame length in bytes
    # (Optional).
    # @param sas_url [String] The Blob URL to store capture file.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def start_web_site_network_trace_async(resource_group_name, name, duration_in_seconds = nil, max_frame_length = nil, sas_url = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/networkTrace/start'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'durationInSeconds' => duration_in_seconds,'maxFrameLength' => max_frame_length,'sasUrl' => sas_url,'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = {
              required: false,
              serialized_name: 'parsed_response',
              type: {
                name: 'String'
              }
            }
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Stop ongoing capturing network packets for the site.
    #
    # Stop ongoing capturing network packets for the site.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] The name of the web app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [String] operation results.
    #
    def stop_web_site_network_trace(resource_group_name, name, custom_headers = nil)
      response = stop_web_site_network_trace_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Stop ongoing capturing network packets for the site.
    #
    # Stop ongoing capturing network packets for the site.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] The name of the web app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def stop_web_site_network_trace_with_http_info(resource_group_name, name, custom_headers = nil)
      stop_web_site_network_trace_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Stop ongoing capturing network packets for the site.
    #
    # Stop ongoing capturing network packets for the site.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] The name of the web app.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def stop_web_site_network_trace_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/networkTrace/stop'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = {
              required: false,
              serialized_name: 'parsed_response',
              type: {
                name: 'String'
              }
            }
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Generates a new publishing password for an app (or deployment slot, if
    # specified).
    #
    # Generates a new publishing password for an app (or deployment slot, if
    # specified).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def generate_new_site_publishing_password(resource_group_name, name, custom_headers = nil)
      response = generate_new_site_publishing_password_async(resource_group_name, name, custom_headers).value!
      nil
    end

    #
    # Generates a new publishing password for an app (or deployment slot, if
    # specified).
    #
    # Generates a new publishing password for an app (or deployment slot, if
    # specified).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def generate_new_site_publishing_password_with_http_info(resource_group_name, name, custom_headers = nil)
      generate_new_site_publishing_password_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Generates a new publishing password for an app (or deployment slot, if
    # specified).
    #
    # Generates a new publishing password for an app (or deployment slot, if
    # specified).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def generate_new_site_publishing_password_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/newpassword'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 204
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Gets perfmon counters for web app.
    #
    # Gets perfmon counters for web app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of web app
    # @param filter [String] Return only usages/metrics specified in the filter.
    # Filter conforms to odata syntax. Example: $filter=(startTime eq
    # '2014-01-01T00:00:00Z' and endTime eq '2014-12-31T23:59:59Z' and timeGrain eq
    # duration'[Hour|Minute|Day]'.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<PerfMonResponse>] operation results.
    #
    def list_perf_mon_counters(resource_group_name, name, filter = nil, custom_headers = nil)
      first_page = list_perf_mon_counters_as_lazy(resource_group_name, name, filter, custom_headers)
      first_page.get_all_items
    end

    #
    # Gets perfmon counters for web app.
    #
    # Gets perfmon counters for web app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of web app
    # @param filter [String] Return only usages/metrics specified in the filter.
    # Filter conforms to odata syntax. Example: $filter=(startTime eq
    # '2014-01-01T00:00:00Z' and endTime eq '2014-12-31T23:59:59Z' and timeGrain eq
    # duration'[Hour|Minute|Day]'.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_perf_mon_counters_with_http_info(resource_group_name, name, filter = nil, custom_headers = nil)
      list_perf_mon_counters_async(resource_group_name, name, filter, custom_headers).value!
    end

    #
    # Gets perfmon counters for web app.
    #
    # Gets perfmon counters for web app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of web app
    # @param filter [String] Return only usages/metrics specified in the filter.
    # Filter conforms to odata syntax. Example: $filter=(startTime eq
    # '2014-01-01T00:00:00Z' and endTime eq '2014-12-31T23:59:59Z' and timeGrain eq
    # duration'[Hour|Minute|Day]'.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_perf_mon_counters_async(resource_group_name, name, filter = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/perfcounters'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          skip_encoding_query_params: {'$filter' => filter},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::PerfMonCounterCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets web app's event logs.
    #
    # Gets web app's event logs.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SitePhpErrorLogFlag] operation results.
    #
    def get_site_php_error_log_flag(resource_group_name, name, custom_headers = nil)
      response = get_site_php_error_log_flag_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets web app's event logs.
    #
    # Gets web app's event logs.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_site_php_error_log_flag_with_http_info(resource_group_name, name, custom_headers = nil)
      get_site_php_error_log_flag_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Gets web app's event logs.
    #
    # Gets web app's event logs.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of web app
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_site_php_error_log_flag_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/phplogging'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::SitePhpErrorLogFlag.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the premier add-ons of an app.
    #
    # Gets the premier add-ons of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [PremierAddOn] operation results.
    #
    def list_premier_add_ons(resource_group_name, name, custom_headers = nil)
      response = list_premier_add_ons_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the premier add-ons of an app.
    #
    # Gets the premier add-ons of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_premier_add_ons_with_http_info(resource_group_name, name, custom_headers = nil)
      list_premier_add_ons_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Gets the premier add-ons of an app.
    #
    # Gets the premier add-ons of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_premier_add_ons_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/premieraddons'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::PremierAddOn.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets a named add-on of an app.
    #
    # Gets a named add-on of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param premier_add_on_name [String] Add-on name.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [PremierAddOn] operation results.
    #
    def get_premier_add_on(resource_group_name, name, premier_add_on_name, custom_headers = nil)
      response = get_premier_add_on_async(resource_group_name, name, premier_add_on_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets a named add-on of an app.
    #
    # Gets a named add-on of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param premier_add_on_name [String] Add-on name.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_premier_add_on_with_http_info(resource_group_name, name, premier_add_on_name, custom_headers = nil)
      get_premier_add_on_async(resource_group_name, name, premier_add_on_name, custom_headers).value!
    end

    #
    # Gets a named add-on of an app.
    #
    # Gets a named add-on of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param premier_add_on_name [String] Add-on name.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_premier_add_on_async(resource_group_name, name, premier_add_on_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'premier_add_on_name is nil' if premier_add_on_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/premieraddons/{premierAddOnName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'premierAddOnName' => premier_add_on_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::PremierAddOn.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Updates a named add-on of an app.
    #
    # Updates a named add-on of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param premier_add_on_name [String] Add-on name.
    # @param premier_add_on [PremierAddOn] A JSON representation of the edited
    # premier add-on.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [PremierAddOn] operation results.
    #
    def add_premier_add_on(resource_group_name, name, premier_add_on_name, premier_add_on, custom_headers = nil)
      response = add_premier_add_on_async(resource_group_name, name, premier_add_on_name, premier_add_on, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Updates a named add-on of an app.
    #
    # Updates a named add-on of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param premier_add_on_name [String] Add-on name.
    # @param premier_add_on [PremierAddOn] A JSON representation of the edited
    # premier add-on.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def add_premier_add_on_with_http_info(resource_group_name, name, premier_add_on_name, premier_add_on, custom_headers = nil)
      add_premier_add_on_async(resource_group_name, name, premier_add_on_name, premier_add_on, custom_headers).value!
    end

    #
    # Updates a named add-on of an app.
    #
    # Updates a named add-on of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param premier_add_on_name [String] Add-on name.
    # @param premier_add_on [PremierAddOn] A JSON representation of the edited
    # premier add-on.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def add_premier_add_on_async(resource_group_name, name, premier_add_on_name, premier_add_on, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'premier_add_on_name is nil' if premier_add_on_name.nil?
      fail ArgumentError, 'premier_add_on is nil' if premier_add_on.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::Web::Models::PremierAddOn.mapper()
      request_content = @client.serialize(request_mapper,  premier_add_on)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/premieraddons/{premierAddOnName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'premierAddOnName' => premier_add_on_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::PremierAddOn.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Delete a premier add-on from an app.
    #
    # Delete a premier add-on from an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param premier_add_on_name [String] Add-on name.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def delete_premier_add_on(resource_group_name, name, premier_add_on_name, custom_headers = nil)
      response = delete_premier_add_on_async(resource_group_name, name, premier_add_on_name, custom_headers).value!
      nil
    end

    #
    # Delete a premier add-on from an app.
    #
    # Delete a premier add-on from an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param premier_add_on_name [String] Add-on name.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_premier_add_on_with_http_info(resource_group_name, name, premier_add_on_name, custom_headers = nil)
      delete_premier_add_on_async(resource_group_name, name, premier_add_on_name, custom_headers).value!
    end

    #
    # Delete a premier add-on from an app.
    #
    # Delete a premier add-on from an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param premier_add_on_name [String] Add-on name.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_premier_add_on_async(resource_group_name, name, premier_add_on_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'premier_add_on_name is nil' if premier_add_on_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/premieraddons/{premierAddOnName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'premierAddOnName' => premier_add_on_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Gets the publishing profile for an app (or deployment slot, if specified).
    #
    # Gets the publishing profile for an app (or deployment slot, if specified).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param publishing_profile_options [CsmPublishingProfileOptions] Specifies
    # publishingProfileOptions for publishing profile. For example, use {"format":
    # "FileZilla3"} to get a FileZilla publishing profile.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [NOT_IMPLEMENTED] operation results.
    #
    def list_publishing_profile_xml_with_secrets(resource_group_name, name, publishing_profile_options, custom_headers = nil)
      response = list_publishing_profile_xml_with_secrets_async(resource_group_name, name, publishing_profile_options, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the publishing profile for an app (or deployment slot, if specified).
    #
    # Gets the publishing profile for an app (or deployment slot, if specified).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param publishing_profile_options [CsmPublishingProfileOptions] Specifies
    # publishingProfileOptions for publishing profile. For example, use {"format":
    # "FileZilla3"} to get a FileZilla publishing profile.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_publishing_profile_xml_with_secrets_with_http_info(resource_group_name, name, publishing_profile_options, custom_headers = nil)
      list_publishing_profile_xml_with_secrets_async(resource_group_name, name, publishing_profile_options, custom_headers).value!
    end

    #
    # Gets the publishing profile for an app (or deployment slot, if specified).
    #
    # Gets the publishing profile for an app (or deployment slot, if specified).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param publishing_profile_options [CsmPublishingProfileOptions] Specifies
    # publishingProfileOptions for publishing profile. For example, use {"format":
    # "FileZilla3"} to get a FileZilla publishing profile.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_publishing_profile_xml_with_secrets_async(resource_group_name, name, publishing_profile_options, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'publishing_profile_options is nil' if publishing_profile_options.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::Web::Models::CsmPublishingProfileOptions.mapper()
      request_content = @client.serialize(request_mapper,  publishing_profile_options)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/publishxml'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = {
              required: false,
              serialized_name: 'parsed_response',
              type: {
                name: 'Stream'
              }
            }
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Recovers a deleted web app.
    #
    # Recovers a deleted web app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of web app
    # @param recovery_entity [CsmSiteRecoveryEntity] Snapshot data used for web app
    # recovery. Snapshot information can be obtained by calling GetDeletedSites or
    # GetSiteSnapshots API.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [RecoverResponse] operation results.
    #
    def recover(resource_group_name, name, recovery_entity, custom_headers = nil)
      response = recover_async(resource_group_name, name, recovery_entity, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of web app
    # @param recovery_entity [CsmSiteRecoveryEntity] Snapshot data used for web app
    # recovery. Snapshot information can be obtained by calling GetDeletedSites or
    # GetSiteSnapshots API.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def recover_async(resource_group_name, name, recovery_entity, custom_headers = nil)
      # Send request
      promise = begin_recover_async(resource_group_name, name, recovery_entity, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Azure::ARM::Web::Models::RecoverResponse.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response)
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Resets the configuration settings of the current slot if they were previously
    # modified by calling the API with POST.
    #
    # Resets the configuration settings of the current slot if they were previously
    # modified by calling the API with POST.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def reset_production_slot_config(resource_group_name, name, custom_headers = nil)
      response = reset_production_slot_config_async(resource_group_name, name, custom_headers).value!
      nil
    end

    #
    # Resets the configuration settings of the current slot if they were previously
    # modified by calling the API with POST.
    #
    # Resets the configuration settings of the current slot if they were previously
    # modified by calling the API with POST.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def reset_production_slot_config_with_http_info(resource_group_name, name, custom_headers = nil)
      reset_production_slot_config_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Resets the configuration settings of the current slot if they were previously
    # modified by calling the API with POST.
    #
    # Resets the configuration settings of the current slot if they were previously
    # modified by calling the API with POST.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def reset_production_slot_config_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/resetSlotConfig'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Gets the category of ResourceHealthMetadata to use for the given site
    #
    # Gets the category of ResourceHealthMetadata to use for the given site
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ResourceHealthMetadata] operation results.
    #
    def get_resource_health_metadata(resource_group_name, name, custom_headers = nil)
      response = get_resource_health_metadata_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the category of ResourceHealthMetadata to use for the given site
    #
    # Gets the category of ResourceHealthMetadata to use for the given site
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_resource_health_metadata_with_http_info(resource_group_name, name, custom_headers = nil)
      get_resource_health_metadata_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Gets the category of ResourceHealthMetadata to use for the given site
    #
    # Gets the category of ResourceHealthMetadata to use for the given site
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of web app
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_resource_health_metadata_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/resourceHealthMetadata'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::ResourceHealthMetadata.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Restarts an app (or deployment slot, if specified).
    #
    # Restarts an app (or deployment slot, if specified).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param soft_restart [Boolean] Specify true to apply the configuration
    # settings and restarts the app only if necessary. By default, the API always
    # restarts and reprovisions the app.
    # @param synchronous [Boolean] Specify true to block until the app is
    # restarted. By default, it is set to false, and the API responds immediately
    # (asynchronous).
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def restart(resource_group_name, name, soft_restart = nil, synchronous = nil, custom_headers = nil)
      response = restart_async(resource_group_name, name, soft_restart, synchronous, custom_headers).value!
      nil
    end

    #
    # Restarts an app (or deployment slot, if specified).
    #
    # Restarts an app (or deployment slot, if specified).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param soft_restart [Boolean] Specify true to apply the configuration
    # settings and restarts the app only if necessary. By default, the API always
    # restarts and reprovisions the app.
    # @param synchronous [Boolean] Specify true to block until the app is
    # restarted. By default, it is set to false, and the API responds immediately
    # (asynchronous).
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def restart_with_http_info(resource_group_name, name, soft_restart = nil, synchronous = nil, custom_headers = nil)
      restart_async(resource_group_name, name, soft_restart, synchronous, custom_headers).value!
    end

    #
    # Restarts an app (or deployment slot, if specified).
    #
    # Restarts an app (or deployment slot, if specified).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param soft_restart [Boolean] Specify true to apply the configuration
    # settings and restarts the app only if necessary. By default, the API always
    # restarts and reprovisions the app.
    # @param synchronous [Boolean] Specify true to block until the app is
    # restarted. By default, it is set to false, and the API responds immediately
    # (asynchronous).
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def restart_async(resource_group_name, name, soft_restart = nil, synchronous = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/restart'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'softRestart' => soft_restart,'synchronous' => synchronous,'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Gets an app's deployment slots.
    #
    # Gets an app's deployment slots.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<Site>] operation results.
    #
    def list_slots(resource_group_name, name, custom_headers = nil)
      first_page = list_slots_as_lazy(resource_group_name, name, custom_headers)
      first_page.get_all_items
    end

    #
    # Gets an app's deployment slots.
    #
    # Gets an app's deployment slots.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_slots_with_http_info(resource_group_name, name, custom_headers = nil)
      list_slots_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Gets an app's deployment slots.
    #
    # Gets an app's deployment slots.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_slots_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::WebAppCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the details of a web, mobile, or API app.
    #
    # Gets the details of a web, mobile, or API app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. By default, this API
    # returns the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Site] operation results.
    #
    def get_slot(resource_group_name, name, slot, custom_headers = nil)
      response = get_slot_async(resource_group_name, name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the details of a web, mobile, or API app.
    #
    # Gets the details of a web, mobile, or API app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. By default, this API
    # returns the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      get_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # Gets the details of a web, mobile, or API app.
    #
    # Gets the details of a web, mobile, or API app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. By default, this API
    # returns the production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::Site.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Creates a new web, mobile, or API app in an existing resource group, or
    # updates an existing app.
    #
    # Creates a new web, mobile, or API app in an existing resource group, or
    # updates an existing app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Unique name of the app to create or update. To create or
    # update a deployment slot, use the {slot} parameter.
    # @param site_envelope [Site] A JSON representation of the app properties. See
    # example.
    # @param slot [String] Name of the deployment slot to create or update. By
    # default, this API attempts to create or modify the production slot.
    # @param skip_dns_registration [Boolean] If true web app hostname is not
    # registered with DNS on creation. This parameter is
    # only used for app creation
    # @param skip_custom_domain_verification [Boolean] If true, custom (non
    # *.azurewebsites.net) domains associated with web app are not verified.
    # @param force_dns_registration [Boolean] If true, web app hostname is force
    # registered with DNS
    # @param ttl_in_seconds [String] Time to live in seconds for web app's default
    # domain name
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Site] operation results.
    #
    def create_or_update_slot(resource_group_name, name, site_envelope, slot, skip_dns_registration = nil, skip_custom_domain_verification = nil, force_dns_registration = nil, ttl_in_seconds = nil, custom_headers = nil)
      response = create_or_update_slot_async(resource_group_name, name, site_envelope, slot, skip_dns_registration, skip_custom_domain_verification, force_dns_registration, ttl_in_seconds, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Unique name of the app to create or update. To create or
    # update a deployment slot, use the {slot} parameter.
    # @param site_envelope [Site] A JSON representation of the app properties. See
    # example.
    # @param slot [String] Name of the deployment slot to create or update. By
    # default, this API attempts to create or modify the production slot.
    # @param skip_dns_registration [Boolean] If true web app hostname is not
    # registered with DNS on creation. This parameter is
    # only used for app creation
    # @param skip_custom_domain_verification [Boolean] If true, custom (non
    # *.azurewebsites.net) domains associated with web app are not verified.
    # @param force_dns_registration [Boolean] If true, web app hostname is force
    # registered with DNS
    # @param ttl_in_seconds [String] Time to live in seconds for web app's default
    # domain name
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def create_or_update_slot_async(resource_group_name, name, site_envelope, slot, skip_dns_registration = nil, skip_custom_domain_verification = nil, force_dns_registration = nil, ttl_in_seconds = nil, custom_headers = nil)
      # Send request
      promise = begin_create_or_update_slot_async(resource_group_name, name, site_envelope, slot, skip_dns_registration, skip_custom_domain_verification, force_dns_registration, ttl_in_seconds, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Azure::ARM::Web::Models::Site.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response)
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Deletes a web, mobile, or API app, or one of the deployment slots.
    #
    # Deletes a web, mobile, or API app, or one of the deployment slots.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app to delete.
    # @param slot [String] Name of the deployment slot to delete. By default, the
    # API deletes the production slot.
    # @param delete_metrics [Boolean] If true, web app metrics are also deleted
    # @param delete_empty_server_farm [Boolean] Specify true if the App Service
    # plan will be empty after app deletion and you want to delete the empty App
    # Service plan. By default, the empty App Service plan is not deleted.
    # @param skip_dns_registration [Boolean] If true, DNS registration is skipped
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def delete_slot(resource_group_name, name, slot, delete_metrics = nil, delete_empty_server_farm = nil, skip_dns_registration = nil, custom_headers = nil)
      response = delete_slot_async(resource_group_name, name, slot, delete_metrics, delete_empty_server_farm, skip_dns_registration, custom_headers).value!
      nil
    end

    #
    # Deletes a web, mobile, or API app, or one of the deployment slots.
    #
    # Deletes a web, mobile, or API app, or one of the deployment slots.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app to delete.
    # @param slot [String] Name of the deployment slot to delete. By default, the
    # API deletes the production slot.
    # @param delete_metrics [Boolean] If true, web app metrics are also deleted
    # @param delete_empty_server_farm [Boolean] Specify true if the App Service
    # plan will be empty after app deletion and you want to delete the empty App
    # Service plan. By default, the empty App Service plan is not deleted.
    # @param skip_dns_registration [Boolean] If true, DNS registration is skipped
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_slot_with_http_info(resource_group_name, name, slot, delete_metrics = nil, delete_empty_server_farm = nil, skip_dns_registration = nil, custom_headers = nil)
      delete_slot_async(resource_group_name, name, slot, delete_metrics, delete_empty_server_farm, skip_dns_registration, custom_headers).value!
    end

    #
    # Deletes a web, mobile, or API app, or one of the deployment slots.
    #
    # Deletes a web, mobile, or API app, or one of the deployment slots.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app to delete.
    # @param slot [String] Name of the deployment slot to delete. By default, the
    # API deletes the production slot.
    # @param delete_metrics [Boolean] If true, web app metrics are also deleted
    # @param delete_empty_server_farm [Boolean] Specify true if the App Service
    # plan will be empty after app deletion and you want to delete the empty App
    # Service plan. By default, the empty App Service plan is not deleted.
    # @param skip_dns_registration [Boolean] If true, DNS registration is skipped
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_slot_async(resource_group_name, name, slot, delete_metrics = nil, delete_empty_server_farm = nil, skip_dns_registration = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'deleteMetrics' => delete_metrics,'deleteEmptyServerFarm' => delete_empty_server_farm,'skipDnsRegistration' => skip_dns_registration,'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 404
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Analyze a custom hostname.
    #
    # Analyze a custom hostname.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param host_name [String] Custom hostname
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [CustomHostnameAnalysisResult] operation results.
    #
    def analyze_custom_hostname_slot(resource_group_name, name, slot, host_name = nil, custom_headers = nil)
      response = analyze_custom_hostname_slot_async(resource_group_name, name, slot, host_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Analyze a custom hostname.
    #
    # Analyze a custom hostname.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param host_name [String] Custom hostname
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def analyze_custom_hostname_slot_with_http_info(resource_group_name, name, slot, host_name = nil, custom_headers = nil)
      analyze_custom_hostname_slot_async(resource_group_name, name, slot, host_name, custom_headers).value!
    end

    #
    # Analyze a custom hostname.
    #
    # Analyze a custom hostname.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param host_name [String] Custom hostname
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def analyze_custom_hostname_slot_async(resource_group_name, name, slot, host_name = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/analyzeCustomHostname'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'hostName' => host_name,'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::CustomHostnameAnalysisResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Applies the configuration settings from the target slot onto the current
    # slot.
    #
    # Applies the configuration settings from the target slot onto the current
    # slot.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot_swap_entity [CsmSlotEntity] JSON object that contains the target
    # slot name. See example.
    # @param slot [String] Name of the source slot. If a slot is not specified, the
    # production slot is used as the source slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def apply_slot_configuration_slot(resource_group_name, name, slot_swap_entity, slot, custom_headers = nil)
      response = apply_slot_configuration_slot_async(resource_group_name, name, slot_swap_entity, slot, custom_headers).value!
      nil
    end

    #
    # Applies the configuration settings from the target slot onto the current
    # slot.
    #
    # Applies the configuration settings from the target slot onto the current
    # slot.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot_swap_entity [CsmSlotEntity] JSON object that contains the target
    # slot name. See example.
    # @param slot [String] Name of the source slot. If a slot is not specified, the
    # production slot is used as the source slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def apply_slot_configuration_slot_with_http_info(resource_group_name, name, slot_swap_entity, slot, custom_headers = nil)
      apply_slot_configuration_slot_async(resource_group_name, name, slot_swap_entity, slot, custom_headers).value!
    end

    #
    # Applies the configuration settings from the target slot onto the current
    # slot.
    #
    # Applies the configuration settings from the target slot onto the current
    # slot.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot_swap_entity [CsmSlotEntity] JSON object that contains the target
    # slot name. See example.
    # @param slot [String] Name of the source slot. If a slot is not specified, the
    # production slot is used as the source slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def apply_slot_configuration_slot_async(resource_group_name, name, slot_swap_entity, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot_swap_entity is nil' if slot_swap_entity.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::Web::Models::CsmSlotEntity.mapper()
      request_content = @client.serialize(request_mapper,  slot_swap_entity)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/applySlotConfig'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Creates a backup of an app.
    #
    # Creates a backup of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param request [BackupRequest] Backup configuration. You can use the JSON
    # response from the POST action as input here.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will create a backup for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [BackupItem] operation results.
    #
    def backup_slot(resource_group_name, name, request, slot, custom_headers = nil)
      response = backup_slot_async(resource_group_name, name, request, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Creates a backup of an app.
    #
    # Creates a backup of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param request [BackupRequest] Backup configuration. You can use the JSON
    # response from the POST action as input here.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will create a backup for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def backup_slot_with_http_info(resource_group_name, name, request, slot, custom_headers = nil)
      backup_slot_async(resource_group_name, name, request, slot, custom_headers).value!
    end

    #
    # Creates a backup of an app.
    #
    # Creates a backup of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param request [BackupRequest] Backup configuration. You can use the JSON
    # response from the POST action as input here.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will create a backup for the production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def backup_slot_async(resource_group_name, name, request, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'request is nil' if request.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::Web::Models::BackupRequest.mapper()
      request_content = @client.serialize(request_mapper,  request)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/backup'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::BackupItem.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets existing backups of an app.
    #
    # Gets existing backups of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will get backups of the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<BackupItem>] operation results.
    #
    def list_backups_slot(resource_group_name, name, slot, custom_headers = nil)
      first_page = list_backups_slot_as_lazy(resource_group_name, name, slot, custom_headers)
      first_page.get_all_items
    end

    #
    # Gets existing backups of an app.
    #
    # Gets existing backups of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will get backups of the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_backups_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      list_backups_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # Gets existing backups of an app.
    #
    # Gets existing backups of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will get backups of the production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_backups_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/backups'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::BackupItemCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Discovers an existing app backup that can be restored from a blob in Azure
    # storage.
    #
    # Discovers an existing app backup that can be restored from a blob in Azure
    # storage.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param request [RestoreRequest] A RestoreRequest object that includes Azure
    # storage URL and blog name for discovery of backup.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will perform discovery for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [RestoreRequest] operation results.
    #
    def discover_restore_slot(resource_group_name, name, request, slot, custom_headers = nil)
      response = discover_restore_slot_async(resource_group_name, name, request, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Discovers an existing app backup that can be restored from a blob in Azure
    # storage.
    #
    # Discovers an existing app backup that can be restored from a blob in Azure
    # storage.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param request [RestoreRequest] A RestoreRequest object that includes Azure
    # storage URL and blog name for discovery of backup.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will perform discovery for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def discover_restore_slot_with_http_info(resource_group_name, name, request, slot, custom_headers = nil)
      discover_restore_slot_async(resource_group_name, name, request, slot, custom_headers).value!
    end

    #
    # Discovers an existing app backup that can be restored from a blob in Azure
    # storage.
    #
    # Discovers an existing app backup that can be restored from a blob in Azure
    # storage.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param request [RestoreRequest] A RestoreRequest object that includes Azure
    # storage URL and blog name for discovery of backup.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will perform discovery for the production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def discover_restore_slot_async(resource_group_name, name, request, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'request is nil' if request.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::Web::Models::RestoreRequest.mapper()
      request_content = @client.serialize(request_mapper,  request)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/backups/discover'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::RestoreRequest.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets a backup of an app by its ID.
    #
    # Gets a backup of an app by its ID.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param backup_id [String] ID of the backup.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will get a backup of the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [BackupItem] operation results.
    #
    def get_backup_status_slot(resource_group_name, name, backup_id, slot, custom_headers = nil)
      response = get_backup_status_slot_async(resource_group_name, name, backup_id, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets a backup of an app by its ID.
    #
    # Gets a backup of an app by its ID.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param backup_id [String] ID of the backup.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will get a backup of the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_backup_status_slot_with_http_info(resource_group_name, name, backup_id, slot, custom_headers = nil)
      get_backup_status_slot_async(resource_group_name, name, backup_id, slot, custom_headers).value!
    end

    #
    # Gets a backup of an app by its ID.
    #
    # Gets a backup of an app by its ID.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param backup_id [String] ID of the backup.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will get a backup of the production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_backup_status_slot_async(resource_group_name, name, backup_id, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'backup_id is nil' if backup_id.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/backups/{backupId}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'backupId' => backup_id,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::BackupItem.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Deletes a backup of an app by its ID.
    #
    # Deletes a backup of an app by its ID.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param backup_id [String] ID of the backup.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will delete a backup of the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def delete_backup_slot(resource_group_name, name, backup_id, slot, custom_headers = nil)
      response = delete_backup_slot_async(resource_group_name, name, backup_id, slot, custom_headers).value!
      nil
    end

    #
    # Deletes a backup of an app by its ID.
    #
    # Deletes a backup of an app by its ID.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param backup_id [String] ID of the backup.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will delete a backup of the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_backup_slot_with_http_info(resource_group_name, name, backup_id, slot, custom_headers = nil)
      delete_backup_slot_async(resource_group_name, name, backup_id, slot, custom_headers).value!
    end

    #
    # Deletes a backup of an app by its ID.
    #
    # Deletes a backup of an app by its ID.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param backup_id [String] ID of the backup.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will delete a backup of the production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_backup_slot_async(resource_group_name, name, backup_id, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'backup_id is nil' if backup_id.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/backups/{backupId}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'backupId' => backup_id,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 404
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Gets status of a web app backup that may be in progress, including secrets
    # associated with the backup, such as the Azure Storage SAS URL. Also can be
    # used to update the SAS URL for the backup if a new URL is passed in the
    # request body.
    #
    # Gets status of a web app backup that may be in progress, including secrets
    # associated with the backup, such as the Azure Storage SAS URL. Also can be
    # used to update the SAS URL for the backup if a new URL is passed in the
    # request body.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of web app
    # @param backup_id [String] Id of backup
    # @param request [BackupRequest] Information on backup request
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [BackupItem] operation results.
    #
    def list_backup_status_secrets_slot(resource_group_name, name, backup_id, request, slot, custom_headers = nil)
      response = list_backup_status_secrets_slot_async(resource_group_name, name, backup_id, request, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets status of a web app backup that may be in progress, including secrets
    # associated with the backup, such as the Azure Storage SAS URL. Also can be
    # used to update the SAS URL for the backup if a new URL is passed in the
    # request body.
    #
    # Gets status of a web app backup that may be in progress, including secrets
    # associated with the backup, such as the Azure Storage SAS URL. Also can be
    # used to update the SAS URL for the backup if a new URL is passed in the
    # request body.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of web app
    # @param backup_id [String] Id of backup
    # @param request [BackupRequest] Information on backup request
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_backup_status_secrets_slot_with_http_info(resource_group_name, name, backup_id, request, slot, custom_headers = nil)
      list_backup_status_secrets_slot_async(resource_group_name, name, backup_id, request, slot, custom_headers).value!
    end

    #
    # Gets status of a web app backup that may be in progress, including secrets
    # associated with the backup, such as the Azure Storage SAS URL. Also can be
    # used to update the SAS URL for the backup if a new URL is passed in the
    # request body.
    #
    # Gets status of a web app backup that may be in progress, including secrets
    # associated with the backup, such as the Azure Storage SAS URL. Also can be
    # used to update the SAS URL for the backup if a new URL is passed in the
    # request body.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of web app
    # @param backup_id [String] Id of backup
    # @param request [BackupRequest] Information on backup request
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_backup_status_secrets_slot_async(resource_group_name, name, backup_id, request, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'backup_id is nil' if backup_id.nil?
      fail ArgumentError, 'request is nil' if request.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::Web::Models::BackupRequest.mapper()
      request_content = @client.serialize(request_mapper,  request)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/backups/{backupId}/list'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'backupId' => backup_id,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::BackupItem.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Restores a specific backup to another app (or deployment slot, if specified).
    #
    # Restores a specific backup to another app (or deployment slot, if specified).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param backup_id [String] ID of the backup.
    # @param request [RestoreRequest] Information on restore request
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will restore a backup of the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [RestoreResponse] operation results.
    #
    def restore_slot(resource_group_name, name, backup_id, request, slot, custom_headers = nil)
      response = restore_slot_async(resource_group_name, name, backup_id, request, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param backup_id [String] ID of the backup.
    # @param request [RestoreRequest] Information on restore request
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will restore a backup of the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def restore_slot_async(resource_group_name, name, backup_id, request, slot, custom_headers = nil)
      # Send request
      promise = begin_restore_slot_async(resource_group_name, name, backup_id, request, slot, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Azure::ARM::Web::Models::RestoreResponse.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response)
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # List the configurations of an app
    #
    # List the configurations of an app
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will return configuration for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<SiteConfigResource>] operation results.
    #
    def list_configurations_slot(resource_group_name, name, slot, custom_headers = nil)
      first_page = list_configurations_slot_as_lazy(resource_group_name, name, slot, custom_headers)
      first_page.get_all_items
    end

    #
    # List the configurations of an app
    #
    # List the configurations of an app
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will return configuration for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_configurations_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      list_configurations_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # List the configurations of an app
    #
    # List the configurations of an app
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will return configuration for the production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_configurations_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::SiteConfigResourceCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Replaces the application settings of an app.
    #
    # Replaces the application settings of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param app_settings [StringDictionary] Application settings of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will update the application settings for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [StringDictionary] operation results.
    #
    def update_application_settings_slot(resource_group_name, name, app_settings, slot, custom_headers = nil)
      response = update_application_settings_slot_async(resource_group_name, name, app_settings, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Replaces the application settings of an app.
    #
    # Replaces the application settings of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param app_settings [StringDictionary] Application settings of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will update the application settings for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_application_settings_slot_with_http_info(resource_group_name, name, app_settings, slot, custom_headers = nil)
      update_application_settings_slot_async(resource_group_name, name, app_settings, slot, custom_headers).value!
    end

    #
    # Replaces the application settings of an app.
    #
    # Replaces the application settings of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param app_settings [StringDictionary] Application settings of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will update the application settings for the production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_application_settings_slot_async(resource_group_name, name, app_settings, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'app_settings is nil' if app_settings.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::Web::Models::StringDictionary.mapper()
      request_content = @client.serialize(request_mapper,  app_settings)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/appsettings'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::StringDictionary.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the application settings of an app.
    #
    # Gets the application settings of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will get the application settings for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [StringDictionary] operation results.
    #
    def list_application_settings_slot(resource_group_name, name, slot, custom_headers = nil)
      response = list_application_settings_slot_async(resource_group_name, name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the application settings of an app.
    #
    # Gets the application settings of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will get the application settings for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_application_settings_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      list_application_settings_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # Gets the application settings of an app.
    #
    # Gets the application settings of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will get the application settings for the production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_application_settings_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/appsettings/list'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::StringDictionary.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Updates the Authentication / Authorization settings associated with web app.
    #
    # Updates the Authentication / Authorization settings associated with web app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of web app
    # @param site_auth_settings [SiteAuthSettings] Auth settings associated with
    # web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteAuthSettings] operation results.
    #
    def update_auth_settings_slot(resource_group_name, name, site_auth_settings, slot, custom_headers = nil)
      response = update_auth_settings_slot_async(resource_group_name, name, site_auth_settings, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Updates the Authentication / Authorization settings associated with web app.
    #
    # Updates the Authentication / Authorization settings associated with web app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of web app
    # @param site_auth_settings [SiteAuthSettings] Auth settings associated with
    # web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_auth_settings_slot_with_http_info(resource_group_name, name, site_auth_settings, slot, custom_headers = nil)
      update_auth_settings_slot_async(resource_group_name, name, site_auth_settings, slot, custom_headers).value!
    end

    #
    # Updates the Authentication / Authorization settings associated with web app.
    #
    # Updates the Authentication / Authorization settings associated with web app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of web app
    # @param site_auth_settings [SiteAuthSettings] Auth settings associated with
    # web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_auth_settings_slot_async(resource_group_name, name, site_auth_settings, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'site_auth_settings is nil' if site_auth_settings.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::Web::Models::SiteAuthSettings.mapper()
      request_content = @client.serialize(request_mapper,  site_auth_settings)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/authsettings'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::SiteAuthSettings.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the Authentication/Authorization settings of an app.
    #
    # Gets the Authentication/Authorization settings of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will get the settings for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteAuthSettings] operation results.
    #
    def get_auth_settings_slot(resource_group_name, name, slot, custom_headers = nil)
      response = get_auth_settings_slot_async(resource_group_name, name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the Authentication/Authorization settings of an app.
    #
    # Gets the Authentication/Authorization settings of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will get the settings for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_auth_settings_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      get_auth_settings_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # Gets the Authentication/Authorization settings of an app.
    #
    # Gets the Authentication/Authorization settings of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will get the settings for the production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_auth_settings_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/authsettings/list'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::SiteAuthSettings.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Updates the backup configuration of an app.
    #
    # Updates the backup configuration of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param request [BackupRequest] Edited backup configuration.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will update the backup configuration for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [BackupRequest] operation results.
    #
    def update_backup_configuration_slot(resource_group_name, name, request, slot, custom_headers = nil)
      response = update_backup_configuration_slot_async(resource_group_name, name, request, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Updates the backup configuration of an app.
    #
    # Updates the backup configuration of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param request [BackupRequest] Edited backup configuration.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will update the backup configuration for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_backup_configuration_slot_with_http_info(resource_group_name, name, request, slot, custom_headers = nil)
      update_backup_configuration_slot_async(resource_group_name, name, request, slot, custom_headers).value!
    end

    #
    # Updates the backup configuration of an app.
    #
    # Updates the backup configuration of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param request [BackupRequest] Edited backup configuration.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will update the backup configuration for the production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_backup_configuration_slot_async(resource_group_name, name, request, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'request is nil' if request.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::Web::Models::BackupRequest.mapper()
      request_content = @client.serialize(request_mapper,  request)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/backup'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::BackupRequest.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Deletes the backup configuration of an app.
    #
    # Deletes the backup configuration of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will delete the backup configuration for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def delete_backup_configuration_slot(resource_group_name, name, slot, custom_headers = nil)
      response = delete_backup_configuration_slot_async(resource_group_name, name, slot, custom_headers).value!
      nil
    end

    #
    # Deletes the backup configuration of an app.
    #
    # Deletes the backup configuration of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will delete the backup configuration for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_backup_configuration_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      delete_backup_configuration_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # Deletes the backup configuration of an app.
    #
    # Deletes the backup configuration of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will delete the backup configuration for the production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_backup_configuration_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/backup'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Gets the backup configuration of an app.
    #
    # Gets the backup configuration of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will get the backup configuration for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [BackupRequest] operation results.
    #
    def get_backup_configuration_slot(resource_group_name, name, slot, custom_headers = nil)
      response = get_backup_configuration_slot_async(resource_group_name, name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the backup configuration of an app.
    #
    # Gets the backup configuration of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will get the backup configuration for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_backup_configuration_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      get_backup_configuration_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # Gets the backup configuration of an app.
    #
    # Gets the backup configuration of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will get the backup configuration for the production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_backup_configuration_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/backup/list'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::BackupRequest.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Replaces the connection strings of an app.
    #
    # Replaces the connection strings of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param connection_strings [ConnectionStringDictionary] Connection strings of
    # the app or deployment slot. See example.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will update the connection settings for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ConnectionStringDictionary] operation results.
    #
    def update_connection_strings_slot(resource_group_name, name, connection_strings, slot, custom_headers = nil)
      response = update_connection_strings_slot_async(resource_group_name, name, connection_strings, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Replaces the connection strings of an app.
    #
    # Replaces the connection strings of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param connection_strings [ConnectionStringDictionary] Connection strings of
    # the app or deployment slot. See example.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will update the connection settings for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_connection_strings_slot_with_http_info(resource_group_name, name, connection_strings, slot, custom_headers = nil)
      update_connection_strings_slot_async(resource_group_name, name, connection_strings, slot, custom_headers).value!
    end

    #
    # Replaces the connection strings of an app.
    #
    # Replaces the connection strings of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param connection_strings [ConnectionStringDictionary] Connection strings of
    # the app or deployment slot. See example.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will update the connection settings for the production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_connection_strings_slot_async(resource_group_name, name, connection_strings, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'connection_strings is nil' if connection_strings.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::Web::Models::ConnectionStringDictionary.mapper()
      request_content = @client.serialize(request_mapper,  connection_strings)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/connectionstrings'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::ConnectionStringDictionary.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the connection strings of an app.
    #
    # Gets the connection strings of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will get the connection settings for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ConnectionStringDictionary] operation results.
    #
    def list_connection_strings_slot(resource_group_name, name, slot, custom_headers = nil)
      response = list_connection_strings_slot_async(resource_group_name, name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the connection strings of an app.
    #
    # Gets the connection strings of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will get the connection settings for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_connection_strings_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      list_connection_strings_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # Gets the connection strings of an app.
    #
    # Gets the connection strings of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will get the connection settings for the production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_connection_strings_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/connectionstrings/list'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::ConnectionStringDictionary.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the logging configuration of an app.
    #
    # Gets the logging configuration of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will get the logging configuration for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteLogsConfig] operation results.
    #
    def get_diagnostic_logs_configuration_slot(resource_group_name, name, slot, custom_headers = nil)
      response = get_diagnostic_logs_configuration_slot_async(resource_group_name, name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the logging configuration of an app.
    #
    # Gets the logging configuration of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will get the logging configuration for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_diagnostic_logs_configuration_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      get_diagnostic_logs_configuration_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # Gets the logging configuration of an app.
    #
    # Gets the logging configuration of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will get the logging configuration for the production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_diagnostic_logs_configuration_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/logs'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::SiteLogsConfig.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Updates the logging configuration of an app.
    #
    # Updates the logging configuration of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param site_logs_config [SiteLogsConfig] A SiteLogsConfig JSON object that
    # contains the logging configuration to change in the "properties" property.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will update the logging configuration for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteLogsConfig] operation results.
    #
    def update_diagnostic_logs_config_slot(resource_group_name, name, site_logs_config, slot, custom_headers = nil)
      response = update_diagnostic_logs_config_slot_async(resource_group_name, name, site_logs_config, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Updates the logging configuration of an app.
    #
    # Updates the logging configuration of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param site_logs_config [SiteLogsConfig] A SiteLogsConfig JSON object that
    # contains the logging configuration to change in the "properties" property.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will update the logging configuration for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_diagnostic_logs_config_slot_with_http_info(resource_group_name, name, site_logs_config, slot, custom_headers = nil)
      update_diagnostic_logs_config_slot_async(resource_group_name, name, site_logs_config, slot, custom_headers).value!
    end

    #
    # Updates the logging configuration of an app.
    #
    # Updates the logging configuration of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param site_logs_config [SiteLogsConfig] A SiteLogsConfig JSON object that
    # contains the logging configuration to change in the "properties" property.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will update the logging configuration for the production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_diagnostic_logs_config_slot_async(resource_group_name, name, site_logs_config, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'site_logs_config is nil' if site_logs_config.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::Web::Models::SiteLogsConfig.mapper()
      request_content = @client.serialize(request_mapper,  site_logs_config)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/logs'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::SiteLogsConfig.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Replaces the metadata of an app.
    #
    # Replaces the metadata of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param metadata [StringDictionary] Edited metadata of the app or deployment
    # slot. See example.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will update the metadata for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [StringDictionary] operation results.
    #
    def update_metadata_slot(resource_group_name, name, metadata, slot, custom_headers = nil)
      response = update_metadata_slot_async(resource_group_name, name, metadata, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Replaces the metadata of an app.
    #
    # Replaces the metadata of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param metadata [StringDictionary] Edited metadata of the app or deployment
    # slot. See example.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will update the metadata for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_metadata_slot_with_http_info(resource_group_name, name, metadata, slot, custom_headers = nil)
      update_metadata_slot_async(resource_group_name, name, metadata, slot, custom_headers).value!
    end

    #
    # Replaces the metadata of an app.
    #
    # Replaces the metadata of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param metadata [StringDictionary] Edited metadata of the app or deployment
    # slot. See example.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will update the metadata for the production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_metadata_slot_async(resource_group_name, name, metadata, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'metadata is nil' if metadata.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::Web::Models::StringDictionary.mapper()
      request_content = @client.serialize(request_mapper,  metadata)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/metadata'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::StringDictionary.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the metadata of an app.
    #
    # Gets the metadata of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will get the metadata for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [StringDictionary] operation results.
    #
    def list_metadata_slot(resource_group_name, name, slot, custom_headers = nil)
      response = list_metadata_slot_async(resource_group_name, name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the metadata of an app.
    #
    # Gets the metadata of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will get the metadata for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_metadata_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      list_metadata_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # Gets the metadata of an app.
    #
    # Gets the metadata of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will get the metadata for the production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_metadata_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/metadata/list'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::StringDictionary.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the Git/FTP publishing credentials of an app.
    #
    # Gets the Git/FTP publishing credentials of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will get the publishing credentials for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [User] operation results.
    #
    def list_publishing_credentials_slot(resource_group_name, name, slot, custom_headers = nil)
      response = list_publishing_credentials_slot_async(resource_group_name, name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will get the publishing credentials for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def list_publishing_credentials_slot_async(resource_group_name, name, slot, custom_headers = nil)
      # Send request
      promise = begin_list_publishing_credentials_slot_async(resource_group_name, name, slot, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Azure::ARM::Web::Models::User.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response)
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Updates the Push settings associated with web app.
    #
    # Updates the Push settings associated with web app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of web app
    # @param push_settings [PushSettings] Push settings associated with web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [PushSettings] operation results.
    #
    def update_site_push_settings_slot(resource_group_name, name, push_settings, slot, custom_headers = nil)
      response = update_site_push_settings_slot_async(resource_group_name, name, push_settings, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Updates the Push settings associated with web app.
    #
    # Updates the Push settings associated with web app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of web app
    # @param push_settings [PushSettings] Push settings associated with web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_site_push_settings_slot_with_http_info(resource_group_name, name, push_settings, slot, custom_headers = nil)
      update_site_push_settings_slot_async(resource_group_name, name, push_settings, slot, custom_headers).value!
    end

    #
    # Updates the Push settings associated with web app.
    #
    # Updates the Push settings associated with web app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of web app
    # @param push_settings [PushSettings] Push settings associated with web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_site_push_settings_slot_async(resource_group_name, name, push_settings, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'push_settings is nil' if push_settings.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::Web::Models::PushSettings.mapper()
      request_content = @client.serialize(request_mapper,  push_settings)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/pushsettings'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::PushSettings.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the Push settings associated with web app.
    #
    # Gets the Push settings associated with web app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [PushSettings] operation results.
    #
    def list_site_push_settings_slot(resource_group_name, name, slot, custom_headers = nil)
      response = list_site_push_settings_slot_async(resource_group_name, name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the Push settings associated with web app.
    #
    # Gets the Push settings associated with web app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_site_push_settings_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      list_site_push_settings_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # Gets the Push settings associated with web app.
    #
    # Gets the Push settings associated with web app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_site_push_settings_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/pushsettings/list'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::PushSettings.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the configuration of an app, such as platform version and bitness,
    # default documents, virtual applications, Always On, etc.
    #
    # Gets the configuration of an app, such as platform version and bitness,
    # default documents, virtual applications, Always On, etc.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will return configuration for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteConfigResource] operation results.
    #
    def get_configuration_slot(resource_group_name, name, slot, custom_headers = nil)
      response = get_configuration_slot_async(resource_group_name, name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the configuration of an app, such as platform version and bitness,
    # default documents, virtual applications, Always On, etc.
    #
    # Gets the configuration of an app, such as platform version and bitness,
    # default documents, virtual applications, Always On, etc.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will return configuration for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_configuration_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      get_configuration_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # Gets the configuration of an app, such as platform version and bitness,
    # default documents, virtual applications, Always On, etc.
    #
    # Gets the configuration of an app, such as platform version and bitness,
    # default documents, virtual applications, Always On, etc.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will return configuration for the production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_configuration_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/web'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::SiteConfigResource.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Updates the configuration of an app.
    #
    # Updates the configuration of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param site_config [SiteConfigResource] JSON representation of a SiteConfig
    # object. See example.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will update configuration for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteConfigResource] operation results.
    #
    def create_or_update_configuration_slot(resource_group_name, name, site_config, slot, custom_headers = nil)
      response = create_or_update_configuration_slot_async(resource_group_name, name, site_config, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Updates the configuration of an app.
    #
    # Updates the configuration of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param site_config [SiteConfigResource] JSON representation of a SiteConfig
    # object. See example.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will update configuration for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def create_or_update_configuration_slot_with_http_info(resource_group_name, name, site_config, slot, custom_headers = nil)
      create_or_update_configuration_slot_async(resource_group_name, name, site_config, slot, custom_headers).value!
    end

    #
    # Updates the configuration of an app.
    #
    # Updates the configuration of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param site_config [SiteConfigResource] JSON representation of a SiteConfig
    # object. See example.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will update configuration for the production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def create_or_update_configuration_slot_async(resource_group_name, name, site_config, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'site_config is nil' if site_config.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::Web::Models::SiteConfigResource.mapper()
      request_content = @client.serialize(request_mapper,  site_config)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/web'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::SiteConfigResource.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Updates the configuration of an app.
    #
    # Updates the configuration of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param site_config [SiteConfigResource] JSON representation of a SiteConfig
    # object. See example.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will update configuration for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteConfigResource] operation results.
    #
    def update_configuration_slot(resource_group_name, name, site_config, slot, custom_headers = nil)
      response = update_configuration_slot_async(resource_group_name, name, site_config, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Updates the configuration of an app.
    #
    # Updates the configuration of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param site_config [SiteConfigResource] JSON representation of a SiteConfig
    # object. See example.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will update configuration for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_configuration_slot_with_http_info(resource_group_name, name, site_config, slot, custom_headers = nil)
      update_configuration_slot_async(resource_group_name, name, site_config, slot, custom_headers).value!
    end

    #
    # Updates the configuration of an app.
    #
    # Updates the configuration of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param site_config [SiteConfigResource] JSON representation of a SiteConfig
    # object. See example.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will update configuration for the production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_configuration_slot_async(resource_group_name, name, site_config, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'site_config is nil' if site_config.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::Web::Models::SiteConfigResource.mapper()
      request_content = @client.serialize(request_mapper,  site_config)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/web'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:patch, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::SiteConfigResource.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets a list of web app configuration snapshots identifiers. Each element of
    # the list contains a timestamp and the ID of the snapshot.
    #
    # Gets a list of web app configuration snapshots identifiers. Each element of
    # the list contains a timestamp and the ID of the snapshot.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will return configuration for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array] operation results.
    #
    def list_configuration_snapshot_info_slot(resource_group_name, name, slot, custom_headers = nil)
      response = list_configuration_snapshot_info_slot_async(resource_group_name, name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets a list of web app configuration snapshots identifiers. Each element of
    # the list contains a timestamp and the ID of the snapshot.
    #
    # Gets a list of web app configuration snapshots identifiers. Each element of
    # the list contains a timestamp and the ID of the snapshot.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will return configuration for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_configuration_snapshot_info_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      list_configuration_snapshot_info_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # Gets a list of web app configuration snapshots identifiers. Each element of
    # the list contains a timestamp and the ID of the snapshot.
    #
    # Gets a list of web app configuration snapshots identifiers. Each element of
    # the list contains a timestamp and the ID of the snapshot.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will return configuration for the production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_configuration_snapshot_info_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/web/snapshots'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = {
              required: false,
              serialized_name: 'parsed_response',
              type: {
                name: 'Sequence',
                element: {
                    required: false,
                    serialized_name: 'SiteConfigurationSnapshotInfoElementType',
                    type: {
                      name: 'Composite',
                      class_name: 'SiteConfigurationSnapshotInfo'
                    }
                }
              }
            }
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets a snapshot of the configuration of an app at a previous point in time.
    #
    # Gets a snapshot of the configuration of an app at a previous point in time.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param snapshot_id [String] The ID of the snapshot to read.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will return configuration for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteConfigResource] operation results.
    #
    def get_configuration_snapshot_slot(resource_group_name, name, snapshot_id, slot, custom_headers = nil)
      response = get_configuration_snapshot_slot_async(resource_group_name, name, snapshot_id, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets a snapshot of the configuration of an app at a previous point in time.
    #
    # Gets a snapshot of the configuration of an app at a previous point in time.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param snapshot_id [String] The ID of the snapshot to read.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will return configuration for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_configuration_snapshot_slot_with_http_info(resource_group_name, name, snapshot_id, slot, custom_headers = nil)
      get_configuration_snapshot_slot_async(resource_group_name, name, snapshot_id, slot, custom_headers).value!
    end

    #
    # Gets a snapshot of the configuration of an app at a previous point in time.
    #
    # Gets a snapshot of the configuration of an app at a previous point in time.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param snapshot_id [String] The ID of the snapshot to read.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will return configuration for the production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_configuration_snapshot_slot_async(resource_group_name, name, snapshot_id, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'snapshot_id is nil' if snapshot_id.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/web/snapshots/{snapshotId}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'snapshotId' => snapshot_id,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::SiteConfigResource.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Reverts the configuration of an app to a previous snapshot.
    #
    # Reverts the configuration of an app to a previous snapshot.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param snapshot_id [String] The ID of the snapshot to read.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will return configuration for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def recover_site_configuration_snapshot_slot(resource_group_name, name, snapshot_id, slot, custom_headers = nil)
      response = recover_site_configuration_snapshot_slot_async(resource_group_name, name, snapshot_id, slot, custom_headers).value!
      nil
    end

    #
    # Reverts the configuration of an app to a previous snapshot.
    #
    # Reverts the configuration of an app to a previous snapshot.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param snapshot_id [String] The ID of the snapshot to read.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will return configuration for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def recover_site_configuration_snapshot_slot_with_http_info(resource_group_name, name, snapshot_id, slot, custom_headers = nil)
      recover_site_configuration_snapshot_slot_async(resource_group_name, name, snapshot_id, slot, custom_headers).value!
    end

    #
    # Reverts the configuration of an app to a previous snapshot.
    #
    # Reverts the configuration of an app to a previous snapshot.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param snapshot_id [String] The ID of the snapshot to read.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will return configuration for the production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def recover_site_configuration_snapshot_slot_async(resource_group_name, name, snapshot_id, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'snapshot_id is nil' if snapshot_id.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/web/snapshots/{snapshotId}/recover'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'snapshotId' => snapshot_id,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 204
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # List deployments for an app, or a deployment slot, or for an instance of a
    # scaled-out app.
    #
    # List deployments for an app, or a deployment slot, or for an instance of a
    # scaled-out app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API returns deployments for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<Deployment>] operation results.
    #
    def list_deployments_slot(resource_group_name, name, slot, custom_headers = nil)
      first_page = list_deployments_slot_as_lazy(resource_group_name, name, slot, custom_headers)
      first_page.get_all_items
    end

    #
    # List deployments for an app, or a deployment slot, or for an instance of a
    # scaled-out app.
    #
    # List deployments for an app, or a deployment slot, or for an instance of a
    # scaled-out app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API returns deployments for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_deployments_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      list_deployments_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # List deployments for an app, or a deployment slot, or for an instance of a
    # scaled-out app.
    #
    # List deployments for an app, or a deployment slot, or for an instance of a
    # scaled-out app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API returns deployments for the production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_deployments_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/deployments'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::DeploymentCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get a deployment by its ID for an app, a specific deployment slot, and/or a
    # specific scaled-out instance.
    #
    # Get a deployment by its ID for an app, a specific deployment slot, and/or a
    # specific scaled-out instance.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param id [String] Deployment ID.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API gets a deployment for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Deployment] operation results.
    #
    def get_deployment_slot(resource_group_name, name, id, slot, custom_headers = nil)
      response = get_deployment_slot_async(resource_group_name, name, id, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get a deployment by its ID for an app, a specific deployment slot, and/or a
    # specific scaled-out instance.
    #
    # Get a deployment by its ID for an app, a specific deployment slot, and/or a
    # specific scaled-out instance.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param id [String] Deployment ID.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API gets a deployment for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_deployment_slot_with_http_info(resource_group_name, name, id, slot, custom_headers = nil)
      get_deployment_slot_async(resource_group_name, name, id, slot, custom_headers).value!
    end

    #
    # Get a deployment by its ID for an app, a specific deployment slot, and/or a
    # specific scaled-out instance.
    #
    # Get a deployment by its ID for an app, a specific deployment slot, and/or a
    # specific scaled-out instance.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param id [String] Deployment ID.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API gets a deployment for the production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_deployment_slot_async(resource_group_name, name, id, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'id is nil' if id.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/deployments/{id}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'id' => id,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::Deployment.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Create a deployment for an app, a specific deployment slot, and/or a specific
    # scaled-out instance.
    #
    # Create a deployment for an app, a specific deployment slot, and/or a specific
    # scaled-out instance.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param id [String] ID of an existing deployment.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API creates a deployment for the production slot.
    # @param deployment [Deployment] Deployment details.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Deployment] operation results.
    #
    def create_deployment_slot(resource_group_name, name, id, slot, deployment, custom_headers = nil)
      response = create_deployment_slot_async(resource_group_name, name, id, slot, deployment, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Create a deployment for an app, a specific deployment slot, and/or a specific
    # scaled-out instance.
    #
    # Create a deployment for an app, a specific deployment slot, and/or a specific
    # scaled-out instance.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param id [String] ID of an existing deployment.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API creates a deployment for the production slot.
    # @param deployment [Deployment] Deployment details.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def create_deployment_slot_with_http_info(resource_group_name, name, id, slot, deployment, custom_headers = nil)
      create_deployment_slot_async(resource_group_name, name, id, slot, deployment, custom_headers).value!
    end

    #
    # Create a deployment for an app, a specific deployment slot, and/or a specific
    # scaled-out instance.
    #
    # Create a deployment for an app, a specific deployment slot, and/or a specific
    # scaled-out instance.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param id [String] ID of an existing deployment.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API creates a deployment for the production slot.
    # @param deployment [Deployment] Deployment details.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def create_deployment_slot_async(resource_group_name, name, id, slot, deployment, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'id is nil' if id.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, 'deployment is nil' if deployment.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::Web::Models::Deployment.mapper()
      request_content = @client.serialize(request_mapper,  deployment)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/deployments/{id}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'id' => id,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::Deployment.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Delete a deployment by its ID for an app, a specific deployment slot, and/or
    # a specific scaled-out instance.
    #
    # Delete a deployment by its ID for an app, a specific deployment slot, and/or
    # a specific scaled-out instance.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param id [String] Deployment ID.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API deletes a deployment for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def delete_deployment_slot(resource_group_name, name, id, slot, custom_headers = nil)
      response = delete_deployment_slot_async(resource_group_name, name, id, slot, custom_headers).value!
      nil
    end

    #
    # Delete a deployment by its ID for an app, a specific deployment slot, and/or
    # a specific scaled-out instance.
    #
    # Delete a deployment by its ID for an app, a specific deployment slot, and/or
    # a specific scaled-out instance.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param id [String] Deployment ID.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API deletes a deployment for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_deployment_slot_with_http_info(resource_group_name, name, id, slot, custom_headers = nil)
      delete_deployment_slot_async(resource_group_name, name, id, slot, custom_headers).value!
    end

    #
    # Delete a deployment by its ID for an app, a specific deployment slot, and/or
    # a specific scaled-out instance.
    #
    # Delete a deployment by its ID for an app, a specific deployment slot, and/or
    # a specific scaled-out instance.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param id [String] Deployment ID.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API deletes a deployment for the production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_deployment_slot_async(resource_group_name, name, id, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'id is nil' if id.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/deployments/{id}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'id' => id,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 204
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Lists ownership identifiers for domain associated with web app.
    #
    # Lists ownership identifiers for domain associated with web app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will delete the binding for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<Identifier>] operation results.
    #
    def list_domain_ownership_identifiers_slot(resource_group_name, name, slot, custom_headers = nil)
      first_page = list_domain_ownership_identifiers_slot_as_lazy(resource_group_name, name, slot, custom_headers)
      first_page.get_all_items
    end

    #
    # Lists ownership identifiers for domain associated with web app.
    #
    # Lists ownership identifiers for domain associated with web app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will delete the binding for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_domain_ownership_identifiers_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      list_domain_ownership_identifiers_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # Lists ownership identifiers for domain associated with web app.
    #
    # Lists ownership identifiers for domain associated with web app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will delete the binding for the production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_domain_ownership_identifiers_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/domainOwnershipIdentifiers'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::IdentifierCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get domain ownership identifier for web app.
    #
    # Get domain ownership identifier for web app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param domain_ownership_identifier_name [String] Name of domain ownership
    # identifier.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will delete the binding for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Identifier] operation results.
    #
    def get_domain_ownership_identifier_slot(resource_group_name, name, domain_ownership_identifier_name, slot, custom_headers = nil)
      response = get_domain_ownership_identifier_slot_async(resource_group_name, name, domain_ownership_identifier_name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get domain ownership identifier for web app.
    #
    # Get domain ownership identifier for web app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param domain_ownership_identifier_name [String] Name of domain ownership
    # identifier.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will delete the binding for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_domain_ownership_identifier_slot_with_http_info(resource_group_name, name, domain_ownership_identifier_name, slot, custom_headers = nil)
      get_domain_ownership_identifier_slot_async(resource_group_name, name, domain_ownership_identifier_name, slot, custom_headers).value!
    end

    #
    # Get domain ownership identifier for web app.
    #
    # Get domain ownership identifier for web app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param domain_ownership_identifier_name [String] Name of domain ownership
    # identifier.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will delete the binding for the production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_domain_ownership_identifier_slot_async(resource_group_name, name, domain_ownership_identifier_name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'domain_ownership_identifier_name is nil' if domain_ownership_identifier_name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/domainOwnershipIdentifiers/{domainOwnershipIdentifierName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'domainOwnershipIdentifierName' => domain_ownership_identifier_name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::Identifier.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Creates a domain ownership identifier for web app, or updates an existing
    # ownership identifier.
    #
    # Creates a domain ownership identifier for web app, or updates an existing
    # ownership identifier.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param domain_ownership_identifier_name [String] Name of domain ownership
    # identifier.
    # @param domain_ownership_identifier [Identifier] A JSON representation of the
    # domain ownership properties.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will delete the binding for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Identifier] operation results.
    #
    def create_or_update_domain_ownership_identifier_slot(resource_group_name, name, domain_ownership_identifier_name, domain_ownership_identifier, slot, custom_headers = nil)
      response = create_or_update_domain_ownership_identifier_slot_async(resource_group_name, name, domain_ownership_identifier_name, domain_ownership_identifier, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Creates a domain ownership identifier for web app, or updates an existing
    # ownership identifier.
    #
    # Creates a domain ownership identifier for web app, or updates an existing
    # ownership identifier.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param domain_ownership_identifier_name [String] Name of domain ownership
    # identifier.
    # @param domain_ownership_identifier [Identifier] A JSON representation of the
    # domain ownership properties.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will delete the binding for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def create_or_update_domain_ownership_identifier_slot_with_http_info(resource_group_name, name, domain_ownership_identifier_name, domain_ownership_identifier, slot, custom_headers = nil)
      create_or_update_domain_ownership_identifier_slot_async(resource_group_name, name, domain_ownership_identifier_name, domain_ownership_identifier, slot, custom_headers).value!
    end

    #
    # Creates a domain ownership identifier for web app, or updates an existing
    # ownership identifier.
    #
    # Creates a domain ownership identifier for web app, or updates an existing
    # ownership identifier.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param domain_ownership_identifier_name [String] Name of domain ownership
    # identifier.
    # @param domain_ownership_identifier [Identifier] A JSON representation of the
    # domain ownership properties.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will delete the binding for the production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def create_or_update_domain_ownership_identifier_slot_async(resource_group_name, name, domain_ownership_identifier_name, domain_ownership_identifier, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'domain_ownership_identifier_name is nil' if domain_ownership_identifier_name.nil?
      fail ArgumentError, 'domain_ownership_identifier is nil' if domain_ownership_identifier.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::Web::Models::Identifier.mapper()
      request_content = @client.serialize(request_mapper,  domain_ownership_identifier)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/domainOwnershipIdentifiers/{domainOwnershipIdentifierName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'domainOwnershipIdentifierName' => domain_ownership_identifier_name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::Identifier.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Deletes a domain ownership identifier for a web app.
    #
    # Deletes a domain ownership identifier for a web app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param domain_ownership_identifier_name [String] Name of domain ownership
    # identifier.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will delete the binding for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def delete_domain_ownership_identifier_slot(resource_group_name, name, domain_ownership_identifier_name, slot, custom_headers = nil)
      response = delete_domain_ownership_identifier_slot_async(resource_group_name, name, domain_ownership_identifier_name, slot, custom_headers).value!
      nil
    end

    #
    # Deletes a domain ownership identifier for a web app.
    #
    # Deletes a domain ownership identifier for a web app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param domain_ownership_identifier_name [String] Name of domain ownership
    # identifier.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will delete the binding for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_domain_ownership_identifier_slot_with_http_info(resource_group_name, name, domain_ownership_identifier_name, slot, custom_headers = nil)
      delete_domain_ownership_identifier_slot_async(resource_group_name, name, domain_ownership_identifier_name, slot, custom_headers).value!
    end

    #
    # Deletes a domain ownership identifier for a web app.
    #
    # Deletes a domain ownership identifier for a web app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param domain_ownership_identifier_name [String] Name of domain ownership
    # identifier.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will delete the binding for the production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_domain_ownership_identifier_slot_async(resource_group_name, name, domain_ownership_identifier_name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'domain_ownership_identifier_name is nil' if domain_ownership_identifier_name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/domainOwnershipIdentifiers/{domainOwnershipIdentifierName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'domainOwnershipIdentifierName' => domain_ownership_identifier_name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 204
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Creates a domain ownership identifier for web app, or updates an existing
    # ownership identifier.
    #
    # Creates a domain ownership identifier for web app, or updates an existing
    # ownership identifier.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param domain_ownership_identifier_name [String] Name of domain ownership
    # identifier.
    # @param domain_ownership_identifier [Identifier] A JSON representation of the
    # domain ownership properties.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will delete the binding for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Identifier] operation results.
    #
    def update_domain_ownership_identifier_slot(resource_group_name, name, domain_ownership_identifier_name, domain_ownership_identifier, slot, custom_headers = nil)
      response = update_domain_ownership_identifier_slot_async(resource_group_name, name, domain_ownership_identifier_name, domain_ownership_identifier, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Creates a domain ownership identifier for web app, or updates an existing
    # ownership identifier.
    #
    # Creates a domain ownership identifier for web app, or updates an existing
    # ownership identifier.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param domain_ownership_identifier_name [String] Name of domain ownership
    # identifier.
    # @param domain_ownership_identifier [Identifier] A JSON representation of the
    # domain ownership properties.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will delete the binding for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_domain_ownership_identifier_slot_with_http_info(resource_group_name, name, domain_ownership_identifier_name, domain_ownership_identifier, slot, custom_headers = nil)
      update_domain_ownership_identifier_slot_async(resource_group_name, name, domain_ownership_identifier_name, domain_ownership_identifier, slot, custom_headers).value!
    end

    #
    # Creates a domain ownership identifier for web app, or updates an existing
    # ownership identifier.
    #
    # Creates a domain ownership identifier for web app, or updates an existing
    # ownership identifier.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param domain_ownership_identifier_name [String] Name of domain ownership
    # identifier.
    # @param domain_ownership_identifier [Identifier] A JSON representation of the
    # domain ownership properties.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will delete the binding for the production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_domain_ownership_identifier_slot_async(resource_group_name, name, domain_ownership_identifier_name, domain_ownership_identifier, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'domain_ownership_identifier_name is nil' if domain_ownership_identifier_name.nil?
      fail ArgumentError, 'domain_ownership_identifier is nil' if domain_ownership_identifier.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::Web::Models::Identifier.mapper()
      request_content = @client.serialize(request_mapper,  domain_ownership_identifier)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/domainOwnershipIdentifiers/{domainOwnershipIdentifierName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'domainOwnershipIdentifierName' => domain_ownership_identifier_name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:patch, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::Identifier.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get hostname bindings for an app or a deployment slot.
    #
    # Get hostname bindings for an app or a deployment slot.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API gets hostname bindings for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<HostNameBinding>] operation results.
    #
    def list_host_name_bindings_slot(resource_group_name, name, slot, custom_headers = nil)
      first_page = list_host_name_bindings_slot_as_lazy(resource_group_name, name, slot, custom_headers)
      first_page.get_all_items
    end

    #
    # Get hostname bindings for an app or a deployment slot.
    #
    # Get hostname bindings for an app or a deployment slot.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API gets hostname bindings for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_host_name_bindings_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      list_host_name_bindings_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # Get hostname bindings for an app or a deployment slot.
    #
    # Get hostname bindings for an app or a deployment slot.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API gets hostname bindings for the production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_host_name_bindings_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hostNameBindings'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::HostNameBindingCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get the named hostname binding for an app (or deployment slot, if specified).
    #
    # Get the named hostname binding for an app (or deployment slot, if specified).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API the named binding for the production slot.
    # @param host_name [String] Hostname in the hostname binding.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [HostNameBinding] operation results.
    #
    def get_host_name_binding_slot(resource_group_name, name, slot, host_name, custom_headers = nil)
      response = get_host_name_binding_slot_async(resource_group_name, name, slot, host_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get the named hostname binding for an app (or deployment slot, if specified).
    #
    # Get the named hostname binding for an app (or deployment slot, if specified).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API the named binding for the production slot.
    # @param host_name [String] Hostname in the hostname binding.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_host_name_binding_slot_with_http_info(resource_group_name, name, slot, host_name, custom_headers = nil)
      get_host_name_binding_slot_async(resource_group_name, name, slot, host_name, custom_headers).value!
    end

    #
    # Get the named hostname binding for an app (or deployment slot, if specified).
    #
    # Get the named hostname binding for an app (or deployment slot, if specified).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API the named binding for the production slot.
    # @param host_name [String] Hostname in the hostname binding.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_host_name_binding_slot_async(resource_group_name, name, slot, host_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, 'host_name is nil' if host_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hostNameBindings/{hostName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'hostName' => host_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::HostNameBinding.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Creates a hostname binding for an app.
    #
    # Creates a hostname binding for an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param host_name [String] Hostname in the hostname binding.
    # @param host_name_binding [HostNameBinding] Binding details. This is the JSON
    # representation of a HostNameBinding object.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will create a binding for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [HostNameBinding] operation results.
    #
    def create_or_update_host_name_binding_slot(resource_group_name, name, host_name, host_name_binding, slot, custom_headers = nil)
      response = create_or_update_host_name_binding_slot_async(resource_group_name, name, host_name, host_name_binding, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Creates a hostname binding for an app.
    #
    # Creates a hostname binding for an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param host_name [String] Hostname in the hostname binding.
    # @param host_name_binding [HostNameBinding] Binding details. This is the JSON
    # representation of a HostNameBinding object.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will create a binding for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def create_or_update_host_name_binding_slot_with_http_info(resource_group_name, name, host_name, host_name_binding, slot, custom_headers = nil)
      create_or_update_host_name_binding_slot_async(resource_group_name, name, host_name, host_name_binding, slot, custom_headers).value!
    end

    #
    # Creates a hostname binding for an app.
    #
    # Creates a hostname binding for an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param host_name [String] Hostname in the hostname binding.
    # @param host_name_binding [HostNameBinding] Binding details. This is the JSON
    # representation of a HostNameBinding object.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will create a binding for the production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def create_or_update_host_name_binding_slot_async(resource_group_name, name, host_name, host_name_binding, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'host_name is nil' if host_name.nil?
      fail ArgumentError, 'host_name_binding is nil' if host_name_binding.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::Web::Models::HostNameBinding.mapper()
      request_content = @client.serialize(request_mapper,  host_name_binding)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hostNameBindings/{hostName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'hostName' => host_name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::HostNameBinding.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Deletes a hostname binding for an app.
    #
    # Deletes a hostname binding for an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will delete the binding for the production slot.
    # @param host_name [String] Hostname in the hostname binding.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def delete_host_name_binding_slot(resource_group_name, name, slot, host_name, custom_headers = nil)
      response = delete_host_name_binding_slot_async(resource_group_name, name, slot, host_name, custom_headers).value!
      nil
    end

    #
    # Deletes a hostname binding for an app.
    #
    # Deletes a hostname binding for an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will delete the binding for the production slot.
    # @param host_name [String] Hostname in the hostname binding.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_host_name_binding_slot_with_http_info(resource_group_name, name, slot, host_name, custom_headers = nil)
      delete_host_name_binding_slot_async(resource_group_name, name, slot, host_name, custom_headers).value!
    end

    #
    # Deletes a hostname binding for an app.
    #
    # Deletes a hostname binding for an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will delete the binding for the production slot.
    # @param host_name [String] Hostname in the hostname binding.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_host_name_binding_slot_async(resource_group_name, name, slot, host_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, 'host_name is nil' if host_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hostNameBindings/{hostName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'hostName' => host_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 204
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Retrieves a specific Service Bus Hybrid Connection used by this Web App.
    #
    # Retrieves a specific Service Bus Hybrid Connection used by this Web App.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] The name of the web app
    # @param namespace_name [String] The namespace for this hybrid connection
    # @param relay_name [String] The relay name for this hybrid connection
    # @param slot [String] The name of the slot for the web app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [HybridConnection] operation results.
    #
    def get_hybrid_connection_slot(resource_group_name, name, namespace_name, relay_name, slot, custom_headers = nil)
      response = get_hybrid_connection_slot_async(resource_group_name, name, namespace_name, relay_name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Retrieves a specific Service Bus Hybrid Connection used by this Web App.
    #
    # Retrieves a specific Service Bus Hybrid Connection used by this Web App.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] The name of the web app
    # @param namespace_name [String] The namespace for this hybrid connection
    # @param relay_name [String] The relay name for this hybrid connection
    # @param slot [String] The name of the slot for the web app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_hybrid_connection_slot_with_http_info(resource_group_name, name, namespace_name, relay_name, slot, custom_headers = nil)
      get_hybrid_connection_slot_async(resource_group_name, name, namespace_name, relay_name, slot, custom_headers).value!
    end

    #
    # Retrieves a specific Service Bus Hybrid Connection used by this Web App.
    #
    # Retrieves a specific Service Bus Hybrid Connection used by this Web App.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] The name of the web app
    # @param namespace_name [String] The namespace for this hybrid connection
    # @param relay_name [String] The relay name for this hybrid connection
    # @param slot [String] The name of the slot for the web app.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_hybrid_connection_slot_async(resource_group_name, name, namespace_name, relay_name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'namespace_name is nil' if namespace_name.nil?
      fail ArgumentError, 'relay_name is nil' if relay_name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'namespaceName' => namespace_name,'relayName' => relay_name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::HybridConnection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Creates a new Hybrid Connection using a Service Bus relay.
    #
    # Creates a new Hybrid Connection using a Service Bus relay.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] The name of the web app
    # @param namespace_name [String] The namespace for this hybrid connection
    # @param relay_name [String] The relay name for this hybrid connection
    # @param connection_envelope [HybridConnection] The details of the hybrid
    # connection
    # @param slot [String] The name of the slot for the web app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [HybridConnection] operation results.
    #
    def create_or_update_hybrid_connection_slot(resource_group_name, name, namespace_name, relay_name, connection_envelope, slot, custom_headers = nil)
      response = create_or_update_hybrid_connection_slot_async(resource_group_name, name, namespace_name, relay_name, connection_envelope, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Creates a new Hybrid Connection using a Service Bus relay.
    #
    # Creates a new Hybrid Connection using a Service Bus relay.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] The name of the web app
    # @param namespace_name [String] The namespace for this hybrid connection
    # @param relay_name [String] The relay name for this hybrid connection
    # @param connection_envelope [HybridConnection] The details of the hybrid
    # connection
    # @param slot [String] The name of the slot for the web app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def create_or_update_hybrid_connection_slot_with_http_info(resource_group_name, name, namespace_name, relay_name, connection_envelope, slot, custom_headers = nil)
      create_or_update_hybrid_connection_slot_async(resource_group_name, name, namespace_name, relay_name, connection_envelope, slot, custom_headers).value!
    end

    #
    # Creates a new Hybrid Connection using a Service Bus relay.
    #
    # Creates a new Hybrid Connection using a Service Bus relay.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] The name of the web app
    # @param namespace_name [String] The namespace for this hybrid connection
    # @param relay_name [String] The relay name for this hybrid connection
    # @param connection_envelope [HybridConnection] The details of the hybrid
    # connection
    # @param slot [String] The name of the slot for the web app.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def create_or_update_hybrid_connection_slot_async(resource_group_name, name, namespace_name, relay_name, connection_envelope, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'namespace_name is nil' if namespace_name.nil?
      fail ArgumentError, 'relay_name is nil' if relay_name.nil?
      fail ArgumentError, 'connection_envelope is nil' if connection_envelope.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::Web::Models::HybridConnection.mapper()
      request_content = @client.serialize(request_mapper,  connection_envelope)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'namespaceName' => namespace_name,'relayName' => relay_name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::HybridConnection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Removes a Hybrid Connection from this site.
    #
    # Removes a Hybrid Connection from this site.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] The name of the web app
    # @param namespace_name [String] The namespace for this hybrid connection
    # @param relay_name [String] The relay name for this hybrid connection
    # @param slot [String] The name of the slot for the web app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def delete_hybrid_connection_slot(resource_group_name, name, namespace_name, relay_name, slot, custom_headers = nil)
      response = delete_hybrid_connection_slot_async(resource_group_name, name, namespace_name, relay_name, slot, custom_headers).value!
      nil
    end

    #
    # Removes a Hybrid Connection from this site.
    #
    # Removes a Hybrid Connection from this site.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] The name of the web app
    # @param namespace_name [String] The namespace for this hybrid connection
    # @param relay_name [String] The relay name for this hybrid connection
    # @param slot [String] The name of the slot for the web app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_hybrid_connection_slot_with_http_info(resource_group_name, name, namespace_name, relay_name, slot, custom_headers = nil)
      delete_hybrid_connection_slot_async(resource_group_name, name, namespace_name, relay_name, slot, custom_headers).value!
    end

    #
    # Removes a Hybrid Connection from this site.
    #
    # Removes a Hybrid Connection from this site.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] The name of the web app
    # @param namespace_name [String] The namespace for this hybrid connection
    # @param relay_name [String] The relay name for this hybrid connection
    # @param slot [String] The name of the slot for the web app.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_hybrid_connection_slot_async(resource_group_name, name, namespace_name, relay_name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'namespace_name is nil' if namespace_name.nil?
      fail ArgumentError, 'relay_name is nil' if relay_name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'namespaceName' => namespace_name,'relayName' => relay_name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 404
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Creates a new Hybrid Connection using a Service Bus relay.
    #
    # Creates a new Hybrid Connection using a Service Bus relay.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] The name of the web app
    # @param namespace_name [String] The namespace for this hybrid connection
    # @param relay_name [String] The relay name for this hybrid connection
    # @param connection_envelope [HybridConnection] The details of the hybrid
    # connection
    # @param slot [String] The name of the slot for the web app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [HybridConnection] operation results.
    #
    def update_hybrid_connection_slot(resource_group_name, name, namespace_name, relay_name, connection_envelope, slot, custom_headers = nil)
      response = update_hybrid_connection_slot_async(resource_group_name, name, namespace_name, relay_name, connection_envelope, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Creates a new Hybrid Connection using a Service Bus relay.
    #
    # Creates a new Hybrid Connection using a Service Bus relay.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] The name of the web app
    # @param namespace_name [String] The namespace for this hybrid connection
    # @param relay_name [String] The relay name for this hybrid connection
    # @param connection_envelope [HybridConnection] The details of the hybrid
    # connection
    # @param slot [String] The name of the slot for the web app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_hybrid_connection_slot_with_http_info(resource_group_name, name, namespace_name, relay_name, connection_envelope, slot, custom_headers = nil)
      update_hybrid_connection_slot_async(resource_group_name, name, namespace_name, relay_name, connection_envelope, slot, custom_headers).value!
    end

    #
    # Creates a new Hybrid Connection using a Service Bus relay.
    #
    # Creates a new Hybrid Connection using a Service Bus relay.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] The name of the web app
    # @param namespace_name [String] The namespace for this hybrid connection
    # @param relay_name [String] The relay name for this hybrid connection
    # @param connection_envelope [HybridConnection] The details of the hybrid
    # connection
    # @param slot [String] The name of the slot for the web app.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_hybrid_connection_slot_async(resource_group_name, name, namespace_name, relay_name, connection_envelope, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'namespace_name is nil' if namespace_name.nil?
      fail ArgumentError, 'relay_name is nil' if relay_name.nil?
      fail ArgumentError, 'connection_envelope is nil' if connection_envelope.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::Web::Models::HybridConnection.mapper()
      request_content = @client.serialize(request_mapper,  connection_envelope)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'namespaceName' => namespace_name,'relayName' => relay_name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:patch, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::HybridConnection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the send key name and value for a Hybrid Connection.
    #
    # Gets the send key name and value for a Hybrid Connection.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] The name of the web app
    # @param namespace_name [String] The namespace for this hybrid connection
    # @param relay_name [String] The relay name for this hybrid connection
    # @param slot [String] The name of the slot for the web app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [HybridConnectionKey] operation results.
    #
    def list_hybrid_connection_keys_slot(resource_group_name, name, namespace_name, relay_name, slot, custom_headers = nil)
      response = list_hybrid_connection_keys_slot_async(resource_group_name, name, namespace_name, relay_name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the send key name and value for a Hybrid Connection.
    #
    # Gets the send key name and value for a Hybrid Connection.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] The name of the web app
    # @param namespace_name [String] The namespace for this hybrid connection
    # @param relay_name [String] The relay name for this hybrid connection
    # @param slot [String] The name of the slot for the web app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_hybrid_connection_keys_slot_with_http_info(resource_group_name, name, namespace_name, relay_name, slot, custom_headers = nil)
      list_hybrid_connection_keys_slot_async(resource_group_name, name, namespace_name, relay_name, slot, custom_headers).value!
    end

    #
    # Gets the send key name and value for a Hybrid Connection.
    #
    # Gets the send key name and value for a Hybrid Connection.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] The name of the web app
    # @param namespace_name [String] The namespace for this hybrid connection
    # @param relay_name [String] The relay name for this hybrid connection
    # @param slot [String] The name of the slot for the web app.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_hybrid_connection_keys_slot_async(resource_group_name, name, namespace_name, relay_name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'namespace_name is nil' if namespace_name.nil?
      fail ArgumentError, 'relay_name is nil' if relay_name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}/listKeys'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'namespaceName' => namespace_name,'relayName' => relay_name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::HybridConnectionKey.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Retrieves all Service Bus Hybrid Connections used by this Web App.
    #
    # Retrieves all Service Bus Hybrid Connections used by this Web App.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] The name of the web app
    # @param slot [String] The name of the slot for the web app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [HybridConnection] operation results.
    #
    def list_hybrid_connections_slot(resource_group_name, name, slot, custom_headers = nil)
      response = list_hybrid_connections_slot_async(resource_group_name, name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Retrieves all Service Bus Hybrid Connections used by this Web App.
    #
    # Retrieves all Service Bus Hybrid Connections used by this Web App.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] The name of the web app
    # @param slot [String] The name of the slot for the web app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_hybrid_connections_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      list_hybrid_connections_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # Retrieves all Service Bus Hybrid Connections used by this Web App.
    #
    # Retrieves all Service Bus Hybrid Connections used by this Web App.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] The name of the web app
    # @param slot [String] The name of the slot for the web app.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_hybrid_connections_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridConnectionRelays'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::HybridConnection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets hybrid connections configured for an app (or deployment slot, if
    # specified).
    #
    # Gets hybrid connections configured for an app (or deployment slot, if
    # specified).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will get hybrid connections for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [RelayServiceConnectionEntity] operation results.
    #
    def list_relay_service_connections_slot(resource_group_name, name, slot, custom_headers = nil)
      response = list_relay_service_connections_slot_async(resource_group_name, name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets hybrid connections configured for an app (or deployment slot, if
    # specified).
    #
    # Gets hybrid connections configured for an app (or deployment slot, if
    # specified).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will get hybrid connections for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_relay_service_connections_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      list_relay_service_connections_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # Gets hybrid connections configured for an app (or deployment slot, if
    # specified).
    #
    # Gets hybrid connections configured for an app (or deployment slot, if
    # specified).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will get hybrid connections for the production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_relay_service_connections_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridconnection'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::RelayServiceConnectionEntity.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets a hybrid connection configuration by its name.
    #
    # Gets a hybrid connection configuration by its name.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param entity_name [String] Name of the hybrid connection.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will get a hybrid connection for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [RelayServiceConnectionEntity] operation results.
    #
    def get_relay_service_connection_slot(resource_group_name, name, entity_name, slot, custom_headers = nil)
      response = get_relay_service_connection_slot_async(resource_group_name, name, entity_name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets a hybrid connection configuration by its name.
    #
    # Gets a hybrid connection configuration by its name.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param entity_name [String] Name of the hybrid connection.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will get a hybrid connection for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_relay_service_connection_slot_with_http_info(resource_group_name, name, entity_name, slot, custom_headers = nil)
      get_relay_service_connection_slot_async(resource_group_name, name, entity_name, slot, custom_headers).value!
    end

    #
    # Gets a hybrid connection configuration by its name.
    #
    # Gets a hybrid connection configuration by its name.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param entity_name [String] Name of the hybrid connection.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will get a hybrid connection for the production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_relay_service_connection_slot_async(resource_group_name, name, entity_name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'entity_name is nil' if entity_name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridconnection/{entityName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'entityName' => entity_name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::RelayServiceConnectionEntity.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Creates a new hybrid connection configuration (PUT), or updates an existing
    # one (PATCH).
    #
    # Creates a new hybrid connection configuration (PUT), or updates an existing
    # one (PATCH).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param entity_name [String] Name of the hybrid connection configuration.
    # @param connection_envelope [RelayServiceConnectionEntity] Details of the
    # hybrid connection configuration.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will create or update a hybrid connection for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [RelayServiceConnectionEntity] operation results.
    #
    def create_or_update_relay_service_connection_slot(resource_group_name, name, entity_name, connection_envelope, slot, custom_headers = nil)
      response = create_or_update_relay_service_connection_slot_async(resource_group_name, name, entity_name, connection_envelope, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Creates a new hybrid connection configuration (PUT), or updates an existing
    # one (PATCH).
    #
    # Creates a new hybrid connection configuration (PUT), or updates an existing
    # one (PATCH).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param entity_name [String] Name of the hybrid connection configuration.
    # @param connection_envelope [RelayServiceConnectionEntity] Details of the
    # hybrid connection configuration.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will create or update a hybrid connection for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def create_or_update_relay_service_connection_slot_with_http_info(resource_group_name, name, entity_name, connection_envelope, slot, custom_headers = nil)
      create_or_update_relay_service_connection_slot_async(resource_group_name, name, entity_name, connection_envelope, slot, custom_headers).value!
    end

    #
    # Creates a new hybrid connection configuration (PUT), or updates an existing
    # one (PATCH).
    #
    # Creates a new hybrid connection configuration (PUT), or updates an existing
    # one (PATCH).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param entity_name [String] Name of the hybrid connection configuration.
    # @param connection_envelope [RelayServiceConnectionEntity] Details of the
    # hybrid connection configuration.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will create or update a hybrid connection for the production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def create_or_update_relay_service_connection_slot_async(resource_group_name, name, entity_name, connection_envelope, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'entity_name is nil' if entity_name.nil?
      fail ArgumentError, 'connection_envelope is nil' if connection_envelope.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::Web::Models::RelayServiceConnectionEntity.mapper()
      request_content = @client.serialize(request_mapper,  connection_envelope)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridconnection/{entityName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'entityName' => entity_name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::RelayServiceConnectionEntity.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Deletes a relay service connection by its name.
    #
    # Deletes a relay service connection by its name.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param entity_name [String] Name of the hybrid connection configuration.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will delete a hybrid connection for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def delete_relay_service_connection_slot(resource_group_name, name, entity_name, slot, custom_headers = nil)
      response = delete_relay_service_connection_slot_async(resource_group_name, name, entity_name, slot, custom_headers).value!
      nil
    end

    #
    # Deletes a relay service connection by its name.
    #
    # Deletes a relay service connection by its name.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param entity_name [String] Name of the hybrid connection configuration.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will delete a hybrid connection for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_relay_service_connection_slot_with_http_info(resource_group_name, name, entity_name, slot, custom_headers = nil)
      delete_relay_service_connection_slot_async(resource_group_name, name, entity_name, slot, custom_headers).value!
    end

    #
    # Deletes a relay service connection by its name.
    #
    # Deletes a relay service connection by its name.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param entity_name [String] Name of the hybrid connection configuration.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will delete a hybrid connection for the production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_relay_service_connection_slot_async(resource_group_name, name, entity_name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'entity_name is nil' if entity_name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridconnection/{entityName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'entityName' => entity_name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 404
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Creates a new hybrid connection configuration (PUT), or updates an existing
    # one (PATCH).
    #
    # Creates a new hybrid connection configuration (PUT), or updates an existing
    # one (PATCH).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param entity_name [String] Name of the hybrid connection configuration.
    # @param connection_envelope [RelayServiceConnectionEntity] Details of the
    # hybrid connection configuration.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will create or update a hybrid connection for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [RelayServiceConnectionEntity] operation results.
    #
    def update_relay_service_connection_slot(resource_group_name, name, entity_name, connection_envelope, slot, custom_headers = nil)
      response = update_relay_service_connection_slot_async(resource_group_name, name, entity_name, connection_envelope, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Creates a new hybrid connection configuration (PUT), or updates an existing
    # one (PATCH).
    #
    # Creates a new hybrid connection configuration (PUT), or updates an existing
    # one (PATCH).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param entity_name [String] Name of the hybrid connection configuration.
    # @param connection_envelope [RelayServiceConnectionEntity] Details of the
    # hybrid connection configuration.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will create or update a hybrid connection for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_relay_service_connection_slot_with_http_info(resource_group_name, name, entity_name, connection_envelope, slot, custom_headers = nil)
      update_relay_service_connection_slot_async(resource_group_name, name, entity_name, connection_envelope, slot, custom_headers).value!
    end

    #
    # Creates a new hybrid connection configuration (PUT), or updates an existing
    # one (PATCH).
    #
    # Creates a new hybrid connection configuration (PUT), or updates an existing
    # one (PATCH).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param entity_name [String] Name of the hybrid connection configuration.
    # @param connection_envelope [RelayServiceConnectionEntity] Details of the
    # hybrid connection configuration.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will create or update a hybrid connection for the production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_relay_service_connection_slot_async(resource_group_name, name, entity_name, connection_envelope, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'entity_name is nil' if entity_name.nil?
      fail ArgumentError, 'connection_envelope is nil' if connection_envelope.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::Web::Models::RelayServiceConnectionEntity.mapper()
      request_content = @client.serialize(request_mapper,  connection_envelope)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridconnection/{entityName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'entityName' => entity_name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:patch, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::RelayServiceConnectionEntity.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets all scale-out instances of an app.
    #
    # Gets all scale-out instances of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API gets the production slot instances.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<SiteInstance>] operation results.
    #
    def list_instance_identifiers_slot(resource_group_name, name, slot, custom_headers = nil)
      first_page = list_instance_identifiers_slot_as_lazy(resource_group_name, name, slot, custom_headers)
      first_page.get_all_items
    end

    #
    # Gets all scale-out instances of an app.
    #
    # Gets all scale-out instances of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API gets the production slot instances.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_instance_identifiers_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      list_instance_identifiers_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # Gets all scale-out instances of an app.
    #
    # Gets all scale-out instances of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API gets the production slot instances.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_instance_identifiers_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::WebAppInstanceCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # List deployments for an app, or a deployment slot, or for an instance of a
    # scaled-out app.
    #
    # List deployments for an app, or a deployment slot, or for an instance of a
    # scaled-out app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API returns deployments for the production slot.
    # @param instance_id [String] The ID of a specific scaled-out instance. This is
    # the value of the name property in the JSON response from "GET
    # api/sites/{siteName}/instances"
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<Deployment>] operation results.
    #
    def list_instance_deployments_slot(resource_group_name, name, slot, instance_id, custom_headers = nil)
      first_page = list_instance_deployments_slot_as_lazy(resource_group_name, name, slot, instance_id, custom_headers)
      first_page.get_all_items
    end

    #
    # List deployments for an app, or a deployment slot, or for an instance of a
    # scaled-out app.
    #
    # List deployments for an app, or a deployment slot, or for an instance of a
    # scaled-out app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API returns deployments for the production slot.
    # @param instance_id [String] The ID of a specific scaled-out instance. This is
    # the value of the name property in the JSON response from "GET
    # api/sites/{siteName}/instances"
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_instance_deployments_slot_with_http_info(resource_group_name, name, slot, instance_id, custom_headers = nil)
      list_instance_deployments_slot_async(resource_group_name, name, slot, instance_id, custom_headers).value!
    end

    #
    # List deployments for an app, or a deployment slot, or for an instance of a
    # scaled-out app.
    #
    # List deployments for an app, or a deployment slot, or for an instance of a
    # scaled-out app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API returns deployments for the production slot.
    # @param instance_id [String] The ID of a specific scaled-out instance. This is
    # the value of the name property in the JSON response from "GET
    # api/sites/{siteName}/instances"
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_instance_deployments_slot_async(resource_group_name, name, slot, instance_id, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, 'instance_id is nil' if instance_id.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/deployments'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'instanceId' => instance_id,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::DeploymentCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get a deployment by its ID for an app, a specific deployment slot, and/or a
    # specific scaled-out instance.
    #
    # Get a deployment by its ID for an app, a specific deployment slot, and/or a
    # specific scaled-out instance.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param id [String] Deployment ID.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API gets a deployment for the production slot.
    # @param instance_id [String] ID of a specific scaled-out instance. This is the
    # value of the name property in the JSON response from "GET
    # api/sites/{siteName}/instances"
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Deployment] operation results.
    #
    def get_instance_deployment_slot(resource_group_name, name, id, slot, instance_id, custom_headers = nil)
      response = get_instance_deployment_slot_async(resource_group_name, name, id, slot, instance_id, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get a deployment by its ID for an app, a specific deployment slot, and/or a
    # specific scaled-out instance.
    #
    # Get a deployment by its ID for an app, a specific deployment slot, and/or a
    # specific scaled-out instance.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param id [String] Deployment ID.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API gets a deployment for the production slot.
    # @param instance_id [String] ID of a specific scaled-out instance. This is the
    # value of the name property in the JSON response from "GET
    # api/sites/{siteName}/instances"
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_instance_deployment_slot_with_http_info(resource_group_name, name, id, slot, instance_id, custom_headers = nil)
      get_instance_deployment_slot_async(resource_group_name, name, id, slot, instance_id, custom_headers).value!
    end

    #
    # Get a deployment by its ID for an app, a specific deployment slot, and/or a
    # specific scaled-out instance.
    #
    # Get a deployment by its ID for an app, a specific deployment slot, and/or a
    # specific scaled-out instance.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param id [String] Deployment ID.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API gets a deployment for the production slot.
    # @param instance_id [String] ID of a specific scaled-out instance. This is the
    # value of the name property in the JSON response from "GET
    # api/sites/{siteName}/instances"
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_instance_deployment_slot_async(resource_group_name, name, id, slot, instance_id, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'id is nil' if id.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, 'instance_id is nil' if instance_id.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/deployments/{id}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'id' => id,'slot' => slot,'instanceId' => instance_id,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::Deployment.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Create a deployment for an app, a specific deployment slot, and/or a specific
    # scaled-out instance.
    #
    # Create a deployment for an app, a specific deployment slot, and/or a specific
    # scaled-out instance.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param id [String] ID of an existing deployment.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API creates a deployment for the production slot.
    # @param instance_id [String] ID of a specific scaled-out instance. This is the
    # value of the name property in the JSON response from "GET
    # api/sites/{siteName}/instances"
    # @param deployment [Deployment] Deployment details.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Deployment] operation results.
    #
    def create_instance_deployment_slot(resource_group_name, name, id, slot, instance_id, deployment, custom_headers = nil)
      response = create_instance_deployment_slot_async(resource_group_name, name, id, slot, instance_id, deployment, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Create a deployment for an app, a specific deployment slot, and/or a specific
    # scaled-out instance.
    #
    # Create a deployment for an app, a specific deployment slot, and/or a specific
    # scaled-out instance.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param id [String] ID of an existing deployment.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API creates a deployment for the production slot.
    # @param instance_id [String] ID of a specific scaled-out instance. This is the
    # value of the name property in the JSON response from "GET
    # api/sites/{siteName}/instances"
    # @param deployment [Deployment] Deployment details.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def create_instance_deployment_slot_with_http_info(resource_group_name, name, id, slot, instance_id, deployment, custom_headers = nil)
      create_instance_deployment_slot_async(resource_group_name, name, id, slot, instance_id, deployment, custom_headers).value!
    end

    #
    # Create a deployment for an app, a specific deployment slot, and/or a specific
    # scaled-out instance.
    #
    # Create a deployment for an app, a specific deployment slot, and/or a specific
    # scaled-out instance.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param id [String] ID of an existing deployment.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API creates a deployment for the production slot.
    # @param instance_id [String] ID of a specific scaled-out instance. This is the
    # value of the name property in the JSON response from "GET
    # api/sites/{siteName}/instances"
    # @param deployment [Deployment] Deployment details.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def create_instance_deployment_slot_async(resource_group_name, name, id, slot, instance_id, deployment, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'id is nil' if id.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, 'instance_id is nil' if instance_id.nil?
      fail ArgumentError, 'deployment is nil' if deployment.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::Web::Models::Deployment.mapper()
      request_content = @client.serialize(request_mapper,  deployment)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/deployments/{id}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'id' => id,'slot' => slot,'instanceId' => instance_id,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::Deployment.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Delete a deployment by its ID for an app, a specific deployment slot, and/or
    # a specific scaled-out instance.
    #
    # Delete a deployment by its ID for an app, a specific deployment slot, and/or
    # a specific scaled-out instance.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param id [String] Deployment ID.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API deletes a deployment for the production slot.
    # @param instance_id [String] ID of a specific scaled-out instance. This is the
    # value of the name property in the JSON response from "GET
    # api/sites/{siteName}/instances"
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def delete_instance_deployment_slot(resource_group_name, name, id, slot, instance_id, custom_headers = nil)
      response = delete_instance_deployment_slot_async(resource_group_name, name, id, slot, instance_id, custom_headers).value!
      nil
    end

    #
    # Delete a deployment by its ID for an app, a specific deployment slot, and/or
    # a specific scaled-out instance.
    #
    # Delete a deployment by its ID for an app, a specific deployment slot, and/or
    # a specific scaled-out instance.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param id [String] Deployment ID.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API deletes a deployment for the production slot.
    # @param instance_id [String] ID of a specific scaled-out instance. This is the
    # value of the name property in the JSON response from "GET
    # api/sites/{siteName}/instances"
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_instance_deployment_slot_with_http_info(resource_group_name, name, id, slot, instance_id, custom_headers = nil)
      delete_instance_deployment_slot_async(resource_group_name, name, id, slot, instance_id, custom_headers).value!
    end

    #
    # Delete a deployment by its ID for an app, a specific deployment slot, and/or
    # a specific scaled-out instance.
    #
    # Delete a deployment by its ID for an app, a specific deployment slot, and/or
    # a specific scaled-out instance.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param id [String] Deployment ID.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API deletes a deployment for the production slot.
    # @param instance_id [String] ID of a specific scaled-out instance. This is the
    # value of the name property in the JSON response from "GET
    # api/sites/{siteName}/instances"
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_instance_deployment_slot_async(resource_group_name, name, id, slot, instance_id, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'id is nil' if id.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, 'instance_id is nil' if instance_id.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/deployments/{id}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'id' => id,'slot' => slot,'instanceId' => instance_id,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 204
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Shows whether an app can be cloned to another resource group or subscription.
    #
    # Shows whether an app can be cloned to another resource group or subscription.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. By default, this API
    # returns information on the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteCloneability] operation results.
    #
    def is_cloneable_slot(resource_group_name, name, slot, custom_headers = nil)
      response = is_cloneable_slot_async(resource_group_name, name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Shows whether an app can be cloned to another resource group or subscription.
    #
    # Shows whether an app can be cloned to another resource group or subscription.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. By default, this API
    # returns information on the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def is_cloneable_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      is_cloneable_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # Shows whether an app can be cloned to another resource group or subscription.
    #
    # Shows whether an app can be cloned to another resource group or subscription.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. By default, this API
    # returns information on the production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def is_cloneable_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/iscloneable'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::SiteCloneability.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets all metric definitions of an app (or deployment slot, if specified).
    #
    # Gets all metric definitions of an app (or deployment slot, if specified).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will get metric definitions of the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<ResourceMetricDefinition>] operation results.
    #
    def list_metric_definitions_slot(resource_group_name, name, slot, custom_headers = nil)
      first_page = list_metric_definitions_slot_as_lazy(resource_group_name, name, slot, custom_headers)
      first_page.get_all_items
    end

    #
    # Gets all metric definitions of an app (or deployment slot, if specified).
    #
    # Gets all metric definitions of an app (or deployment slot, if specified).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will get metric definitions of the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_metric_definitions_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      list_metric_definitions_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # Gets all metric definitions of an app (or deployment slot, if specified).
    #
    # Gets all metric definitions of an app (or deployment slot, if specified).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will get metric definitions of the production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_metric_definitions_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/metricdefinitions'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::ResourceMetricDefinitionCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets performance metrics of an app (or deployment slot, if specified).
    #
    # Gets performance metrics of an app (or deployment slot, if specified).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will get metrics of the production slot.
    # @param details [Boolean] Specify "true" to include metric details in the
    # response. It is "false" by default.
    # @param filter [String] Return only metrics specified in the filter (using
    # OData syntax). For example: $filter=(name.value eq 'Metric1' or name.value eq
    # 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and endTime eq
    # '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<ResourceMetric>] operation results.
    #
    def list_metrics_slot(resource_group_name, name, slot, details = nil, filter = nil, custom_headers = nil)
      first_page = list_metrics_slot_as_lazy(resource_group_name, name, slot, details, filter, custom_headers)
      first_page.get_all_items
    end

    #
    # Gets performance metrics of an app (or deployment slot, if specified).
    #
    # Gets performance metrics of an app (or deployment slot, if specified).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will get metrics of the production slot.
    # @param details [Boolean] Specify "true" to include metric details in the
    # response. It is "false" by default.
    # @param filter [String] Return only metrics specified in the filter (using
    # OData syntax). For example: $filter=(name.value eq 'Metric1' or name.value eq
    # 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and endTime eq
    # '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_metrics_slot_with_http_info(resource_group_name, name, slot, details = nil, filter = nil, custom_headers = nil)
      list_metrics_slot_async(resource_group_name, name, slot, details, filter, custom_headers).value!
    end

    #
    # Gets performance metrics of an app (or deployment slot, if specified).
    #
    # Gets performance metrics of an app (or deployment slot, if specified).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will get metrics of the production slot.
    # @param details [Boolean] Specify "true" to include metric details in the
    # response. It is "false" by default.
    # @param filter [String] Return only metrics specified in the filter (using
    # OData syntax). For example: $filter=(name.value eq 'Metric1' or name.value eq
    # 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and endTime eq
    # '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_metrics_slot_async(resource_group_name, name, slot, details = nil, filter = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/metrics'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'details' => details,'api-version' => api_version},
          skip_encoding_query_params: {'$filter' => filter},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::ResourceMetricCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Returns the status of MySql in app migration, if one is active, and whether
    # or not MySql in app is enabled
    #
    # Returns the status of MySql in app migration, if one is active, and whether
    # or not MySql in app is enabled
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of web app
    # @param slot [String] Name of the deployment slot
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MigrateMySqlStatus] operation results.
    #
    def get_migrate_my_sql_status_slot(resource_group_name, name, slot, custom_headers = nil)
      response = get_migrate_my_sql_status_slot_async(resource_group_name, name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Returns the status of MySql in app migration, if one is active, and whether
    # or not MySql in app is enabled
    #
    # Returns the status of MySql in app migration, if one is active, and whether
    # or not MySql in app is enabled
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of web app
    # @param slot [String] Name of the deployment slot
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_migrate_my_sql_status_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      get_migrate_my_sql_status_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # Returns the status of MySql in app migration, if one is active, and whether
    # or not MySql in app is enabled
    #
    # Returns the status of MySql in app migration, if one is active, and whether
    # or not MySql in app is enabled
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of web app
    # @param slot [String] Name of the deployment slot
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_migrate_my_sql_status_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/migratemysql/status'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::MigrateMySqlStatus.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets all network features used by the app (or deployment slot, if specified).
    #
    # Gets all network features used by the app (or deployment slot, if specified).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param view [String] The type of view. This can either be "summary" or
    # "detailed".
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will get network features for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [NetworkFeatures] operation results.
    #
    def list_network_features_slot(resource_group_name, name, view, slot, custom_headers = nil)
      response = list_network_features_slot_async(resource_group_name, name, view, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets all network features used by the app (or deployment slot, if specified).
    #
    # Gets all network features used by the app (or deployment slot, if specified).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param view [String] The type of view. This can either be "summary" or
    # "detailed".
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will get network features for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_network_features_slot_with_http_info(resource_group_name, name, view, slot, custom_headers = nil)
      list_network_features_slot_async(resource_group_name, name, view, slot, custom_headers).value!
    end

    #
    # Gets all network features used by the app (or deployment slot, if specified).
    #
    # Gets all network features used by the app (or deployment slot, if specified).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param view [String] The type of view. This can either be "summary" or
    # "detailed".
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will get network features for the production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_network_features_slot_async(resource_group_name, name, view, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'view is nil' if view.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/networkFeatures/{view}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'view' => view,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 404
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::NetworkFeatures.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Start capturing network packets for the site.
    #
    # Start capturing network packets for the site.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] The name of the web app.
    # @param slot [String] The name of the slot for this web app.
    # @param duration_in_seconds [Integer] The duration to keep capturing in
    # seconds.
    # @param max_frame_length [Integer] The maximum frame length in bytes
    # (Optional).
    # @param sas_url [String] The Blob URL to store capture file.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [String] operation results.
    #
    def start_web_site_network_trace_slot(resource_group_name, name, slot, duration_in_seconds = nil, max_frame_length = nil, sas_url = nil, custom_headers = nil)
      response = start_web_site_network_trace_slot_async(resource_group_name, name, slot, duration_in_seconds, max_frame_length, sas_url, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Start capturing network packets for the site.
    #
    # Start capturing network packets for the site.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] The name of the web app.
    # @param slot [String] The name of the slot for this web app.
    # @param duration_in_seconds [Integer] The duration to keep capturing in
    # seconds.
    # @param max_frame_length [Integer] The maximum frame length in bytes
    # (Optional).
    # @param sas_url [String] The Blob URL to store capture file.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def start_web_site_network_trace_slot_with_http_info(resource_group_name, name, slot, duration_in_seconds = nil, max_frame_length = nil, sas_url = nil, custom_headers = nil)
      start_web_site_network_trace_slot_async(resource_group_name, name, slot, duration_in_seconds, max_frame_length, sas_url, custom_headers).value!
    end

    #
    # Start capturing network packets for the site.
    #
    # Start capturing network packets for the site.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] The name of the web app.
    # @param slot [String] The name of the slot for this web app.
    # @param duration_in_seconds [Integer] The duration to keep capturing in
    # seconds.
    # @param max_frame_length [Integer] The maximum frame length in bytes
    # (Optional).
    # @param sas_url [String] The Blob URL to store capture file.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def start_web_site_network_trace_slot_async(resource_group_name, name, slot, duration_in_seconds = nil, max_frame_length = nil, sas_url = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/networkTrace/start'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'durationInSeconds' => duration_in_seconds,'maxFrameLength' => max_frame_length,'sasUrl' => sas_url,'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = {
              required: false,
              serialized_name: 'parsed_response',
              type: {
                name: 'String'
              }
            }
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Stop ongoing capturing network packets for the site.
    #
    # Stop ongoing capturing network packets for the site.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] The name of the web app.
    # @param slot [String] The name of the slot for this web app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [String] operation results.
    #
    def stop_web_site_network_trace_slot(resource_group_name, name, slot, custom_headers = nil)
      response = stop_web_site_network_trace_slot_async(resource_group_name, name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Stop ongoing capturing network packets for the site.
    #
    # Stop ongoing capturing network packets for the site.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] The name of the web app.
    # @param slot [String] The name of the slot for this web app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def stop_web_site_network_trace_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      stop_web_site_network_trace_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # Stop ongoing capturing network packets for the site.
    #
    # Stop ongoing capturing network packets for the site.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] The name of the web app.
    # @param slot [String] The name of the slot for this web app.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def stop_web_site_network_trace_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/networkTrace/stop'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = {
              required: false,
              serialized_name: 'parsed_response',
              type: {
                name: 'String'
              }
            }
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Generates a new publishing password for an app (or deployment slot, if
    # specified).
    #
    # Generates a new publishing password for an app (or deployment slot, if
    # specified).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API generate a new publishing password for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def generate_new_site_publishing_password_slot(resource_group_name, name, slot, custom_headers = nil)
      response = generate_new_site_publishing_password_slot_async(resource_group_name, name, slot, custom_headers).value!
      nil
    end

    #
    # Generates a new publishing password for an app (or deployment slot, if
    # specified).
    #
    # Generates a new publishing password for an app (or deployment slot, if
    # specified).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API generate a new publishing password for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def generate_new_site_publishing_password_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      generate_new_site_publishing_password_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # Generates a new publishing password for an app (or deployment slot, if
    # specified).
    #
    # Generates a new publishing password for an app (or deployment slot, if
    # specified).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API generate a new publishing password for the production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def generate_new_site_publishing_password_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/newpassword'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 204
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Gets perfmon counters for web app.
    #
    # Gets perfmon counters for web app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot. **** CURRENTLY UNUSED *****
    # @param filter [String] Return only usages/metrics specified in the filter.
    # Filter conforms to odata syntax. Example: $filter=(startTime eq
    # '2014-01-01T00:00:00Z' and endTime eq '2014-12-31T23:59:59Z' and timeGrain eq
    # duration'[Hour|Minute|Day]'.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<PerfMonResponse>] operation results.
    #
    def list_perf_mon_counters_slot(resource_group_name, name, slot, filter = nil, custom_headers = nil)
      first_page = list_perf_mon_counters_slot_as_lazy(resource_group_name, name, slot, filter, custom_headers)
      first_page.get_all_items
    end

    #
    # Gets perfmon counters for web app.
    #
    # Gets perfmon counters for web app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot. **** CURRENTLY UNUSED *****
    # @param filter [String] Return only usages/metrics specified in the filter.
    # Filter conforms to odata syntax. Example: $filter=(startTime eq
    # '2014-01-01T00:00:00Z' and endTime eq '2014-12-31T23:59:59Z' and timeGrain eq
    # duration'[Hour|Minute|Day]'.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_perf_mon_counters_slot_with_http_info(resource_group_name, name, slot, filter = nil, custom_headers = nil)
      list_perf_mon_counters_slot_async(resource_group_name, name, slot, filter, custom_headers).value!
    end

    #
    # Gets perfmon counters for web app.
    #
    # Gets perfmon counters for web app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot. **** CURRENTLY UNUSED *****
    # @param filter [String] Return only usages/metrics specified in the filter.
    # Filter conforms to odata syntax. Example: $filter=(startTime eq
    # '2014-01-01T00:00:00Z' and endTime eq '2014-12-31T23:59:59Z' and timeGrain eq
    # duration'[Hour|Minute|Day]'.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_perf_mon_counters_slot_async(resource_group_name, name, slot, filter = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/perfcounters'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          skip_encoding_query_params: {'$filter' => filter},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::PerfMonCounterCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets web app's event logs.
    #
    # Gets web app's event logs.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SitePhpErrorLogFlag] operation results.
    #
    def get_site_php_error_log_flag_slot(resource_group_name, name, slot, custom_headers = nil)
      response = get_site_php_error_log_flag_slot_async(resource_group_name, name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets web app's event logs.
    #
    # Gets web app's event logs.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_site_php_error_log_flag_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      get_site_php_error_log_flag_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # Gets web app's event logs.
    #
    # Gets web app's event logs.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_site_php_error_log_flag_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/phplogging'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::SitePhpErrorLogFlag.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the premier add-ons of an app.
    #
    # Gets the premier add-ons of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will get the premier add-ons for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [PremierAddOn] operation results.
    #
    def list_premier_add_ons_slot(resource_group_name, name, slot, custom_headers = nil)
      response = list_premier_add_ons_slot_async(resource_group_name, name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the premier add-ons of an app.
    #
    # Gets the premier add-ons of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will get the premier add-ons for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_premier_add_ons_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      list_premier_add_ons_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # Gets the premier add-ons of an app.
    #
    # Gets the premier add-ons of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will get the premier add-ons for the production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_premier_add_ons_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/premieraddons'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::PremierAddOn.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets a named add-on of an app.
    #
    # Gets a named add-on of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param premier_add_on_name [String] Add-on name.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will get the named add-on for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [PremierAddOn] operation results.
    #
    def get_premier_add_on_slot(resource_group_name, name, premier_add_on_name, slot, custom_headers = nil)
      response = get_premier_add_on_slot_async(resource_group_name, name, premier_add_on_name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets a named add-on of an app.
    #
    # Gets a named add-on of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param premier_add_on_name [String] Add-on name.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will get the named add-on for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_premier_add_on_slot_with_http_info(resource_group_name, name, premier_add_on_name, slot, custom_headers = nil)
      get_premier_add_on_slot_async(resource_group_name, name, premier_add_on_name, slot, custom_headers).value!
    end

    #
    # Gets a named add-on of an app.
    #
    # Gets a named add-on of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param premier_add_on_name [String] Add-on name.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will get the named add-on for the production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_premier_add_on_slot_async(resource_group_name, name, premier_add_on_name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'premier_add_on_name is nil' if premier_add_on_name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/premieraddons/{premierAddOnName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'premierAddOnName' => premier_add_on_name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::PremierAddOn.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Updates a named add-on of an app.
    #
    # Updates a named add-on of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param premier_add_on_name [String] Add-on name.
    # @param premier_add_on [PremierAddOn] A JSON representation of the edited
    # premier add-on.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will update the named add-on for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [PremierAddOn] operation results.
    #
    def add_premier_add_on_slot(resource_group_name, name, premier_add_on_name, premier_add_on, slot, custom_headers = nil)
      response = add_premier_add_on_slot_async(resource_group_name, name, premier_add_on_name, premier_add_on, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Updates a named add-on of an app.
    #
    # Updates a named add-on of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param premier_add_on_name [String] Add-on name.
    # @param premier_add_on [PremierAddOn] A JSON representation of the edited
    # premier add-on.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will update the named add-on for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def add_premier_add_on_slot_with_http_info(resource_group_name, name, premier_add_on_name, premier_add_on, slot, custom_headers = nil)
      add_premier_add_on_slot_async(resource_group_name, name, premier_add_on_name, premier_add_on, slot, custom_headers).value!
    end

    #
    # Updates a named add-on of an app.
    #
    # Updates a named add-on of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param premier_add_on_name [String] Add-on name.
    # @param premier_add_on [PremierAddOn] A JSON representation of the edited
    # premier add-on.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will update the named add-on for the production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def add_premier_add_on_slot_async(resource_group_name, name, premier_add_on_name, premier_add_on, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'premier_add_on_name is nil' if premier_add_on_name.nil?
      fail ArgumentError, 'premier_add_on is nil' if premier_add_on.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::Web::Models::PremierAddOn.mapper()
      request_content = @client.serialize(request_mapper,  premier_add_on)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/premieraddons/{premierAddOnName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'premierAddOnName' => premier_add_on_name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::PremierAddOn.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Delete a premier add-on from an app.
    #
    # Delete a premier add-on from an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param premier_add_on_name [String] Add-on name.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will delete the named add-on for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def delete_premier_add_on_slot(resource_group_name, name, premier_add_on_name, slot, custom_headers = nil)
      response = delete_premier_add_on_slot_async(resource_group_name, name, premier_add_on_name, slot, custom_headers).value!
      nil
    end

    #
    # Delete a premier add-on from an app.
    #
    # Delete a premier add-on from an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param premier_add_on_name [String] Add-on name.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will delete the named add-on for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_premier_add_on_slot_with_http_info(resource_group_name, name, premier_add_on_name, slot, custom_headers = nil)
      delete_premier_add_on_slot_async(resource_group_name, name, premier_add_on_name, slot, custom_headers).value!
    end

    #
    # Delete a premier add-on from an app.
    #
    # Delete a premier add-on from an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param premier_add_on_name [String] Add-on name.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will delete the named add-on for the production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_premier_add_on_slot_async(resource_group_name, name, premier_add_on_name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'premier_add_on_name is nil' if premier_add_on_name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/premieraddons/{premierAddOnName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'premierAddOnName' => premier_add_on_name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Gets the publishing profile for an app (or deployment slot, if specified).
    #
    # Gets the publishing profile for an app (or deployment slot, if specified).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param publishing_profile_options [CsmPublishingProfileOptions] Specifies
    # publishingProfileOptions for publishing profile. For example, use {"format":
    # "FileZilla3"} to get a FileZilla publishing profile.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will get the publishing profile for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [NOT_IMPLEMENTED] operation results.
    #
    def list_publishing_profile_xml_with_secrets_slot(resource_group_name, name, publishing_profile_options, slot, custom_headers = nil)
      response = list_publishing_profile_xml_with_secrets_slot_async(resource_group_name, name, publishing_profile_options, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the publishing profile for an app (or deployment slot, if specified).
    #
    # Gets the publishing profile for an app (or deployment slot, if specified).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param publishing_profile_options [CsmPublishingProfileOptions] Specifies
    # publishingProfileOptions for publishing profile. For example, use {"format":
    # "FileZilla3"} to get a FileZilla publishing profile.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will get the publishing profile for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_publishing_profile_xml_with_secrets_slot_with_http_info(resource_group_name, name, publishing_profile_options, slot, custom_headers = nil)
      list_publishing_profile_xml_with_secrets_slot_async(resource_group_name, name, publishing_profile_options, slot, custom_headers).value!
    end

    #
    # Gets the publishing profile for an app (or deployment slot, if specified).
    #
    # Gets the publishing profile for an app (or deployment slot, if specified).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param publishing_profile_options [CsmPublishingProfileOptions] Specifies
    # publishingProfileOptions for publishing profile. For example, use {"format":
    # "FileZilla3"} to get a FileZilla publishing profile.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will get the publishing profile for the production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_publishing_profile_xml_with_secrets_slot_async(resource_group_name, name, publishing_profile_options, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'publishing_profile_options is nil' if publishing_profile_options.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::Web::Models::CsmPublishingProfileOptions.mapper()
      request_content = @client.serialize(request_mapper,  publishing_profile_options)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/publishxml'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = {
              required: false,
              serialized_name: 'parsed_response',
              type: {
                name: 'Stream'
              }
            }
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Recovers a deleted web app.
    #
    # Recovers a deleted web app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of web app
    # @param recovery_entity [CsmSiteRecoveryEntity] Snapshot data used for web app
    # recovery. Snapshot information can be obtained by calling GetDeletedSites or
    # GetSiteSnapshots API.
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [RecoverResponse] operation results.
    #
    def recover_slot(resource_group_name, name, recovery_entity, slot, custom_headers = nil)
      response = recover_slot_async(resource_group_name, name, recovery_entity, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of web app
    # @param recovery_entity [CsmSiteRecoveryEntity] Snapshot data used for web app
    # recovery. Snapshot information can be obtained by calling GetDeletedSites or
    # GetSiteSnapshots API.
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def recover_slot_async(resource_group_name, name, recovery_entity, slot, custom_headers = nil)
      # Send request
      promise = begin_recover_slot_async(resource_group_name, name, recovery_entity, slot, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Azure::ARM::Web::Models::RecoverResponse.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response)
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Resets the configuration settings of the current slot if they were previously
    # modified by calling the API with POST.
    #
    # Resets the configuration settings of the current slot if they were previously
    # modified by calling the API with POST.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API resets configuration settings for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def reset_slot_configuration_slot(resource_group_name, name, slot, custom_headers = nil)
      response = reset_slot_configuration_slot_async(resource_group_name, name, slot, custom_headers).value!
      nil
    end

    #
    # Resets the configuration settings of the current slot if they were previously
    # modified by calling the API with POST.
    #
    # Resets the configuration settings of the current slot if they were previously
    # modified by calling the API with POST.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API resets configuration settings for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def reset_slot_configuration_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      reset_slot_configuration_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # Resets the configuration settings of the current slot if they were previously
    # modified by calling the API with POST.
    #
    # Resets the configuration settings of the current slot if they were previously
    # modified by calling the API with POST.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API resets configuration settings for the production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def reset_slot_configuration_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/resetSlotConfig'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Gets the category of ResourceHealthMetadata to use for the given site
    #
    # Gets the category of ResourceHealthMetadata to use for the given site
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ResourceHealthMetadata] operation results.
    #
    def get_resource_health_metadata_slot(resource_group_name, name, slot, custom_headers = nil)
      response = get_resource_health_metadata_slot_async(resource_group_name, name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the category of ResourceHealthMetadata to use for the given site
    #
    # Gets the category of ResourceHealthMetadata to use for the given site
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_resource_health_metadata_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      get_resource_health_metadata_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # Gets the category of ResourceHealthMetadata to use for the given site
    #
    # Gets the category of ResourceHealthMetadata to use for the given site
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_resource_health_metadata_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/resourceHealthMetadata'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::ResourceHealthMetadata.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Restarts an app (or deployment slot, if specified).
    #
    # Restarts an app (or deployment slot, if specified).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will restart the production slot.
    # @param soft_restart [Boolean] Specify true to apply the configuration
    # settings and restarts the app only if necessary. By default, the API always
    # restarts and reprovisions the app.
    # @param synchronous [Boolean] Specify true to block until the app is
    # restarted. By default, it is set to false, and the API responds immediately
    # (asynchronous).
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def restart_slot(resource_group_name, name, slot, soft_restart = nil, synchronous = nil, custom_headers = nil)
      response = restart_slot_async(resource_group_name, name, slot, soft_restart, synchronous, custom_headers).value!
      nil
    end

    #
    # Restarts an app (or deployment slot, if specified).
    #
    # Restarts an app (or deployment slot, if specified).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will restart the production slot.
    # @param soft_restart [Boolean] Specify true to apply the configuration
    # settings and restarts the app only if necessary. By default, the API always
    # restarts and reprovisions the app.
    # @param synchronous [Boolean] Specify true to block until the app is
    # restarted. By default, it is set to false, and the API responds immediately
    # (asynchronous).
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def restart_slot_with_http_info(resource_group_name, name, slot, soft_restart = nil, synchronous = nil, custom_headers = nil)
      restart_slot_async(resource_group_name, name, slot, soft_restart, synchronous, custom_headers).value!
    end

    #
    # Restarts an app (or deployment slot, if specified).
    #
    # Restarts an app (or deployment slot, if specified).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will restart the production slot.
    # @param soft_restart [Boolean] Specify true to apply the configuration
    # settings and restarts the app only if necessary. By default, the API always
    # restarts and reprovisions the app.
    # @param synchronous [Boolean] Specify true to block until the app is
    # restarted. By default, it is set to false, and the API responds immediately
    # (asynchronous).
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def restart_slot_async(resource_group_name, name, slot, soft_restart = nil, synchronous = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/restart'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'softRestart' => soft_restart,'synchronous' => synchronous,'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Get the difference in configuration settings between two web app slots.
    #
    # Get the difference in configuration settings between two web app slots.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot_swap_entity [CsmSlotEntity] JSON object that contains the target
    # slot name. See example.
    # @param slot [String] Name of the source slot. If a slot is not specified, the
    # production slot is used as the source slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<SlotDifference>] operation results.
    #
    def list_slot_differences_slot(resource_group_name, name, slot_swap_entity, slot, custom_headers = nil)
      first_page = list_slot_differences_slot_as_lazy(resource_group_name, name, slot_swap_entity, slot, custom_headers)
      first_page.get_all_items
    end

    #
    # Get the difference in configuration settings between two web app slots.
    #
    # Get the difference in configuration settings between two web app slots.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot_swap_entity [CsmSlotEntity] JSON object that contains the target
    # slot name. See example.
    # @param slot [String] Name of the source slot. If a slot is not specified, the
    # production slot is used as the source slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_slot_differences_slot_with_http_info(resource_group_name, name, slot_swap_entity, slot, custom_headers = nil)
      list_slot_differences_slot_async(resource_group_name, name, slot_swap_entity, slot, custom_headers).value!
    end

    #
    # Get the difference in configuration settings between two web app slots.
    #
    # Get the difference in configuration settings between two web app slots.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot_swap_entity [CsmSlotEntity] JSON object that contains the target
    # slot name. See example.
    # @param slot [String] Name of the source slot. If a slot is not specified, the
    # production slot is used as the source slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_slot_differences_slot_async(resource_group_name, name, slot_swap_entity, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot_swap_entity is nil' if slot_swap_entity.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::Web::Models::CsmSlotEntity.mapper()
      request_content = @client.serialize(request_mapper,  slot_swap_entity)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/slotsdiffs'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::SlotDifferenceCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Swaps two deployment slots of an app.
    #
    # Swaps two deployment slots of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot_swap_entity [CsmSlotEntity] JSON object that contains the target
    # slot name. See example.
    # @param slot [String] Name of the source slot. If a slot is not specified, the
    # production slot is used as the source slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    def swap_slot_slot(resource_group_name, name, slot_swap_entity, slot, custom_headers = nil)
      response = swap_slot_slot_async(resource_group_name, name, slot_swap_entity, slot, custom_headers).value!
      nil
    end

    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot_swap_entity [CsmSlotEntity] JSON object that contains the target
    # slot name. See example.
    # @param slot [String] Name of the source slot. If a slot is not specified, the
    # production slot is used as the source slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def swap_slot_slot_async(resource_group_name, name, slot_swap_entity, slot, custom_headers = nil)
      # Send request
      promise = begin_swap_slot_slot_async(resource_group_name, name, slot_swap_entity, slot, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Returns all Snapshots to the user.
    #
    # Returns all Snapshots to the user.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Website Name
    # @param slot [String] Website Slot
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<Snapshot>] operation results.
    #
    def list_snapshots_slot(resource_group_name, name, slot, custom_headers = nil)
      first_page = list_snapshots_slot_as_lazy(resource_group_name, name, slot, custom_headers)
      first_page.get_all_items
    end

    #
    # Returns all Snapshots to the user.
    #
    # Returns all Snapshots to the user.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Website Name
    # @param slot [String] Website Slot
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_snapshots_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      list_snapshots_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # Returns all Snapshots to the user.
    #
    # Returns all Snapshots to the user.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Website Name
    # @param slot [String] Website Slot
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_snapshots_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/snapshots'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::SnapshotCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the source control configuration of an app.
    #
    # Gets the source control configuration of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will get the source control configuration for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteSourceControl] operation results.
    #
    def get_source_control_slot(resource_group_name, name, slot, custom_headers = nil)
      response = get_source_control_slot_async(resource_group_name, name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the source control configuration of an app.
    #
    # Gets the source control configuration of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will get the source control configuration for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_source_control_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      get_source_control_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # Gets the source control configuration of an app.
    #
    # Gets the source control configuration of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will get the source control configuration for the production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_source_control_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/sourcecontrols/web'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::SiteSourceControl.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Updates the source control configuration of an app.
    #
    # Updates the source control configuration of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param site_source_control [SiteSourceControl] JSON representation of a
    # SiteSourceControl object. See example.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will update the source control configuration for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteSourceControl] operation results.
    #
    def create_or_update_source_control_slot(resource_group_name, name, site_source_control, slot, custom_headers = nil)
      response = create_or_update_source_control_slot_async(resource_group_name, name, site_source_control, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param site_source_control [SiteSourceControl] JSON representation of a
    # SiteSourceControl object. See example.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will update the source control configuration for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def create_or_update_source_control_slot_async(resource_group_name, name, site_source_control, slot, custom_headers = nil)
      # Send request
      promise = begin_create_or_update_source_control_slot_async(resource_group_name, name, site_source_control, slot, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Azure::ARM::Web::Models::SiteSourceControl.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response)
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Deletes the source control configuration of an app.
    #
    # Deletes the source control configuration of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will delete the source control configuration for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def delete_source_control_slot(resource_group_name, name, slot, custom_headers = nil)
      response = delete_source_control_slot_async(resource_group_name, name, slot, custom_headers).value!
      nil
    end

    #
    # Deletes the source control configuration of an app.
    #
    # Deletes the source control configuration of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will delete the source control configuration for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_source_control_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      delete_source_control_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # Deletes the source control configuration of an app.
    #
    # Deletes the source control configuration of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will delete the source control configuration for the production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_source_control_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/sourcecontrols/web'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202 || status_code == 404
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Starts an app (or deployment slot, if specified).
    #
    # Starts an app (or deployment slot, if specified).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will start the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def start_slot(resource_group_name, name, slot, custom_headers = nil)
      response = start_slot_async(resource_group_name, name, slot, custom_headers).value!
      nil
    end

    #
    # Starts an app (or deployment slot, if specified).
    #
    # Starts an app (or deployment slot, if specified).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will start the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def start_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      start_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # Starts an app (or deployment slot, if specified).
    #
    # Starts an app (or deployment slot, if specified).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will start the production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def start_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/start'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Stops an app (or deployment slot, if specified).
    #
    # Stops an app (or deployment slot, if specified).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will stop the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def stop_slot(resource_group_name, name, slot, custom_headers = nil)
      response = stop_slot_async(resource_group_name, name, slot, custom_headers).value!
      nil
    end

    #
    # Stops an app (or deployment slot, if specified).
    #
    # Stops an app (or deployment slot, if specified).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will stop the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def stop_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      stop_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # Stops an app (or deployment slot, if specified).
    #
    # Stops an app (or deployment slot, if specified).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will stop the production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def stop_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/stop'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Sync web app repository.
    #
    # Sync web app repository.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def sync_repository_slot(resource_group_name, name, slot, custom_headers = nil)
      response = sync_repository_slot_async(resource_group_name, name, slot, custom_headers).value!
      nil
    end

    #
    # Sync web app repository.
    #
    # Sync web app repository.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def sync_repository_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      sync_repository_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # Sync web app repository.
    #
    # Sync web app repository.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def sync_repository_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/sync'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 204
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Syncs function trigger metadata to the scale controller
    #
    # Syncs function trigger metadata to the scale controller
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will restore a backup of the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def sync_function_triggers_slot(resource_group_name, name, slot, custom_headers = nil)
      response = sync_function_triggers_slot_async(resource_group_name, name, slot, custom_headers).value!
      nil
    end

    #
    # Syncs function trigger metadata to the scale controller
    #
    # Syncs function trigger metadata to the scale controller
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will restore a backup of the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def sync_function_triggers_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      sync_function_triggers_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # Syncs function trigger metadata to the scale controller
    #
    # Syncs function trigger metadata to the scale controller
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will restore a backup of the production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def sync_function_triggers_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/syncfunctiontriggers'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 204
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Gets the quota usage information of an app (or deployment slot, if
    # specified).
    #
    # Gets the quota usage information of an app (or deployment slot, if
    # specified).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will get quota information of the production slot.
    # @param filter [String] Return only information specified in the filter (using
    # OData syntax). For example: $filter=(name.value eq 'Metric1' or name.value eq
    # 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and endTime eq
    # '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<CsmUsageQuota>] operation results.
    #
    def list_usages_slot(resource_group_name, name, slot, filter = nil, custom_headers = nil)
      first_page = list_usages_slot_as_lazy(resource_group_name, name, slot, filter, custom_headers)
      first_page.get_all_items
    end

    #
    # Gets the quota usage information of an app (or deployment slot, if
    # specified).
    #
    # Gets the quota usage information of an app (or deployment slot, if
    # specified).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will get quota information of the production slot.
    # @param filter [String] Return only information specified in the filter (using
    # OData syntax). For example: $filter=(name.value eq 'Metric1' or name.value eq
    # 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and endTime eq
    # '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_usages_slot_with_http_info(resource_group_name, name, slot, filter = nil, custom_headers = nil)
      list_usages_slot_async(resource_group_name, name, slot, filter, custom_headers).value!
    end

    #
    # Gets the quota usage information of an app (or deployment slot, if
    # specified).
    #
    # Gets the quota usage information of an app (or deployment slot, if
    # specified).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will get quota information of the production slot.
    # @param filter [String] Return only information specified in the filter (using
    # OData syntax). For example: $filter=(name.value eq 'Metric1' or name.value eq
    # 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and endTime eq
    # '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_usages_slot_async(resource_group_name, name, slot, filter = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/usages'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          skip_encoding_query_params: {'$filter' => filter},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::CsmUsageQuotaCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the virtual networks the app (or deployment slot) is connected to.
    #
    # Gets the virtual networks the app (or deployment slot) is connected to.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will get virtual network connections for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array] operation results.
    #
    def list_vnet_connections_slot(resource_group_name, name, slot, custom_headers = nil)
      response = list_vnet_connections_slot_async(resource_group_name, name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the virtual networks the app (or deployment slot) is connected to.
    #
    # Gets the virtual networks the app (or deployment slot) is connected to.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will get virtual network connections for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_vnet_connections_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      list_vnet_connections_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # Gets the virtual networks the app (or deployment slot) is connected to.
    #
    # Gets the virtual networks the app (or deployment slot) is connected to.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will get virtual network connections for the production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_vnet_connections_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = {
              required: false,
              serialized_name: 'parsed_response',
              type: {
                name: 'Sequence',
                element: {
                    required: false,
                    serialized_name: 'VnetInfoElementType',
                    type: {
                      name: 'Composite',
                      class_name: 'VnetInfo'
                    }
                }
              }
            }
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets a virtual network the app (or deployment slot) is connected to by name.
    #
    # Gets a virtual network the app (or deployment slot) is connected to by name.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param vnet_name [String] Name of the virtual network.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will get the named virtual network for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VnetInfo] operation results.
    #
    def get_vnet_connection_slot(resource_group_name, name, vnet_name, slot, custom_headers = nil)
      response = get_vnet_connection_slot_async(resource_group_name, name, vnet_name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets a virtual network the app (or deployment slot) is connected to by name.
    #
    # Gets a virtual network the app (or deployment slot) is connected to by name.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param vnet_name [String] Name of the virtual network.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will get the named virtual network for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_vnet_connection_slot_with_http_info(resource_group_name, name, vnet_name, slot, custom_headers = nil)
      get_vnet_connection_slot_async(resource_group_name, name, vnet_name, slot, custom_headers).value!
    end

    #
    # Gets a virtual network the app (or deployment slot) is connected to by name.
    #
    # Gets a virtual network the app (or deployment slot) is connected to by name.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param vnet_name [String] Name of the virtual network.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will get the named virtual network for the production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_vnet_connection_slot_async(resource_group_name, name, vnet_name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'vnet_name is nil' if vnet_name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections/{vnetName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'vnetName' => vnet_name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::VnetInfo.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Adds a Virtual Network connection to an app or slot (PUT) or updates the
    # connection properties (PATCH).
    #
    # Adds a Virtual Network connection to an app or slot (PUT) or updates the
    # connection properties (PATCH).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param vnet_name [String] Name of an existing Virtual Network.
    # @param connection_envelope [VnetInfo] Properties of the Virtual Network
    # connection. See example.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will add or update connections for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VnetInfo] operation results.
    #
    def create_or_update_vnet_connection_slot(resource_group_name, name, vnet_name, connection_envelope, slot, custom_headers = nil)
      response = create_or_update_vnet_connection_slot_async(resource_group_name, name, vnet_name, connection_envelope, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Adds a Virtual Network connection to an app or slot (PUT) or updates the
    # connection properties (PATCH).
    #
    # Adds a Virtual Network connection to an app or slot (PUT) or updates the
    # connection properties (PATCH).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param vnet_name [String] Name of an existing Virtual Network.
    # @param connection_envelope [VnetInfo] Properties of the Virtual Network
    # connection. See example.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will add or update connections for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def create_or_update_vnet_connection_slot_with_http_info(resource_group_name, name, vnet_name, connection_envelope, slot, custom_headers = nil)
      create_or_update_vnet_connection_slot_async(resource_group_name, name, vnet_name, connection_envelope, slot, custom_headers).value!
    end

    #
    # Adds a Virtual Network connection to an app or slot (PUT) or updates the
    # connection properties (PATCH).
    #
    # Adds a Virtual Network connection to an app or slot (PUT) or updates the
    # connection properties (PATCH).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param vnet_name [String] Name of an existing Virtual Network.
    # @param connection_envelope [VnetInfo] Properties of the Virtual Network
    # connection. See example.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will add or update connections for the production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def create_or_update_vnet_connection_slot_async(resource_group_name, name, vnet_name, connection_envelope, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'vnet_name is nil' if vnet_name.nil?
      fail ArgumentError, 'connection_envelope is nil' if connection_envelope.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::Web::Models::VnetInfo.mapper()
      request_content = @client.serialize(request_mapper,  connection_envelope)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections/{vnetName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'vnetName' => vnet_name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::VnetInfo.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Deletes a connection from an app (or deployment slot to a named virtual
    # network.
    #
    # Deletes a connection from an app (or deployment slot to a named virtual
    # network.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param vnet_name [String] Name of the virtual network.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will delete the connection for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def delete_vnet_connection_slot(resource_group_name, name, vnet_name, slot, custom_headers = nil)
      response = delete_vnet_connection_slot_async(resource_group_name, name, vnet_name, slot, custom_headers).value!
      nil
    end

    #
    # Deletes a connection from an app (or deployment slot to a named virtual
    # network.
    #
    # Deletes a connection from an app (or deployment slot to a named virtual
    # network.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param vnet_name [String] Name of the virtual network.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will delete the connection for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_vnet_connection_slot_with_http_info(resource_group_name, name, vnet_name, slot, custom_headers = nil)
      delete_vnet_connection_slot_async(resource_group_name, name, vnet_name, slot, custom_headers).value!
    end

    #
    # Deletes a connection from an app (or deployment slot to a named virtual
    # network.
    #
    # Deletes a connection from an app (or deployment slot to a named virtual
    # network.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param vnet_name [String] Name of the virtual network.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will delete the connection for the production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_vnet_connection_slot_async(resource_group_name, name, vnet_name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'vnet_name is nil' if vnet_name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections/{vnetName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'vnetName' => vnet_name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 404
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Adds a Virtual Network connection to an app or slot (PUT) or updates the
    # connection properties (PATCH).
    #
    # Adds a Virtual Network connection to an app or slot (PUT) or updates the
    # connection properties (PATCH).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param vnet_name [String] Name of an existing Virtual Network.
    # @param connection_envelope [VnetInfo] Properties of the Virtual Network
    # connection. See example.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will add or update connections for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VnetInfo] operation results.
    #
    def update_vnet_connection_slot(resource_group_name, name, vnet_name, connection_envelope, slot, custom_headers = nil)
      response = update_vnet_connection_slot_async(resource_group_name, name, vnet_name, connection_envelope, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Adds a Virtual Network connection to an app or slot (PUT) or updates the
    # connection properties (PATCH).
    #
    # Adds a Virtual Network connection to an app or slot (PUT) or updates the
    # connection properties (PATCH).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param vnet_name [String] Name of an existing Virtual Network.
    # @param connection_envelope [VnetInfo] Properties of the Virtual Network
    # connection. See example.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will add or update connections for the production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_vnet_connection_slot_with_http_info(resource_group_name, name, vnet_name, connection_envelope, slot, custom_headers = nil)
      update_vnet_connection_slot_async(resource_group_name, name, vnet_name, connection_envelope, slot, custom_headers).value!
    end

    #
    # Adds a Virtual Network connection to an app or slot (PUT) or updates the
    # connection properties (PATCH).
    #
    # Adds a Virtual Network connection to an app or slot (PUT) or updates the
    # connection properties (PATCH).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param vnet_name [String] Name of an existing Virtual Network.
    # @param connection_envelope [VnetInfo] Properties of the Virtual Network
    # connection. See example.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will add or update connections for the production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_vnet_connection_slot_async(resource_group_name, name, vnet_name, connection_envelope, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'vnet_name is nil' if vnet_name.nil?
      fail ArgumentError, 'connection_envelope is nil' if connection_envelope.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::Web::Models::VnetInfo.mapper()
      request_content = @client.serialize(request_mapper,  connection_envelope)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections/{vnetName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'vnetName' => vnet_name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:patch, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::VnetInfo.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets an app's Virtual Network gateway.
    #
    # Gets an app's Virtual Network gateway.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param vnet_name [String] Name of the Virtual Network.
    # @param gateway_name [String] Name of the gateway. Currently, the only
    # supported string is "primary".
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will get a gateway for the production slot's Virtual Network.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VnetGateway] operation results.
    #
    def get_vnet_connection_gateway_slot(resource_group_name, name, vnet_name, gateway_name, slot, custom_headers = nil)
      response = get_vnet_connection_gateway_slot_async(resource_group_name, name, vnet_name, gateway_name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets an app's Virtual Network gateway.
    #
    # Gets an app's Virtual Network gateway.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param vnet_name [String] Name of the Virtual Network.
    # @param gateway_name [String] Name of the gateway. Currently, the only
    # supported string is "primary".
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will get a gateway for the production slot's Virtual Network.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_vnet_connection_gateway_slot_with_http_info(resource_group_name, name, vnet_name, gateway_name, slot, custom_headers = nil)
      get_vnet_connection_gateway_slot_async(resource_group_name, name, vnet_name, gateway_name, slot, custom_headers).value!
    end

    #
    # Gets an app's Virtual Network gateway.
    #
    # Gets an app's Virtual Network gateway.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param vnet_name [String] Name of the Virtual Network.
    # @param gateway_name [String] Name of the gateway. Currently, the only
    # supported string is "primary".
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will get a gateway for the production slot's Virtual Network.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_vnet_connection_gateway_slot_async(resource_group_name, name, vnet_name, gateway_name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'vnet_name is nil' if vnet_name.nil?
      fail ArgumentError, 'gateway_name is nil' if gateway_name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections/{vnetName}/gateways/{gatewayName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'vnetName' => vnet_name,'gatewayName' => gateway_name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 404
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::VnetGateway.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Adds a gateway to a connected Virtual Network (PUT) or updates it (PATCH).
    #
    # Adds a gateway to a connected Virtual Network (PUT) or updates it (PATCH).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param vnet_name [String] Name of the Virtual Network.
    # @param gateway_name [String] Name of the gateway. Currently, the only
    # supported string is "primary".
    # @param connection_envelope [VnetGateway] The properties to update this
    # gateway with.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will add or update a gateway for the production slot's Virtual
    # Network.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VnetGateway] operation results.
    #
    def create_or_update_vnet_connection_gateway_slot(resource_group_name, name, vnet_name, gateway_name, connection_envelope, slot, custom_headers = nil)
      response = create_or_update_vnet_connection_gateway_slot_async(resource_group_name, name, vnet_name, gateway_name, connection_envelope, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Adds a gateway to a connected Virtual Network (PUT) or updates it (PATCH).
    #
    # Adds a gateway to a connected Virtual Network (PUT) or updates it (PATCH).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param vnet_name [String] Name of the Virtual Network.
    # @param gateway_name [String] Name of the gateway. Currently, the only
    # supported string is "primary".
    # @param connection_envelope [VnetGateway] The properties to update this
    # gateway with.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will add or update a gateway for the production slot's Virtual
    # Network.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def create_or_update_vnet_connection_gateway_slot_with_http_info(resource_group_name, name, vnet_name, gateway_name, connection_envelope, slot, custom_headers = nil)
      create_or_update_vnet_connection_gateway_slot_async(resource_group_name, name, vnet_name, gateway_name, connection_envelope, slot, custom_headers).value!
    end

    #
    # Adds a gateway to a connected Virtual Network (PUT) or updates it (PATCH).
    #
    # Adds a gateway to a connected Virtual Network (PUT) or updates it (PATCH).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param vnet_name [String] Name of the Virtual Network.
    # @param gateway_name [String] Name of the gateway. Currently, the only
    # supported string is "primary".
    # @param connection_envelope [VnetGateway] The properties to update this
    # gateway with.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will add or update a gateway for the production slot's Virtual
    # Network.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def create_or_update_vnet_connection_gateway_slot_async(resource_group_name, name, vnet_name, gateway_name, connection_envelope, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'vnet_name is nil' if vnet_name.nil?
      fail ArgumentError, 'gateway_name is nil' if gateway_name.nil?
      fail ArgumentError, 'connection_envelope is nil' if connection_envelope.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::Web::Models::VnetGateway.mapper()
      request_content = @client.serialize(request_mapper,  connection_envelope)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections/{vnetName}/gateways/{gatewayName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'vnetName' => vnet_name,'gatewayName' => gateway_name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::VnetGateway.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Adds a gateway to a connected Virtual Network (PUT) or updates it (PATCH).
    #
    # Adds a gateway to a connected Virtual Network (PUT) or updates it (PATCH).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param vnet_name [String] Name of the Virtual Network.
    # @param gateway_name [String] Name of the gateway. Currently, the only
    # supported string is "primary".
    # @param connection_envelope [VnetGateway] The properties to update this
    # gateway with.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will add or update a gateway for the production slot's Virtual
    # Network.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VnetGateway] operation results.
    #
    def update_vnet_connection_gateway_slot(resource_group_name, name, vnet_name, gateway_name, connection_envelope, slot, custom_headers = nil)
      response = update_vnet_connection_gateway_slot_async(resource_group_name, name, vnet_name, gateway_name, connection_envelope, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Adds a gateway to a connected Virtual Network (PUT) or updates it (PATCH).
    #
    # Adds a gateway to a connected Virtual Network (PUT) or updates it (PATCH).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param vnet_name [String] Name of the Virtual Network.
    # @param gateway_name [String] Name of the gateway. Currently, the only
    # supported string is "primary".
    # @param connection_envelope [VnetGateway] The properties to update this
    # gateway with.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will add or update a gateway for the production slot's Virtual
    # Network.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_vnet_connection_gateway_slot_with_http_info(resource_group_name, name, vnet_name, gateway_name, connection_envelope, slot, custom_headers = nil)
      update_vnet_connection_gateway_slot_async(resource_group_name, name, vnet_name, gateway_name, connection_envelope, slot, custom_headers).value!
    end

    #
    # Adds a gateway to a connected Virtual Network (PUT) or updates it (PATCH).
    #
    # Adds a gateway to a connected Virtual Network (PUT) or updates it (PATCH).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param vnet_name [String] Name of the Virtual Network.
    # @param gateway_name [String] Name of the gateway. Currently, the only
    # supported string is "primary".
    # @param connection_envelope [VnetGateway] The properties to update this
    # gateway with.
    # @param slot [String] Name of the deployment slot. If a slot is not specified,
    # the API will add or update a gateway for the production slot's Virtual
    # Network.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_vnet_connection_gateway_slot_async(resource_group_name, name, vnet_name, gateway_name, connection_envelope, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'vnet_name is nil' if vnet_name.nil?
      fail ArgumentError, 'gateway_name is nil' if gateway_name.nil?
      fail ArgumentError, 'connection_envelope is nil' if connection_envelope.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::Web::Models::VnetGateway.mapper()
      request_content = @client.serialize(request_mapper,  connection_envelope)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections/{vnetName}/gateways/{gatewayName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'vnetName' => vnet_name,'gatewayName' => gateway_name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:patch, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::VnetGateway.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get the difference in configuration settings between two web app slots.
    #
    # Get the difference in configuration settings between two web app slots.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot_swap_entity [CsmSlotEntity] JSON object that contains the target
    # slot name. See example.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<SlotDifference>] operation results.
    #
    def list_slot_differences_from_production(resource_group_name, name, slot_swap_entity, custom_headers = nil)
      first_page = list_slot_differences_from_production_as_lazy(resource_group_name, name, slot_swap_entity, custom_headers)
      first_page.get_all_items
    end

    #
    # Get the difference in configuration settings between two web app slots.
    #
    # Get the difference in configuration settings between two web app slots.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot_swap_entity [CsmSlotEntity] JSON object that contains the target
    # slot name. See example.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_slot_differences_from_production_with_http_info(resource_group_name, name, slot_swap_entity, custom_headers = nil)
      list_slot_differences_from_production_async(resource_group_name, name, slot_swap_entity, custom_headers).value!
    end

    #
    # Get the difference in configuration settings between two web app slots.
    #
    # Get the difference in configuration settings between two web app slots.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot_swap_entity [CsmSlotEntity] JSON object that contains the target
    # slot name. See example.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_slot_differences_from_production_async(resource_group_name, name, slot_swap_entity, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot_swap_entity is nil' if slot_swap_entity.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::Web::Models::CsmSlotEntity.mapper()
      request_content = @client.serialize(request_mapper,  slot_swap_entity)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slotsdiffs'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::SlotDifferenceCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Swaps two deployment slots of an app.
    #
    # Swaps two deployment slots of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot_swap_entity [CsmSlotEntity] JSON object that contains the target
    # slot name. See example.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    def swap_slot_with_production(resource_group_name, name, slot_swap_entity, custom_headers = nil)
      response = swap_slot_with_production_async(resource_group_name, name, slot_swap_entity, custom_headers).value!
      nil
    end

    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param slot_swap_entity [CsmSlotEntity] JSON object that contains the target
    # slot name. See example.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def swap_slot_with_production_async(resource_group_name, name, slot_swap_entity, custom_headers = nil)
      # Send request
      promise = begin_swap_slot_with_production_async(resource_group_name, name, slot_swap_entity, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Returns all Snapshots to the user.
    #
    # Returns all Snapshots to the user.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Website Name
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<Snapshot>] operation results.
    #
    def list_snapshots(resource_group_name, name, custom_headers = nil)
      first_page = list_snapshots_as_lazy(resource_group_name, name, custom_headers)
      first_page.get_all_items
    end

    #
    # Returns all Snapshots to the user.
    #
    # Returns all Snapshots to the user.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Website Name
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_snapshots_with_http_info(resource_group_name, name, custom_headers = nil)
      list_snapshots_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Returns all Snapshots to the user.
    #
    # Returns all Snapshots to the user.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Website Name
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_snapshots_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/snapshots'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::SnapshotCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the source control configuration of an app.
    #
    # Gets the source control configuration of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteSourceControl] operation results.
    #
    def get_source_control(resource_group_name, name, custom_headers = nil)
      response = get_source_control_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the source control configuration of an app.
    #
    # Gets the source control configuration of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_source_control_with_http_info(resource_group_name, name, custom_headers = nil)
      get_source_control_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Gets the source control configuration of an app.
    #
    # Gets the source control configuration of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_source_control_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/sourcecontrols/web'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::SiteSourceControl.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Updates the source control configuration of an app.
    #
    # Updates the source control configuration of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param site_source_control [SiteSourceControl] JSON representation of a
    # SiteSourceControl object. See example.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteSourceControl] operation results.
    #
    def create_or_update_source_control(resource_group_name, name, site_source_control, custom_headers = nil)
      response = create_or_update_source_control_async(resource_group_name, name, site_source_control, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param site_source_control [SiteSourceControl] JSON representation of a
    # SiteSourceControl object. See example.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def create_or_update_source_control_async(resource_group_name, name, site_source_control, custom_headers = nil)
      # Send request
      promise = begin_create_or_update_source_control_async(resource_group_name, name, site_source_control, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Azure::ARM::Web::Models::SiteSourceControl.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response)
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Deletes the source control configuration of an app.
    #
    # Deletes the source control configuration of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def delete_source_control(resource_group_name, name, custom_headers = nil)
      response = delete_source_control_async(resource_group_name, name, custom_headers).value!
      nil
    end

    #
    # Deletes the source control configuration of an app.
    #
    # Deletes the source control configuration of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_source_control_with_http_info(resource_group_name, name, custom_headers = nil)
      delete_source_control_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Deletes the source control configuration of an app.
    #
    # Deletes the source control configuration of an app.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_source_control_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/sourcecontrols/web'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202 || status_code == 404
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Starts an app (or deployment slot, if specified).
    #
    # Starts an app (or deployment slot, if specified).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def start(resource_group_name, name, custom_headers = nil)
      response = start_async(resource_group_name, name, custom_headers).value!
      nil
    end

    #
    # Starts an app (or deployment slot, if specified).
    #
    # Starts an app (or deployment slot, if specified).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def start_with_http_info(resource_group_name, name, custom_headers = nil)
      start_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Starts an app (or deployment slot, if specified).
    #
    # Starts an app (or deployment slot, if specified).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def start_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/start'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Stops an app (or deployment slot, if specified).
    #
    # Stops an app (or deployment slot, if specified).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def stop(resource_group_name, name, custom_headers = nil)
      response = stop_async(resource_group_name, name, custom_headers).value!
      nil
    end

    #
    # Stops an app (or deployment slot, if specified).
    #
    # Stops an app (or deployment slot, if specified).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def stop_with_http_info(resource_group_name, name, custom_headers = nil)
      stop_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Stops an app (or deployment slot, if specified).
    #
    # Stops an app (or deployment slot, if specified).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def stop_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/stop'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Sync web app repository.
    #
    # Sync web app repository.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def sync_repository(resource_group_name, name, custom_headers = nil)
      response = sync_repository_async(resource_group_name, name, custom_headers).value!
      nil
    end

    #
    # Sync web app repository.
    #
    # Sync web app repository.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def sync_repository_with_http_info(resource_group_name, name, custom_headers = nil)
      sync_repository_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Sync web app repository.
    #
    # Sync web app repository.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of web app
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def sync_repository_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/sync'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 204
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Syncs function trigger metadata to the scale controller
    #
    # Syncs function trigger metadata to the scale controller
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def sync_function_triggers(resource_group_name, name, custom_headers = nil)
      response = sync_function_triggers_async(resource_group_name, name, custom_headers).value!
      nil
    end

    #
    # Syncs function trigger metadata to the scale controller
    #
    # Syncs function trigger metadata to the scale controller
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def sync_function_triggers_with_http_info(resource_group_name, name, custom_headers = nil)
      sync_function_triggers_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Syncs function trigger metadata to the scale controller
    #
    # Syncs function trigger metadata to the scale controller
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def sync_function_triggers_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/syncfunctiontriggers'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 204
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Gets the quota usage information of an app (or deployment slot, if
    # specified).
    #
    # Gets the quota usage information of an app (or deployment slot, if
    # specified).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param filter [String] Return only information specified in the filter (using
    # OData syntax). For example: $filter=(name.value eq 'Metric1' or name.value eq
    # 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and endTime eq
    # '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<CsmUsageQuota>] operation results.
    #
    def list_usages(resource_group_name, name, filter = nil, custom_headers = nil)
      first_page = list_usages_as_lazy(resource_group_name, name, filter, custom_headers)
      first_page.get_all_items
    end

    #
    # Gets the quota usage information of an app (or deployment slot, if
    # specified).
    #
    # Gets the quota usage information of an app (or deployment slot, if
    # specified).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param filter [String] Return only information specified in the filter (using
    # OData syntax). For example: $filter=(name.value eq 'Metric1' or name.value eq
    # 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and endTime eq
    # '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_usages_with_http_info(resource_group_name, name, filter = nil, custom_headers = nil)
      list_usages_async(resource_group_name, name, filter, custom_headers).value!
    end

    #
    # Gets the quota usage information of an app (or deployment slot, if
    # specified).
    #
    # Gets the quota usage information of an app (or deployment slot, if
    # specified).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param filter [String] Return only information specified in the filter (using
    # OData syntax). For example: $filter=(name.value eq 'Metric1' or name.value eq
    # 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and endTime eq
    # '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_usages_async(resource_group_name, name, filter = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/usages'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          skip_encoding_query_params: {'$filter' => filter},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::CsmUsageQuotaCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the virtual networks the app (or deployment slot) is connected to.
    #
    # Gets the virtual networks the app (or deployment slot) is connected to.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array] operation results.
    #
    def list_vnet_connections(resource_group_name, name, custom_headers = nil)
      response = list_vnet_connections_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the virtual networks the app (or deployment slot) is connected to.
    #
    # Gets the virtual networks the app (or deployment slot) is connected to.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_vnet_connections_with_http_info(resource_group_name, name, custom_headers = nil)
      list_vnet_connections_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Gets the virtual networks the app (or deployment slot) is connected to.
    #
    # Gets the virtual networks the app (or deployment slot) is connected to.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_vnet_connections_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = {
              required: false,
              serialized_name: 'parsed_response',
              type: {
                name: 'Sequence',
                element: {
                    required: false,
                    serialized_name: 'VnetInfoElementType',
                    type: {
                      name: 'Composite',
                      class_name: 'VnetInfo'
                    }
                }
              }
            }
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets a virtual network the app (or deployment slot) is connected to by name.
    #
    # Gets a virtual network the app (or deployment slot) is connected to by name.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param vnet_name [String] Name of the virtual network.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VnetInfo] operation results.
    #
    def get_vnet_connection(resource_group_name, name, vnet_name, custom_headers = nil)
      response = get_vnet_connection_async(resource_group_name, name, vnet_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets a virtual network the app (or deployment slot) is connected to by name.
    #
    # Gets a virtual network the app (or deployment slot) is connected to by name.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param vnet_name [String] Name of the virtual network.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_vnet_connection_with_http_info(resource_group_name, name, vnet_name, custom_headers = nil)
      get_vnet_connection_async(resource_group_name, name, vnet_name, custom_headers).value!
    end

    #
    # Gets a virtual network the app (or deployment slot) is connected to by name.
    #
    # Gets a virtual network the app (or deployment slot) is connected to by name.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param vnet_name [String] Name of the virtual network.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_vnet_connection_async(resource_group_name, name, vnet_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'vnet_name is nil' if vnet_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections/{vnetName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'vnetName' => vnet_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::VnetInfo.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Adds a Virtual Network connection to an app or slot (PUT) or updates the
    # connection properties (PATCH).
    #
    # Adds a Virtual Network connection to an app or slot (PUT) or updates the
    # connection properties (PATCH).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param vnet_name [String] Name of an existing Virtual Network.
    # @param connection_envelope [VnetInfo] Properties of the Virtual Network
    # connection. See example.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VnetInfo] operation results.
    #
    def create_or_update_vnet_connection(resource_group_name, name, vnet_name, connection_envelope, custom_headers = nil)
      response = create_or_update_vnet_connection_async(resource_group_name, name, vnet_name, connection_envelope, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Adds a Virtual Network connection to an app or slot (PUT) or updates the
    # connection properties (PATCH).
    #
    # Adds a Virtual Network connection to an app or slot (PUT) or updates the
    # connection properties (PATCH).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param vnet_name [String] Name of an existing Virtual Network.
    # @param connection_envelope [VnetInfo] Properties of the Virtual Network
    # connection. See example.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def create_or_update_vnet_connection_with_http_info(resource_group_name, name, vnet_name, connection_envelope, custom_headers = nil)
      create_or_update_vnet_connection_async(resource_group_name, name, vnet_name, connection_envelope, custom_headers).value!
    end

    #
    # Adds a Virtual Network connection to an app or slot (PUT) or updates the
    # connection properties (PATCH).
    #
    # Adds a Virtual Network connection to an app or slot (PUT) or updates the
    # connection properties (PATCH).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param vnet_name [String] Name of an existing Virtual Network.
    # @param connection_envelope [VnetInfo] Properties of the Virtual Network
    # connection. See example.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def create_or_update_vnet_connection_async(resource_group_name, name, vnet_name, connection_envelope, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'vnet_name is nil' if vnet_name.nil?
      fail ArgumentError, 'connection_envelope is nil' if connection_envelope.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::Web::Models::VnetInfo.mapper()
      request_content = @client.serialize(request_mapper,  connection_envelope)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections/{vnetName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'vnetName' => vnet_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::VnetInfo.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Deletes a connection from an app (or deployment slot to a named virtual
    # network.
    #
    # Deletes a connection from an app (or deployment slot to a named virtual
    # network.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param vnet_name [String] Name of the virtual network.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def delete_vnet_connection(resource_group_name, name, vnet_name, custom_headers = nil)
      response = delete_vnet_connection_async(resource_group_name, name, vnet_name, custom_headers).value!
      nil
    end

    #
    # Deletes a connection from an app (or deployment slot to a named virtual
    # network.
    #
    # Deletes a connection from an app (or deployment slot to a named virtual
    # network.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param vnet_name [String] Name of the virtual network.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_vnet_connection_with_http_info(resource_group_name, name, vnet_name, custom_headers = nil)
      delete_vnet_connection_async(resource_group_name, name, vnet_name, custom_headers).value!
    end

    #
    # Deletes a connection from an app (or deployment slot to a named virtual
    # network.
    #
    # Deletes a connection from an app (or deployment slot to a named virtual
    # network.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param vnet_name [String] Name of the virtual network.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_vnet_connection_async(resource_group_name, name, vnet_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'vnet_name is nil' if vnet_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections/{vnetName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'vnetName' => vnet_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 404
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Adds a Virtual Network connection to an app or slot (PUT) or updates the
    # connection properties (PATCH).
    #
    # Adds a Virtual Network connection to an app or slot (PUT) or updates the
    # connection properties (PATCH).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param vnet_name [String] Name of an existing Virtual Network.
    # @param connection_envelope [VnetInfo] Properties of the Virtual Network
    # connection. See example.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VnetInfo] operation results.
    #
    def update_vnet_connection(resource_group_name, name, vnet_name, connection_envelope, custom_headers = nil)
      response = update_vnet_connection_async(resource_group_name, name, vnet_name, connection_envelope, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Adds a Virtual Network connection to an app or slot (PUT) or updates the
    # connection properties (PATCH).
    #
    # Adds a Virtual Network connection to an app or slot (PUT) or updates the
    # connection properties (PATCH).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param vnet_name [String] Name of an existing Virtual Network.
    # @param connection_envelope [VnetInfo] Properties of the Virtual Network
    # connection. See example.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_vnet_connection_with_http_info(resource_group_name, name, vnet_name, connection_envelope, custom_headers = nil)
      update_vnet_connection_async(resource_group_name, name, vnet_name, connection_envelope, custom_headers).value!
    end

    #
    # Adds a Virtual Network connection to an app or slot (PUT) or updates the
    # connection properties (PATCH).
    #
    # Adds a Virtual Network connection to an app or slot (PUT) or updates the
    # connection properties (PATCH).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param vnet_name [String] Name of an existing Virtual Network.
    # @param connection_envelope [VnetInfo] Properties of the Virtual Network
    # connection. See example.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_vnet_connection_async(resource_group_name, name, vnet_name, connection_envelope, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'vnet_name is nil' if vnet_name.nil?
      fail ArgumentError, 'connection_envelope is nil' if connection_envelope.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::Web::Models::VnetInfo.mapper()
      request_content = @client.serialize(request_mapper,  connection_envelope)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections/{vnetName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'vnetName' => vnet_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:patch, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::VnetInfo.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets an app's Virtual Network gateway.
    #
    # Gets an app's Virtual Network gateway.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param vnet_name [String] Name of the Virtual Network.
    # @param gateway_name [String] Name of the gateway. Currently, the only
    # supported string is "primary".
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VnetGateway] operation results.
    #
    def get_vnet_connection_gateway(resource_group_name, name, vnet_name, gateway_name, custom_headers = nil)
      response = get_vnet_connection_gateway_async(resource_group_name, name, vnet_name, gateway_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets an app's Virtual Network gateway.
    #
    # Gets an app's Virtual Network gateway.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param vnet_name [String] Name of the Virtual Network.
    # @param gateway_name [String] Name of the gateway. Currently, the only
    # supported string is "primary".
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_vnet_connection_gateway_with_http_info(resource_group_name, name, vnet_name, gateway_name, custom_headers = nil)
      get_vnet_connection_gateway_async(resource_group_name, name, vnet_name, gateway_name, custom_headers).value!
    end

    #
    # Gets an app's Virtual Network gateway.
    #
    # Gets an app's Virtual Network gateway.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param vnet_name [String] Name of the Virtual Network.
    # @param gateway_name [String] Name of the gateway. Currently, the only
    # supported string is "primary".
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_vnet_connection_gateway_async(resource_group_name, name, vnet_name, gateway_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'vnet_name is nil' if vnet_name.nil?
      fail ArgumentError, 'gateway_name is nil' if gateway_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections/{vnetName}/gateways/{gatewayName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'vnetName' => vnet_name,'gatewayName' => gateway_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 404
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::VnetGateway.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Adds a gateway to a connected Virtual Network (PUT) or updates it (PATCH).
    #
    # Adds a gateway to a connected Virtual Network (PUT) or updates it (PATCH).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param vnet_name [String] Name of the Virtual Network.
    # @param gateway_name [String] Name of the gateway. Currently, the only
    # supported string is "primary".
    # @param connection_envelope [VnetGateway] The properties to update this
    # gateway with.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VnetGateway] operation results.
    #
    def create_or_update_vnet_connection_gateway(resource_group_name, name, vnet_name, gateway_name, connection_envelope, custom_headers = nil)
      response = create_or_update_vnet_connection_gateway_async(resource_group_name, name, vnet_name, gateway_name, connection_envelope, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Adds a gateway to a connected Virtual Network (PUT) or updates it (PATCH).
    #
    # Adds a gateway to a connected Virtual Network (PUT) or updates it (PATCH).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the app.
    # @param vnet_name [String] Name of the Virtual Network.
    # @param gateway_name [String] Name of the gateway. Currently, the 