#version 330
in vec3 Normalv;
in vec3 nor;

uniform vec4 Color;
uniform vec3 lightPos;
uniform float lintrans = 1.0;
uniform bool lighting = true;

out vec4 fragColor;

vec3 blinnPhongDirectional( vec3 n , vec3 kd) {
  vec3 ambient = kd * 0.5;//Light.La * Material.Ka;
  vec3 intensity = vec3(0.8, 0.8, 0.8);
  vec3 s = normalize(lightPos);// directional light
  float sDotN = abs(dot(s, n));
  vec3 diffuse = kd * sDotN;
  vec3 spec = vec3(0.0);
  float Shininess = 48.0;
  if (sDotN > 0.0) {
    spec = vec3(1,1,1) * pow(max(dot(s,n), 0.0), Shininess);
  }
  return ambient + intensity * (diffuse + spec);
}

void main( void ){
   //fragColor = vec4(Normal.rgb, lintrans);
   //fragColor = vec4(nor.rgb, lintrans);
   if (lighting){
       fragColor = vec4(blinnPhongDirectional(Normalv, Color.rgb), lintrans);
   }else {
       fragColor = vec4(Color.rgb, lintrans);
   }
}
