os = require('os')
test_run = require('test_run').new()

os.setenv('location', 'Hell_Hotel')
os.getenv('location')
os.setenv('location', nil)

do os.getenv('location') end

env_dict = os.environ()
type(env_dict)
err = nil
test_run:cmd("setopt delimiter ';'")
do
    for k, v in pairs(env_dict) do
        if type(k) ~= 'string' or type(v) ~= 'string' then
            err = {k, v}
            break
        end
    end
end
test_run:cmd("setopt delimiter ''");
err

--
-- gh-4733: os.setenv() should affect os.environ
--
size = 0
for _, __ in pairs(os.environ()) do size = size + 1 end
for i = 1, size do os.setenv('gh-4733-test-var'..i, tostring(i)) end
env = os.environ()
err = nil
for i = 1, size do                                                  \
    local value = env['gh-4733-test-var'..i]                        \
    if value ~= tostring(i) then                                    \
        err = {i, value}                                            \
        break                                                       \
    end                                                             \
end
err
