/*
 * stream-engine.c - proxy for telepathy-stream-engine's D-Bus API
 *
 * Copyright (C) 2007-2008 Collabora Ltd. <http://www.collabora.co.uk/>
 * Copyright (C) 2007-2008 Nokia Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "extensions/stream-engine.h"

#include <telepathy-glib/proxy-subclass.h>

#include "extensions/extensions.h"

#include "extensions/_gen/cli-stream-engine-body.h"

G_DEFINE_TYPE (TIStreamEngine,
    ti_stream_engine,
    TP_TYPE_PROXY);

static void
ti_stream_engine_init (TIStreamEngine *self)
{
}

static void
ti_stream_engine_constructed (GObject *object)
{
  void (*chain_up) (GObject *) =
    G_OBJECT_CLASS (ti_stream_engine_parent_class)->constructed;
  TIStreamEngine *self = TI_STREAM_ENGINE (object);

  if (chain_up != NULL)
    chain_up (object);

  tp_proxy_add_interface_by_id ((TpProxy *) self,
      TI_IFACE_QUARK_CHANNEL_HANDLER);
}

static void
ti_stream_engine_class_init (TIStreamEngineClass *klass)
{
  GType tp_type = TI_TYPE_STREAM_ENGINE;
  TpProxyClass *proxy_class = (TpProxyClass *) klass;
  GObjectClass *object_class = (GObjectClass *) klass;

  object_class->constructed = ti_stream_engine_constructed;

  proxy_class->must_have_unique_name = FALSE;
  proxy_class->interface = TI_IFACE_QUARK_STREAM_ENGINE;
  tp_proxy_or_subclass_hook_on_interface_add (tp_type,
      ti_cli_stream_engine_add_signals);
  tp_proxy_subclass_add_error_mapping (tp_type,
      TP_ERROR_PREFIX, TP_ERRORS, TP_TYPE_ERROR);
}

TIStreamEngine *
ti_stream_engine_new (TpDBusDaemon *dbus)
{
  return TI_STREAM_ENGINE (g_object_new (TI_TYPE_STREAM_ENGINE,
        "dbus-daemon", dbus,
        "bus-name", TI_STREAM_ENGINE_BUS_NAME,
        "object-path", TI_STREAM_ENGINE_OBJECT_PATH,
        NULL));
}
