# Avast Threat Labs C++ Utilities

A general C++ utility library used by various Avast Threat Labs projects.

The library contains several independently usable modules to facilitate work with addresses, containers, strings, time, etc.

## Usage Example

To use the library, include a desired module's header from the `include` directory, call its functions, and tell CMake to link the library to your project.

The following example checks if one string contains another string regardless of the used case:
```cpp
#include <iostream>
#include "tl-cpputils/string.h"

int main() {
    std::string str = "hello world";
    std::string subStr = "WORLD";
    if (tl_cpputils::containsCaseInsensitive(str, subStr)) {
        std::cout << str << " contains " << subStr << "\n";
    } else {
        std::cout << str << " does not contain " << subStr << "\n";
    }

    return 0;
}
```

For more usage examples of `tl-cpputils` library, see the implementation of unit tests in `tests/tl-cpputils`.

## Requirements

* A compiler supporting C++14
  * On Windows, only Microsoft Visual C++ is supported (version >= Visual Studio 2015).
* CMake (version >= 3.6)

## Build and Installation

* Recursively clone the repository (it contains submodules):
  * `git clone --recursive https://github.com/avast-tl/tl-cpputils`
* Linux:
  * `cd tl-cpputils`
  * `mkdir build && cd build`
  * `cmake .. -DCMAKE_INSTALL_PREFIX=<path>`
  * `make && make install`
* Windows:
  * Open MSBuild command prompt, or any terminal that is configured to run the `msbuild` command.
  * `cd tl-cpputils`
  * `mkdir build && cd build`
  * `cmake .. -DCMAKE_INSTALL_PREFIX=<path> -G<generator>`
  * `msbuild /m /p:Configuration=Release tl-cpputils.sln`
  * `msbuild /m /p:Configuration=Release INSTALL.vcxproj`
  * Alternatively, you can open `tl-cpputils.sln` generated by `cmake` in Visual Studio IDE.

You must pass the following parameters to `cmake`:
* `-DCMAKE_INSTALL_PREFIX=<path>` to set the installation path to `<path>`.
* (Windows only) `-G<generator>` is `-G"Visual Studio 14 2015"` for 32-bit build using Visual Studio 2015, or `-G"Visual Studio 14 2015 Win64"` for 64-bit build using Visual Studio 2015. Later versions of Visual Studio may be used.

You can pass the following additional parameters to `cmake`:
* `-DTL_CPPUTILS_DOC=ON` to build with API documentation (requires Doxygen and Graphviz, disabled by default).
* `-DTL_CPPUTILS_TESTS=ON` to build with tests (disabled by default).
* `-DCMAKE_BUILD_TYPE=Debug` to build with debugging information, which is useful during development. By default, the project is built in the `Release` mode. This has no effect on Windows, but the same thing can be achieved by running `msbuild` with the `/p:Configuration=Debug` parameter.

## Library Use

### Adding `tl-cpputils` to your project via git submodule

A single target named `tl-cpputils` is exposed. It can be used as follows:
```cmake
target_link_libraries(project-that-needs-tl-cpputils tl-cpputils)
```

### Using `tl-cpputils` via CMake `find_package` command

Not supported at the moment.

## API Documentation

You can generate the API documentation by yourself. Pass `-DTL_CPPUTILS_DOC=ON` to `cmake` and run `make doc`.

## License

Copyright (c) 2017 Avast Software, licensed under the MIT license. See the `LICENSE` file for more details.

`tl-cpputils` uses third-party libraries or other resources listed, along with their licenses, in the `LICENSE-THIRD-PARTY` file.

## Contributing

See [RetDec contribution guidelines](https://github.com/avast-tl/retdec/wiki/Contribution-Guidelines).
